/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.modules;

import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.jscomp.jarjar.com.google.auto.value.AutoValue;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableMultiset;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.jscomp.modules.AutoValue_ModuleMetadataMap_ModuleMetadata;
import com.google.javascript.rhino.Node;
import java.util.Map;

public final class ModuleMetadataMap {
    private final ImmutableMap<String, ModuleMetadata> modulesByPath;
    private final ImmutableMap<String, ModuleMetadata> modulesByGoogNamespace;
    private final ImmutableSet<ModuleMetadata> moduleMetadata;

    public ModuleMetadataMap(Map<String, ModuleMetadata> modulesByPath, Map<String, ModuleMetadata> modulesByGoogNamespace) {
        this.modulesByPath = ImmutableMap.copyOf(modulesByPath);
        this.modulesByGoogNamespace = ImmutableMap.copyOf(modulesByGoogNamespace);
        this.moduleMetadata = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(modulesByPath.values())).addAll(modulesByGoogNamespace.values())).build();
    }

    public ImmutableMap<String, ModuleMetadata> getModulesByPath() {
        return this.modulesByPath;
    }

    public ImmutableMap<String, ModuleMetadata> getModulesByGoogNamespace() {
        return this.modulesByGoogNamespace;
    }

    public ImmutableSet<ModuleMetadata> getAllModuleMetadata() {
        return this.moduleMetadata;
    }

    public static ModuleMetadataMap emptyForTesting() {
        return new ModuleMetadataMap(ImmutableMap.of(), ImmutableMap.of());
    }

    @AutoValue
    public static abstract class ModuleMetadata {
        public abstract ModuleType moduleType();

        public boolean isEs6Module() {
            return this.moduleType() == ModuleType.ES6_MODULE;
        }

        public boolean isGoogModule() {
            return this.isNonLegacyGoogModule() || this.isLegacyGoogModule();
        }

        public boolean isNonLegacyGoogModule() {
            return this.moduleType() == ModuleType.GOOG_MODULE;
        }

        public boolean isLegacyGoogModule() {
            return this.moduleType() == ModuleType.LEGACY_GOOG_MODULE;
        }

        public boolean isGoogProvide() {
            return this.moduleType() == ModuleType.GOOG_PROVIDE;
        }

        public boolean isCommonJs() {
            return this.moduleType() == ModuleType.COMMON_JS;
        }

        public boolean isNonProvideScript() {
            return this.moduleType() == ModuleType.SCRIPT;
        }

        public boolean isModule() {
            switch (this.moduleType()) {
                case GOOG_PROVIDE: 
                case SCRIPT: {
                    return false;
                }
                case COMMON_JS: 
                case ES6_MODULE: 
                case GOOG_MODULE: 
                case LEGACY_GOOG_MODULE: {
                    return true;
                }
            }
            throw new AssertionError((Object)this.moduleType());
        }

        @Nullable
        public abstract Node rootNode();

        public abstract boolean usesClosure();

        public abstract boolean isTestOnly();

        public abstract ImmutableMultiset<String> googNamespaces();

        public abstract ImmutableMultiset<String> stronglyRequiredGoogNamespaces();

        public abstract ImmutableMultiset<String> weaklyRequiredGoogNamespaces();

        public abstract ImmutableMultiset<String> es6ImportSpecifiers();

        public abstract ImmutableList<ModuleMetadata> nestedModules();

        @Nullable
        public abstract ModuleLoader.ModulePath path();

        public static Builder builder() {
            return new AutoValue_ModuleMetadataMap_ModuleMetadata.Builder();
        }

        public final boolean equals(Object other) {
            return super.equals(other);
        }

        public final int hashCode() {
            return super.hashCode();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract ModuleMetadata build();

            public abstract ImmutableMultiset.Builder<String> googNamespacesBuilder();

            public Builder addGoogNamespace(String namespace) {
                this.googNamespacesBuilder().add((Object)namespace);
                return this;
            }

            public abstract ImmutableMultiset.Builder<String> stronglyRequiredGoogNamespacesBuilder();

            public abstract ImmutableMultiset.Builder<String> weaklyRequiredGoogNamespacesBuilder();

            public abstract ImmutableMultiset.Builder<String> es6ImportSpecifiersBuilder();

            public abstract ImmutableList.Builder<ModuleMetadata> nestedModulesBuilder();

            public abstract Builder path(@Nullable ModuleLoader.ModulePath var1);

            public abstract Builder usesClosure(boolean var1);

            public abstract Builder isTestOnly(boolean var1);

            public abstract ModuleType moduleType();

            public abstract Builder moduleType(ModuleType var1);

            public abstract Builder rootNode(@Nullable Node var1);
        }
    }

    public static enum ModuleType {
        ES6_MODULE("an ES6 module"),
        GOOG_MODULE("a goog.module"),
        LEGACY_GOOG_MODULE("a goog.module"),
        COMMON_JS("a CommonJS module"),
        GOOG_PROVIDE("a script file that contains at least one goog.provide"),
        SCRIPT("a script file that does not contain a goog.provide");

        public final String description;

        private ModuleType(String description) {
            this.description = description;
        }
    }
}

