/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.modules;

import com.google.javascript.jscomp.jarjar.com.google.auto.value.AutoValue;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.jscomp.modules.AutoValue_Binding;
import com.google.javascript.jscomp.modules.Export;
import com.google.javascript.jscomp.modules.ModuleMetadataMap;
import com.google.javascript.rhino.Node;

@AutoValue
public abstract class Binding {
    Binding() {
    }

    static Binding from(Export boundExport, Node sourceNode) {
        return new AutoValue_Binding(boundExport.moduleMetadata(), sourceNode, boundExport, false, boundExport.closureNamespace(), CreatedBy.EXPORT);
    }

    static Binding from(ModuleMetadataMap.ModuleMetadata metadata, Node sourceNode, String closureNamespace, CreatedBy createdBy) {
        Preconditions.checkArgument(createdBy.isClosureImport(), "Expected goog.require(Type) or goog.forwardDeclare, got %s", (Object)createdBy);
        return new AutoValue_Binding(metadata, sourceNode, null, true, closureNamespace, createdBy);
    }

    static Binding from(ModuleMetadataMap.ModuleMetadata metadataOfBoundModule, @Nullable String closureNamespace, Node sourceNode) {
        return new AutoValue_Binding(metadataOfBoundModule, sourceNode, null, true, closureNamespace, CreatedBy.IMPORT);
    }

    Binding copy(Node sourceNode, CreatedBy createdBy) {
        Preconditions.checkNotNull(sourceNode);
        return new AutoValue_Binding(this.metadata(), sourceNode, this.originatingExport(), this.isModuleNamespace(), this.closureNamespace(), createdBy);
    }

    public abstract ModuleMetadataMap.ModuleMetadata metadata();

    @Nullable
    public abstract Node sourceNode();

    @Nullable
    public abstract Export originatingExport();

    public abstract boolean isModuleNamespace();

    @Nullable
    public abstract String closureNamespace();

    public abstract CreatedBy createdBy();

    public final String boundName() {
        Preconditions.checkState(!this.isModuleNamespace());
        return this.originatingExport().localName();
    }

    public final boolean isMutated() {
        return !this.isModuleNamespace() && this.originatingExport().mutated();
    }

    public final boolean isCreatedByEsImport() {
        return this.createdBy().equals((Object)CreatedBy.IMPORT);
    }

    public final boolean isCreatedByEsExport() {
        return this.createdBy().equals((Object)CreatedBy.EXPORT);
    }

    public final boolean isSomeImport() {
        return !this.createdBy().equals((Object)CreatedBy.EXPORT);
    }

    static enum CreatedBy {
        EXPORT,
        IMPORT,
        GOOG_REQUIRE,
        GOOG_REQUIRE_TYPE,
        GOOG_FORWARD_DECLARE;


        boolean isClosureImport() {
            return this.equals((Object)GOOG_REQUIRE) || this.equals((Object)GOOG_REQUIRE_TYPE) || this.equals((Object)GOOG_FORWARD_DECLARE);
        }
    }
}

