/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.disambiguate;

import com.google.javascript.jscomp.colors.Color;
import com.google.javascript.jscomp.colors.PrimitiveColor;
import com.google.javascript.jscomp.colors.UnionColor;
import com.google.javascript.jscomp.disambiguate.ColorGraphNode;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import java.util.LinkedHashMap;

final class ColorGraphNodeFactory {
    private final LinkedHashMap<Color, ColorGraphNode> typeIndex;

    private ColorGraphNodeFactory(LinkedHashMap<Color, ColorGraphNode> initialTypeIndex) {
        this.typeIndex = initialTypeIndex;
    }

    static ColorGraphNodeFactory createFactory() {
        LinkedHashMap<Color, ColorGraphNode> typeIndex = new LinkedHashMap<Color, ColorGraphNode>();
        ColorGraphNode unknownColorNode = ColorGraphNode.create(PrimitiveColor.UNKNOWN, 0);
        typeIndex.put(PrimitiveColor.UNKNOWN, unknownColorNode);
        return new ColorGraphNodeFactory(typeIndex);
    }

    public ColorGraphNode createNode(@Nullable Color color) {
        Color key = this.simplifyColor(color);
        return this.typeIndex.computeIfAbsent(key, this::newColorGraphNode);
    }

    public ImmutableSet<ColorGraphNode> getAllKnownTypes() {
        return ImmutableSet.copyOf(this.typeIndex.values());
    }

    private ColorGraphNode newColorGraphNode(Color key) {
        int id = this.typeIndex.size();
        return ColorGraphNode.create(key, id);
    }

    private Color simplifyColor(@Nullable Color type) {
        if (type == null) {
            return PrimitiveColor.UNKNOWN;
        }
        if (type.isPrimitive()) {
            return PrimitiveColor.UNKNOWN;
        }
        if (type.isUnion()) {
            return this.simplifyUnion((UnionColor)type);
        }
        return type;
    }

    private Color simplifyUnion(UnionColor union) {
        ImmutableSet<Color> colors = union.getAlternates().stream().filter(c -> !c.equals(PrimitiveColor.NULL_OR_VOID)).map(this::simplifyColor).collect(ImmutableSet.toImmutableSet());
        switch (colors.size()) {
            case 0: {
                throw new AssertionError();
            }
            case 1: {
                return (Color)colors.iterator().next();
            }
        }
        return UnionColor.create(colors);
    }
}

