/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.disambiguate;

import com.google.javascript.jscomp.disambiguate.FlatType;
import com.google.javascript.jscomp.disambiguate.PropertyClustering;
import com.google.javascript.jscomp.graph.FixedPointGraphTraversal;

final class ClusterPropagator
implements FixedPointGraphTraversal.EdgeCallback<FlatType, Object> {
    ClusterPropagator() {
    }

    @Override
    public boolean traverseEdge(FlatType src, Object unused, FlatType dest) {
        int startDestPropCount = dest.getAssociatedProps().size();
        ClusterPropagator.invalidatePropertiesIfInvalidating(src);
        for (PropertyClustering prop : src.getAssociatedProps()) {
            if (prop.isInvalidated()) continue;
            dest.getAssociatedProps().add(prop);
            prop.getClusters().union(src, dest);
        }
        ClusterPropagator.invalidatePropertiesIfInvalidating(dest);
        return startDestPropCount < dest.getAssociatedProps().size();
    }

    private static void invalidatePropertiesIfInvalidating(FlatType flat) {
        if (flat.isInvalidating()) {
            flat.getAssociatedProps().forEach(PropertyClustering::invalidate);
            flat.getAssociatedProps().clear();
        }
    }
}

