/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.JsAst;
import com.google.javascript.jscomp.SourceAst;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.Node;

public class RecoverableJsAst
implements SourceAst {
    private static final long serialVersionUID = 1L;
    private Node root = null;
    private final SourceAst realSource;
    private final boolean reportParseErrors;

    public RecoverableJsAst(SourceAst realSource, boolean reportParseErrors) {
        Preconditions.checkNotNull(realSource);
        this.realSource = realSource;
        this.reportParseErrors = reportParseErrors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Node getAstRoot(AbstractCompiler compiler) {
        if (this.root == null) {
            SourceAst sourceAst = this.realSource;
            synchronized (sourceAst) {
                this.root = this.realSource.getAstRoot(compiler).cloneTree(true);
                JsAst.ParseResult result = (JsAst.ParseResult)this.root.getProp(Node.PARSE_RESULTS);
                if (this.reportParseErrors && result != null) {
                    this.replay(compiler, result);
                }
            }
        }
        return Preconditions.checkNotNull(this.root);
    }

    private void replay(AbstractCompiler compiler, JsAst.ParseResult result) {
        ErrorReporter reporter = compiler.getDefaultErrorReporter();
        for (JsAst.RhinoError error : result.errors) {
            reporter.error(error.message, error.sourceName, error.line, error.lineOffset);
        }
        for (JsAst.RhinoError warning : result.warnings) {
            reporter.warning(warning.message, warning.sourceName, warning.line, warning.lineOffset);
        }
    }

    @Override
    public void clearAst() {
        this.root = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputId getInputId() {
        SourceAst sourceAst = this.realSource;
        synchronized (sourceAst) {
            return this.realSource.getInputId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SourceFile getSourceFile() {
        SourceAst sourceAst = this.realSource;
        synchronized (sourceAst) {
            return this.realSource.getSourceFile();
        }
    }

    @Override
    public void setSourceFile(SourceFile file) {
        throw new UnsupportedOperationException();
    }
}

