/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.GlobalNamespace;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.ModuleImportResolver;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PolymerBehaviorExtractor;
import com.google.javascript.jscomp.PolymerClassDefinition;
import com.google.javascript.jscomp.PolymerClassRewriter;
import com.google.javascript.jscomp.PolymerExportPolicy;
import com.google.javascript.jscomp.PolymerPassErrors;
import com.google.javascript.jscomp.PolymerPassFindExterns;
import com.google.javascript.jscomp.PolymerPassStaticUtils;
import com.google.javascript.jscomp.PolymerPassSuppressBehaviors;
import com.google.javascript.jscomp.TagNameToType;
import com.google.javascript.jscomp.jarjar.com.google.common.base.MoreObjects;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.modules.ModuleMetadataMap;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.HashSet;
import java.util.Set;

final class PolymerPass
extends NodeTraversal.ExternsSkippingCallback
implements HotSwapCompilerPass {
    private static final String VIRTUAL_FILE = "<PolymerPass.java>";
    private final AbstractCompiler compiler;
    private final ImmutableMap<String, String> tagNameMap;
    private final int polymerVersion;
    private final PolymerExportPolicy polymerExportPolicy;
    private final boolean propertyRenamingEnabled;
    private Node polymerElementExterns;
    private Node externsInsertionRef = null;
    private final Set<String> nativeExternsAdded;
    private ImmutableList<Node> polymerElementProps;
    private GlobalNamespace globalNames;
    private PolymerBehaviorExtractor behaviorExtractor;
    private boolean warnedPolymer1ExternsMissing = false;
    private boolean propertySinkExternInjected = false;

    PolymerPass(AbstractCompiler compiler, Integer polymerVersion, PolymerExportPolicy polymerExportPolicy, boolean propertyRenamingEnabled) {
        Preconditions.checkArgument(polymerVersion == null || polymerVersion == 1 || polymerVersion == 2, "Invalid Polymer version:", (Object)polymerVersion);
        this.compiler = compiler;
        this.tagNameMap = TagNameToType.getMap();
        this.nativeExternsAdded = new HashSet<String>();
        this.polymerVersion = polymerVersion == null ? 1 : polymerVersion;
        this.polymerExportPolicy = polymerExportPolicy == null ? PolymerExportPolicy.LEGACY : polymerExportPolicy;
        this.propertyRenamingEnabled = propertyRenamingEnabled;
    }

    @Override
    public void process(Node externs, Node root) {
        PolymerPassFindExterns externsCallback = new PolymerPassFindExterns();
        NodeTraversal.traverse(this.compiler, externs, externsCallback);
        this.polymerElementExterns = externsCallback.getPolymerElementExterns();
        this.polymerElementProps = externsCallback.getPolymerElementProps();
        if (this.polymerVersion == 1 && this.polymerElementExterns == null) {
            this.warnedPolymer1ExternsMissing = true;
            this.compiler.report(JSError.make(PolymerPassErrors.POLYMER_MISSING_EXTERNS, new String[0]));
            return;
        }
        if (this.polymerVersion > 1 && this.propertyRenamingEnabled) {
            this.compiler.ensureLibraryInjected("util/reflectobject", false);
        }
        this.globalNames = new GlobalNamespace(this.compiler, externs, root);
        this.behaviorExtractor = new PolymerBehaviorExtractor(this.compiler, this.globalNames, this.compiler.getModuleMetadataMap(), this.compiler.getModuleMap());
        Node externsAndJsRoot = root.getParent();
        this.hotSwapScript(externsAndJsRoot, null);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverse(this.compiler, scriptRoot, this);
        PolymerPassSuppressBehaviors suppressBehaviorsCallback = new PolymerPassSuppressBehaviors(this.compiler);
        NodeTraversal.traverse(this.compiler, scriptRoot, suppressBehaviorsCallback);
    }

    @Override
    public void visit(NodeTraversal traversal, Node node, Node parent) {
        Preconditions.checkNotNull(this.globalNames, "Cannot call visit() before process()");
        if (PolymerPassStaticUtils.isPolymerCall(node)) {
            if (this.polymerElementExterns != null) {
                this.rewritePolymer1ClassDefinition(node, parent, traversal);
            } else if (!this.warnedPolymer1ExternsMissing) {
                this.compiler.report(JSError.make(node, PolymerPassErrors.POLYMER_MISSING_EXTERNS, new String[0]));
                this.warnedPolymer1ExternsMissing = true;
            }
        } else if (PolymerPassStaticUtils.isPolymerClass(node)) {
            this.rewritePolymer2ClassDefinition(node, traversal);
        }
    }

    private ModuleMetadataMap.ModuleMetadata getModuleMetadata(NodeTraversal traversal) {
        Node script = traversal.getCurrentScript();
        if (script != null && script.getFirstChild().isModuleBody()) {
            return ModuleImportResolver.getModuleFromScopeRoot(this.compiler.getModuleMap(), this.compiler, script.getFirstChild()).metadata();
        }
        Node scopeRoot = traversal.getScopeRoot();
        if (NodeUtil.isBundledGoogModuleScopeRoot(scopeRoot)) {
            return ModuleImportResolver.getModuleFromScopeRoot(this.compiler.getModuleMap(), this.compiler, scopeRoot).metadata();
        }
        return null;
    }

    private void rewritePolymer1ClassDefinition(Node node, Node parent, NodeTraversal traversal) {
        PolymerClassDefinition def;
        Node grandparent = parent.getParent();
        if (grandparent.isConst()) {
            grandparent.setToken(Token.LET);
            Node scriptNode = traversal.getCurrentScript();
            if (scriptNode != null) {
                NodeUtil.addFeatureToScript(scriptNode, FeatureSet.Feature.LET_DECLARATIONS, this.compiler);
            }
            traversal.reportCodeChange();
        }
        if (NodeUtil.isNameDeclaration(grandparent) && grandparent.getParent().isExport()) {
            this.normalizePolymerExport(grandparent, grandparent.getParent());
            traversal.reportCodeChange();
        }
        if ((def = PolymerClassDefinition.extractFromCallNode(node, this.compiler, this.getModuleMetadata(traversal), this.behaviorExtractor)) != null) {
            if (def.nativeBaseElement != null) {
                this.appendPolymerElementExterns(def);
            }
            PolymerClassRewriter rewriter = new PolymerClassRewriter(this.compiler, this.getExtensInsertionRef(), this.polymerVersion, this.polymerExportPolicy, this.propertyRenamingEnabled);
            rewriter.rewritePolymerCall(def, traversal);
        }
    }

    private void rewritePolymer2ClassDefinition(Node node, NodeTraversal traversal) {
        PolymerClassDefinition def = PolymerClassDefinition.extractFromClassNode(node, this.compiler, this.globalNames);
        if (def != null) {
            PolymerClassRewriter rewriter = new PolymerClassRewriter(this.compiler, this.getExtensInsertionRef(), this.polymerVersion, this.polymerExportPolicy, this.propertyRenamingEnabled);
            rewriter.propertySinkExternInjected = this.propertySinkExternInjected;
            rewriter.rewritePolymerClassDeclaration(node, traversal, def);
            this.propertySinkExternInjected = rewriter.propertySinkExternInjected;
        }
    }

    private void normalizePolymerExport(Node nameDecl, Node export) {
        Node block = export.getParent();
        Node name = nameDecl.getFirstChild();
        block.addChildBefore(nameDecl.detach(), export);
        Node exportSpec = new Node(Token.EXPORT_SPEC);
        exportSpec.addChildToFront(name.cloneNode());
        exportSpec.addChildToFront(name.cloneNode());
        export.addChildToFront(new Node(Token.EXPORT_SPECS, exportSpec).srcrefTree(export));
    }

    private Node getExtensInsertionRef() {
        if (this.polymerElementExterns != null) {
            return this.polymerElementExterns;
        }
        if (this.externsInsertionRef == null) {
            this.externsInsertionRef = this.compiler.getSynthesizedExternsInputAtEnd().getAstRoot(this.compiler);
        }
        return this.externsInsertionRef;
    }

    private void appendPolymerElementExterns(PolymerClassDefinition def) {
        if (!this.nativeExternsAdded.add(def.nativeBaseElement)) {
            return;
        }
        Node block = IR.block();
        Node baseExterns = this.polymerElementExterns.cloneTree();
        String polymerElementType = PolymerPassStaticUtils.getPolymerElementType(def);
        baseExterns.getFirstChild().setString(polymerElementType);
        String elementType = this.tagNameMap.get(def.nativeBaseElement);
        if (elementType == null) {
            this.compiler.report(JSError.make(def.descriptor, PolymerPassErrors.POLYMER_INVALID_EXTENDS, def.nativeBaseElement));
            return;
        }
        JSTypeExpression elementBaseType = new JSTypeExpression(new Node(Token.BANG, IR.string(elementType).srcrefTree(this.polymerElementExterns)), VIRTUAL_FILE);
        JSDocInfoBuilder baseDocs = JSDocInfoBuilder.copyFrom(baseExterns.getJSDocInfo());
        baseDocs.changeBaseType(elementBaseType);
        baseExterns.setJSDocInfo(baseDocs.build());
        block.addChildToBack(baseExterns);
        for (Node baseProp : this.polymerElementProps) {
            Node newProp = baseProp.cloneTree();
            Node newPropRootName = NodeUtil.getRootOfQualifiedName(newProp.getFirstFirstChild());
            newPropRootName.setString(polymerElementType);
            block.addChildToBack(newProp);
        }
        block.useSourceInfoIfMissingFromForTree(this.polymerElementExterns);
        Node parent = this.polymerElementExterns.getParent();
        Node stmts = block.removeChildren();
        parent.addChildrenAfter(stmts, this.polymerElementExterns);
        this.compiler.reportChangeToEnclosingScope(stmts);
    }

    static class MemberDefinition {
        final JSDocInfo info;
        final Node name;
        final Node value;

        MemberDefinition(JSDocInfo info, Node name, Node value) {
            this.info = info;
            this.name = name;
            this.value = value;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("name", this.name).add("value", this.value).toString();
        }
    }
}

