/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstAnalyzer;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.OptimizeCalls;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ArrayListMultimap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableListMultimap;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.Iterables;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;

class OptimizeParameters
implements CompilerPass,
OptimizeCalls.CallGraphCompilerPass {
    private final AbstractCompiler compiler;
    private final AstAnalyzer astAnalyzer;
    private Scope globalScope;

    OptimizeParameters(AbstractCompiler compiler) {
        this.compiler = Preconditions.checkNotNull(compiler);
        this.astAnalyzer = compiler.getAstAnalyzer();
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkState(this.compiler.getLifeCycleStage() == AbstractCompiler.LifeCycleStage.NORMALIZED);
        OptimizeCalls.builder().setCompiler(this.compiler).setConsiderExterns(false).addPass(this).build().process(externs, root);
    }

    @Override
    public void process(Node externs, Node root, OptimizeCalls.ReferenceMap refMap) {
        ArrayList<Node> refs;
        this.globalScope = refMap.getGlobalScope();
        ArrayList<ArrayList<Node>> toOptimize = new ArrayList<ArrayList<Node>>();
        for (Map.Entry<String, ArrayList<Node>> entry : refMap.getNameReferences()) {
            String string = entry.getKey();
            if (!this.isCandidate(string, refs = entry.getValue())) continue;
            toOptimize.add(refs);
        }
        for (Map.Entry<String, ArrayList<Node>> entry : refMap.getPropReferences()) {
            String string = entry.getKey();
            if (!this.isCandidate(string, refs = entry.getValue())) continue;
            toOptimize.add(refs);
        }
        for (ArrayList arrayList : toOptimize) {
            this.tryEliminateOptionalArgs(arrayList);
        }
        for (ArrayList arrayList : toOptimize) {
            this.tryEliminateConstantArgs(arrayList);
        }
        UnusedParameterOptimizer optimizer = new UnusedParameterOptimizer();
        for (ArrayList arrayList : toOptimize) {
            optimizer.tryEliminateUnusedArgs(arrayList);
        }
        optimizer.applyChanges();
    }

    private static boolean alreadyRemoved(Node n) {
        Node parent = n.getParent();
        while (parent != null) {
            n = parent;
            parent = n.getParent();
        }
        return !n.isRoot();
    }

    private boolean isCandidate(String name, ArrayList<Node> refs) {
        if (!OptimizeCalls.mayBeOptimizableName(this.compiler, name)) {
            return false;
        }
        boolean seenCandidateDefinition = false;
        boolean seenCandidateUse = false;
        for (Node n : refs) {
            if (OptimizeCalls.ReferenceMap.isNormalOrOptionalCallOrNewTarget(n)) {
                seenCandidateUse = true;
                continue;
            }
            if (this.isCandidateDefinition(n)) {
                seenCandidateDefinition = true;
                continue;
            }
            if (OptimizeCalls.isAllowedReference(n)) continue;
            return false;
        }
        return seenCandidateDefinition && seenCandidateUse;
    }

    private boolean isCandidateDefinition(Node n) {
        Node functionExpr;
        Node parent = n.getParent();
        if (parent.isFunction() && NodeUtil.isFunctionDeclaration(parent)) {
            functionExpr = parent;
        } else if (OptimizeCalls.ReferenceMap.isSimpleAssignmentTarget(n)) {
            functionExpr = parent.getLastChild();
        } else if (n.isName() && n.hasChildren()) {
            functionExpr = n.getFirstChild();
        } else if (this.isClassMemberDefinition(n)) {
            functionExpr = n.getFirstChild();
        } else {
            return false;
        }
        return OptimizeParameters.allDefinitionsAreCandidateFunctions(functionExpr);
    }

    private boolean isClassMemberDefinition(Node n) {
        return n.isMemberFunctionDef() && n.getParent().isClassMembers();
    }

    private static boolean allDefinitionsAreCandidateFunctions(Node n) {
        switch (n.getToken()) {
            case FUNCTION: {
                return !NodeUtil.isNamedFunctionExpression(n) && !NodeUtil.doesFunctionReferenceOwnArgumentsObject(n) && !OptimizeParameters.mayReferenceParamBeforeBody(n);
            }
            case CAST: 
            case COMMA: {
                return OptimizeParameters.allDefinitionsAreCandidateFunctions(n.getLastChild());
            }
            case HOOK: {
                return OptimizeParameters.allDefinitionsAreCandidateFunctions(n.getSecondChild()) && OptimizeParameters.allDefinitionsAreCandidateFunctions(n.getLastChild());
            }
            case OR: 
            case AND: 
            case COALESCE: {
                return OptimizeParameters.allDefinitionsAreCandidateFunctions(n.getFirstChild()) && OptimizeParameters.allDefinitionsAreCandidateFunctions(n.getLastChild());
            }
        }
        return false;
    }

    private static boolean mayReferenceParamBeforeBody(Node function) {
        Node paramList = function.getSecondChild();
        if (!paramList.hasChildren()) {
            return false;
        }
        ArrayListMultimap namesByNames = ArrayListMultimap.create();
        NodeUtil.visitPostOrder(paramList, n -> {
            if (n.isName()) {
                namesByNames.put(n.getString(), n);
            }
        });
        for (Collection names : namesByNames.asMap().values()) {
            if (names.size() == 1) continue;
            for (Node name : names) {
                if (!NodeUtil.isLValue(name)) continue;
                return true;
            }
        }
        return false;
    }

    private void tryEliminateOptionalArgs(ArrayList<Node> refs) {
        int maxArgs = -1;
        for (Node n : refs) {
            Node firstArg;
            if (!OptimizeCalls.ReferenceMap.isNormalOrOptionalCallOrNewTarget(n)) continue;
            int numArgs = 0;
            for (Node c = firstArg = OptimizeCalls.ReferenceMap.getFirstArgumentForCallOrNewOrDotCall(n); c != null; c = c.getNext()) {
                ++numArgs;
                if (!c.isSpread()) continue;
                return;
            }
            if (numArgs <= maxArgs) continue;
            maxArgs = numArgs;
        }
        for (Node fn : OptimizeCalls.ReferenceMap.getFunctionNodes(refs).values()) {
            this.eliminateParamsAfter(fn, maxArgs);
        }
    }

    private void tryEliminateConstantArgs(ArrayList<Node> refs) {
        List<Parameter> parameters = this.findFixedArguments(refs);
        if (parameters == null) {
            return;
        }
        ImmutableListMultimap<Node, Node> fns = OptimizeCalls.ReferenceMap.getFunctionNodes(refs);
        if (fns.size() > 1) {
            return;
        }
        Node fn = (Node)Iterables.getOnlyElement(fns.values());
        boolean continueLooking = OptimizeParameters.adjustForConstraints(fn, parameters);
        if (!continueLooking) {
            return;
        }
        for (Node n : refs) {
            if (OptimizeParameters.alreadyRemoved(n) || !OptimizeCalls.ReferenceMap.isNormalOrOptionalCallOrNewTarget(n)) continue;
            this.optimizeCallSite(parameters, n);
        }
        this.optimizeFunctionDefinition(parameters, fn);
    }

    private List<Parameter> findFixedArguments(ArrayList<Node> refs) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        boolean firstCall = true;
        boolean continueLooking = false;
        for (Node n : refs) {
            if (!OptimizeCalls.ReferenceMap.isNormalOrOptionalCallOrNewTarget(n)) continue;
            Node call = n.getParent();
            Node firstDotCallParam = call.getFirstChild();
            if (firstDotCallParam.isSpread()) {
                continueLooking = false;
                break;
            }
            Node cur = OptimizeCalls.ReferenceMap.getFirstArgumentForCallOrNewOrDotCall(n);
            if (firstCall) {
                continueLooking = this.buildInitialParameterList(parameters, cur);
                firstCall = false;
            } else {
                continueLooking = this.findFixedParameters(parameters, cur);
            }
            if (continueLooking) continue;
            break;
        }
        return continueLooking ? parameters : null;
    }

    private static boolean adjustForConstraints(Node fn, List<Parameter> parameters) {
        JSDocInfo info = NodeUtil.getBestJSDocInfo(fn);
        if (info != null && info.isNoInline()) {
            return false;
        }
        Node paramList = NodeUtil.getFunctionParameters(fn);
        Node lastFormal = paramList.getLastChild();
        int restIndex = Integer.MAX_VALUE;
        int lastNonRestFormal = paramList.getChildCount() - 1;
        Node formal = lastFormal;
        if (lastFormal != null && lastFormal.isRest()) {
            restIndex = lastNonRestFormal--;
            formal = formal.getPrevious();
        }
        boolean anyMovable = false;
        boolean seenUnmovableSideEffects = false;
        boolean seenUnmoveableSideEffected = false;
        boolean allRestValueRemovable = true;
        for (int i = parameters.size() - 1; i >= 0; --i) {
            Parameter current = parameters.get(i);
            if (i <= lastNonRestFormal) {
                if (formal.isDefaultValue() && current.mayBeUndefined) {
                    current.shouldRemove = false;
                }
                formal = formal.getPrevious();
            }
            if (current.shouldRemove && (seenUnmovableSideEffects && current.canBeSideEffected() || seenUnmoveableSideEffected && current.hasSideEffects())) {
                current.shouldRemove = false;
            }
            if (i >= restIndex) {
                if (allRestValueRemovable) {
                    if (!current.shouldRemove) {
                        anyMovable = false;
                        allRestValueRemovable = false;
                        for (int j = i + 1; j < parameters.size(); ++j) {
                            Parameter p = parameters.get(0);
                            p.shouldRemove = false;
                            if (p.canBeSideEffected) {
                                seenUnmoveableSideEffected = true;
                            }
                            if (!p.hasSideEffects) continue;
                            seenUnmovableSideEffects = true;
                        }
                    }
                } else {
                    current.shouldRemove = false;
                }
            }
            if (current.shouldRemove) {
                anyMovable = true;
                continue;
            }
            if (current.canBeSideEffected) {
                seenUnmoveableSideEffected = true;
            }
            if (!current.hasSideEffects) continue;
            seenUnmovableSideEffects = true;
        }
        return anyMovable;
    }

    private boolean findFixedParameters(List<Parameter> parameters, Node cur) {
        boolean anyMovable = false;
        int index = 0;
        while (cur != null) {
            Parameter p;
            if (index >= parameters.size()) {
                p = new Parameter(cur, false);
                parameters.add(p);
                this.setParameterSideEffectInfo(p, cur);
            } else {
                p = parameters.get(index);
                if (p.shouldRemove()) {
                    Node value = p.getArg();
                    if (!cur.isEquivalentTo(value)) {
                        p.setShouldRemove(false);
                    } else {
                        anyMovable = true;
                    }
                }
            }
            if (cur.isSpread()) break;
            cur = cur.getNext();
            ++index;
        }
        while (index < parameters.size()) {
            parameters.get(index).setShouldRemove(false);
            ++index;
        }
        return anyMovable;
    }

    private boolean buildInitialParameterList(List<Parameter> parameters, Node cur) {
        boolean anyMovable = false;
        while (cur != null) {
            boolean movable = OptimizeParameters.isMovableValue(cur, this.globalScope);
            Parameter p = new Parameter(cur, movable);
            this.setParameterSideEffectInfo(p, cur);
            parameters.add(p);
            if (movable) {
                anyMovable = true;
            }
            if (cur.isSpread()) break;
            cur = cur.getNext();
        }
        return anyMovable;
    }

    private void setParameterSideEffectInfo(Parameter p, Node value) {
        p.setHasSideEffects(this.astAnalyzer.mayHaveSideEffects(value));
        p.setCanBeSideEffected(NodeUtil.canBeSideEffected(value));
        if (!value.isSpread()) {
            p.setMayBeUndefined(NodeUtil.mayBeUndefined(value));
        }
    }

    private static boolean isMovableValue(Node n, Scope globalScope) {
        switch (n.getToken()) {
            case AWAIT: 
            case YIELD: 
            case THIS: 
            case SUPER: 
            case ITER_SPREAD: 
            case OBJECT_SPREAD: {
                return false;
            }
            case FUNCTION: {
                return false;
            }
            case NAME: {
                if (n.getString().equals("arguments")) {
                    return false;
                }
                Var v = (Var)globalScope.getVar(n.getString());
                if (v != null) break;
                return false;
            }
        }
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            if (OptimizeParameters.isMovableValue(c, globalScope)) continue;
            return false;
        }
        return true;
    }

    private void optimizeFunctionDefinition(List<Parameter> parameters, Node fn) {
        Node paramList = NodeUtil.getFunctionParameters(fn);
        Node maybeRest = paramList.getLastChild();
        int lastParameter = parameters.size() - 1;
        if (maybeRest != null && maybeRest.isRest()) {
            int restIndex = paramList.getChildCount() - 1;
            if (parameters.size() < restIndex || restIndex < parameters.size() && parameters.get(restIndex).shouldRemove()) {
                Node value = IR.arraylit(new Node[0]).srcref(maybeRest);
                for (int i = restIndex; i < parameters.size(); ++i) {
                    Parameter parameter = parameters.get(i);
                    Preconditions.checkState(parameter.shouldRemove());
                    value.addChildToBack(parameters.get(i).getArg());
                }
                maybeRest.detach();
                Node lhs = maybeRest.removeFirstChild();
                this.addRestVariableToFunction(fn, lhs, value);
            }
            lastParameter = Math.min(parameters.size() - 1, restIndex - 1);
        }
        for (int i = lastParameter; i >= 0; --i) {
            Parameter parameter = parameters.get(i);
            if (!parameter.shouldRemove()) continue;
            Node formalParam = NodeUtil.getArgumentForFunction(fn, i);
            if (formalParam != null) {
                formalParam.detach();
                if (formalParam.isDefaultValue()) {
                    Preconditions.checkState(!parameter.mayBeUndefined);
                    formalParam = formalParam.removeFirstChild();
                }
            }
            this.addVariableToFunction(fn, formalParam, parameters.get(i).getArg());
        }
    }

    private void optimizeCallSite(List<Parameter> parameters, Node target) {
        Node call = OptimizeCalls.ReferenceMap.getCallOrNewNodeForTarget(target);
        boolean mayMutateArgs = call.mayMutateArguments();
        boolean mayMutateGlobalsOrThrow = call.mayMutateGlobalStateOrThrow();
        for (int index = parameters.size() - 1; index >= 0; --index) {
            Parameter p = parameters.get(index);
            if (!p.shouldRemove()) continue;
            this.eliminateCallTargetArgAt(target, index);
            if (!mayMutateArgs || mayMutateGlobalsOrThrow || NodeUtil.isImmutableValue(p.getArg())) continue;
            mayMutateGlobalsOrThrow = true;
            call.setSideEffectFlags(new Node.SideEffectFlags(call.getSideEffectFlags()).setMutatesGlobalState());
        }
    }

    private void addRestVariableToFunction(Node function, Node lhs, Node value) {
        Preconditions.checkState(lhs.getParent() == null);
        this.addVariableToFunction(function, lhs, value);
    }

    private void addVariableToFunction(Node function, @Nullable Node lhs, Node value) {
        Node insertionPoint;
        Preconditions.checkState(value.getParent() == null);
        Preconditions.checkState(lhs == null || lhs.getParent() == null);
        Node block = NodeUtil.getFunctionBody(function);
        Node stmt = lhs != null ? NodeUtil.newVarNode(lhs, value) : IR.exprResult(value).useSourceInfoFrom(value);
        for (insertionPoint = block.getFirstChild(); insertionPoint != null && insertionPoint.isFunction(); insertionPoint = insertionPoint.getNext()) {
        }
        if (insertionPoint == null) {
            block.addChildToBack(stmt);
        } else {
            block.addChildBefore(stmt, insertionPoint);
        }
        this.compiler.reportChangeToEnclosingScope(stmt);
    }

    private void eliminateParamsAfter(Node fnNode, int argIndex) {
        Node formalArgPtr;
        for (formalArgPtr = NodeUtil.getFunctionParameters(fnNode).getFirstChild(); argIndex != 0 && formalArgPtr != null; formalArgPtr = formalArgPtr.getNext(), --argIndex) {
        }
        this.eliminateParamsAfter(fnNode, formalArgPtr);
    }

    private void eliminateParamsAfter(Node fnNode, Node formal) {
        if (formal != null) {
            Node stmt;
            this.eliminateParamsAfter(fnNode, formal.getNext());
            formal.detach();
            if (formal.isRest()) {
                Preconditions.checkState(formal.getNext() == null);
                stmt = NodeUtil.newVarNode(formal.removeFirstChild(), IR.arraylit(new Node[0]).srcref(formal));
            } else if (formal.isDefaultValue()) {
                Node lhs = formal.removeFirstChild();
                Node value = formal.getLastChild().detach();
                stmt = NodeUtil.newVarNode(lhs, value);
            } else if (formal.isDestructuringPattern()) {
                Node value = NodeUtil.newUndefinedNode(formal);
                stmt = NodeUtil.newVarNode(formal, value);
            } else {
                stmt = IR.var(formal).useSourceInfoIfMissingFrom(formal);
            }
            fnNode.getLastChild().addChildToFront(stmt);
            this.compiler.reportChangeToEnclosingScope(stmt);
        }
    }

    private void eliminateCallTargetArgAt(Node ref, int argIndex) {
        Node callArgNode = OptimizeCalls.ReferenceMap.getArgumentForCallOrNewOrDotCall(ref, argIndex);
        if (callArgNode != null) {
            NodeUtil.deleteNode(callArgNode, this.compiler);
        }
    }

    private static class Parameter {
        private final Node arg;
        private boolean shouldRemove;
        private boolean hasSideEffects;
        private boolean canBeSideEffected;
        private boolean mayBeUndefined;

        public Parameter(Node arg, boolean shouldRemove) {
            this.shouldRemove = shouldRemove;
            this.arg = arg;
        }

        public Node getArg() {
            return this.arg;
        }

        public boolean shouldRemove() {
            return this.shouldRemove;
        }

        public void setShouldRemove(boolean value) {
            this.shouldRemove = value;
        }

        public void setHasSideEffects(boolean hasSideEffects) {
            this.hasSideEffects = hasSideEffects;
        }

        public boolean hasSideEffects() {
            return this.hasSideEffects;
        }

        public void setCanBeSideEffected(boolean canBeSideEffected) {
            this.canBeSideEffected = canBeSideEffected;
        }

        public boolean canBeSideEffected() {
            return this.canBeSideEffected;
        }

        public void setMayBeUndefined(boolean mayBeUndefined) {
            this.mayBeUndefined = mayBeUndefined;
        }

        public boolean mayBeUndefined() {
            return this.mayBeUndefined;
        }
    }

    class UnusedParameterOptimizer {
        final List<Node> toRemove = new ArrayList<Node>();
        final List<Node> toReplaceWithZero = new ArrayList<Node>();

        UnusedParameterOptimizer() {
        }

        void tryEliminateUnusedArgs(ArrayList<Node> refs) {
            ImmutableListMultimap<Node, Node> fns = OptimizeCalls.ReferenceMap.getFunctionNodes(refs);
            Preconditions.checkState(!fns.isEmpty());
            int maxFormalsCount = 0;
            int lowestUsedRest = Integer.MAX_VALUE;
            BitSet used = new BitSet();
            for (Node fn : fns.values()) {
                Node paramList = NodeUtil.getFunctionParameters(fn);
                int index = -1;
                for (Node c = paramList.getFirstChild(); c != null; c = c.getNext()) {
                    ++index;
                    if (c.isUnusedParameter()) continue;
                    used.set(index);
                    if (!c.isRest() || (lowestUsedRest = Math.min(lowestUsedRest, index)) != 0) continue;
                    return;
                }
                maxFormalsCount = Math.max(maxFormalsCount, index + 1);
            }
            if (lowestUsedRest < maxFormalsCount) {
                used.set(lowestUsedRest, maxFormalsCount);
            }
            BitSet unused = (BitSet)used.clone();
            unused.flip(0, maxFormalsCount);
            if (lowestUsedRest < maxFormalsCount && unused.cardinality() == 0) {
                return;
            }
            BitSet unremovable = (BitSet)used.clone();
            int lowestSpread = Integer.MAX_VALUE;
            block2: for (Node n : refs) {
                if (!OptimizeCalls.ReferenceMap.isNormalOrOptionalCallOrNewTarget(n)) continue;
                Node param = OptimizeCalls.ReferenceMap.getFirstArgumentForCallOrNewOrDotCall(n);
                for (int paramIndex = 0; param != null && paramIndex < maxFormalsCount; param = param.getNext(), ++paramIndex) {
                    if (param.isSpread()) {
                        lowestSpread = Math.min(lowestSpread, paramIndex);
                        continue block2;
                    }
                    if (unremovable.get(paramIndex) || !OptimizeParameters.this.astAnalyzer.mayHaveSideEffects(param)) continue;
                    unremovable.set(paramIndex);
                }
            }
            if (lowestSpread < maxFormalsCount) {
                unremovable.set(lowestSpread, maxFormalsCount);
            }
            int removeAllAfterIndex = Integer.MAX_VALUE;
            if (lowestUsedRest == Integer.MAX_VALUE) {
                removeAllAfterIndex = maxFormalsCount - 1;
            }
            for (Node n : refs) {
                if (!OptimizeCalls.ReferenceMap.isNormalOrOptionalCallOrNewTarget(n) || OptimizeParameters.alreadyRemoved(n)) continue;
                Node arg = OptimizeCalls.ReferenceMap.getFirstArgumentForCallOrNewOrDotCall(n);
                this.recordRemovalCallArguments(lowestUsedRest, removeAllAfterIndex, unused, unremovable, arg, 0);
            }
            for (Node fn : fns.values()) {
                Node paramList = NodeUtil.getFunctionParameters(fn);
                Node param = paramList.getFirstChild();
                this.removeUnusedFunctionParameters(unremovable, param, 0);
            }
        }

        void recordRemovalCallArguments(int firstRestIndex, int removeAllAfterIndex, BitSet unused, BitSet unremovable, Node arg, int index) {
            if (arg == null) {
                return;
            }
            if (index > removeAllAfterIndex) {
                this.removeArgAndFollowing(arg);
                return;
            }
            if (arg.isSpread()) {
                return;
            }
            this.recordRemovalCallArguments(firstRestIndex, removeAllAfterIndex, unused, unremovable, arg.getNext(), index + 1);
            if (index < firstRestIndex && unused.get(index) && !OptimizeParameters.this.astAnalyzer.mayHaveSideEffects(arg)) {
                if (unremovable.get(index)) {
                    if (!arg.isNumber() || arg.getDouble() != 0.0) {
                        this.toReplaceWithZero.add(arg);
                    }
                } else {
                    this.toRemove.add(arg);
                }
            }
        }

        void removeArgAndFollowing(Node arg) {
            if (arg != null) {
                this.removeArgAndFollowing(arg.getNext());
                if (!OptimizeParameters.this.astAnalyzer.mayHaveSideEffects(arg)) {
                    this.toRemove.add(arg);
                }
            }
        }

        void removeUnusedFunctionParameters(BitSet unremovable, Node param, int index) {
            if (param != null) {
                this.removeUnusedFunctionParameters(unremovable, param.getNext(), index + 1);
                if (!unremovable.get(index)) {
                    Preconditions.checkState(param.isName());
                    OptimizeParameters.this.compiler.reportChangeToEnclosingScope(param);
                    param.detach();
                }
            }
        }

        public void applyChanges() {
            for (Node n : this.toRemove) {
                if (OptimizeParameters.alreadyRemoved(n)) continue;
                OptimizeParameters.this.compiler.reportChangeToEnclosingScope(n);
                n.detach();
                NodeUtil.markFunctionsDeleted(n, OptimizeParameters.this.compiler);
            }
            for (Node n : this.toReplaceWithZero) {
                Preconditions.checkState(!n.isNumber() || n.getDouble() != 0.0);
                if (OptimizeParameters.alreadyRemoved(n)) continue;
                OptimizeParameters.this.compiler.reportChangeToEnclosingScope(n);
                n.replaceWith(IR.number(0.0).srcref(n));
                NodeUtil.markFunctionsDeleted(n, OptimizeParameters.this.compiler);
            }
        }
    }
}

