/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AutoValue_JsMessage;
import com.google.javascript.jscomp.AutoValue_JsMessage_PlaceholderReference;
import com.google.javascript.jscomp.jarjar.com.google.auto.value.AutoValue;
import com.google.javascript.jscomp.jarjar.com.google.common.annotations.GwtIncompatible;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Ascii;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.jarjar.com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.jscomp.parsing.parser.util.format.SimpleFormat;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@AutoValue
public abstract class JsMessage {
    private static final String MESSAGE_REPRESENTATION_FORMAT = "{$%s}";

    @Nullable
    public abstract String getSourceName();

    public abstract String getKey();

    public abstract boolean isAnonymous();

    public abstract boolean isExternal();

    public abstract String getId();

    public abstract ImmutableList<CharSequence> getParts();

    @Nullable
    public abstract String getAlternateId();

    @Nullable
    public abstract String getDesc();

    @Nullable
    public abstract String getMeaning();

    public abstract boolean isHidden();

    @Deprecated
    public final ImmutableList<CharSequence> parts() {
        return this.getParts();
    }

    public abstract ImmutableSet<String> placeholders();

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        for (CharSequence p : this.getParts()) {
            sb.append(p.toString());
        }
        return sb.toString();
    }

    public final boolean isEmpty() {
        for (CharSequence part : this.getParts()) {
            if (part.length() <= 0) continue;
            return false;
        }
        return true;
    }

    public static interface IdGenerator {
        public String generateId(String var1, List<CharSequence> var2);
    }

    static final class Hash {
        private static final long SEED64 = 3141592653589793238L;
        private static final long CONSTANT64 = -2266404186210603134L;

        private Hash() {
        }

        static long hash64(@Nullable String value) {
            return Hash.hash64(value, 3141592653589793238L);
        }

        private static long hash64(@Nullable String value, long seed) {
            if (value == null) {
                return Hash.hash64(null, 0, 0, seed);
            }
            return Hash.hash64(value.getBytes(StandardCharsets.UTF_8), seed);
        }

        private static long hash64(byte[] value, long seed) {
            return Hash.hash64(value, 0, value == null ? 0 : value.length, seed);
        }

        private static long hash64(byte[] value, int offset, int length, long seed) {
            long a;
            long b = a = -2266404186210603134L;
            long c = seed;
            int keylen = length;
            while (keylen >= 24) {
                a += Hash.word64At(value, offset);
                a -= (b += Hash.word64At(value, offset + 8));
                a -= (c += Hash.word64At(value, offset + 16));
                b -= c;
                b -= (a ^= c >>> 43);
                c -= a;
                c -= (b ^= a << 9);
                a -= b;
                a -= (c ^= b >>> 8);
                b -= c;
                b -= (a ^= c >>> 38);
                c -= a;
                c -= (b ^= a << 23);
                a -= b;
                a -= (c ^= b >>> 5);
                b -= c;
                b -= (a ^= c >>> 35);
                c -= a;
                c -= (b ^= a << 49);
                a -= b;
                a -= (c ^= b >>> 11);
                b -= c;
                b -= (a ^= c >>> 12);
                c -= a;
                c -= (b ^= a << 18);
                c ^= b >>> 22;
                keylen -= 24;
                offset += 24;
            }
            c += (long)length;
            if (keylen >= 16) {
                if (keylen == 23) {
                    c += (long)value[offset + 22] << 56;
                }
                if (keylen >= 22) {
                    c += ((long)value[offset + 21] & 0xFFL) << 48;
                }
                if (keylen >= 21) {
                    c += ((long)value[offset + 20] & 0xFFL) << 40;
                }
                if (keylen >= 20) {
                    c += ((long)value[offset + 19] & 0xFFL) << 32;
                }
                if (keylen >= 19) {
                    c += ((long)value[offset + 18] & 0xFFL) << 24;
                }
                if (keylen >= 18) {
                    c += ((long)value[offset + 17] & 0xFFL) << 16;
                }
                if (keylen >= 17) {
                    c += ((long)value[offset + 16] & 0xFFL) << 8;
                }
                if (keylen >= 16) {
                    b += Hash.word64At(value, offset + 8);
                    a += Hash.word64At(value, offset);
                }
            } else if (keylen >= 8) {
                if (keylen == 15) {
                    b += ((long)value[offset + 14] & 0xFFL) << 48;
                }
                if (keylen >= 14) {
                    b += ((long)value[offset + 13] & 0xFFL) << 40;
                }
                if (keylen >= 13) {
                    b += ((long)value[offset + 12] & 0xFFL) << 32;
                }
                if (keylen >= 12) {
                    b += ((long)value[offset + 11] & 0xFFL) << 24;
                }
                if (keylen >= 11) {
                    b += ((long)value[offset + 10] & 0xFFL) << 16;
                }
                if (keylen >= 10) {
                    b += ((long)value[offset + 9] & 0xFFL) << 8;
                }
                if (keylen >= 9) {
                    b += (long)value[offset + 8] & 0xFFL;
                }
                if (keylen >= 8) {
                    a += Hash.word64At(value, offset);
                }
            } else {
                if (keylen == 7) {
                    a += ((long)value[offset + 6] & 0xFFL) << 48;
                }
                if (keylen >= 6) {
                    a += ((long)value[offset + 5] & 0xFFL) << 40;
                }
                if (keylen >= 5) {
                    a += ((long)value[offset + 4] & 0xFFL) << 32;
                }
                if (keylen >= 4) {
                    a += ((long)value[offset + 3] & 0xFFL) << 24;
                }
                if (keylen >= 3) {
                    a += ((long)value[offset + 2] & 0xFFL) << 16;
                }
                if (keylen >= 2) {
                    a += ((long)value[offset + 1] & 0xFFL) << 8;
                }
                if (keylen >= 1) {
                    a += (long)value[offset + 0] & 0xFFL;
                }
            }
            return Hash.mix64(a, b, c);
        }

        private static long word64At(byte[] bytes, int offset) {
            return ((long)bytes[offset + 0] & 0xFFL) + (((long)bytes[offset + 1] & 0xFFL) << 8) + (((long)bytes[offset + 2] & 0xFFL) << 16) + (((long)bytes[offset + 3] & 0xFFL) << 24) + (((long)bytes[offset + 4] & 0xFFL) << 32) + (((long)bytes[offset + 5] & 0xFFL) << 40) + (((long)bytes[offset + 6] & 0xFFL) << 48) + (((long)bytes[offset + 7] & 0xFFL) << 56);
        }

        private static long mix64(long a, long b, long c) {
            a -= b;
            a -= c;
            b -= c;
            b -= (a ^= c >>> 43);
            c -= a;
            c -= (b ^= a << 9);
            a -= b;
            a -= (c ^= b >>> 8);
            b -= c;
            b -= (a ^= c >>> 38);
            c -= a;
            c -= (b ^= a << 23);
            a -= b;
            a -= (c ^= b >>> 5);
            b -= c;
            b -= (a ^= c >>> 35);
            c -= a;
            c -= (b ^= a << 49);
            a -= b;
            a -= (c ^= b >>> 11);
            b -= c;
            b -= (a ^= c >>> 12);
            c -= a;
            c -= (b ^= a << 18);
            return c ^= b >>> 22;
        }
    }

    @GwtIncompatible(value="java.util.regex")
    public static final class Builder {
        private static final String MSG_EXTERNAL_PREFIX = "MSG_EXTERNAL_";
        private String key;
        private String meaning;
        private String desc;
        private boolean hidden;
        private String alternateId;
        private final List<CharSequence> parts = new ArrayList<CharSequence>();
        private final Set<String> placeholders = new HashSet<String>();
        private String sourceName;

        private static String getExternalMessageId(String identifier) {
            if (identifier.startsWith(MSG_EXTERNAL_PREFIX)) {
                int start;
                char c;
                int end;
                for (end = start = MSG_EXTERNAL_PREFIX.length(); end < identifier.length() && (c = identifier.charAt(end)) <= '9' && c >= '0'; ++end) {
                }
                if (end > start) {
                    return identifier.substring(start, end);
                }
            }
            return null;
        }

        public Builder() {
            this(null);
        }

        public Builder(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        public Builder setSourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public Builder appendPlaceholderReference(String name) {
            Preconditions.checkNotNull(name, "Placeholder name could not be null");
            this.parts.add(PlaceholderReference.create(name));
            this.placeholders.add(name);
            return this;
        }

        public Builder appendStringPart(String part) {
            Preconditions.checkNotNull(part, "String part of the message could not be null");
            this.parts.add(part);
            return this;
        }

        public Set<String> getPlaceholders() {
            return this.placeholders;
        }

        public Builder setDesc(String desc) {
            this.desc = desc;
            return this;
        }

        public Builder setMeaning(String meaning) {
            this.meaning = meaning;
            return this;
        }

        public Builder setAlternateId(String alternateId) {
            this.alternateId = alternateId;
            return this;
        }

        public Builder setIsHidden(boolean hidden) {
            this.hidden = hidden;
            return this;
        }

        public boolean hasParts() {
            return !this.parts.isEmpty();
        }

        public List<CharSequence> getParts() {
            return this.parts;
        }

        public JsMessage build() {
            return this.build(null);
        }

        public JsMessage build(IdGenerator idGenerator) {
            String externalId;
            boolean isAnonymous = false;
            boolean isExternal = false;
            String id = null;
            if (this.getKey() == null) {
                this.key = "MSG_" + Builder.fingerprint(this.getParts());
                isAnonymous = true;
            }
            if (!isAnonymous && (externalId = Builder.getExternalMessageId(this.key)) != null) {
                isExternal = true;
                id = externalId;
            }
            if (!isExternal) {
                String defactoMeaning = this.meaning != null ? this.meaning : this.key;
                id = idGenerator == null ? defactoMeaning : idGenerator.generateId(defactoMeaning, this.parts);
            }
            return new AutoValue_JsMessage(this.sourceName, this.key, isAnonymous, isExternal, id, ImmutableList.copyOf(this.parts), this.alternateId, this.desc, this.meaning, this.hidden, ImmutableSet.copyOf(this.placeholders));
        }

        private static String fingerprint(List<CharSequence> messageParts) {
            StringBuilder sb = new StringBuilder();
            for (CharSequence part : messageParts) {
                if (part instanceof PlaceholderReference) {
                    sb.append(part.toString());
                    continue;
                }
                sb.append(part);
            }
            long nonnegativeHash = Long.MAX_VALUE & Hash.hash64(sb.toString());
            return Ascii.toUpperCase(Long.toString(nonnegativeHash, 36));
        }
    }

    @AutoValue
    public static abstract class PlaceholderReference
    implements CharSequence {
        static PlaceholderReference create(String name) {
            return new AutoValue_JsMessage_PlaceholderReference(name);
        }

        @Override
        public int length() {
            return this.getName().length();
        }

        @Override
        public char charAt(int index) {
            return this.getName().charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.getName().subSequence(start, end);
        }

        public abstract String getName();

        @Override
        public final String toString() {
            return SimpleFormat.format(JsMessage.MESSAGE_REPRESENTATION_FORMAT, this.getName());
        }
    }

    public static enum Style {
        LEGACY,
        RELAX,
        CLOSURE;


        static Style getFromParams(boolean useClosure, boolean allowLegacyMessages) {
            if (useClosure) {
                return allowLegacyMessages ? RELAX : CLOSURE;
            }
            return LEGACY;
        }
    }
}

