/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.rhino.Node;

final class J2clSourceFileChecker
implements CompilerPass {
    static final String HAS_J2CL_ANNOTATION_KEY = "HAS_J2CL";
    private final AbstractCompiler compiler;

    J2clSourceFileChecker(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    private static boolean hasJ2cl(Node root) {
        for (Node script : root.children()) {
            Preconditions.checkState(script.isScript());
            if (script.getSourceFileName() == null || !script.getSourceFileName().endsWith(".java.js")) continue;
            return true;
        }
        return false;
    }

    @Override
    public void process(Node externs, Node root) {
        if (J2clSourceFileChecker.hasJ2cl(root)) {
            J2clSourceFileChecker.markToRunJ2clPasses(this.compiler);
        }
    }

    static void markToRunJ2clPasses(AbstractCompiler compiler) {
        compiler.setAnnotation(HAS_J2CL_ANNOTATION_KEY, true);
    }

    static boolean shouldRunJ2clPasses(AbstractCompiler compiler) {
        return Boolean.TRUE.equals(compiler.getAnnotation(HAS_J2CL_ANNOTATION_KEY));
    }
}

