/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstAnalyzer;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.Es6ToEs3Util;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.OptionalChainRewriter;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.jarjar.com.google.common.annotations.VisibleForTesting;
import com.google.javascript.jscomp.jarjar.com.google.common.base.MoreObjects;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Supplier;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import java.util.ArrayDeque;
import java.util.Set;

class ExpressionDecomposer {
    private final AbstractCompiler compiler;
    private final AstAnalyzer astAnalyzer;
    private final AstFactory astFactory;
    private final Supplier<String> safeNameIdSupplier;
    private final Set<String> knownConstants;
    private final Scope scope;
    private final JSType unknownType;
    private final JSType stringType;
    private final boolean allowMethodCallDecomposing;
    private static final int MAX_ITERATIONS = 100;
    private String tempNamePrefix = "JSCompiler_temp";
    private String resultNamePrefix = "JSCompiler_inline_result";

    ExpressionDecomposer(AbstractCompiler compiler, Supplier<String> safeNameIdSupplier, Set<String> constNames, Scope scope, boolean allowMethodCallDecomposing) {
        Preconditions.checkNotNull(compiler);
        Preconditions.checkNotNull(safeNameIdSupplier);
        Preconditions.checkNotNull(constNames);
        this.compiler = compiler;
        this.astAnalyzer = compiler.getAstAnalyzer();
        this.astFactory = compiler.createAstFactory();
        this.safeNameIdSupplier = safeNameIdSupplier;
        this.knownConstants = constNames;
        this.scope = scope;
        this.allowMethodCallDecomposing = allowMethodCallDecomposing;
        this.unknownType = compiler.getTypeRegistry().getNativeType(JSTypeNative.UNKNOWN_TYPE);
        this.stringType = compiler.getTypeRegistry().getNativeType(JSTypeNative.STRING_TYPE);
    }

    void maybeExposeExpression(Node expression) {
        int i = 0;
        while (DecompositionType.DECOMPOSABLE == this.canExposeExpression(expression)) {
            this.exposeExpression(expression);
            if (++i <= 100) continue;
            throw new IllegalStateException("DecomposeExpression depth exceeded on:\n" + expression.toStringTree());
        }
    }

    private void exposeExpression(Node expression) {
        this.rewriteAllContainingOptionalChains(expression);
        Node expressionRoot = ExpressionDecomposer.findExpressionRoot(expression);
        Preconditions.checkNotNull(expressionRoot);
        Preconditions.checkState(NodeUtil.isStatement(expressionRoot), expressionRoot);
        this.exposeExpression(expressionRoot, expression);
    }

    private void exposeExpression(Node expressionRoot, Node subExpression) {
        Node nodeWithNonconditionalParent = ExpressionDecomposer.findNonconditionalParent(subExpression, expressionRoot);
        boolean hasFollowingSideEffects = this.astAnalyzer.mayHaveSideEffects(nodeWithNonconditionalParent);
        Node exprInjectionPoint = ExpressionDecomposer.findInjectionPoint(nodeWithNonconditionalParent);
        DecompositionState state = new DecompositionState();
        state.sideEffects = hasFollowingSideEffects;
        state.extractBeforeStatement = exprInjectionPoint;
        Node lastExposedSubexpression = null;
        Node expressionToExpose = nodeWithNonconditionalParent;
        Node expressionParent = expressionToExpose.getParent();
        while (expressionParent != expressionRoot) {
            Preconditions.checkState(!ExpressionDecomposer.isConditionalOp(expressionParent) || expressionToExpose.isFirstChildOf(expressionParent), expressionParent);
            if (expressionParent.isAssign()) {
                if (!this.isSafeAssign(expressionParent, state.sideEffects) && !expressionToExpose.isFirstChildOf(expressionParent)) {
                    Node left = expressionParent.getFirstChild();
                    switch (left.getToken()) {
                        case GETELEM: {
                            this.decomposeSubExpressions(left.getLastChild(), null, state);
                        }
                        case GETPROP: {
                            this.decomposeSubExpressions(left.getFirstChild(), null, state);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Expected a property access: " + left.toStringTree());
                        }
                    }
                }
            } else if (expressionParent.isCall() && NodeUtil.isNormalGet(expressionParent.getFirstChild())) {
                Node callee = expressionParent.getFirstChild();
                this.decomposeSubExpressions(callee.getNext(), expressionToExpose, state);
                if (this.isExpressionTreeUnsafe(callee, state.sideEffects) && lastExposedSubexpression != callee.getFirstChild()) {
                    Preconditions.checkState(this.allowMethodCallDecomposing, "Object method calls cannot be decomposed.");
                    state.sideEffects = true;
                    expressionParent = this.rewriteCallExpression(expressionParent, state);
                }
            } else {
                this.decomposeSubExpressions(expressionParent.getFirstChild(), expressionToExpose, state);
            }
            lastExposedSubexpression = expressionToExpose;
            expressionToExpose = expressionParent;
            expressionParent = expressionToExpose.getParent();
        }
        if (nodeWithNonconditionalParent != subExpression) {
            Node parent = nodeWithNonconditionalParent.getParent();
            boolean needResult = !parent.isExprResult();
            this.extractConditional(nodeWithNonconditionalParent, exprInjectionPoint, needResult);
        }
    }

    private void rewriteAllContainingOptionalChains(Node subExpression) {
        OptionalChainRewriter.Builder optChainRewriterBuilder = OptionalChainRewriter.builder(this.compiler).setTmpVarNameCreator(this::getTempConstantValueName);
        ArrayDeque<OptionalChainRewriter> rewriters = new ArrayDeque<OptionalChainRewriter>();
        Node exprParent = subExpression.getParent();
        while (!NodeUtil.isStatement(exprParent)) {
            Node callee;
            if (NodeUtil.isEndOfFullOptChain(exprParent)) {
                rewriters.addFirst(optChainRewriterBuilder.build(exprParent));
            } else if (exprParent.isCall() && NodeUtil.isOptChainGet(callee = exprParent.getFirstChild())) {
                rewriters.addFirst(optChainRewriterBuilder.build(callee));
            }
            exprParent = exprParent.getParent();
        }
        for (OptionalChainRewriter rewriter : rewriters) {
            rewriter.rewrite();
        }
    }

    void moveExpression(Node expression) {
        String resultName = this.getResultValueName();
        Node injectionPoint = ExpressionDecomposer.findInjectionPoint(expression);
        Preconditions.checkNotNull(injectionPoint);
        Node injectionPointParent = injectionPoint.getParent();
        Preconditions.checkNotNull(injectionPointParent);
        Preconditions.checkState(NodeUtil.isStatementBlock(injectionPointParent));
        Node expressionParent = expression.getParent();
        expressionParent.replaceChild(expression, Es6ToEs3Util.withType(IR.name(resultName), expression.getJSType()));
        Node newExpressionRoot = NodeUtil.newVarNode(resultName, expression);
        newExpressionRoot.getFirstChild().setJSType(expression.getJSType());
        injectionPointParent.addChildBefore(newExpressionRoot, injectionPoint);
        this.compiler.reportChangeToEnclosingScope(injectionPointParent);
    }

    private static Node findNonconditionalParent(Node subExpression, Node expressionRoot) {
        Node result = subExpression;
        Node child = subExpression;
        Node parent = child.getParent();
        while (parent != expressionRoot) {
            if (ExpressionDecomposer.isConditionalOp(parent) && !child.isFirstChildOf(parent)) {
                result = parent;
            }
            child = parent;
            parent = child.getParent();
        }
        if (NodeUtil.isOptChainNode(result)) {
            result = NodeUtil.getEndOfOptChainSegment(result);
        }
        return result;
    }

    private void decomposeSubExpressions(Node n, Node stopNode, DecompositionState state) {
        if (n == null || n == stopNode) {
            return;
        }
        this.decomposeSubExpressions(n.getNext(), stopNode, state);
        if (NodeUtil.mayBeObjectLitKey(n) || n.isComputedProp()) {
            if (n.isComputedProp()) {
                this.decomposeSubExpressions(n.getSecondChild(), stopNode, state);
            }
            n = n.getFirstChild();
        } else if (n.isTemplateLitSub()) {
            n = n.getFirstChild();
        } else if (!n.isSpread() && !IR.mayBeExpression(n)) {
            return;
        }
        if (this.isExpressionTreeUnsafe(n, state.sideEffects)) {
            state.sideEffects = true;
            state.extractBeforeStatement = this.extractExpression(n, state.extractBeforeStatement);
        }
    }

    private static void insertBefore(Node injectionPoint, Node newNode) {
        Node injectionParent = injectionPoint.getParent();
        injectionParent.addChildBefore(newNode, injectionPoint);
    }

    private Node extractConditional(Node expr, Node injectionPoint, boolean needResult) {
        Node injectionPointParent;
        Node parent = expr.getParent();
        String tempName = this.getTempValueName();
        Node first = expr.getFirstChild();
        Node second = first.getNext();
        Node last = expr.getLastChild();
        expr.detachChildren();
        Node cond = null;
        Node trueExpr = this.astFactory.createBlock(new Node[0]).srcref(expr);
        Node falseExpr = this.astFactory.createBlock(new Node[0]).srcref(expr);
        switch (expr.getToken()) {
            case HOOK: {
                cond = first;
                trueExpr.addChildToFront(this.astFactory.exprResult(ExpressionDecomposer.buildResultExpression(second, needResult, tempName)));
                falseExpr.addChildToFront(this.astFactory.exprResult(ExpressionDecomposer.buildResultExpression(last, needResult, tempName)));
                break;
            }
            case AND: {
                cond = ExpressionDecomposer.buildResultExpression(first, needResult, tempName);
                trueExpr.addChildToFront(this.astFactory.exprResult(ExpressionDecomposer.buildResultExpression(last, needResult, tempName)));
                break;
            }
            case OR: {
                cond = ExpressionDecomposer.buildResultExpression(first, needResult, tempName);
                falseExpr.addChildToFront(this.astFactory.exprResult(ExpressionDecomposer.buildResultExpression(last, needResult, tempName)));
                break;
            }
            case COALESCE: {
                String tempNameAssign = this.getTempValueName();
                Node tempVarNodeAssign = this.astFactory.createSingleVarNameDeclaration(tempNameAssign).useSourceInfoIfMissingFromForTree(expr);
                injectionPointParent = injectionPoint.getParent();
                injectionPointParent.addChildBefore(tempVarNodeAssign, injectionPoint);
                Node assignLhs = ExpressionDecomposer.buildResultExpression(first, true, tempNameAssign);
                Node nullNode = this.astFactory.createNull().useSourceInfoFrom(expr);
                cond = this.astFactory.createNe(assignLhs, nullNode).useSourceInfoFrom(expr);
                trueExpr.addChildToFront(this.astFactory.exprResult(ExpressionDecomposer.buildResultExpression(this.astFactory.createName(tempNameAssign, first.getJSType()).useSourceInfoFrom(expr), needResult, tempName)));
                falseExpr.addChildToFront(this.astFactory.exprResult(ExpressionDecomposer.buildResultExpression(last, needResult, tempName)));
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected expression: " + expr);
            }
        }
        Node ifNode = falseExpr.hasChildren() ? this.astFactory.createIf(cond, trueExpr, falseExpr) : this.astFactory.createIf(cond, trueExpr);
        ifNode.useSourceInfoIfMissingFrom(expr);
        if (needResult) {
            Node tempVarNode = this.astFactory.createSingleVarNameDeclaration(tempName).useSourceInfoIfMissingFromForTree(expr);
            injectionPointParent = injectionPoint.getParent();
            injectionPointParent.addChildBefore(tempVarNode, injectionPoint);
            injectionPointParent.addChildAfter(ifNode, tempVarNode);
            Node replacementValueNode = Es6ToEs3Util.withType(IR.name(tempName), expr.getJSType());
            parent.replaceChild(expr, replacementValueNode);
        } else {
            Preconditions.checkArgument(parent.isExprResult());
            Node grandparent = parent.getParent();
            grandparent.replaceChild(parent, ifNode);
        }
        return ifNode;
    }

    private static Node buildResultExpression(Node expr, boolean needResult, String tempName) {
        if (needResult) {
            JSType type = expr.getJSType();
            return Es6ToEs3Util.withType(IR.assign(Es6ToEs3Util.withType(IR.name(tempName), type), expr), type).srcrefTree(expr);
        }
        return expr;
    }

    private boolean isConstantNameNode(Node n) {
        return n.isName() && (NodeUtil.isConstantVar(n, this.scope) || this.knownConstants.contains(n.getString()));
    }

    private Node extractExpression(Node expr, Node injectionPoint) {
        Node tempNameValue;
        Node parent = expr.getParent();
        boolean isLhsOfAssignOp = NodeUtil.isAssignmentOp(parent) && !parent.isAssign() && expr.isFirstChildOf(parent);
        Node firstExtractedNode = null;
        if (isLhsOfAssignOp && NodeUtil.isNormalGet(expr)) {
            for (Node n : expr.children()) {
                if (n.isString() || this.isConstantNameNode(n)) continue;
                Node extractedNode = this.extractExpression(n, injectionPoint);
                if (firstExtractedNode != null) continue;
                firstExtractedNode = extractedNode;
            }
        }
        String tempName = this.getTempConstantValueName();
        Node replacementValueNode = IR.name(tempName).setJSType(expr.getJSType()).srcref(expr);
        if (isLhsOfAssignOp) {
            Preconditions.checkState(expr.isName() || NodeUtil.isNormalGet(expr), expr);
            Node opNode = Es6ToEs3Util.withType(new Node(NodeUtil.getOpFromAssignmentOp(parent)), parent.getJSType()).useSourceInfoIfMissingFrom(parent);
            Node rightOperand = parent.getLastChild();
            parent.setToken(Token.ASSIGN);
            parent.replaceChild(rightOperand, opNode);
            opNode.addChildToFront(replacementValueNode);
            opNode.addChildToBack(rightOperand);
            tempNameValue = expr.cloneTree();
        } else if (expr.isSpread()) {
            Node spreadCopy = expr.cloneNode();
            spreadCopy.addChildToBack(replacementValueNode);
            expr.replaceWith(spreadCopy);
            switch (parent.getToken()) {
                case ARRAYLIT: 
                case CALL: 
                case NEW: {
                    tempNameValue = this.astFactory.createArraylit(expr).useSourceInfoFrom(expr.getOnlyChild());
                    break;
                }
                case OBJECTLIT: {
                    tempNameValue = this.astFactory.createObjectLit(expr).useSourceInfoFrom(expr.getOnlyChild());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected parent of SPREAD:" + parent.toStringTree());
                }
            }
        } else {
            parent.replaceChild(expr, replacementValueNode);
            tempNameValue = expr;
        }
        Node tempVarNode = NodeUtil.newVarNode(tempName, tempNameValue);
        tempVarNode.getFirstChild().setJSType(tempNameValue.getJSType());
        ExpressionDecomposer.insertBefore(injectionPoint, tempVarNode);
        if (firstExtractedNode == null) {
            firstExtractedNode = tempVarNode;
        }
        Preconditions.checkState(firstExtractedNode.isVar());
        return firstExtractedNode;
    }

    private Node rewriteCallExpression(Node call, DecompositionState state) {
        Node thisVarNode;
        Node getVarNode;
        Preconditions.checkArgument(call.isCall(), call);
        Node first = call.getFirstChild();
        Preconditions.checkArgument(NodeUtil.isNormalGet(first), first);
        JSType fnType = first.getJSType();
        JSType fnCallType = null;
        if (fnType != null) {
            fnCallType = fnType.isFunctionType() ? fnType.toMaybeFunctionType().getPropertyType("call") : this.unknownType;
        }
        state.extractBeforeStatement = getVarNode = this.extractExpression(first, state.extractBeforeStatement);
        Node getExprNode = getVarNode.getFirstFirstChild();
        Preconditions.checkArgument(NodeUtil.isNormalGet(getExprNode), getExprNode);
        state.extractBeforeStatement = thisVarNode = this.extractExpression(getExprNode.getFirstChild(), state.extractBeforeStatement);
        Node thisNameNode = thisVarNode.getFirstChild();
        Node functionNameNode = getVarNode.getFirstChild();
        Node newCall = IR.call(Es6ToEs3Util.withType(IR.getprop(functionNameNode.cloneNode(), Es6ToEs3Util.withType(IR.string("call"), this.stringType)), fnCallType), thisNameNode.cloneNode()).setJSType(call.getJSType()).useSourceInfoIfMissingFromForTree(call);
        call.removeFirstChild();
        if (call.hasChildren()) {
            newCall.addChildrenToBack(call.removeChildren());
        }
        call.replaceWith(newCall);
        return newCall;
    }

    @VisibleForTesting
    public void setTempNamePrefix(String prefix) {
        this.tempNamePrefix = prefix;
    }

    private String getTempValueName() {
        return this.tempNamePrefix + "$jscomp$" + this.safeNameIdSupplier.get();
    }

    @VisibleForTesting
    public void setResultNamePrefix(String prefix) {
        this.resultNamePrefix = prefix;
    }

    private String getResultValueName() {
        return this.resultNamePrefix + "$jscomp$" + this.safeNameIdSupplier.get();
    }

    private String getTempConstantValueName() {
        String name = this.tempNamePrefix + "_const" + "$jscomp$" + this.safeNameIdSupplier.get();
        this.knownConstants.add(name);
        return name;
    }

    private boolean isTempConstantValueName(Node name) {
        return name.isName() && name.getString().startsWith(this.tempNamePrefix + "_const" + "$jscomp$");
    }

    @Nullable
    static Node findInjectionPoint(Node subExpression) {
        Node expressionRoot = ExpressionDecomposer.findExpressionRoot(subExpression);
        Preconditions.checkNotNull(expressionRoot);
        Node injectionPoint = expressionRoot;
        Node parent = injectionPoint.getParent();
        while (parent.isLabel()) {
            injectionPoint = parent;
            parent = injectionPoint.getParent();
        }
        Preconditions.checkState(NodeUtil.isStatementBlock(parent), parent);
        return injectionPoint;
    }

    private static boolean isConditionalOp(Node n) {
        switch (n.getToken()) {
            case HOOK: 
            case AND: 
            case OR: 
            case COALESCE: 
            case OPTCHAIN_GETELEM: 
            case OPTCHAIN_GETPROP: 
            case OPTCHAIN_CALL: {
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static Node findExpressionRoot(Node subExpression) {
        Node child = subExpression;
        for (Node current : child.getAncestors()) {
            Node parent = current.getParent();
            switch (current.getToken()) {
                case EXPR_RESULT: 
                case IF: 
                case SWITCH: 
                case RETURN: 
                case THROW: {
                    Preconditions.checkState(child.isFirstChildOf(current));
                    return current;
                }
                case VAR: 
                case LET: 
                case CONST: {
                    if (NodeUtil.isAnyFor(parent)) break;
                    return current;
                }
                case FOR: {
                    if (child.isFirstChildOf(current)) {
                        return current;
                    }
                }
                case FOR_IN: 
                case FOR_OF: 
                case FOR_AWAIT_OF: 
                case DO: 
                case WHILE: 
                case SCRIPT: 
                case BLOCK: 
                case LABEL: 
                case CASE: 
                case DEFAULT_CASE: 
                case DEFAULT_VALUE: 
                case PARAM_LIST: {
                    return null;
                }
            }
            child = current;
        }
        throw new IllegalStateException("Unexpected AST structure.");
    }

    DecompositionType canExposeExpression(Node subExpression) {
        Node expressionRoot = ExpressionDecomposer.findExpressionRoot(subExpression);
        if (expressionRoot != null) {
            return this.isSubexpressionMovable(expressionRoot, subExpression);
        }
        return DecompositionType.UNDECOMPOSABLE;
    }

    private DecompositionType isSubexpressionMovable(Node expressionRoot, Node subExpression) {
        boolean requiresDecomposition = false;
        boolean seenSideEffects = this.astAnalyzer.mayHaveSideEffects(subExpression);
        if (NodeUtil.isOptChainNode(subExpression) && !NodeUtil.isEndOfFullOptChain(subExpression)) {
            requiresDecomposition = true;
        }
        Node child = subExpression;
        for (Node parent : child.getAncestors()) {
            if (NodeUtil.isNameDeclaration(parent) && !child.isFirstChildOf(parent)) {
                return DecompositionType.UNDECOMPOSABLE;
            }
            if (parent == expressionRoot) {
                return requiresDecomposition ? DecompositionType.DECOMPOSABLE : DecompositionType.MOVABLE;
            }
            if (ExpressionDecomposer.isConditionalOp(parent)) {
                if (child != parent.getFirstChild()) {
                    requiresDecomposition = true;
                }
            } else if (!this.isSafeAssign(parent, seenSideEffects)) {
                EvaluationDirection direction = ExpressionDecomposer.getEvaluationDirection(parent);
                Node n = this.getFirstEvaluatedChild(parent, direction);
                while (n != null && n != child) {
                    if (this.isExpressionTreeUnsafe(n, seenSideEffects)) {
                        seenSideEffects = true;
                        requiresDecomposition = true;
                    }
                    n = this.getNextEvaluatedSibling(n, direction);
                }
                Node first = parent.getFirstChild();
                if (requiresDecomposition && parent.isCall() && NodeUtil.isNormalGet(first)) {
                    if (this.allowMethodCallDecomposing) {
                        return DecompositionType.DECOMPOSABLE;
                    }
                    return DecompositionType.UNDECOMPOSABLE;
                }
            }
            child = parent;
        }
        throw new IllegalStateException("Unexpected.");
    }

    private static EvaluationDirection getEvaluationDirection(Node node) {
        switch (node.getToken()) {
            case DEFAULT_VALUE: 
            case DESTRUCTURING_LHS: 
            case ASSIGN: {
                if (!node.getFirstChild().isDestructuringPattern()) break;
                return EvaluationDirection.REVERSE;
            }
        }
        return EvaluationDirection.FORWARD;
    }

    private Node getFirstEvaluatedChild(Node parent, EvaluationDirection direction) {
        return direction == EvaluationDirection.FORWARD ? parent.getFirstChild() : parent.getLastChild();
    }

    private Node getNextEvaluatedSibling(Node node, EvaluationDirection direction) {
        return direction == EvaluationDirection.FORWARD ? node.getNext() : node.getPrevious();
    }

    private boolean isSafeAssign(Node n, boolean seenSideEffects) {
        if (n.isAssign()) {
            Node lhs = n.getFirstChild();
            switch (lhs.getToken()) {
                case NAME: {
                    return true;
                }
                case GETPROP: {
                    return !this.isExpressionTreeUnsafe(lhs.getFirstChild(), seenSideEffects);
                }
                case GETELEM: {
                    return !this.isExpressionTreeUnsafe(lhs.getFirstChild(), seenSideEffects) && !this.isExpressionTreeUnsafe(lhs.getLastChild(), seenSideEffects);
                }
            }
        }
        return false;
    }

    private boolean isExpressionTreeUnsafe(Node tree, boolean followingSideEffectsExist) {
        if (tree.isSpread() && this.isTempConstantValueName(tree.getOnlyChild())) {
            return false;
        }
        if (followingSideEffectsExist) {
            Node parent = tree.getParent();
            if (NodeUtil.isObjectCallMethod(parent, "call") && tree.isFirstChildOf(parent) && this.isTempConstantValueName(tree.getFirstChild())) {
                return false;
            }
            return NodeUtil.canBeSideEffected(tree, this.knownConstants, this.scope);
        }
        return this.astAnalyzer.mayHaveSideEffects(tree);
    }

    private static enum EvaluationDirection {
        FORWARD,
        REVERSE;

    }

    private static class DecompositionState {
        boolean sideEffects;
        Node extractBeforeStatement;

        private DecompositionState() {
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("sideEffects", this.sideEffects).add("extractBeforeStatement", this.extractBeforeStatement).toString();
        }
    }

    static enum DecompositionType {
        UNDECOMPOSABLE,
        MOVABLE,
        DECOMPOSABLE;

    }
}

