/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AbstractScope;
import com.google.javascript.jscomp.BasicBlock;
import com.google.javascript.jscomp.CollapseProperties;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DestructuringGlobalNameExtractor;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.GlobalNamespace;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Reference;
import com.google.javascript.jscomp.ReferenceCollectingCallback;
import com.google.javascript.jscomp.ReferenceCollection;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.StaticSuperPropReplacer;
import com.google.javascript.jscomp.SyntacticScopeCreator;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.jarjar.com.google.common.annotations.VisibleForTesting;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Preconditions;
import com.google.javascript.jscomp.jarjar.com.google.common.base.Predicates;
import com.google.javascript.jscomp.jarjar.javax.annotation.Nullable;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.Set;

class AggressiveInlineAliases
implements CompilerPass {
    static final DiagnosticType UNSAFE_CTOR_ALIASING = DiagnosticType.warning("JSC_UNSAFE_CTOR_ALIASING", "Variable {0} aliases a constructor, so it cannot be assigned multiple times");
    private final AbstractCompiler compiler;
    private boolean codeChanged;
    private GlobalNamespace namespace;

    AggressiveInlineAliases(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.codeChanged = true;
    }

    @VisibleForTesting
    GlobalNamespace getLastUsedGlobalNamespace() {
        return this.namespace;
    }

    @Override
    public void process(Node externs, Node root) {
        new StaticSuperPropReplacer(this.compiler).replaceAll(root);
        NodeTraversal.traverse(this.compiler, root, new RewriteSimpleDestructuringAliases());
        this.namespace = new GlobalNamespace(this.compiler, root);
        while (this.codeChanged) {
            this.codeChanged = false;
            this.inlineAliases(this.namespace);
        }
    }

    private JSModule getRefModule(Reference ref) {
        CompilerInput input = this.compiler.getInput(ref.getInputId());
        return input == null ? null : input.getModule();
    }

    private void inlineAliases(GlobalNamespace namespace) {
        ArrayDeque<GlobalNamespace.Name> workList = new ArrayDeque<GlobalNamespace.Name>(namespace.getNameForest());
        while (!workList.isEmpty()) {
            GlobalNamespace.Name name = (GlobalNamespace.Name)workList.pop();
            if (name.isGetOrSetDefinition()) continue;
            if (!name.inExterns() && name.getGlobalSets() == 1 && name.getLocalSets() == 0) {
                this.maybeInlineInnerName(name);
                if (name.getAliasingGets() > 0 || name.getSubclassingGets() > 0) {
                    this.inlineAliasesForName(name, namespace);
                }
            }
            AggressiveInlineAliases.maybeAddPropertiesToWorklist(name, workList);
        }
    }

    private void inlineAliasesForName(GlobalNamespace.Name name, GlobalNamespace namespace) {
        ArrayList<GlobalNamespace.Ref> refs = new ArrayList<GlobalNamespace.Ref>(name.getRefs());
        for (GlobalNamespace.Ref ref : refs) {
            Scope hoistScope = (Scope)ref.scope.getClosestHoistScope();
            if (ref.type == GlobalNamespace.Ref.Type.ALIASING_GET && !AggressiveInlineAliases.mayBeGlobalAlias(ref) && ref.getTwin() == null) {
                this.inlineAliasIfPossible(name, ref, namespace);
                continue;
            }
            if (ref.type == GlobalNamespace.Ref.Type.ALIASING_GET && hoistScope.isGlobal() && ref.getTwin() == null) {
                this.inlineGlobalAliasIfPossible(name, ref, namespace);
                continue;
            }
            if (!name.isClass() || ref.type != GlobalNamespace.Ref.Type.SUBCLASSING_GET || name.props == null) continue;
            for (GlobalNamespace.Name prop : name.props) {
                this.rewriteAllSubclassInheritedAccesses(name, ref, prop, namespace);
            }
        }
    }

    private void maybeInlineInnerName(GlobalNamespace.Name globalName) {
        GlobalNamespace.Ref globalNameDeclaration = Preconditions.checkNotNull(globalName.getDeclaration(), globalName);
        Node globalDeclarationNode = Preconditions.checkNotNull(globalNameDeclaration.getNode(), globalNameDeclaration);
        Node valueNode = NodeUtil.getRValueOfLValue(globalDeclarationNode);
        if (valueNode == null) {
            return;
        }
        Node innerNameNode = AggressiveInlineAliases.maybeGetInnerNameNode(valueNode);
        if (innerNameNode == null) {
            return;
        }
        String innerName = innerNameNode.getString();
        SyntacticScopeCreator syntacticScopeCreator = new SyntacticScopeCreator(this.compiler);
        AbstractScope innerScope = syntacticScopeCreator.createScope(valueNode, (AbstractScope)globalNameDeclaration.scope);
        Var innerNameVar = Preconditions.checkNotNull((Var)innerScope.getVar(innerName));
        ReferenceCollectingCallback collector = new ReferenceCollectingCallback(this.compiler, ReferenceCollectingCallback.DO_NOTHING_BEHAVIOR, syntacticScopeCreator, Predicates.equalTo(innerNameVar));
        collector.processScope((Scope)innerScope);
        ReferenceCollection innerNameRefs = collector.getReferences(innerNameVar);
        LinkedHashSet<GlobalNamespace.AstChange> newNodes = new LinkedHashSet<GlobalNamespace.AstChange>();
        for (Reference innerNameRef : innerNameRefs) {
            Node innerNameRefNode = innerNameRef.getNode();
            if (!NodeUtil.isNormalGet(innerNameRefNode.getParent())) continue;
            newNodes.add(this.replaceAliasReference(globalNameDeclaration, innerNameRef));
        }
        this.namespace.scanNewNodes(newNodes);
    }

    @Nullable
    private static Node maybeGetInnerNameNode(Node maybeFunctionOrClassNode) {
        if (NodeUtil.isFunctionExpression(maybeFunctionOrClassNode)) {
            Node nameNode = maybeFunctionOrClassNode.getFirstChild();
            Preconditions.checkState(nameNode.isName(), nameNode);
            return nameNode.getString().isEmpty() ? null : nameNode;
        }
        if (NodeUtil.isClassExpression(maybeFunctionOrClassNode)) {
            Node nameNode = maybeFunctionOrClassNode.getFirstChild();
            return nameNode.isName() ? nameNode : null;
        }
        return null;
    }

    private static void maybeAddPropertiesToWorklist(GlobalNamespace.Name name, Deque<GlobalNamespace.Name> workList) {
        if (!(name.isObjectLiteral() || name.isFunction() || name.isClass())) {
            return;
        }
        if (AggressiveInlineAliases.isUnsafelyReassigned(name)) {
            return;
        }
        if (name.props == null) {
            return;
        }
        if (name.getAliasingGets() == 0) {
            workList.addAll(name.props);
        } else {
            for (GlobalNamespace.Name property : name.props) {
                if (!property.canCollapse()) continue;
                workList.add(property);
            }
        }
    }

    private boolean rewriteAllSubclassInheritedAccesses(GlobalNamespace.Name superclassNameObj, GlobalNamespace.Ref superclassRef, GlobalNamespace.Name prop, GlobalNamespace namespace) {
        if (!prop.canCollapse()) {
            return false;
        }
        Node subclass = AggressiveInlineAliases.getSubclassForEs6Superclass(superclassRef.getNode());
        if (subclass == null || !subclass.isQualifiedName()) {
            return false;
        }
        String subclassName = subclass.getQualifiedName();
        String subclassQualifiedPropName = subclassName + "." + prop.getBaseName();
        GlobalNamespace.Name subclassPropNameObj = namespace.getOwnSlot(subclassQualifiedPropName);
        if (subclassPropNameObj != null && (subclassPropNameObj.getLocalSets() > 0 || subclassPropNameObj.getGlobalSets() > 0)) {
            return false;
        }
        GlobalNamespace.Name subclassNameObj = namespace.getOwnSlot(subclassName);
        if (subclassNameObj != null && subclassNameObj.subclassingGetCount() > 0) {
            for (GlobalNamespace.Ref ref : subclassNameObj.getRefs()) {
                if (ref.type != GlobalNamespace.Ref.Type.SUBCLASSING_GET) continue;
                this.rewriteAllSubclassInheritedAccesses(superclassNameObj, ref, prop, namespace);
            }
        }
        if (subclassPropNameObj != null) {
            LinkedHashSet<GlobalNamespace.AstChange> newNodes = new LinkedHashSet<GlobalNamespace.AstChange>();
            Node superclassNameNode = superclassNameObj.getDeclaration().getNode();
            if (superclassNameNode.isName()) {
                superclassNameNode = superclassNameNode.cloneNode();
            } else if (superclassNameNode.isGetProp()) {
                superclassNameNode = superclassNameNode.cloneTree();
            } else {
                return false;
            }
            this.rewriteNestedAliasReference(superclassNameNode, 0, newNodes, subclassPropNameObj);
            namespace.scanNewNodes(newNodes);
        }
        return true;
    }

    private static boolean mayBeGlobalAlias(GlobalNamespace.Ref alias) {
        Node aliasLhsNode;
        if (alias.scope.isGlobal()) {
            return true;
        }
        Node aliasParent = alias.getNode().getParent();
        if (!aliasParent.isAssign() && !aliasParent.isName()) {
            return true;
        }
        Node node = aliasLhsNode = aliasParent.isName() ? aliasParent : aliasParent.getFirstChild();
        if (!aliasLhsNode.isName()) {
            return true;
        }
        String aliasVarName = aliasLhsNode.getString();
        Var aliasVar = (Var)alias.scope.getVar(aliasVarName);
        if (aliasVar != null) {
            return aliasVar.isGlobal();
        }
        return true;
    }

    private void inlineAliasIfPossible(GlobalNamespace.Name name, GlobalNamespace.Ref alias, GlobalNamespace namespace) {
        Node aliasParent = alias.getNode().getParent();
        if (aliasParent.isName() || aliasParent.isAssign()) {
            Node aliasLhsNode = aliasParent.isName() ? aliasParent : aliasParent.getFirstChild();
            String aliasVarName = aliasLhsNode.getString();
            Var aliasVar = (Var)alias.scope.getVar(aliasVarName);
            Preconditions.checkState(aliasVar != null, "Expected variable to be defined in scope", (Object)aliasVarName);
            ReferenceCollectingCallback collector = new ReferenceCollectingCallback(this.compiler, ReferenceCollectingCallback.DO_NOTHING_BEHAVIOR, new SyntacticScopeCreator(this.compiler), Predicates.equalTo(aliasVar));
            Scope aliasScope = (Scope)aliasVar.getScope();
            collector.processScope(aliasScope);
            ReferenceCollection aliasRefs = collector.getReferences(aliasVar);
            LinkedHashSet<GlobalNamespace.AstChange> newNodes = new LinkedHashSet<GlobalNamespace.AstChange>();
            if (aliasRefs.isWellDefined() && aliasRefs.isAssignedOnceInLifetime()) {
                int firstRead;
                int size = aliasRefs.references.size();
                for (int i = firstRead = aliasRefs.references.get(0).isInitializingDeclaration() ? 1 : 2; i < size; ++i) {
                    Reference aliasRef = aliasRefs.references.get(i);
                    newNodes.add(this.replaceAliasReference(alias, aliasRef));
                }
                this.tryReplacingAliasingAssignment(alias, aliasLhsNode);
                namespace.scanNewNodes(newNodes);
                return;
            }
            if (name.isConstructor() && !this.partiallyInlineAlias(alias, namespace, aliasRefs, aliasLhsNode) && AggressiveInlineAliases.referencesCollapsibleProperty(aliasRefs, name, namespace)) {
                this.compiler.report(JSError.make(aliasParent, UNSAFE_CTOR_ALIASING, aliasVarName));
            }
        }
    }

    private boolean partiallyInlineAlias(GlobalNamespace.Ref alias, GlobalNamespace namespace, ReferenceCollection aliasRefs, Node aliasLhsNode) {
        BasicBlock aliasBlock = null;
        for (Reference aliasRef : aliasRefs) {
            Node aliasRefNode = aliasRef.getNode();
            if (aliasRefNode == aliasLhsNode) {
                aliasBlock = aliasRef.getBasicBlock();
                continue;
            }
            if (!aliasRef.isLvalue()) continue;
            return false;
        }
        LinkedHashSet<GlobalNamespace.AstChange> newNodes = new LinkedHashSet<GlobalNamespace.AstChange>();
        boolean alreadySeenInitialAlias = false;
        boolean foundNonReplaceableAlias = false;
        for (Reference aliasRef : aliasRefs) {
            Node aliasRefNode = aliasRef.getNode();
            if (aliasRefNode == aliasLhsNode) {
                alreadySeenInitialAlias = true;
                continue;
            }
            if (aliasRef.isDeclaration()) continue;
            BasicBlock refBlock = aliasRef.getBasicBlock();
            if (refBlock != aliasBlock && aliasBlock.provablyExecutesBefore(refBlock) || refBlock == aliasBlock && alreadySeenInitialAlias) {
                this.codeChanged = true;
                newNodes.add(this.replaceAliasReference(alias, aliasRef));
                continue;
            }
            foundNonReplaceableAlias = true;
        }
        if (!foundNonReplaceableAlias) {
            this.tryReplacingAliasingAssignment(alias, aliasLhsNode);
        }
        if (this.codeChanged) {
            namespace.scanNewNodes(newNodes);
        }
        return !foundNonReplaceableAlias;
    }

    private boolean tryReplacingAliasingAssignment(GlobalNamespace.Ref alias, Node aliasLhsNode) {
        Node assignment = aliasLhsNode.getParent();
        if (!NodeUtil.isNameDeclaration(assignment) && NodeUtil.isExpressionResultUsed(assignment)) {
            return false;
        }
        Node aliasParent = alias.getNode().getParent();
        aliasParent.replaceChild(alias.getNode(), IR.nullNode());
        alias.name.removeRef(alias);
        this.codeChanged = true;
        this.compiler.reportChangeToEnclosingScope(aliasParent);
        return true;
    }

    private static boolean referencesCollapsibleProperty(ReferenceCollection aliasRefs, GlobalNamespace.Name aliasedName, GlobalNamespace namespace) {
        for (Reference ref : aliasRefs.references) {
            if (ref.getParent() == null || !ref.getParent().isGetProp()) continue;
            Node propertyNode = ref.getNode().getNext();
            String propertyName = propertyNode.getString();
            String originalPropertyName = aliasedName.getName() + "." + propertyName;
            GlobalNamespace.Name originalProperty = namespace.getOwnSlot(originalPropertyName);
            if (originalProperty == null || !originalProperty.canCollapse()) continue;
            return true;
        }
        return false;
    }

    private GlobalNamespace.AstChange replaceAliasReference(GlobalNamespace.Ref alias, Reference aliasRef) {
        Node originalRefNode = alias.getNode();
        Node nodeToReplace = aliasRef.getNode();
        Preconditions.checkState(nodeToReplace.isQualifiedName(), nodeToReplace);
        Node newNode = originalRefNode.isName() ? originalRefNode.cloneNode() : originalRefNode.cloneTree();
        newNode.srcrefTree(nodeToReplace);
        aliasRef.getParent().replaceChild(nodeToReplace, newNode);
        this.compiler.reportChangeToEnclosingScope(newNode);
        return new GlobalNamespace.AstChange(this.getRefModule(aliasRef), aliasRef.getScope(), newNode);
    }

    private void inlineGlobalAliasIfPossible(GlobalNamespace.Name name, GlobalNamespace.Ref alias, GlobalNamespace namespace) {
        Node aliasParent = alias.getNode().getParent();
        if ((aliasParent.isAssign() || aliasParent.isName()) && NodeUtil.isExecutedExactlyOnce(aliasParent) || aliasParent.isName() && name.isConstructor()) {
            Node lvalue;
            Node node = lvalue = aliasParent.isName() ? aliasParent : aliasParent.getFirstChild();
            if (!lvalue.isQualifiedName()) {
                return;
            }
            if (lvalue.isName() && this.compiler.getCodingConvention().isExported(lvalue.getString(), false)) {
                return;
            }
            GlobalNamespace.Name aliasingName = namespace.getSlot(lvalue.getQualifiedName());
            if (aliasingName == null) {
                return;
            }
            if (name.equals(aliasingName) && aliasParent.isAssign()) {
                return;
            }
            GlobalNamespace.Inlinability aliasInlinability = aliasingName.calculateInlinability();
            if (!aliasInlinability.shouldInlineUsages()) {
                return;
            }
            LinkedHashSet<GlobalNamespace.AstChange> newNodes = new LinkedHashSet<GlobalNamespace.AstChange>();
            this.rewriteAliasReferences(aliasingName, alias, newNodes);
            this.rewriteAliasProps(aliasingName, alias.getNode(), 0, newNodes);
            if (aliasInlinability.shouldRemoveDeclaration()) {
                GlobalNamespace.Ref aliasDeclaration = aliasingName.getDeclaration();
                if (aliasDeclaration.getTwin() != null) {
                    Preconditions.checkState(aliasParent.isAssign(), aliasParent);
                    Node aliasGrandparent = aliasParent.getParent();
                    aliasParent.replaceWith(alias.getNode().detach());
                    aliasingName.removeTwinRefs(aliasDeclaration);
                    newNodes.add(new GlobalNamespace.AstChange(alias.module, alias.scope, alias.getNode()));
                    this.compiler.reportChangeToEnclosingScope(aliasGrandparent);
                } else {
                    aliasParent.replaceChild(alias.getNode(), IR.nullNode());
                    this.compiler.reportChangeToEnclosingScope(aliasParent);
                }
                this.codeChanged = true;
                name.removeRef(alias);
            }
            namespace.scanNewNodes(newNodes);
        }
    }

    private void rewriteAliasReferences(GlobalNamespace.Name aliasingName, GlobalNamespace.Ref aliasingRef, Set<GlobalNamespace.AstChange> newNodes) {
        ArrayList<GlobalNamespace.Ref> refs = new ArrayList<GlobalNamespace.Ref>(aliasingName.getRefs());
        block4: for (GlobalNamespace.Ref ref : refs) {
            switch (ref.type) {
                case SET_FROM_GLOBAL: {
                    continue block4;
                }
                case DIRECT_GET: 
                case ALIASING_GET: 
                case PROTOTYPE_GET: 
                case CALL_GET: 
                case SUBCLASSING_GET: {
                    if (ref.getTwin() != null) {
                        Preconditions.checkState(ref.type == GlobalNamespace.Ref.Type.ALIASING_GET, ref);
                        continue block4;
                    }
                    if (ref.getNode().isStringKey()) {
                        DestructuringGlobalNameExtractor.reassignDestructringLvalue(ref.getNode(), aliasingRef.getNode().cloneTree(), newNodes, ref, this.compiler);
                    } else {
                        Preconditions.checkState(ref.getNode().isGetProp() || ref.getNode().isName());
                        Node newNode = aliasingRef.getNode().cloneTree();
                        Node node = ref.getNode();
                        node.replaceWith(newNode);
                        this.compiler.reportChangeToEnclosingScope(newNode);
                        newNodes.add(new GlobalNamespace.AstChange(ref.module, ref.scope, newNode));
                    }
                    aliasingName.removeRef(ref);
                    continue block4;
                }
            }
            throw new IllegalStateException();
        }
    }

    private static boolean isUnsafelyReassigned(GlobalNamespace.Name name) {
        boolean foundOriginalDefinition = false;
        for (GlobalNamespace.Ref ref : name.getRefs()) {
            if (!ref.isSet() || CollapseProperties.isSafeNamespaceReinit(ref)) continue;
            if (!foundOriginalDefinition) {
                foundOriginalDefinition = true;
                continue;
            }
            return true;
        }
        return false;
    }

    private void rewriteAliasProps(GlobalNamespace.Name name, Node value, int depth, Set<GlobalNamespace.AstChange> newNodes) {
        if (name.props == null) {
            return;
        }
        Preconditions.checkState(!value.matchesQualifiedName(name.getFullName()), "%s should not match name %s", (Object)value, (Object)name.getFullName());
        for (GlobalNamespace.Name prop : name.props) {
            this.rewriteNestedAliasReference(value, depth, newNodes, prop);
        }
    }

    private void rewriteNestedAliasReference(Node value, int depth, Set<GlobalNamespace.AstChange> newNodes, GlobalNamespace.Name prop) {
        this.rewriteAliasProps(prop, value, depth + 1, newNodes);
        ArrayList<GlobalNamespace.Ref> refs = new ArrayList<GlobalNamespace.Ref>(prop.getRefs());
        for (GlobalNamespace.Ref ref : refs) {
            Node target = ref.getNode();
            if (target.isStringKey() && target.getParent().isDestructuringPattern()) {
                Preconditions.checkState(target.getGrandparent().isAssign() || target.getGrandparent().isDestructuringLhs(), "Did not expect GlobalNamespace to create Ref for key in nested object pattern %s", (Object)target);
                continue;
            }
            for (int i = 0; i <= depth; ++i) {
                if (target.isGetProp()) {
                    target = target.getFirstChild();
                    continue;
                }
                if (NodeUtil.isObjectLitKey(target)) {
                    Node gparent = target.getGrandparent();
                    if (gparent.isAssign()) {
                        target = gparent.getFirstChild();
                        continue;
                    }
                    Preconditions.checkState(NodeUtil.isObjectLitKey(gparent));
                    target = gparent;
                    continue;
                }
                throw new IllegalStateException("unexpected node: " + target);
            }
            Preconditions.checkState(target.isGetProp() || target.isName());
            Node newValue = value.cloneTree();
            target.replaceWith(newValue);
            this.compiler.reportChangeToEnclosingScope(newValue);
            prop.removeRef(ref);
            newNodes.add(new GlobalNamespace.AstChange(ref.module, ref.scope, ref.getNode()));
            this.codeChanged = true;
        }
    }

    @Nullable
    private static Node getSubclassForEs6Superclass(Node superclass) {
        Node classNode = superclass.getParent();
        Preconditions.checkArgument(classNode.isClass(), classNode);
        if (NodeUtil.isNameDeclaration(classNode.getGrandparent())) {
            return classNode.getParent();
        }
        if (superclass.getGrandparent().isAssign()) {
            return classNode.getPrevious();
        }
        if (NodeUtil.isClassDeclaration(classNode)) {
            return classNode.getFirstChild();
        }
        return null;
    }

    private static class RewriteSimpleDestructuringAliases
    extends NodeTraversal.AbstractPostOrderCallback {
        private RewriteSimpleDestructuringAliases() {
        }

        public boolean isSimpleDestructuringAlias(Node n) {
            if (!NodeUtil.isStatement(n) || !n.isConst()) {
                return false;
            }
            Preconditions.checkState(n.hasOneChild());
            Node destructuringLhs = n.getFirstChild();
            if (!destructuringLhs.isDestructuringLhs()) {
                return false;
            }
            Node objectPattern = destructuringLhs.getFirstChild();
            if (!objectPattern.isObjectPattern()) {
                return false;
            }
            Node rhs = destructuringLhs.getLastChild();
            if (!rhs.isQualifiedName()) {
                return false;
            }
            for (Node key : objectPattern.children()) {
                if (!key.isStringKey() || key.isQuotedString()) {
                    return false;
                }
                Preconditions.checkState(key.hasOneChild());
                Node identifier = key.getFirstChild();
                if (identifier.isName()) continue;
                return false;
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (!this.isSimpleDestructuringAlias(n)) {
                return;
            }
            Node insertionPoint = n;
            Node destructuringLhs = n.getFirstChild();
            Node objectPattern = destructuringLhs.getFirstChild();
            Node rhs = destructuringLhs.getLastChild();
            for (Node key : objectPattern.children()) {
                Node identifier = key.getFirstChild();
                Node newRhs = IR.getprop(rhs.cloneTree(), IR.string(key.getString()).srcref(key)).srcref(identifier);
                Node newConstNode = IR.constNode(identifier.detach(), newRhs).srcref(n);
                insertionPoint.getParent().addChildAfter(newConstNode, insertionPoint);
                insertionPoint = newConstNode;
            }
            n.detach();
            t.reportCodeChange();
        }
    }
}

