/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.javascript.rhino.jstype.EquivalenceMethod;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.TemplateType;
import com.google.javascript.rhino.jstype.TemplateTypeMapReplacer;
import java.io.Serializable;
import java.util.Set;

public class TemplateTypeMap
implements Serializable {
    private final ImmutableList<TemplateType> templateKeys;
    private final ImmutableList<JSType> templateValues;
    private final JSType[] resolvedTemplateValues;
    private boolean inRecursiveEquivalenceCheck = false;
    final JSTypeRegistry registry;

    TemplateTypeMap(JSTypeRegistry registry, ImmutableList<TemplateType> templateKeys, ImmutableList<JSType> templateValues) {
        Preconditions.checkNotNull(templateKeys);
        Preconditions.checkNotNull(templateValues);
        Preconditions.checkArgument(templateValues.size() <= templateKeys.size());
        this.registry = registry;
        this.templateKeys = templateKeys;
        this.templateValues = templateValues;
        TemplateTypeMapReplacer replacer = new TemplateTypeMapReplacer(registry, this, true);
        int nValues = this.templateValues.size();
        int nKeys = this.templateKeys.size();
        JSType[] resolvedValues = new JSType[nKeys];
        for (int i = 0; i < nKeys; ++i) {
            if (i < nValues) {
                TemplateType templateKey = (TemplateType)this.templateKeys.get(i);
                replacer.setKeyType(templateKey);
                JSType templateValue = (JSType)this.templateValues.get(i);
                resolvedValues[i] = templateValue.visit(replacer);
                continue;
            }
            resolvedValues[i] = registry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        this.resolvedTemplateValues = resolvedValues;
    }

    public boolean isEmpty() {
        return this.templateKeys.isEmpty();
    }

    public ImmutableList<TemplateType> getTemplateKeys() {
        return this.templateKeys;
    }

    public boolean hasTemplateKey(TemplateType templateKey) {
        for (TemplateType entry : this.templateKeys) {
            if (entry != templateKey) continue;
            return true;
        }
        return false;
    }

    int numUnfilledTemplateKeys() {
        return this.templateKeys.size() - this.templateValues.size();
    }

    boolean isFull() {
        return this.numUnfilledTemplateKeys() == 0;
    }

    boolean isPartiallyFull() {
        return !this.templateValues.isEmpty();
    }

    ImmutableList<TemplateType> getUnfilledTemplateKeys() {
        return this.templateKeys.subList(this.templateValues.size(), this.templateKeys.size());
    }

    public boolean hasTemplateType(TemplateType key) {
        return this.getTemplateTypeIndex(key) != -1;
    }

    JSType getUnresolvedOriginalTemplateType(TemplateType key) {
        int index = this.getTemplateTypeIndex(key);
        return index == -1 ? this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE) : (JSType)this.templateValues.get(index);
    }

    public TemplateType getTemplateTypeKeyByName(String keyName) {
        for (TemplateType key : this.templateKeys) {
            if (!key.getReferenceName().equals(keyName)) continue;
            return key;
        }
        return null;
    }

    private int getTemplateTypeIndex(TemplateType key) {
        int maxIndex = Math.min(this.templateKeys.size(), this.templateValues.size());
        for (int i = maxIndex - 1; i >= 0; --i) {
            if (!TemplateTypeMap.isSameKey((TemplateType)this.templateKeys.get(i), key)) continue;
            return i;
        }
        return -1;
    }

    public JSType getResolvedTemplateType(TemplateType key) {
        int index = this.getTemplateTypeIndex(key);
        return index == -1 ? this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE) : this.resolvedTemplateValues[index];
    }

    public boolean checkEquivalenceHelper(TemplateTypeMap that, EquivalenceMethod eqMethod, JSType.SubtypingMode subtypingMode) {
        return this.checkEquivalenceHelper(that, eqMethod, JSType.EqCache.create(), subtypingMode);
    }

    public boolean checkEquivalenceHelper(TemplateTypeMap that, EquivalenceMethod eqMethod, JSType.EqCache eqCache, JSType.SubtypingMode subtypingMode) {
        boolean result = false;
        if (!this.inRecursiveEquivalenceCheck && !that.inRecursiveEquivalenceCheck) {
            this.inRecursiveEquivalenceCheck = true;
            that.inRecursiveEquivalenceCheck = true;
            result = TemplateTypeMap.checkEquivalenceHelper(eqMethod, this, that, eqCache, subtypingMode) && TemplateTypeMap.checkEquivalenceHelper(eqMethod, that, this, eqCache, subtypingMode);
            this.inRecursiveEquivalenceCheck = false;
            that.inRecursiveEquivalenceCheck = false;
        }
        return result;
    }

    private static boolean isSameKey(TemplateType thisKey, TemplateType thatKey) {
        return thisKey == thatKey;
    }

    private static boolean checkEquivalenceHelper(EquivalenceMethod eqMethod, TemplateTypeMap thisMap, TemplateTypeMap thatMap, JSType.EqCache eqCache, JSType.SubtypingMode subtypingMode) {
        ImmutableList<TemplateType> thisKeys = thisMap.getTemplateKeys();
        ImmutableList<TemplateType> thatKeys = thatMap.getTemplateKeys();
        for (int i = 0; i < thisKeys.size(); ++i) {
            TemplateType thisKey = (TemplateType)thisKeys.get(i);
            JSType thisType = thisMap.getResolvedTemplateType(thisKey);
            EquivalenceMatch thisMatch = EquivalenceMatch.NO_KEY_MATCH;
            for (int j = 0; j < thatKeys.size(); ++j) {
                TemplateType thatKey = (TemplateType)thatKeys.get(j);
                JSType thatType = thatMap.getResolvedTemplateType(thatKey);
                if (!TemplateTypeMap.isSameKey(thisKey, thatKey)) continue;
                EquivalenceMatch newMatchType = EquivalenceMatch.VALUE_MISMATCH;
                if (thisType.checkEquivalenceHelper(thatType, eqMethod, eqCache) || subtypingMode == JSType.SubtypingMode.IGNORE_NULL_UNDEFINED && thisType.isSubtype(thatType, subtypingMode) && thatType.isSubtype(thatType, subtypingMode)) {
                    newMatchType = EquivalenceMatch.VALUE_MATCH;
                }
                if (thisMatch == EquivalenceMatch.VALUE_MATCH) continue;
                thisMatch = newMatchType;
            }
            if (!TemplateTypeMap.failedEquivalenceCheck(thisMatch, eqMethod)) continue;
            return false;
        }
        return true;
    }

    private static boolean failedEquivalenceCheck(EquivalenceMatch eqMatch, EquivalenceMethod eqMethod) {
        return eqMatch == EquivalenceMatch.VALUE_MISMATCH || eqMatch == EquivalenceMatch.NO_KEY_MATCH && eqMethod != EquivalenceMethod.INVARIANT;
    }

    private ImmutableList<JSType> normalize(ImmutableList<JSType> values, int keyCount) {
        int missing = keyCount - values.size();
        if (missing > 0) {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll(values);
            for (int i = 0; i < missing; ++i) {
                builder.add(this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE));
            }
            return builder.build();
        }
        return values;
    }

    TemplateTypeMap extend(TemplateTypeMap thatMap) {
        ImmutableList<JSType> thatNormalizedValues = this.normalize(thatMap.templateValues, thatMap.templateKeys.size());
        return this.registry.createTemplateTypeMap(this.concatImmutableLists(thatMap.templateKeys, this.templateKeys), this.concatImmutableLists(thatNormalizedValues, this.templateValues));
    }

    TemplateTypeMap addValues(ImmutableList<JSType> newValues) {
        int numUnfilledKeys = this.numUnfilledTemplateKeys();
        if (numUnfilledKeys < newValues.size()) {
            newValues = newValues.subList(0, numUnfilledKeys);
        }
        return this.registry.createTemplateTypeMap(this.templateKeys, this.concatImmutableLists((ImmutableList)this.templateValues, (ImmutableList)newValues));
    }

    TemplateTypeMap remove(Set<TemplateType> toRemove) {
        ImmutableList.Builder keys = ImmutableList.builder();
        keys.addAll((Iterable)this.templateKeys.subList(0, this.templateValues.size()));
        for (int i = this.templateValues.size(); i < this.templateKeys.size(); ++i) {
            TemplateType key = (TemplateType)this.templateKeys.get(i);
            if (toRemove.contains(key)) continue;
            keys.add(key);
        }
        return this.registry.createTemplateTypeMap((ImmutableList<TemplateType>)keys.build(), this.templateValues);
    }

    private <T> ImmutableList<T> concatImmutableLists(ImmutableList<T> first, ImmutableList<T> second) {
        if (first.isEmpty()) {
            return second;
        }
        if (second.isEmpty()) {
            return first;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(first);
        builder.addAll(second);
        return builder.build();
    }

    boolean hasAnyTemplateTypesInternal() {
        if (this.resolvedTemplateValues != null) {
            for (JSType templateValue : this.resolvedTemplateValues) {
                if (!templateValue.hasAnyTemplateTypes()) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        String s = "";
        int len = this.templateKeys.size();
        s = s + "{ ";
        for (int i = 0; i < len; ++i) {
            s = s + "(";
            s = s + this.templateKeys.get(i);
            s = s + ",";
            s = s + (i < this.templateValues.size() ? (Serializable)this.templateValues.get(i) : "");
            s = s + ",";
            s = s + (this.resolvedTemplateValues != null && i < this.resolvedTemplateValues.length ? this.resolvedTemplateValues[i] : "");
            s = s + ") ";
        }
        s = s + "}";
        return s;
    }

    private static enum EquivalenceMatch {
        NO_KEY_MATCH,
        VALUE_MISMATCH,
        VALUE_MATCH;

    }
}

