/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.lint;

import com.google.common.base.Joiner;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.Node;
import java.util.NavigableSet;
import java.util.TreeSet;

public final class CheckEs6ModuleFileStructure
extends NodeTraversal.AbstractPreOrderCallback
implements CompilerPass {
    public static final DiagnosticType MUST_COME_BEFORE = DiagnosticType.warning("JSC_MUST_COME_BEFORE_IN_ES6_MODULE", "In ES6 modules, {0} should come before {1}.");
    private final AbstractCompiler compiler;
    private final TreeSet<OrderedStatement> orderedStatements = new TreeSet();

    public CheckEs6ModuleFileStructure(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case ROOT: {
                return true;
            }
            case SCRIPT: {
                return n.getBooleanProp((byte)99);
            }
            case MODULE_BODY: {
                this.orderedStatements.clear();
                return true;
            }
            case IMPORT: {
                this.visitImport(t, n);
                return false;
            }
            case EXPR_RESULT: {
                return this.visitExprResult(t, n, parent);
            }
            case VAR: 
            case LET: 
            case CONST: {
                return this.visitDeclaration(t, n, parent);
            }
        }
        if (parent != null && parent.isModuleBody()) {
            this.checkOrder(t, n, OrderedStatement.OTHER);
        }
        return false;
    }

    private void checkOrder(NodeTraversal t, Node n, OrderedStatement statement) {
        this.orderedStatements.add(statement);
        NavigableSet<OrderedStatement> outOfOrder = this.orderedStatements.tailSet(statement, false);
        if (!outOfOrder.isEmpty()) {
            t.report(n, MUST_COME_BEFORE, statement.toString(), Joiner.on(", ").join(outOfOrder));
        }
    }

    private boolean visitExprResult(NodeTraversal t, Node exprResult, Node parent) {
        if (parent.isModuleBody() && exprResult.getFirstChild().isCall()) {
            Node call = exprResult.getFirstChild();
            if (call.getFirstChild().matchesQualifiedName("goog.module.declareNamespace")) {
                this.checkOrder(t, call, OrderedStatement.DECLARE_NAMESPACE);
                return false;
            }
            if (call.getFirstChild().matchesQualifiedName("goog.require")) {
                this.checkOrder(t, call, OrderedStatement.GOOG_REQUIRE);
                return false;
            }
        }
        this.checkOrder(t, exprResult, OrderedStatement.OTHER);
        return true;
    }

    private boolean visitDeclaration(NodeTraversal t, Node declaration, Node parent) {
        Node call;
        if (parent.isModuleBody() && declaration.hasOneChild() && declaration.getFirstChild().hasOneChild() && declaration.getFirstFirstChild().isCall() && (call = declaration.getFirstFirstChild()).getFirstChild().matchesQualifiedName("goog.require")) {
            this.checkOrder(t, call, OrderedStatement.GOOG_REQUIRE);
            return false;
        }
        this.checkOrder(t, declaration, OrderedStatement.OTHER);
        return true;
    }

    private void visitImport(NodeTraversal t, Node importNode) {
        this.checkOrder(t, importNode, OrderedStatement.IMPORT);
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    private static enum OrderedStatement {
        IMPORT("import statements"),
        DECLARE_NAMESPACE("a call to goog.module.declareNamespace()"),
        GOOG_REQUIRE("calls to goog.require()"),
        OTHER("other statements");

        final String description;

        private OrderedStatement(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }
}

