/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AbstractScope;
import com.google.javascript.jscomp.AbstractVar;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.Es6SyntacticScopeCreator;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.JSType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

class RemoveUnusedCode
implements CompilerPass {
    private static final ImmutableSet<String> IMPLICITLY_USED_PROPERTIES = ImmutableSet.of("length", "toString", "valueOf", "constructor");
    private final AbstractCompiler compiler;
    private final CodingConvention codingConvention;
    private final boolean removeLocalVars;
    private final boolean removeGlobals;
    private final boolean preserveFunctionExpressionNames;
    private final Deque<Continuation> worklist = new ArrayDeque<Continuation>();
    private final Map<Var, VarInfo> varInfoMap = new HashMap<Var, VarInfo>();
    private final Set<String> referencedPropertyNames = new HashSet<String>(IMPLICITLY_USED_PROPERTIES);
    private final Multimap<String, Removable> removablesForPropertyNames = HashMultimap.create();
    private final VarInfo canonicalUnremovableVarInfo;
    private final List<Scope> allFunctionParamScopes = new ArrayList<Scope>();
    private final Es6SyntacticScopeCreator scopeCreator;
    private final boolean removeUnusedPrototypeProperties;
    private final boolean allowRemovalOfExternProperties;
    private final boolean removeUnusedThisProperties;
    private final boolean removeUnusedStaticProperties;
    private final boolean removeUnusedObjectDefinePropertiesDefinitions;

    RemoveUnusedCode(Builder builder) {
        this.compiler = builder.compiler;
        this.codingConvention = builder.compiler.getCodingConvention();
        this.removeLocalVars = builder.removeLocalVars;
        this.removeGlobals = builder.removeGlobals;
        this.preserveFunctionExpressionNames = builder.preserveFunctionExpressionNames;
        this.removeUnusedPrototypeProperties = builder.removeUnusedPrototypeProperties;
        this.allowRemovalOfExternProperties = builder.allowRemovalOfExternProperties;
        this.removeUnusedThisProperties = builder.removeUnusedThisProperties;
        this.removeUnusedStaticProperties = builder.removeUnusedStaticProperties;
        this.removeUnusedObjectDefinePropertiesDefinitions = builder.removeUnusedObjectDefinePropertiesDefinitions;
        this.scopeCreator = new Es6SyntacticScopeCreator(builder.compiler);
        this.canonicalUnremovableVarInfo = new VarInfo();
        this.canonicalUnremovableVarInfo.setIsExplicitlyNotRemovable();
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkState(this.compiler.getLifeCycleStage().isNormalized());
        if (!this.allowRemovalOfExternProperties) {
            this.referencedPropertyNames.addAll(this.compiler.getExternProperties());
        }
        this.traverseAndRemoveUnusedReferences(root);
    }

    private void traverseAndRemoveUnusedReferences(Node root) {
        AbstractScope scope = this.scopeCreator.createScope(root.getParent(), (AbstractScope)null);
        if (!scope.hasSlot("JSCompiler_renameProperty")) {
            ((Scope)scope).declare("JSCompiler_renameProperty", null, null);
        }
        this.worklist.add(new Continuation(root, (Scope)scope));
        while (!this.worklist.isEmpty()) {
            Continuation continuation = this.worklist.remove();
            continuation.apply();
        }
        this.removeUnreferencedVars();
        this.removeIndependentlyRemovableProperties();
        for (Scope fparamScope : this.allFunctionParamScopes) {
            this.removeUnreferencedFunctionArgs(fparamScope);
        }
    }

    private void removeIndependentlyRemovableProperties() {
        for (Removable removable : this.removablesForPropertyNames.values()) {
            removable.remove(this.compiler);
        }
    }

    private void traverseNode(Node n, Scope scope) {
        Node parent = n.getParent();
        Token type = n.getToken();
        switch (type) {
            case CATCH: {
                this.traverseCatch(n, scope);
                break;
            }
            case FUNCTION: {
                VarInfo varInfo = null;
                if (NodeUtil.isFunctionDeclaration(n)) {
                    varInfo = this.traverseNameNode(n.getFirstChild(), scope);
                    FunctionDeclaration functionDeclaration = new RemovableBuilder().addContinuation(new Continuation(n, scope)).buildFunctionDeclaration(n);
                    varInfo.addRemovable(functionDeclaration);
                    if (!parent.isExport()) break;
                    varInfo.markAsReferenced();
                    break;
                }
                this.traverseFunction(n, scope);
                break;
            }
            case ASSIGN: {
                this.traverseAssign(n, scope);
                break;
            }
            case ASSIGN_BITOR: 
            case ASSIGN_BITXOR: 
            case ASSIGN_BITAND: 
            case ASSIGN_LSH: 
            case ASSIGN_RSH: 
            case ASSIGN_URSH: 
            case ASSIGN_ADD: 
            case ASSIGN_SUB: 
            case ASSIGN_MUL: 
            case ASSIGN_EXPONENT: 
            case ASSIGN_DIV: 
            case ASSIGN_MOD: {
                this.traverseCompoundAssign(n, scope);
                break;
            }
            case INC: 
            case DEC: {
                this.traverseIncrementOrDecrementOp(n, scope);
                break;
            }
            case CALL: {
                this.traverseCall(n, scope);
                break;
            }
            case SWITCH: 
            case BLOCK: {
                this.traverseChildren(n, (Scope)(NodeUtil.createsBlockScope(n) ? this.scopeCreator.createScope(n, (AbstractScope)scope) : scope));
                break;
            }
            case MODULE_BODY: {
                this.traverseChildren(n, (Scope)this.scopeCreator.createScope(n, (AbstractScope)scope));
                break;
            }
            case CLASS: {
                this.traverseClass(n, scope);
                break;
            }
            case CLASS_MEMBERS: {
                this.traverseClassMembers(n, scope);
                break;
            }
            case DEFAULT_VALUE: {
                this.traverseDefaultValue(n, scope);
                break;
            }
            case REST: {
                this.traverseRest(n, scope);
                break;
            }
            case ARRAY_PATTERN: {
                this.traverseArrayPattern(n, scope);
                break;
            }
            case OBJECT_PATTERN: {
                this.traverseObjectPattern(n, scope);
                break;
            }
            case OBJECTLIT: {
                this.traverseObjectLiteral(n, scope);
                break;
            }
            case FOR: {
                this.traverseVanillaFor(n, scope);
                break;
            }
            case FOR_IN: 
            case FOR_OF: {
                this.traverseEnhancedFor(n, scope);
                break;
            }
            case LET: 
            case CONST: 
            case VAR: {
                Preconditions.checkState(NodeUtil.isStatement(n));
                this.traverseDeclarationStatement(n, scope);
                break;
            }
            case INSTANCEOF: {
                this.traverseInstanceof(n, scope);
                break;
            }
            case NAME: {
                Preconditions.checkState(!n.hasChildren());
                if (parent.isParamList()) break;
                Preconditions.checkState(!NodeUtil.isNameDeclaration(parent));
                Preconditions.checkState(!parent.isFunction() && !parent.isClass() || parent.getFirstChild() != n);
                this.traverseNameNode(n, scope).markAsReferenced();
                break;
            }
            case GETPROP: {
                this.traverseGetProp(n, scope);
                break;
            }
            default: {
                this.traverseChildren(n, scope);
            }
        }
    }

    private void traverseInstanceof(Node instanceofNode, Scope scope) {
        Preconditions.checkArgument(instanceofNode.isInstanceOf(), instanceofNode);
        Node lhs = instanceofNode.getFirstChild();
        Node rhs = lhs.getNext();
        this.traverseNode(lhs, scope);
        if (rhs.isName()) {
            VarInfo varInfo = this.traverseNameNode(rhs, scope);
            RemovableBuilder builder = new RemovableBuilder();
            varInfo.addRemovable(builder.buildInstanceofName(instanceofNode));
        } else {
            this.traverseNode(rhs, scope);
        }
    }

    private void traverseGetProp(Node getProp, Scope scope) {
        Node objectNode = getProp.getFirstChild();
        Node propertyNameNode = objectNode.getNext();
        String propertyName = propertyNameNode.getString();
        if (NodeUtil.isExpressionResultUsed(getProp)) {
            this.markPropertyNameReferenced(propertyName);
            this.traverseNode(objectNode, scope);
        } else if (objectNode.isThis()) {
            RemovableBuilder builder = new RemovableBuilder().setIsThisDotPropertyReference(true);
            this.considerForIndependentRemoval(builder.buildUnusedReadReference(getProp, propertyNameNode));
        } else if (RemoveUnusedCode.isDotPrototype(objectNode)) {
            RemovableBuilder builder = new RemovableBuilder().setIsPrototypeDotPropertyReference(true);
            Node objExpression = objectNode.getFirstChild();
            if (objExpression.isName()) {
                VarInfo varInfo = this.traverseNameNode(objExpression, scope);
                varInfo.addRemovable(builder.buildUnusedReadReference(getProp, propertyNameNode));
            } else {
                if (NodeUtil.mayHaveSideEffects(objExpression)) {
                    this.traverseNode(objExpression, scope);
                } else {
                    builder.addContinuation(new Continuation(objExpression, scope));
                }
                this.considerForIndependentRemoval(builder.buildUnusedReadReference(getProp, propertyNameNode));
            }
        } else {
            this.markPropertyNameReferenced(propertyName);
            this.traverseNode(objectNode, scope);
        }
    }

    private void traverseIncrementOrDecrementOp(Node incOrDecOp, Scope scope) {
        Preconditions.checkArgument(incOrDecOp.isInc() || incOrDecOp.isDec(), incOrDecOp);
        Node arg = incOrDecOp.getOnlyChild();
        if (NodeUtil.isExpressionResultUsed(incOrDecOp)) {
            this.traverseNode(arg, scope);
        } else if (arg.isGetProp()) {
            Node getPropObj = arg.getFirstChild();
            Node propertyNameNode = arg.getLastChild();
            if (getPropObj.isThis()) {
                RemovableBuilder builder = new RemovableBuilder().setIsThisDotPropertyReference(true);
                this.considerForIndependentRemoval(builder.buildIncOrDepOp(incOrDecOp, propertyNameNode));
            } else if (RemoveUnusedCode.isDotPrototype(getPropObj)) {
                Node exprObj = getPropObj.getFirstChild();
                RemovableBuilder builder = new RemovableBuilder().setIsPrototypeDotPropertyReference(true);
                if (exprObj.isName()) {
                    VarInfo varInfo = this.traverseNameNode(exprObj, scope);
                    varInfo.addRemovable(builder.buildIncOrDepOp(incOrDecOp, propertyNameNode));
                } else {
                    if (NodeUtil.mayHaveSideEffects(exprObj)) {
                        this.traverseNode(exprObj, scope);
                    } else {
                        builder.addContinuation(new Continuation(exprObj, scope));
                    }
                    this.considerForIndependentRemoval(builder.buildIncOrDepOp(incOrDecOp, propertyNameNode));
                }
            } else {
                this.traverseNode(arg, scope);
            }
        } else {
            this.traverseNode(arg, scope);
        }
    }

    private void traverseCompoundAssign(Node compoundAssignNode, Scope scope) {
        Node targetNode = compoundAssignNode.getFirstChild();
        Node valueNode = compoundAssignNode.getLastChild();
        if (targetNode.isGetProp() && targetNode.getFirstChild().isThis() && !NodeUtil.isExpressionResultUsed(compoundAssignNode)) {
            RemovableBuilder builder = new RemovableBuilder().setIsThisDotPropertyReference(true);
            this.traverseRemovableAssignValue(valueNode, builder, scope);
            this.considerForIndependentRemoval(builder.buildNamedPropertyAssign(compoundAssignNode, targetNode.getLastChild()));
        } else {
            this.traverseNode(targetNode, scope);
            this.traverseNode(valueNode, scope);
        }
    }

    private VarInfo traverseNameNode(Node n, Scope scope) {
        return this.traverseVar(this.getVarForNameNode(n, scope));
    }

    private void traverseCall(Node callNode, Scope scope) {
        Node callee = callNode.getFirstChild();
        if (callee.isQualifiedName() && this.codingConvention.isPropertyRenameFunction(callee.getOriginalQualifiedName())) {
            Node propertyNameNode = Preconditions.checkNotNull(callee.getNext());
            if (propertyNameNode.isString()) {
                this.markPropertyNameReferenced(propertyNameNode.getString());
            }
            this.traverseChildren(callNode, scope);
        } else if (NodeUtil.isObjectDefinePropertiesDefinition(callNode)) {
            this.traverseObjectDefinePropertiesCall(callNode, scope);
        } else {
            Node parent = callNode.getParent();
            String classVarName = null;
            if (parent.isExprResult() || parent.isComma() && parent.getFirstChild() == callNode) {
                CodingConvention.SubclassRelationship subclassRelationship = this.codingConvention.getClassesDefinedByCall(callNode);
                classVarName = subclassRelationship != null ? subclassRelationship.subclassName : this.codingConvention.getSingletonGetterClassName(callNode);
            }
            AbstractVar classVar = null;
            if (classVarName != null && NodeUtil.isValidSimpleName(classVarName)) {
                classVar = (Var)Preconditions.checkNotNull(scope.getVar(classVarName), classVarName);
            }
            if (classVar == null || !classVar.isGlobal()) {
                this.traverseChildren(callNode, scope);
            } else {
                RemovableBuilder builder = new RemovableBuilder();
                for (Node child = callNode.getFirstChild(); child != null; child = child.getNext()) {
                    builder.addContinuation(new Continuation(child, scope));
                }
                this.traverseVar((Var)classVar).addRemovable(builder.buildClassSetupCall(callNode));
            }
        }
    }

    private void traverseObjectDefinePropertiesCall(Node callNode, Scope scope) {
        Node callee = callNode.getFirstChild();
        Node targetObject = callNode.getSecondChild();
        Node propertyDefinitions = targetObject.getNext();
        if ((targetObject.isName() || this.isNameDotPrototype(targetObject)) && !NodeUtil.isExpressionResultUsed(callNode)) {
            Node nameNode = targetObject.isName() ? targetObject : targetObject.getFirstChild();
            VarInfo varInfo = this.traverseNameNode(nameNode, scope);
            RemovableBuilder builder = new RemovableBuilder();
            builder.addContinuation(new Continuation(callee, scope));
            if (NodeUtil.mayHaveSideEffects(propertyDefinitions)) {
                this.traverseNode(propertyDefinitions, scope);
            } else {
                builder.addContinuation(new Continuation(propertyDefinitions, scope));
            }
            varInfo.addRemovable(builder.buildClassSetupCall(callNode));
        } else {
            this.traverseNode(callee, scope);
            this.traverseNode(targetObject, scope);
            this.traverseNode(propertyDefinitions, scope);
        }
    }

    private void traverseObjectDefinePropertiesLiteral(Node propertyDefinitions, Scope scope) {
        for (Node property = propertyDefinitions.getFirstChild(); property != null; property = property.getNext()) {
            if (property.isQuotedString()) {
                this.markPropertyNameReferenced(property.getString());
                this.traverseNode(property.getOnlyChild(), scope);
                continue;
            }
            if (property.isStringKey()) {
                Node definition = property.getOnlyChild();
                if (NodeUtil.mayHaveSideEffects(definition)) {
                    this.traverseNode(definition, scope);
                    continue;
                }
                this.considerForIndependentRemoval(new RemovableBuilder().addContinuation(new Continuation(definition, scope)).buildObjectDefinePropertiesDefinition(property));
                continue;
            }
            this.traverseNode(property, scope);
        }
    }

    private void traverseRest(Node restNode, Scope scope) {
        Node target = restNode.getOnlyChild();
        if (target.isName()) {
            VarInfo varInfo = this.traverseNameNode(target, scope);
            if (!restNode.getParent().isParamList()) {
                varInfo.addRemovable(new RemovableBuilder().buildDestructuringAssign(target));
            }
        } else if (RemoveUnusedCode.isThisDotProperty(target)) {
            this.considerForIndependentRemoval(new RemovableBuilder().buildDestructuringAssign(target));
        } else {
            this.traverseNode(target, scope);
        }
    }

    private Var getVarForNameNode(Node nameNode, Scope scope) {
        return (Var)Preconditions.checkNotNull(scope.getVar(nameNode.getString()), nameNode);
    }

    private void traverseObjectLiteral(Node objectLiteral, Scope scope) {
        Preconditions.checkArgument(objectLiteral.isObjectLit(), objectLiteral);
        if (this.isAssignmentToPrototype(objectLiteral.getParent())) {
            this.traversePrototypeLiteral(objectLiteral, scope);
        } else if (this.isObjectDefinePropertiesSecondArgument(objectLiteral)) {
            this.traverseObjectDefinePropertiesLiteral(objectLiteral, scope);
        } else {
            this.traverseNonPrototypeObjectLiteral(objectLiteral, scope);
        }
    }

    private boolean isObjectDefinePropertiesSecondArgument(Node n) {
        Node parent = n.getParent();
        return NodeUtil.isObjectDefinePropertiesDefinition(parent) && parent.getLastChild() == n;
    }

    private void traverseNonPrototypeObjectLiteral(Node objectLiteral, Scope scope) {
        for (Node propertyNode = objectLiteral.getFirstChild(); propertyNode != null; propertyNode = propertyNode.getNext()) {
            if (propertyNode.isStringKey()) {
                this.markPropertyNameReferenced(propertyNode.getString());
                this.traverseNode(propertyNode.getFirstChild(), scope);
                continue;
            }
            this.traverseNode(propertyNode, scope);
        }
    }

    private void traversePrototypeLiteral(Node objectLiteral, Scope scope) {
        for (Node propertyNode = objectLiteral.getFirstChild(); propertyNode != null; propertyNode = propertyNode.getNext()) {
            if (propertyNode.isComputedProp() || propertyNode.isQuotedString()) {
                this.traverseChildren(propertyNode, scope);
                continue;
            }
            Node valueNode = propertyNode.getOnlyChild();
            if (NodeUtil.mayHaveSideEffects(valueNode)) {
                this.traverseNode(valueNode, scope);
                continue;
            }
            this.considerForIndependentRemoval(new RemovableBuilder().addContinuation(new Continuation(valueNode, scope)).buildClassOrPrototypeNamedProperty(propertyNode));
        }
    }

    private boolean isAssignmentToPrototype(Node n) {
        return n.isAssign() && RemoveUnusedCode.isDotPrototype(n.getFirstChild());
    }

    private static boolean isDotPrototype(Node n) {
        return n.isGetProp() && n.getLastChild().getString().equals("prototype");
    }

    private void traverseCatch(Node catchNode, Scope scope) {
        Node exceptionNameNode = catchNode.getFirstChild();
        Node block = exceptionNameNode.getNext();
        VarInfo exceptionVarInfo = this.traverseNameNode(exceptionNameNode, scope);
        exceptionVarInfo.setIsExplicitlyNotRemovable();
        this.traverseNode(block, scope);
    }

    private void traverseEnhancedFor(Node enhancedFor, Scope scope) {
        AbstractScope forScope = this.scopeCreator.createScope(enhancedFor, (AbstractScope)scope);
        Node iterationTarget = enhancedFor.getFirstChild();
        Node collection = iterationTarget.getNext();
        Node body = collection.getNext();
        if (iterationTarget.isName()) {
            VarInfo varInfo = this.traverseNameNode(iterationTarget, (Scope)forScope);
            varInfo.setIsExplicitlyNotRemovable();
        } else if (NodeUtil.isNameDeclaration(iterationTarget)) {
            Node declNode = iterationTarget.getOnlyChild();
            if (declNode.isDestructuringLhs()) {
                this.traverseNode(declNode, (Scope)forScope);
            } else {
                Preconditions.checkState(declNode.isName());
                Preconditions.checkState(!declNode.hasChildren());
                VarInfo varInfo = this.traverseNameNode(declNode, (Scope)forScope);
                varInfo.setIsExplicitlyNotRemovable();
            }
        } else {
            this.traverseNode(iterationTarget, (Scope)forScope);
        }
        this.traverseNode(collection, (Scope)forScope);
        this.traverseNode(body, (Scope)forScope);
    }

    private void traverseVanillaFor(Node forNode, Scope scope) {
        AbstractScope forScope = this.scopeCreator.createScope(forNode, (AbstractScope)scope);
        Node initialization = forNode.getFirstChild();
        Node condition = initialization.getNext();
        Node update = condition.getNext();
        Node block = update.getNext();
        if (NodeUtil.isNameDeclaration(initialization)) {
            this.traverseVanillaForNameDeclarations(initialization, (Scope)forScope);
        } else {
            this.traverseNode(initialization, (Scope)forScope);
        }
        this.traverseNode(condition, (Scope)forScope);
        this.traverseNode(update, (Scope)forScope);
        this.traverseNode(block, (Scope)forScope);
    }

    private void traverseVanillaForNameDeclarations(Node nameDeclaration, Scope scope) {
        for (Node child = nameDeclaration.getFirstChild(); child != null; child = child.getNext()) {
            if (!child.isName()) {
                this.traverseNode(child, scope);
                continue;
            }
            Node nameNode = child;
            Node valueNode = child.getFirstChild();
            VarInfo varInfo = this.traverseNameNode(nameNode, scope);
            if (valueNode == null) {
                varInfo.addRemovable(new RemovableBuilder().buildVanillaForNameDeclaration(nameNode));
                continue;
            }
            if (NodeUtil.mayHaveSideEffects(valueNode)) {
                varInfo.setIsExplicitlyNotRemovable();
                this.traverseNode(valueNode, scope);
                continue;
            }
            VanillaForNameDeclaration vanillaForNameDeclaration = new RemovableBuilder().addContinuation(new Continuation(valueNode, scope)).buildVanillaForNameDeclaration(nameNode);
            varInfo.addRemovable(vanillaForNameDeclaration);
        }
    }

    private void traverseDeclarationStatement(Node declarationStatement, Scope scope) {
        Node nameNode = declarationStatement.getOnlyChild();
        if (!nameNode.isName()) {
            this.traverseNode(nameNode, scope);
        } else {
            Node valueNode = nameNode.getFirstChild();
            VarInfo varInfo = this.traverseNameNode(nameNode, scope);
            RemovableBuilder builder = new RemovableBuilder();
            if (valueNode == null) {
                varInfo.addRemovable(builder.buildNameDeclarationStatement(declarationStatement));
            } else {
                if (NodeUtil.mayHaveSideEffects(valueNode)) {
                    this.traverseNode(valueNode, scope);
                } else {
                    builder.addContinuation(new Continuation(valueNode, scope));
                }
                NameDeclarationStatement removable = builder.buildNameDeclarationStatement(declarationStatement);
                varInfo.addRemovable(removable);
            }
        }
    }

    private void traverseAssign(Node assignNode, Scope scope) {
        Preconditions.checkState(NodeUtil.isAssignmentOp(assignNode));
        Node lhs = assignNode.getFirstChild();
        Node valueNode = assignNode.getLastChild();
        if (lhs.isName()) {
            VarInfo varInfo = this.traverseNameNode(lhs, scope);
            RemovableBuilder builder = new RemovableBuilder();
            this.traverseRemovableAssignValue(valueNode, builder, scope);
            varInfo.addRemovable(builder.buildVariableAssign(assignNode));
        } else if (lhs.isGetElem()) {
            Node varNameNode;
            Node getElemObj = lhs.getFirstChild();
            Node getElemKey = lhs.getLastChild();
            Node node = getElemObj.isName() ? getElemObj : (varNameNode = this.isNameDotPrototype(getElemObj) ? getElemObj.getFirstChild() : null);
            if (varNameNode != null) {
                VarInfo varInfo = this.traverseNameNode(varNameNode, scope);
                RemovableBuilder builder = new RemovableBuilder();
                if (NodeUtil.mayHaveSideEffects(getElemKey)) {
                    this.traverseNode(getElemKey, scope);
                } else {
                    builder.addContinuation(new Continuation(getElemKey, scope));
                }
                this.traverseRemovableAssignValue(valueNode, builder, scope);
                varInfo.addRemovable(builder.buildComputedPropertyAssign(assignNode, getElemKey));
            } else {
                this.traverseNode(getElemObj, scope);
                this.traverseNode(getElemKey, scope);
                this.traverseNode(valueNode, scope);
            }
        } else if (lhs.isGetProp()) {
            Node getPropLhs = lhs.getFirstChild();
            Node propNameNode = lhs.getLastChild();
            if (getPropLhs.isName()) {
                VarInfo varInfo = this.traverseNameNode(getPropLhs, scope);
                RemovableBuilder builder = new RemovableBuilder();
                this.traverseRemovableAssignValue(valueNode, builder, scope);
                varInfo.addRemovable(builder.buildNamedPropertyAssign(assignNode, propNameNode));
            } else if (RemoveUnusedCode.isDotPrototype(getPropLhs)) {
                Node objExpression = getPropLhs.getFirstChild();
                RemovableBuilder builder = new RemovableBuilder().setIsPrototypeDotPropertyReference(true);
                this.traverseRemovableAssignValue(valueNode, builder, scope);
                if (objExpression.isName()) {
                    VarInfo varInfo = this.traverseNameNode(getPropLhs.getFirstChild(), scope);
                    varInfo.addRemovable(builder.buildNamedPropertyAssign(assignNode, propNameNode));
                } else {
                    if (NodeUtil.mayHaveSideEffects(objExpression)) {
                        this.traverseNode(objExpression, scope);
                    } else {
                        builder.addContinuation(new Continuation(objExpression, scope));
                    }
                    this.considerForIndependentRemoval(builder.buildAnonymousPrototypeNamedPropertyAssign(assignNode, propNameNode.getString()));
                }
            } else if (getPropLhs.isThis()) {
                RemovableBuilder builder = new RemovableBuilder().setIsThisDotPropertyReference(true);
                this.traverseRemovableAssignValue(valueNode, builder, scope);
                this.considerForIndependentRemoval(builder.buildNamedPropertyAssign(assignNode, propNameNode));
            } else {
                this.traverseNode(lhs, scope);
                this.traverseNode(valueNode, scope);
            }
        } else {
            this.traverseNode(lhs, scope);
            this.traverseNode(valueNode, scope);
        }
    }

    private void traverseRemovableAssignValue(Node valueNode, RemovableBuilder builder, Scope scope) {
        if (NodeUtil.mayHaveSideEffects(valueNode) || NodeUtil.isExpressionResultUsed(valueNode.getParent())) {
            this.traverseNode(valueNode, scope);
        } else {
            builder.addContinuation(new Continuation(valueNode, scope));
        }
    }

    private boolean isNameDotPrototype(Node n) {
        return n.isGetProp() && n.getFirstChild().isName() && n.getLastChild().getString().equals("prototype");
    }

    private void traverseDefaultValue(Node defaultValueNode, Scope scope) {
        Node target = defaultValueNode.getFirstChild();
        Node value = target.getNext();
        if (NodeUtil.mayHaveSideEffects(value)) {
            this.traverseNode(target, scope);
            this.traverseNode(value, scope);
        } else if (target.isName()) {
            VarInfo varInfo = this.traverseNameNode(target, scope);
            DestructuringAssign assign = new RemovableBuilder().addContinuation(new Continuation(value, scope)).buildDestructuringAssign(target);
            varInfo.addRemovable(assign);
        } else if (RemoveUnusedCode.isThisDotProperty(target)) {
            DestructuringAssign assign = new RemovableBuilder().addContinuation(new Continuation(value, scope)).buildDestructuringAssign(target);
            this.considerForIndependentRemoval(assign);
        } else {
            this.traverseNode(target, scope);
            this.traverseNode(value, scope);
        }
    }

    private void traverseArrayPattern(Node arrayPattern, Scope scope) {
        for (Node c = arrayPattern.getFirstChild(); c != null; c = c.getNext()) {
            if (c.isName()) {
                VarInfo varInfo = this.traverseNameNode(c, scope);
                varInfo.addRemovable(new RemovableBuilder().buildDestructuringAssign(c));
                continue;
            }
            if (RemoveUnusedCode.isThisDotProperty(c)) {
                this.considerForIndependentRemoval(new RemovableBuilder().buildDestructuringAssign(c));
                continue;
            }
            if (c.isDefaultValue()) {
                this.traverseDefaultValue(c, scope);
                continue;
            }
            this.traverseNode(c, scope);
        }
    }

    private void traverseObjectPattern(Node objectPattern, Scope scope) {
        for (Node propertyNode = objectPattern.getFirstChild(); propertyNode != null; propertyNode = propertyNode.getNext()) {
            if (propertyNode.isComputedProp()) {
                this.traverseObjectPatternComputedProperty(propertyNode, scope);
                continue;
            }
            this.traverseObjectPatternStringKey(propertyNode, scope);
        }
    }

    private void traverseObjectPatternStringKey(Node elm, Scope scope) {
        Preconditions.checkArgument(elm.isStringKey(), elm);
        if (!elm.isQuotedString()) {
            this.markPropertyNameReferenced(elm.getString());
        }
        Node target = elm.getOnlyChild();
        Node defaultValue = null;
        if (target.isDefaultValue()) {
            target = target.getFirstChild();
            defaultValue = Preconditions.checkNotNull(target.getNext());
        }
        if (defaultValue != null && NodeUtil.mayHaveSideEffects(defaultValue)) {
            if (defaultValue != null) {
                this.traverseNode(defaultValue, scope);
            }
            this.traverseNode(target, scope);
        } else if (target.isName()) {
            VarInfo varInfo = this.traverseNameNode(target, scope);
            RemovableBuilder builder = new RemovableBuilder();
            if (defaultValue != null) {
                builder.addContinuation(new Continuation(defaultValue, scope));
            }
            varInfo.addRemovable(builder.buildDestructuringAssign(target));
        } else if (RemoveUnusedCode.isThisDotProperty(target)) {
            RemovableBuilder builder = new RemovableBuilder();
            if (defaultValue != null) {
                builder.addContinuation(new Continuation(defaultValue, scope));
            }
            this.considerForIndependentRemoval(builder.buildDestructuringAssign(target));
        } else {
            if (defaultValue != null) {
                this.traverseNode(defaultValue, scope);
            }
            this.traverseNode(target, scope);
        }
    }

    private void traverseObjectPatternComputedProperty(Node elm, Scope scope) {
        Preconditions.checkArgument(elm.isComputedProp(), elm);
        Node propertyExpression = elm.getFirstChild();
        Node target = propertyExpression.getNext();
        Node defaultValue = null;
        if (target.isDefaultValue()) {
            target = target.getFirstChild();
            defaultValue = Preconditions.checkNotNull(target.getNext());
        }
        if (NodeUtil.mayHaveSideEffects(propertyExpression) || defaultValue != null && NodeUtil.mayHaveSideEffects(defaultValue)) {
            this.traverseNode(propertyExpression, scope);
            if (defaultValue != null) {
                this.traverseNode(defaultValue, scope);
            }
            this.traverseNode(target, scope);
        } else if (target.isName()) {
            VarInfo varInfo = this.traverseNameNode(target, scope);
            RemovableBuilder builder = new RemovableBuilder();
            builder.addContinuation(new Continuation(propertyExpression, scope));
            if (defaultValue != null) {
                builder.addContinuation(new Continuation(defaultValue, scope));
            }
            varInfo.addRemovable(builder.buildDestructuringAssign(target));
        } else if (this.isNameDotPrototype(target)) {
            RemovableBuilder builder = new RemovableBuilder();
            builder.addContinuation(new Continuation(propertyExpression, scope));
            if (defaultValue != null) {
                builder.addContinuation(new Continuation(defaultValue, scope));
            }
            this.considerForIndependentRemoval(builder.buildDestructuringAssign(target));
        } else {
            this.traverseNode(propertyExpression, scope);
            if (defaultValue != null) {
                this.traverseNode(defaultValue, scope);
            }
            this.traverseNode(target, scope);
        }
    }

    private void traverseChildren(Node n, Scope scope) {
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            this.traverseNode(c, scope);
        }
    }

    private void traverseClass(Node classNode, Scope scope) {
        Preconditions.checkArgument(classNode.isClass());
        if (NodeUtil.isClassDeclaration(classNode)) {
            this.traverseClassDeclaration(classNode, scope);
        } else {
            this.traverseClassExpression(classNode, scope);
        }
    }

    private void traverseClassDeclaration(Node classNode, Scope scope) {
        Preconditions.checkArgument(classNode.isClass());
        Node classNameNode = classNode.getFirstChild();
        Node baseClassExpression = classNameNode.getNext();
        Node classBodyNode = baseClassExpression.getNext();
        AbstractScope classScope = this.scopeCreator.createScope(classNode, (AbstractScope)scope);
        VarInfo varInfo = this.traverseNameNode(classNameNode, scope);
        if (classNode.getParent().isExport()) {
            varInfo.setIsExplicitlyNotRemovable();
            this.traverseNode(baseClassExpression, scope);
            this.traverseChildren(classBodyNode, (Scope)classScope);
        } else if (NodeUtil.mayHaveSideEffects(baseClassExpression)) {
            varInfo.setIsExplicitlyNotRemovable();
            this.traverseNode(baseClassExpression, scope);
            this.traverseClassMembers(classBodyNode, (Scope)classScope);
        } else {
            RemovableBuilder builder = new RemovableBuilder().addContinuation(new Continuation(baseClassExpression, (Scope)classScope)).addContinuation(new Continuation(classBodyNode, (Scope)classScope));
            varInfo.addRemovable(builder.buildClassDeclaration(classNode));
        }
    }

    private void traverseClassExpression(Node classNode, Scope scope) {
        Preconditions.checkArgument(classNode.isClass());
        Node classNameNode = classNode.getFirstChild();
        Node baseClassExpression = classNameNode.getNext();
        Node classBodyNode = baseClassExpression.getNext();
        AbstractScope classScope = this.scopeCreator.createScope(classNode, (AbstractScope)scope);
        if (classNameNode.isName()) {
            VarInfo varInfo = this.traverseNameNode(classNameNode, (Scope)classScope);
            varInfo.addRemovable(new RemovableBuilder().buildNamedClassExpression(classNode));
        }
        this.traverseNode(baseClassExpression, scope);
        this.traverseClassMembers(classBodyNode, (Scope)classScope);
    }

    private void traverseClassMembers(Node node, Scope scope) {
        Preconditions.checkArgument(node.isClassMembers(), node);
        if (this.removeUnusedPrototypeProperties) {
            for (Node member = node.getFirstChild(); member != null; member = member.getNext()) {
                if (member.isMemberFunctionDef() || NodeUtil.isGetOrSetKey(member)) {
                    this.considerForIndependentRemoval(new RemovableBuilder().addContinuation(new Continuation(member, scope)).buildClassOrPrototypeNamedProperty(member));
                    continue;
                }
                Preconditions.checkState(member.isComputedProp());
                this.traverseChildren(member, scope);
            }
        } else {
            this.traverseChildren(node, scope);
        }
    }

    private void traverseFunction(Node function, Scope parentScope) {
        Preconditions.checkState(function.getChildCount() == 3, function);
        Preconditions.checkState(function.isFunction(), function);
        Node paramlist = NodeUtil.getFunctionParameters(function);
        Node body = function.getLastChild();
        Preconditions.checkState(body.getNext() == null && body.isBlock(), body);
        AbstractScope fparamScope = this.scopeCreator.createScope(function, (AbstractScope)parentScope);
        AbstractScope fbodyScope = this.scopeCreator.createScope(body, fparamScope);
        Node nameNode = function.getFirstChild();
        if (!nameNode.getString().isEmpty()) {
            VarInfo varInfo = this.traverseNameNode(nameNode, (Scope)fparamScope);
            if (NodeUtil.isExpressionResultUsed(function)) {
                varInfo.hasNonLocalOrNonLiteralValue = true;
            }
        }
        this.traverseChildren(paramlist, (Scope)fparamScope);
        this.traverseChildren(body, (Scope)fbodyScope);
        this.allFunctionParamScopes.add((Scope)fparamScope);
    }

    private boolean canRemoveParameters(Node parameterList) {
        Preconditions.checkState(parameterList.isParamList());
        Node function = parameterList.getParent();
        return this.removeGlobals && !NodeUtil.isGetOrSetKey(function.getParent());
    }

    private void removeUnreferencedFunctionArgs(Scope fparamScope) {
        if (!this.removeGlobals) {
            return;
        }
        Node function = fparamScope.getRootNode();
        Preconditions.checkState(function.isFunction());
        if (NodeUtil.isGetOrSetKey(function.getParent())) {
            return;
        }
        Node argList = NodeUtil.getFunctionParameters(function);
        this.maybeRemoveUnusedTrailingParameters(argList, fparamScope);
        this.markUnusedParameters(argList, fparamScope);
    }

    private void markPropertyNameReferenced(String propertyName) {
        if (this.referencedPropertyNames.add(propertyName)) {
            for (Removable removable : this.removablesForPropertyNames.removeAll(propertyName)) {
                removable.applyContinuations();
            }
        }
    }

    private void considerForIndependentRemoval(Removable removable) {
        if (removable.isNamedProperty()) {
            String propertyName = removable.getPropertyName();
            if (this.referencedPropertyNames.contains(propertyName) || this.codingConvention.isExported(propertyName)) {
                removable.applyContinuations();
            } else if (this.isIndependentlyRemovable(removable)) {
                this.removablesForPropertyNames.put(propertyName, removable);
            } else {
                removable.applyContinuations();
                this.markPropertyNameReferenced(propertyName);
            }
        } else {
            removable.applyContinuations();
        }
    }

    private boolean isIndependentlyRemovable(Removable removable) {
        return this.removeUnusedPrototypeProperties && removable.isPrototypeProperty() || this.removeUnusedThisProperties && removable.isThisDotPropertyReference() || this.removeUnusedObjectDefinePropertiesDefinitions && removable.isObjectDefinePropertiesDefinition() || this.removeUnusedStaticProperties && removable.isStaticProperty();
    }

    private void markUnusedParameters(Node paramList, Scope fparamScope) {
        for (Node param = paramList.getFirstChild(); param != null; param = param.getNext()) {
            VarInfo varInfo;
            if (param.isUnusedParameter()) continue;
            Node lValue = param;
            if (lValue.isDefaultValue()) {
                lValue = lValue.getFirstChild();
            }
            if (lValue.isRest()) {
                lValue = lValue.getOnlyChild();
            }
            if (lValue.isDestructuringPattern() || !(varInfo = this.traverseNameNode(lValue, fparamScope)).isRemovable()) continue;
            param.setUnusedParameter(true);
            this.compiler.reportChangeToEnclosingScope(paramList);
        }
    }

    private void maybeRemoveUnusedTrailingParameters(Node argList, Scope fparamScope) {
        Node lastArg;
        while ((lastArg = argList.getLastChild()) != null) {
            Node lValue = lastArg;
            if (lastArg.isDefaultValue()) {
                lValue = lastArg.getFirstChild();
                if (NodeUtil.mayHaveSideEffects(lastArg.getLastChild())) break;
            }
            if (lValue.isRest()) {
                lValue = lValue.getFirstChild();
            }
            if (lValue.isDestructuringPattern()) {
                if (lValue.hasChildren()) break;
                NodeUtil.deleteNode(lastArg, this.compiler);
                continue;
            }
            VarInfo varInfo = this.getVarInfo(this.getVarForNameNode(lValue, fparamScope));
            if (!varInfo.isRemovable()) break;
            NodeUtil.deleteNode(lastArg, this.compiler);
        }
    }

    private VarInfo traverseVar(Var var) {
        Preconditions.checkNotNull(var);
        if (this.removeLocalVars && var.isArguments()) {
            Scope functionScope = (Scope)((Scope)var.getScope()).getClosestHoistScope();
            Node paramList = NodeUtil.getFunctionParameters(functionScope.getRootNode());
            for (Node param = paramList.getFirstChild(); param != null; param = param.getNext()) {
                Node lValue = param;
                if (lValue.isDefaultValue()) {
                    lValue = lValue.getFirstChild();
                }
                if (lValue.isRest()) {
                    lValue = lValue.getOnlyChild();
                }
                if (lValue.isDestructuringPattern()) continue;
                this.getVarInfo(this.getVarForNameNode(lValue, functionScope)).markAsReferenced();
            }
            return this.canonicalUnremovableVarInfo;
        }
        return this.getVarInfo(var);
    }

    private VarInfo getVarInfo(Var var) {
        Preconditions.checkNotNull(var);
        boolean isGlobal = var.isGlobal();
        if (var.isExtern()) {
            return this.canonicalUnremovableVarInfo;
        }
        if (isGlobal && !this.removeGlobals) {
            return this.canonicalUnremovableVarInfo;
        }
        if (!isGlobal && !this.removeLocalVars) {
            return this.canonicalUnremovableVarInfo;
        }
        if (this.codingConvention.isExported(var.getName(), !isGlobal)) {
            return this.canonicalUnremovableVarInfo;
        }
        if (var.isArguments()) {
            return this.canonicalUnremovableVarInfo;
        }
        VarInfo varInfo = this.varInfoMap.get(var);
        if (varInfo == null) {
            varInfo = new VarInfo();
            if (var.getParentNode().isParamList()) {
                varInfo.hasNonLocalOrNonLiteralValue = true;
            }
            this.varInfoMap.put(var, varInfo);
        }
        return varInfo;
    }

    private void removeUnreferencedVars() {
        for (Map.Entry<Var, VarInfo> entry : this.varInfoMap.entrySet()) {
            Var var = entry.getKey();
            VarInfo varInfo = entry.getValue();
            if (!varInfo.isRemovable()) continue;
            varInfo.removeAllRemovables();
            Node nameNode = var.nameNode;
            Node toRemove = nameNode.getParent();
            if (toRemove == null || RemoveUnusedCode.alreadyRemoved(toRemove)) continue;
            if (NodeUtil.isFunctionExpression(toRemove)) {
                if (this.preserveFunctionExpressionNames) continue;
                Node fnNameNode = toRemove.getFirstChild();
                this.compiler.reportChangeToEnclosingScope(fnNameNode);
                fnNameNode.setString("");
                continue;
            }
            Preconditions.checkState(toRemove.isParamList() || toRemove.getParent().isParamList() && (toRemove.isDefaultValue() || toRemove.isRest()), "unremoved code: %s", (Object)toRemove);
        }
    }

    private static boolean isThisDotProperty(Node n) {
        return n.isGetProp() && n.getFirstChild().isThis();
    }

    private static boolean isDotPrototypeDotProperty(Node n) {
        return n.isGetProp() && RemoveUnusedCode.isDotPrototype(n.getFirstChild());
    }

    private static boolean isLocalDefaultValueAssignment(Node targetNode, Node valueNode) {
        return valueNode.isOr() && targetNode.isQualifiedName() && valueNode.getFirstChild().isEquivalentTo(targetNode) && NodeUtil.evaluatesToLocalValue(valueNode.getLastChild());
    }

    private static boolean alreadyRemoved(Node n) {
        Node parent = n.getParent();
        if (parent == null) {
            return true;
        }
        if (parent.isRoot()) {
            return false;
        }
        return RemoveUnusedCode.alreadyRemoved(parent);
    }

    void removeExpressionCompletely(Node expression) {
        Preconditions.checkState(!NodeUtil.isExpressionResultUsed(expression), expression);
        Node parent = expression.getParent();
        if (parent.isExprResult()) {
            NodeUtil.deleteNode(parent, this.compiler);
        } else if (parent.isComma()) {
            Node otherChild = expression.getNext();
            if (otherChild == null) {
                otherChild = expression.getPrevious();
            }
            this.replaceNodeWith(parent, otherChild.detach());
        } else {
            this.replaceNodeWith(expression, IR.number(0.0).useSourceInfoFrom(expression));
        }
    }

    void replaceNodeWith(Node n, Node replacement) {
        this.compiler.reportChangeToEnclosingScope(n);
        n.replaceWith(replacement);
        NodeUtil.markFunctionsDeleted(n, this.compiler);
    }

    private class VanillaForNameDeclaration
    extends Removable {
        private final Node nameNode;

        private VanillaForNameDeclaration(RemovableBuilder builder, Node nameNode) {
            super(builder);
            this.nameNode = nameNode;
        }

        @Override
        void removeInternal(AbstractCompiler compiler) {
            Node declaration = Preconditions.checkNotNull(this.nameNode.getParent());
            compiler.reportChangeToEnclosingScope(declaration);
            if (this.nameNode.getPrevious() == null && this.nameNode.getNext() == null) {
                declaration.replaceWith(IR.empty().useSourceInfoFrom(declaration));
            } else {
                declaration.removeChild(this.nameNode);
            }
            NodeUtil.markFunctionsDeleted(this.nameNode, compiler);
        }
    }

    private class VarInfo {
        final List<Removable> removables = new ArrayList<Removable>();
        boolean isEntirelyRemovable = true;
        boolean hasNonLocalOrNonLiteralValue = false;
        boolean requiresLocalLiteralValueForRemoval = false;

        private VarInfo() {
        }

        void addRemovable(Removable removable) {
            if (!removable.isAssignedValueLocal() && (removable.isVariableAssignment() || removable.isPrototypeAssignment())) {
                this.hasNonLocalOrNonLiteralValue = true;
            }
            if (removable.preventsRemovalOfVariableWithNonLocalValueOrPrototype()) {
                this.requiresLocalLiteralValueForRemoval = true;
            }
            if (this.hasNonLocalOrNonLiteralValue && this.requiresLocalLiteralValueForRemoval) {
                this.setIsExplicitlyNotRemovable();
            }
            if (this.isEntirelyRemovable) {
                this.removables.add(removable);
            } else {
                RemoveUnusedCode.this.considerForIndependentRemoval(removable);
            }
        }

        boolean markAsReferenced() {
            return this.setIsExplicitlyNotRemovable();
        }

        boolean isRemovable() {
            return this.isEntirelyRemovable;
        }

        boolean setIsExplicitlyNotRemovable() {
            if (this.isEntirelyRemovable) {
                this.isEntirelyRemovable = false;
                for (Removable r : this.removables) {
                    RemoveUnusedCode.this.considerForIndependentRemoval(r);
                }
                this.removables.clear();
                return true;
            }
            return false;
        }

        void removeAllRemovables() {
            Preconditions.checkState(this.isEntirelyRemovable);
            for (Removable removable : this.removables) {
                removable.remove(RemoveUnusedCode.this.compiler);
            }
            this.removables.clear();
        }
    }

    private class ClassSetupCall
    extends Removable {
        final Node callNode;

        ClassSetupCall(RemovableBuilder builder, Node callNode) {
            super(builder);
            this.callNode = callNode;
        }

        @Override
        public void removeInternal(AbstractCompiler compiler) {
            Node parent = this.callNode.getParent();
            Node replacement = null;
            this.callNode.removeFirstChild();
            Node arg = this.callNode.getLastChild();
            while (arg != null) {
                arg.detach();
                if (NodeUtil.mayHaveSideEffects(arg)) {
                    replacement = replacement == null ? arg : IR.comma(arg, replacement).srcref(this.callNode);
                } else {
                    NodeUtil.markFunctionsDeleted(arg, compiler);
                }
                arg = this.callNode.getLastChild();
            }
            if (replacement != null) {
                RemoveUnusedCode.this.replaceNodeWith(this.callNode, replacement);
            } else if (parent.isExprResult()) {
                NodeUtil.deleteNode(parent, compiler);
            } else {
                Preconditions.checkState(parent.isComma());
                Node rhs = Preconditions.checkNotNull(this.callNode.getNext());
                compiler.reportChangeToEnclosingScope(parent);
                parent.replaceWith(rhs.detach());
            }
        }

        @Override
        public boolean preventsRemovalOfVariableWithNonLocalValueOrPrototype() {
            return true;
        }

        public String toString() {
            return "ClassSetupCall:" + this.callNode;
        }
    }

    private class AnonymousPrototypeNamedPropertyAssign
    extends Removable {
        final Node assignNode;

        AnonymousPrototypeNamedPropertyAssign(RemovableBuilder builder, Node assignNode) {
            super(builder);
            Preconditions.checkNotNull(builder.propertyName);
            Preconditions.checkArgument(assignNode.isAssign(), assignNode);
            this.assignNode = assignNode;
        }

        @Override
        void removeInternal(AbstractCompiler compiler) {
            if (RemoveUnusedCode.alreadyRemoved(this.assignNode)) {
                return;
            }
            Node parent = this.assignNode.getParent();
            compiler.reportChangeToEnclosingScope(parent);
            Node lhs = this.assignNode.getFirstChild();
            Node rhs = this.assignNode.getLastChild();
            Preconditions.checkState(lhs.isGetProp(), lhs);
            Node objDotPrototype = lhs.getFirstChild();
            Preconditions.checkState(objDotPrototype.isGetProp(), objDotPrototype);
            Node objExpression = objDotPrototype.getFirstChild();
            Node prototype = objDotPrototype.getLastChild();
            Preconditions.checkState(prototype.getString().equals("prototype"), prototype);
            boolean mustPreserveRhs = NodeUtil.mayHaveSideEffects(rhs) || NodeUtil.isExpressionResultUsed(this.assignNode);
            boolean mustPreserveObjExpression = NodeUtil.mayHaveSideEffects(objExpression);
            if (mustPreserveRhs && mustPreserveObjExpression) {
                Node replacement = IR.comma(objExpression.detach(), rhs.detach()).useSourceInfoFrom(this.assignNode);
                RemoveUnusedCode.this.replaceNodeWith(this.assignNode, replacement);
            } else if (mustPreserveObjExpression) {
                RemoveUnusedCode.this.replaceNodeWith(this.assignNode, objExpression.detach());
            } else if (mustPreserveRhs) {
                RemoveUnusedCode.this.replaceNodeWith(this.assignNode, rhs.detach());
            } else {
                RemoveUnusedCode.this.removeExpressionCompletely(this.assignNode);
            }
        }

        @Override
        boolean isPrototypeProperty() {
            return true;
        }

        public String toString() {
            return "AnonymousPrototypeNamedPropertyAssign:" + this.assignNode;
        }
    }

    private class Assign
    extends Removable {
        final Node assignNode;
        final Kind kind;

        Assign(RemovableBuilder builder, Node assignNode, @Nullable Kind kind, Node propertyNode) {
            super(builder);
            Preconditions.checkArgument(NodeUtil.isAssignmentOp(assignNode), assignNode);
            if (kind == Kind.VARIABLE) {
                Preconditions.checkArgument(propertyNode == null, "got property node for simple variable assignment: %s", (Object)propertyNode);
            } else {
                Preconditions.checkArgument(propertyNode != null, "missing property node");
                if (kind == Kind.NAMED_PROPERTY) {
                    Preconditions.checkArgument(propertyNode.isString(), "property name is not a string: %s", (Object)propertyNode);
                }
            }
            this.assignNode = assignNode;
            this.kind = kind;
        }

        @Override
        boolean isVariableAssignment() {
            return this.kind == Kind.VARIABLE;
        }

        @Override
        boolean isAssignedValueLocal() {
            if (NodeUtil.isExpressionResultUsed(this.assignNode)) {
                return false;
            }
            Node targetNode = this.assignNode.getFirstChild();
            Node valueNode = targetNode.getNext();
            return NodeUtil.evaluatesToLocalValue(valueNode) || RemoveUnusedCode.isLocalDefaultValueAssignment(targetNode, valueNode);
        }

        @Override
        public boolean preventsRemovalOfVariableWithNonLocalValueOrPrototype() {
            return this.isNamedPropertyAssignment() || this.isComputedPropertyAssignment();
        }

        @Override
        boolean isNamedPropertyAssignment() {
            return this.kind == Kind.NAMED_PROPERTY;
        }

        boolean isComputedPropertyAssignment() {
            return this.kind == Kind.COMPUTED_PROPERTY;
        }

        @Override
        public boolean isStaticProperty() {
            Node lhs = this.assignNode.getFirstChild();
            if (lhs.isGetProp()) {
                Node getPropLhs = lhs.getFirstChild();
                JSType typeI = getPropLhs.getJSType();
                return typeI != null && (typeI.isConstructor() || typeI.isInterface());
            }
            return false;
        }

        @Override
        public void removeInternal(AbstractCompiler compiler) {
            boolean mustPreserveGetElmExpr;
            if (RemoveUnusedCode.alreadyRemoved(this.assignNode)) {
                return;
            }
            Node parent = this.assignNode.getParent();
            compiler.reportChangeToEnclosingScope(parent);
            Node lhs = this.assignNode.getFirstChild();
            Node rhs = this.assignNode.getSecondChild();
            boolean mustPreserveRhs = NodeUtil.mayHaveSideEffects(rhs) || NodeUtil.isExpressionResultUsed(this.assignNode);
            boolean bl = mustPreserveGetElmExpr = lhs.isGetElem() && NodeUtil.mayHaveSideEffects(lhs.getLastChild());
            if (mustPreserveRhs && mustPreserveGetElmExpr) {
                Node replacement = IR.comma(lhs.getLastChild().detach(), rhs.detach()).useSourceInfoFrom(this.assignNode);
                RemoveUnusedCode.this.replaceNodeWith(this.assignNode, replacement);
            } else if (mustPreserveGetElmExpr) {
                RemoveUnusedCode.this.replaceNodeWith(this.assignNode, lhs.getLastChild().detach());
            } else if (mustPreserveRhs) {
                RemoveUnusedCode.this.replaceNodeWith(this.assignNode, rhs.detach());
            } else {
                RemoveUnusedCode.this.removeExpressionCompletely(this.assignNode);
            }
        }

        public String toString() {
            return "Assign:" + this.assignNode;
        }
    }

    static enum Kind {
        VARIABLE,
        NAMED_PROPERTY,
        COMPUTED_PROPERTY;

    }

    private class NameDeclarationStatement
    extends Removable {
        private final Node declarationStatement;

        public NameDeclarationStatement(RemovableBuilder builder, Node declarationStatement) {
            super(builder);
            Preconditions.checkArgument(NodeUtil.isNameDeclaration(declarationStatement), declarationStatement);
            this.declarationStatement = declarationStatement;
        }

        @Override
        void removeInternal(AbstractCompiler compiler) {
            Node nameNode = this.declarationStatement.getOnlyChild();
            Node valueNode = nameNode.getFirstChild();
            if (valueNode != null && NodeUtil.mayHaveSideEffects(valueNode)) {
                compiler.reportChangeToEnclosingScope(this.declarationStatement);
                valueNode.detach();
                this.declarationStatement.replaceWith(IR.exprResult(valueNode).useSourceInfoFrom(valueNode));
            } else {
                NodeUtil.deleteNode(this.declarationStatement, compiler);
            }
        }

        @Override
        boolean isVariableAssignment() {
            return true;
        }

        @Override
        boolean isAssignedValueLocal() {
            Node nameNode = this.declarationStatement.getOnlyChild();
            Node valueNode = nameNode.getFirstChild();
            return valueNode == null || RemoveUnusedCode.isLocalDefaultValueAssignment(nameNode, valueNode) || NodeUtil.evaluatesToLocalValue(valueNode);
        }

        public String toString() {
            return "NameDeclStmt:" + this.declarationStatement;
        }
    }

    private class FunctionDeclaration
    extends Removable {
        final Node functionDeclarationNode;

        FunctionDeclaration(RemovableBuilder builder, Node functionDeclarationNode) {
            super(builder);
            this.functionDeclarationNode = functionDeclarationNode;
        }

        @Override
        public void removeInternal(AbstractCompiler compiler) {
            NodeUtil.deleteNode(this.functionDeclarationNode, compiler);
        }

        @Override
        boolean isAssignedValueLocal() {
            return true;
        }

        public String toString() {
            return "FunctionDeclaration:" + this.functionDeclarationNode;
        }
    }

    private class ObjectDefinePropertiesDefinition
    extends Removable {
        final Node propertyNode;

        ObjectDefinePropertiesDefinition(RemovableBuilder builder, Node propertyNode) {
            super(builder);
            this.propertyNode = propertyNode;
        }

        @Override
        public boolean isObjectDefinePropertiesDefinition() {
            return true;
        }

        @Override
        void removeInternal(AbstractCompiler compiler) {
            NodeUtil.deleteNode(this.propertyNode, compiler);
        }
    }

    private class ClassOrPrototypeNamedProperty
    extends Removable {
        final Node propertyNode;

        ClassOrPrototypeNamedProperty(RemovableBuilder builder, Node propertyNode) {
            super(builder);
            this.propertyNode = propertyNode;
        }

        @Override
        public boolean isStaticProperty() {
            return this.propertyNode.isStaticMember();
        }

        @Override
        boolean isClassOrPrototypeNamedProperty() {
            return !this.isStaticProperty();
        }

        @Override
        void removeInternal(AbstractCompiler compiler) {
            NodeUtil.deleteNode(this.propertyNode, compiler);
        }

        public String toString() {
            return "ClassOrPrototypeNamedProperty:" + this.propertyNode;
        }
    }

    private class NamedClassExpression
    extends Removable {
        final Node classNode;

        NamedClassExpression(RemovableBuilder builder, Node classNode) {
            super(builder);
            this.classNode = classNode;
        }

        @Override
        public void removeInternal(AbstractCompiler compiler) {
            Node nameNode;
            if (!RemoveUnusedCode.alreadyRemoved(this.classNode) && !(nameNode = this.classNode.getFirstChild()).isEmpty()) {
                this.classNode.replaceChild(nameNode, IR.empty().useSourceInfoFrom(nameNode));
                compiler.reportChangeToEnclosingScope(this.classNode);
            }
        }

        public String toString() {
            return "NamedClassExpression:" + this.classNode;
        }
    }

    private class ClassDeclaration
    extends Removable {
        final Node classDeclarationNode;

        ClassDeclaration(RemovableBuilder builder, Node classDeclarationNode) {
            super(builder);
            this.classDeclarationNode = classDeclarationNode;
        }

        @Override
        public void removeInternal(AbstractCompiler compiler) {
            NodeUtil.deleteNode(this.classDeclarationNode, compiler);
        }

        public String toString() {
            return "ClassDeclaration:" + this.classDeclarationNode;
        }
    }

    private class DestructuringAssign
    extends Removable {
        final Node targetNode;

        DestructuringAssign(RemovableBuilder builder, Node targetNode) {
            super(builder);
            Preconditions.checkState(targetNode.isName() || RemoveUnusedCode.isThisDotProperty(targetNode), targetNode);
            this.targetNode = targetNode;
        }

        @Override
        boolean isVariableAssignment() {
            return this.targetNode.isName();
        }

        @Override
        boolean isThisDotPropertyReference() {
            return RemoveUnusedCode.isThisDotProperty(this.targetNode);
        }

        @Override
        boolean isNamedProperty() {
            return this.targetNode.isGetProp();
        }

        @Override
        public boolean preventsRemovalOfVariableWithNonLocalValueOrPrototype() {
            if (this.targetNode.isGetProp()) {
                Node getPropLhs = this.targetNode.getFirstChild();
                return getPropLhs.isName() || RemoveUnusedCode.this.isNameDotPrototype(getPropLhs);
            }
            return false;
        }

        @Override
        boolean isNamedPropertyAssignment() {
            return this.targetNode.isGetProp();
        }

        @Override
        String getPropertyName() {
            Preconditions.checkState(this.targetNode.isGetProp(), this.targetNode);
            return this.targetNode.getLastChild().getString();
        }

        @Override
        public void removeInternal(AbstractCompiler compiler) {
            if (!RemoveUnusedCode.alreadyRemoved(this.targetNode)) {
                this.removeDestructuringTarget(this.targetNode);
            }
        }

        private void removeDestructuringTarget(Node target) {
            Node targetParent = target.getParent();
            if (targetParent.isArrayPattern()) {
                RemoveUnusedCode.this.replaceNodeWith(target, IR.empty().srcref(target));
                Node maybeEmpty = targetParent.getLastChild();
                while (maybeEmpty != null && maybeEmpty.isEmpty()) {
                    maybeEmpty.detach();
                    maybeEmpty = targetParent.getLastChild();
                }
                RemoveUnusedCode.this.compiler.reportChangeToEnclosingScope(targetParent);
            } else if (targetParent.isParamList()) {
                Preconditions.checkState(target.isDefaultValue(), target);
                RemoveUnusedCode.this.compiler.reportChangeToEnclosingScope(targetParent);
                Node name = target.getFirstChild();
                Preconditions.checkState(name.isName());
                if (target == targetParent.getLastChild() && RemoveUnusedCode.this.removeGlobals && RemoveUnusedCode.this.canRemoveParameters(targetParent)) {
                    target.detach();
                } else {
                    target.replaceWith(name.detach());
                }
                NodeUtil.markFunctionsDeleted(target, RemoveUnusedCode.this.compiler);
            } else if (targetParent.isRest()) {
                this.removeDestructuringTarget(targetParent);
            } else if (targetParent.isDefaultValue()) {
                this.removeDestructuringTarget(targetParent);
            } else {
                Preconditions.checkState(targetParent.isStringKey() || targetParent.isComputedProp(), targetParent);
                NodeUtil.deleteNode(targetParent, RemoveUnusedCode.this.compiler);
            }
        }
    }

    private class IncOrDecOp
    extends Removable {
        final Node incOrDecNode;

        IncOrDecOp(RemovableBuilder builder, Node incOrDecNode) {
            super(builder);
            Preconditions.checkArgument(incOrDecNode.isInc() || incOrDecNode.isDec(), incOrDecNode);
            Node arg = incOrDecNode.getOnlyChild();
            Preconditions.checkState(RemoveUnusedCode.isThisDotProperty(arg) || RemoveUnusedCode.isDotPrototypeDotProperty(arg), arg);
            this.incOrDecNode = incOrDecNode;
        }

        @Override
        void removeInternal(AbstractCompiler compiler) {
            if (!RemoveUnusedCode.alreadyRemoved(this.incOrDecNode)) {
                Node arg = this.incOrDecNode.getOnlyChild();
                Preconditions.checkState(arg.isGetProp(), arg);
                if (RemoveUnusedCode.isThisDotProperty(arg)) {
                    RemoveUnusedCode.this.removeExpressionCompletely(this.incOrDecNode);
                } else {
                    Preconditions.checkState(RemoveUnusedCode.isDotPrototypeDotProperty(arg), arg);
                    Node objExpression = arg.getFirstFirstChild();
                    if (NodeUtil.mayHaveSideEffects(objExpression)) {
                        RemoveUnusedCode.this.replaceNodeWith(this.incOrDecNode, objExpression.detach());
                    } else {
                        RemoveUnusedCode.this.removeExpressionCompletely(this.incOrDecNode);
                    }
                }
            }
        }

        public String toString() {
            return "IncOrDecOp:" + this.incOrDecNode;
        }
    }

    private class InstanceofName
    extends Removable {
        final Node instanceofNode;

        InstanceofName(RemovableBuilder builder, Node instanceofNode) {
            super(builder);
            Preconditions.checkArgument(instanceofNode.isInstanceOf(), instanceofNode);
            this.instanceofNode = instanceofNode;
        }

        @Override
        void removeInternal(AbstractCompiler compiler) {
            if (!RemoveUnusedCode.alreadyRemoved(this.instanceofNode)) {
                Node lhs = this.instanceofNode.getFirstChild();
                Node falseNode = IR.falseNode().srcref(this.instanceofNode);
                if (NodeUtil.mayHaveSideEffects(lhs)) {
                    RemoveUnusedCode.this.replaceNodeWith(this.instanceofNode, IR.comma(lhs.detach(), falseNode).srcref(this.instanceofNode));
                } else {
                    RemoveUnusedCode.this.replaceNodeWith(this.instanceofNode, falseNode);
                }
            }
        }

        @Override
        public boolean preventsRemovalOfVariableWithNonLocalValueOrPrototype() {
            return true;
        }

        public String toString() {
            return "InstanceofName:" + this.instanceofNode;
        }
    }

    private class UnusedReadReference
    extends Removable {
        final Node referenceNode;

        UnusedReadReference(RemovableBuilder builder, Node referenceNode) {
            super(builder);
            Preconditions.checkState(RemoveUnusedCode.isThisDotProperty(referenceNode) || RemoveUnusedCode.isDotPrototypeDotProperty(referenceNode), referenceNode);
            this.referenceNode = referenceNode;
        }

        @Override
        void removeInternal(AbstractCompiler compiler) {
            if (!RemoveUnusedCode.alreadyRemoved(this.referenceNode)) {
                if (RemoveUnusedCode.isThisDotProperty(this.referenceNode)) {
                    RemoveUnusedCode.this.removeExpressionCompletely(this.referenceNode);
                } else {
                    Preconditions.checkState(RemoveUnusedCode.isDotPrototypeDotProperty(this.referenceNode), this.referenceNode);
                    Node objExpression = this.referenceNode.getFirstFirstChild();
                    if (NodeUtil.mayHaveSideEffects(objExpression)) {
                        RemoveUnusedCode.this.replaceNodeWith(this.referenceNode, objExpression.detach());
                    } else {
                        RemoveUnusedCode.this.removeExpressionCompletely(this.referenceNode);
                    }
                }
            }
        }

        public String toString() {
            return "UnusedReadReference:" + this.referenceNode;
        }
    }

    private class RemovableBuilder {
        final List<Continuation> continuations = new ArrayList<Continuation>();
        @Nullable
        String propertyName = null;
        boolean isPrototypeDotPropertyReference = false;
        boolean isThisDotPropertyReference = false;

        private RemovableBuilder() {
        }

        RemovableBuilder addContinuation(Continuation continuation) {
            this.continuations.add(continuation);
            return this;
        }

        RemovableBuilder setIsPrototypeDotPropertyReference(boolean value) {
            this.isPrototypeDotPropertyReference = value;
            return this;
        }

        RemovableBuilder setIsThisDotPropertyReference(boolean value) {
            this.isThisDotPropertyReference = value;
            return this;
        }

        DestructuringAssign buildDestructuringAssign(Node targetNode) {
            return new DestructuringAssign(this, targetNode);
        }

        ClassDeclaration buildClassDeclaration(Node classNode) {
            return new ClassDeclaration(this, classNode);
        }

        NamedClassExpression buildNamedClassExpression(Node classNode) {
            return new NamedClassExpression(this, classNode);
        }

        ClassOrPrototypeNamedProperty buildClassOrPrototypeNamedProperty(Node propertyNode) {
            Preconditions.checkArgument(propertyNode.isMemberFunctionDef() || NodeUtil.isGetOrSetKey(propertyNode) || propertyNode.isStringKey() && !propertyNode.isQuotedString(), propertyNode);
            this.propertyName = propertyNode.getString();
            return new ClassOrPrototypeNamedProperty(this, propertyNode);
        }

        ObjectDefinePropertiesDefinition buildObjectDefinePropertiesDefinition(Node propertyNode) {
            this.propertyName = propertyNode.getString();
            return new ObjectDefinePropertiesDefinition(this, propertyNode);
        }

        FunctionDeclaration buildFunctionDeclaration(Node functionNode) {
            return new FunctionDeclaration(this, functionNode);
        }

        NameDeclarationStatement buildNameDeclarationStatement(Node declarationStatement) {
            return new NameDeclarationStatement(this, declarationStatement);
        }

        Assign buildNamedPropertyAssign(Node assignNode, Node propertyNode) {
            this.propertyName = propertyNode.getString();
            return new Assign(this, assignNode, Kind.NAMED_PROPERTY, propertyNode);
        }

        Assign buildComputedPropertyAssign(Node assignNode, Node propertyNode) {
            return new Assign(this, assignNode, Kind.COMPUTED_PROPERTY, propertyNode);
        }

        Assign buildVariableAssign(Node assignNode) {
            return new Assign(this, assignNode, Kind.VARIABLE, null);
        }

        ClassSetupCall buildClassSetupCall(Node callNode) {
            return new ClassSetupCall(this, callNode);
        }

        VanillaForNameDeclaration buildVanillaForNameDeclaration(Node nameNode) {
            return new VanillaForNameDeclaration(this, nameNode);
        }

        AnonymousPrototypeNamedPropertyAssign buildAnonymousPrototypeNamedPropertyAssign(Node assignNode, String propertyName) {
            this.propertyName = propertyName;
            return new AnonymousPrototypeNamedPropertyAssign(this, assignNode);
        }

        IncOrDecOp buildIncOrDepOp(Node incOrDecOp, Node propertyNode) {
            this.propertyName = propertyNode.getString();
            return new IncOrDecOp(this, incOrDecOp);
        }

        UnusedReadReference buildUnusedReadReference(Node referenceNode, Node propertyNode) {
            this.propertyName = propertyNode.getString();
            return new UnusedReadReference(this, referenceNode);
        }

        public Removable buildInstanceofName(Node instanceofNode) {
            return new InstanceofName(this, instanceofNode);
        }
    }

    private abstract class Removable {
        private final List<Continuation> continuations;
        @Nullable
        private final String propertyName;
        private final boolean isPrototypeDotPropertyReference;
        private final boolean isThisDotPropertyReference;
        private boolean continuationsAreApplied = false;
        private boolean isRemoved = false;

        Removable(RemovableBuilder builder) {
            this.continuations = builder.continuations;
            this.propertyName = builder.propertyName;
            this.isPrototypeDotPropertyReference = builder.isPrototypeDotPropertyReference;
            this.isThisDotPropertyReference = builder.isThisDotPropertyReference;
        }

        String getPropertyName() {
            return Preconditions.checkNotNull(this.propertyName);
        }

        abstract void removeInternal(AbstractCompiler var1);

        void remove(AbstractCompiler compiler) {
            if (!this.isRemoved) {
                this.isRemoved = true;
                this.removeInternal(compiler);
            }
        }

        public void applyContinuations() {
            if (!this.continuationsAreApplied) {
                this.continuationsAreApplied = true;
                for (Continuation c : this.continuations) {
                    RemoveUnusedCode.this.worklist.add(c);
                }
                this.continuations.clear();
            }
        }

        boolean isVariableAssignment() {
            return false;
        }

        boolean isNamedProperty() {
            return this.propertyName != null;
        }

        boolean isNamedPropertyAssignment() {
            return false;
        }

        boolean isAssignedValueLocal() {
            return false;
        }

        boolean isPrototypeAssignment() {
            return this.isNamedPropertyAssignment() && this.propertyName.equals("prototype");
        }

        boolean isPrototypeDotPropertyReference() {
            return this.isPrototypeDotPropertyReference;
        }

        boolean isClassOrPrototypeNamedProperty() {
            return false;
        }

        boolean isPrototypeProperty() {
            return this.isPrototypeDotPropertyReference() || this.isClassOrPrototypeNamedProperty();
        }

        boolean isThisDotPropertyReference() {
            return this.isThisDotPropertyReference;
        }

        public boolean isObjectDefinePropertiesDefinition() {
            return false;
        }

        public boolean isStaticProperty() {
            return false;
        }

        public boolean preventsRemovalOfVariableWithNonLocalValueOrPrototype() {
            return false;
        }
    }

    private class Continuation {
        private final Node node;
        private final Scope scope;

        Continuation(Node node, Scope scope) {
            this.node = node;
            this.scope = scope;
        }

        void apply() {
            if (this.node.isFunction()) {
                RemoveUnusedCode.this.traverseFunction(this.node, this.scope);
            } else {
                RemoveUnusedCode.this.traverseNode(this.node, this.scope);
            }
        }
    }

    public static class Builder {
        private final AbstractCompiler compiler;
        private boolean removeLocalVars = false;
        private boolean removeGlobals = false;
        private boolean preserveFunctionExpressionNames = false;
        private boolean removeUnusedPrototypeProperties = false;
        private boolean allowRemovalOfExternProperties = false;
        private boolean removeUnusedThisProperties = false;
        private boolean removeUnusedStaticProperties = false;
        private boolean removeUnusedObjectDefinePropertiesDefinitions = false;

        Builder(AbstractCompiler compiler) {
            this.compiler = compiler;
        }

        Builder removeLocalVars(boolean value) {
            this.removeLocalVars = value;
            return this;
        }

        Builder removeGlobals(boolean value) {
            this.removeGlobals = value;
            return this;
        }

        Builder preserveFunctionExpressionNames(boolean value) {
            this.preserveFunctionExpressionNames = value;
            return this;
        }

        Builder removeUnusedPrototypeProperties(boolean value) {
            this.removeUnusedPrototypeProperties = value;
            return this;
        }

        Builder allowRemovalOfExternProperties(boolean value) {
            this.allowRemovalOfExternProperties = value;
            return this;
        }

        Builder removeUnusedThisProperties(boolean value) {
            this.removeUnusedThisProperties = value;
            return this;
        }

        Builder removeUnusedConstructorProperties(boolean value) {
            this.removeUnusedStaticProperties = value;
            return this;
        }

        Builder removeUnusedObjectDefinePropertiesDefinitions(boolean value) {
            this.removeUnusedObjectDefinePropertiesDefinitions = value;
            return this;
        }

        RemoveUnusedCode build() {
            return new RemoveUnusedCode(this);
        }
    }
}

