/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.Es6ToEs3Util;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public final class Es6RewriteClass
implements NodeTraversal.Callback,
HotSwapCompilerPass {
    private final AbstractCompiler compiler;
    private static final FeatureSet features = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.CLASSES, FeatureSet.Feature.CLASS_EXTENDS, FeatureSet.Feature.CLASS_GETTER_SETTER, FeatureSet.Feature.NEW_TARGET);
    static final DiagnosticType DYNAMIC_EXTENDS_TYPE = DiagnosticType.error("JSC_DYNAMIC_EXTENDS_TYPE", "The class in an extends clause must be a qualified name.");
    static final DiagnosticType CLASS_REASSIGNMENT = DiagnosticType.error("CLASS_REASSIGNMENT", "Class names defined inside a function cannot be reassigned.");
    static final DiagnosticType CONFLICTING_GETTER_SETTER_TYPE = DiagnosticType.error("CONFLICTING_GETTER_SETTER_TYPE", "The types of the getter and setter for property ''{0}'' do not match.");
    static final String INHERITS = "$jscomp.inherits";

    public Es6RewriteClass(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, externs, features, this);
        TranspilationPasses.processTranspile(this.compiler, root, features, this);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, features);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        TranspilationPasses.hotSwapTranspile(this.compiler, scriptRoot, features, this);
        if (!this.compiler.hasHaltingErrors()) {
            TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, features);
        }
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case GETTER_DEF: 
            case SETTER_DEF: {
                if (!FeatureSet.ES3.contains(this.compiler.getOptions().getOutputFeatureSet())) break;
                this.cannotConvert(n, "ES5 getters/setters (consider using --language_out=ES5)");
                return false;
            }
            case NEW_TARGET: {
                this.cannotConvertYet(n, "new.target");
                break;
            }
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case CLASS: {
                this.visitClass(t, n, parent);
                break;
            }
        }
    }

    private void checkClassReassignment(Node clazz) {
        Node name = NodeUtil.getNameNode(clazz);
        Node enclosingFunction = NodeUtil.getEnclosingFunction(clazz);
        if (enclosingFunction == null) {
            return;
        }
        CheckClassAssignments checkAssigns = new CheckClassAssignments(name);
        NodeTraversal.traverse(this.compiler, enclosingFunction, checkAssigns);
    }

    private void visitClass(NodeTraversal t, Node classNode, Node parent) {
        Node var;
        Node definePropsCall;
        this.checkClassReassignment(classNode);
        ClassDeclarationMetadata metadata = ClassDeclarationMetadata.create(classNode, parent);
        if (metadata == null || metadata.fullClassName == null) {
            throw new IllegalStateException("Can only convert classes that are declarations or the right hand side of a simple assignment: " + classNode);
        }
        if (metadata.hasSuperClass() && !metadata.superClassNameNode.isQualifiedName()) {
            this.compiler.report(JSError.make(metadata.superClassNameNode, DYNAMIC_EXTENDS_TYPE, new String[0]));
            return;
        }
        Preconditions.checkState(NodeUtil.isStatement(metadata.insertionPoint), "insertion point must be a statement: %s", (Object)metadata.insertionPoint);
        Node constructor = null;
        JSDocInfo ctorJSDocInfo = null;
        Node classMembers = classNode.getLastChild();
        for (Node member : classMembers.children()) {
            if (member.isComputedProp() && (member.getBooleanProp((byte)73) || member.getBooleanProp((byte)74)) || member.isGetterDef() || member.isSetterDef()) {
                this.visitNonMethodMember(member, metadata);
                continue;
            }
            if (member.isMemberFunctionDef() && member.getString().equals("constructor")) {
                ctorJSDocInfo = member.getJSDocInfo();
                constructor = member.getFirstChild().detach();
                if (metadata.anonymous) continue;
                constructor.replaceChild(constructor.getFirstChild(), metadata.classNameNode.cloneNode());
                continue;
            }
            if (member.isEmpty()) continue;
            Preconditions.checkState(member.isMemberFunctionDef() || member.isComputedProp(), "Unexpected class member:", (Object)member);
            Preconditions.checkState(!member.getBooleanProp((byte)75), "Member variables should have been transpiled earlier:", (Object)member);
            this.visitMethod(member, metadata);
        }
        if (metadata.definePropertiesObjForPrototype.hasChildren()) {
            this.compiler.ensureLibraryInjected("util/global", false);
            definePropsCall = IR.exprResult(IR.call(NodeUtil.newQName(this.compiler, "$jscomp.global.Object.defineProperties"), NodeUtil.newQName(this.compiler, metadata.fullClassName + ".prototype"), metadata.definePropertiesObjForPrototype));
            definePropsCall.useSourceInfoIfMissingFromForTree(classNode);
            metadata.insertNodeAndAdvance(definePropsCall);
        }
        if (metadata.definePropertiesObjForClass.hasChildren()) {
            this.compiler.ensureLibraryInjected("util/global", false);
            definePropsCall = IR.exprResult(IR.call(NodeUtil.newQName(this.compiler, "$jscomp.global.Object.defineProperties"), NodeUtil.newQName(this.compiler, metadata.fullClassName), metadata.definePropertiesObjForClass));
            definePropsCall.useSourceInfoIfMissingFromForTree(classNode);
            metadata.insertNodeAndAdvance(definePropsCall);
        }
        Preconditions.checkNotNull(constructor);
        JSDocInfo classJSDoc = NodeUtil.getBestJSDocInfo(classNode);
        JSDocInfoBuilder newInfo = JSDocInfoBuilder.maybeCopyFrom(classJSDoc);
        newInfo.recordConstructor();
        Node enclosingStatement = NodeUtil.getEnclosingStatement(classNode);
        if (metadata.hasSuperClass()) {
            String superClassString = metadata.superClassNameNode.getQualifiedName();
            if (newInfo.isInterfaceRecorded()) {
                newInfo.recordExtendedInterface(new JSTypeExpression(new Node(Token.BANG, IR.string(superClassString)), metadata.superClassNameNode.getSourceFileName()));
            } else {
                if (!classNode.isFromExterns()) {
                    Node classNameNode = NodeUtil.newQName(this.compiler, metadata.fullClassName).useSourceInfoIfMissingFrom(metadata.classNameNode);
                    Node superClassNameNode = metadata.superClassNameNode.cloneTree();
                    Node inherits = IR.call(NodeUtil.newQName(this.compiler, INHERITS), classNameNode, superClassNameNode);
                    Node inheritsCall = IR.exprResult(inherits);
                    this.compiler.ensureLibraryInjected("es6/util/inherits", false);
                    inheritsCall.useSourceInfoIfMissingFromForTree(metadata.superClassNameNode);
                    enclosingStatement.getParent().addChildAfter(inheritsCall, enclosingStatement);
                }
                newInfo.recordBaseType(new JSTypeExpression(new Node(Token.BANG, IR.string(superClassString)), metadata.superClassNameNode.getSourceFileName()));
            }
        }
        this.addTypeDeclarations(metadata, enclosingStatement);
        this.updateClassJsDoc(ctorJSDocInfo, newInfo);
        if (NodeUtil.isStatement(classNode)) {
            constructor.getFirstChild().setString("");
            Node ctorVar = IR.let(metadata.classNameNode.cloneNode(), constructor);
            ctorVar.useSourceInfoIfMissingFromForTree(classNode);
            parent.replaceChild(classNode, ctorVar);
            NodeUtil.addFeatureToScript(t.getCurrentFile(), FeatureSet.Feature.LET_DECLARATIONS);
        } else {
            parent.replaceChild(classNode, constructor);
        }
        NodeUtil.markFunctionsDeleted(classNode, this.compiler);
        if (NodeUtil.isStatement(constructor)) {
            constructor.setJSDocInfo(newInfo.build());
        } else if (parent.isName()) {
            var = parent.getParent();
            var.setJSDocInfo(newInfo.build());
        } else if (constructor.getParent().isName()) {
            var = constructor.getGrandparent();
            var.setJSDocInfo(newInfo.build());
        } else if (parent.isAssign()) {
            parent.setJSDocInfo(newInfo.build());
        } else {
            throw new IllegalStateException("Unexpected parent node " + parent);
        }
        constructor.putBooleanProp((byte)92, true);
        t.reportCodeChange();
    }

    private void updateClassJsDoc(@Nullable JSDocInfo ctorInfo, JSDocInfoBuilder newInfo) {
        if (!(newInfo.isUnrestrictedRecorded() || newInfo.isDictRecorded() || newInfo.isStructRecorded())) {
            newInfo.recordStruct();
        }
        if (ctorInfo != null) {
            if (!ctorInfo.getSuppressions().isEmpty()) {
                newInfo.recordSuppressions(ctorInfo.getSuppressions());
            }
            for (String param : ctorInfo.getParameterNames()) {
                newInfo.recordParameter(param, ctorInfo.getParameterType(param));
                newInfo.recordParameterDescription(param, ctorInfo.getDescriptionForParameter(param));
            }
            for (JSTypeExpression thrown : ctorInfo.getThrownTypes()) {
                newInfo.recordThrowType(thrown);
                newInfo.recordThrowDescription(thrown, ctorInfo.getThrowsDescriptionForType(thrown));
            }
            JSDocInfo.Visibility visibility = ctorInfo.getVisibility();
            if (visibility != null && visibility != JSDocInfo.Visibility.INHERITED) {
                newInfo.recordVisibility(visibility);
            }
            if (ctorInfo.isDeprecated()) {
                newInfo.recordDeprecated();
            }
            if (ctorInfo.getDeprecationReason() != null && !newInfo.isDeprecationReasonRecorded()) {
                newInfo.recordDeprecationReason(ctorInfo.getDeprecationReason());
            }
            newInfo.mergePropertyBitfieldFrom(ctorInfo);
            for (String templateType : ctorInfo.getTemplateTypeNames()) {
                newInfo.recordTemplateTypeName(templateType);
            }
        }
    }

    @Nullable
    private JSTypeExpression getTypeFromGetterOrSetter(Node node) {
        JSDocInfo info = node.getJSDocInfo();
        if (info != null) {
            JSTypeExpression paramType;
            boolean getter;
            boolean bl = getter = node.isGetterDef() || node.getBooleanProp((byte)73);
            if (getter && info.getReturnType() != null) {
                return info.getReturnType();
            }
            Set<String> paramNames = info.getParameterNames();
            if (paramNames.size() == 1 && (paramType = info.getParameterType(Iterables.getOnlyElement(info.getParameterNames()))) != null) {
                return paramType;
            }
        }
        return null;
    }

    private void addToDefinePropertiesObject(ClassDeclarationMetadata metadata, Node member) {
        Node prop;
        Node obj = member.isStaticMember() ? metadata.definePropertiesObjForClass : metadata.definePropertiesObjForPrototype;
        Node node = prop = member.isComputedProp() ? NodeUtil.getFirstComputedPropMatchingKey(obj, member.getFirstChild()) : NodeUtil.getFirstPropMatchingKey(obj, member.getString());
        if (prop == null) {
            prop = IR.objectlit(IR.stringKey("configurable", IR.trueNode()), IR.stringKey("enumerable", IR.trueNode()));
            if (member.isComputedProp()) {
                obj.addChildToBack(IR.computedProp(member.getFirstChild().cloneTree(), prop));
            } else {
                obj.addChildToBack(IR.stringKey(member.getString(), prop));
            }
        }
        Node function = member.getLastChild();
        JSDocInfoBuilder info = JSDocInfoBuilder.maybeCopyFrom(NodeUtil.getBestJSDocInfo(function));
        info.recordThisType(new JSTypeExpression(new Node(Token.BANG, IR.string(metadata.fullClassName)), member.getSourceFileName()));
        Node stringKey = IR.stringKey(member.isGetterDef() || member.getBooleanProp((byte)73) ? "get" : "set", function.detach());
        stringKey.setJSDocInfo(info.build());
        prop.addChildToBack(stringKey);
        prop.useSourceInfoIfMissingFromForTree(member);
    }

    private void visitNonMethodMember(Node member, ClassDeclarationMetadata metadata) {
        JSTypeExpression existingType;
        String memberName;
        Map membersToDeclare;
        if (member.isComputedProp() && member.isStaticMember()) {
            this.cannotConvertYet(member, "Static computed property");
            return;
        }
        if (member.isComputedProp() && !member.getFirstChild().isQualifiedName()) {
            this.cannotConvert(member.getFirstChild(), "Computed property with non-qualified-name key");
            return;
        }
        JSTypeExpression typeExpr = this.getTypeFromGetterOrSetter(member);
        this.addToDefinePropertiesObject(metadata, member);
        if (member.isComputedProp()) {
            Preconditions.checkState(!member.isStaticMember());
            membersToDeclare = metadata.prototypeComputedPropsToDeclare;
            memberName = member.getFirstChild().getQualifiedName();
        } else {
            membersToDeclare = member.isStaticMember() ? metadata.classMembersToDeclare : metadata.prototypeMembersToDeclare;
            memberName = member.getString();
        }
        JSDocInfo existingJSDoc = (JSDocInfo)membersToDeclare.get(memberName);
        JSTypeExpression jSTypeExpression = existingType = existingJSDoc == null ? null : existingJSDoc.getType();
        if (existingType != null && typeExpr != null && !existingType.equals(typeExpr)) {
            this.compiler.report(JSError.make(member, CONFLICTING_GETTER_SETTER_TYPE, memberName));
        } else {
            JSDocInfoBuilder jsDoc = new JSDocInfoBuilder(false);
            if (member.getJSDocInfo() != null && member.getJSDocInfo().isExport()) {
                jsDoc.recordExport();
                jsDoc.recordVisibility(JSDocInfo.Visibility.PUBLIC);
            }
            if (member.getJSDocInfo() != null && member.getJSDocInfo().isOverride()) {
                jsDoc.recordOverride();
            } else if (typeExpr == null) {
                typeExpr = new JSTypeExpression(new Node(Token.QMARK), member.getSourceFileName());
            }
            if (typeExpr != null) {
                jsDoc.recordType(typeExpr.copy());
            }
            if (member.isStaticMember() && !member.isComputedProp()) {
                jsDoc.recordNoCollapse();
            }
            membersToDeclare.put(memberName, jsDoc.build());
        }
    }

    private void visitMethod(Node member, ClassDeclarationMetadata metadata) {
        Node qualifiedMemberAccess = Es6RewriteClass.getQualifiedMemberAccess(member, NodeUtil.newQName(this.compiler, metadata.fullClassName), NodeUtil.newQName(this.compiler, metadata.fullClassName + ".prototype"));
        Node method = member.getLastChild().detach();
        Node assign = IR.assign(qualifiedMemberAccess, method);
        assign.useSourceInfoIfMissingFrom(method);
        JSDocInfo info = member.getJSDocInfo();
        if (member.isStaticMember() && NodeUtil.referencesThis(assign.getLastChild())) {
            JSDocInfoBuilder memberDoc = JSDocInfoBuilder.maybeCopyFrom(info);
            memberDoc.recordThisType(new JSTypeExpression(new Node(Token.BANG, new Node(Token.QMARK)), member.getSourceFileName()));
            info = memberDoc.build();
        }
        if (info != null) {
            assign.setJSDocInfo(info);
        }
        Node newNode = NodeUtil.newExpr(assign);
        metadata.insertNodeAndAdvance(newNode);
    }

    private void addTypeDeclarations(ClassDeclarationMetadata metadata, Node insertionPoint) {
        Node declaration;
        String declaredMember;
        for (Map.Entry entry : metadata.prototypeMembersToDeclare.entrySet()) {
            declaredMember = (String)entry.getKey();
            declaration = IR.getprop(NodeUtil.newQName(this.compiler, metadata.fullClassName + ".prototype"), IR.string(declaredMember));
            declaration.setJSDocInfo((JSDocInfo)entry.getValue());
            declaration = IR.exprResult(declaration).useSourceInfoIfMissingFromForTree(metadata.classNameNode);
            insertionPoint.getParent().addChildAfter(declaration, insertionPoint);
            insertionPoint = declaration;
        }
        for (Map.Entry entry : metadata.classMembersToDeclare.entrySet()) {
            declaredMember = (String)entry.getKey();
            declaration = IR.getprop(NodeUtil.newQName(this.compiler, metadata.fullClassName), IR.string(declaredMember));
            declaration.setJSDocInfo((JSDocInfo)entry.getValue());
            declaration = IR.exprResult(declaration).useSourceInfoIfMissingFromForTree(metadata.classNameNode);
            insertionPoint.getParent().addChildAfter(declaration, insertionPoint);
            insertionPoint = declaration;
        }
        for (Map.Entry entry : metadata.prototypeComputedPropsToDeclare.entrySet()) {
            declaredMember = (String)entry.getKey();
            declaration = IR.getelem(NodeUtil.newQName(this.compiler, metadata.fullClassName + ".prototype"), NodeUtil.newQName(this.compiler, declaredMember));
            declaration.setJSDocInfo((JSDocInfo)entry.getValue());
            declaration = IR.exprResult(declaration).useSourceInfoIfMissingFromForTree(metadata.classNameNode);
            insertionPoint.getParent().addChildAfter(declaration, insertionPoint);
            insertionPoint = declaration;
        }
    }

    private static Node getQualifiedMemberAccess(Node member, Node staticAccess, Node instanceAccess) {
        Node context = member.isStaticMember() ? staticAccess : instanceAccess;
        context = context.cloneTree().useSourceInfoIfMissingFromForTree(member);
        context.makeNonIndexableRecursive();
        if (member.isComputedProp()) {
            return IR.getelem(context, member.removeFirstChild()).useSourceInfoFrom(member);
        }
        Node methodName = member.getFirstFirstChild();
        return IR.getprop(context, IR.string(member.getString())).useSourceInfoFromForTree(methodName);
    }

    private void cannotConvert(Node n, String message) {
        this.compiler.report(JSError.make(n, Es6ToEs3Util.CANNOT_CONVERT, message));
    }

    private void cannotConvertYet(Node n, String feature) {
        this.compiler.report(JSError.make(n, Es6ToEs3Util.CANNOT_CONVERT_YET, feature));
    }

    static class ClassDeclarationMetadata {
        private Node insertionPoint;
        private final Node definePropertiesObjForPrototype;
        private final Node definePropertiesObjForClass;
        private final Map<String, JSDocInfo> prototypeMembersToDeclare;
        private final Map<String, JSDocInfo> prototypeComputedPropsToDeclare;
        private final Map<String, JSDocInfo> classMembersToDeclare;
        final String fullClassName;
        final boolean anonymous;
        final Node classNameNode;
        final Node superClassNameNode;

        private ClassDeclarationMetadata(Node insertionPoint, String fullClassName, boolean anonymous, Node classNameNode, Node superClassNameNode) {
            this.insertionPoint = insertionPoint;
            this.definePropertiesObjForClass = IR.objectlit(new Node[0]);
            this.definePropertiesObjForPrototype = IR.objectlit(new Node[0]);
            this.prototypeMembersToDeclare = new LinkedHashMap<String, JSDocInfo>();
            this.prototypeComputedPropsToDeclare = new LinkedHashMap<String, JSDocInfo>();
            this.classMembersToDeclare = new LinkedHashMap<String, JSDocInfo>();
            this.fullClassName = fullClassName;
            this.anonymous = anonymous;
            this.classNameNode = classNameNode;
            this.superClassNameNode = superClassNameNode;
        }

        static ClassDeclarationMetadata create(Node classNode, Node parent) {
            Node classNameNode = classNode.getFirstChild();
            Node superClassNameNode = classNameNode.getNext();
            if (NodeUtil.isClassDeclaration(classNode)) {
                return new ClassDeclarationMetadata(classNode, classNameNode.getString(), false, classNameNode, superClassNameNode);
            }
            if (parent.isAssign() && parent.getParent().isExprResult()) {
                String fullClassName = parent.getFirstChild().getQualifiedName();
                if (fullClassName == null) {
                    return null;
                }
                return new ClassDeclarationMetadata(parent.getParent(), fullClassName, true, classNameNode, superClassNameNode);
            }
            if (parent.isExport()) {
                return new ClassDeclarationMetadata(classNode, classNameNode.getString(), false, classNameNode, superClassNameNode);
            }
            if (parent.isName()) {
                return new ClassDeclarationMetadata(parent.getParent(), parent.getString(), true, classNameNode, superClassNameNode);
            }
            return null;
        }

        void insertNodeAndAdvance(Node newNode) {
            this.insertionPoint.getParent().addChildAfter(newNode, this.insertionPoint);
            this.insertionPoint = newNode;
        }

        boolean hasSuperClass() {
            return !this.superClassNameNode.isEmpty();
        }
    }

    private class CheckClassAssignments
    extends NodeTraversal.AbstractPostOrderCallback {
        private final Node className;

        public CheckClassAssignments(Node className) {
            this.className = className;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (!n.isAssign() || n.getFirstChild() == this.className) {
                return;
            }
            if (this.className.matchesQualifiedName(n.getFirstChild())) {
                Es6RewriteClass.this.compiler.report(JSError.make(n, CLASS_REASSIGNMENT, new String[0]));
            }
        }
    }
}

