/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.parsing;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import com.google.javascript.jscomp.parsing.Annotation;
import com.google.javascript.jscomp.parsing.AutoValue_Config;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;

@Immutable
public abstract class Config {
    abstract LanguageMode languageMode();

    abstract StrictMode strictMode();

    abstract JsDocParsing jsDocParsingMode();

    abstract RunMode runMode();

    abstract ImmutableMap<String, Annotation> annotations();

    abstract ImmutableSet<String> suppressionNames();

    abstract boolean parseInlineSourceMaps();

    final ImmutableSet<String> annotationNames() {
        return this.annotations().keySet();
    }

    static Builder builder() {
        return new AutoValue_Config.Builder().setLanguageMode(LanguageMode.TYPESCRIPT).setStrictMode(StrictMode.STRICT).setJsDocParsingMode(JsDocParsing.TYPES_ONLY).setRunMode(RunMode.STOP_AFTER_ERROR).setExtraAnnotationNames(ImmutableSet.of()).setSuppressionNames(ImmutableSet.of()).setParseInlineSourceMaps(false);
    }

    private static ImmutableMap<String, Annotation> buildAnnotations(Iterable<String> whitelist) {
        ImmutableMap.Builder<String, Annotation> annotationsBuilder = ImmutableMap.builder();
        annotationsBuilder.putAll(Annotation.recognizedAnnotations);
        for (String unrecognizedAnnotation : whitelist) {
            if (unrecognizedAnnotation.isEmpty() || Annotation.recognizedAnnotations.containsKey(unrecognizedAnnotation)) continue;
            annotationsBuilder.put(unrecognizedAnnotation, Annotation.NOT_IMPLEMENTED);
        }
        return annotationsBuilder.build();
    }

    static abstract class Builder {
        Builder() {
        }

        abstract Builder setLanguageMode(LanguageMode var1);

        abstract Builder setStrictMode(StrictMode var1);

        abstract Builder setJsDocParsingMode(JsDocParsing var1);

        abstract Builder setRunMode(RunMode var1);

        abstract Builder setParseInlineSourceMaps(boolean var1);

        abstract Builder setSuppressionNames(Iterable<String> var1);

        final Builder setExtraAnnotationNames(Iterable<String> names) {
            return this.setAnnotations(Config.buildAnnotations(names));
        }

        abstract Config build();

        abstract Builder setAnnotations(ImmutableMap<String, Annotation> var1);
    }

    public static enum RunMode {
        STOP_AFTER_ERROR,
        KEEP_GOING;

    }

    public static enum JsDocParsing {
        TYPES_ONLY,
        INCLUDE_DESCRIPTIONS_NO_WHITESPACE,
        INCLUDE_DESCRIPTIONS_WITH_WHITESPACE;


        boolean shouldParseDescriptions() {
            return this != TYPES_ONLY;
        }

        boolean shouldPreserveWhitespace() {
            return this == INCLUDE_DESCRIPTIONS_WITH_WHITESPACE;
        }
    }

    public static enum LanguageMode {
        ECMASCRIPT3(FeatureSet.ES3),
        ECMASCRIPT5(FeatureSet.ES5),
        ECMASCRIPT6(FeatureSet.ES6_MODULES),
        ECMASCRIPT7(FeatureSet.ES7_MODULES),
        ECMASCRIPT8(FeatureSet.ES8_MODULES),
        ECMASCRIPT2018(FeatureSet.ES2018_MODULES),
        ES_NEXT(FeatureSet.ES_NEXT),
        TYPESCRIPT(FeatureSet.TYPESCRIPT);

        public final FeatureSet featureSet;

        private LanguageMode(FeatureSet featureSet) {
            this.featureSet = featureSet;
        }

        public static LanguageMode minimumRequiredFor(FeatureSet.Feature feature) {
            for (LanguageMode mode : LanguageMode.values()) {
                if (!mode.featureSet.has(feature)) continue;
                return mode;
            }
            throw new IllegalStateException("No input language mode supports feature: " + (Object)((Object)feature));
        }

        public static LanguageMode minimumRequiredForSet(FeatureSet featureSet) {
            for (LanguageMode mode : LanguageMode.values()) {
                if (!mode.featureSet.contains(featureSet)) continue;
                return mode;
            }
            throw new IllegalStateException("No input language mode supports feature set: " + featureSet);
        }

        public static LanguageMode latestEcmaScript() {
            return ECMASCRIPT8;
        }
    }

    public static enum StrictMode {
        STRICT,
        SLOPPY;


        public boolean isStrict() {
            return this == STRICT;
        }
    }
}

