/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.ijs;

import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import javax.annotation.Nullable;

final class JsdocUtil {
    private JsdocUtil() {
    }

    static boolean isPrivate(@Nullable JSDocInfo jsdoc) {
        return jsdoc != null && jsdoc.getVisibility().equals((Object)JSDocInfo.Visibility.PRIVATE);
    }

    static JSDocInfo getUnusableTypeJSDoc(JSDocInfo oldJSDoc) {
        return JsdocUtil.getConstJSDoc(oldJSDoc, "UnusableType");
    }

    static JSDocInfo getQmarkTypeJSDoc() {
        return JsdocUtil.getConstJSDoc(null, new Node(Token.QMARK));
    }

    private static JSTypeExpression asTypeExpression(Node typeAst) {
        return new JSTypeExpression(typeAst, "<synthetic>");
    }

    private static JSDocInfo getConstJSDoc(JSDocInfo oldJSDoc, String contents) {
        return JsdocUtil.getConstJSDoc(oldJSDoc, Node.newString(contents));
    }

    private static JSDocInfo getConstJSDoc(JSDocInfo oldJSDoc, Node typeAst) {
        return JsdocUtil.getConstJSDoc(oldJSDoc, JsdocUtil.asTypeExpression(typeAst));
    }

    private static JSDocInfo getConstJSDoc(JSDocInfo oldJSDoc, JSTypeExpression newType) {
        JSDocInfoBuilder builder = JSDocInfoBuilder.maybeCopyFrom(oldJSDoc);
        builder.recordType(newType);
        builder.recordConstancy();
        return builder.build();
    }

    static JSDocInfo markConstant(JSDocInfo oldJSDoc) {
        JSDocInfoBuilder builder = JSDocInfoBuilder.maybeCopyFrom(oldJSDoc);
        builder.recordConstancy();
        return builder.build();
    }

    static JSDocInfo mergeJsdocs(@Nullable JSDocInfo classicJsdoc, @Nullable JSDocInfo inlineJsdoc) {
        if (inlineJsdoc == null || !inlineJsdoc.hasType()) {
            return classicJsdoc;
        }
        JSDocInfoBuilder builder = JSDocInfoBuilder.maybeCopyFrom(classicJsdoc);
        builder.recordType(inlineJsdoc.getType());
        return builder.build();
    }

    static boolean hasAnnotatedType(JSDocInfo jsdoc) {
        if (jsdoc == null) {
            return false;
        }
        return jsdoc.hasType() || jsdoc.hasReturnType() || jsdoc.getParameterCount() > 0 || jsdoc.isConstructorOrInterface() || jsdoc.hasTypedefType() || jsdoc.hasThisType() || jsdoc.hasEnumParameterType();
    }

    static JSDocInfo getJSDocForRhs(Node rhs, JSDocInfo oldJSDoc) {
        switch (NodeUtil.getKnownValueType(rhs)) {
            case BOOLEAN: {
                return JsdocUtil.getConstJSDoc(oldJSDoc, "boolean");
            }
            case NUMBER: {
                return JsdocUtil.getConstJSDoc(oldJSDoc, "number");
            }
            case STRING: {
                return JsdocUtil.getConstJSDoc(oldJSDoc, "string");
            }
            case NULL: {
                return JsdocUtil.getConstJSDoc(oldJSDoc, "null");
            }
            case VOID: {
                return JsdocUtil.getConstJSDoc(oldJSDoc, "void");
            }
            case OBJECT: {
                if (!rhs.isRegExp()) break;
                return JsdocUtil.getConstJSDoc(oldJSDoc, new Node(Token.BANG, IR.string("RegExp")));
            }
            case UNDETERMINED: {
                if (oldJSDoc == null || oldJSDoc.getDescription() == null) break;
                return JsdocUtil.getConstJSDoc(oldJSDoc, "string");
            }
        }
        if (rhs.isCast()) {
            return JsdocUtil.getConstJSDoc(oldJSDoc, rhs.getJSDocInfo().getType().getRoot());
        }
        return null;
    }

    static JSDocInfo getJSDocForName(Var decl, JSDocInfo oldJSDoc) {
        if (decl == null) {
            return null;
        }
        JSTypeExpression expr = NodeUtil.getDeclaredTypeExpression(decl.getNameNode());
        if (expr == null) {
            return null;
        }
        switch (expr.getRoot().getToken()) {
            case EQUALS: {
                Node typeRoot = expr.getRoot().getFirstChild().cloneTree();
                if (!decl.isDefaultParam()) {
                    typeRoot = new Node(Token.PIPE, typeRoot, IR.string("undefined"));
                }
                expr = JsdocUtil.asTypeExpression(typeRoot);
                break;
            }
            case ELLIPSIS: {
                Node type = new Node(Token.BANG);
                Node array = IR.string("Array");
                type.addChildToBack(array);
                Node block = new Node(Token.BLOCK, expr.getRoot().getFirstChild().cloneTree());
                array.addChildToBack(block);
                expr = JsdocUtil.asTypeExpression(type);
                break;
            }
        }
        return JsdocUtil.getConstJSDoc(oldJSDoc, expr);
    }
}

