/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;

class PrepareAst
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final boolean checkOnly;

    PrepareAst(AbstractCompiler compiler) {
        this(compiler, false);
    }

    PrepareAst(AbstractCompiler compiler, boolean checkOnly) {
        this.compiler = compiler;
        this.checkOnly = checkOnly;
    }

    private void reportChange() {
        if (this.checkOnly) {
            throw new IllegalStateException("normalizeNodeType constraints violated");
        }
    }

    @Override
    public void process(Node externs, Node root) {
        if (this.checkOnly) {
            this.normalizeNodeTypes(root);
        } else {
            if (externs != null) {
                NodeTraversal.traverse(this.compiler, externs, new PrepareAnnotations());
            }
            if (root != null) {
                NodeTraversal.traverse(this.compiler, root, new PrepareAnnotations());
            }
        }
    }

    private void normalizeNodeTypes(Node n) {
        this.normalizeBlocks(n);
        for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
            Preconditions.checkState(child.getParent() == n);
            this.normalizeNodeTypes(child);
        }
    }

    private void normalizeBlocks(Node n) {
        if (NodeUtil.isControlStructure(n) && !n.isLabel() && !n.isSwitch()) {
            for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
                if (!NodeUtil.isControlStructureCodeBlock(n, c) || c.isBlock()) continue;
                Node newBlock = IR.block().srcref(n);
                n.replaceChild(c, newBlock);
                newBlock.setIsAddedBlock(true);
                if (!c.isEmpty()) {
                    newBlock.addChildrenToFront(c);
                }
                c = newBlock;
                this.reportChange();
            }
        }
    }

    static class PrepareAnnotations
    extends NodeTraversal.AbstractPostOrderCallback {
        PrepareAnnotations() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case CALL: {
                    PrepareAnnotations.annotateCalls(n);
                    break;
                }
            }
        }

        private static void annotateCalls(Node n) {
            Preconditions.checkState(n.isCall(), n);
            Node first = n.getFirstChild();
            while (first.isCast()) {
                first = first.getFirstChild();
            }
            if (!NodeUtil.isGet(first)) {
                n.putBooleanProp((byte)50, true);
            }
            if (first.isName() && "eval".equals(first.getString())) {
                first.putBooleanProp((byte)49, true);
            }
        }
    }
}

