/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.Es6SyntacticScopeCreator;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.ReferenceCollectingCallback;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.ScopeCreator;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticSourceFile;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.TokenStream;
import com.google.javascript.rhino.TokenUtil;
import com.google.javascript.rhino.dtoa.DToA;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.TernaryValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public final class NodeUtil {
    public static final String EXTERN_OBJECT_PROPERTY_STRING = "JSCompiler_ObjectPropertyString";
    static final long MAX_POSITIVE_INTEGER_NUMBER = 0x20000000000000L;
    static final String JSC_PROPERTY_NAME_FN = "JSCompiler_renameProperty";
    static final char LARGEST_BASIC_LATIN = '\u007f';
    private static final ImmutableSet<String> CONSTRUCTORS_WITHOUT_SIDE_EFFECTS = ImmutableSet.of("Array", "Date", "Error", "Object", "RegExp", "XMLHttpRequest", new String[0]);
    private static final ImmutableSet<String> BUILTIN_FUNCTIONS_WITHOUT_SIDEEFFECTS = ImmutableSet.of("Object", "Array", "String", "Number", "Boolean", "RegExp", new String[]{"Error"});
    private static final ImmutableSet<String> OBJECT_METHODS_WITHOUT_SIDEEFFECTS = ImmutableSet.of("toString", "valueOf");
    private static final ImmutableSet<String> REGEXP_METHODS = ImmutableSet.of("test", "exec");
    private static final ImmutableSet<String> STRING_REGEXP_METHODS = ImmutableSet.of("match", "replace", "search", "split");
    private static final Set<Token> DEFINITE_CFG_ROOTS = EnumSet.of(Token.FUNCTION, Token.SCRIPT, Token.MODULE_BODY, Token.ROOT);
    private static final Set<Token> IS_STATEMENT_PARENT = EnumSet.of(Token.SCRIPT, new Token[]{Token.MODULE_BODY, Token.BLOCK, Token.LABEL, Token.NAMESPACE_ELEMENTS, Token.INTERFACE_MEMBERS});
    static final Predicate<Node> MATCH_NOT_FUNCTION = n -> !n.isFunction();
    static final Predicate<Node> MATCH_NOT_THIS_BINDING = n -> !NodeUtil.isVanillaFunction(n);

    private NodeUtil() {
    }

    static boolean isImpureTrue(Node n) {
        return NodeUtil.getImpureBooleanValue(n) == TernaryValue.TRUE;
    }

    static TernaryValue getImpureBooleanValue(Node n) {
        switch (n.getToken()) {
            case ASSIGN: 
            case COMMA: {
                return NodeUtil.getImpureBooleanValue(n.getLastChild());
            }
            case NOT: {
                TernaryValue value = NodeUtil.getImpureBooleanValue(n.getLastChild());
                return value.not();
            }
            case AND: {
                TernaryValue lhs = NodeUtil.getImpureBooleanValue(n.getFirstChild());
                TernaryValue rhs = NodeUtil.getImpureBooleanValue(n.getLastChild());
                return lhs.and(rhs);
            }
            case OR: {
                TernaryValue lhs = NodeUtil.getImpureBooleanValue(n.getFirstChild());
                TernaryValue rhs = NodeUtil.getImpureBooleanValue(n.getLastChild());
                return lhs.or(rhs);
            }
            case HOOK: {
                TernaryValue trueValue = NodeUtil.getImpureBooleanValue(n.getSecondChild());
                TernaryValue falseValue = NodeUtil.getImpureBooleanValue(n.getLastChild());
                if (trueValue.equals((Object)falseValue)) {
                    return trueValue;
                }
                return TernaryValue.UNKNOWN;
            }
            case NEW: 
            case ARRAYLIT: 
            case OBJECTLIT: {
                return TernaryValue.TRUE;
            }
            case VOID: {
                return TernaryValue.FALSE;
            }
        }
        return NodeUtil.getPureBooleanValue(n);
    }

    static TernaryValue getPureBooleanValue(Node n) {
        switch (n.getToken()) {
            case TEMPLATELIT: {
                if (!n.hasOneChild()) break;
                return TernaryValue.forBoolean(!n.getFirstChild().getString().isEmpty());
            }
            case STRING: {
                return TernaryValue.forBoolean(n.getString().length() > 0);
            }
            case NUMBER: {
                return TernaryValue.forBoolean(n.getDouble() != 0.0);
            }
            case NOT: {
                return NodeUtil.getPureBooleanValue(n.getLastChild()).not();
            }
            case NULL: 
            case FALSE: {
                return TernaryValue.FALSE;
            }
            case VOID: {
                if (NodeUtil.mayHaveSideEffects(n.getFirstChild())) break;
                return TernaryValue.FALSE;
            }
            case NAME: {
                String name = n.getString();
                if ("undefined".equals(name) || "NaN".equals(name)) {
                    return TernaryValue.FALSE;
                }
                if (!"Infinity".equals(name)) break;
                return TernaryValue.TRUE;
            }
            case TRUE: 
            case REGEXP: {
                return TernaryValue.TRUE;
            }
            case NEW: 
            case ARRAYLIT: 
            case OBJECTLIT: 
            case FUNCTION: 
            case CLASS: {
                if (NodeUtil.mayHaveSideEffects(n)) break;
                return TernaryValue.TRUE;
            }
        }
        return TernaryValue.UNKNOWN;
    }

    public static String getStringValue(Node n) {
        switch (n.getToken()) {
            case STRING: 
            case STRING_KEY: {
                return n.getString();
            }
            case TEMPLATELIT: {
                String string = "";
                for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
                    if (child.isString()) {
                        string = string + child.getString();
                        continue;
                    }
                    if (!child.isTemplateLitSub()) continue;
                    Node expression = child.getFirstChild();
                    String expressionString = NodeUtil.getStringValue(expression);
                    if (expressionString == null) {
                        return null;
                    }
                    string = string + expressionString;
                }
                return string;
            }
            case NAME: {
                String name = n.getString();
                if (!"undefined".equals(name) && !"Infinity".equals(name) && !"NaN".equals(name)) break;
                return name;
            }
            case NUMBER: {
                return DToA.numberToString(n.getDouble());
            }
            case FALSE: {
                return "false";
            }
            case TRUE: {
                return "true";
            }
            case NULL: {
                return "null";
            }
            case VOID: {
                return "undefined";
            }
            case NOT: {
                TernaryValue child = NodeUtil.getPureBooleanValue(n.getFirstChild());
                if (child == TernaryValue.UNKNOWN) break;
                return child.toBoolean(true) ? "false" : "true";
            }
            case ARRAYLIT: {
                return NodeUtil.arrayToString(n);
            }
            case OBJECTLIT: {
                return "[object Object]";
            }
        }
        return null;
    }

    static String getArrayElementStringValue(Node n) {
        return NodeUtil.isNullOrUndefined(n) || n.isEmpty() ? "" : NodeUtil.getStringValue(n);
    }

    static String arrayToString(Node literal) {
        Node first = literal.getFirstChild();
        StringBuilder result = new StringBuilder();
        for (Node n = first; n != null; n = n.getNext()) {
            String childValue = NodeUtil.getArrayElementStringValue(n);
            if (childValue == null) {
                return null;
            }
            if (n != first) {
                result.append(',');
            }
            result.append(childValue);
        }
        return result.toString();
    }

    static Double getNumberValue(Node n) {
        switch (n.getToken()) {
            case TRUE: {
                return 1.0;
            }
            case NULL: 
            case FALSE: {
                return 0.0;
            }
            case NUMBER: {
                return n.getDouble();
            }
            case VOID: {
                if (NodeUtil.mayHaveSideEffects(n.getFirstChild())) {
                    return null;
                }
                return Double.NaN;
            }
            case NAME: {
                String name = n.getString();
                if (name.equals("undefined")) {
                    return Double.NaN;
                }
                if (name.equals("NaN")) {
                    return Double.NaN;
                }
                if (name.equals("Infinity")) {
                    return Double.POSITIVE_INFINITY;
                }
                return null;
            }
            case NEG: {
                if (n.hasOneChild() && n.getFirstChild().isName() && n.getFirstChild().getString().equals("Infinity")) {
                    return Double.NEGATIVE_INFINITY;
                }
                return null;
            }
            case NOT: {
                TernaryValue child = NodeUtil.getPureBooleanValue(n.getFirstChild());
                if (child == TernaryValue.UNKNOWN) break;
                return child.toBoolean(true) ? 0.0 : 1.0;
            }
            case TEMPLATELIT: {
                String string = NodeUtil.getStringValue(n);
                if (string == null) {
                    return null;
                }
                return NodeUtil.getStringNumberValue(string);
            }
            case STRING: {
                return NodeUtil.getStringNumberValue(n.getString());
            }
            case ARRAYLIT: 
            case OBJECTLIT: {
                String value = NodeUtil.getStringValue(n);
                return value != null ? NodeUtil.getStringNumberValue(value) : null;
            }
        }
        return null;
    }

    static Double getStringNumberValue(String rawJsString) {
        if (rawJsString.contains("\u000b")) {
            return null;
        }
        String s = NodeUtil.trimJsWhiteSpace(rawJsString);
        if (s.isEmpty()) {
            return 0.0;
        }
        if (s.length() > 2 && s.charAt(0) == '0' && (s.charAt(1) == 'x' || s.charAt(1) == 'X')) {
            try {
                return Integer.parseInt(s.substring(2), 16);
            }
            catch (NumberFormatException e) {
                return Double.NaN;
            }
        }
        if (!(s.length() <= 3 || s.charAt(0) != '-' && s.charAt(0) != '+' || s.charAt(1) != '0' || s.charAt(2) != 'x' && s.charAt(2) != 'X')) {
            return null;
        }
        if (s.equals("infinity") || s.equals("-infinity") || s.equals("+infinity")) {
            return null;
        }
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    static String trimJsWhiteSpace(String s) {
        int end;
        int start = 0;
        for (end = s.length(); end > 0 && TokenUtil.isStrWhiteSpaceChar(s.charAt(end - 1)) == TernaryValue.TRUE; --end) {
        }
        while (start < end && TokenUtil.isStrWhiteSpaceChar(s.charAt(start)) == TernaryValue.TRUE) {
            ++start;
        }
        return s.substring(start, end);
    }

    public static String getName(Node n) {
        Node nameNode = NodeUtil.getNameNode(n);
        return nameNode == null ? null : nameNode.getQualifiedName();
    }

    public static Node getNameNode(Node n) {
        Preconditions.checkState(n.isFunction() || n.isClass(), n);
        Node parent = n.getParent();
        switch (parent.getToken()) {
            case NAME: {
                return parent;
            }
            case ASSIGN: {
                Node firstChild = parent.getFirstChild();
                return firstChild.isQualifiedName() ? firstChild : null;
            }
        }
        Node funNameNode = n.getFirstChild();
        return funNameNode.isEmpty() || funNameNode.getString().isEmpty() ? null : funNameNode;
    }

    public static void removeName(Node n) {
        Preconditions.checkState(n.isFunction() || n.isClass());
        Node originalName = n.getFirstChild();
        Node emptyName = n.isFunction() ? IR.name("") : IR.empty();
        n.replaceChild(originalName, emptyName.useSourceInfoFrom(originalName));
    }

    public static String getNearestFunctionName(Node n) {
        if (!n.isFunction()) {
            return null;
        }
        String name = NodeUtil.getName(n);
        if (name != null) {
            return name;
        }
        Node parent = n.getParent();
        switch (parent.getToken()) {
            case STRING_KEY: 
            case MEMBER_FUNCTION_DEF: 
            case SETTER_DEF: 
            case GETTER_DEF: {
                return parent.getString();
            }
            case NUMBER: {
                return NodeUtil.getStringValue(parent);
            }
        }
        return null;
    }

    public static Node getClassMembers(Node n) {
        Preconditions.checkArgument(n.isClass());
        return n.getLastChild();
    }

    static boolean isImmutableValue(Node n) {
        switch (n.getToken()) {
            case STRING: 
            case NUMBER: 
            case NULL: 
            case FALSE: 
            case TRUE: {
                return true;
            }
            case NOT: 
            case VOID: 
            case NEG: 
            case CAST: {
                return NodeUtil.isImmutableValue(n.getFirstChild());
            }
            case NAME: {
                String name = n.getString();
                return "undefined".equals(name) || "Infinity".equals(name) || "NaN".equals(name);
            }
            case TEMPLATELIT: {
                for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
                    if (!child.isTemplateLitSub() || NodeUtil.isImmutableValue(child.getFirstChild())) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    static boolean isSymmetricOperation(Node n) {
        switch (n.getToken()) {
            case EQ: 
            case NE: 
            case SHEQ: 
            case SHNE: 
            case MUL: {
                return true;
            }
        }
        return false;
    }

    static boolean isRelationalOperation(Node n) {
        switch (n.getToken()) {
            case GT: 
            case GE: 
            case LT: 
            case LE: {
                return true;
            }
        }
        return false;
    }

    static Token getInverseOperator(Token type) {
        switch (type) {
            case GT: {
                return Token.LT;
            }
            case LT: {
                return Token.GT;
            }
            case GE: {
                return Token.LE;
            }
            case LE: {
                return Token.GE;
            }
        }
        throw new IllegalArgumentException("Unexpected token: " + (Object)((Object)type));
    }

    public static boolean isLiteralValue(Node n, boolean includeFunctions) {
        switch (n.getToken()) {
            case CAST: {
                return NodeUtil.isLiteralValue(n.getFirstChild(), includeFunctions);
            }
            case ARRAYLIT: {
                for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
                    if (child.isEmpty() || NodeUtil.isLiteralValue(child, includeFunctions)) continue;
                    return false;
                }
                return true;
            }
            case REGEXP: {
                for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
                    if (NodeUtil.isLiteralValue(child, includeFunctions)) continue;
                    return false;
                }
                return true;
            }
            case OBJECTLIT: {
                for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
                    if (child.isMemberFunctionDef() || NodeUtil.isGetOrSetKey(child)) {
                        if (includeFunctions) continue;
                        return false;
                    }
                    if (child.isComputedProp()) {
                        if (NodeUtil.isLiteralValue(child.getFirstChild(), includeFunctions) && NodeUtil.isLiteralValue(child.getLastChild(), includeFunctions)) continue;
                        return false;
                    }
                    if (child.isSpread()) {
                        if (NodeUtil.isLiteralValue(child.getOnlyChild(), includeFunctions)) continue;
                        return false;
                    }
                    Preconditions.checkState(child.isStringKey(), child);
                    if (NodeUtil.isLiteralValue(child.getOnlyChild(), includeFunctions)) continue;
                    return false;
                }
                return true;
            }
            case FUNCTION: {
                return includeFunctions && !NodeUtil.isFunctionDeclaration(n);
            }
            case TEMPLATELIT: {
                for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
                    if (!child.isTemplateLitSub() || NodeUtil.isLiteralValue(child.getFirstChild(), includeFunctions)) continue;
                    return false;
                }
                return true;
            }
        }
        return NodeUtil.isImmutableValue(n);
    }

    static boolean isSomeCompileTimeConstStringValue(Node node) {
        if (node.isString() || node.isTemplateLit() && node.hasOneChild()) {
            return true;
        }
        if (node.isAdd()) {
            Preconditions.checkState(node.hasTwoChildren(), node);
            Node left = node.getFirstChild();
            Node right = node.getLastChild();
            return NodeUtil.isSomeCompileTimeConstStringValue(left) && NodeUtil.isSomeCompileTimeConstStringValue(right);
        }
        if (node.isHook()) {
            Node left = node.getSecondChild();
            Node right = node.getLastChild();
            return NodeUtil.isSomeCompileTimeConstStringValue(left) && NodeUtil.isSomeCompileTimeConstStringValue(right);
        }
        return false;
    }

    static boolean isValidDefineValue(Node val, Set<String> defines) {
        switch (val.getToken()) {
            case STRING: 
            case NUMBER: 
            case FALSE: 
            case TRUE: {
                return true;
            }
            case AND: 
            case OR: 
            case EQ: 
            case NE: 
            case SHEQ: 
            case SHNE: 
            case MUL: 
            case GT: 
            case GE: 
            case LT: 
            case LE: 
            case ADD: 
            case BITAND: 
            case BITNOT: 
            case BITOR: 
            case BITXOR: 
            case DIV: 
            case EXPONENT: 
            case LSH: 
            case MOD: 
            case RSH: 
            case SUB: 
            case URSH: {
                return NodeUtil.isValidDefineValue(val.getFirstChild(), defines) && NodeUtil.isValidDefineValue(val.getLastChild(), defines);
            }
            case HOOK: {
                return NodeUtil.isValidDefineValue(val.getFirstChild(), defines) && NodeUtil.isValidDefineValue(val.getSecondChild(), defines) && NodeUtil.isValidDefineValue(val.getLastChild(), defines);
            }
            case NOT: 
            case NEG: 
            case POS: {
                return NodeUtil.isValidDefineValue(val.getFirstChild(), defines);
            }
            case NAME: 
            case GETPROP: {
                if (!val.isQualifiedName()) break;
                return defines.contains(val.getQualifiedName());
            }
        }
        return false;
    }

    static boolean isEmptyBlock(Node block) {
        if (!block.isBlock()) {
            return false;
        }
        for (Node n = block.getFirstChild(); n != null; n = n.getNext()) {
            if (n.isEmpty()) continue;
            return false;
        }
        return true;
    }

    static boolean isBinaryOperator(Node n) {
        return NodeUtil.isBinaryOperatorType(n.getToken());
    }

    static boolean isBinaryOperatorType(Token type) {
        switch (type) {
            case AND: 
            case OR: 
            case EQ: 
            case NE: 
            case SHEQ: 
            case SHNE: 
            case MUL: 
            case GT: 
            case GE: 
            case LT: 
            case LE: 
            case ADD: 
            case BITAND: 
            case BITOR: 
            case BITXOR: 
            case DIV: 
            case EXPONENT: 
            case LSH: 
            case MOD: 
            case RSH: 
            case SUB: 
            case URSH: 
            case INSTANCEOF: 
            case IN: {
                return true;
            }
        }
        return false;
    }

    static boolean isUnaryOperator(Node n) {
        return NodeUtil.isUnaryOperatorType(n.getToken());
    }

    static boolean isUnaryOperatorType(Token type) {
        switch (type) {
            case NOT: 
            case VOID: 
            case NEG: 
            case BITNOT: 
            case POS: 
            case DELPROP: 
            case TYPEOF: {
                return true;
            }
        }
        return false;
    }

    static boolean isUpdateOperator(Node n) {
        return NodeUtil.isUpdateOperatorType(n.getToken());
    }

    static boolean isUpdateOperatorType(Token type) {
        switch (type) {
            case INC: 
            case DEC: {
                return true;
            }
        }
        return false;
    }

    static boolean isSimpleOperator(Node n) {
        return NodeUtil.isSimpleOperatorType(n.getToken());
    }

    static boolean isSimpleOperatorType(Token type) {
        switch (type) {
            case COMMA: 
            case NOT: 
            case VOID: 
            case NEG: 
            case EQ: 
            case NE: 
            case SHEQ: 
            case SHNE: 
            case MUL: 
            case GT: 
            case GE: 
            case LT: 
            case LE: 
            case ADD: 
            case BITAND: 
            case BITNOT: 
            case BITOR: 
            case BITXOR: 
            case DIV: 
            case EXPONENT: 
            case LSH: 
            case MOD: 
            case RSH: 
            case SUB: 
            case URSH: 
            case POS: 
            case GETPROP: 
            case INSTANCEOF: 
            case IN: 
            case TYPEOF: 
            case GETELEM: {
                return true;
            }
        }
        return false;
    }

    static boolean isAliasedConstDefinition(Node lhs) {
        JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(lhs);
        if (jsdoc == null && !lhs.isFromExterns()) {
            return false;
        }
        if (jsdoc != null && !jsdoc.hasConstAnnotation()) {
            return false;
        }
        Node rhs = NodeUtil.getRValueOfLValue(lhs);
        if (rhs == null || !rhs.isQualifiedName()) {
            return false;
        }
        Node parent = lhs.getParent();
        return lhs.isName() && parent.isVar() || lhs.isGetProp() && lhs.isQualifiedName() && parent.isAssign() && parent.getParent().isExprResult();
    }

    static boolean isTypedefDecl(Node n) {
        if (n.isVar() || n.isName() && n.getParent().isVar() || n.isGetProp() && n.getParent().isExprResult()) {
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(n);
            return jsdoc != null && jsdoc.hasTypedefType();
        }
        return false;
    }

    static boolean isEnumDecl(Node n) {
        if (NodeUtil.isNameDeclaration(n) || n.isName() && NodeUtil.isNameDeclaration(n.getParent()) || n.isGetProp() && n.getParent().isAssign() && n.getGrandparent().isExprResult() || n.isAssign() && n.getParent().isExprResult()) {
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(n);
            return jsdoc != null && jsdoc.hasEnumParameterType();
        }
        return false;
    }

    public static boolean isNamespaceDecl(Node n) {
        Node initializer;
        Node qnameNode;
        boolean isMarkedConst;
        JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(n);
        if (jsdoc != null && !jsdoc.getTypeNodes().isEmpty()) {
            return false;
        }
        boolean bl = isMarkedConst = n.getParent().isConst() || jsdoc != null && jsdoc.isConstant();
        if (!n.isFromExterns() && !isMarkedConst) {
            return false;
        }
        if (NodeUtil.isNameDeclaration(n.getParent())) {
            qnameNode = n;
            initializer = n.getFirstChild();
        } else if (n.isExprResult()) {
            Node expr = n.getFirstChild();
            if (!expr.isAssign() || !expr.getFirstChild().isGetProp()) {
                return false;
            }
            qnameNode = expr.getFirstChild();
            initializer = expr.getLastChild();
        } else if (n.isGetProp()) {
            Node parent = n.getParent();
            if (!parent.isAssign() || !parent.getParent().isExprResult()) {
                return false;
            }
            qnameNode = n;
            initializer = parent.getLastChild();
        } else {
            return false;
        }
        if (initializer == null || qnameNode == null) {
            return false;
        }
        if (initializer.isObjectLit()) {
            return true;
        }
        return initializer.isOr() && qnameNode.matchesQualifiedName(initializer.getFirstChild()) && initializer.getLastChild().isObjectLit();
    }

    public static boolean isFromTypeSummary(Node n) {
        Preconditions.checkArgument(n.isScript(), n);
        JSDocInfo info = n.getJSDocInfo();
        return info != null && info.isTypeSummary();
    }

    static Node newExpr(Node child) {
        return IR.exprResult(child).srcref(child);
    }

    static boolean mayEffectMutableState(Node n) {
        return NodeUtil.mayEffectMutableState(n, null);
    }

    static boolean mayEffectMutableState(Node n, AbstractCompiler compiler) {
        return NodeUtil.checkForStateChangeHelper(n, true, compiler);
    }

    public static boolean mayHaveSideEffects(Node n) {
        return NodeUtil.mayHaveSideEffects(n, null);
    }

    public static boolean mayHaveSideEffects(Node n, AbstractCompiler compiler) {
        return NodeUtil.checkForStateChangeHelper(n, false, compiler);
    }

    private static boolean checkForStateChangeHelper(Node n, boolean checkForNewObjects, AbstractCompiler compiler) {
        switch (n.getToken()) {
            case THROW: 
            case YIELD: 
            case EXPORT: 
            case VAR: 
            case LET: 
            case CONST: {
                return true;
            }
            case OBJECTLIT: {
                if (checkForNewObjects) {
                    return true;
                }
                for (Node key = n.getFirstChild(); key != null; key = key.getNext()) {
                    for (Node c = key.getFirstChild(); c != null; c = c.getNext()) {
                        if (!NodeUtil.checkForStateChangeHelper(c, checkForNewObjects, compiler)) continue;
                        return true;
                    }
                }
                return false;
            }
            case ARRAYLIT: 
            case REGEXP: {
                if (!checkForNewObjects) break;
                return true;
            }
            case SPREAD: {
                Node expr = n.getOnlyChild();
                if (expr.isArrayLit()) break;
                return true;
            }
            case NAME: {
                if (!n.hasChildren()) break;
                return true;
            }
            case FUNCTION: {
                return checkForNewObjects || NodeUtil.isFunctionDeclaration(n);
            }
            case CLASS: {
                return checkForNewObjects || NodeUtil.isClassDeclaration(n) || NodeUtil.checkForStateChangeHelper(n.getSecondChild(), checkForNewObjects, compiler) || NodeUtil.checkForStateChangeHelper(n.getLastChild(), checkForNewObjects, compiler);
            }
            case CLASS_MEMBERS: {
                for (Node member = n.getFirstChild(); member != null; member = member.getNext()) {
                    if (!member.isComputedProp() || !NodeUtil.checkForStateChangeHelper(member.getFirstChild(), checkForNewObjects, compiler)) continue;
                    return true;
                }
                return false;
            }
            case NEW: {
                if (checkForNewObjects) {
                    return true;
                }
                if (!NodeUtil.constructorCallHasSideEffects(n)) break;
                return true;
            }
            case CALL: {
                if (!NodeUtil.functionCallHasSideEffects(n, compiler)) break;
                return true;
            }
            case TAGGED_TEMPLATELIT: {
                return NodeUtil.functionCallHasSideEffects(n, compiler);
            }
            case AND: 
            case OR: 
            case HOOK: 
            case TEMPLATELIT: 
            case STRING: 
            case NUMBER: 
            case NULL: 
            case FALSE: 
            case TRUE: 
            case STRING_KEY: 
            case CAST: 
            case BLOCK: 
            case ROOT: 
            case EXPR_RESULT: 
            case IF: 
            case PARAM_LIST: 
            case THIS: 
            case SWITCH: 
            case TEMPLATELIT_SUB: 
            case TRY: 
            case EMPTY: 
            case COMPUTED_PROP: {
                break;
            }
            default: {
                if (NodeUtil.isSimpleOperator(n)) break;
                if (NodeUtil.isAssignmentOp(n)) {
                    Node assignTarget = n.getFirstChild();
                    if (assignTarget.isName()) {
                        return true;
                    }
                    if (NodeUtil.checkForStateChangeHelper(n.getFirstChild(), checkForNewObjects, compiler) || NodeUtil.checkForStateChangeHelper(n.getLastChild(), checkForNewObjects, compiler)) {
                        return true;
                    }
                    if (NodeUtil.isGet(assignTarget)) {
                        Node current = assignTarget.getFirstChild();
                        if (NodeUtil.evaluatesToLocalValue(current)) {
                            return false;
                        }
                        while (NodeUtil.isGet(current)) {
                            current = current.getFirstChild();
                        }
                        return !NodeUtil.isLiteralValue(current, true);
                    }
                    return !NodeUtil.isLiteralValue(assignTarget, true);
                }
                return true;
            }
        }
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            if (!NodeUtil.checkForStateChangeHelper(c, checkForNewObjects, compiler)) continue;
            return true;
        }
        return false;
    }

    static boolean constructorCallHasSideEffects(Node callNode) {
        Preconditions.checkArgument(callNode.isNew(), "Expected NEW node, got %s", (Object)callNode.getToken());
        if (callNode.isNoSideEffectsCall()) {
            return false;
        }
        if (callNode.isOnlyModifiesArgumentsCall() && NodeUtil.allArgsUnescapedLocal(callNode)) {
            return false;
        }
        Node nameNode = callNode.getFirstChild();
        return !nameNode.isName() || !CONSTRUCTORS_WITHOUT_SIDE_EFFECTS.contains(nameNode.getString());
    }

    static boolean functionCallHasSideEffects(Node callNode) {
        return NodeUtil.functionCallHasSideEffects(callNode, null);
    }

    static boolean functionCallHasSideEffects(Node callNode, @Nullable AbstractCompiler compiler) {
        Preconditions.checkState(callNode.isCall() || callNode.isTaggedTemplateLit(), callNode);
        if (callNode.isNoSideEffectsCall()) {
            return false;
        }
        if (callNode.isOnlyModifiesArgumentsCall() && NodeUtil.allArgsUnescapedLocal(callNode)) {
            return false;
        }
        Node callee = callNode.getFirstChild();
        if (callee.isName()) {
            String name = callee.getString();
            if (BUILTIN_FUNCTIONS_WITHOUT_SIDEEFFECTS.contains(name)) {
                return false;
            }
        } else if (callee.isGetProp()) {
            if (callNode.hasOneChild() && OBJECT_METHODS_WITHOUT_SIDEEFFECTS.contains(callee.getLastChild().getString())) {
                return false;
            }
            if (callNode.isOnlyModifiesThisCall() && NodeUtil.evaluatesToLocalValue(callee.getFirstChild())) {
                return false;
            }
            if (callee.getFirstChild().isName() && callee.isQualifiedName() && callee.getFirstChild().getString().equals("Math")) {
                switch (callee.getLastChild().getString()) {
                    case "abs": 
                    case "acos": 
                    case "acosh": 
                    case "asin": 
                    case "asinh": 
                    case "atan": 
                    case "atanh": 
                    case "atan2": 
                    case "cbrt": 
                    case "ceil": 
                    case "cos": 
                    case "cosh": 
                    case "exp": 
                    case "expm1": 
                    case "floor": 
                    case "hypot": 
                    case "log": 
                    case "log10": 
                    case "log1p": 
                    case "log2": 
                    case "max": 
                    case "min": 
                    case "pow": 
                    case "round": 
                    case "sign": 
                    case "sin": 
                    case "sinh": 
                    case "sqrt": 
                    case "tan": 
                    case "tanh": 
                    case "trunc": {
                        return false;
                    }
                    case "random": {
                        return !callNode.hasOneChild();
                    }
                }
            }
            if (compiler != null && !compiler.hasRegExpGlobalReferences()) {
                if (callee.getFirstChild().isRegExp() && REGEXP_METHODS.contains(callee.getLastChild().getString())) {
                    return false;
                }
                if (NodeUtil.isTypedAsString(callee.getFirstChild(), compiler)) {
                    String method = callee.getLastChild().getString();
                    Node param = callee.getNext();
                    if (param != null) {
                        if (param.isString()) {
                            if (STRING_REGEXP_METHODS.contains(method)) {
                                return false;
                            }
                        } else if (param.isRegExp()) {
                            if ("replace".equals(method)) {
                                return !param.getNext().isString();
                            }
                            if (STRING_REGEXP_METHODS.contains(method)) {
                                return false;
                            }
                        }
                    }
                }
            }
        }
        return true;
    }

    private static boolean isTypedAsString(Node n, AbstractCompiler compiler) {
        JSType nativeStringType;
        JSType type;
        if (n.isString()) {
            return true;
        }
        return compiler.getOptions().useTypesForLocalOptimization && (type = n.getJSType()) != null && type.isEquivalentTo(nativeStringType = compiler.getTypeRegistry().getNativeType(JSTypeNative.STRING_TYPE));
    }

    static boolean callHasLocalResult(Node n) {
        Preconditions.checkState(n.isCall() || n.isTaggedTemplateLit(), n);
        return (n.getSideEffectFlags() & 0x10) > 0;
    }

    static boolean newHasLocalResult(Node n) {
        Preconditions.checkState(n.isNew(), n);
        return n.isOnlyModifiesThisCall();
    }

    static boolean nodeTypeMayHaveSideEffects(Node n) {
        return NodeUtil.nodeTypeMayHaveSideEffects(n, null);
    }

    static boolean nodeTypeMayHaveSideEffects(Node n, AbstractCompiler compiler) {
        if (NodeUtil.isAssignmentOp(n)) {
            return true;
        }
        switch (n.getToken()) {
            case DELPROP: 
            case INC: 
            case DEC: 
            case THROW: 
            case YIELD: 
            case AWAIT: 
            case FOR_IN: 
            case FOR_OF: 
            case FOR_AWAIT_OF: {
                return true;
            }
            case CALL: {
                return NodeUtil.functionCallHasSideEffects(n, compiler);
            }
            case NEW: {
                return NodeUtil.constructorCallHasSideEffects(n);
            }
            case NAME: {
                return n.hasChildren();
            }
        }
        return false;
    }

    static boolean allArgsUnescapedLocal(Node callOrNew) {
        for (Node arg = callOrNew.getSecondChild(); arg != null; arg = arg.getNext()) {
            if (NodeUtil.evaluatesToLocalValue(arg)) continue;
            return false;
        }
        return true;
    }

    static boolean canBeSideEffected(Node n) {
        Set<String> emptySet = Collections.emptySet();
        return NodeUtil.canBeSideEffected(n, emptySet, null);
    }

    static boolean canBeSideEffected(Node n, Set<String> knownConstants, @Nullable Scope scope) {
        switch (n.getToken()) {
            case NEW: 
            case YIELD: 
            case CALL: {
                return true;
            }
            case NAME: {
                return !NodeUtil.isConstantVar(n, scope) && !knownConstants.contains(n.getString());
            }
            case GETPROP: 
            case GETELEM: {
                return true;
            }
            case FUNCTION: {
                Preconditions.checkState(!NodeUtil.isFunctionDeclaration(n), n);
                return false;
            }
        }
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            if (!NodeUtil.canBeSideEffected(c, knownConstants, scope)) continue;
            return true;
        }
        return false;
    }

    public static int precedence(Token type) {
        switch (type) {
            case COMMA: {
                return 0;
            }
            case ASSIGN: 
            case ASSIGN_BITOR: 
            case ASSIGN_BITXOR: 
            case ASSIGN_BITAND: 
            case ASSIGN_LSH: 
            case ASSIGN_RSH: 
            case ASSIGN_URSH: 
            case ASSIGN_ADD: 
            case ASSIGN_SUB: 
            case ASSIGN_MUL: 
            case ASSIGN_EXPONENT: 
            case ASSIGN_DIV: 
            case ASSIGN_MOD: {
                return 1;
            }
            case YIELD: {
                return 2;
            }
            case HOOK: {
                return 3;
            }
            case OR: {
                return 4;
            }
            case AND: {
                return 5;
            }
            case BITOR: {
                return 6;
            }
            case BITXOR: {
                return 7;
            }
            case BITAND: {
                return 8;
            }
            case EQ: 
            case NE: 
            case SHEQ: 
            case SHNE: {
                return 9;
            }
            case GT: 
            case GE: 
            case LT: 
            case LE: 
            case INSTANCEOF: 
            case IN: {
                return 10;
            }
            case LSH: 
            case RSH: 
            case URSH: {
                return 11;
            }
            case ADD: 
            case SUB: {
                return 12;
            }
            case MUL: 
            case DIV: 
            case MOD: {
                return 13;
            }
            case EXPONENT: {
                return 14;
            }
            case NOT: 
            case NEW: 
            case VOID: 
            case NEG: 
            case BITNOT: 
            case POS: 
            case DELPROP: 
            case TYPEOF: 
            case AWAIT: {
                return 15;
            }
            case INC: 
            case DEC: {
                return 16;
            }
            case ARRAYLIT: 
            case OBJECTLIT: 
            case TEMPLATELIT: 
            case STRING: 
            case NUMBER: 
            case NULL: 
            case FALSE: 
            case NAME: 
            case TRUE: 
            case REGEXP: 
            case FUNCTION: 
            case CLASS: 
            case STRING_KEY: 
            case GETPROP: 
            case GETELEM: 
            case SPREAD: 
            case CALL: 
            case TAGGED_TEMPLATELIT: 
            case THIS: 
            case EMPTY: 
            case NEW_TARGET: 
            case ARRAY_PATTERN: 
            case DEFAULT_VALUE: 
            case DESTRUCTURING_LHS: 
            case INTERFACE: 
            case OBJECT_PATTERN: 
            case REST: 
            case MEMBER_VARIABLE_DEF: 
            case INDEX_SIGNATURE: 
            case CALL_SIGNATURE: 
            case SUPER: 
            case UNION_TYPE: {
                return 17;
            }
            case FUNCTION_TYPE: {
                return 18;
            }
            case ARRAY_TYPE: 
            case PARAMETERIZED_TYPE: {
                return 19;
            }
            case STRING_TYPE: 
            case NUMBER_TYPE: 
            case BOOLEAN_TYPE: 
            case ANY_TYPE: 
            case RECORD_TYPE: 
            case NULLABLE_TYPE: 
            case NAMED_TYPE: 
            case UNDEFINED_TYPE: 
            case GENERIC_TYPE: {
                return 20;
            }
            case CAST: {
                return 21;
            }
        }
        throw new IllegalStateException("Unknown precedence for " + (Object)((Object)type));
    }

    public static boolean isUndefined(Node n) {
        switch (n.getToken()) {
            case VOID: {
                return true;
            }
            case NAME: {
                return n.getString().equals("undefined");
            }
        }
        return false;
    }

    public static boolean isNullOrUndefined(Node n) {
        return n.isNull() || NodeUtil.isUndefined(n);
    }

    static boolean isImmutableResult(Node n) {
        return NodeUtil.allResultsMatch(n, NodeUtil::isImmutableValue);
    }

    static boolean allResultsMatch(Node n, Predicate<Node> p) {
        switch (n.getToken()) {
            case CAST: {
                return NodeUtil.allResultsMatch(n.getFirstChild(), p);
            }
            case ASSIGN: 
            case COMMA: {
                return NodeUtil.allResultsMatch(n.getLastChild(), p);
            }
            case AND: 
            case OR: {
                return NodeUtil.allResultsMatch(n.getFirstChild(), p) && NodeUtil.allResultsMatch(n.getLastChild(), p);
            }
            case HOOK: {
                return NodeUtil.allResultsMatch(n.getSecondChild(), p) && NodeUtil.allResultsMatch(n.getLastChild(), p);
            }
        }
        return p.apply(n);
    }

    public static ValueType getKnownValueType(Node n) {
        switch (n.getToken()) {
            case CAST: {
                return NodeUtil.getKnownValueType(n.getFirstChild());
            }
            case ASSIGN: 
            case COMMA: {
                return NodeUtil.getKnownValueType(n.getLastChild());
            }
            case AND: 
            case OR: {
                return NodeUtil.and(NodeUtil.getKnownValueType(n.getFirstChild()), NodeUtil.getKnownValueType(n.getLastChild()));
            }
            case HOOK: {
                return NodeUtil.and(NodeUtil.getKnownValueType(n.getSecondChild()), NodeUtil.getKnownValueType(n.getLastChild()));
            }
            case ADD: {
                ValueType last = NodeUtil.getKnownValueType(n.getLastChild());
                if (last == ValueType.STRING) {
                    return ValueType.STRING;
                }
                ValueType first = NodeUtil.getKnownValueType(n.getFirstChild());
                if (first == ValueType.STRING) {
                    return ValueType.STRING;
                }
                if (first == ValueType.OBJECT || last == ValueType.OBJECT) {
                    return ValueType.UNDETERMINED;
                }
                if (!NodeUtil.mayBeString(first) && !NodeUtil.mayBeString(last)) {
                    return ValueType.NUMBER;
                }
                return ValueType.UNDETERMINED;
            }
            case ASSIGN_ADD: {
                ValueType last = NodeUtil.getKnownValueType(n.getLastChild());
                if (last == ValueType.STRING) {
                    return ValueType.STRING;
                }
                return ValueType.UNDETERMINED;
            }
            case NAME: {
                String name = n.getString();
                if (name.equals("undefined")) {
                    return ValueType.VOID;
                }
                if (name.equals("NaN")) {
                    return ValueType.NUMBER;
                }
                if (name.equals("Infinity")) {
                    return ValueType.NUMBER;
                }
                return ValueType.UNDETERMINED;
            }
            case NUMBER: 
            case NEG: 
            case MUL: 
            case BITAND: 
            case BITNOT: 
            case BITOR: 
            case BITXOR: 
            case DIV: 
            case EXPONENT: 
            case LSH: 
            case MOD: 
            case RSH: 
            case SUB: 
            case URSH: 
            case POS: 
            case INC: 
            case DEC: 
            case ASSIGN_BITOR: 
            case ASSIGN_BITXOR: 
            case ASSIGN_BITAND: 
            case ASSIGN_LSH: 
            case ASSIGN_RSH: 
            case ASSIGN_URSH: 
            case ASSIGN_SUB: 
            case ASSIGN_MUL: 
            case ASSIGN_EXPONENT: 
            case ASSIGN_DIV: 
            case ASSIGN_MOD: {
                return ValueType.NUMBER;
            }
            case NOT: 
            case FALSE: 
            case TRUE: 
            case EQ: 
            case NE: 
            case SHEQ: 
            case SHNE: 
            case GT: 
            case GE: 
            case LT: 
            case LE: 
            case INSTANCEOF: 
            case IN: 
            case DELPROP: {
                return ValueType.BOOLEAN;
            }
            case TEMPLATELIT: 
            case STRING: 
            case TYPEOF: {
                return ValueType.STRING;
            }
            case NULL: {
                return ValueType.NULL;
            }
            case VOID: {
                return ValueType.VOID;
            }
            case NEW: 
            case ARRAYLIT: 
            case OBJECTLIT: 
            case REGEXP: 
            case FUNCTION: {
                return ValueType.OBJECT;
            }
        }
        return ValueType.UNDETERMINED;
    }

    static ValueType and(ValueType a, ValueType b) {
        return a == b ? a : ValueType.UNDETERMINED;
    }

    public static boolean isNumericResult(Node n) {
        return NodeUtil.getKnownValueType(n) == ValueType.NUMBER;
    }

    public static boolean isBooleanResult(Node n) {
        return NodeUtil.getKnownValueType(n) == ValueType.BOOLEAN;
    }

    public static boolean isStringResult(Node n) {
        return NodeUtil.getKnownValueType(n) == ValueType.STRING;
    }

    public static boolean isObjectResult(Node n) {
        return NodeUtil.getKnownValueType(n) == ValueType.OBJECT;
    }

    static boolean mayBeString(Node n) {
        return NodeUtil.mayBeString(n, false);
    }

    static boolean mayBeString(Node n, boolean useType) {
        JSType type;
        if (useType && (type = n.getJSType()) != null) {
            if (type.isStringValueType()) {
                return true;
            }
            if (type.isNumberValueType() || type.isBooleanValueType() || type.isNullType() || type.isVoidType()) {
                return false;
            }
        }
        return NodeUtil.mayBeString(NodeUtil.getKnownValueType(n));
    }

    static boolean mayBeString(ValueType type) {
        switch (type) {
            case BOOLEAN: 
            case NULL: 
            case NUMBER: 
            case VOID: {
                return false;
            }
            case OBJECT: 
            case STRING: 
            case UNDETERMINED: {
                return true;
            }
        }
        throw new IllegalStateException("unexpected");
    }

    static boolean mayBeObject(Node n) {
        return NodeUtil.mayBeObject(NodeUtil.getKnownValueType(n));
    }

    static boolean mayBeObject(ValueType type) {
        switch (type) {
            case BOOLEAN: 
            case NULL: 
            case NUMBER: 
            case VOID: 
            case STRING: {
                return false;
            }
            case OBJECT: 
            case UNDETERMINED: {
                return true;
            }
        }
        throw new IllegalStateException("unexpected");
    }

    static boolean isAssociative(Token type) {
        switch (type) {
            case AND: 
            case OR: 
            case MUL: 
            case BITAND: 
            case BITOR: 
            case BITXOR: {
                return true;
            }
        }
        return false;
    }

    static boolean isCommutative(Token type) {
        switch (type) {
            case MUL: 
            case BITAND: 
            case BITOR: 
            case BITXOR: {
                return true;
            }
        }
        return false;
    }

    public static boolean isAssignmentOp(Node n) {
        switch (n.getToken()) {
            case ASSIGN: 
            case ASSIGN_BITOR: 
            case ASSIGN_BITXOR: 
            case ASSIGN_BITAND: 
            case ASSIGN_LSH: 
            case ASSIGN_RSH: 
            case ASSIGN_URSH: 
            case ASSIGN_ADD: 
            case ASSIGN_SUB: 
            case ASSIGN_MUL: 
            case ASSIGN_EXPONENT: 
            case ASSIGN_DIV: 
            case ASSIGN_MOD: {
                return true;
            }
        }
        return false;
    }

    public static boolean isCompoundAssignmentOp(Node n) {
        return NodeUtil.isAssignmentOp(n) && !n.isAssign();
    }

    static Token getOpFromAssignmentOp(Node n) {
        switch (n.getToken()) {
            case ASSIGN_BITOR: {
                return Token.BITOR;
            }
            case ASSIGN_BITXOR: {
                return Token.BITXOR;
            }
            case ASSIGN_BITAND: {
                return Token.BITAND;
            }
            case ASSIGN_LSH: {
                return Token.LSH;
            }
            case ASSIGN_RSH: {
                return Token.RSH;
            }
            case ASSIGN_URSH: {
                return Token.URSH;
            }
            case ASSIGN_ADD: {
                return Token.ADD;
            }
            case ASSIGN_SUB: {
                return Token.SUB;
            }
            case ASSIGN_MUL: {
                return Token.MUL;
            }
            case ASSIGN_EXPONENT: {
                return Token.EXPONENT;
            }
            case ASSIGN_DIV: {
                return Token.DIV;
            }
            case ASSIGN_MOD: {
                return Token.MOD;
            }
        }
        throw new IllegalArgumentException("Not an assignment op:" + n);
    }

    static Token getAssignOpFromOp(Node n) {
        switch (n.getToken()) {
            case BITOR: {
                return Token.ASSIGN_BITOR;
            }
            case BITXOR: {
                return Token.ASSIGN_BITXOR;
            }
            case BITAND: {
                return Token.ASSIGN_BITAND;
            }
            case LSH: {
                return Token.ASSIGN_LSH;
            }
            case RSH: {
                return Token.ASSIGN_RSH;
            }
            case URSH: {
                return Token.ASSIGN_URSH;
            }
            case ADD: {
                return Token.ASSIGN_ADD;
            }
            case SUB: {
                return Token.ASSIGN_SUB;
            }
            case MUL: {
                return Token.ASSIGN_MUL;
            }
            case EXPONENT: {
                return Token.ASSIGN_EXPONENT;
            }
            case DIV: {
                return Token.ASSIGN_DIV;
            }
            case MOD: {
                return Token.ASSIGN_MOD;
            }
        }
        throw new IllegalStateException("Unexpected operator: " + n);
    }

    static boolean hasCorrespondingAssignmentOp(Node n) {
        switch (n.getToken()) {
            case MUL: 
            case ADD: 
            case BITAND: 
            case BITOR: 
            case BITXOR: 
            case DIV: 
            case LSH: 
            case MOD: 
            case RSH: 
            case SUB: 
            case URSH: {
                return true;
            }
        }
        return false;
    }

    static boolean containsFunction(Node n) {
        return NodeUtil.containsType(n, Token.FUNCTION);
    }

    public static Node getEnclosingType(Node n, final Token type) {
        return NodeUtil.getEnclosingNode(n, new Predicate<Node>(){

            @Override
            public boolean apply(Node n) {
                return n.getToken() == type;
            }
        });
    }

    static Node getEnclosingClassMemberFunction(Node n) {
        return NodeUtil.getEnclosingType(n, Token.MEMBER_FUNCTION_DEF);
    }

    public static Node getEnclosingClass(Node n) {
        return NodeUtil.getEnclosingType(n, Token.CLASS);
    }

    public static Node getEnclosingFunction(Node n) {
        return NodeUtil.getEnclosingType(n, Token.FUNCTION);
    }

    public static Node getEnclosingScript(Node n) {
        return NodeUtil.getEnclosingType(n, Token.SCRIPT);
    }

    public static Node getEnclosingBlock(Node n) {
        return NodeUtil.getEnclosingType(n, Token.BLOCK);
    }

    public static Node getEnclosingBlockScopeRoot(Node n) {
        return NodeUtil.getEnclosingNode(n, NodeUtil::createsBlockScope);
    }

    public static Node getEnclosingScopeRoot(Node n) {
        return NodeUtil.getEnclosingNode(n, NodeUtil::createsScope);
    }

    public static boolean isInFunction(Node n) {
        return NodeUtil.getEnclosingFunction(n) != null;
    }

    public static Node getEnclosingStatement(Node n) {
        return NodeUtil.getEnclosingNode(n, NodeUtil::isStatement);
    }

    public static Node getEnclosingNode(Node n, Predicate<Node> pred) {
        Node curr;
        for (curr = n; curr != null && !pred.apply(curr); curr = curr.getParent()) {
        }
        return curr;
    }

    @Nullable
    static Node getFirstPropMatchingKey(Node n, String keyName) {
        Preconditions.checkState(n.isObjectLit() || n.isClassMembers());
        for (Node keyNode : n.children()) {
            if (!keyNode.isStringKey() && !keyNode.isMemberFunctionDef() || !keyNode.getString().equals(keyName)) continue;
            return keyNode.getFirstChild();
        }
        return null;
    }

    @Nullable
    static Node getFirstGetterMatchingKey(Node n, String keyName) {
        Preconditions.checkState(n.isClassMembers() || n.isObjectLit(), n);
        for (Node keyNode : n.children()) {
            if (!keyNode.isGetterDef() || !keyNode.getString().equals(keyName)) continue;
            return keyNode;
        }
        return null;
    }

    @Nullable
    static Node getFirstSetterMatchingKey(Node n, String keyName) {
        Preconditions.checkState(n.isClassMembers() || n.isObjectLit(), n);
        for (Node keyNode : n.children()) {
            if (!keyNode.isSetterDef() || !keyNode.getString().equals(keyName)) continue;
            return keyNode;
        }
        return null;
    }

    @Nullable
    static Node getFirstComputedPropMatchingKey(Node objlit, Node key) {
        Preconditions.checkState(objlit.isObjectLit());
        for (Node child : objlit.children()) {
            if (!child.isComputedProp() || !child.getFirstChild().isEquivalentTo(key)) continue;
            return child.getLastChild();
        }
        return null;
    }

    static boolean referencesThis(Node n) {
        Node start = n.isFunction() ? n.getLastChild() : n;
        return NodeUtil.containsType(start, Token.THIS, MATCH_NOT_THIS_BINDING);
    }

    static boolean referencesSuper(Node n) {
        for (Node curr = n.getFirstChild(); curr != null; curr = curr.getNext()) {
            if (!NodeUtil.containsType(curr, Token.SUPER, node -> !node.isClass())) continue;
            return true;
        }
        return false;
    }

    public static boolean isGet(Node n) {
        return n.isGetProp() || n.isGetElem();
    }

    static boolean isBlockScopedDeclaration(Node n) {
        if (n.isName()) {
            switch (n.getParent().getToken()) {
                case LET: 
                case CONST: 
                case CATCH: {
                    return true;
                }
                case CLASS: {
                    return n.getParent().getFirstChild() == n;
                }
                case FUNCTION: {
                    return NodeUtil.isBlockScopedFunctionDeclaration(n.getParent());
                }
            }
        }
        return false;
    }

    public static boolean isNameDeclaration(Node n) {
        return n != null && (n.isVar() || n.isLet() || n.isConst());
    }

    static boolean isDestructuringDeclaration(Node n) {
        if (NodeUtil.isNameDeclaration(n)) {
            for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
                if (!c.isDestructuringLhs()) continue;
                return true;
            }
        }
        return false;
    }

    public static Node getAssignedValue(Node n) {
        Preconditions.checkState(n.isName() || n.isGetProp(), n);
        Node parent = n.getParent();
        if (NodeUtil.isNameDeclaration(parent)) {
            return n.getFirstChild();
        }
        if (parent.isAssign() && parent.getFirstChild() == n) {
            return n.getNext();
        }
        return null;
    }

    static boolean isExprAssign(Node n) {
        return n.isExprResult() && n.getFirstChild().isAssign();
    }

    public static boolean isExprCall(Node n) {
        return n.isExprResult() && n.getFirstChild().isCall();
    }

    static boolean isVanillaFunction(Node n) {
        return n.isFunction() && !n.isArrowFunction();
    }

    public static boolean isEnhancedFor(Node n) {
        return n.isForOf() || n.isForAwaitOf() || n.isForIn();
    }

    public static boolean isAnyFor(Node n) {
        return n.isVanillaFor() || n.isForIn() || n.isForOf();
    }

    static boolean isLoopStructure(Node n) {
        switch (n.getToken()) {
            case FOR_IN: 
            case FOR_OF: 
            case FOR_AWAIT_OF: 
            case FOR: 
            case DO: 
            case WHILE: {
                return true;
            }
        }
        return false;
    }

    static Node getLoopCodeBlock(Node n) {
        switch (n.getToken()) {
            case FOR_IN: 
            case FOR_OF: 
            case FOR_AWAIT_OF: 
            case FOR: 
            case WHILE: {
                return n.getLastChild();
            }
            case DO: {
                return n.getFirstChild();
            }
        }
        return null;
    }

    static boolean isWithinLoop(Node n) {
        for (Node parent : n.getAncestors()) {
            if (NodeUtil.isLoopStructure(parent)) {
                return true;
            }
            if (!parent.isFunction()) continue;
            break;
        }
        return false;
    }

    public static boolean isControlStructure(Node n) {
        switch (n.getToken()) {
            case IF: 
            case SWITCH: 
            case TRY: 
            case FOR_IN: 
            case FOR_OF: 
            case FOR_AWAIT_OF: 
            case CATCH: 
            case FOR: 
            case DO: 
            case WHILE: 
            case WITH: 
            case LABEL: 
            case CASE: 
            case DEFAULT_CASE: {
                return true;
            }
        }
        return false;
    }

    static boolean isControlStructureCodeBlock(Node parent, Node n) {
        switch (parent.getToken()) {
            case DO: {
                return parent.getFirstChild() == n;
            }
            case TRY: {
                return parent.getFirstChild() == n || parent.getLastChild() == n;
            }
            case FOR_IN: 
            case FOR_OF: 
            case FOR_AWAIT_OF: 
            case CATCH: 
            case FOR: 
            case WHILE: 
            case WITH: 
            case LABEL: {
                return parent.getLastChild() == n;
            }
            case IF: 
            case SWITCH: 
            case CASE: {
                return parent.getFirstChild() != n;
            }
            case DEFAULT_CASE: {
                return true;
            }
        }
        Preconditions.checkState(NodeUtil.isControlStructure(parent), parent);
        return false;
    }

    static Node getConditionExpression(Node n) {
        switch (n.getToken()) {
            case IF: 
            case WHILE: {
                return n.getFirstChild();
            }
            case DO: {
                return n.getLastChild();
            }
            case FOR: {
                return n.getSecondChild();
            }
            case FOR_IN: 
            case FOR_OF: 
            case FOR_AWAIT_OF: 
            case CASE: {
                return null;
            }
        }
        throw new IllegalArgumentException(n + " does not have a condition.");
    }

    public static boolean isStatementBlock(Node n) {
        return n.isRoot() || n.isScript() || n.isBlock() || n.isModuleBody();
    }

    static boolean createsBlockScope(Node n) {
        switch (n.getToken()) {
            case BLOCK: {
                Node parent = n.getParent();
                return parent != null && !NodeUtil.isSwitchCase(parent) && !parent.isCatch();
            }
            case CLASS: 
            case SWITCH: 
            case FOR_IN: 
            case FOR_OF: 
            case FOR_AWAIT_OF: 
            case FOR: {
                return true;
            }
        }
        return false;
    }

    static boolean createsScope(Node n) {
        return NodeUtil.createsBlockScope(n) || n.isFunction() || n.isModuleBody() || n.isRoot() && n.getParent() == null;
    }

    static boolean isValidCfgRoot(Node n) {
        return DEFINITE_CFG_ROOTS.contains((Object)n.getToken());
    }

    public static boolean isStatement(Node n) {
        return !n.isModuleBody() && NodeUtil.isStatementParent(n.getParent());
    }

    public static boolean isStatementParent(Node parent) {
        return IS_STATEMENT_PARENT.contains((Object)parent.getToken());
    }

    private static boolean isDeclarationParent(Node parent) {
        switch (parent.getToken()) {
            case EXPORT: 
            case DECLARE: {
                return true;
            }
        }
        return NodeUtil.isStatementParent(parent);
    }

    static boolean isSwitchCase(Node n) {
        return n.isCase() || n.isDefaultCase();
    }

    static boolean isReferenceName(Node n) {
        return n.isName() && !n.getString().isEmpty();
    }

    static boolean isNonlocalModuleExportName(Node n) {
        Node parent = n.getParent();
        return parent != null && n.isName() && (parent.isExportSpec() && n != parent.getFirstChild() || parent.isImportSpec() && n != parent.getLastChild());
    }

    static boolean isTryFinallyNode(Node parent, Node child) {
        return parent.isTry() && parent.hasXChildren(3) && child == parent.getLastChild();
    }

    static boolean isTryCatchNodeContainer(Node n) {
        Node parent = n.getParent();
        return parent.isTry() && parent.getSecondChild() == n;
    }

    static boolean isInSyntheticScript(Node n) {
        return n.getSourceFileName() != null && n.getSourceFileName().startsWith(" [synthetic:");
    }

    public static void deleteNode(Node n, AbstractCompiler compiler) {
        Node parent = n.getParent();
        NodeUtil.markFunctionsDeleted(n, compiler);
        n.detach();
        compiler.reportChangeToEnclosingScope(parent);
    }

    public static void deleteFunctionCall(Node n, AbstractCompiler compiler) {
        Preconditions.checkState(n.isCall());
        Node parent = n.getParent();
        if (parent.isExprResult()) {
            Node grandParent = parent.getParent();
            grandParent.removeChild(parent);
            parent = grandParent;
        } else {
            parent.replaceChild(n, NodeUtil.newUndefinedNode(n));
        }
        NodeUtil.markFunctionsDeleted(n, compiler);
        compiler.reportChangeToEnclosingScope(parent);
    }

    public static void deleteChildren(Node n, AbstractCompiler compiler) {
        while (n.hasChildren()) {
            NodeUtil.deleteNode(n.getFirstChild(), compiler);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void removeChild(Node parent, Node node) {
        if (NodeUtil.isTryFinallyNode(parent, node)) {
            if (NodeUtil.hasCatchHandler(NodeUtil.getCatchBlock(parent))) {
                parent.removeChild(node);
                return;
            } else {
                node.detachChildren();
            }
            return;
        } else if (node.isCatch()) {
            Node tryNode = node.getGrandparent();
            Preconditions.checkState(NodeUtil.hasFinally(tryNode));
            node.detach();
            return;
        } else if (NodeUtil.isTryCatchNodeContainer(node)) {
            Node tryNode = node.getParent();
            Preconditions.checkState(NodeUtil.hasFinally(tryNode));
            node.detachChildren();
            return;
        } else if (node.isBlock()) {
            node.detachChildren();
            return;
        } else if (NodeUtil.isStatementBlock(parent) || NodeUtil.isSwitchCase(node) || node.isMemberFunctionDef()) {
            parent.removeChild(node);
            return;
        } else if (NodeUtil.isNameDeclaration(parent) || parent.isExprResult()) {
            if (parent.hasMoreThanOneChild()) {
                parent.removeChild(node);
                return;
            } else {
                parent.removeChild(node);
                NodeUtil.removeChild(parent.getParent(), parent);
            }
            return;
        } else if (parent.isLabel() && node == parent.getLastChild()) {
            parent.removeChild(node);
            NodeUtil.removeChild(parent.getParent(), parent);
            return;
        } else if (parent.isVanillaFor()) {
            parent.replaceChild(node, IR.empty());
            return;
        } else if (parent.isObjectPattern()) {
            parent.removeChild(node);
            return;
        } else if (parent.isArrayPattern()) {
            if (node == parent.getLastChild()) {
                parent.removeChild(node);
                return;
            } else {
                parent.replaceChild(node, IR.empty());
            }
            return;
        } else if (parent.isDestructuringLhs()) {
            parent.removeChild(node);
            if (!parent.getParent().hasChildren()) return;
            NodeUtil.removeChild(parent.getParent(), parent);
            return;
        } else if (parent.isRest()) {
            parent.detach();
            return;
        } else if (parent.isParamList()) {
            parent.removeChild(node);
            return;
        } else {
            if (!parent.isImport()) throw new IllegalStateException("Invalid attempt to remove node: " + node + " of " + parent);
            if (node != parent.getFirstChild()) throw new IllegalStateException("Invalid attempt to remove: " + node + " from " + parent);
            parent.replaceChild(node, IR.empty());
        }
    }

    public static void replaceDeclarationChild(Node declChild, Node newStatement) {
        Preconditions.checkArgument(NodeUtil.isNameDeclaration(declChild.getParent()));
        Preconditions.checkArgument(null == newStatement.getParent());
        Node decl = declChild.getParent();
        Node declParent = decl.getParent();
        if (decl.hasOneChild()) {
            declParent.replaceChild(decl, newStatement);
        } else if (declChild.getNext() == null) {
            decl.removeChild(declChild);
            declParent.addChildAfter(newStatement, decl);
        } else if (declChild.getPrevious() == null) {
            decl.removeChild(declChild);
            declParent.addChildBefore(newStatement, decl);
        } else {
            Preconditions.checkState(decl.hasMoreThanOneChild());
            Node newDecl = new Node(decl.getToken()).srcref(decl);
            Node after = declChild.getNext();
            while (after != null) {
                Node next = after.getNext();
                newDecl.addChildToBack(after.detach());
                after = next;
            }
            decl.removeChild(declChild);
            declParent.addChildAfter(newStatement, decl);
            declParent.addChildAfter(newDecl, newStatement);
        }
    }

    static void maybeAddFinally(Node tryNode) {
        Preconditions.checkState(tryNode.isTry());
        if (!NodeUtil.hasFinally(tryNode)) {
            tryNode.addChildToBack(IR.block().srcref(tryNode));
        }
    }

    public static boolean tryMergeBlock(Node block, boolean alwaysMerge) {
        boolean canMerge;
        Preconditions.checkState(block.isBlock());
        Node parent = block.getParent();
        boolean bl = canMerge = alwaysMerge || NodeUtil.canMergeBlock(block);
        if (NodeUtil.isStatementBlock(parent) && canMerge) {
            Node previous = block;
            while (block.hasChildren()) {
                Node child = block.removeFirstChild();
                parent.addChildAfter(child, previous);
                previous = child;
            }
            parent.removeChild(block);
            return true;
        }
        return false;
    }

    public static boolean canMergeBlock(Node block) {
        block4: for (Node c = block.getFirstChild(); c != null; c = c.getNext()) {
            switch (c.getToken()) {
                case LABEL: {
                    if (NodeUtil.canMergeBlock(c)) continue block4;
                    return false;
                }
                case FUNCTION: 
                case CLASS: 
                case LET: 
                case CONST: {
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isCallOrNew(Node node) {
        return node.isCall() || node.isNew();
    }

    public static Node getFunctionBody(Node fn) {
        Preconditions.checkArgument(fn.isFunction(), fn);
        return fn.getLastChild();
    }

    static boolean isDeclaration(Node n) {
        return NodeUtil.isNameDeclaration(n) || NodeUtil.isFunctionDeclaration(n) || NodeUtil.isClassDeclaration(n);
    }

    public static boolean isFunctionDeclaration(Node n) {
        return n.isFunction() && NodeUtil.isDeclarationParent(n.getParent()) && NodeUtil.isNamedFunction(n);
    }

    public static boolean isMethodDeclaration(Node n) {
        if (n.isFunction()) {
            Node parent = n.getParent();
            switch (parent.getToken()) {
                case MEMBER_FUNCTION_DEF: 
                case SETTER_DEF: 
                case GETTER_DEF: {
                    return true;
                }
                case COMPUTED_PROP: {
                    return parent.getLastChild() == n;
                }
            }
            return false;
        }
        return false;
    }

    public static boolean isClassDeclaration(Node n) {
        return n.isClass() && NodeUtil.isDeclarationParent(n.getParent()) && NodeUtil.isNamedClass(n);
    }

    public static boolean isHoistedFunctionDeclaration(Node n) {
        if (NodeUtil.isFunctionDeclaration(n)) {
            Node parent = n.getParent();
            return parent.isScript() || parent.isModuleBody() || parent.getParent().isFunction() || parent.isExport();
        }
        return false;
    }

    static boolean isBlockScopedFunctionDeclaration(Node n) {
        if (!NodeUtil.isFunctionDeclaration(n)) {
            return false;
        }
        for (Node current = n.getParent(); current != null; current = current.getParent()) {
            switch (current.getToken()) {
                case BLOCK: {
                    return !current.getParent().isFunction();
                }
                case FUNCTION: 
                case EXPORT: 
                case DECLARE: 
                case SCRIPT: 
                case MODULE_BODY: {
                    return false;
                }
            }
            Preconditions.checkState(current.isLabel(), current);
        }
        return false;
    }

    static boolean isFunctionBlock(Node n) {
        return n.isBlock() && n.getParent() != null && n.getParent().isFunction();
    }

    static boolean isFunctionExpression(Node n) {
        return n.isFunction() && !NodeUtil.isFunctionDeclaration(n) && !NodeUtil.isMethodDeclaration(n);
    }

    static boolean isUnannotatedCallback(Node n) {
        JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(n);
        return n.isFunction() && n.getParent().isCall() && n != n.getParent().getFirstChild() && jsdoc == null && !NodeUtil.functionHasInlineJsdocs(n);
    }

    static boolean isNamedFunctionExpression(Node n) {
        return NodeUtil.isFunctionExpression(n) && !n.getFirstChild().getString().isEmpty();
    }

    static boolean isClassExpression(Node n) {
        return n.isClass() && (!NodeUtil.isNamedClass(n) || !NodeUtil.isDeclarationParent(n.getParent()));
    }

    static boolean isNamedFunction(Node n) {
        return n.isFunction() && NodeUtil.isReferenceName(n.getFirstChild());
    }

    static boolean isNamedClass(Node n) {
        return n.isClass() && NodeUtil.isReferenceName(n.getFirstChild());
    }

    static boolean isBleedingFunctionName(Node n) {
        if (!n.isName() || n.getString().isEmpty()) {
            return false;
        }
        Node parent = n.getParent();
        return NodeUtil.isFunctionExpression(parent) && n == parent.getFirstChild();
    }

    static boolean isEmptyFunctionExpression(Node node) {
        return NodeUtil.isFunctionExpression(node) && NodeUtil.isEmptyBlock(node.getLastChild());
    }

    static boolean doesFunctionReferenceOwnArgumentsObject(Node fn) {
        Preconditions.checkArgument(fn.isFunction());
        if (fn.isArrowFunction()) {
            return false;
        }
        return NodeUtil.referencesArgumentsHelper(fn.getLastChild());
    }

    private static boolean referencesArgumentsHelper(Node node) {
        if (node.isName() && node.getString().equals("arguments")) {
            return true;
        }
        if (NodeUtil.isVanillaFunction(node)) {
            return false;
        }
        for (Node c = node.getFirstChild(); c != null; c = c.getNext()) {
            if (!NodeUtil.referencesArgumentsHelper(c)) continue;
            return true;
        }
        return false;
    }

    static boolean isObjectCallMethod(Node callNode, String methodName) {
        Node last;
        Node functionIndentifyingExpression;
        if (callNode.isCall() && NodeUtil.isGet(functionIndentifyingExpression = callNode.getFirstChild()) && (last = functionIndentifyingExpression.getLastChild()) != null && last.isString()) {
            String propName = last.getString();
            return propName.equals(methodName);
        }
        return false;
    }

    static boolean isFunctionObjectCall(Node callNode) {
        return NodeUtil.isObjectCallMethod(callNode, "call");
    }

    static boolean isFunctionObjectApply(Node callNode) {
        return NodeUtil.isObjectCallMethod(callNode, "apply");
    }

    static boolean isGoogBind(Node n) {
        return n.isGetProp() && n.matchesQualifiedName("goog.bind");
    }

    static boolean isGoogPartial(Node n) {
        return n.isGetProp() && n.matchesQualifiedName("goog.partial");
    }

    static boolean isFunctionBind(Node expr) {
        if (!expr.isGetProp()) {
            return false;
        }
        if (NodeUtil.isGoogBind(expr) || NodeUtil.isGoogPartial(expr)) {
            return true;
        }
        return expr.getFirstChild().isFunction() && expr.getLastChild().getString().equals("bind");
    }

    static boolean isNameDeclOrSimpleAssignLhs(Node n, Node parent) {
        return parent.isAssign() && parent.getFirstChild() == n || NodeUtil.isNameDeclaration(parent);
    }

    public static boolean isLValue(Node n) {
        switch (n.getToken()) {
            case NAME: 
            case GETPROP: 
            case GETELEM: {
                break;
            }
            default: {
                return false;
            }
        }
        Node parent = n.getParent();
        if (parent == null) {
            return false;
        }
        switch (parent.getToken()) {
            case IMPORT_SPEC: {
                return parent.getLastChild() == n;
            }
            case INC: 
            case DEC: 
            case VAR: 
            case LET: 
            case CONST: 
            case PARAM_LIST: 
            case REST: 
            case CATCH: 
            case IMPORT: {
                return true;
            }
            case FUNCTION: 
            case CLASS: 
            case FOR_IN: 
            case FOR_OF: 
            case FOR_AWAIT_OF: 
            case DEFAULT_VALUE: 
            case FOR: {
                return parent.getFirstChild() == n;
            }
            case STRING_KEY: 
            case COMPUTED_PROP: 
            case ARRAY_PATTERN: {
                return NodeUtil.isLhsByDestructuring(n);
            }
        }
        return NodeUtil.isAssignmentOp(parent) && parent.getFirstChild() == n;
    }

    public static boolean isDeclarationLValue(Node n) {
        boolean isLValue = NodeUtil.isLValue(n);
        if (!isLValue) {
            return false;
        }
        Node parent = n.getParent();
        switch (parent.getToken()) {
            case FUNCTION: 
            case CLASS: 
            case VAR: 
            case LET: 
            case CONST: 
            case PARAM_LIST: 
            case CATCH: 
            case IMPORT_SPEC: 
            case IMPORT: {
                return true;
            }
            case STRING_KEY: {
                return NodeUtil.isNameDeclaration(parent.getParent().getGrandparent());
            }
            case ARRAY_PATTERN: 
            case OBJECT_PATTERN: {
                return NodeUtil.isNameDeclaration(parent.getGrandparent());
            }
        }
        return false;
    }

    static boolean isLhsOfAssign(Node n) {
        Node parent = n.getParent();
        return parent != null && parent.isAssign() && parent.getFirstChild() == n;
    }

    public static boolean isImportedName(Node n) {
        Node parent = n.getParent();
        return parent.isImport() || parent.isImportSpec() && parent.getLastChild() == n;
    }

    public static Node getDeclaringParent(Node targetNode) {
        Node rootTarget = NodeUtil.getRootTarget(targetNode);
        Node parent = rootTarget.getParent();
        if (parent.isRest() || parent.isDefaultValue()) {
            parent = parent.getParent();
            Preconditions.checkState(parent.isParamList(), parent);
        } else if (parent.isDestructuringLhs()) {
            parent = parent.getParent();
            Preconditions.checkState(NodeUtil.isNameDeclaration(parent), parent);
        } else if (parent.isClass() || parent.isFunction()) {
            Preconditions.checkState(targetNode == parent.getFirstChild(), targetNode);
        } else if (parent.isImportSpec()) {
            Preconditions.checkState(targetNode == parent.getSecondChild(), targetNode);
            parent = parent.getGrandparent();
            Preconditions.checkState(parent.isImport(), parent);
        } else {
            Preconditions.checkState(parent.isParamList() || NodeUtil.isNameDeclaration(parent) || parent.isImport() || parent.isCatch(), parent);
        }
        return parent;
    }

    public static Node getRootTarget(Node targetNode) {
        Node enclosingTarget = targetNode;
        Node nextTarget = NodeUtil.getEnclosingTarget(enclosingTarget);
        while (nextTarget != null) {
            enclosingTarget = nextTarget;
            nextTarget = NodeUtil.getEnclosingTarget(enclosingTarget);
        }
        return enclosingTarget;
    }

    @Nullable
    private static Node getEnclosingTarget(Node targetNode) {
        boolean targetIsFirstChild;
        Preconditions.checkState(Preconditions.checkNotNull(targetNode).isValidAssignmentTarget(), targetNode);
        Node parent = Preconditions.checkNotNull(targetNode.getParent(), targetNode);
        boolean bl = targetIsFirstChild = parent.getFirstChild() == targetNode;
        if (parent.isDefaultValue() || parent.isRest()) {
            Preconditions.checkState(targetIsFirstChild, parent);
            targetNode = parent;
            parent = Preconditions.checkNotNull(targetNode.getParent());
            targetIsFirstChild = targetNode == parent.getFirstChild();
        }
        switch (parent.getToken()) {
            case ARRAY_PATTERN: {
                return parent;
            }
            case COMPUTED_PROP: {
                Preconditions.checkState(!targetIsFirstChild, parent);
            }
            case STRING_KEY: {
                Node grandparent = Preconditions.checkNotNull(parent.getParent(), parent);
                Preconditions.checkState(grandparent.isObjectPattern(), grandparent);
                return grandparent;
            }
            case VAR: 
            case LET: 
            case CONST: 
            case PARAM_LIST: {
                return null;
            }
            case FUNCTION: 
            case CLASS: {
                Preconditions.checkState(targetIsFirstChild, targetNode);
                return null;
            }
            case FOR_IN: 
            case FOR_OF: 
            case FOR_AWAIT_OF: {
                Preconditions.checkState(targetIsFirstChild, targetNode);
                return null;
            }
            case DESTRUCTURING_LHS: {
                Preconditions.checkState(targetIsFirstChild, targetNode);
                return null;
            }
            case IMPORT: {
                return null;
            }
            case IMPORT_SPEC: {
                Preconditions.checkState(!targetIsFirstChild, parent);
                return null;
            }
            case CATCH: {
                return null;
            }
        }
        Preconditions.checkState(NodeUtil.isAssignmentOp(parent) && targetIsFirstChild, parent);
        return null;
    }

    public static boolean isLhsByDestructuring(Node n) {
        switch (n.getToken()) {
            case NAME: 
            case STRING_KEY: 
            case GETPROP: 
            case GETELEM: {
                return NodeUtil.isLhsByDestructuringHelper(n);
            }
        }
        return false;
    }

    private static boolean isLhsByDestructuringHelper(Node n) {
        Node parent = n.getParent();
        Node grandparent = n.getGrandparent();
        switch (parent.getToken()) {
            case ARRAY_PATTERN: {
                return true;
            }
            case STRING_KEY: {
                return grandparent.isObjectPattern();
            }
            case OBJECT_PATTERN: {
                return !n.isStringKey();
            }
            case COMPUTED_PROP: {
                if (n == parent.getSecondChild()) {
                    return NodeUtil.isLhsByDestructuringHelper(parent);
                }
                return false;
            }
            case REST: {
                return NodeUtil.isLhsByDestructuringHelper(parent);
            }
            case DEFAULT_VALUE: {
                if (n == parent.getFirstChild()) {
                    return NodeUtil.isLhsByDestructuringHelper(parent);
                }
                return false;
            }
        }
        return false;
    }

    static boolean isObjectLitKey(Node node) {
        switch (node.getToken()) {
            case STRING_KEY: 
            case MEMBER_FUNCTION_DEF: 
            case SETTER_DEF: 
            case GETTER_DEF: {
                return true;
            }
        }
        return false;
    }

    static String getObjectLitKeyName(Node key) {
        Node keyNode = NodeUtil.getObjectLitKeyNode(key);
        if (keyNode != null) {
            return keyNode.getString();
        }
        throw new IllegalStateException("Unexpected node type: " + key);
    }

    static Node getObjectLitKeyNode(Node key) {
        switch (key.getToken()) {
            case STRING_KEY: 
            case MEMBER_FUNCTION_DEF: 
            case SETTER_DEF: 
            case GETTER_DEF: {
                return key;
            }
            case COMPUTED_PROP: {
                return key.getFirstChild().isString() ? key.getFirstChild() : null;
            }
        }
        throw new IllegalStateException("Unexpected node type: " + key);
    }

    static boolean isNestedObjectPattern(Node n) {
        Preconditions.checkState(n.isObjectPattern());
        for (Node key = n.getFirstChild(); key != null; key = key.getNext()) {
            Node value = key.getFirstChild();
            if (value == null || !value.isObjectLit() && !value.isArrayLit() && !value.isDestructuringPattern()) continue;
            return true;
        }
        return false;
    }

    static boolean isNestedArrayPattern(Node n) {
        Preconditions.checkState(n.isArrayPattern());
        for (Node key = n.getFirstChild(); key != null; key = key.getNext()) {
            if (!key.hasChildren()) continue;
            return true;
        }
        return false;
    }

    static boolean isGetOrSetKey(Node node) {
        switch (node.getToken()) {
            case SETTER_DEF: 
            case GETTER_DEF: {
                return true;
            }
        }
        return false;
    }

    public static String opToStr(Token operator) {
        switch (operator) {
            case BITOR: {
                return "|";
            }
            case OR: {
                return "||";
            }
            case BITXOR: {
                return "^";
            }
            case AND: {
                return "&&";
            }
            case BITAND: {
                return "&";
            }
            case SHEQ: {
                return "===";
            }
            case EQ: {
                return "==";
            }
            case NOT: {
                return "!";
            }
            case NE: {
                return "!=";
            }
            case SHNE: {
                return "!==";
            }
            case LSH: {
                return "<<";
            }
            case IN: {
                return "in";
            }
            case LE: {
                return "<=";
            }
            case LT: {
                return "<";
            }
            case URSH: {
                return ">>>";
            }
            case RSH: {
                return ">>";
            }
            case GE: {
                return ">=";
            }
            case GT: {
                return ">";
            }
            case MUL: {
                return "*";
            }
            case DIV: {
                return "/";
            }
            case MOD: {
                return "%";
            }
            case EXPONENT: {
                return "**";
            }
            case BITNOT: {
                return "~";
            }
            case ADD: 
            case POS: {
                return "+";
            }
            case NEG: 
            case SUB: {
                return "-";
            }
            case ASSIGN: {
                return "=";
            }
            case ASSIGN_BITOR: {
                return "|=";
            }
            case ASSIGN_BITXOR: {
                return "^=";
            }
            case ASSIGN_BITAND: {
                return "&=";
            }
            case ASSIGN_LSH: {
                return "<<=";
            }
            case ASSIGN_RSH: {
                return ">>=";
            }
            case ASSIGN_URSH: {
                return ">>>=";
            }
            case ASSIGN_ADD: {
                return "+=";
            }
            case ASSIGN_SUB: {
                return "-=";
            }
            case ASSIGN_MUL: {
                return "*=";
            }
            case ASSIGN_EXPONENT: {
                return "**=";
            }
            case ASSIGN_DIV: {
                return "/=";
            }
            case ASSIGN_MOD: {
                return "%=";
            }
            case VOID: {
                return "void";
            }
            case TYPEOF: {
                return "typeof";
            }
            case INSTANCEOF: {
                return "instanceof";
            }
        }
        return null;
    }

    static String opToStrNoFail(Token operator) {
        String res = NodeUtil.opToStr(operator);
        if (res == null) {
            throw new Error("Unknown op " + (Object)((Object)operator));
        }
        return res;
    }

    static boolean containsType(Node node, Token type, Predicate<Node> traverseChildrenPred) {
        return NodeUtil.has(node, new MatchNodeType(type), traverseChildrenPred);
    }

    public static boolean containsType(Node node, Token type) {
        return NodeUtil.containsType(node, type, Predicates.alwaysTrue());
    }

    static void redeclareVarsInsideBranch(Node branch) {
        Collection<Node> vars = NodeUtil.getVarsDeclaredInBranch(branch);
        if (vars.isEmpty()) {
            return;
        }
        Node parent = NodeUtil.getAddingRoot(branch);
        for (Node nameNode : vars) {
            Node var = IR.var(IR.name(nameNode.getString()).srcref(nameNode)).srcref(nameNode);
            NodeUtil.copyNameAnnotations(nameNode, var.getFirstChild());
            parent.addChildToFront(var);
        }
    }

    static void copyNameAnnotations(Node source, Node destination) {
        if (source.getBooleanProp((byte)43)) {
            destination.putBooleanProp((byte)43, true);
        }
    }

    private static Node getAddingRoot(Node n) {
        Node addingRoot = null;
        Node ancestor = n;
        block4: while (null != (ancestor = ancestor.getParent())) {
            switch (ancestor.getToken()) {
                case SCRIPT: 
                case MODULE_BODY: {
                    addingRoot = ancestor;
                    break block4;
                }
                case FUNCTION: {
                    addingRoot = ancestor.getLastChild();
                    break block4;
                }
                default: {
                    continue block4;
                }
            }
        }
        Preconditions.checkState(addingRoot.isBlock() || addingRoot.isModuleBody() || addingRoot.isScript());
        Preconditions.checkState(!addingRoot.hasChildren() || !addingRoot.getFirstChild().isScript());
        return addingRoot;
    }

    public static Node newDeclaration(Node lhs, @Nullable Node rhs, Token declarationType) {
        if (rhs == null) {
            return IR.declaration(lhs, declarationType);
        }
        return IR.declaration(lhs, rhs, declarationType);
    }

    public static Node newQName(AbstractCompiler compiler, String name) {
        int endPos = name.indexOf(46);
        if (endPos == -1) {
            return NodeUtil.newName(compiler, name);
        }
        String nodeName = name.substring(0, endPos);
        Node node = "this".equals(nodeName) ? IR.thisNode() : ("super".equals(nodeName) ? IR.superNode() : NodeUtil.newName(compiler, nodeName));
        do {
            int startPos;
            String part = (endPos = name.indexOf(46, startPos = endPos + 1)) == -1 ? name.substring(startPos) : name.substring(startPos, endPos);
            Node propNode = IR.string(part);
            propNode.setLength(part.length());
            if (compiler.getCodingConvention().isConstantKey(part)) {
                propNode.putBooleanProp((byte)43, true);
            }
            int length = node.getLength() + ".".length() + part.length();
            node = IR.getprop(node, propNode);
            node.setLength(length);
        } while (endPos != -1);
        return node;
    }

    static Node newQName(AbstractCompiler compiler, String name, Node basisNode, String originalName) {
        Node node = NodeUtil.newQName(compiler, name);
        NodeUtil.useSourceInfoForNewQName(node, basisNode);
        if (!originalName.equals(node.getOriginalName())) {
            node.setOriginalName(originalName);
        }
        return node;
    }

    public static Node newPropertyAccess(AbstractCompiler compiler, Node context, String name) {
        Node propNode = IR.getprop(context, IR.string(name));
        if (compiler.getCodingConvention().isConstantKey(name)) {
            propNode.putBooleanProp((byte)43, true);
        }
        return propNode;
    }

    public static Node newQNameDeclaration(AbstractCompiler compiler, String name, Node value, JSDocInfo info) {
        return NodeUtil.newQNameDeclaration(compiler, name, value, info, Token.VAR);
    }

    public static Node newQNameDeclaration(AbstractCompiler compiler, String name, Node value, JSDocInfo info, Token type) {
        Node result;
        Preconditions.checkState(type == Token.VAR || type == Token.LET || type == Token.CONST, (Object)type);
        Node nameNode = NodeUtil.newQName(compiler, name);
        if (nameNode.isName()) {
            result = value == null ? IR.declaration(nameNode, type) : IR.declaration(nameNode, value, type);
            result.setJSDocInfo(info);
        } else if (value != null) {
            result = IR.exprResult(IR.assign(nameNode, value));
            result.getFirstChild().setJSDocInfo(info);
        } else {
            result = IR.exprResult(nameNode);
            result.getFirstChild().setJSDocInfo(info);
        }
        return result;
    }

    private static void useSourceInfoForNewQName(Node newQName, Node basisNode) {
        if (newQName.getStaticSourceFile() == null) {
            newQName.setStaticSourceFileFrom(basisNode);
            newQName.setSourceEncodedPosition(basisNode.getSourcePosition());
        }
        if (newQName.getOriginalName() == null) {
            newQName.putProp((byte)40, basisNode.getOriginalName());
        }
        for (Node child = newQName.getFirstChild(); child != null; child = child.getNext()) {
            NodeUtil.useSourceInfoForNewQName(child, basisNode);
        }
    }

    static Node getRootOfQualifiedName(Node qName) {
        Node current = qName;
        while (!(current.isName() || current.isThis() || current.isSuper())) {
            Preconditions.checkState(current.isGetProp(), "Not a getprop node: ", (Object)current);
            current = current.getFirstChild();
        }
        return current;
    }

    static int getLengthOfQname(Node qname) {
        int result = 1;
        while (qname.isGetProp() || qname.isGetElem()) {
            ++result;
            qname = qname.getFirstChild();
        }
        Preconditions.checkState(qname.isName());
        return result;
    }

    private static Node newName(AbstractCompiler compiler, String name) {
        Node nameNode = IR.name(name);
        nameNode.setLength(name.length());
        if (compiler.getCodingConvention().isConstant(name)) {
            nameNode.putBooleanProp((byte)43, true);
        }
        return nameNode;
    }

    static Node newName(AbstractCompiler compiler, String name, Node srcref) {
        return NodeUtil.newName(compiler, name).srcref(srcref);
    }

    static Node newName(AbstractCompiler compiler, String name, Node basisNode, String originalName) {
        Node nameNode = NodeUtil.newName(compiler, name, basisNode);
        nameNode.setOriginalName(originalName);
        return nameNode;
    }

    static boolean isLatin(String s) {
        int len = s.length();
        for (int index = 0; index < len; ++index) {
            char c = s.charAt(index);
            if (c <= '\u007f') continue;
            return false;
        }
        return true;
    }

    static boolean isValidSimpleName(String name) {
        return TokenStream.isJSIdentifier(name) && !TokenStream.isKeyword(name) && NodeUtil.isLatin(name);
    }

    @Deprecated
    public static boolean isValidQualifiedName(CompilerOptions.LanguageMode mode, String name) {
        return NodeUtil.isValidQualifiedName(mode.toFeatureSet(), name);
    }

    public static boolean isValidQualifiedName(FeatureSet mode, String name) {
        if (name.endsWith(".") || name.startsWith(".")) {
            return false;
        }
        List<String> parts = Splitter.on('.').splitToList(name);
        for (String part : parts) {
            if (NodeUtil.isValidPropertyName(mode, part)) continue;
            return false;
        }
        return NodeUtil.isValidSimpleName(parts.get(0));
    }

    static boolean isValidPropertyName(FeatureSet mode, String name) {
        if (NodeUtil.isValidSimpleName(name)) {
            return true;
        }
        return mode.has(FeatureSet.Feature.KEYWORDS_AS_PROPERTIES) && TokenStream.isKeyword(name);
    }

    static Collection<Node> getVarsDeclaredInBranch(Node root) {
        VarCollector collector = new VarCollector();
        NodeUtil.visitPreOrder(root, collector, MATCH_NOT_FUNCTION);
        return collector.vars.values();
    }

    private static void getLhsNodesHelper(Node n, List<Node> lhsNodes) {
        switch (n.getToken()) {
            case IMPORT: {
                NodeUtil.getLhsNodesHelper(n.getFirstChild(), lhsNodes);
                NodeUtil.getLhsNodesHelper(n.getSecondChild(), lhsNodes);
                return;
            }
            case VAR: 
            case LET: 
            case CONST: 
            case PARAM_LIST: 
            case ARRAY_PATTERN: 
            case OBJECT_PATTERN: 
            case IMPORT_SPECS: {
                for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
                    NodeUtil.getLhsNodesHelper(child, lhsNodes);
                }
                return;
            }
            case CAST: 
            case DEFAULT_VALUE: 
            case DESTRUCTURING_LHS: 
            case REST: 
            case CATCH: {
                NodeUtil.getLhsNodesHelper(n.getFirstChild(), lhsNodes);
                return;
            }
            case STRING_KEY: 
            case COMPUTED_PROP: 
            case IMPORT_SPEC: {
                NodeUtil.getLhsNodesHelper(n.getLastChild(), lhsNodes);
                return;
            }
            case NAME: 
            case IMPORT_STAR: {
                lhsNodes.add(n);
                return;
            }
            case GETPROP: 
            case GETELEM: {
                lhsNodes.add(n);
                return;
            }
            case EMPTY: {
                return;
            }
            case FOR_IN: 
            case FOR_OF: 
            case FOR_AWAIT_OF: {
                NodeUtil.getLhsNodesHelper(n.getFirstChild(), lhsNodes);
                return;
            }
        }
        if (!NodeUtil.isAssignmentOp(n)) {
            throw new IllegalStateException("Invalid node in lhs: " + n);
        }
        NodeUtil.getLhsNodesHelper(n.getFirstChild(), lhsNodes);
    }

    public static List<Node> findLhsNodesInNode(Node assigningParent) {
        Preconditions.checkArgument(NodeUtil.isNameDeclaration(assigningParent) || assigningParent.isParamList() || NodeUtil.isAssignmentOp(assigningParent) || assigningParent.isCatch() || assigningParent.isDestructuringLhs() || assigningParent.isDefaultValue() || assigningParent.isImport() || NodeUtil.isEnhancedFor(assigningParent), assigningParent);
        ArrayList<Node> lhsNodes = new ArrayList<Node>();
        NodeUtil.getLhsNodesHelper(assigningParent, lhsNodes);
        return lhsNodes;
    }

    static boolean isObjectDefinePropertiesDefinition(Node n) {
        if (!n.isCall() || !n.hasXChildren(3)) {
            return false;
        }
        Node first = n.getFirstChild();
        if (!first.isGetProp()) {
            return false;
        }
        Node prop = first.getLastChild();
        return prop.getString().equals("defineProperties") && NodeUtil.isKnownGlobalObjectReference(first.getFirstChild());
    }

    private static boolean isKnownGlobalObjectReference(Node n) {
        switch (n.getToken()) {
            case NAME: {
                return n.getString().equals("Object");
            }
            case GETPROP: {
                return n.matchesQualifiedName("$jscomp.global.Object") || n.matchesQualifiedName("$jscomp$global.Object");
            }
        }
        return false;
    }

    static boolean isObjectDefinePropertyDefinition(Node n) {
        return n.isCall() && n.hasXChildren(4) && n.getFirstChild().matchesQualifiedName("Object.defineProperty");
    }

    static Iterable<Node> getObjectDefinedPropertiesKeys(Node definePropertiesCall) {
        Preconditions.checkArgument(NodeUtil.isObjectDefinePropertiesDefinition(definePropertiesCall));
        ArrayList<Node> properties = new ArrayList<Node>();
        Node objectLiteral = definePropertiesCall.getLastChild();
        for (Node key : objectLiteral.children()) {
            if (!key.isStringKey()) continue;
            properties.add(key);
        }
        return properties;
    }

    public static boolean isPrototypePropertyDeclaration(Node n) {
        return NodeUtil.isExprAssign(n) && NodeUtil.isPrototypeProperty(n.getFirstFirstChild());
    }

    static boolean isPrototypeProperty(Node n) {
        if (!n.isGetProp()) {
            return false;
        }
        Node recv = n.getFirstChild();
        return recv.isGetProp() && recv.getLastChild().getString().equals("prototype");
    }

    static boolean isPrototypeMethod(Node n) {
        if (!n.isFunction()) {
            return false;
        }
        Node assignNode = n.getParent();
        if (!assignNode.isAssign()) {
            return false;
        }
        return NodeUtil.isPrototypePropertyDeclaration(assignNode.getParent());
    }

    static boolean isPrototypeAssignment(Node getProp) {
        if (!getProp.isGetProp()) {
            return false;
        }
        Node parent = getProp.getParent();
        return parent.isAssign() && parent.getFirstChild() == getProp && parent.getFirstChild().getLastChild().getString().equals("prototype");
    }

    static boolean isPropertyTest(AbstractCompiler compiler, Node propAccess) {
        Node parent = propAccess.getParent();
        switch (parent.getToken()) {
            case CALL: {
                return parent.getFirstChild() != propAccess && compiler.getCodingConvention().isPropertyTestFunction(parent);
            }
            case IF: 
            case FOR_IN: 
            case FOR: 
            case DO: 
            case WHILE: {
                return NodeUtil.getConditionExpression(parent) == propAccess;
            }
            case AND: 
            case OR: 
            case INSTANCEOF: 
            case TYPEOF: {
                return true;
            }
            case NE: 
            case SHNE: {
                Node other = parent.getFirstChild() == propAccess ? parent.getSecondChild() : parent.getFirstChild();
                return NodeUtil.isUndefined(other);
            }
            case HOOK: {
                return parent.getFirstChild() == propAccess;
            }
            case NOT: {
                return parent.getParent().isOr() && parent.getParent().getFirstChild() == parent;
            }
            case CAST: {
                return NodeUtil.isPropertyTest(compiler, parent);
            }
        }
        return false;
    }

    static boolean isPropertyAbsenceTest(Node propAccess) {
        Node parent = propAccess.getParent();
        switch (parent.getToken()) {
            case EQ: 
            case SHEQ: {
                Node other = parent.getFirstChild() == propAccess ? parent.getSecondChild() : parent.getFirstChild();
                return NodeUtil.isUndefined(other);
            }
        }
        return false;
    }

    static Node getPrototypeClassName(Node qName) {
        if (!qName.isGetProp()) {
            return null;
        }
        if (qName.getLastChild().getString().equals("prototype")) {
            return qName.getFirstChild();
        }
        Node recv = qName.getFirstChild();
        if (recv.isGetProp() && recv.getLastChild().getString().equals("prototype")) {
            return recv.getFirstChild();
        }
        return null;
    }

    static String getPrototypePropertyName(Node qName) {
        String qNameStr = qName.getQualifiedName();
        int prototypeIdx = qNameStr.lastIndexOf(".prototype.");
        int memberIndex = prototypeIdx + ".prototype".length() + 1;
        return qNameStr.substring(memberIndex);
    }

    static Node newUndefinedNode(Node srcReferenceNode) {
        Node node = IR.voidNode(IR.number(0.0));
        if (srcReferenceNode != null) {
            node.useSourceInfoFromForTree(srcReferenceNode);
        }
        return node;
    }

    static Node newVarNode(String name, Node value) {
        Node lhs = IR.name(name);
        if (value != null) {
            lhs.srcref(value);
        }
        return NodeUtil.newVarNode(lhs, value);
    }

    static Node newVarNode(Node lhs, Node value) {
        if (lhs.isDestructuringPattern()) {
            Preconditions.checkNotNull(value);
            return IR.var(new Node(Token.DESTRUCTURING_LHS, lhs, value).srcref(lhs)).srcref(lhs);
        }
        Preconditions.checkState(lhs.isName() && !lhs.hasChildren());
        if (value != null) {
            lhs.addChildToBack(value);
        }
        return IR.var(lhs).srcref(lhs);
    }

    public static Node emptyFunction() {
        return IR.function(IR.name(""), IR.paramList(), IR.block());
    }

    static int getNodeTypeReferenceCount(Node node, Token type, Predicate<Node> traverseChildrenPred) {
        return NodeUtil.getCount(node, new MatchNodeType(type), traverseChildrenPred);
    }

    static boolean isNameReferenced(Node node, String name, Predicate<Node> traverseChildrenPred) {
        return NodeUtil.has(node, new MatchNameNode(name), traverseChildrenPred);
    }

    static boolean isNameReferenced(Node node, String name) {
        return NodeUtil.isNameReferenced(node, name, Predicates.alwaysTrue());
    }

    static int getNameReferenceCount(Node node, String name) {
        return NodeUtil.getCount(node, new MatchNameNode(name), Predicates.alwaysTrue());
    }

    public static boolean has(Node node, Predicate<Node> pred, Predicate<Node> traverseChildrenPred) {
        if (pred.apply(node)) {
            return true;
        }
        if (!traverseChildrenPred.apply(node)) {
            return false;
        }
        for (Node c = node.getFirstChild(); c != null; c = c.getNext()) {
            if (!NodeUtil.has(c, pred, traverseChildrenPred)) continue;
            return true;
        }
        return false;
    }

    public static int getCount(Node n, Predicate<Node> pred, Predicate<Node> traverseChildrenPred) {
        int total = 0;
        if (pred.apply(n)) {
            ++total;
        }
        if (traverseChildrenPred.apply(n)) {
            for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
                total += NodeUtil.getCount(c, pred, traverseChildrenPred);
            }
        }
        return total;
    }

    public static void visitPreOrder(Node node, Visitor visitor) {
        NodeUtil.visitPreOrder(node, visitor, Predicates.alwaysTrue());
    }

    public static void visitPreOrder(Node node, Visitor visitor, Predicate<Node> traverseChildrenPred) {
        visitor.visit(node);
        if (traverseChildrenPred.apply(node)) {
            for (Node c = node.getFirstChild(); c != null; c = c.getNext()) {
                NodeUtil.visitPreOrder(c, visitor, traverseChildrenPred);
            }
        }
    }

    public static void visitPostOrder(Node node, Visitor visitor) {
        NodeUtil.visitPostOrder(node, visitor, Predicates.alwaysTrue());
    }

    public static void visitPostOrder(Node node, Visitor visitor, Predicate<Node> traverseChildrenPred) {
        if (traverseChildrenPred.apply(node)) {
            for (Node c = node.getFirstChild(); c != null; c = c.getNext()) {
                NodeUtil.visitPostOrder(c, visitor, traverseChildrenPred);
            }
        }
        visitor.visit(node);
    }

    static boolean isExportFrom(Node n) {
        Preconditions.checkArgument(n.isExport());
        return n.hasTwoChildren();
    }

    static boolean hasFinally(Node n) {
        Preconditions.checkArgument(n.isTry());
        return n.hasXChildren(3);
    }

    static Node getCatchBlock(Node n) {
        Preconditions.checkArgument(n.isTry());
        return n.getSecondChild();
    }

    static boolean hasCatchHandler(Node n) {
        Preconditions.checkArgument(n.isBlock());
        return n.hasChildren() && n.getFirstChild().isCatch();
    }

    public static Node getFunctionParameters(Node fnNode) {
        Preconditions.checkArgument(fnNode.isFunction());
        return fnNode.getSecondChild();
    }

    public static int getApproxRequiredArity(Node fun) {
        Preconditions.checkArgument(fun.isFunction());
        Preconditions.checkArgument(NodeUtil.getBestJSDocInfo(fun) == null, "Expected unannotated function, found: %s", (Object)fun);
        int result = 0;
        for (Node param : fun.getSecondChild().children()) {
            if (param.isOptionalArg() || param.isVarArgs()) break;
            ++result;
        }
        return result;
    }

    static boolean isConstantVar(Node node, @Nullable Scope scope) {
        if (NodeUtil.isConstantName(node)) {
            return true;
        }
        if (!node.isName() || scope == null) {
            return false;
        }
        Var var = (Var)scope.getVar(node.getString());
        return var != null && (var.isInferredConst() || var.isConst());
    }

    static boolean isConstantName(Node node) {
        return node.getBooleanProp((byte)43);
    }

    static boolean isConstantByConvention(CodingConvention convention, Node node) {
        Node parent = node.getParent();
        if (parent.isGetProp() && node == parent.getLastChild()) {
            return convention.isConstantKey(node.getString());
        }
        if (NodeUtil.isObjectLitKey(node)) {
            return convention.isConstantKey(node.getString());
        }
        if (node.isName()) {
            return convention.isConstant(node.getString());
        }
        return false;
    }

    static boolean isConstantDeclaration(CodingConvention convention, JSDocInfo info, Node node) {
        if (node.isName() && node.getParent().isConst()) {
            return true;
        }
        if (node.isName() && NodeUtil.isLhsByDestructuring(node) && NodeUtil.getRootTarget(node).getGrandparent().isConst()) {
            return true;
        }
        if (info != null && info.isConstant()) {
            return true;
        }
        if (node.getBooleanProp((byte)65)) {
            return true;
        }
        switch (node.getToken()) {
            case NAME: {
                return NodeUtil.isConstantByConvention(convention, node);
            }
            case GETPROP: {
                return node.isQualifiedName() && NodeUtil.isConstantByConvention(convention, node.getLastChild());
            }
        }
        return false;
    }

    static boolean functionHasInlineJsdocs(Node fn) {
        if (!fn.isFunction()) {
            return false;
        }
        if (fn.getFirstChild().getJSDocInfo() != null) {
            return true;
        }
        for (Node param = fn.getSecondChild().getFirstChild(); param != null; param = param.getNext()) {
            if (param.getJSDocInfo() == null) continue;
            return true;
        }
        return false;
    }

    public static String getSourceName(Node n) {
        String sourceName = null;
        while (sourceName == null && n != null) {
            sourceName = n.getSourceFileName();
            n = n.getParent();
        }
        return sourceName;
    }

    public static StaticSourceFile getSourceFile(Node n) {
        StaticSourceFile sourceName = null;
        while (sourceName == null && n != null) {
            sourceName = n.getStaticSourceFile();
            n = n.getParent();
        }
        return sourceName;
    }

    public static InputId getInputId(Node n) {
        while (n != null && !n.isScript()) {
            n = n.getParent();
        }
        return n != null && n.isScript() ? n.getInputId() : null;
    }

    public static Node getNodeByLineCol(Node ancestor, int lineNo, int columNo) {
        Preconditions.checkArgument(ancestor.isScript());
        Node current = ancestor;
        Node result = null;
        while (current != null) {
            int currLineNo = current.getLineno();
            Preconditions.checkState(current.getLineno() <= lineNo);
            Node nextSibling = current.getNext();
            if (nextSibling != null) {
                int nextSiblingLineNo = nextSibling.getLineno();
                int nextSiblingColumNo = NodeUtil.getColumnNoBase1(nextSibling);
                if (result != null && lineNo == nextSiblingLineNo && columNo == nextSiblingColumNo) {
                    if (result.hasChildren() && !nextSibling.hasChildren()) {
                        return nextSibling;
                    }
                    return result;
                }
                if (lineNo > nextSiblingLineNo || lineNo > currLineNo && lineNo == nextSiblingLineNo || lineNo == nextSiblingLineNo && columNo > nextSiblingColumNo) {
                    current = nextSibling;
                    continue;
                }
            }
            int currColumNo = NodeUtil.getColumnNoBase1(current);
            if (currLineNo == lineNo) {
                if (currColumNo > columNo) {
                    return result;
                }
                if (currColumNo + current.getLength() >= columNo) {
                    result = current;
                }
            }
            current = current.getFirstChild();
        }
        return result;
    }

    private static int getColumnNoBase1(Node n) {
        return n.getCharno() + 1;
    }

    static Node newCallNode(Node callTarget, Node ... parameters) {
        boolean isFreeCall = !NodeUtil.isGet(callTarget);
        Node call = IR.call(callTarget, new Node[0]);
        call.putBooleanProp((byte)50, isFreeCall);
        for (Node parameter : parameters) {
            call.addChildToBack(parameter);
        }
        return call;
    }

    static boolean evaluatesToLocalValue(Node value) {
        return NodeUtil.evaluatesToLocalValue(value, Predicates.alwaysFalse());
    }

    static boolean evaluatesToLocalValue(Node value, Predicate<Node> locals) {
        switch (value.getToken()) {
            case ASSIGN: {
                return NodeUtil.isImmutableValue(value.getLastChild()) || locals.apply(value) && NodeUtil.evaluatesToLocalValue(value.getLastChild(), locals);
            }
            case COMMA: {
                return NodeUtil.evaluatesToLocalValue(value.getLastChild(), locals);
            }
            case AND: 
            case OR: {
                return NodeUtil.evaluatesToLocalValue(value.getFirstChild(), locals) && NodeUtil.evaluatesToLocalValue(value.getLastChild(), locals);
            }
            case HOOK: {
                return NodeUtil.evaluatesToLocalValue(value.getSecondChild(), locals) && NodeUtil.evaluatesToLocalValue(value.getLastChild(), locals);
            }
            case THIS: 
            case SUPER: {
                return locals.apply(value);
            }
            case NAME: {
                return NodeUtil.isImmutableValue(value) || locals.apply(value);
            }
            case GETPROP: 
            case GETELEM: {
                return locals.apply(value);
            }
            case CALL: {
                return NodeUtil.callHasLocalResult(value) || NodeUtil.isToStringMethodCall(value) || locals.apply(value);
            }
            case TAGGED_TEMPLATELIT: {
                return NodeUtil.callHasLocalResult(value) || locals.apply(value);
            }
            case NEW: {
                return NodeUtil.newHasLocalResult(value) || locals.apply(value);
            }
            case ARRAYLIT: 
            case OBJECTLIT: 
            case TEMPLATELIT: 
            case REGEXP: 
            case FUNCTION: 
            case CLASS: 
            case DELPROP: 
            case INC: 
            case DEC: 
            case EMPTY: {
                return true;
            }
            case CAST: {
                return NodeUtil.evaluatesToLocalValue(value.getFirstChild(), locals);
            }
            case YIELD: 
            case SPREAD: 
            case AWAIT: {
                return false;
            }
        }
        if (NodeUtil.isAssignmentOp(value) || NodeUtil.isSimpleOperator(value) || NodeUtil.isImmutableValue(value)) {
            return true;
        }
        throw new IllegalStateException("Unexpected expression node: " + value + "\n parent:" + value.getParent());
    }

    static boolean mayBeUndefined(Node n) {
        return !NodeUtil.isDefinedValue(n);
    }

    static boolean isDefinedValue(Node value) {
        switch (value.getToken()) {
            case ASSIGN: 
            case COMMA: 
            case CAST: {
                return NodeUtil.isDefinedValue(value.getLastChild());
            }
            case AND: 
            case OR: {
                return NodeUtil.isDefinedValue(value.getFirstChild()) && NodeUtil.isDefinedValue(value.getLastChild());
            }
            case HOOK: {
                return NodeUtil.isDefinedValue(value.getSecondChild()) && NodeUtil.isDefinedValue(value.getLastChild());
            }
            case NEW: 
            case VOID: 
            case GETPROP: 
            case GETELEM: 
            case YIELD: 
            case CALL: 
            case TAGGED_TEMPLATELIT: 
            case THIS: 
            case AWAIT: {
                return false;
            }
            case ARRAYLIT: 
            case OBJECTLIT: 
            case TEMPLATELIT: 
            case STRING: 
            case NUMBER: 
            case NULL: 
            case FALSE: 
            case TRUE: 
            case REGEXP: 
            case FUNCTION: 
            case CLASS: 
            case DELPROP: 
            case INC: 
            case DEC: 
            case EMPTY: {
                return true;
            }
            case NAME: {
                String name = value.getString();
                return "Infinity".equals(name) || "NaN".equals(name);
            }
        }
        if (NodeUtil.isAssignmentOp(value) || NodeUtil.isSimpleOperator(value)) {
            return true;
        }
        throw new IllegalStateException("Unexpected expression node: " + value + "\n parent:" + value.getParent());
    }

    private static Node getNthSibling(Node first, int index) {
        Node sibling;
        for (sibling = first; index != 0 && sibling != null; sibling = sibling.getNext(), --index) {
        }
        return sibling;
    }

    static Node getArgumentForFunction(Node function, int index) {
        Preconditions.checkState(function.isFunction());
        return NodeUtil.getNthSibling(function.getSecondChild().getFirstChild(), index);
    }

    static Node getArgumentForCallOrNew(Node call, int index) {
        Preconditions.checkState(NodeUtil.isCallOrNew(call));
        return NodeUtil.getNthSibling(call.getSecondChild(), index);
    }

    static boolean isInvocationTarget(Node n) {
        Node parent = n.getParent();
        return parent != null && (NodeUtil.isCallOrNew(parent) || parent.isTaggedTemplateLit()) && parent.getFirstChild() == n;
    }

    static boolean isInvocation(Node n) {
        return NodeUtil.isCallOrNew(n) || n.isTaggedTemplateLit();
    }

    static boolean isCallOrNewArgument(Node n) {
        Node parent = n.getParent();
        return parent != null && NodeUtil.isCallOrNew(parent) && parent.getFirstChild() != n;
    }

    private static boolean isToStringMethodCall(Node call) {
        Node getNode = call.getFirstChild();
        if (NodeUtil.isGet(getNode)) {
            Node propNode = getNode.getLastChild();
            return propNode.isString() && "toString".equals(propNode.getString());
        }
        return false;
    }

    @Nullable
    public static JSTypeExpression getDeclaredTypeExpression(Node declaration) {
        JSDocInfo functionJsdoc;
        Preconditions.checkArgument(declaration.isName() || declaration.isStringKey());
        JSDocInfo nameJsdoc = NodeUtil.getBestJSDocInfo(declaration);
        if (nameJsdoc != null) {
            return nameJsdoc.getType();
        }
        Node parent = declaration.getParent();
        if (parent.isRest() || parent.isDefaultValue()) {
            parent = parent.getParent();
        }
        if (parent.isParamList() && (functionJsdoc = NodeUtil.getBestJSDocInfo(parent.getParent())) != null) {
            return functionJsdoc.getParameterType(declaration.getString());
        }
        return null;
    }

    @Nullable
    public static JSDocInfo getBestJSDocInfo(Node n) {
        Node jsdocNode = NodeUtil.getBestJSDocInfoNode(n);
        return jsdocNode == null ? null : jsdocNode.getJSDocInfo();
    }

    @Nullable
    public static Node getBestJSDocInfoNode(Node n) {
        if (n.isExprResult()) {
            return NodeUtil.getBestJSDocInfoNode(n.getFirstChild());
        }
        JSDocInfo info = n.getJSDocInfo();
        if (info == null) {
            Node parent = n.getParent();
            if (parent == null || n.isExprResult()) {
                return null;
            }
            if (parent.isName()) {
                return NodeUtil.getBestJSDocInfoNode(parent);
            }
            if (parent.isAssign()) {
                return NodeUtil.getBestJSDocInfoNode(parent);
            }
            if (NodeUtil.isObjectLitKey(parent) || parent.isComputedProp()) {
                return parent;
            }
            if ((parent.isFunction() || parent.isClass()) && n == parent.getFirstChild()) {
                return NodeUtil.getBestJSDocInfoNode(parent);
            }
            if (NodeUtil.isNameDeclaration(parent) && parent.hasOneChild()) {
                return parent;
            }
            if (parent.isHook() && parent.getFirstChild() != n || parent.isOr() || parent.isAnd() || parent.isComma() && parent.getFirstChild() != n) {
                return NodeUtil.getBestJSDocInfoNode(parent);
            }
        }
        return n;
    }

    public static Node getBestLValue(Node n) {
        Node parent = n.getParent();
        if (NodeUtil.isFunctionDeclaration(n) || NodeUtil.isClassDeclaration(n)) {
            return n.getFirstChild();
        }
        if (n.isClassMembers()) {
            return NodeUtil.getBestLValue(parent);
        }
        if (parent.isName()) {
            return parent;
        }
        if (parent.isAssign()) {
            return parent.getFirstChild();
        }
        if (NodeUtil.isObjectLitKey(parent) || parent.isComputedProp()) {
            return parent;
        }
        if (parent.isHook() && parent.getFirstChild() != n || parent.isOr() || parent.isAnd() || parent.isComma() && parent.getFirstChild() != n) {
            return NodeUtil.getBestLValue(parent);
        }
        if (parent.isCast()) {
            return NodeUtil.getBestLValue(parent);
        }
        return null;
    }

    public static Node getRValueOfLValue(Node n) {
        Node parent = n.getParent();
        switch (parent.getToken()) {
            case ASSIGN: 
            case ASSIGN_BITOR: 
            case ASSIGN_BITXOR: 
            case ASSIGN_BITAND: 
            case ASSIGN_LSH: 
            case ASSIGN_RSH: 
            case ASSIGN_URSH: 
            case ASSIGN_ADD: 
            case ASSIGN_SUB: 
            case ASSIGN_MUL: 
            case ASSIGN_EXPONENT: 
            case ASSIGN_DIV: 
            case ASSIGN_MOD: {
                return n.getNext();
            }
            case VAR: 
            case LET: 
            case CONST: {
                return n.getLastChild();
            }
            case DESTRUCTURING_LHS: {
                return parent.getLastChild();
            }
            case OBJECTLIT: {
                return n.getFirstChild();
            }
            case FUNCTION: 
            case CLASS: {
                return parent;
            }
        }
        return null;
    }

    static Node getBestLValueOwner(@Nullable Node lValue) {
        if (lValue == null || lValue.getParent() == null) {
            return null;
        }
        if (NodeUtil.isObjectLitKey(lValue) || lValue.isComputedProp()) {
            return NodeUtil.getBestLValue(lValue.getParent());
        }
        if (NodeUtil.isGet(lValue)) {
            return lValue.getFirstChild();
        }
        return null;
    }

    static String getBestLValueName(@Nullable Node lValue) {
        if (lValue == null || lValue.getParent() == null) {
            return null;
        }
        if (lValue.getParent().isClassMembers() && !lValue.isComputedProp()) {
            String className = NodeUtil.getName(lValue.getGrandparent());
            if (className == null) {
                return null;
            }
            String methodName = lValue.getString();
            String maybePrototype = lValue.isStaticMember() ? "." : ".prototype.";
            return className + maybePrototype + methodName;
        }
        if (NodeUtil.isObjectLitKey(lValue)) {
            String ownerName;
            Node owner = NodeUtil.getBestLValue(lValue.getParent());
            if (owner != null && (ownerName = NodeUtil.getBestLValueName(owner)) != null) {
                String key = NodeUtil.getObjectLitKeyName(lValue);
                return TokenStream.isJSIdentifier(key) ? ownerName + "." + key : null;
            }
            return null;
        }
        return lValue.getQualifiedName();
    }

    static Node getBestLValueRoot(@Nullable Node lValue) {
        if (lValue == null) {
            return null;
        }
        switch (lValue.getToken()) {
            case STRING_KEY: {
                return NodeUtil.getBestLValueRoot(NodeUtil.getBestLValue(lValue.getParent()));
            }
            case GETPROP: 
            case GETELEM: {
                return NodeUtil.getBestLValueRoot(lValue.getFirstChild());
            }
            case NAME: 
            case THIS: 
            case SUPER: {
                return lValue;
            }
        }
        return null;
    }

    static boolean isExpressionResultUsed(Node expr) {
        Node parent = expr.getParent();
        switch (parent.getToken()) {
            case BLOCK: 
            case EXPR_RESULT: {
                return false;
            }
            case CAST: {
                return NodeUtil.isExpressionResultUsed(parent);
            }
            case AND: 
            case OR: 
            case HOOK: {
                return expr == parent.getFirstChild() || NodeUtil.isExpressionResultUsed(parent);
            }
            case COMMA: {
                Node grandparent = parent.getParent();
                if (grandparent.isCall() && parent == grandparent.getFirstChild() && expr == parent.getFirstChild() && parent.hasTwoChildren() && expr.getNext().isName() && "eval".equals(expr.getNext().getString())) {
                    return true;
                }
                return expr == parent.getFirstChild() ? false : NodeUtil.isExpressionResultUsed(parent);
            }
            case FOR: {
                return parent.getSecondChild() == expr;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    static boolean isExecutedExactlyOnce(Node n) {
        do {
            Node parent = n.getParent();
            switch (parent.getToken()) {
                case AND: 
                case OR: 
                case HOOK: 
                case IF: {
                    if (parent.getFirstChild() == n) break;
                    return false;
                }
                case FOR_IN: 
                case FOR: {
                    if (!(parent.isForIn() ? parent.getSecondChild() != n : parent.getFirstChild() != n)) break;
                    return false;
                }
                case DO: 
                case WHILE: {
                    return false;
                }
                case TRY: {
                    if (!NodeUtil.hasFinally(parent)) return false;
                    if (parent.getLastChild() == n) break;
                    return false;
                }
                case CASE: 
                case DEFAULT_CASE: {
                    return false;
                }
                case FUNCTION: 
                case SCRIPT: {
                    return true;
                }
            }
        } while ((n = n.getParent()) != null);
        return true;
    }

    static Node booleanNode(boolean value) {
        return value ? IR.trueNode() : IR.falseNode();
    }

    static Node numberNode(double value, Node srcref) {
        Node result = Double.isNaN(value) ? IR.name("NaN") : (value == Double.POSITIVE_INFINITY ? IR.name("Infinity") : (value == Double.NEGATIVE_INFINITY ? IR.neg(IR.name("Infinity")) : IR.number(value)));
        if (srcref != null) {
            result.srcrefTree(srcref);
        }
        return result;
    }

    static boolean isNaN(Node n) {
        return n.isName() && n.getString().equals("NaN") || n.getToken() == Token.DIV && n.getFirstChild().isNumber() && n.getFirstChild().getDouble() == 0.0 && n.getLastChild().isNumber() && n.getLastChild().getDouble() == 0.0;
    }

    static boolean isChangeScopeRoot(Node n) {
        return n.isScript() || n.isFunction();
    }

    static Node getEnclosingChangeScopeRoot(Node n) {
        while (n != null && !NodeUtil.isChangeScopeRoot(n)) {
            n = n.getParent();
        }
        return n;
    }

    static int countAstSizeUpToLimit(Node n, final int limit) {
        final int[] wrappedSize = new int[]{0};
        NodeUtil.visitPreOrder(n, new Visitor(){

            @Override
            public void visit(Node n) {
                wrappedSize[0] = wrappedSize[0] + 1;
            }
        }, new Predicate<Node>(){

            @Override
            public boolean apply(Node n) {
                return wrappedSize[0] < limit;
            }
        });
        return wrappedSize[0];
    }

    static int countAstSize(Node n) {
        int count = 1;
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            count += NodeUtil.countAstSize(c);
        }
        return count;
    }

    static JSDocInfo createConstantJsDoc() {
        JSDocInfoBuilder builder = new JSDocInfoBuilder(false);
        builder.recordConstancy();
        return builder.build();
    }

    static int toInt32(double d) {
        int id = (int)d;
        if ((double)id == d) {
            return id;
        }
        if (Double.isNaN(d) || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
            return 0;
        }
        d = d >= 0.0 ? Math.floor(d) : Math.ceil(d);
        double two32 = 4.294967296E9;
        long l = (long)(d %= two32);
        return (int)l;
    }

    static int toUInt32(double d) {
        if (Double.isNaN(d) || Double.isInfinite(d) || d == 0.0) {
            return 0;
        }
        d = Math.signum(d) * Math.floor(Math.abs(d));
        double two32 = 4.294967296E9;
        d = (d % two32 + two32) % two32;
        long l = (long)d;
        return (int)l;
    }

    private static boolean isGoogModuleCall(Node n) {
        if (NodeUtil.isExprCall(n)) {
            Node target = n.getFirstFirstChild();
            return target.matchesQualifiedName("goog.module");
        }
        return false;
    }

    static boolean isModuleScopeRoot(Node n) {
        return n.isModuleBody() || NodeUtil.isBundledGoogModuleScopeRoot(n);
    }

    private static boolean isBundledGoogModuleScopeRoot(Node n) {
        if (!(n.isBlock() && n.hasChildren() && NodeUtil.isGoogModuleCall(n.getFirstChild()))) {
            return false;
        }
        Node function = n.getParent();
        if (!(function != null && function.isFunction() && NodeUtil.getFunctionParameters(function).hasOneChild() && NodeUtil.getFunctionParameters(function).getFirstChild().matchesQualifiedName("exports"))) {
            return false;
        }
        Node call = function.getParent();
        if (!(call.isCall() && call.hasTwoChildren() && call.getFirstChild().matchesQualifiedName("goog.loadModule"))) {
            return false;
        }
        return call.getParent().isExprResult() && call.getGrandparent().isScript();
    }

    static boolean isGoogModuleDeclareLegacyNamespaceCall(Node n) {
        if (NodeUtil.isExprCall(n)) {
            Node target = n.getFirstFirstChild();
            return target.matchesQualifiedName("goog.module.declareLegacyNamespace");
        }
        return false;
    }

    public static boolean isTopLevel(Node n) {
        return n.isScript() || n.isModuleBody();
    }

    static boolean isGoogModuleFile(Node n) {
        return n.isScript() && n.hasChildren() && n.getFirstChild().isModuleBody() && NodeUtil.isGoogModuleCall(n.getFirstFirstChild());
    }

    static boolean isLegacyGoogModuleFile(Node n) {
        return NodeUtil.isGoogModuleFile(n) && NodeUtil.isGoogModuleDeclareLegacyNamespaceCall(n.getFirstChild().getSecondChild());
    }

    static boolean isConstructor(Node fnNode) {
        if (fnNode == null || !fnNode.isFunction()) {
            return false;
        }
        JSType type = fnNode.getJSType();
        JSDocInfo jsDocInfo = NodeUtil.getBestJSDocInfo(fnNode);
        return type != null && type.isConstructor() || jsDocInfo != null && jsDocInfo.isConstructor() || NodeUtil.isEs6Constructor(fnNode);
    }

    private static boolean isEs6Constructor(Node fnNode) {
        return fnNode.isFunction() && fnNode.getGrandparent() != null && fnNode.getGrandparent().isClassMembers() && fnNode.getParent().matchesQualifiedName("constructor");
    }

    static boolean isGetterOrSetter(Node propNode) {
        if (NodeUtil.isGetOrSetKey(propNode)) {
            return true;
        }
        if (!propNode.isStringKey() || !propNode.getFirstChild().isFunction()) {
            return false;
        }
        String keyName = propNode.getString();
        return keyName.equals("get") || keyName.equals("set");
    }

    public static boolean isCallTo(Node n, String qualifiedName) {
        return n.isCall() && n.getFirstChild().matchesQualifiedName(qualifiedName);
    }

    static ImmutableSet<String> collectExternVariableNames(AbstractCompiler compiler, Node externs) {
        ReferenceCollectingCallback externsRefs = new ReferenceCollectingCallback(compiler, ReferenceCollectingCallback.DO_NOTHING_BEHAVIOR, new Es6SyntacticScopeCreator(compiler));
        externsRefs.process(externs);
        ImmutableSet.Builder externsNames = ImmutableSet.builder();
        for (Var v : externsRefs.getAllSymbols()) {
            if (v.isParam()) continue;
            externsNames.add(v.getName());
        }
        return externsNames.build();
    }

    static void markNewScopesChanged(Node node, AbstractCompiler compiler) {
        if (node.isFunction()) {
            compiler.reportChangeToChangeScope(node);
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNext()) {
            NodeUtil.markNewScopesChanged(child, compiler);
        }
    }

    public static void markFunctionsDeleted(Node node, AbstractCompiler compiler) {
        if (node.isFunction()) {
            compiler.reportFunctionDeleted(node);
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNext()) {
            NodeUtil.markFunctionsDeleted(child, compiler);
        }
    }

    public static List<Node> getParentChangeScopeNodes(List<Node> scopeNodes) {
        LinkedHashSet<Node> parentScopeNodes = new LinkedHashSet<Node>(scopeNodes);
        for (Node scopeNode : scopeNodes) {
            parentScopeNodes.add(NodeUtil.getEnclosingChangeScopeRoot(scopeNode));
        }
        return new ArrayList<Node>(parentScopeNodes);
    }

    public static List<Node> removeNestedChangeScopeNodes(List<Node> scopeNodes) {
        LinkedHashSet<Node> uniqueScopeNodes = new LinkedHashSet<Node>(scopeNodes);
        block0: for (Node scopeNode : scopeNodes) {
            for (Node ancestor = scopeNode.getParent(); ancestor != null; ancestor = ancestor.getParent()) {
                if (!NodeUtil.isChangeScopeRoot(ancestor) || !uniqueScopeNodes.contains(ancestor)) continue;
                uniqueScopeNodes.remove(scopeNode);
                continue block0;
            }
        }
        return new ArrayList<Node>(uniqueScopeNodes);
    }

    static Iterable<Node> getInvocationArgsAsIterable(Node invocation) {
        if (invocation.isTaggedTemplateLit()) {
            return new TemplateArgsIterable(invocation.getLastChild());
        }
        Preconditions.checkState(NodeUtil.isCallOrNew(invocation), invocation);
        return invocation.hasOneChild() ? ImmutableList.of() : invocation.getSecondChild().siblings();
    }

    static int getInvocationArgsCount(Node invocation) {
        if (invocation.isTaggedTemplateLit()) {
            TemplateArgsIterable args = new TemplateArgsIterable(invocation.getLastChild());
            return Iterables.size(args) + 1;
        }
        return invocation.getChildCount() - 1;
    }

    static void getAllVarsDeclaredInFunction(final Map<String, Var> nameVarMap, final List<Var> orderedVars, AbstractCompiler compiler, ScopeCreator scopeCreator, final Scope scope) {
        Preconditions.checkState(nameVarMap.isEmpty());
        Preconditions.checkState(orderedVars.isEmpty());
        Preconditions.checkState(scope.isFunctionScope(), scope);
        NodeTraversal.ScopedCallback finder = new NodeTraversal.ScopedCallback(){

            @Override
            public void enterScope(NodeTraversal t) {
                Scope currentScope = t.getScope();
                for (Var v : currentScope.getVarIterable()) {
                    nameVarMap.put(v.getName(), v);
                    orderedVars.add(v);
                }
            }

            @Override
            public void exitScope(NodeTraversal t) {
            }

            @Override
            public final boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
                return !n.isFunction() || n == scope.getRootNode();
            }

            @Override
            public void visit(NodeTraversal t, Node n, Node parent) {
            }
        };
        NodeTraversal t = new NodeTraversal(compiler, finder, scopeCreator);
        t.traverseAtScope(scope);
    }

    public static boolean isObjLitProperty(Node node) {
        return node.isStringKey() || node.isGetterDef() || node.isSetterDef() || node.isMemberFunctionDef() || node.isComputedProp();
    }

    public static boolean isBlocklessArrowFunctionResult(Node n) {
        Node parent = n.getParent();
        return parent != null && parent.isFunction() && n == parent.getLastChild() && !n.isBlock();
    }

    @Nullable
    static FeatureSet getFeatureSetOfScript(Node scriptNode) {
        Preconditions.checkState(scriptNode.isScript(), scriptNode);
        return (FeatureSet)scriptNode.getProp((byte)89);
    }

    static void addFeatureToScript(Node scriptNode, FeatureSet.Feature feature) {
        Preconditions.checkState(scriptNode.isScript(), scriptNode);
        FeatureSet currentFeatures = NodeUtil.getFeatureSetOfScript(scriptNode);
        FeatureSet newFeatures = currentFeatures != null ? currentFeatures.with(feature) : FeatureSet.BARE_MINIMUM.with(feature);
        scriptNode.putProp((byte)89, newFeatures);
    }

    private static final class TemplateArgsIterable
    implements Iterable<Node> {
        private final Node templateLit;

        TemplateArgsIterable(Node templateLit) {
            Preconditions.checkState(templateLit.isTemplateLit());
            this.templateLit = templateLit;
        }

        @Override
        public Iterator<Node> iterator() {
            return new AbstractIterator<Node>(){
                @Nullable
                private Node nextChild;
                {
                    this.nextChild = templateLit.getFirstChild();
                }

                @Override
                protected Node computeNext() {
                    while (this.nextChild != null && !this.nextChild.isTemplateLitSub()) {
                        this.nextChild = this.nextChild.getNext();
                    }
                    if (this.nextChild == null) {
                        return (Node)this.endOfData();
                    }
                    Node result = this.nextChild.getFirstChild();
                    this.nextChild = this.nextChild.getNext();
                    return result;
                }
            };
        }
    }

    public static interface Visitor {
        public void visit(Node var1);
    }

    static class MatchShallowStatement
    implements Predicate<Node> {
        MatchShallowStatement() {
        }

        @Override
        public boolean apply(Node n) {
            Node parent = n.getParent();
            return n.isRoot() || n.isBlock() || !n.isFunction() && (parent == null || NodeUtil.isControlStructure(parent) || NodeUtil.isStatementBlock(parent));
        }
    }

    static class MatchDeclaration
    implements Predicate<Node> {
        MatchDeclaration() {
        }

        @Override
        public boolean apply(Node n) {
            return NodeUtil.isDeclaration(n);
        }
    }

    static class MatchNodeType
    implements Predicate<Node> {
        final Token type;

        MatchNodeType(Token type) {
            this.type = type;
        }

        @Override
        public boolean apply(Node n) {
            return n.getToken() == this.type;
        }
    }

    static class MatchNameNode
    implements Predicate<Node> {
        final String name;

        MatchNameNode(String name) {
            this.name = name;
        }

        @Override
        public boolean apply(Node n) {
            return n.isName() && n.getString().equals(this.name);
        }
    }

    private static class VarCollector
    implements Visitor {
        final Map<String, Node> vars = new LinkedHashMap<String, Node>();

        private VarCollector() {
        }

        @Override
        public void visit(Node n) {
            Node parent;
            if (n.isName() && (parent = n.getParent()) != null && parent.isVar()) {
                String name = n.getString();
                this.vars.putIfAbsent(name, n);
            }
        }
    }

    public static enum ValueType {
        UNDETERMINED,
        NULL,
        VOID,
        NUMBER,
        STRING,
        BOOLEAN,
        OBJECT;

    }
}

