/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.LinkedHashMultiset;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AutoValue_ModuleMetadata_Module;
import com.google.javascript.jscomp.ClosureCheckModule;
import com.google.javascript.jscomp.ClosureRewriteModule;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.ProcessCommonJSModules;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public final class ModuleMetadata {
    static final DiagnosticType MIXED_MODULE_TYPE = DiagnosticType.error("JSC_MIXED_MODULE_TYPE", "A file cannot be both {0} and {1}.");
    static final DiagnosticType INVALID_DECLARE_NAMESPACE_CALL = DiagnosticType.error("JSC_INVALID_DECLARE_NAMESPACE_CALL", "goog.module.declareNamespace parameter must be a string literal.");
    static final DiagnosticType DECLARE_MODULE_NAMESPACE_OUTSIDE_ES6_MODULE = DiagnosticType.error("JSC_DECLARE_MODULE_NAMESPACE_OUTSIDE_ES6_MODULE", "goog.module.declareNamespace can only be called within ES6 modules.");
    static final DiagnosticType MULTIPLE_DECLARE_MODULE_NAMESPACE = DiagnosticType.error("JSC_MULTIPLE_DECLARE_MODULE_NAMESPACE", "goog.module.declareNamespace can only be called once per ES6 module.");
    static final DiagnosticType INVALID_REQUIRE_TYPE = DiagnosticType.error("JSC_INVALID_REQUIRE_TYPE", "Argument to goog.requireType must be a string.");
    static final DiagnosticType INVALID_SET_TEST_ONLY = DiagnosticType.error("JSC_INVALID_SET_TEST_ONLY", "Optional, single argument to goog.setTestOnly must be a string.");
    private static final Node GOOG_PROVIDE = IR.getprop(IR.name("goog"), IR.string("provide"));
    private static final Node GOOG_MODULE = IR.getprop(IR.name("goog"), IR.string("module"));
    private static final Node GOOG_REQUIRE = IR.getprop(IR.name("goog"), IR.string("require"));
    private static final Node GOOG_REQUIRE_TYPE = IR.getprop(IR.name("goog"), IR.string("requireType"));
    private static final Node GOOG_SET_TEST_ONLY = IR.getprop(IR.name("goog"), IR.string("setTestOnly"));
    private static final Node GOOG_MODULE_DECLARELEGACYNAMESPACE = IR.getprop(GOOG_MODULE.cloneTree(), IR.string("declareLegacyNamespace"));
    private static final Node GOOG_MODULE_DECLARNAMESPACE = IR.getprop(GOOG_MODULE.cloneTree(), IR.string("declareNamespace"));
    private final Map<String, Module> modulesByPath = new HashMap<String, Module>();
    private final Map<String, Module> modulesByGoogNamespace = new HashMap<String, Module>();
    private final Map<Node, Module> modulesByNode = new HashMap<Node, Module>();
    private Module.Builder currentModule;
    private Module.Builder parentModule;
    private Node loadModuleCall;
    private final AbstractCompiler compiler;
    private final boolean processCommonJsModules;
    private final ModuleLoader.ResolutionMode moduleResolutionMode;
    private Finder finder;

    public ModuleMetadata(AbstractCompiler compiler) {
        this(compiler, false, ModuleLoader.ResolutionMode.BROWSER);
    }

    public ModuleMetadata(AbstractCompiler compiler, boolean processCommonJsModules, ModuleLoader.ResolutionMode moduleResolutionMode) {
        this.compiler = compiler;
        this.processCommonJsModules = processCommonJsModules;
        this.moduleResolutionMode = moduleResolutionMode;
        this.finder = new Finder();
    }

    public void process(Node externs, Node root) {
        this.finder = new Finder();
        NodeTraversal.traverse(this.compiler, externs, this.finder);
        NodeTraversal.traverse(this.compiler, root, this.finder);
    }

    private void remove(Module module) {
        if (module != null) {
            for (String symbol : module.googNamespaces()) {
                this.modulesByGoogNamespace.remove(symbol);
            }
            if (module.path() != null) {
                this.modulesByPath.remove(module.path().toString());
            }
            for (Module nested : module.nestedModules()) {
                this.remove(nested);
            }
        }
    }

    public void hotSwapScript(Node scriptRoot) {
        Module existing = this.modulesByPath.get(this.compiler.getInput(scriptRoot.getInputId()).getPath().toString());
        this.remove(existing);
        NodeTraversal.traverse(this.compiler, scriptRoot, this.finder);
    }

    public Map<String, Module> getModulesByPath() {
        return Collections.unmodifiableMap(this.modulesByPath);
    }

    public Map<String, Module> getModulesByGoogNamespace() {
        return Collections.unmodifiableMap(this.modulesByGoogNamespace);
    }

    @Nullable
    Module getContainingModule(Node n) {
        if (this.finder == null) {
            return null;
        }
        Module m = null;
        while (m == null && n != null) {
            m = this.modulesByNode.get(n);
            n = n.getParent();
        }
        return m;
    }

    private final class Finder
    implements NodeTraversal.Callback {
        private Finder() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case SCRIPT: {
                    this.enterModule(n, t.getInput().getPath());
                    break;
                }
                case IMPORT: 
                case EXPORT: {
                    this.visitImportOrExport(t, n);
                    break;
                }
                case CALL: {
                    if (!n.isCall() || !n.getFirstChild().matchesQualifiedName("goog.loadModule")) break;
                    ModuleMetadata.this.loadModuleCall = n;
                    this.enterModule(n, null);
                    break;
                }
            }
            return true;
        }

        private void visitImportOrExport(NodeTraversal t, Node importOrExport) {
            Preconditions.checkNotNull(ModuleMetadata.this.currentModule);
            ModuleMetadata.this.currentModule.moduleType(ModuleType.ES6_MODULE, t, importOrExport);
            if (importOrExport.isImport() || importOrExport.hasTwoChildren() && importOrExport.getLastChild().isString()) {
                ModuleMetadata.this.currentModule.es6ImportSpecifiersBuilder().add((Object)importOrExport.getLastChild().getString());
            }
        }

        private void enterModule(Node n, @Nullable ModuleLoader.ModulePath path) {
            Module.Builder newModule = Module.builder(ModuleMetadata.this.compiler, n, path);
            if (ModuleMetadata.this.currentModule != null) {
                Preconditions.checkState(ModuleMetadata.this.parentModule == null, "Expected modules to be nested at most 2 deep.");
                ModuleMetadata.this.parentModule = ModuleMetadata.this.currentModule;
            }
            ModuleMetadata.this.currentModule = newModule;
        }

        private void leaveModule() {
            Preconditions.checkNotNull(ModuleMetadata.this.currentModule);
            Module module = ModuleMetadata.this.currentModule.build();
            ModuleMetadata.this.modulesByNode.put(ModuleMetadata.this.currentModule.rootNode, module);
            if (module.path() != null) {
                ModuleMetadata.this.modulesByPath.put(module.path().toString(), module);
            }
            for (String namespace : module.googNamespaces()) {
                ModuleMetadata.this.modulesByGoogNamespace.put(namespace, module);
            }
            if (ModuleMetadata.this.parentModule != null) {
                ModuleMetadata.this.parentModule.nestedModulesBuilder().add((Object)module);
            }
            ModuleMetadata.this.currentModule = ModuleMetadata.this.parentModule;
            ModuleMetadata.this.parentModule = null;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (ModuleMetadata.this.processCommonJsModules && ModuleMetadata.this.currentModule != null && ModuleMetadata.this.currentModule.isScript() && (ProcessCommonJSModules.isCommonJsExport(t, n, ModuleMetadata.this.moduleResolutionMode) || ProcessCommonJSModules.isCommonJsImport(n, ModuleMetadata.this.moduleResolutionMode))) {
                ModuleMetadata.this.currentModule.moduleType(ModuleType.COMMON_JS, t, n);
                return;
            }
            switch (n.getToken()) {
                case SCRIPT: {
                    this.leaveModule();
                    break;
                }
                case NAME: {
                    this.visitName(t, n);
                    break;
                }
                case CALL: {
                    if (ModuleMetadata.this.loadModuleCall == n) {
                        this.leaveModule();
                        ModuleMetadata.this.loadModuleCall = null;
                        break;
                    }
                    this.visitGoogCall(t, n);
                    break;
                }
            }
        }

        private boolean isFromGoogImport(Var goog) {
            Node nameNode = goog.getNameNode();
            return nameNode != null && nameNode.isImportStar() && nameNode.getString().equals("goog") && nameNode.getParent().getFirstChild().isEmpty() && nameNode.getParent().getLastChild().getString().endsWith("/goog.js");
        }

        private void visitName(NodeTraversal t, Node n) {
            if (!"goog".equals(n.getString())) {
                return;
            }
            Var root = (Var)t.getScope().getVar("goog");
            if (root != null && !this.isFromGoogImport(root)) {
                return;
            }
            ModuleMetadata.this.currentModule.usesClosure(true);
        }

        private void visitGoogCall(NodeTraversal t, Node n) {
            if (!(n.hasChildren() && n.getFirstChild().isGetProp() && n.getFirstChild().isQualifiedName())) {
                return;
            }
            Node getprop = n.getFirstChild();
            Node firstProp = n.getFirstChild();
            while (firstProp.isGetProp()) {
                firstProp = firstProp.getFirstChild();
            }
            if (!firstProp.isName() || !firstProp.getString().equals("goog")) {
                return;
            }
            Var root = (Var)t.getScope().getVar("goog");
            if (root != null && !this.isFromGoogImport(root)) {
                return;
            }
            ModuleMetadata.this.currentModule.usesClosure(true);
            if (getprop.matchesQualifiedName(GOOG_PROVIDE)) {
                ModuleMetadata.this.currentModule.moduleType(ModuleType.GOOG_PROVIDE, t, n);
                if (n.hasTwoChildren() && n.getLastChild().isString()) {
                    String namespace = n.getLastChild().getString();
                    this.addNamespace(ModuleMetadata.this.currentModule, namespace, t, n);
                } else {
                    t.report(n, ClosureRewriteModule.INVALID_PROVIDE_NAMESPACE, new String[0]);
                }
            } else if (getprop.matchesQualifiedName(GOOG_MODULE)) {
                ModuleMetadata.this.currentModule.moduleType(ModuleType.GOOG_MODULE, t, n);
                if (n.hasTwoChildren() && n.getLastChild().isString()) {
                    String namespace = n.getLastChild().getString();
                    this.addNamespace(ModuleMetadata.this.currentModule, namespace, t, n);
                } else {
                    t.report(n, ClosureRewriteModule.INVALID_MODULE_NAMESPACE, new String[0]);
                }
            } else if (getprop.matchesQualifiedName(GOOG_MODULE_DECLARELEGACYNAMESPACE)) {
                ModuleMetadata.this.currentModule.recordDeclareLegacyNamespace(n);
            } else if (getprop.matchesQualifiedName(GOOG_MODULE_DECLARNAMESPACE)) {
                if (ModuleMetadata.this.currentModule.declaresNamespace != null) {
                    t.report(n, MULTIPLE_DECLARE_MODULE_NAMESPACE, new String[0]);
                }
                if (n.hasTwoChildren() && n.getLastChild().isString()) {
                    ModuleMetadata.this.currentModule.recordDeclareNamespace(n);
                    String namespace = n.getLastChild().getString();
                    this.addNamespace(ModuleMetadata.this.currentModule, namespace, t, n);
                } else {
                    t.report(n, INVALID_DECLARE_NAMESPACE_CALL, new String[0]);
                }
            } else if (getprop.matchesQualifiedName(GOOG_REQUIRE)) {
                if (n.hasTwoChildren() && n.getLastChild().isString()) {
                    ModuleMetadata.this.currentModule.requiredGoogNamespacesBuilder().add((Object)n.getLastChild().getString());
                } else {
                    t.report(n, ClosureRewriteModule.INVALID_REQUIRE_NAMESPACE, new String[0]);
                }
            } else if (getprop.matchesQualifiedName(GOOG_REQUIRE_TYPE)) {
                if (n.hasTwoChildren() && n.getLastChild().isString()) {
                    ModuleMetadata.this.currentModule.requiredTypesBuilder().add((Object)n.getLastChild().getString());
                } else {
                    t.report(n, INVALID_REQUIRE_TYPE, new String[0]);
                }
            } else if (getprop.matchesQualifiedName(GOOG_SET_TEST_ONLY)) {
                if (n.hasOneChild() || n.hasTwoChildren() && n.getLastChild().isString()) {
                    ModuleMetadata.this.currentModule.isTestOnly(true);
                } else {
                    t.report(n, INVALID_SET_TEST_ONLY, new String[0]);
                }
            }
        }

        private void addNamespace(Module.Builder module, String namespace, NodeTraversal t, Node n) {
            ModuleType existingType = null;
            if (module.googNamespaces.contains(namespace)) {
                existingType = module.moduleType();
            } else {
                Module existingModule = (Module)ModuleMetadata.this.modulesByGoogNamespace.get(namespace);
                if (existingModule != null) {
                    existingType = existingModule.moduleType();
                }
            }
            ((ModuleMetadata)ModuleMetadata.this).currentModule.googNamespaces.add(namespace);
            if (existingType != null) {
                switch (existingType) {
                    case GOOG_MODULE: 
                    case LEGACY_GOOG_MODULE: 
                    case ES6_MODULE: {
                        t.report(n, ClosureRewriteModule.DUPLICATE_MODULE, namespace);
                        return;
                    }
                    case GOOG_PROVIDE: {
                        t.report(n, ClosureRewriteModule.DUPLICATE_NAMESPACE, namespace);
                        return;
                    }
                }
                throw new IllegalStateException("Unexpected module type: " + (Object)((Object)existingType));
            }
        }
    }

    public static abstract class Module {
        public abstract ModuleType moduleType();

        public boolean isEs6Module() {
            return this.moduleType() == ModuleType.ES6_MODULE;
        }

        public boolean isGoogModule() {
            return this.isNonLegacyGoogModule() || this.isLegacyGoogModule();
        }

        public boolean isNonLegacyGoogModule() {
            return this.moduleType() == ModuleType.GOOG_MODULE;
        }

        public boolean isLegacyGoogModule() {
            return this.moduleType() == ModuleType.LEGACY_GOOG_MODULE;
        }

        public boolean isGoogProvide() {
            return this.moduleType() == ModuleType.GOOG_PROVIDE;
        }

        public boolean isCommonJs() {
            return this.moduleType() == ModuleType.COMMON_JS;
        }

        public boolean isScript() {
            return this.moduleType() == ModuleType.SCRIPT;
        }

        public abstract boolean usesClosure();

        public abstract boolean isTestOnly();

        public abstract ImmutableMultiset<String> googNamespaces();

        public abstract ImmutableMultiset<String> requiredGoogNamespaces();

        public abstract ImmutableMultiset<String> requiredTypes();

        public abstract ImmutableMultiset<String> es6ImportSpecifiers();

        abstract ImmutableList<Module> nestedModules();

        @Nullable
        public abstract ModuleLoader.ModulePath path();

        public String getGlobalName() {
            return this.getGlobalName(null);
        }

        public String getGlobalName(@Nullable String googNamespace) {
            Preconditions.checkState(googNamespace == null || this.googNamespaces().contains(googNamespace));
            switch (this.moduleType()) {
                case GOOG_MODULE: {
                    return ClosureRewriteModule.getBinaryModuleNamespace(googNamespace);
                }
                case GOOG_PROVIDE: 
                case LEGACY_GOOG_MODULE: {
                    return googNamespace;
                }
                case ES6_MODULE: 
                case COMMON_JS: {
                    return this.path().toModuleName();
                }
            }
            throw new IllegalStateException("Unexpected module type: " + (Object)((Object)this.moduleType()));
        }

        private static Builder builder(AbstractCompiler compiler, Node rootNode, @Nullable ModuleLoader.ModulePath path) {
            AutoValue_ModuleMetadata_Module.Builder builder = new AutoValue_ModuleMetadata_Module.Builder();
            ((Builder)builder).compiler = compiler;
            ((Builder)builder).rootNode = rootNode;
            return ((Builder)builder).path(path).moduleType(ModuleType.SCRIPT).usesClosure(false).isTestOnly(false);
        }

        static abstract class Builder {
            private boolean ambiguous;
            private Node declaresNamespace;
            private Node declaresLegacyNamespace;
            private Node rootNode;
            private AbstractCompiler compiler;
            LinkedHashMultiset<String> googNamespaces = LinkedHashMultiset.create();

            Builder() {
            }

            abstract Module buildInternal();

            abstract Builder googNamespaces(ImmutableMultiset<String> var1);

            abstract ImmutableMultiset.Builder<String> requiredGoogNamespacesBuilder();

            abstract ImmutableMultiset.Builder<String> requiredTypesBuilder();

            abstract ImmutableMultiset.Builder<String> es6ImportSpecifiersBuilder();

            abstract ImmutableList.Builder<Module> nestedModulesBuilder();

            abstract Builder path(@Nullable ModuleLoader.ModulePath var1);

            abstract Builder usesClosure(boolean var1);

            abstract Builder isTestOnly(boolean var1);

            abstract ModuleType moduleType();

            abstract Builder moduleType(ModuleType var1);

            void moduleType(ModuleType type, NodeTraversal t, Node n) {
                Preconditions.checkNotNull(type);
                if (this.moduleType() == type) {
                    return;
                }
                if (this.moduleType() == ModuleType.SCRIPT) {
                    this.moduleType(type);
                    return;
                }
                this.ambiguous = true;
                t.report(n, MIXED_MODULE_TYPE, this.moduleType().description, type.description);
            }

            void recordDeclareNamespace(Node declaresNamespace) {
                this.declaresNamespace = declaresNamespace;
            }

            void recordDeclareLegacyNamespace(Node declaresLegacyNamespace) {
                this.declaresLegacyNamespace = declaresLegacyNamespace;
            }

            boolean isScript() {
                return this.moduleType() == ModuleType.SCRIPT;
            }

            Module build() {
                this.googNamespaces(ImmutableMultiset.copyOf(this.googNamespaces));
                if (!this.ambiguous) {
                    if (this.declaresNamespace != null && this.moduleType() != ModuleType.ES6_MODULE) {
                        this.compiler.report(JSError.make(this.declaresNamespace, DECLARE_MODULE_NAMESPACE_OUTSIDE_ES6_MODULE, new String[0]));
                    }
                    if (this.declaresLegacyNamespace != null) {
                        if (this.moduleType() == ModuleType.GOOG_MODULE) {
                            this.moduleType(ModuleType.LEGACY_GOOG_MODULE);
                        } else {
                            this.compiler.report(JSError.make(this.declaresLegacyNamespace, ClosureCheckModule.DECLARE_LEGACY_NAMESPACE_IN_NON_MODULE, new String[0]));
                        }
                    }
                }
                return this.buildInternal();
            }
        }
    }

    public static enum ModuleType {
        ES6_MODULE("an ES6 module"),
        GOOG_PROVIDE("a goog.provide'd file"),
        GOOG_MODULE("a goog.module"),
        LEGACY_GOOG_MODULE("a goog.module"),
        COMMON_JS("a CommonJS module"),
        SCRIPT("a script");

        private final String description;

        private ModuleType(String description) {
            this.description = description;
        }
    }
}

