/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.WarningsGuard;

public class DiagnosticGroupWarningsGuard
extends WarningsGuard {
    private static final long serialVersionUID = 1L;
    private final DiagnosticGroup group;
    private final CheckLevel level;

    public DiagnosticGroupWarningsGuard(DiagnosticGroup group, CheckLevel level) {
        this.group = group;
        this.level = level;
    }

    @Override
    public CheckLevel level(JSError error) {
        return this.group.matches(error) ? this.level : null;
    }

    @Override
    public boolean disables(DiagnosticGroup otherGroup) {
        return !this.level.isOn() && this.group.isSubGroup(otherGroup);
    }

    @Override
    public boolean enables(DiagnosticGroup otherGroup) {
        if (this.level.isOn()) {
            for (DiagnosticType type : otherGroup.getTypes()) {
                if (!this.group.matches(type)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected WarningsGuard.DiagnosticGroupState enablesExplicitly(DiagnosticGroup group) {
        if (group.getName() != null && group.getName().equals(this.group.getName())) {
            return this.level.isOn() ? WarningsGuard.DiagnosticGroupState.ON : WarningsGuard.DiagnosticGroupState.OFF;
        }
        return WarningsGuard.DiagnosticGroupState.UNSPECIFIED;
    }

    @Override
    protected WarningsGuard makeNonStrict() {
        return new DiagnosticGroupWarningsGuard(this.group, this.level.isOn() ? CheckLevel.WARNING : CheckLevel.OFF);
    }

    public String toString() {
        return this.group + "(" + this.level + ")";
    }
}

