/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AbstractPeepholeOptimization;
import com.google.javascript.jscomp.AggressiveInlineAliases;
import com.google.javascript.jscomp.AliasStrings;
import com.google.javascript.jscomp.AmbiguateProperties;
import com.google.javascript.jscomp.AngularPass;
import com.google.javascript.jscomp.AnonymousFunctionNamingPolicy;
import com.google.javascript.jscomp.AstValidator;
import com.google.javascript.jscomp.CheckAccessControls;
import com.google.javascript.jscomp.CheckConformance;
import com.google.javascript.jscomp.CheckConstPrivateProperties;
import com.google.javascript.jscomp.CheckDebuggerStatement;
import com.google.javascript.jscomp.CheckGlobalNames;
import com.google.javascript.jscomp.CheckGlobalThis;
import com.google.javascript.jscomp.CheckJSDoc;
import com.google.javascript.jscomp.CheckMissingAndExtraRequires;
import com.google.javascript.jscomp.CheckMissingGetCssName;
import com.google.javascript.jscomp.CheckMissingReturn;
import com.google.javascript.jscomp.CheckProvides;
import com.google.javascript.jscomp.CheckRegExp;
import com.google.javascript.jscomp.CheckSideEffects;
import com.google.javascript.jscomp.CheckSuper;
import com.google.javascript.jscomp.CheckSuspiciousCode;
import com.google.javascript.jscomp.CheckUnreachableCode;
import com.google.javascript.jscomp.CheckUnusedPrivateProperties;
import com.google.javascript.jscomp.ChromePass;
import com.google.javascript.jscomp.ClosureCheckModule;
import com.google.javascript.jscomp.ClosureCodeRemoval;
import com.google.javascript.jscomp.ClosureOptimizePrimitives;
import com.google.javascript.jscomp.ClosureRewriteClass;
import com.google.javascript.jscomp.ClosureRewriteModule;
import com.google.javascript.jscomp.CoalesceVariableNames;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CollapseAnonymousFunctions;
import com.google.javascript.jscomp.CollapseProperties;
import com.google.javascript.jscomp.CollapseVariableDeclarations;
import com.google.javascript.jscomp.CollectFunctionNames;
import com.google.javascript.jscomp.CombinedCompilerPass;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ConstCheck;
import com.google.javascript.jscomp.ConstParamCheck;
import com.google.javascript.jscomp.ConvertToDottedProperties;
import com.google.javascript.jscomp.CoverageInstrumentationPass;
import com.google.javascript.jscomp.CreateSyntheticBlocks;
import com.google.javascript.jscomp.CrossModuleCodeMotion;
import com.google.javascript.jscomp.CrossModuleMethodMotion;
import com.google.javascript.jscomp.CustomPassExecutionTime;
import com.google.javascript.jscomp.DartSuperAccessorsPass;
import com.google.javascript.jscomp.DeadAssignmentsElimination;
import com.google.javascript.jscomp.DeadPropertyAssignmentElimination;
import com.google.javascript.jscomp.DeclaredGlobalExternsOnWindow;
import com.google.javascript.jscomp.Denormalize;
import com.google.javascript.jscomp.DevirtualizePrototypeMethods;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.DisambiguatePrivateProperties;
import com.google.javascript.jscomp.DisambiguateProperties;
import com.google.javascript.jscomp.ErrorPass;
import com.google.javascript.jscomp.Es6CheckModule;
import com.google.javascript.jscomp.Es6RewriteScriptsToModules;
import com.google.javascript.jscomp.Es6ToEs3ClassSideInheritance;
import com.google.javascript.jscomp.Es6TypedToEs6Converter;
import com.google.javascript.jscomp.ExploitAssigns;
import com.google.javascript.jscomp.ExportTestFunctions;
import com.google.javascript.jscomp.ExternExportsPass;
import com.google.javascript.jscomp.ExtractPrototypeMemberDeclarations;
import com.google.javascript.jscomp.FlowSensitiveInlineVariables;
import com.google.javascript.jscomp.FunctionRewriter;
import com.google.javascript.jscomp.GatherExternProperties;
import com.google.javascript.jscomp.GatherRawExports;
import com.google.javascript.jscomp.GenerateExports;
import com.google.javascript.jscomp.GlobalNamespace;
import com.google.javascript.jscomp.GoogleJsMessageIdGenerator;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.ImplicitNullabilityCheck;
import com.google.javascript.jscomp.InferConsts;
import com.google.javascript.jscomp.InjectRuntimeLibraries;
import com.google.javascript.jscomp.InlineAliases;
import com.google.javascript.jscomp.InlineFunctions;
import com.google.javascript.jscomp.InlineObjectLiterals;
import com.google.javascript.jscomp.InlineProperties;
import com.google.javascript.jscomp.InlineSimpleMethods;
import com.google.javascript.jscomp.InlineVariables;
import com.google.javascript.jscomp.InstrumentFunctions;
import com.google.javascript.jscomp.J2clAssertRemovalPass;
import com.google.javascript.jscomp.J2clChecksPass;
import com.google.javascript.jscomp.J2clClinitPrunerPass;
import com.google.javascript.jscomp.J2clConstantHoisterPass;
import com.google.javascript.jscomp.J2clEqualitySameRewriterPass;
import com.google.javascript.jscomp.J2clPass;
import com.google.javascript.jscomp.J2clPropertyInlinerPass;
import com.google.javascript.jscomp.J2clSourceFileChecker;
import com.google.javascript.jscomp.J2clStringValueOfRewriterPass;
import com.google.javascript.jscomp.J2clUtilGetDefineRewriterPass;
import com.google.javascript.jscomp.JsMessage;
import com.google.javascript.jscomp.MakeDeclaredNamesUnique;
import com.google.javascript.jscomp.MarkNoSideEffectCalls;
import com.google.javascript.jscomp.MinimizeExitPoints;
import com.google.javascript.jscomp.MoveFunctionDeclarations;
import com.google.javascript.jscomp.NameAnonymousFunctions;
import com.google.javascript.jscomp.NameAnonymousFunctionsMapped;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.Normalize;
import com.google.javascript.jscomp.ObjectPropertyStringPostprocess;
import com.google.javascript.jscomp.ObjectPropertyStringPreprocess;
import com.google.javascript.jscomp.OptimizeArgumentsArray;
import com.google.javascript.jscomp.OptimizeCalls;
import com.google.javascript.jscomp.OptimizeParameters;
import com.google.javascript.jscomp.OptimizeReturns;
import com.google.javascript.jscomp.PassConfig;
import com.google.javascript.jscomp.PassFactory;
import com.google.javascript.jscomp.PeepholeCollectPropertyAssignments;
import com.google.javascript.jscomp.PeepholeFoldConstants;
import com.google.javascript.jscomp.PeepholeMinimizeConditions;
import com.google.javascript.jscomp.PeepholeOptimizationsPass;
import com.google.javascript.jscomp.PeepholeRemoveDeadCode;
import com.google.javascript.jscomp.PeepholeReorderConstantExpression;
import com.google.javascript.jscomp.PeepholeReplaceKnownMethods;
import com.google.javascript.jscomp.PeepholeSubstituteAlternateSyntax;
import com.google.javascript.jscomp.PolymerPass;
import com.google.javascript.jscomp.PreprocessorSymbolTable;
import com.google.javascript.jscomp.ProcessClosurePrimitives;
import com.google.javascript.jscomp.ProcessCommonJSModules;
import com.google.javascript.jscomp.ProcessDefines;
import com.google.javascript.jscomp.ProcessTweaks;
import com.google.javascript.jscomp.PropertyRenamingPolicy;
import com.google.javascript.jscomp.PureFunctionIdentifier;
import com.google.javascript.jscomp.RemoveSuperMethodsPass;
import com.google.javascript.jscomp.RemoveUnusedCode;
import com.google.javascript.jscomp.RemoveUnusedPolyfills;
import com.google.javascript.jscomp.RenameLabels;
import com.google.javascript.jscomp.RenameProperties;
import com.google.javascript.jscomp.RenameVars;
import com.google.javascript.jscomp.ReplaceCssNames;
import com.google.javascript.jscomp.ReplaceIdGenerators;
import com.google.javascript.jscomp.ReplaceMessages;
import com.google.javascript.jscomp.ReplaceMessagesForChrome;
import com.google.javascript.jscomp.ReplaceStrings;
import com.google.javascript.jscomp.RescopeGlobalSymbols;
import com.google.javascript.jscomp.RewriteGoogJsImports;
import com.google.javascript.jscomp.RuntimeTypeCheck;
import com.google.javascript.jscomp.ScopedAliases;
import com.google.javascript.jscomp.StatementFusion;
import com.google.javascript.jscomp.StrictModeCheck;
import com.google.javascript.jscomp.StripCode;
import com.google.javascript.jscomp.SubstituteEs6Syntax;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.TypeCheck;
import com.google.javascript.jscomp.UnreachableCodeElimination;
import com.google.javascript.jscomp.VarCheck;
import com.google.javascript.jscomp.VariableMap;
import com.google.javascript.jscomp.VariableReferenceCheck;
import com.google.javascript.jscomp.VariableRenamingPolicy;
import com.google.javascript.jscomp.WhitespaceWrapGoogModules;
import com.google.javascript.jscomp.ijs.ConvertToTypedInterface;
import com.google.javascript.jscomp.lint.CheckArrayWithGoogObject;
import com.google.javascript.jscomp.lint.CheckDuplicateCase;
import com.google.javascript.jscomp.lint.CheckEmptyStatements;
import com.google.javascript.jscomp.lint.CheckEnums;
import com.google.javascript.jscomp.lint.CheckInterfaces;
import com.google.javascript.jscomp.lint.CheckJSDocStyle;
import com.google.javascript.jscomp.lint.CheckMissingSemicolon;
import com.google.javascript.jscomp.lint.CheckNullableReturn;
import com.google.javascript.jscomp.lint.CheckPrimitiveAsObject;
import com.google.javascript.jscomp.lint.CheckPrototypeProperties;
import com.google.javascript.jscomp.lint.CheckRedundantNullabilityModifier;
import com.google.javascript.jscomp.lint.CheckRequiresAndProvidesSorted;
import com.google.javascript.jscomp.lint.CheckUnusedLabels;
import com.google.javascript.jscomp.lint.CheckUselessBlocks;
import com.google.javascript.jscomp.parsing.ParserRunner;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class DefaultPassConfig
extends PassConfig {
    private static final String COMPILED_CONSTANT_NAME = "COMPILED";
    private static final String CLOSURE_LOCALE_CONSTANT_NAME = "goog.LOCALE";
    static final DiagnosticType CANNOT_USE_PROTOTYPE_AND_VAR = DiagnosticType.error("JSC_CANNOT_USE_PROTOTYPE_AND_VAR", "Rename prototypes and inline variables cannot be used together.");
    private static final Pattern GLOBAL_SYMBOL_NAMESPACE_PATTERN = Pattern.compile("^[a-zA-Z0-9$_]+$");
    private transient GlobalNamespace namespaceForChecks = null;
    private final transient PreprocessorSymbolTable.CachedInstanceFactory preprocessorSymbolTableFactory;
    private transient ClosureRewriteModule.GlobalRewriteState moduleRewriteState = null;
    private final boolean protectHiddenSideEffects;
    private final PassFactory.HotSwapPassFactory checkSideEffects = new PassFactory.HotSwapPassFactory("checkSideEffects"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new CheckSideEffects(compiler, DefaultPassConfig.this.options.checkSuspiciousCode, DefaultPassConfig.this.protectHiddenSideEffects);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory stripSideEffectProtection = new PassFactory("stripSideEffectProtection", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new CheckSideEffects.StripProtection(compiler);
        }

        @Override
        public FeatureSet featureSet() {
            return FeatureSet.latest();
        }
    };
    private final PassFactory.HotSwapPassFactory suspiciousCode = new PassFactory.HotSwapPassFactory("suspiciousCode"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            ArrayList<NodeTraversal.Callback> sharedCallbacks = new ArrayList<NodeTraversal.Callback>();
            if (DefaultPassConfig.this.options.checkSuspiciousCode) {
                sharedCallbacks.add(new CheckSuspiciousCode());
                sharedCallbacks.add(new CheckDuplicateCase(compiler));
            }
            if (DefaultPassConfig.this.options.enables(DiagnosticGroups.GLOBAL_THIS)) {
                sharedCallbacks.add(new CheckGlobalThis(compiler));
            }
            if (DefaultPassConfig.this.options.enables(DiagnosticGroups.DEBUGGER_STATEMENT_PRESENT)) {
                sharedCallbacks.add(new CheckDebuggerStatement(compiler));
            }
            return DefaultPassConfig.combineChecks(compiler, sharedCallbacks);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory.HotSwapPassFactory checkRequires = new PassFactory.HotSwapPassFactory("checkMissingAndExtraRequires"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new CheckMissingAndExtraRequires(compiler, CheckMissingAndExtraRequires.Mode.FULL_COMPILE);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory.HotSwapPassFactory checkProvides = new PassFactory.HotSwapPassFactory("checkProvides"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new CheckProvides(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private static final DiagnosticType GENERATE_EXPORTS_ERROR = DiagnosticType.error("JSC_GENERATE_EXPORTS_ERROR", "Exports can only be generated if export symbol/property functions are set.");
    private final PassFactory.HotSwapPassFactory checkJsDocAndEs6Modules = new PassFactory.HotSwapPassFactory("checkJsDocAndEs6Modules"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            ImmutableCollection.Builder callbacks = ((ImmutableList.Builder)ImmutableList.builder().add(new CheckJSDoc(compiler))).add(new Es6CheckModule(compiler));
            return DefaultPassConfig.combineChecks(compiler, (List)((Object)((ImmutableList.Builder)callbacks).build()));
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.latest();
        }
    };
    private final PassFactory generateExports = new PassFactory("generateExports", true){

        @Override
        protected CompilerPass create(final AbstractCompiler compiler) {
            CodingConvention convention = compiler.getCodingConvention();
            if (convention.getExportSymbolFunction() != null && convention.getExportPropertyFunction() != null) {
                final GenerateExports pass = new GenerateExports(compiler, DefaultPassConfig.this.options.exportLocalPropertyDefinitions, convention.getExportSymbolFunction(), convention.getExportPropertyFunction());
                return new CompilerPass(){

                    @Override
                    public void process(Node externs, Node root) {
                        pass.process(externs, root);
                        compiler.addExportedNames(pass.getExportedVariableNames());
                    }
                };
            }
            return new ErrorPass(compiler, GENERATE_EXPORTS_ERROR);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES2018;
        }
    };
    private final PassFactory generateIjs = new PassFactory("generateIjs", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new ConvertToTypedInterface(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory exportTestFunctions = new PassFactory("exportTestFunctions", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            CodingConvention convention = compiler.getCodingConvention();
            if (convention.getExportSymbolFunction() != null) {
                return new ExportTestFunctions(compiler, convention.getExportSymbolFunction(), convention.getExportPropertyFunction());
            }
            return new ErrorPass(compiler, GENERATE_EXPORTS_ERROR);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory gatherRawExports = new PassFactory("gatherRawExports", true){

        @Override
        protected CompilerPass create(final AbstractCompiler compiler) {
            final GatherRawExports pass = new GatherRawExports(compiler);
            return new CompilerPass(){

                @Override
                public void process(Node externs, Node root) {
                    pass.process(externs, root);
                    compiler.addExportedNames(pass.getExportedVariableNames());
                }
            };
        }

        @Override
        public FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory.HotSwapPassFactory closurePrimitives = new PassFactory.HotSwapPassFactory("closurePrimitives"){

        @Override
        protected HotSwapCompilerPass create(final AbstractCompiler compiler) {
            DefaultPassConfig.this.preprocessorSymbolTableFactory.maybeInitialize(compiler);
            final ProcessClosurePrimitives pass = new ProcessClosurePrimitives(compiler, DefaultPassConfig.this.preprocessorSymbolTableFactory.getInstanceOrNull(), DefaultPassConfig.this.options.brokenClosureRequiresLevel, DefaultPassConfig.this.options.shouldPreservesGoogProvidesAndRequires());
            return new HotSwapCompilerPass(){

                @Override
                public void process(Node externs, Node root) {
                    pass.process(externs, root);
                    compiler.addExportedNames(pass.getExportedVariableNames());
                }

                @Override
                public void hotSwapScript(Node scriptRoot, Node originalRoot) {
                    pass.hotSwapScript(scriptRoot, originalRoot);
                }
            };
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory.HotSwapPassFactory angularPass = new PassFactory.HotSwapPassFactory("angularPass"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new AngularPass(compiler);
        }

        @Override
        public FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory replaceMessages = new PassFactory("replaceMessages", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new ReplaceMessages(compiler, DefaultPassConfig.this.options.messageBundle, true, JsMessage.Style.CLOSURE, false);
        }

        @Override
        public FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory replaceMessagesForChrome = new PassFactory("replaceMessages", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new ReplaceMessagesForChrome(compiler, new GoogleJsMessageIdGenerator(DefaultPassConfig.this.options.tcProjectId), true, JsMessage.Style.CLOSURE);
        }

        @Override
        public FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory.HotSwapPassFactory closureGoogScopeAliases = new PassFactory.HotSwapPassFactory("closureGoogScopeAliases"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            DefaultPassConfig.this.preprocessorSymbolTableFactory.maybeInitialize(compiler);
            return new ScopedAliases(compiler, DefaultPassConfig.this.preprocessorSymbolTableFactory.getInstanceOrNull(), DefaultPassConfig.this.options.getAliasTransformationHandler());
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory injectRuntimeLibraries = new PassFactory("InjectRuntimeLibraries", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new InjectRuntimeLibraries(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    final PassFactory.HotSwapPassFactory convertEs6TypedToEs6 = new PassFactory.HotSwapPassFactory("convertEs6Typed"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new Es6TypedToEs6Converter(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.TYPESCRIPT;
        }
    };
    private final PassFactory convertStaticInheritance = new PassFactory("Es6StaticInheritance", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new Es6ToEs3ClassSideInheritance(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.TYPE_CHECK_SUPPORTED;
        }
    };
    private final PassFactory inlineTypeAliases = new PassFactory("inlineTypeAliases", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new InlineAliases(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory aggressiveInlineAliases = new PassFactory("aggressiveInlineAliases", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new AggressiveInlineAliases(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory declaredGlobalExternsOnWindow = new PassFactory("declaredGlobalExternsOnWindow", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new DeclaredGlobalExternsOnWindow(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory.HotSwapPassFactory closureRewriteClass = new PassFactory.HotSwapPassFactory("closureRewriteClass"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new ClosureRewriteClass(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory.HotSwapPassFactory closureCheckModule = new PassFactory.HotSwapPassFactory("closureCheckModule"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new ClosureCheckModule(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory.HotSwapPassFactory closureRewriteModule = new PassFactory.HotSwapPassFactory("closureRewriteModule"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            DefaultPassConfig.this.preprocessorSymbolTableFactory.maybeInitialize(compiler);
            DefaultPassConfig.this.maybeInitializeModuleRewriteState();
            return new ClosureRewriteModule(compiler, DefaultPassConfig.this.preprocessorSymbolTableFactory.getInstanceOrNull(), DefaultPassConfig.this.moduleRewriteState);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory.HotSwapPassFactory rewriteGoogJsImports = new PassFactory.HotSwapPassFactory("rewriteGoogJsImports"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new RewriteGoogJsImports(compiler, RewriteGoogJsImports.Mode.LINT_AND_REWRITE);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory closureCheckGetCssName = new PassFactory("closureCheckGetCssName", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new CheckMissingGetCssName(compiler, DefaultPassConfig.this.options.checkMissingGetCssNameLevel, DefaultPassConfig.this.options.checkMissingGetCssNameBlacklist);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory closureReplaceGetCssName = new PassFactory("closureReplaceGetCssName", true){

        @Override
        protected CompilerPass create(final AbstractCompiler compiler) {
            return new CompilerPass(){

                @Override
                public void process(Node externs, Node jsRoot) {
                    HashMap<String, Integer> newCssNames = null;
                    if (DefaultPassConfig.this.options.gatherCssNames) {
                        newCssNames = new HashMap<String, Integer>();
                    }
                    ReplaceCssNames pass = new ReplaceCssNames(compiler, newCssNames, DefaultPassConfig.this.options.cssRenamingWhitelist);
                    pass.process(externs, jsRoot);
                    compiler.setCssNames(newCssNames);
                }
            };
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory createSyntheticBlocks = new PassFactory("createSyntheticBlocks", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new CreateSyntheticBlocks(compiler, DefaultPassConfig.this.options.syntheticBlockStartMarker, DefaultPassConfig.this.options.syntheticBlockEndMarker);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory earlyPeepholeOptimizations = new PassFactory("earlyPeepholeOptimizations", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            ArrayList<AbstractPeepholeOptimization> peepholeOptimizations = new ArrayList<AbstractPeepholeOptimization>();
            peepholeOptimizations.add(new PeepholeRemoveDeadCode());
            if (compiler.getOptions().j2clPassMode.shouldAddJ2clPasses()) {
                peepholeOptimizations.add(new J2clEqualitySameRewriterPass());
            }
            return new PeepholeOptimizationsPass(compiler, this.getName(), peepholeOptimizations);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory earlyInlineVariables = new PassFactory("earlyInlineVariables", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            InlineVariables.Mode mode;
            if (DefaultPassConfig.this.options.inlineVariables) {
                mode = InlineVariables.Mode.ALL;
            } else if (DefaultPassConfig.this.options.inlineLocalVariables) {
                mode = InlineVariables.Mode.LOCALS_ONLY;
            } else {
                throw new IllegalStateException("No variable inlining option set.");
            }
            return new InlineVariables(compiler, mode, true);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory peepholeOptimizations = new PassFactory("peepholeOptimizations", false){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return DefaultPassConfig.createPeepholeOptimizationsPass(compiler, this.getName());
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory peepholeOptimizationsOnce = new PassFactory("peepholeOptimizations", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return DefaultPassConfig.createPeepholeOptimizationsPass(compiler, this.getName());
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory latePeepholeOptimizations = new PassFactory("latePeepholeOptimizations", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            boolean late = true;
            boolean useTypesForOptimization = DefaultPassConfig.this.options.useTypesForLocalOptimization;
            return new PeepholeOptimizationsPass(compiler, this.getName(), new StatementFusion(DefaultPassConfig.this.options.aggressiveFusion), new PeepholeRemoveDeadCode(), new PeepholeMinimizeConditions(true), new PeepholeSubstituteAlternateSyntax(true), new PeepholeReplaceKnownMethods(true, useTypesForOptimization), new PeepholeFoldConstants(true, useTypesForOptimization), new PeepholeReorderConstantExpression());
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory.HotSwapPassFactory checkVars = new PassFactory.HotSwapPassFactory("checkVars"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new VarCheck(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory inferConsts = new PassFactory("inferConsts", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new InferConsts(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory checkRegExp = new PassFactory("checkRegExp", true){

        @Override
        protected CompilerPass create(final AbstractCompiler compiler) {
            final CheckRegExp pass = new CheckRegExp(compiler);
            return new CompilerPass(){

                @Override
                public void process(Node externs, Node root) {
                    pass.process(externs, root);
                    compiler.setHasRegExpGlobalReferences(pass.isGlobalRegExpPropertiesUsed());
                }
            };
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory.HotSwapPassFactory checkVariableReferencesForTranspileOnly = new PassFactory.HotSwapPassFactory("checkVariableReferences"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new VariableReferenceCheck(compiler, true);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory.HotSwapPassFactory checkVariableReferences = new PassFactory.HotSwapPassFactory("checkVariableReferences"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new VariableReferenceCheck(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory.HotSwapPassFactory checkSuper = new PassFactory.HotSwapPassFactory("checkSuper"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new CheckSuper(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory objectPropertyStringPreprocess = new PassFactory("ObjectPropertyStringPreprocess", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new ObjectPropertyStringPreprocess(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    final PassFactory.HotSwapPassFactory resolveTypes = new PassFactory.HotSwapPassFactory("resolveTypes"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new GlobalTypeResolver(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.TYPE_CHECK_SUPPORTED;
        }
    };
    private final PassFactory clearTypedScopePass = new PassFactory("clearTypedScopePass", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new ClearTypedScope();
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.latest();
        }
    };
    final PassFactory.HotSwapPassFactory inferTypes = new PassFactory.HotSwapPassFactory("inferTypes"){

        @Override
        protected HotSwapCompilerPass create(final AbstractCompiler compiler) {
            return new HotSwapCompilerPass(){

                @Override
                public void process(Node externs, Node root) {
                    Preconditions.checkNotNull(DefaultPassConfig.this.topScope);
                    Preconditions.checkNotNull(DefaultPassConfig.this.getTypedScopeCreator());
                    DefaultPassConfig.this.makeTypeInference(compiler).process(externs, root);
                }

                @Override
                public void hotSwapScript(Node scriptRoot, Node originalRoot) {
                    DefaultPassConfig.this.makeTypeInference(compiler).inferAllScopes(scriptRoot);
                }
            };
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.TYPE_CHECK_SUPPORTED;
        }
    };
    private final PassFactory.HotSwapPassFactory inferJsDocInfo = new PassFactory.HotSwapPassFactory("inferJsDocInfo"){

        @Override
        protected HotSwapCompilerPass create(final AbstractCompiler compiler) {
            return new HotSwapCompilerPass(){

                @Override
                public void process(Node externs, Node root) {
                    Preconditions.checkNotNull(DefaultPassConfig.this.topScope);
                    Preconditions.checkNotNull(DefaultPassConfig.this.getTypedScopeCreator());
                    PassConfig.makeInferJsDocInfo(compiler).process(externs, root);
                }

                @Override
                public void hotSwapScript(Node scriptRoot, Node originalRoot) {
                    PassConfig.makeInferJsDocInfo(compiler).hotSwapScript(scriptRoot, originalRoot);
                }
            };
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.TYPE_CHECK_SUPPORTED;
        }
    };
    private final PassFactory.HotSwapPassFactory checkTypes = new PassFactory.HotSwapPassFactory("checkTypes"){

        @Override
        protected HotSwapCompilerPass create(final AbstractCompiler compiler) {
            return new HotSwapCompilerPass(){

                @Override
                public void process(Node externs, Node root) {
                    Preconditions.checkNotNull(DefaultPassConfig.this.topScope);
                    Preconditions.checkNotNull(DefaultPassConfig.this.getTypedScopeCreator());
                    TypeCheck check = DefaultPassConfig.this.makeTypeCheck(compiler);
                    check.process(externs, root);
                    compiler.getErrorManager().setTypedPercent(check.getTypedPercent());
                }

                @Override
                public void hotSwapScript(Node scriptRoot, Node originalRoot) {
                    DefaultPassConfig.this.makeTypeCheck(compiler).check(scriptRoot, false);
                }
            };
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.TYPE_CHECK_SUPPORTED;
        }
    };
    private final PassFactory.HotSwapPassFactory checkControlFlow = new PassFactory.HotSwapPassFactory("checkControlFlow"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            ArrayList<NodeTraversal.ScopedCallback> callbacks = new ArrayList<NodeTraversal.ScopedCallback>();
            if (!DefaultPassConfig.this.options.disables(DiagnosticGroups.CHECK_USELESS_CODE)) {
                callbacks.add(new CheckUnreachableCode(compiler));
            }
            if (!DefaultPassConfig.this.options.disables(DiagnosticGroups.MISSING_RETURN)) {
                callbacks.add(new CheckMissingReturn(compiler));
            }
            return DefaultPassConfig.combineChecks(compiler, callbacks);
        }

        @Override
        public FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory.HotSwapPassFactory checkAccessControls = new PassFactory.HotSwapPassFactory("checkAccessControls"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new CheckAccessControls(compiler, DefaultPassConfig.this.options.enforceAccessControlCodingConventions);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.TYPE_CHECK_SUPPORTED;
        }
    };
    private final PassFactory.HotSwapPassFactory lintChecks = new PassFactory.HotSwapPassFactory("lintChecks"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            ImmutableCollection.Builder callbacks = ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(new CheckEmptyStatements(compiler))).add(new CheckEnums(compiler))).add(new CheckInterfaces(compiler))).add(new CheckJSDocStyle(compiler))).add(new CheckMissingSemicolon(compiler))).add(new CheckPrimitiveAsObject(compiler))).add(new CheckPrototypeProperties(compiler))).add(new CheckRedundantNullabilityModifier(compiler))).add(new CheckUnusedLabels(compiler))).add(new CheckUselessBlocks(compiler));
            return DefaultPassConfig.combineChecks(compiler, (List)((Object)((ImmutableList.Builder)callbacks).build()));
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory.HotSwapPassFactory analyzerChecks = new PassFactory.HotSwapPassFactory("analyzerChecks"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            ImmutableList.Builder callbacks = ImmutableList.builder();
            if (DefaultPassConfig.this.options.enables(DiagnosticGroups.ANALYZER_CHECKS_INTERNAL)) {
                ((ImmutableList.Builder)((ImmutableList.Builder)callbacks.add(new CheckNullableReturn(compiler))).add(new CheckArrayWithGoogObject(compiler))).add(new ImplicitNullabilityCheck(compiler));
            }
            if (DefaultPassConfig.this.options.enables(DiagnosticGroups.UNUSED_PRIVATE_PROPERTY)) {
                callbacks.add(new CheckUnusedPrivateProperties(compiler));
            }
            if (DefaultPassConfig.this.options.enables(DiagnosticGroups.MISSING_CONST_PROPERTY)) {
                callbacks.add(new CheckConstPrivateProperties(compiler));
            }
            return DefaultPassConfig.combineChecks(compiler, (List)((Object)callbacks.build()));
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.TYPE_CHECK_SUPPORTED;
        }
    };
    private final PassFactory.HotSwapPassFactory checkRequiresAndProvidesSorted = new PassFactory.HotSwapPassFactory("checkRequiresAndProvidesSorted"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new CheckRequiresAndProvidesSorted(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory checkGlobalNames = new PassFactory("checkGlobalNames", true){

        @Override
        protected CompilerPass create(final AbstractCompiler compiler) {
            return new CompilerPass(){

                @Override
                public void process(Node externs, Node jsRoot) {
                    DefaultPassConfig.this.namespaceForChecks = new GlobalNamespace(compiler, externs, jsRoot);
                    new CheckGlobalNames(compiler, DefaultPassConfig.this.options.checkGlobalNamesLevel).injectNamespace(DefaultPassConfig.this.namespaceForChecks).process(externs, jsRoot);
                }
            };
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.TYPE_CHECK_SUPPORTED;
        }
    };
    private final PassFactory checkStrictMode = new PassFactory("checkStrictMode", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new StrictModeCheck(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory processTweaks = new PassFactory("processTweaks", true){

        @Override
        protected CompilerPass create(final AbstractCompiler compiler) {
            return new CompilerPass(){

                @Override
                public void process(Node externs, Node jsRoot) {
                    new ProcessTweaks(compiler, DefaultPassConfig.this.options.getTweakProcessing().shouldStrip(), DefaultPassConfig.this.options.getTweakReplacements()).process(externs, jsRoot);
                }
            };
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.TYPE_CHECK_SUPPORTED;
        }
    };
    private final PassFactory processDefines = new PassFactory("processDefines", true){

        @Override
        protected CompilerPass create(final AbstractCompiler compiler) {
            return new CompilerPass(){

                @Override
                public void process(Node externs, Node jsRoot) {
                    HashMap<String, Node> replacements = new HashMap<String, Node>();
                    replacements.putAll(compiler.getDefaultDefineValues());
                    replacements.putAll(DefaultPassConfig.getAdditionalReplacements(DefaultPassConfig.this.options));
                    replacements.putAll(DefaultPassConfig.this.options.getDefineReplacements());
                    new ProcessDefines(compiler, ImmutableMap.copyOf(replacements), !DefaultPassConfig.this.options.checksOnly).injectNamespace(DefaultPassConfig.this.namespaceForChecks).process(externs, jsRoot);
                }
            };
        }

        @Override
        public FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory stripCode = new PassFactory("stripCode", true){

        @Override
        protected CompilerPass create(final AbstractCompiler compiler) {
            return new CompilerPass(){

                @Override
                public void process(Node externs, Node jsRoot) {
                    CompilerOptions options = compiler.getOptions();
                    StripCode pass = new StripCode(compiler, options.stripTypes, options.stripNameSuffixes, options.stripTypePrefixes, options.stripNamePrefixes);
                    if (options.getTweakProcessing().shouldStrip()) {
                        pass.enableTweakStripping();
                    }
                    pass.process(externs, jsRoot);
                }
            };
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    final PassFactory garbageCollectChecks = new PassFactory.HotSwapPassFactory("garbageCollectChecks"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new HotSwapCompilerPass(){

                @Override
                public void process(Node externs, Node jsRoot) {
                    DefaultPassConfig.this.namespaceForChecks = null;
                }

                @Override
                public void hotSwapScript(Node scriptRoot, Node originalRoot) {
                    this.process(null, null);
                }
            };
        }

        @Override
        public FeatureSet featureSet() {
            return FeatureSet.latest();
        }
    };
    private final PassFactory checkConsts = new PassFactory("checkConsts", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new ConstCheck(compiler);
        }

        @Override
        public FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory checkConstParams = new PassFactory("checkConstParams", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new ConstParamCheck(compiler);
        }

        @Override
        public FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory computeFunctionNames = new PassFactory("computeFunctionNames", true){

        @Override
        protected CompilerPass create(final AbstractCompiler compiler) {
            return new CompilerPass(){

                @Override
                public void process(Node externs, Node root) {
                    CollectFunctionNames pass = new CollectFunctionNames(compiler);
                    pass.process(externs, root);
                    compiler.setFunctionNames(pass.getFunctionNames());
                }
            };
        }

        @Override
        public FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory runtimeTypeCheck = new PassFactory("runtimeTypeCheck", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new RuntimeTypeCheck(compiler, DefaultPassConfig.this.options.runtimeTypeCheckLogFunction);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES5;
        }
    };
    private final PassFactory replaceIdGenerators = new PassFactory("replaceIdGenerators", true){

        @Override
        protected CompilerPass create(final AbstractCompiler compiler) {
            return new CompilerPass(){

                @Override
                public void process(Node externs, Node root) {
                    ReplaceIdGenerators pass = new ReplaceIdGenerators(compiler, DefaultPassConfig.this.options.idGenerators, DefaultPassConfig.this.options.generatePseudoNames, DefaultPassConfig.this.options.idGeneratorsMapSerialized, DefaultPassConfig.this.options.xidHashFunction);
                    pass.process(externs, root);
                    compiler.setIdGeneratorMap(pass.getSerializedIdMappings());
                }
            };
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory replaceStrings = new PassFactory("replaceStrings", true){

        @Override
        protected CompilerPass create(final AbstractCompiler compiler) {
            return new CompilerPass(){

                @Override
                public void process(Node externs, Node root) {
                    ReplaceStrings pass = new ReplaceStrings(compiler, DefaultPassConfig.this.options.replaceStringsPlaceholderToken, DefaultPassConfig.this.options.replaceStringsFunctionDescriptions, DefaultPassConfig.this.options.replaceStringsReservedStrings, DefaultPassConfig.this.options.replaceStringsInputMap);
                    pass.process(externs, root);
                    compiler.setStringMap(pass.getStringMap());
                }
            };
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES5;
        }
    };
    private final PassFactory optimizeArgumentsArray = new PassFactory("optimizeArgumentsArray", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new OptimizeArgumentsArray(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory closureCodeRemoval = new PassFactory("closureCodeRemoval", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new ClosureCodeRemoval(compiler, DefaultPassConfig.this.options.removeAbstractMethods, DefaultPassConfig.this.options.removeClosureAsserts);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory closureOptimizePrimitives = new PassFactory("closureOptimizePrimitives", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new ClosureOptimizePrimitives(compiler, compiler.getOptions().propertyRenaming == PropertyRenamingPolicy.ALL_UNQUOTED, compiler.getOptions().getOutputFeatureSet().contains(FeatureSet.ES6));
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory rescopeGlobalSymbols = new PassFactory("rescopeGlobalSymbols", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new RescopeGlobalSymbols(compiler, DefaultPassConfig.this.options.renamePrefixNamespace, DefaultPassConfig.this.options.renamePrefixNamespaceAssumeCrossChunkNames);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory collapseProperties = new PassFactory("collapseProperties", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new CollapseProperties(compiler, DefaultPassConfig.this.options.getPropertyCollapseLevel());
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory collapseObjectLiterals = new PassFactory("collapseObjectLiterals", false){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new InlineObjectLiterals(compiler, compiler.getUniqueNameIdSupplier());
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory disambiguatePrivateProperties = new PassFactory("disambiguatePrivateProperties", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new DisambiguatePrivateProperties(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory disambiguateProperties = new PassFactory("disambiguateProperties", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new DisambiguateProperties(compiler, DefaultPassConfig.this.options.propertyInvalidationErrors);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES5;
        }
    };
    private final PassFactory devirtualizePrototypeMethods = new PassFactory("devirtualizePrototypeMethods", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new DevirtualizePrototypeMethods(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES5;
        }
    };
    private final PassFactory optimizeCalls = new PassFactory("optimizeCalls", false){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            OptimizeCalls passes = new OptimizeCalls(compiler);
            passes.addPass(new OptimizeReturns(compiler));
            passes.addPass(new OptimizeParameters(compiler));
            return passes;
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory markPureFunctions = new PassFactory("markPureFunctions", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new PureFunctionIdentifier.Driver(compiler, DefaultPassConfig.this.options.debugFunctionSideEffectsPath);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory markNoSideEffectCalls = new PassFactory("markNoSideEffectCalls", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new MarkNoSideEffectCalls(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES5;
        }
    };
    private final PassFactory inlineVariables = new PassFactory("inlineVariables", false){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            InlineVariables.Mode mode;
            if (DefaultPassConfig.this.options.inlineVariables) {
                mode = InlineVariables.Mode.ALL;
            } else if (DefaultPassConfig.this.options.inlineLocalVariables) {
                mode = InlineVariables.Mode.LOCALS_ONLY;
            } else {
                throw new IllegalStateException("No variable inlining option set.");
            }
            return new InlineVariables(compiler, mode, true);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory inlineConstants = new PassFactory("inlineConstants", false){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new InlineVariables(compiler, InlineVariables.Mode.CONSTANTS_ONLY, true);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory removeUnreachableCode = new PassFactory("removeUnreachableCode", false){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new UnreachableCodeElimination(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8;
        }
    };
    private final PassFactory removeUnusedPolyfills = new PassFactory("removeUnusedPolyfills", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new RemoveUnusedPolyfills(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory inlineSimpleMethods = new PassFactory("inlineSimpleMethods", false){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new InlineSimpleMethods(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory deadAssignmentsElimination = new PassFactory("deadAssignmentsElimination", false){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new DeadAssignmentsElimination(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory deadPropertyAssignmentElimination = new PassFactory("deadPropertyAssignmentElimination", false){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new DeadPropertyAssignmentElimination(compiler);
        }

        @Override
        public FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory inlineFunctions = new PassFactory("inlineFunctions", false){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new InlineFunctions(compiler, compiler.getUniqueNameIdSupplier(), DefaultPassConfig.this.options.getInlineFunctionsLevel(), DefaultPassConfig.this.options.assumeStrictThis() || DefaultPassConfig.this.options.expectStrictModeInput(), DefaultPassConfig.this.options.assumeClosuresOnlyCaptureReferences, DefaultPassConfig.this.options.maxFunctionSizeAfterInlining);
        }

        @Override
        public FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory inlineProperties = new PassFactory("inlineProperties", false){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new InlineProperties(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES5;
        }
    };
    private final PassFactory removeUnusedCodeOnce = this.getRemoveUnusedCode(true);
    private final PassFactory removeUnusedCode = this.getRemoveUnusedCode(false);
    private final PassFactory crossModuleCodeMotion = new PassFactory("crossModuleCodeMotion", false){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new CrossModuleCodeMotion(compiler, compiler.getModuleGraph(), DefaultPassConfig.this.options.parentChunkCanSeeSymbolsDeclaredInChildren);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory crossModuleMethodMotion = new PassFactory("crossModuleMethodMotion", false){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new CrossModuleMethodMotion(compiler, compiler.getCrossModuleIdGenerator(), DefaultPassConfig.this.options.removeUnusedPrototypePropertiesInExterns, DefaultPassConfig.this.options.crossChunkCodeMotionNoStubMethods);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory flowSensitiveInlineVariables = new PassFactory("flowSensitiveInlineVariables", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new FlowSensitiveInlineVariables(compiler);
        }

        @Override
        public FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory coalesceVariableNames = new PassFactory("coalesceVariableNames", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new CoalesceVariableNames(compiler, DefaultPassConfig.this.options.generatePseudoNames);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory exploitAssign = new PassFactory("exploitAssign", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new PeepholeOptimizationsPass(compiler, this.getName(), new ExploitAssigns());
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory collapseVariableDeclarations = new PassFactory("collapseVariableDeclarations", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new CollapseVariableDeclarations(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory extractPrototypeMemberDeclarations = new PassFactory("extractPrototypeMemberDeclarations", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            ExtractPrototypeMemberDeclarations.Pattern pattern;
            switch (DefaultPassConfig.this.options.extractPrototypeMemberDeclarations) {
                case USE_GLOBAL_TEMP: {
                    pattern = ExtractPrototypeMemberDeclarations.Pattern.USE_GLOBAL_TEMP;
                    break;
                }
                case USE_IIFE: {
                    pattern = ExtractPrototypeMemberDeclarations.Pattern.USE_IIFE;
                    break;
                }
                default: {
                    throw new IllegalStateException("unexpected");
                }
            }
            return new ExtractPrototypeMemberDeclarations(compiler, pattern);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8;
        }
    };
    private final PassFactory rewriteFunctionExpressions = new PassFactory("rewriteFunctionExpressions", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new FunctionRewriter(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.latest();
        }
    };
    private final PassFactory collapseAnonymousFunctions = new PassFactory("collapseAnonymousFunctions", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new CollapseAnonymousFunctions(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory moveFunctionDeclarations = new PassFactory("moveFunctionDeclarations", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new MoveFunctionDeclarations(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8;
        }
    };
    private final PassFactory nameUnmappedAnonymousFunctions = new PassFactory("nameAnonymousFunctions", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new NameAnonymousFunctions(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory nameMappedAnonymousFunctions = new PassFactory("nameAnonymousFunctions", true){

        @Override
        protected CompilerPass create(final AbstractCompiler compiler) {
            return new CompilerPass(){

                @Override
                public void process(Node externs, Node root) {
                    NameAnonymousFunctionsMapped naf = new NameAnonymousFunctionsMapped(compiler, DefaultPassConfig.this.options.inputAnonymousFunctionNamingMap);
                    naf.process(externs, root);
                    compiler.setAnonymousFunctionNameMap(naf.getFunctionMap());
                }
            };
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory aliasStrings = new PassFactory("aliasStrings", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new AliasStrings(compiler, compiler.getModuleGraph(), DefaultPassConfig.this.options.aliasAllStrings ? null : DefaultPassConfig.this.options.aliasableStrings, DefaultPassConfig.this.options.aliasStringsBlacklist, DefaultPassConfig.this.options.outputJsStringUsage);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory objectPropertyStringPostprocess = new PassFactory("ObjectPropertyStringPostprocess", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new ObjectPropertyStringPostprocess(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES5;
        }
    };
    private final PassFactory ambiguateProperties = new PassFactory("ambiguateProperties", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new AmbiguateProperties(compiler, DefaultPassConfig.this.options.getPropertyReservedNamingFirstChars(), DefaultPassConfig.this.options.getPropertyReservedNamingNonFirstChars());
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES5;
        }
    };
    private final PassFactory markUnnormalized = new PassFactory("markUnnormalized", true){

        @Override
        protected CompilerPass create(final AbstractCompiler compiler) {
            return new CompilerPass(){

                @Override
                public void process(Node externs, Node root) {
                    compiler.setLifeCycleStage(AbstractCompiler.LifeCycleStage.RAW);
                }
            };
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.latest();
        }
    };
    private final PassFactory normalize = new PassFactory("normalize", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new Normalize(compiler, false);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory externExports = new PassFactory("externExports", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new ExternExportsPass(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES5;
        }
    };
    private final PassFactory denormalize = new PassFactory("denormalize", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new Denormalize(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory invertContextualRenaming = new PassFactory("invertContextualRenaming", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return MakeDeclaredNamesUnique.getContextualRenameInverter(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory renameProperties = new PassFactory("renameProperties", true){

        @Override
        protected CompilerPass create(final AbstractCompiler compiler) {
            Preconditions.checkState(DefaultPassConfig.this.options.propertyRenaming == PropertyRenamingPolicy.ALL_UNQUOTED);
            final VariableMap prevPropertyMap = DefaultPassConfig.this.options.inputPropertyMap;
            return new CompilerPass(){

                @Override
                public void process(Node externs, Node root) {
                    RenameProperties rprop = new RenameProperties(compiler, DefaultPassConfig.this.options.generatePseudoNames, prevPropertyMap, DefaultPassConfig.this.options.getPropertyReservedNamingFirstChars(), DefaultPassConfig.this.options.getPropertyReservedNamingNonFirstChars(), DefaultPassConfig.this.options.nameGenerator);
                    rprop.process(externs, root);
                    compiler.setPropertyMap(rprop.getPropertyMap());
                }
            };
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory renameVars = new PassFactory("renameVars", true){

        @Override
        protected CompilerPass create(final AbstractCompiler compiler) {
            final VariableMap prevVariableMap = DefaultPassConfig.this.options.inputVariableMap;
            return new CompilerPass(){

                @Override
                public void process(Node externs, Node root) {
                    compiler.setVariableMap(DefaultPassConfig.this.runVariableRenaming(compiler, prevVariableMap, externs, root));
                }
            };
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory renameLabels = new PassFactory("renameLabels", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new RenameLabels(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory convertToDottedProperties = new PassFactory("convertToDottedProperties", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new ConvertToDottedProperties(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory checkAstValidity = new PassFactory("checkAstValidity", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new AstValidator(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.latest();
        }
    };
    private final PassFactory varCheckValidity = new PassFactory("varCheckValidity", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new VarCheck(compiler, true);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory instrumentFunctions = new PassFactory("instrumentFunctions", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new InstrumentFunctions(compiler, compiler.getFunctionNames(), DefaultPassConfig.this.options.instrumentationTemplate, DefaultPassConfig.this.options.appNameStr);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES5;
        }
    };
    private final PassFactory instrumentForCodeCoverage = new PassFactory("instrumentForCodeCoverage", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            if (DefaultPassConfig.this.options.instrumentBranchCoverage) {
                return new CoverageInstrumentationPass(compiler, CoverageInstrumentationPass.CoverageReach.CONDITIONAL, CoverageInstrumentationPass.InstrumentOption.BRANCH_ONLY);
            }
            return new CoverageInstrumentationPass(compiler, CoverageInstrumentationPass.CoverageReach.CONDITIONAL);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES5;
        }
    };
    private final PassFactory gatherExternProperties = new PassFactory("gatherExternProperties", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new GatherExternProperties(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory.HotSwapPassFactory polymerPass = new PassFactory.HotSwapPassFactory("polymerPass"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new PolymerPass(compiler, compiler.getOptions().polymerVersion, compiler.getOptions().propertyRenaming == PropertyRenamingPolicy.ALL_UNQUOTED);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory chromePass = new PassFactory("chromePass", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new ChromePass(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory.HotSwapPassFactory dartSuperAccessorsPass = new PassFactory.HotSwapPassFactory("dartSuperAccessorsPass"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new DartSuperAccessorsPass(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory j2clConstantHoisterPass = new PassFactory("j2clConstantHoisterPass", false){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new J2clConstantHoisterPass(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory j2clClinitPass = new PassFactory("j2clClinitPass", false){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            List<Node> changedScopeNodes = compiler.getChangedScopeNodesForPass(this.getName());
            return new J2clClinitPrunerPass(compiler, changedScopeNodes);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory j2clPropertyInlinerPass = new PassFactory("j2clES6Pass", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new J2clPropertyInlinerPass(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory j2clPass = new PassFactory("j2clPass", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new J2clPass(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory j2clUtilGetDefineRewriterPass = new PassFactory("j2clUtilGetDefineRewriterPass", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new J2clUtilGetDefineRewriterPass(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory j2clAssertRemovalPass = new PassFactory("j2clAssertRemovalPass", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new J2clAssertRemovalPass(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory j2clSourceFileChecker = new PassFactory("j2clSourceFileChecker", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new J2clSourceFileChecker(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.latest();
        }
    };
    private final PassFactory j2clChecksPass = new PassFactory("j2clChecksPass", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new J2clChecksPass(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory checkConformance = new PassFactory("checkConformance", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new CheckConformance(compiler, ImmutableList.copyOf(DefaultPassConfig.this.options.getConformanceConfigs()));
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.TYPE_CHECK_SUPPORTED;
        }
    };
    private final PassFactory optimizeToEs6 = new PassFactory("optimizeToEs6", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new SubstituteEs6Syntax(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory.HotSwapPassFactory whitespaceWrapGoogModules = new PassFactory.HotSwapPassFactory("whitespaceWrapGoogModules"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new WhitespaceWrapGoogModules(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private final PassFactory removeSuperMethodsPass = new PassFactory("removeSuperMethods", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new RemoveSuperMethodsPass(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES5;
        }
    };
    private final PassFactory rewriteCommonJsModules = new PassFactory("rewriteCommonJsModules", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new ProcessCommonJSModules(compiler);
        }

        @Override
        public FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private final PassFactory rewriteScriptsToEs6Modules = new PassFactory("rewriteScriptsToEs6Modules", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new Es6RewriteScriptsToModules(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };

    public DefaultPassConfig(CompilerOptions options) {
        super(options);
        this.protectHiddenSideEffects = options != null && options.shouldProtectHiddenSideEffects();
        this.preprocessorSymbolTableFactory = new PreprocessorSymbolTable.CachedInstanceFactory();
    }

    GlobalNamespace getGlobalNamespace() {
        return this.namespaceForChecks;
    }

    @Nullable
    PreprocessorSymbolTable getPreprocessorSymbolTable() {
        return this.preprocessorSymbolTableFactory.getInstanceOrNull();
    }

    void maybeInitializeModuleRewriteState() {
        if (this.options.allowsHotswapReplaceScript() && this.moduleRewriteState == null) {
            this.moduleRewriteState = new ClosureRewriteModule.GlobalRewriteState();
        }
    }

    @Override
    protected List<PassFactory> getTranspileOnlyPasses() {
        ArrayList<PassFactory> passes = new ArrayList<PassFactory>();
        if (this.options.needsTranspilationFrom(FeatureSet.TYPESCRIPT)) {
            passes.add(this.convertEs6TypedToEs6);
        }
        if (this.options.getLanguageIn().toFeatureSet().has(FeatureSet.Feature.MODULES)) {
            passes.add(this.rewriteGoogJsImports);
            switch (this.options.getEs6ModuleTranspilation()) {
                case COMPILE: {
                    TranspilationPasses.addEs6ModulePass(passes, this.preprocessorSymbolTableFactory);
                    break;
                }
                case TO_COMMON_JS_LIKE_MODULES: {
                    TranspilationPasses.addEs6ModuleToCjsPass(passes);
                    break;
                }
                case RELATIVIZE_IMPORT_PATHS: {
                    TranspilationPasses.addEs6RewriteImportPathPass(passes);
                    break;
                }
            }
        }
        passes.add(this.checkSuper);
        passes.add(this.checkVariableReferencesForTranspileOnly);
        if (this.options.dartPass && this.options.needsTranspilationFrom(FeatureSet.ES6)) {
            passes.add(this.dartSuperAccessorsPass);
        }
        TranspilationPasses.addPreTypecheckTranspilationPasses(passes, this.options);
        TranspilationPasses.addPostCheckTranspilationPasses(passes, this.options);
        if (this.options.needsTranspilationFrom(FeatureSet.ES6) && this.options.rewritePolyfills) {
            TranspilationPasses.addRewritePolyfillPass(passes);
        }
        passes.add(this.injectRuntimeLibraries);
        DefaultPassConfig.assertAllOneTimePasses(passes);
        this.assertValidOrderForChecks(passes);
        return passes;
    }

    @Override
    protected List<PassFactory> getWhitespaceOnlyPasses() {
        ArrayList<PassFactory> passes = new ArrayList<PassFactory>();
        if (this.options.processCommonJSModules) {
            passes.add(this.rewriteCommonJsModules);
        } else if (this.options.getLanguageIn().toFeatureSet().has(FeatureSet.Feature.MODULES)) {
            passes.add(this.rewriteScriptsToEs6Modules);
        }
        if (this.options.wrapGoogModulesForWhitespaceOnly) {
            passes.add(this.whitespaceWrapGoogModules);
        }
        return passes;
    }

    private void addTypeCheckerPasses(List<PassFactory> checks, CompilerOptions options) {
        if (!options.allowsHotswapReplaceScript()) {
            checks.add(this.inlineTypeAliases);
        }
        if (options.checkTypes || options.inferTypes) {
            checks.add(this.resolveTypes);
            checks.add(this.inferTypes);
            if (options.checkTypes) {
                checks.add(this.checkTypes);
            } else {
                checks.add(this.inferJsDocInfo);
            }
            if (!options.preservesDetailedSourceInfo() && !options.allowsHotswapReplaceScript()) {
                checks.add(this.clearTypedScopePass);
            }
        }
    }

    @Override
    protected List<PassFactory> getChecks() {
        ArrayList<PassFactory> checks = new ArrayList<PassFactory>();
        if (this.options.shouldGenerateTypedExterns()) {
            checks.add(this.closureGoogScopeAliases);
            checks.add(this.closureRewriteClass);
            checks.add(this.generateIjs);
            checks.add(this.whitespaceWrapGoogModules);
            return checks;
        }
        checks.add(PassFactory.createEmptyPass("beforeStandardChecks"));
        if (this.options.processCommonJSModules) {
            checks.add(this.rewriteCommonJsModules);
        } else if (this.options.getLanguageIn().toFeatureSet().has(FeatureSet.Feature.MODULES)) {
            checks.add(this.rewriteScriptsToEs6Modules);
        }
        if (this.options.isChromePassEnabled()) {
            checks.add(this.chromePass);
        }
        checks.add(this.checkJsDocAndEs6Modules);
        if (this.options.needsTranspilationFrom(FeatureSet.TYPESCRIPT)) {
            checks.add(this.convertEs6TypedToEs6);
        }
        if (this.options.enables(DiagnosticGroups.LINT_CHECKS)) {
            checks.add(this.lintChecks);
        }
        if (this.options.closurePass && this.options.enables(DiagnosticGroups.LINT_CHECKS)) {
            checks.add(this.checkRequiresAndProvidesSorted);
        }
        if (this.options.enables(DiagnosticGroups.MISSING_REQUIRE) || this.options.enables(DiagnosticGroups.STRICT_MISSING_REQUIRE) || this.options.enables(DiagnosticGroups.EXTRA_REQUIRE)) {
            checks.add(this.checkRequires);
        }
        if (this.options.getLanguageIn().toFeatureSet().has(FeatureSet.Feature.MODULES)) {
            checks.add(this.rewriteGoogJsImports);
            TranspilationPasses.addEs6ModulePass(checks, this.preprocessorSymbolTableFactory);
        }
        checks.add(this.checkVariableReferences);
        checks.add(this.checkStrictMode);
        if (this.options.closurePass) {
            checks.add(this.closureCheckModule);
            checks.add(this.closureRewriteModule);
        }
        if (this.options.declaredGlobalExternsOnWindow) {
            checks.add(this.declaredGlobalExternsOnWindow);
        }
        checks.add(this.checkSuper);
        if (this.options.closurePass) {
            checks.add(this.closureGoogScopeAliases);
            checks.add(this.closureRewriteClass);
        }
        checks.add(this.checkSideEffects);
        if (this.options.enables(DiagnosticGroups.MISSING_PROVIDE)) {
            checks.add(this.checkProvides);
        }
        if (this.options.angularPass) {
            checks.add(this.angularPass);
        }
        if (!this.options.generateExportsAfterTypeChecking && this.options.generateExports) {
            checks.add(this.generateExports);
        }
        if (this.options.exportTestFunctions) {
            checks.add(this.exportTestFunctions);
        }
        if (this.options.closurePass) {
            checks.add(this.closurePrimitives);
        }
        if (this.options.polymerVersion != null) {
            checks.add(this.polymerPass);
        }
        if (this.options.checkSuspiciousCode || this.options.enables(DiagnosticGroups.GLOBAL_THIS) || this.options.enables(DiagnosticGroups.DEBUGGER_STATEMENT_PRESENT)) {
            checks.add(this.suspiciousCode);
        }
        if (this.options.closurePass && this.options.checkMissingGetCssNameLevel.isOn()) {
            checks.add(this.closureCheckGetCssName);
        }
        if (this.options.syntheticBlockStartMarker != null) {
            checks.add(this.createSyntheticBlocks);
        }
        checks.add(this.checkVars);
        if (this.options.inferConsts) {
            checks.add(this.inferConsts);
        }
        if (this.options.computeFunctionSideEffects) {
            checks.add(this.checkRegExp);
        }
        if (this.options.processObjectPropertyString) {
            checks.add(this.objectPropertyStringPreprocess);
        }
        if (this.options.dartPass && !this.options.getOutputFeatureSet().contains(FeatureSet.ES6)) {
            checks.add(this.dartSuperAccessorsPass);
        }
        checks.add(PassFactory.createEmptyPass("beforeES2017Transpilation"));
        TranspilationPasses.addPreTypecheckTranspilationPasses(checks, this.options);
        if (this.options.rewritePolyfills && !this.options.checksOnly) {
            TranspilationPasses.addRewritePolyfillPass(checks);
        }
        checks.add(this.injectRuntimeLibraries);
        if (this.options.needsTranspilationFrom(FeatureSet.ES6)) {
            checks.add(this.convertStaticInheritance);
        }
        checks.add(PassFactory.createEmptyPass("beforeTypeChecking"));
        this.addTypeCheckerPasses(checks, this.options);
        if (this.options.j2clPassMode.shouldAddJ2clPasses()) {
            checks.add(this.j2clSourceFileChecker);
        }
        if (!this.options.disables(DiagnosticGroups.CHECK_USELESS_CODE) || !this.options.disables(DiagnosticGroups.MISSING_RETURN)) {
            checks.add(this.checkControlFlow);
        }
        if (this.options.isTypecheckingEnabled() && (!this.options.disables(DiagnosticGroups.ACCESS_CONTROLS) || this.options.enables(DiagnosticGroups.CONSTANT_PROPERTY))) {
            checks.add(this.checkAccessControls);
        }
        checks.add(this.checkConsts);
        if (this.options.enables(DiagnosticGroups.ANALYZER_CHECKS) && this.options.isTypecheckingEnabled()) {
            checks.add(this.analyzerChecks);
        }
        if (this.options.checkGlobalNamesLevel.isOn()) {
            checks.add(this.checkGlobalNames);
        }
        if (!this.options.getConformanceConfigs().isEmpty()) {
            checks.add(this.checkConformance);
        }
        if (this.options.closurePass && !this.options.shouldPreserveGoogLibraryPrimitives()) {
            checks.add(this.closureReplaceGetCssName);
        }
        if (this.options.getTweakProcessing().isOn()) {
            checks.add(this.processTweaks);
        }
        if (this.options.instrumentationTemplate != null || this.options.recordFunctionInformation) {
            checks.add(this.computeFunctionNames);
        }
        if (this.options.checksOnly) {
            checks.add(this.processDefines);
        }
        if (this.options.j2clPassMode.shouldAddJ2clPasses()) {
            checks.add(this.j2clChecksPass);
        }
        if (this.options.shouldRunTypeSummaryChecksLate()) {
            checks.add(this.generateIjs);
        }
        if (this.options.generateExportsAfterTypeChecking && this.options.generateExports) {
            checks.add(this.generateExports);
        }
        checks.add(PassFactory.createEmptyPass("afterStandardChecks"));
        if (!this.options.checksOnly) {
            TranspilationPasses.addPostCheckTranspilationPasses(checks, this.options);
        }
        DefaultPassConfig.assertAllOneTimePasses(checks);
        this.assertValidOrderForChecks(checks);
        return checks;
    }

    @Override
    protected List<PassFactory> getOptimizations() {
        ArrayList<PassFactory> passes = new ArrayList<PassFactory>();
        if (this.options.skipNonTranspilationPasses) {
            return passes;
        }
        passes.add(this.garbageCollectChecks);
        if (this.options.replaceMessagesWithChromeI18n) {
            passes.add(this.replaceMessagesForChrome);
        } else if (this.options.messageBundle != null) {
            passes.add(this.replaceMessages);
        }
        passes.add(this.processDefines);
        if (!(!this.options.getTweakProcessing().shouldStrip() && this.options.stripTypes.isEmpty() && this.options.stripNameSuffixes.isEmpty() && this.options.stripTypePrefixes.isEmpty() && this.options.stripNamePrefixes.isEmpty())) {
            passes.add(this.stripCode);
        }
        passes.add(this.normalize);
        if (this.options.isExternExportsEnabled() || this.options.externExportsPath != null) {
            passes.add(this.externExports);
        }
        passes.add(this.gatherExternProperties);
        if (this.options.j2clPassMode.shouldAddJ2clPasses()) {
            passes.add(this.j2clPass);
            passes.add(this.j2clUtilGetDefineRewriterPass);
        }
        if (this.options.instrumentForCoverage) {
            passes.add(this.instrumentForCodeCoverage);
        }
        if (this.options.runtimeTypeCheck) {
            passes.add(this.runtimeTypeCheck);
        }
        passes.add(PassFactory.createEmptyPass("beforeStandardOptimizations"));
        if (this.options.replaceIdGenerators) {
            passes.add(this.replaceIdGenerators);
        }
        if (this.options.optimizeArgumentsArray) {
            passes.add(this.optimizeArgumentsArray);
        }
        if (this.options.closurePass && (this.options.removeAbstractMethods || this.options.removeClosureAsserts)) {
            passes.add(this.closureCodeRemoval);
        }
        if (this.options.removeJ2clAsserts) {
            passes.add(this.j2clAssertRemovalPass);
        }
        if (this.options.disambiguatePrivateProperties) {
            passes.add(this.disambiguatePrivateProperties);
        }
        DefaultPassConfig.assertAllOneTimePasses(passes);
        if (this.options.shouldCollapseProperties()) {
            passes.add(this.aggressiveInlineAliases);
        }
        if (this.options.j2clPassMode.shouldAddJ2clPasses() && this.options.shouldCollapseProperties()) {
            passes.add(this.j2clPropertyInlinerPass);
        }
        if (this.options.shouldCollapseProperties()) {
            passes.add(this.collapseProperties);
        }
        if (this.options.inferConsts) {
            passes.add(this.inferConsts);
        }
        passes.add(this.checkConstParams);
        if (this.options.extraSmartNameRemoval && this.options.smartNameRemoval) {
            if (this.options.foldConstants && (this.options.inlineVariables || this.options.inlineLocalVariables)) {
                passes.add(this.earlyInlineVariables);
                passes.add(this.earlyPeepholeOptimizations);
            }
            passes.add(this.removeUnusedCodeOnce);
        }
        if (this.options.rewritePolyfills) {
            passes.add(this.removeUnusedPolyfills);
        }
        if (this.options.shouldDisambiguateProperties() && this.options.isTypecheckingEnabled()) {
            passes.add(this.disambiguateProperties);
        }
        if (this.options.computeFunctionSideEffects) {
            passes.add(this.markPureFunctions);
        } else if (this.options.markNoSideEffectCalls) {
            passes.add(this.markNoSideEffectCalls);
        }
        if (this.options.smartNameRemoval) {
            passes.addAll(this.getCodeRemovingPasses());
        }
        if (this.options.closurePass) {
            passes.add(this.closureOptimizePrimitives);
        }
        if (!this.options.replaceStringsFunctionDescriptions.isEmpty()) {
            passes.add(this.replaceStrings);
        }
        if (this.options.shouldRunCrossChunkCodeMotion()) {
            passes.add(this.crossModuleCodeMotion);
        }
        if (this.options.removeSuperMethods) {
            passes.add(this.removeSuperMethodsPass);
        }
        if (this.options.devirtualizePrototypeMethods) {
            passes.add(this.devirtualizePrototypeMethods);
        }
        if (this.options.customPasses != null) {
            passes.add(this.getCustomPasses(CustomPassExecutionTime.BEFORE_OPTIMIZATION_LOOP));
        }
        passes.add(PassFactory.createEmptyPass("beforeMainOptimizations"));
        if (this.options.inlineVariables || this.options.inlineLocalVariables) {
            passes.add(this.flowSensitiveInlineVariables);
        }
        passes.addAll(this.getMainOptimizationLoop());
        passes.add(PassFactory.createEmptyPass("afterMainOptimizations"));
        passes.add(PassFactory.createEmptyPass("beforeModuleMotion"));
        if (this.options.shouldRunCrossChunkCodeMotion()) {
            passes.add(this.crossModuleCodeMotion);
        }
        if (this.options.shouldRunCrossChunkMethodMotion()) {
            passes.add(this.crossModuleMethodMotion);
        }
        passes.add(PassFactory.createEmptyPass("afterModuleMotion"));
        if (this.options.customPasses != null) {
            passes.add(this.getCustomPasses(CustomPassExecutionTime.AFTER_OPTIMIZATION_LOOP));
        }
        if (this.options.inlineVariables || this.options.inlineLocalVariables) {
            passes.add(this.flowSensitiveInlineVariables);
            if (this.shouldRunRemoveUnusedCode()) {
                passes.add(this.removeUnusedCodeOnce);
            }
        }
        if (this.options.collapseAnonymousFunctions) {
            passes.add(this.collapseAnonymousFunctions);
        }
        if (this.options.moveFunctionDeclarations || this.options.renamePrefixNamespace != null) {
            passes.add(this.moveFunctionDeclarations);
        }
        if (this.options.anonymousFunctionNaming == AnonymousFunctionNamingPolicy.MAPPED) {
            passes.add(this.nameMappedAnonymousFunctions);
        }
        if (this.options.extractPrototypeMemberDeclarations != CompilerOptions.ExtractPrototypeMemberDeclarationsMode.OFF) {
            passes.add(this.extractPrototypeMemberDeclarations);
        }
        if (this.options.shouldAmbiguateProperties() && this.options.propertyRenaming == PropertyRenamingPolicy.ALL_UNQUOTED && this.options.isTypecheckingEnabled()) {
            passes.add(this.ambiguateProperties);
        }
        if (this.options.propertyRenaming == PropertyRenamingPolicy.ALL_UNQUOTED) {
            passes.add(this.renameProperties);
        }
        if (this.options.reserveRawExports) {
            passes.add(this.gatherRawExports);
        }
        if (this.options.convertToDottedProperties) {
            passes.add(this.convertToDottedProperties);
        }
        if (this.options.rewriteFunctionExpressions) {
            passes.add(this.rewriteFunctionExpressions);
        }
        if (!this.options.aliasableStrings.isEmpty() || this.options.aliasAllStrings) {
            passes.add(this.aliasStrings);
        }
        if (this.options.coalesceVariableNames) {
            passes.add(this.coalesceVariableNames);
            if (this.options.foldConstants) {
                passes.add(this.peepholeOptimizationsOnce);
            }
        }
        passes.add(this.markUnnormalized);
        if (this.options.collapseVariableDeclarations) {
            passes.add(this.exploitAssign);
            passes.add(this.collapseVariableDeclarations);
        }
        passes.add(this.denormalize);
        if (this.options.instrumentationTemplate != null) {
            passes.add(this.instrumentFunctions);
        }
        if (this.options.variableRenaming != VariableRenamingPolicy.ALL) {
            passes.add(this.invertContextualRenaming);
        }
        if (this.options.variableRenaming != VariableRenamingPolicy.OFF) {
            passes.add(this.renameVars);
        }
        if (this.options.processObjectPropertyString) {
            passes.add(this.objectPropertyStringPostprocess);
        }
        if (this.options.labelRenaming) {
            passes.add(this.renameLabels);
        }
        if (this.options.foldConstants) {
            passes.add(this.latePeepholeOptimizations);
        }
        if (this.options.anonymousFunctionNaming == AnonymousFunctionNamingPolicy.UNMAPPED) {
            passes.add(this.nameUnmappedAnonymousFunctions);
        }
        if (this.protectHiddenSideEffects) {
            passes.add(this.stripSideEffectProtection);
        }
        if (this.options.renamePrefixNamespace != null) {
            if (!GLOBAL_SYMBOL_NAMESPACE_PATTERN.matcher(this.options.renamePrefixNamespace).matches()) {
                throw new IllegalArgumentException("Illegal character in renamePrefixNamespace name: " + this.options.renamePrefixNamespace);
            }
            passes.add(this.rescopeGlobalSymbols);
        }
        passes.add(this.checkAstValidity);
        passes.add(this.varCheckValidity);
        if (this.options.getOutputFeatureSet().contains(FeatureSet.ES6)) {
            passes.add(this.optimizeToEs6);
        }
        this.assertValidOrderForOptimizations(passes);
        return passes;
    }

    private List<PassFactory> getMainOptimizationLoop() {
        ArrayList<PassFactory> passes = new ArrayList<PassFactory>();
        if (this.options.inlineGetters) {
            passes.add(this.inlineSimpleMethods);
        }
        passes.addAll(this.getCodeRemovingPasses());
        if (this.options.getInlineFunctionsLevel() != CompilerOptions.Reach.NONE) {
            passes.add(this.inlineFunctions);
        }
        if (this.options.shouldInlineProperties() && this.options.isTypecheckingEnabled()) {
            passes.add(this.inlineProperties);
        }
        if ((this.options.removeUnusedVars || this.options.removeUnusedLocalVars) && this.options.deadAssignmentElimination) {
            passes.add(this.deadAssignmentsElimination);
            if (this.options.polymerVersion == null) {
                passes.add(this.deadPropertyAssignmentElimination);
            }
        }
        if (this.options.optimizeCalls) {
            passes.add(this.optimizeCalls);
        }
        if (this.options.j2clPassMode.shouldAddJ2clPasses()) {
            passes.add(this.j2clConstantHoisterPass);
            passes.add(this.j2clClinitPass);
        }
        DefaultPassConfig.assertAllLoopablePasses(passes);
        return passes;
    }

    private List<PassFactory> getCodeRemovingPasses() {
        ArrayList<PassFactory> passes = new ArrayList<PassFactory>();
        if (this.options.collapseObjectLiterals) {
            passes.add(this.collapseObjectLiterals);
        }
        if (this.options.inlineVariables || this.options.inlineLocalVariables) {
            passes.add(this.inlineVariables);
        } else if (this.options.inlineConstantVars) {
            passes.add(this.inlineConstants);
        }
        if (this.options.foldConstants) {
            passes.add(this.peepholeOptimizations);
        }
        if (this.options.removeDeadCode) {
            passes.add(this.removeUnreachableCode);
        }
        if (this.shouldRunRemoveUnusedCode()) {
            passes.add(this.removeUnusedCode);
        }
        DefaultPassConfig.assertAllLoopablePasses(passes);
        return passes;
    }

    private boolean shouldRunRemoveUnusedCode() {
        return this.options.removeUnusedVars || this.options.removeUnusedLocalVars || this.options.removeUnusedPrototypeProperties || this.options.isRemoveUnusedClassProperties() || this.options.isRemoveUnusedConstructorProperties();
    }

    private static void assertAllOneTimePasses(List<PassFactory> passes) {
        for (PassFactory pass : passes) {
            Preconditions.checkState(pass.isOneTimePass());
        }
    }

    private static void assertAllLoopablePasses(List<PassFactory> passes) {
        for (PassFactory pass : passes) {
            Preconditions.checkState(!pass.isOneTimePass());
        }
    }

    private void assertPassOrder(List<PassFactory> passList, PassFactory pass1, PassFactory pass2, String msg) {
        int pass1Index = passList.indexOf(pass1);
        int pass2Index = passList.indexOf(pass2);
        if (pass1Index != -1 && pass2Index != -1) {
            Preconditions.checkState(pass1Index < pass2Index, msg);
        }
    }

    private void assertValidOrderForChecks(List<PassFactory> checks) {
        this.assertPassOrder(checks, this.chromePass, this.checkJsDocAndEs6Modules, "The ChromePass must run before after JsDoc and Es6 module checking.");
        this.assertPassOrder(checks, this.closureRewriteModule, this.processDefines, "Must rewrite goog.module before processing @define's, so that @defines in modules work.");
        this.assertPassOrder(checks, this.closurePrimitives, this.polymerPass, "The Polymer pass must run after goog.provide processing.");
        this.assertPassOrder(checks, this.chromePass, this.polymerPass, "The Polymer pass must run after ChromePass processing.");
        this.assertPassOrder(checks, this.polymerPass, this.suspiciousCode, "The Polymer pass must run before suspiciousCode processing.");
        this.assertPassOrder(checks, this.dartSuperAccessorsPass, TranspilationPasses.es6ConvertSuper, "The Dart super accessors pass must run before ES6->ES3 super lowering.");
        if (checks.contains(this.closureGoogScopeAliases)) {
            Preconditions.checkState(checks.contains(this.checkVariableReferences), "goog.scope processing requires variable checking");
        }
        this.assertPassOrder(checks, this.checkVariableReferences, this.closureGoogScopeAliases, "Variable checking must happen before goog.scope processing.");
        this.assertPassOrder(checks, TranspilationPasses.es6ConvertSuper, this.removeSuperMethodsPass, "Super-call method removal must run after Es6 super rewriting, because Es6 super calls are matched on their post-processed form.");
        this.assertPassOrder(checks, this.closurePrimitives, this.removeSuperMethodsPass, "Super-call method removal must run after Es6 super rewriting, because Closure base calls are expected to be in post-processed form.");
        this.assertPassOrder(checks, this.closureCodeRemoval, this.removeSuperMethodsPass, "Super-call method removal must run after closure code removal, because removing assertions may make more super calls eligible to be stripped.");
    }

    private void assertValidOrderForOptimizations(List<PassFactory> optimizations) {
        this.assertPassOrder(optimizations, this.removeSuperMethodsPass, this.optimizeCalls, "RemoveSuperMethodsPass must run before OptimizeCalls.");
        this.assertPassOrder(optimizations, this.removeSuperMethodsPass, this.devirtualizePrototypeMethods, "RemoveSuperMethodsPass must run before DevirtualizePrototypeMethods.");
    }

    private static CompilerPass createPeepholeOptimizationsPass(AbstractCompiler compiler, String passName) {
        boolean late = false;
        boolean useTypesForOptimization = compiler.getOptions().useTypesForLocalOptimization;
        ArrayList<AbstractPeepholeOptimization> optimizations = new ArrayList<AbstractPeepholeOptimization>();
        optimizations.add(new MinimizeExitPoints());
        optimizations.add(new PeepholeMinimizeConditions(false));
        optimizations.add(new PeepholeSubstituteAlternateSyntax(false));
        optimizations.add(new PeepholeReplaceKnownMethods(false, useTypesForOptimization));
        optimizations.add(new PeepholeRemoveDeadCode());
        if (compiler.getOptions().j2clPassMode.shouldAddJ2clPasses()) {
            optimizations.add(new J2clEqualitySameRewriterPass());
            optimizations.add(new J2clStringValueOfRewriterPass());
        }
        optimizations.add(new PeepholeFoldConstants(false, useTypesForOptimization));
        optimizations.add(new PeepholeCollectPropertyAssignments());
        return new PeepholeOptimizationsPass(compiler, passName, optimizations);
    }

    private static HotSwapCompilerPass combineChecks(AbstractCompiler compiler, List<NodeTraversal.Callback> callbacks) {
        Preconditions.checkArgument(!callbacks.isEmpty());
        return new CombinedCompilerPass(compiler, callbacks);
    }

    private PassFactory getRemoveUnusedCode(boolean isOneTimePass) {
        return new PassFactory("removeUnusedCode", isOneTimePass){

            @Override
            protected CompilerPass create(AbstractCompiler compiler) {
                boolean preserveAnonymousFunctionNames = DefaultPassConfig.this.options.anonymousFunctionNaming != AnonymousFunctionNamingPolicy.OFF;
                return new RemoveUnusedCode.Builder(compiler).removeLocalVars(DefaultPassConfig.this.options.removeUnusedLocalVars).removeGlobals(DefaultPassConfig.this.options.removeUnusedVars).preserveFunctionExpressionNames(preserveAnonymousFunctionNames).removeUnusedPrototypeProperties(DefaultPassConfig.this.options.removeUnusedPrototypeProperties).allowRemovalOfExternProperties(DefaultPassConfig.this.options.removeUnusedPrototypePropertiesInExterns).removeUnusedThisProperties(DefaultPassConfig.this.options.isRemoveUnusedClassProperties()).removeUnusedObjectDefinePropertiesDefinitions(DefaultPassConfig.this.options.isRemoveUnusedClassProperties()).removeUnusedConstructorProperties(DefaultPassConfig.this.options.isRemoveUnusedConstructorProperties()).build();
            }

            @Override
            public FeatureSet featureSet() {
                return FeatureSet.ES8_MODULES;
            }
        };
    }

    private VariableMap runVariableRenaming(AbstractCompiler compiler, VariableMap prevVariableMap, Node externs, Node root) {
        char[] reservedChars = this.options.anonymousFunctionNaming.getReservedCharacters();
        boolean preserveAnonymousFunctionNames = this.options.anonymousFunctionNaming != AnonymousFunctionNamingPolicy.OFF;
        HashSet<String> reservedNames = new HashSet<String>();
        if (this.options.renamePrefixNamespace != null) {
            reservedNames.add(this.options.renamePrefixNamespace);
        }
        reservedNames.addAll(compiler.getExportedNames());
        reservedNames.addAll(ParserRunner.getReservedVars());
        RenameVars rn = new RenameVars(compiler, this.options.renamePrefix, this.options.variableRenaming == VariableRenamingPolicy.LOCAL, preserveAnonymousFunctionNames, this.options.generatePseudoNames, this.options.shadowVariables, this.options.preferStableNames, prevVariableMap, reservedChars, reservedNames, this.options.nameGenerator);
        rn.process(externs, root);
        return rn.getVariableMap();
    }

    private PassFactory getCustomPasses(final CustomPassExecutionTime executionTime) {
        return new PassFactory("runCustomPasses", true){

            @Override
            protected CompilerPass create(AbstractCompiler compiler) {
                return DefaultPassConfig.runInSerial(DefaultPassConfig.this.options.customPasses.get(executionTime));
            }

            @Override
            protected FeatureSet featureSet() {
                return FeatureSet.ES5;
            }
        };
    }

    private static CompilerPass runInSerial(final Collection<CompilerPass> passes) {
        return new CompilerPass(){

            @Override
            public void process(Node externs, Node root) {
                for (CompilerPass pass : passes) {
                    pass.process(externs, root);
                }
            }
        };
    }

    @VisibleForTesting
    static Map<String, Node> getAdditionalReplacements(CompilerOptions options) {
        HashMap<String, Node> additionalReplacements = new HashMap<String, Node>();
        if (options.markAsCompiled || options.closurePass) {
            additionalReplacements.put(COMPILED_CONSTANT_NAME, IR.trueNode());
        }
        if (options.closurePass && options.locale != null) {
            additionalReplacements.put(CLOSURE_LOCALE_CONSTANT_NAME, IR.string(options.locale));
        }
        return additionalReplacements;
    }

    class ClearTypedScope
    implements CompilerPass {
        ClearTypedScope() {
        }

        @Override
        public void process(Node externs, Node root) {
            DefaultPassConfig.this.clearTypedScope();
        }
    }

    class GlobalTypeResolver
    implements HotSwapCompilerPass {
        private final AbstractCompiler compiler;

        GlobalTypeResolver(AbstractCompiler compiler) {
            this.compiler = compiler;
        }

        @Override
        public void process(Node externs, Node root) {
            this.compiler.setTypeCheckingHasRun(true);
            if (DefaultPassConfig.this.topScope == null) {
                DefaultPassConfig.this.regenerateGlobalTypedScope(this.compiler, root.getParent());
            } else {
                this.compiler.getTypeRegistry().resolveTypes();
            }
        }

        @Override
        public void hotSwapScript(Node scriptRoot, Node originalRoot) {
            DefaultPassConfig.this.patchGlobalTypedScope(this.compiler, scriptRoot);
        }
    }
}

