/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.debugging.sourcemap.Util;
import com.google.javascript.jscomp.CodeConsumer;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.JSDocInfoPrinter;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.OutputCharsetEncoder;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.TokenStream;
import java.util.HashMap;
import java.util.Map;

public class CodeGenerator {
    private static final String LT_ESCAPED = "\\x3c";
    private static final String GT_ESCAPED = "\\x3e";
    private final Map<String, String> escapedJsStrings = new HashMap<String, String>();
    private final CodeConsumer cc;
    private final OutputCharsetEncoder outputCharsetEncoder;
    private final boolean preferSingleQuotes;
    private final boolean preserveTypeAnnotations;
    private final boolean trustedStrings;
    private final boolean quoteKeywordProperties;
    private final boolean useOriginalName;
    private final JSDocInfoPrinter jsDocInfoPrinter;

    private CodeGenerator(CodeConsumer consumer) {
        this.cc = consumer;
        this.outputCharsetEncoder = null;
        this.preferSingleQuotes = false;
        this.trustedStrings = true;
        this.preserveTypeAnnotations = false;
        this.quoteKeywordProperties = false;
        this.useOriginalName = false;
        this.jsDocInfoPrinter = new JSDocInfoPrinter(false);
    }

    protected CodeGenerator(CodeConsumer consumer, CompilerOptions options) {
        this.cc = consumer;
        this.outputCharsetEncoder = new OutputCharsetEncoder(options.getOutputCharset());
        this.preferSingleQuotes = options.preferSingleQuotes;
        this.trustedStrings = options.trustedStrings;
        this.preserveTypeAnnotations = options.preserveTypeAnnotations;
        this.quoteKeywordProperties = options.shouldQuoteKeywordProperties();
        this.useOriginalName = options.getUseOriginalNamesInOutput();
        this.jsDocInfoPrinter = new JSDocInfoPrinter(this.useOriginalName);
    }

    static CodeGenerator forCostEstimation(CodeConsumer consumer) {
        return new CodeGenerator(consumer);
    }

    void tagAsTypeSummary() {
        this.add("/** @fileoverview @typeSummary */\n");
    }

    public void tagAsStrict() {
        this.add("'use strict';");
        this.cc.endLine();
    }

    protected void add(String str) {
        this.cc.add(str);
    }

    protected void add(Node n) {
        this.add(n, Context.OTHER);
    }

    protected void add(Node n, Context context) {
        String jsdocAsString;
        if (!this.cc.continueProcessing()) {
            return;
        }
        if (this.preserveTypeAnnotations && n.getJSDocInfo() != null && !(jsdocAsString = this.jsDocInfoPrinter.print(n.getJSDocInfo())).equals("/** */ ")) {
            this.add(jsdocAsString);
        }
        Token type = n.getToken();
        String opstr = NodeUtil.opToStr(type);
        int childCount = n.getChildCount();
        Node first = n.getFirstChild();
        Node last = n.getLastChild();
        if (opstr != null && first != last) {
            boolean needsParens;
            Preconditions.checkState(childCount == 2, "Bad binary operator \"%s\": expected 2 arguments but got %s", (Object)opstr, childCount);
            int p = this.precedence(n);
            Context rhsContext = CodeGenerator.getContextForNoInOperator(context);
            boolean bl = needsParens = (context == Context.START_OF_EXPR || context.atArrowFunctionBody()) && first.isObjectPattern();
            if (n.isAssign() && needsParens) {
                this.add("(");
            }
            if (NodeUtil.isAssignmentOp(n) || type == Token.EXPONENT) {
                this.addExpr(first, p + 1, context);
                this.cc.addOp(opstr, true);
                this.addExpr(last, p, rhsContext);
            } else {
                this.unrollBinaryOperator(n, type, opstr, context, rhsContext, p, p + 1);
            }
            if (n.isAssign() && needsParens) {
                this.add(")");
            }
            return;
        }
        this.cc.startSourceMapping(n);
        switch (type) {
            case TRY: {
                Preconditions.checkState(first.getNext().isBlock() && !first.getNext().hasMoreThanOneChild());
                Preconditions.checkState(childCount >= 2 && childCount <= 3);
                this.add("try");
                this.add(first);
                Node catchblock = first.getNext().getFirstChild();
                if (catchblock != null) {
                    this.add(catchblock);
                }
                if (childCount != 3) break;
                this.cc.maybeInsertSpace();
                this.add("finally");
                this.add(last);
                break;
            }
            case CATCH: {
                Preconditions.checkState(childCount == 2, n);
                this.cc.maybeInsertSpace();
                this.add("catch");
                this.cc.maybeInsertSpace();
                this.add("(");
                this.add(first);
                this.add(")");
                this.add(last);
                break;
            }
            case THROW: {
                Preconditions.checkState(childCount == 1, n);
                this.add("throw");
                this.cc.maybeInsertSpace();
                this.add(first);
                this.cc.endStatement(true);
                break;
            }
            case RETURN: {
                this.add("return");
                if (childCount == 1) {
                    this.cc.maybeInsertSpace();
                    if (this.preserveTypeAnnotations && first.getJSDocInfo() != null) {
                        this.add("(");
                        this.add(first);
                        this.add(")");
                    } else {
                        this.add(first);
                    }
                } else {
                    Preconditions.checkState(childCount == 0, n);
                }
                this.cc.endStatement();
                break;
            }
            case VAR: {
                this.add("var ");
                this.addList(first, false, CodeGenerator.getContextForNoInOperator(context), ",");
                if (n.getParent() != null && !NodeUtil.isStatement(n)) break;
                this.cc.endStatement();
                break;
            }
            case CONST: {
                this.add("const ");
                this.addList(first, false, CodeGenerator.getContextForNoInOperator(context), ",");
                if (n.getParent() != null && !NodeUtil.isStatement(n)) break;
                this.cc.endStatement();
                break;
            }
            case LET: {
                this.add("let ");
                this.addList(first, false, CodeGenerator.getContextForNoInOperator(context), ",");
                if (n.getParent() != null && !NodeUtil.isStatement(n)) break;
                this.cc.endStatement();
                break;
            }
            case LABEL_NAME: {
                Preconditions.checkState(!n.getString().isEmpty(), n);
                this.addIdentifier(n.getString());
                break;
            }
            case DESTRUCTURING_LHS: {
                this.add(first);
                if (first == last) break;
                Preconditions.checkState(childCount == 2, n);
                this.cc.addOp("=", true);
                this.add(last);
                break;
            }
            case NAME: {
                if (this.useOriginalName && n.getOriginalName() != null) {
                    this.addIdentifier(n.getOriginalName());
                } else {
                    this.addIdentifier(n.getString());
                }
                this.maybeAddOptional(n);
                this.maybeAddTypeDecl(n);
                if (first == null || first.isEmpty()) break;
                Preconditions.checkState(childCount == 1, n);
                this.cc.addOp("=", true);
                if (first.isComma() || first.isCast() && first.getFirstChild().isComma()) {
                    this.addExpr(first, NodeUtil.precedence(Token.ASSIGN), Context.OTHER);
                    break;
                }
                this.addExpr(first, 0, CodeGenerator.getContextForNoInOperator(context));
                break;
            }
            case ARRAYLIT: {
                this.add("[");
                this.addArrayList(first);
                this.add("]");
                break;
            }
            case ARRAY_PATTERN: {
                this.add("[");
                this.addArrayList(first);
                this.add("]");
                this.maybeAddTypeDecl(n);
                break;
            }
            case PARAM_LIST: {
                this.add("(");
                this.addList(first);
                this.add(")");
                break;
            }
            case DEFAULT_VALUE: {
                this.add(first);
                this.maybeAddTypeDecl(n);
                this.cc.addOp("=", true);
                this.addExpr(first.getNext(), 1, Context.OTHER);
                break;
            }
            case COMMA: {
                Preconditions.checkState(childCount == 2, n);
                this.unrollBinaryOperator(n, Token.COMMA, ",", context, CodeGenerator.getContextForNoInOperator(context), 0, 0);
                break;
            }
            case NUMBER: {
                Preconditions.checkState(childCount == 0, n);
                this.cc.addNumber(n.getDouble(), n);
                break;
            }
            case TYPEOF: 
            case VOID: 
            case NOT: 
            case BITNOT: 
            case POS: {
                Preconditions.checkState(childCount == 1, n);
                this.cc.addOp(NodeUtil.opToStrNoFail(type), false);
                this.addExpr(first, NodeUtil.precedence(type), Context.OTHER);
                break;
            }
            case NEG: {
                Preconditions.checkState(childCount == 1, n);
                if (n.getFirstChild().isNumber()) {
                    this.cc.addNumber(-n.getFirstChild().getDouble(), n.getFirstChild());
                    break;
                }
                this.cc.addOp(NodeUtil.opToStrNoFail(type), false);
                this.addExpr(first, NodeUtil.precedence(type), Context.OTHER);
                break;
            }
            case HOOK: {
                Preconditions.checkState(childCount == 3, n);
                int p = NodeUtil.precedence(type);
                Context rhsContext = CodeGenerator.getContextForNoInOperator(context);
                this.addExpr(first, p + 1, context);
                this.cc.addOp("?", true);
                this.addExpr(first.getNext(), 1, rhsContext);
                this.cc.addOp(":", true);
                this.addExpr(last, 1, rhsContext);
                break;
            }
            case REGEXP: {
                if (!first.isString() || !last.isString()) {
                    throw new Error("Expected children to be strings");
                }
                String regexp = this.regexpEscape(first.getString());
                if (childCount == 2) {
                    this.add(regexp + last.getString());
                    break;
                }
                Preconditions.checkState(childCount == 1, n);
                this.add(regexp);
                break;
            }
            case FUNCTION: {
                if (n.getClass() != Node.class) {
                    throw new Error("Unexpected Node subclass.");
                }
                Preconditions.checkState(childCount == 3, n);
                if (n.isArrowFunction()) {
                    this.addArrowFunction(n, first, last, context);
                    break;
                }
                this.addFunction(n, first, last, context);
                break;
            }
            case REST: {
                this.add("...");
                this.add(first);
                this.maybeAddTypeDecl(n);
                break;
            }
            case SPREAD: {
                this.add("...");
                this.add(n.getFirstChild());
                break;
            }
            case EXPORT: {
                this.add("export");
                if (n.getBooleanProp((byte)63)) {
                    this.add("default");
                }
                if (n.getBooleanProp((byte)64)) {
                    this.add("*");
                    Preconditions.checkState(first != null && first.isEmpty(), n);
                } else {
                    this.add(first);
                }
                if (childCount == 2) {
                    this.add("from");
                    this.add(last);
                }
                this.processEnd(first, context);
                break;
            }
            case IMPORT: {
                this.add("import");
                Node second = first.getNext();
                if (!first.isEmpty()) {
                    this.add(first);
                    if (!second.isEmpty()) {
                        this.cc.listSeparator();
                    }
                }
                if (!second.isEmpty()) {
                    this.add(second);
                }
                if (!first.isEmpty() || !second.isEmpty()) {
                    this.add("from");
                }
                this.add(last);
                this.cc.endStatement();
                break;
            }
            case EXPORT_SPECS: 
            case IMPORT_SPECS: {
                this.add("{");
                for (Node c = first; c != null; c = c.getNext()) {
                    if (c != first) {
                        this.cc.listSeparator();
                    }
                    this.add(c);
                }
                this.add("}");
                break;
            }
            case EXPORT_SPEC: 
            case IMPORT_SPEC: {
                this.add(first);
                if (n.isShorthandProperty() && first.getString().equals(last.getString())) break;
                this.add("as");
                this.add(last);
                break;
            }
            case IMPORT_STAR: {
                this.add("*");
                this.add("as");
                this.add(n.getString());
                break;
            }
            case CLASS: {
                Node interfaces;
                boolean classNeedsParens;
                Preconditions.checkState(childCount == 3, n);
                boolean bl = classNeedsParens = context == Context.START_OF_EXPR;
                if (classNeedsParens) {
                    this.add("(");
                }
                Node name = first;
                Node superClass = first.getNext();
                Node members = last;
                this.add("class");
                if (!name.isEmpty()) {
                    this.add(name);
                }
                this.maybeAddGenericTypes(first);
                if (!superClass.isEmpty()) {
                    this.add("extends");
                    this.add(superClass);
                }
                if ((interfaces = (Node)n.getProp((byte)82)) != null) {
                    this.add("implements");
                    Node child = interfaces.getFirstChild();
                    this.add(child);
                    while ((child = child.getNext()) != null) {
                        this.add(",");
                        this.cc.maybeInsertSpace();
                        this.add(child);
                    }
                }
                this.add(members);
                this.cc.endClass(context == Context.STATEMENT);
                if (!classNeedsParens) break;
                this.add(")");
                break;
            }
            case CLASS_MEMBERS: 
            case INTERFACE_MEMBERS: 
            case NAMESPACE_ELEMENTS: {
                this.cc.beginBlock();
                for (Node c = first; c != null; c = c.getNext()) {
                    this.add(c);
                    this.processEnd(c, context);
                    this.cc.endLine();
                }
                this.cc.endBlock(false);
                break;
            }
            case ENUM_MEMBERS: {
                this.cc.beginBlock();
                for (Node c = first; c != null; c = c.getNext()) {
                    this.add(c);
                    if (c.getNext() != null) {
                        this.add(",");
                    }
                    this.cc.endLine();
                }
                this.cc.endBlock(false);
                break;
            }
            case GETTER_DEF: 
            case SETTER_DEF: 
            case MEMBER_FUNCTION_DEF: 
            case MEMBER_VARIABLE_DEF: {
                Preconditions.checkState(n.getParent().isObjectLit() || n.getParent().isClassMembers() || n.getParent().isInterfaceMembers() || n.getParent().isRecordType() || n.getParent().isIndexSignature());
                this.maybeAddAccessibilityModifier(n);
                if (n.isStaticMember()) {
                    this.add("static ");
                }
                if (n.isMemberFunctionDef() && n.getFirstChild().isAsyncFunction()) {
                    this.add("async ");
                }
                if (!n.isMemberVariableDef() && n.getFirstChild().isGeneratorFunction()) {
                    Preconditions.checkState(type == Token.MEMBER_FUNCTION_DEF, n);
                    this.add("*");
                }
                switch (type) {
                    case GETTER_DEF: {
                        Preconditions.checkState(!first.getSecondChild().hasChildren(), n);
                        this.add("get ");
                        break;
                    }
                    case SETTER_DEF: {
                        Preconditions.checkState(first.getSecondChild().hasOneChild(), n);
                        this.add("set ");
                        break;
                    }
                    case MEMBER_FUNCTION_DEF: 
                    case MEMBER_VARIABLE_DEF: {
                        break;
                    }
                }
                String name = n.getString();
                if (n.isMemberVariableDef()) {
                    this.add(n.getString());
                    this.maybeAddOptional(n);
                    this.maybeAddTypeDecl(n);
                    break;
                }
                Preconditions.checkState(childCount == 1, n);
                Preconditions.checkState(first.isFunction(), first);
                Preconditions.checkState(first.getFirstChild().getString().isEmpty(), first);
                Node fn = first;
                Node parameters = fn.getSecondChild();
                Node body = fn.getLastChild();
                if (!n.isQuotedString() && TokenStream.isJSIdentifier(name) && NodeUtil.isLatin(name)) {
                    this.add(name);
                    this.maybeAddGenericTypes(fn.getFirstChild());
                } else {
                    double d = CodeGenerator.getSimpleNumber(name);
                    if (!Double.isNaN(d)) {
                        this.cc.addNumber(d, n);
                    } else {
                        this.addJsString(n);
                    }
                }
                this.maybeAddOptional(fn);
                this.add(parameters);
                this.maybeAddTypeDecl(fn);
                this.add(body);
                break;
            }
            case SCRIPT: 
            case MODULE_BODY: 
            case BLOCK: 
            case ROOT: {
                boolean preserveBlock;
                if (n.getClass() != Node.class) {
                    throw new Error("Unexpected Node subclass.");
                }
                boolean bl = preserveBlock = n.isBlock() && !n.isSyntheticBlock();
                if (preserveBlock) {
                    this.cc.beginBlock();
                }
                boolean preferLineBreaks = type == Token.SCRIPT || type == Token.BLOCK && !preserveBlock && n.getParent().isScript();
                for (Node c = first; c != null; c = c.getNext()) {
                    this.add(c, Context.STATEMENT);
                    if (c.isFunction() || c.isClass()) {
                        this.cc.maybeLineBreak();
                    }
                    if (!preferLineBreaks) continue;
                    this.cc.notePreferredLineBreak();
                }
                if (!preserveBlock) break;
                this.cc.endBlock(this.cc.breakAfterBlockFor(n, context == Context.STATEMENT));
                break;
            }
            case FOR: {
                Preconditions.checkState(childCount == 4, n);
                this.add("for");
                this.cc.maybeInsertSpace();
                this.add("(");
                if (NodeUtil.isNameDeclaration(first)) {
                    this.add(first, Context.IN_FOR_INIT_CLAUSE);
                } else {
                    this.addExpr(first, 0, Context.IN_FOR_INIT_CLAUSE);
                }
                this.add(";");
                if (!first.getNext().isEmpty()) {
                    this.cc.maybeInsertSpace();
                }
                this.add(first.getNext());
                this.add(";");
                if (!first.getNext().getNext().isEmpty()) {
                    this.cc.maybeInsertSpace();
                }
                this.add(first.getNext().getNext());
                this.add(")");
                this.addNonEmptyStatement(last, CodeGenerator.getContextForNonEmptyExpression(context), false);
                break;
            }
            case FOR_IN: {
                Preconditions.checkState(childCount == 3, n);
                this.add("for");
                this.cc.maybeInsertSpace();
                this.add("(");
                this.add(first);
                this.add("in");
                this.add(first.getNext());
                this.add(")");
                this.addNonEmptyStatement(last, CodeGenerator.getContextForNonEmptyExpression(context), false);
                break;
            }
            case FOR_OF: {
                Preconditions.checkState(childCount == 3, n);
                this.add("for");
                this.cc.maybeInsertSpace();
                this.add("(");
                this.add(first);
                this.cc.maybeInsertSpace();
                this.add("of");
                this.cc.maybeInsertSpace();
                this.add(first.getNext());
                this.add(")");
                this.addNonEmptyStatement(last, CodeGenerator.getContextForNonEmptyExpression(context), false);
                break;
            }
            case FOR_AWAIT_OF: {
                Preconditions.checkState(childCount == 3, n);
                this.add("for await");
                this.cc.maybeInsertSpace();
                this.add("(");
                this.add(first);
                this.cc.maybeInsertSpace();
                this.add("of");
                this.cc.maybeInsertSpace();
                this.add(first.getNext());
                this.add(")");
                this.addNonEmptyStatement(last, CodeGenerator.getContextForNonEmptyExpression(context), false);
                break;
            }
            case DO: {
                Preconditions.checkState(childCount == 2, n);
                this.add("do");
                this.addNonEmptyStatement(first, Context.OTHER, false);
                this.cc.maybeInsertSpace();
                this.add("while");
                this.cc.maybeInsertSpace();
                this.add("(");
                this.add(last);
                this.add(")");
                this.cc.endStatement();
                break;
            }
            case WHILE: {
                Preconditions.checkState(childCount == 2, n);
                this.add("while");
                this.cc.maybeInsertSpace();
                this.add("(");
                this.add(first);
                this.add(")");
                this.addNonEmptyStatement(last, CodeGenerator.getContextForNonEmptyExpression(context), false);
                break;
            }
            case EMPTY: {
                Preconditions.checkState(childCount == 0, n);
                break;
            }
            case GETPROP: {
                if (this.useOriginalName && n.getOriginalName() != null) {
                    if (n.getFirstChild().matchesQualifiedName("$jscomp.scope") && n.getParent().isAssign()) {
                        this.add("var ");
                    }
                    this.addIdentifier(n.getOriginalName());
                    break;
                }
                Preconditions.checkState(childCount == 2, "Bad GETPROP: expected 2 children, but got %s", childCount);
                Preconditions.checkState(last.isString(), "Bad GETPROP: RHS should be STRING");
                boolean needsParens = first.isNumber();
                if (needsParens) {
                    this.add("(");
                }
                this.addExpr(first, NodeUtil.precedence(type), context);
                if (needsParens) {
                    this.add(")");
                }
                if (this.quoteKeywordProperties && TokenStream.isKeyword(last.getString())) {
                    this.add("[");
                    this.add(last);
                    this.add("]");
                    break;
                }
                this.add(".");
                this.addIdentifier(last.getString());
                break;
            }
            case GETELEM: {
                Preconditions.checkState(childCount == 2, "Bad GETELEM node: Expected 2 children but got %s. For node: %s", childCount, (Object)n);
                this.addExpr(first, NodeUtil.precedence(type), context);
                this.add("[");
                this.add(first.getNext());
                this.add("]");
                break;
            }
            case WITH: {
                Preconditions.checkState(childCount == 2, n);
                this.add("with(");
                this.add(first);
                this.add(")");
                this.addNonEmptyStatement(last, CodeGenerator.getContextForNonEmptyExpression(context), false);
                break;
            }
            case INC: 
            case DEC: {
                Preconditions.checkState(childCount == 1, n);
                String o = type == Token.INC ? "++" : "--";
                boolean postProp = n.getBooleanProp((byte)32);
                if (postProp) {
                    this.addExpr(first, NodeUtil.precedence(type), context);
                    this.cc.addOp(o, false);
                    break;
                }
                this.cc.addOp(o, false);
                this.add(first);
                break;
            }
            case CALL: {
                if (CodeGenerator.isIndirectEval(first) || n.getBooleanProp((byte)50) && NodeUtil.isGet(first)) {
                    this.add("(0,");
                    this.addExpr(first, NodeUtil.precedence(Token.COMMA), Context.OTHER);
                    this.add(")");
                } else {
                    this.addExpr(first, NodeUtil.precedence(type), context);
                }
                Node args = first.getNext();
                this.add("(");
                this.addList(args);
                this.add(")");
                break;
            }
            case IF: {
                boolean ambiguousElseClause;
                Preconditions.checkState(childCount == 2 || childCount == 3, n);
                boolean hasElse = childCount == 3;
                boolean bl = ambiguousElseClause = context == Context.BEFORE_DANGLING_ELSE && !hasElse;
                if (ambiguousElseClause) {
                    this.cc.beginBlock();
                }
                this.add("if");
                this.cc.maybeInsertSpace();
                this.add("(");
                this.add(first);
                this.add(")");
                if (hasElse) {
                    this.addNonEmptyStatement(first.getNext(), Context.BEFORE_DANGLING_ELSE, false);
                    this.cc.maybeInsertSpace();
                    this.add("else");
                    this.addNonEmptyStatement(last, CodeGenerator.getContextForNonEmptyExpression(context), false);
                } else {
                    this.addNonEmptyStatement(first.getNext(), Context.OTHER, false);
                }
                if (!ambiguousElseClause) break;
                this.cc.endBlock();
                break;
            }
            case NULL: {
                Preconditions.checkState(childCount == 0, n);
                this.cc.addConstant("null");
                break;
            }
            case THIS: {
                Preconditions.checkState(childCount == 0, n);
                this.add("this");
                break;
            }
            case SUPER: {
                Preconditions.checkState(childCount == 0, n);
                this.add("super");
                break;
            }
            case NEW_TARGET: {
                Preconditions.checkState(childCount == 0, n);
                this.add("new.target");
                break;
            }
            case YIELD: {
                this.add("yield");
                if (n.isYieldAll()) {
                    Preconditions.checkNotNull(first);
                    this.add("*");
                }
                if (first == null) break;
                this.cc.maybeInsertSpace();
                this.addExpr(first, NodeUtil.precedence(type), Context.OTHER);
                break;
            }
            case AWAIT: {
                this.add("await ");
                this.addExpr(first, NodeUtil.precedence(type), Context.OTHER);
                break;
            }
            case FALSE: {
                Preconditions.checkState(childCount == 0, n);
                this.cc.addConstant("false");
                break;
            }
            case TRUE: {
                Preconditions.checkState(childCount == 0, n);
                this.cc.addConstant("true");
                break;
            }
            case CONTINUE: {
                Preconditions.checkState(childCount <= 1, n);
                this.add("continue");
                if (childCount == 1) {
                    if (!first.isLabelName()) {
                        throw new Error("Unexpected token type. Should be LABEL_NAME.");
                    }
                    this.add(" ");
                    this.add(first);
                }
                this.cc.endStatement();
                break;
            }
            case DEBUGGER: {
                Preconditions.checkState(childCount == 0, n);
                this.add("debugger");
                this.cc.endStatement();
                break;
            }
            case BREAK: {
                Preconditions.checkState(childCount <= 1, n);
                this.add("break");
                if (childCount == 1) {
                    if (!first.isLabelName()) {
                        throw new Error("Unexpected token type. Should be LABEL_NAME.");
                    }
                    this.add(" ");
                    this.add(first);
                }
                this.cc.endStatement();
                break;
            }
            case EXPR_RESULT: {
                Preconditions.checkState(childCount == 1, n);
                this.add(first, Context.START_OF_EXPR);
                this.cc.endStatement();
                break;
            }
            case NEW: {
                this.add("new ");
                int precedence = NodeUtil.precedence(type);
                int precedenceOfFirst = NodeUtil.precedence(first.getToken());
                if (precedenceOfFirst == precedence) {
                    ++precedence;
                }
                if (NodeUtil.containsType(first, Token.CALL, NodeUtil.MATCH_NOT_FUNCTION)) {
                    precedence = NodeUtil.precedence(first.getToken()) + 1;
                }
                this.addExpr(first, precedence, Context.OTHER);
                Node next = first.getNext();
                if (next == null) break;
                this.add("(");
                this.addList(next);
                this.add(")");
                break;
            }
            case STRING_KEY: {
                this.addStringKey(n);
                break;
            }
            case STRING: {
                Preconditions.checkState(childCount == 0, "String node %s may not have children", (Object)n);
                this.addJsString(n);
                break;
            }
            case DELPROP: {
                Preconditions.checkState(childCount == 1, n);
                this.add("delete ");
                this.add(first);
                break;
            }
            case OBJECTLIT: {
                boolean needsParens;
                boolean bl = needsParens = context == Context.START_OF_EXPR || context.atArrowFunctionBody();
                if (needsParens) {
                    this.add("(");
                }
                this.add("{");
                for (Node c = first; c != null; c = c.getNext()) {
                    if (c != first) {
                        this.cc.listSeparator();
                    }
                    Preconditions.checkState(NodeUtil.isObjLitProperty(c) || c.isSpread(), c);
                    this.add(c);
                }
                this.add("}");
                if (!needsParens) break;
                this.add(")");
                break;
            }
            case COMPUTED_PROP: {
                this.maybeAddAccessibilityModifier(n);
                if (n.getBooleanProp((byte)58)) {
                    this.add("static ");
                }
                if (n.getBooleanProp((byte)73)) {
                    this.add("get ");
                } else if (n.getBooleanProp((byte)74)) {
                    this.add("set ");
                } else {
                    if (last.isAsyncFunction()) {
                        this.add("async");
                    }
                    if (last.getBooleanProp((byte)59)) {
                        this.add("*");
                    }
                }
                this.add("[");
                this.add(first);
                this.add("]");
                this.maybeAddTypeDecl(n);
                if (n.getBooleanProp((byte)72) || n.getBooleanProp((byte)73) || n.getBooleanProp((byte)74)) {
                    Node function = first.getNext();
                    Node params = function.getSecondChild();
                    Node body = function.getLastChild();
                    this.add(params);
                    this.add(body);
                    break;
                }
                boolean isInClass = n.getParent().isClassMembers();
                Node initializer = first.getNext();
                if (initializer != null) {
                    Preconditions.checkState(!isInClass, "initializers should only exist in object literals, not classes");
                    this.cc.addOp(":", false);
                    this.add(initializer);
                    break;
                }
                Preconditions.checkState(n.getBooleanProp((byte)75), n);
                break;
            }
            case OBJECT_PATTERN: {
                this.addObjectPattern(n);
                this.maybeAddTypeDecl(n);
                break;
            }
            case SWITCH: {
                this.add("switch(");
                this.add(first);
                this.add(")");
                this.cc.beginBlock();
                this.addAllSiblings(first.getNext());
                this.cc.endBlock(context == Context.STATEMENT);
                break;
            }
            case CASE: {
                Preconditions.checkState(childCount == 2, n);
                this.add("case ");
                this.add(first);
                this.addCaseBody(last);
                break;
            }
            case DEFAULT_CASE: {
                Preconditions.checkState(childCount == 1, n);
                this.add("default");
                this.addCaseBody(first);
                break;
            }
            case LABEL: {
                Preconditions.checkState(childCount == 2, n);
                if (!first.isLabelName()) {
                    throw new Error("Unexpected token type. Should be LABEL_NAME.");
                }
                this.add(first);
                this.add(":");
                if (!last.isBlock()) {
                    this.cc.maybeInsertSpace();
                }
                this.addNonEmptyStatement(last, CodeGenerator.getContextForNonEmptyExpression(context), true);
                break;
            }
            case CAST: {
                if (this.preserveTypeAnnotations) {
                    this.add("(");
                    this.add(first);
                    this.add(")");
                    break;
                }
                this.add(first, context);
                break;
            }
            case TAGGED_TEMPLATELIT: {
                this.add(first, Context.START_OF_EXPR);
                this.add(first.getNext());
                break;
            }
            case TEMPLATELIT: {
                this.add("`");
                for (Node c = first; c != null; c = c.getNext()) {
                    if (c.isString()) {
                        this.add(this.strEscape(c.getString(), "\"", "'", "\\`", "\\\\", "\\$", false, false));
                        continue;
                    }
                    this.cc.append("${");
                    this.add(c.getFirstChild(), Context.START_OF_EXPR);
                    this.add("}");
                }
                this.add("`");
                break;
            }
            case STRING_TYPE: {
                this.add("string");
                break;
            }
            case BOOLEAN_TYPE: {
                this.add("boolean");
                break;
            }
            case NUMBER_TYPE: {
                this.add("number");
                break;
            }
            case ANY_TYPE: {
                this.add("any");
                break;
            }
            case VOID_TYPE: {
                this.add("void");
                break;
            }
            case NAMED_TYPE: {
                this.add(first);
                break;
            }
            case ARRAY_TYPE: {
                this.addExpr(first, NodeUtil.precedence(Token.ARRAY_TYPE), context);
                this.add("[]");
                break;
            }
            case FUNCTION_TYPE: {
                Node returnType = first;
                this.add("(");
                this.addList(first.getNext());
                this.add(")");
                this.cc.addOp("=>", true);
                this.add(returnType);
                break;
            }
            case UNION_TYPE: {
                this.addList(first, "|");
                break;
            }
            case RECORD_TYPE: {
                this.add("{");
                this.addList(first, false, Context.OTHER, ",");
                this.add("}");
                break;
            }
            case PARAMETERIZED_TYPE: {
                this.add(first);
                this.add("<");
                this.addList(first.getNext());
                this.add(">");
                break;
            }
            case GENERIC_TYPE_LIST: {
                this.add("<");
                this.addList(first, false, Context.STATEMENT, ",");
                this.add(">");
                break;
            }
            case GENERIC_TYPE: {
                this.addIdentifier(n.getString());
                if (!n.hasChildren()) break;
                this.add("extends");
                this.cc.maybeInsertSpace();
                this.add(n.getFirstChild());
                break;
            }
            case INTERFACE: {
                Preconditions.checkState(childCount == 3, n);
                Node name = first;
                Node superTypes = first.getNext();
                Node members = last;
                this.add("interface");
                this.add(name);
                this.maybeAddGenericTypes(name);
                if (!superTypes.isEmpty()) {
                    this.add("extends");
                    Node superType = superTypes.getFirstChild();
                    this.add(superType);
                    while ((superType = superType.getNext()) != null) {
                        this.add(",");
                        this.cc.maybeInsertSpace();
                        this.add(superType);
                    }
                }
                this.add(members);
                break;
            }
            case ENUM: {
                Preconditions.checkState(childCount == 2, n);
                Node name = first;
                Node members = last;
                this.add("enum");
                this.add(name);
                this.add(members);
                break;
            }
            case NAMESPACE: {
                Preconditions.checkState(childCount == 2, n);
                Node name = first;
                Node elements = last;
                this.add("namespace");
                this.add(name);
                this.add(elements);
                break;
            }
            case TYPE_ALIAS: {
                this.add("type");
                this.add(n.getString());
                this.cc.addOp("=", true);
                this.add(last);
                this.cc.endStatement(true);
                break;
            }
            case DECLARE: {
                this.add("declare");
                this.add(first);
                this.processEnd(n, context);
                break;
            }
            case INDEX_SIGNATURE: {
                this.add("[");
                this.add(first);
                this.add("]");
                this.maybeAddTypeDecl(n);
                this.cc.endStatement(true);
                break;
            }
            case CALL_SIGNATURE: {
                if (n.getBooleanProp((byte)83)) {
                    this.add("new ");
                }
                this.maybeAddGenericTypes(n);
                this.add(first);
                this.maybeAddTypeDecl(n);
                this.cc.endStatement(true);
                break;
            }
            default: {
                throw new RuntimeException("Unknown token " + (Object)((Object)type) + "\n" + n.toStringTree());
            }
        }
        this.cc.endSourceMapping(n);
    }

    private void addIdentifier(String identifier) {
        this.cc.addIdentifier(CodeGenerator.identifierEscape(identifier));
    }

    private int precedence(Node n) {
        if (n.isCast()) {
            return this.precedence(n.getFirstChild());
        }
        return NodeUtil.precedence(n.getToken());
    }

    private static boolean arrowFunctionNeedsParens(Node n) {
        Node parent = n.getParent();
        if (parent == null) {
            return false;
        }
        if (NodeUtil.isBinaryOperator(parent) || NodeUtil.isUnaryOperator(parent) || NodeUtil.isUpdateOperator(parent) || parent.isTaggedTemplateLit() || parent.isGetProp()) {
            return true;
        }
        if (parent.isGetElem() || parent.isCall() || parent.isHook()) {
            return CodeGenerator.isFirstChild(n);
        }
        return false;
    }

    private static boolean isFirstChild(Node n) {
        Node parent = n.getParent();
        return parent != null && n == parent.getFirstChild();
    }

    private void addArrowFunction(Node n, Node first, Node last, Context context) {
        Preconditions.checkState(first.getString().isEmpty(), first);
        boolean funcNeedsParens = CodeGenerator.arrowFunctionNeedsParens(n);
        if (funcNeedsParens) {
            this.add("(");
        }
        this.maybeAddGenericTypes(first);
        if (n.isAsyncFunction()) {
            this.add("async");
        }
        this.add(first.getNext());
        this.maybeAddTypeDecl(n);
        this.cc.addOp("=>", true);
        if (last.isBlock()) {
            this.add(last);
        } else {
            this.addExpr(last, NodeUtil.precedence(Token.COMMA) + 1, CodeGenerator.getContextForArrowFunctionBody(context));
        }
        this.cc.endFunction(context == Context.STATEMENT);
        if (funcNeedsParens) {
            this.add(")");
        }
    }

    private void addFunction(Node n, Node first, Node last, Context context) {
        boolean funcNeedsParens;
        boolean bl = funcNeedsParens = context == Context.START_OF_EXPR;
        if (funcNeedsParens) {
            this.add("(");
        }
        this.add(n.isAsyncFunction() ? "async function" : "function");
        if (n.isGeneratorFunction()) {
            this.add("*");
            if (!first.getString().isEmpty()) {
                this.cc.maybeInsertSpace();
            }
        }
        this.add(first);
        this.maybeAddGenericTypes(first);
        this.add(first.getNext());
        this.maybeAddTypeDecl(n);
        this.add(last);
        this.cc.endFunction(context == Context.STATEMENT);
        if (funcNeedsParens) {
            this.add(")");
        }
    }

    private void maybeAddAccessibilityModifier(Node n) {
        JSDocInfo.Visibility access = (JSDocInfo.Visibility)((Object)n.getProp((byte)84));
        if (access != null) {
            this.add(access.toString().toLowerCase() + " ");
        }
    }

    private void maybeAddTypeDecl(Node n) {
        if (n.getDeclaredTypeExpression() != null) {
            this.add(":");
            this.cc.maybeInsertSpace();
            this.add(n.getDeclaredTypeExpression());
        }
    }

    private void maybeAddGenericTypes(Node n) {
        Node generics = (Node)n.getProp((byte)81);
        if (generics != null) {
            this.add(generics);
        }
    }

    private void maybeAddOptional(Node n) {
        if (n.getBooleanProp((byte)80)) {
            this.add("?");
        }
    }

    private void unrollBinaryOperator(Node n, Token op, String opStr, Context context, Context rhsContext, int leftPrecedence, int rightPrecedence) {
        Node firstNonOperator = n.getFirstChild();
        while (firstNonOperator.getToken() == op) {
            firstNonOperator = firstNonOperator.getFirstChild();
        }
        this.addExpr(firstNonOperator, leftPrecedence, context);
        Node current = firstNonOperator;
        do {
            current = current.getParent();
            this.cc.addOp(opStr, true);
            this.addExpr(current.getSecondChild(), rightPrecedence, rhsContext);
        } while (current != n);
    }

    static boolean isSimpleNumber(String s) {
        int len = s.length();
        if (len == 0) {
            return false;
        }
        for (int index = 0; index < len; ++index) {
            char c = s.charAt(index);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return len == 1 || s.charAt(0) != '0';
    }

    static double getSimpleNumber(String s) {
        if (CodeGenerator.isSimpleNumber(s)) {
            try {
                long l = Long.parseLong(s);
                if (l < 0x20000000000000L) {
                    return l;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Double.NaN;
    }

    private static boolean isIndirectEval(Node n) {
        return n.isName() && "eval".equals(n.getString()) && !n.getBooleanProp((byte)49);
    }

    private void addNonEmptyStatement(Node n, Context context, boolean allowNonBlockChild) {
        Node nodeToProcess = n;
        if (!allowNonBlockChild && !n.isBlock()) {
            throw new Error("Missing BLOCK child.");
        }
        if (n.isBlock()) {
            int count = CodeGenerator.getNonEmptyChildCount(n, 2);
            if (count == 0) {
                if (this.cc.shouldPreserveExtraBlocks()) {
                    this.cc.beginBlock();
                    this.cc.endBlock(this.cc.breakAfterBlockFor(n, context == Context.STATEMENT));
                } else {
                    this.cc.endStatement(true);
                }
                return;
            }
            if (count == 1) {
                Node firstAndOnlyChild = CodeGenerator.getFirstNonEmptyChild(n);
                boolean alwaysWrapInBlock = this.cc.shouldPreserveExtraBlocks();
                if (alwaysWrapInBlock || CodeGenerator.isBlockDeclOrDo(firstAndOnlyChild)) {
                    this.cc.beginBlock();
                    this.add(firstAndOnlyChild, Context.STATEMENT);
                    this.cc.maybeLineBreak();
                    this.cc.endBlock(this.cc.breakAfterBlockFor(n, context == Context.STATEMENT));
                    return;
                }
                nodeToProcess = firstAndOnlyChild;
            }
        }
        if (nodeToProcess.isEmpty()) {
            this.cc.endStatement(true);
        } else {
            this.add(nodeToProcess, context);
        }
    }

    private static boolean isBlockDeclOrDo(Node n) {
        if (n.isLabel()) {
            Node labeledStatement = n.getLastChild();
            if (!labeledStatement.isBlock()) {
                return CodeGenerator.isBlockDeclOrDo(labeledStatement);
            }
            if (CodeGenerator.getNonEmptyChildCount(n, 2) == 1) {
                return CodeGenerator.isBlockDeclOrDo(CodeGenerator.getFirstNonEmptyChild(n));
            }
            return false;
        }
        switch (n.getToken()) {
            case CONST: 
            case LET: 
            case FUNCTION: 
            case CLASS: 
            case DO: {
                return true;
            }
        }
        return false;
    }

    private void addExpr(Node n, int minPrecedence, Context context) {
        if (this.opRequiresParentheses(n, minPrecedence, context)) {
            this.add("(");
            this.add(n, Context.OTHER);
            this.add(")");
        } else {
            this.add(n, context);
        }
    }

    private boolean opRequiresParentheses(Node n, int minPrecedence, Context context) {
        if (context.inForInInitClause() && n.isIn()) {
            return true;
        }
        if (NodeUtil.isUnaryOperator(n) && this.isFirstOperandOfExponentiationExpression(n)) {
            return true;
        }
        return this.precedence(n) < minPrecedence;
    }

    private boolean isFirstOperandOfExponentiationExpression(Node n) {
        Node parent = n.getParent();
        return parent != null && parent.getToken() == Token.EXPONENT && parent.getFirstChild() == n;
    }

    void addList(Node firstInList) {
        this.addList(firstInList, true, Context.OTHER, ",");
    }

    void addList(Node firstInList, String separator) {
        this.addList(firstInList, true, Context.OTHER, separator);
    }

    void addList(Node firstInList, boolean isArrayOrFunctionArgument, Context lhsContext, String separator) {
        for (Node n = firstInList; n != null; n = n.getNext()) {
            boolean isFirst;
            boolean bl = isFirst = n == firstInList;
            if (isFirst) {
                this.addExpr(n, isArrayOrFunctionArgument ? 1 : 0, lhsContext);
                continue;
            }
            this.cc.addOp(separator, true);
            this.addExpr(n, isArrayOrFunctionArgument ? 1 : 0, CodeGenerator.getContextForNoInOperator(lhsContext));
        }
    }

    void addStringKey(Node n) {
        boolean mustBeQuoted;
        String key = n.getString();
        boolean bl = mustBeQuoted = n.isQuotedString() || this.quoteKeywordProperties && TokenStream.isKeyword(key) || !TokenStream.isJSIdentifier(key) || !NodeUtil.isLatin(key);
        if (!mustBeQuoted) {
            Node child;
            if (n.isShorthandProperty() && ((child = n.getFirstChild()).matchesQualifiedName(key) || child.isDefaultValue() && child.getFirstChild().matchesQualifiedName(key))) {
                this.add(child);
                return;
            }
            this.add(key);
        } else {
            double d = CodeGenerator.getSimpleNumber(key);
            if (!Double.isNaN(d)) {
                this.cc.addNumber(d, n);
            } else {
                this.addJsString(n);
            }
        }
        if (n.hasChildren()) {
            this.add(":");
            this.addExpr(n.getFirstChild(), 1, Context.OTHER);
        }
    }

    void addObjectPattern(Node n) {
        this.add("{");
        for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
            if (child != n.getFirstChild()) {
                this.cc.listSeparator();
            }
            this.add(child);
        }
        this.add("}");
    }

    void addArrayList(Node firstInList) {
        boolean lastWasEmpty = false;
        for (Node n = firstInList; n != null; n = n.getNext()) {
            if (n != firstInList) {
                this.cc.listSeparator();
            }
            this.addExpr(n, 1, Context.OTHER);
            lastWasEmpty = n.isEmpty();
        }
        if (lastWasEmpty) {
            this.cc.listSeparator();
        }
    }

    void addCaseBody(Node caseBody) {
        Preconditions.checkState(caseBody.isBlock(), caseBody);
        this.cc.beginCaseBody();
        this.addAllSiblings(caseBody.getFirstChild());
        this.cc.endCaseBody();
    }

    void addAllSiblings(Node n) {
        for (Node c = n; c != null; c = c.getNext()) {
            this.add(c);
        }
    }

    private void addJsString(Node n) {
        String s = n.getString();
        boolean useSlashV = n.getBooleanProp((byte)54);
        if (useSlashV) {
            this.add(this.jsString(n.getString(), useSlashV));
        } else {
            String cached = this.escapedJsStrings.get(s);
            if (cached == null) {
                cached = this.jsString(n.getString(), useSlashV);
                this.escapedJsStrings.put(s, cached);
            }
            this.add(cached);
        }
    }

    private String jsString(String s, boolean useSlashV) {
        String singlequote;
        String doublequote;
        char quote;
        int singleq = 0;
        int doubleq = 0;
        block4: for (int i = 0; i < s.length(); ++i) {
            switch (s.charAt(i)) {
                case '\"': {
                    ++doubleq;
                    continue block4;
                }
                case '\'': {
                    ++singleq;
                    continue block4;
                }
            }
        }
        if (this.preferSingleQuotes ? singleq <= doubleq : singleq < doubleq) {
            quote = '\'';
            doublequote = "\"";
            singlequote = "\\'";
        } else {
            quote = '\"';
            doublequote = "\\\"";
            singlequote = "'";
        }
        return quote + this.strEscape(s, doublequote, singlequote, "`", "\\\\", "$", useSlashV, false) + quote;
    }

    String regexpEscape(String s) {
        return '/' + this.strEscape(s, "\"", "'", "`", "\\", "$", false, true) + '/';
    }

    private String strEscape(String s, String doublequoteEscape, String singlequoteEscape, String backtickEscape, String backslashEscape, String dollarEscape, boolean useSlashV, boolean isRegexp) {
        StringBuilder sb = new StringBuilder(s.length() + 2);
        block20: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\u0000': {
                    sb.append("\\x00");
                    continue block20;
                }
                case '\u000b': {
                    if (useSlashV) {
                        sb.append("\\v");
                        continue block20;
                    }
                    sb.append("\\x0B");
                    continue block20;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block20;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block20;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block20;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block20;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block20;
                }
                case '\\': {
                    sb.append(backslashEscape);
                    continue block20;
                }
                case '\"': {
                    sb.append(doublequoteEscape);
                    continue block20;
                }
                case '\'': {
                    sb.append(singlequoteEscape);
                    continue block20;
                }
                case '$': {
                    sb.append(dollarEscape);
                    continue block20;
                }
                case '`': {
                    sb.append(backtickEscape);
                    continue block20;
                }
                case '\u2028': {
                    sb.append("\\u2028");
                    continue block20;
                }
                case '\u2029': {
                    sb.append("\\u2029");
                    continue block20;
                }
                case '=': {
                    if (this.trustedStrings || isRegexp) {
                        sb.append(c);
                        continue block20;
                    }
                    sb.append("\\x3d");
                    continue block20;
                }
                case '&': {
                    if (this.trustedStrings || isRegexp) {
                        sb.append(c);
                        continue block20;
                    }
                    sb.append("\\x26");
                    continue block20;
                }
                case '>': {
                    if (!this.trustedStrings && !isRegexp) {
                        sb.append(GT_ESCAPED);
                        continue block20;
                    }
                    if (i >= 2 && (s.charAt(i - 1) == '-' && s.charAt(i - 2) == '-' || s.charAt(i - 1) == ']' && s.charAt(i - 2) == ']')) {
                        sb.append(GT_ESCAPED);
                        continue block20;
                    }
                    sb.append(c);
                    continue block20;
                }
                case '<': {
                    if (!this.trustedStrings && !isRegexp) {
                        sb.append(LT_ESCAPED);
                        continue block20;
                    }
                    String endScript = "/script";
                    String startComment = "!--";
                    if (s.regionMatches(true, i + 1, "/script", 0, "/script".length())) {
                        sb.append(LT_ESCAPED);
                        continue block20;
                    }
                    if (s.regionMatches(false, i + 1, "!--", 0, "!--".length())) {
                        sb.append(LT_ESCAPED);
                        continue block20;
                    }
                    sb.append(c);
                    continue block20;
                }
                default: {
                    if (this.outputCharsetEncoder != null && this.outputCharsetEncoder.canEncode(c) || c > '\u001f' && c < '\u007f') {
                        sb.append(c);
                        continue block20;
                    }
                    Util.appendHexJavaScriptRepresentation(sb, c);
                }
            }
        }
        return sb.toString();
    }

    static String identifierEscape(String s) {
        if (NodeUtil.isLatin(s)) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c > '\u001f' && c < '\u007f') {
                sb.append(c);
                continue;
            }
            Util.appendHexJavaScriptRepresentation(sb, c);
        }
        return sb.toString();
    }

    private static int getNonEmptyChildCount(Node n, int maxCount) {
        int i = 0;
        for (Node c = n.getFirstChild(); c != null && i < maxCount; c = c.getNext()) {
            if (c.isBlock()) {
                i += CodeGenerator.getNonEmptyChildCount(c, maxCount - i);
                continue;
            }
            if (c.isEmpty()) continue;
            ++i;
        }
        return i;
    }

    private static Node getFirstNonEmptyChild(Node n) {
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            if (c.isBlock()) {
                Node result = CodeGenerator.getFirstNonEmptyChild(c);
                if (result == null) continue;
                return result;
            }
            if (c.isEmpty()) continue;
            return c;
        }
        return null;
    }

    private static Context getContextForNonEmptyExpression(Context currentContext) {
        return currentContext == Context.BEFORE_DANGLING_ELSE ? Context.BEFORE_DANGLING_ELSE : Context.OTHER;
    }

    private static Context getContextForNoInOperator(Context context) {
        return context.inForInInitClause() ? context : Context.OTHER;
    }

    private static Context getContextForArrowFunctionBody(Context context) {
        return context.inForInInitClause() ? Context.START_OF_ARROW_FN_IN_FOR_INIT : Context.START_OF_ARROW_FN_BODY;
    }

    private void processEnd(Node n, Context context) {
        switch (n.getToken()) {
            case CLASS: 
            case INTERFACE: 
            case ENUM: 
            case NAMESPACE: {
                this.cc.endClass(context == Context.STATEMENT);
                break;
            }
            case FUNCTION: {
                if (n.getLastChild().isEmpty()) {
                    this.cc.endStatement(true);
                    break;
                }
                this.cc.endFunction(context == Context.STATEMENT);
                break;
            }
            case DECLARE: {
                if (n.getParent().getToken() == Token.NAMESPACE_ELEMENTS) break;
                this.processEnd(n.getFirstChild(), context);
                break;
            }
            case EXPORT: {
                if (n.getParent().getToken() == Token.NAMESPACE_ELEMENTS || n.getFirstChild().getToken() == Token.DECLARE) break;
                this.processEnd(n.getFirstChild(), context);
                break;
            }
            case COMPUTED_PROP: {
                if (!n.hasOneChild()) break;
                this.cc.endStatement(true);
                break;
            }
            case GETTER_DEF: 
            case SETTER_DEF: 
            case MEMBER_FUNCTION_DEF: {
                if (!n.getFirstChild().getLastChild().isEmpty()) break;
                this.cc.endStatement(true);
                break;
            }
            case MEMBER_VARIABLE_DEF: {
                this.cc.endStatement(true);
                break;
            }
            default: {
                if (context != Context.STATEMENT) break;
                this.cc.endStatement();
            }
        }
    }

    public static enum Context {
        STATEMENT,
        BEFORE_DANGLING_ELSE,
        START_OF_EXPR,
        IN_FOR_INIT_CLAUSE(true, false),
        START_OF_ARROW_FN_BODY(false, true),
        START_OF_ARROW_FN_IN_FOR_INIT(true, true),
        OTHER;

        private final boolean inForInitClause;
        private final boolean atArrowFnBody;

        private Context() {
            this(false, false);
        }

        private Context(boolean inForInitClause, boolean atStartOfArrowFnBody) {
            this.inForInitClause = inForInitClause;
            this.atArrowFnBody = atStartOfArrowFnBody;
        }

        public boolean inForInInitClause() {
            return this.inForInitClause;
        }

        public boolean atArrowFunctionBody() {
            return this.atArrowFnBody;
        }
    }
}

