/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.ijs;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import javax.annotation.Nullable;

final class ClassUtil {
    private ClassUtil() {
    }

    static boolean isThisProp(Node getprop) {
        return ClassUtil.getClassNameOfThisProp(getprop) != null;
    }

    static String getPrototypeNameOfThisProp(Node getprop) {
        String className = Preconditions.checkNotNull(ClassUtil.getClassNameOfThisProp(getprop));
        return className + ".prototype." + getprop.getLastChild().getString();
    }

    @Nullable
    private static String getClassNameOfThisProp(Node getprop) {
        if (!getprop.isGetProp() || !getprop.getFirstChild().isThis()) {
            return null;
        }
        Node function = NodeUtil.getEnclosingFunction(getprop);
        if (function == null) {
            return null;
        }
        String className = ClassUtil.getClassName(function);
        if (className == null || className.isEmpty()) {
            return null;
        }
        return className;
    }

    static String getFullyQualifiedNameOfMethod(Node function) {
        Preconditions.checkArgument(ClassUtil.isClassMethod(function));
        String className = ClassUtil.getClassName(function);
        Preconditions.checkState(className != null && !className.isEmpty());
        Node memberFunctionDef = function.getParent();
        String methodName = memberFunctionDef.getString();
        return memberFunctionDef.isStaticMember() ? className + "." + methodName : className + ".prototype." + methodName;
    }

    static boolean isClassMethod(Node functionNode) {
        Preconditions.checkArgument(functionNode.isFunction());
        Node parent = functionNode.getParent();
        if (parent.isMemberFunctionDef() && parent.getParent().isClassMembers()) {
            return true;
        }
        return parent.isStringKey() && parent.getParent().isObjectLit() && parent.getGrandparent().isCall() && parent.getGrandparent().getFirstChild().matchesQualifiedName("goog.defineClass");
    }

    static boolean hasNamedClass(Node functionNode) {
        Preconditions.checkArgument(functionNode.isFunction());
        return ClassUtil.getClassName(functionNode) != null;
    }

    private static String getClassName(Node functionNode) {
        Preconditions.checkArgument(functionNode.isFunction());
        if (ClassUtil.isClassMethod(functionNode)) {
            Node parent = functionNode.getParent();
            if (parent.isMemberFunctionDef()) {
                Node classNode = functionNode.getGrandparent().getParent();
                Preconditions.checkState(classNode.isClass());
                return NodeUtil.getName(classNode);
            }
            Preconditions.checkState(parent.isStringKey());
            Node defineClassCall = parent.getGrandparent();
            Preconditions.checkState(defineClassCall.isCall());
            return NodeUtil.getBestLValue(defineClassCall).getQualifiedName();
        }
        return NodeUtil.getName(functionNode);
    }

    static boolean isConstructor(Node functionNode) {
        if (ClassUtil.isClassMethod(functionNode)) {
            return "constructor".equals(functionNode.getParent().getString());
        }
        JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(functionNode);
        return jsdoc != null && jsdoc.isConstructor();
    }
}

