/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AbstractScope;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.FunctionTypeBuilder;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.ScopeCreator;
import com.google.javascript.jscomp.ScopedName;
import com.google.javascript.jscomp.TypeCheck;
import com.google.javascript.jscomp.TypeValidator;
import com.google.javascript.jscomp.TypedScope;
import com.google.javascript.jscomp.TypedVar;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.NominalTypeBuilder;
import com.google.javascript.rhino.StaticSymbolTable;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.EnumType;
import com.google.javascript.rhino.jstype.FunctionParamBuilder;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.NominalTypeBuilderOti;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.Property;
import com.google.javascript.rhino.jstype.TemplateType;
import com.google.javascript.rhino.jstype.TemplateTypeMap;
import com.google.javascript.rhino.jstype.TemplateTypeMapReplacer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;

final class TypedScopeCreator
implements ScopeCreator,
StaticSymbolTable<TypedVar, TypedVar> {
    static final String DELEGATE_PROXY_SUFFIX = ObjectType.createDelegateSuffix("Proxy");
    static final DiagnosticType MALFORMED_TYPEDEF = DiagnosticType.warning("JSC_MALFORMED_TYPEDEF", "Typedef for {0} does not have any type information");
    static final DiagnosticType ENUM_INITIALIZER = DiagnosticType.warning("JSC_ENUM_INITIALIZER_NOT_ENUM", "enum initializer must be an object literal or an enum");
    static final DiagnosticType INVALID_ENUM_KEY = DiagnosticType.warning("JSC_INVALID_ENUM_KEY", "enum key must be a string or numeric literal");
    static final DiagnosticType CTOR_INITIALIZER = DiagnosticType.warning("JSC_CTOR_INITIALIZER_NOT_CTOR", "Constructor {0} must be initialized at declaration");
    static final DiagnosticType IFACE_INITIALIZER = DiagnosticType.warning("JSC_IFACE_INITIALIZER_NOT_IFACE", "Interface {0} must be initialized at declaration");
    static final DiagnosticType CONSTRUCTOR_EXPECTED = DiagnosticType.warning("JSC_REFLECT_CONSTRUCTOR_EXPECTED", "Constructor expected as first argument");
    static final DiagnosticType UNKNOWN_LENDS = DiagnosticType.warning("JSC_UNKNOWN_LENDS", "Variable {0} not declared before @lends annotation.");
    static final DiagnosticType LENDS_ON_NON_OBJECT = DiagnosticType.warning("JSC_LENDS_ON_NON_OBJECT", "May only lend properties to object types. {0} has type {1}.");
    static final DiagnosticType INCOMPATIBLE_ALIAS_ANNOTATION = DiagnosticType.warning("JSC_INCOMPATIBLE_ALIAS_ANNOTATION", "Annotation {0} on {1} incompatible with aliased type.");
    static final DiagnosticType DYNAMIC_EXTENDS_WITHOUT_JSDOC = DiagnosticType.warning("JSC_DYNAMIC_EXTENDS_WITHOUT_JSDOC", "The right-hand side of an extends clause must be a qualified name, or else @extends must be specified in JSDoc");
    static final DiagnosticGroup ALL_DIAGNOSTICS = new DiagnosticGroup(DELEGATE_PROXY_SUFFIX, MALFORMED_TYPEDEF, ENUM_INITIALIZER, CTOR_INITIALIZER, IFACE_INITIALIZER, CONSTRUCTOR_EXPECTED, UNKNOWN_LENDS, LENDS_ON_NON_OBJECT, INCOMPATIBLE_ALIAS_ANNOTATION, DYNAMIC_EXTENDS_WITHOUT_JSDOC);
    private final AbstractCompiler compiler;
    private final ErrorReporter typeParsingErrorReporter;
    private final TypeValidator validator;
    private final CodingConvention codingConvention;
    private final JSTypeRegistry typeRegistry;
    private final List<FunctionType> delegateProxyCtors = new ArrayList<FunctionType>();
    private final Map<String, String> delegateCallingConventions = new HashMap<String, String>();
    private final Map<Node, TypedScope> memoized = new LinkedHashMap<Node, TypedScope>();
    private final Set<Node> functionsWithNonEmptyReturns = new HashSet<Node>();
    private final Set<ScopedName> escapedVarNames = new HashSet<ScopedName>();
    private final Multiset<ScopedName> assignedVarNames = HashMultiset.create();
    private final ObjectType unknownType;
    private final List<DeferredSetType> deferredSetTypes = new ArrayList<DeferredSetType>();

    TypedScopeCreator(AbstractCompiler compiler) {
        this(compiler, compiler.getCodingConvention());
    }

    TypedScopeCreator(AbstractCompiler compiler, CodingConvention codingConvention) {
        this.compiler = compiler;
        this.validator = compiler.getTypeValidator();
        this.codingConvention = codingConvention;
        this.typeRegistry = compiler.getTypeRegistry();
        this.typeParsingErrorReporter = this.typeRegistry.getErrorReporter();
        this.unknownType = this.typeRegistry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE);
    }

    private void report(JSError error) {
        this.compiler.report(error);
    }

    @Override
    public ImmutableList<TypedVar> getReferences(TypedVar var) {
        return ImmutableList.of(var);
    }

    public TypedScope getScope(TypedVar var) {
        return (TypedScope)var.scope;
    }

    @Override
    public Iterable<TypedVar> getAllSymbols() {
        ArrayList<TypedVar> vars = new ArrayList<TypedVar>();
        for (TypedScope s : this.memoized.values()) {
            Iterables.addAll(vars, s.getAllSymbols());
        }
        return vars;
    }

    Collection<TypedScope> getAllMemoizedScopes() {
        return Lists.reverse(ImmutableList.copyOf(this.memoized.values()));
    }

    void removeScopesForScript(String scriptName) {
        this.memoized.keySet().removeIf(n -> scriptName.equals(NodeUtil.getSourceName(n)));
    }

    TypedScope createScope(Node n) {
        TypedScope s = this.memoized.get(n);
        return s != null ? s : this.createScope(n, (AbstractScope)this.createScope(NodeUtil.getEnclosingScopeRoot(n.getParent())));
    }

    public TypedScope createScope(Node root, AbstractScope<?, ?> parent) {
        Preconditions.checkArgument(parent == null || parent instanceof TypedScope);
        TypedScope typedParent = (TypedScope)parent;
        TypedScope scope = this.memoized.get(root);
        if (scope != null) {
            Preconditions.checkState(typedParent == scope.getParent());
        } else {
            scope = this.createScopeInternal(root, typedParent);
            this.memoized.put(root, scope);
        }
        return scope;
    }

    private TypedScope createScopeInternal(Node root, TypedScope typedParent) {
        TypedScope newScope = null;
        AbstractScopeBuilder scopeBuilder = null;
        if (typedParent == null) {
            ObjectType globalThis = this.typeRegistry.getNativeObjectType(JSTypeNative.GLOBAL_THIS);
            root.setJSType(globalThis);
            root.getFirstChild().setJSType(globalThis);
            root.getLastChild().setJSType(globalThis);
            new FirstOrderFunctionAnalyzer().process(root.getFirstChild(), root.getLastChild());
            newScope = this.createInitialScope(root);
        } else {
            newScope = new TypedScope(typedParent, root);
        }
        scopeBuilder = root.isFunction() ? new FunctionScopeBuilder(newScope) : (root.isClass() ? new ClassScopeBuilder(newScope) : new NormalScopeBuilder(newScope));
        scopeBuilder.build();
        if (typedParent == null) {
            ArrayList<NominalTypeBuilder> delegateProxies = new ArrayList<NominalTypeBuilder>();
            for (FunctionType delegateProxyCtor : this.delegateProxyCtors) {
                delegateProxies.add(new NominalTypeBuilderOti(delegateProxyCtor, delegateProxyCtor.getInstanceType()));
            }
            this.codingConvention.defineDelegateProxyPrototypeProperties(this.typeRegistry, delegateProxies, this.delegateCallingConventions);
        }
        return newScope;
    }

    void patchGlobalScope(TypedScope globalScope, Node scriptRoot) {
        Preconditions.checkState(scriptRoot.isScript());
        Preconditions.checkNotNull(globalScope);
        Preconditions.checkState(globalScope.isGlobal());
        String scriptName = NodeUtil.getSourceName(scriptRoot);
        Preconditions.checkNotNull(scriptName);
        Predicate<Node> inScript = n -> scriptName.equals(NodeUtil.getSourceName(n));
        this.escapedVarNames.removeIf(var -> inScript.test(var.getScopeRoot()));
        this.assignedVarNames.removeIf(var -> inScript.test(var.getScopeRoot()));
        this.functionsWithNonEmptyReturns.removeIf(inScript);
        new FirstOrderFunctionAnalyzer().process(null, scriptRoot);
        ArrayList<TypedVar> varsToRemove = new ArrayList<TypedVar>();
        for (TypedVar oldVar : globalScope.getVarIterable()) {
            if (!scriptName.equals(oldVar.getInputName())) continue;
            varsToRemove.add(oldVar);
        }
        for (TypedVar var2 : varsToRemove) {
            String typeName = var2.getName();
            globalScope.undeclare(var2);
            globalScope.getTypeOfThis().toObjectType().removeProperty(typeName);
            if (this.typeRegistry.getType(globalScope, typeName) == null) continue;
            this.typeRegistry.removeType(globalScope, typeName);
        }
        NormalScopeBuilder scopeBuilder = new NormalScopeBuilder(globalScope);
        NodeTraversal.traverse(this.compiler, scriptRoot, scopeBuilder);
    }

    @VisibleForTesting
    TypedScope createInitialScope(Node root) {
        NodeTraversal.traverse(this.compiler, root, new IdentifyGlobalEnumsAndTypedefsAsNonNullable(this.typeRegistry));
        TypedScope s = TypedScope.createGlobalScope(root);
        this.declareNativeFunctionType(s, JSTypeNative.ARRAY_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.BOOLEAN_OBJECT_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.DATE_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.FUNCTION_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.GENERATOR_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.ITERABLE_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.ITERATOR_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.NUMBER_OBJECT_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.OBJECT_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.REGEXP_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.STRING_OBJECT_FUNCTION_TYPE);
        this.declareNativeValueType(s, "undefined", JSTypeNative.VOID_TYPE);
        return s;
    }

    private void declareNativeFunctionType(TypedScope scope, JSTypeNative tId) {
        FunctionType t = this.typeRegistry.getNativeFunctionType(tId);
        TypedScopeCreator.declareNativeType(scope, t.getInstanceType().getReferenceName(), t);
        TypedScopeCreator.declareNativeType(scope, t.getPrototype().getReferenceName(), t.getPrototype());
    }

    private void declareNativeValueType(TypedScope scope, String name, JSTypeNative tId) {
        TypedScopeCreator.declareNativeType(scope, name, this.typeRegistry.getNativeType(tId));
    }

    private static void declareNativeType(TypedScope scope, String name, JSType t) {
        scope.declare(name, null, t, null, false);
    }

    void setDeferredType(Node node, JSType type) {
        node.setJSType(type);
        this.deferredSetTypes.add(new DeferredSetType(node, type));
    }

    void resolveTypes() {
        for (DeferredSetType deferred : this.deferredSetTypes) {
            deferred.resolve();
        }
        for (TypedScope scope : this.getAllMemoizedScopes()) {
            for (TypedVar var : scope.getVarIterable()) {
                var.resolveType(this.typeParsingErrorReporter);
            }
        }
        this.typeRegistry.resolveTypes();
    }

    private JSType getNativeType(JSTypeNative nativeType) {
        return this.typeRegistry.getNativeType(nativeType);
    }

    @Override
    public boolean hasBlockScope() {
        return true;
    }

    private class FirstOrderFunctionAnalyzer
    extends NodeTraversal.AbstractScopedCallback {
        private FirstOrderFunctionAnalyzer() {
        }

        void process(Node externs, Node root) {
            if (externs == null) {
                NodeTraversal.traverse(TypedScopeCreator.this.compiler, root, this);
            } else {
                NodeTraversal.traverseRoots(TypedScopeCreator.this.compiler, this, externs, root);
            }
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (t.inGlobalScope()) {
                return;
            }
            Scope containerScope = (Scope)t.getClosestContainerScope();
            if (n.isReturn() && n.hasChildren() || NodeUtil.isBlocklessArrowFunctionResult(n)) {
                TypedScopeCreator.this.functionsWithNonEmptyReturns.add(containerScope.getRootNode());
            }
            if (n.isName() && NodeUtil.isLValue(n) && !NodeUtil.isBleedingFunctionName(n)) {
                Scope ownerScope;
                String name = n.getString();
                Scope scope = t.getScope();
                Var var = (Var)scope.getVar(name);
                if (var != null && (ownerScope = (Scope)var.getScope()).isLocal()) {
                    ScopedName scopedName = ScopedName.of(name, ownerScope.getRootNode());
                    TypedScopeCreator.this.assignedVarNames.add(scopedName);
                    if (!containerScope.hasSameContainerScope(ownerScope)) {
                        TypedScopeCreator.this.escapedVarNames.add(scopedName);
                    }
                }
            } else if (n.isGetProp() && n.isUnscopedQualifiedName() && NodeUtil.isLValue(n)) {
                Scope ownerScope;
                String name = NodeUtil.getRootOfQualifiedName(n).getString();
                Scope scope = t.getScope();
                Var var = (Var)scope.getVar(name);
                if (var != null && (ownerScope = (Scope)var.getScope()).isLocal() && !containerScope.hasSameContainerScope(ownerScope)) {
                    TypedScopeCreator.this.escapedVarNames.add(ScopedName.of(n.getQualifiedName(), ownerScope.getRootNode()));
                }
            }
        }
    }

    private final class ClassScopeBuilder
    extends AbstractScopeBuilder {
        ClassScopeBuilder(TypedScope scope) {
            super(scope);
        }

        @Override
        void visitPreorder(NodeTraversal t, Node n, Node parent) {
            if (n.isFunction()) {
                if (parent.getString().equals("constructor")) {
                    TypedScopeCreator.this.setDeferredType(n, this.currentScope.getRootNode().getJSType());
                } else {
                    this.defineFunctionLiteral(n);
                }
            }
        }

        @Override
        void visitPostorder(NodeTraversal t, Node n, Node parent) {
            if (n.isName() && parent == this.currentScope.getRootNode() && NodeUtil.isClassExpression(parent)) {
                Preconditions.checkState(!n.getString().isEmpty());
                new AbstractScopeBuilder.SlotDefiner().forDeclarationNode(n).readVariableNameFromDeclarationNode().inScope(this.currentScope).withType(parent.getJSType()).allowLaterTypeInference(false).defineSlot();
            } else if (n.isMemberFunctionDef() && !"constructor".equals(n.getString())) {
                this.defineMemberFunction(n);
            }
        }

        void defineMemberFunction(Node n) {
            Node ownerNode = n.getGrandparent();
            Preconditions.checkState(ownerNode.isClass());
            ObjectType ownerType = ownerNode.getJSType().toMaybeFunctionType();
            if (!n.isStaticMember()) {
                ownerType = ownerType.getPrototype();
            }
            ownerType.defineDeclaredProperty(n.getString(), n.getLastChild().getJSType(), n);
        }
    }

    private final class FunctionScopeBuilder
    extends AbstractScopeBuilder {
        FunctionScopeBuilder(TypedScope scope) {
            super(scope);
        }

        @Override
        void visitPreorder(NodeTraversal t, Node n, Node parent) {
            if (parent == null) {
                this.handleFunctionInputs();
            } else if (n.isFunction()) {
                this.defineFunctionLiteral(n);
            }
        }

        void handleFunctionInputs() {
            TypedVar fnVar;
            Node fnNode = this.currentScope.getRootNode();
            Node fnNameNode = fnNode.getFirstChild();
            String fnName = fnNameNode.getString();
            if (!fnName.isEmpty() && ((fnVar = (TypedVar)this.currentScope.getVar(fnName)) == null || fnVar.getNameNode() != null && fnVar.getInitialValue() != fnNode)) {
                new AbstractScopeBuilder.SlotDefiner().forDeclarationNode(fnNameNode).forVariableName(fnName).inScope(this.currentScope).withType(fnNode.getJSType()).allowLaterTypeInference(false).defineSlot();
            }
            this.declareArguments();
        }

        void declareArguments() {
            FunctionType functionType;
            Node functionNode = this.currentScope.getRootNode();
            Node astParameters = functionNode.getSecondChild();
            Node iifeArgumentNode = null;
            if (NodeUtil.isInvocationTarget(functionNode)) {
                iifeArgumentNode = functionNode.getNext();
            }
            if ((functionType = JSType.toMaybeFunctionType(functionNode.getJSType())) != null) {
                Iterable<String> templateNames;
                JSDocInfo info;
                Node jsDocParameters = functionType.getParametersNode();
                if (jsDocParameters != null) {
                    Node jsDocParameter = jsDocParameters.getFirstChild();
                    for (Node astParameter : astParameters.children()) {
                        boolean inferred;
                        boolean isRestParameter = false;
                        if (astParameter.isRest()) {
                            astParameter = astParameter.getOnlyChild();
                            isRestParameter = true;
                        }
                        Preconditions.checkState(astParameter.isName(), astParameter);
                        JSType paramType = jsDocParameter == null ? TypedScopeCreator.this.unknownType : jsDocParameter.getJSType();
                        boolean bl = inferred = paramType == null || paramType.equals(TypedScopeCreator.this.unknownType);
                        if (isRestParameter) {
                            ObjectType arrayType = TypedScopeCreator.this.typeRegistry.getNativeObjectType(JSTypeNative.ARRAY_TYPE);
                            paramType = TypedScopeCreator.this.typeRegistry.createTemplatizedType(arrayType, paramType);
                        }
                        if (iifeArgumentNode != null && inferred) {
                            TypedVar argumentVar;
                            String argumentName = iifeArgumentNode.getQualifiedName();
                            TypedVar typedVar = argumentVar = argumentName == null || this.currentScope.getParent() == null ? null : (TypedVar)this.currentScope.getParent().getVar(argumentName);
                            if (argumentVar != null && !argumentVar.isTypeInferred()) {
                                paramType = argumentVar.getType();
                            }
                        }
                        if (paramType == null) {
                            paramType = TypedScopeCreator.this.unknownType;
                        }
                        new AbstractScopeBuilder.SlotDefiner().forDeclarationNode(astParameter).readVariableNameFromDeclarationNode().inScope(this.currentScope).withType(paramType).allowLaterTypeInference(inferred).defineSlot();
                        if (jsDocParameter != null) {
                            jsDocParameter = jsDocParameter.getNext();
                        }
                        if (iifeArgumentNode == null) continue;
                        iifeArgumentNode = iifeArgumentNode.getNext();
                    }
                }
                if ((info = NodeUtil.getBestJSDocInfo(functionNode)) != null && !Iterables.isEmpty(templateNames = Iterables.concat(info.getTemplateTypeNames(), info.getTypeTransformations().keySet()))) {
                    CompilerInput input = this.getCompilerInput();
                    JSType voidType = TypedScopeCreator.this.typeRegistry.getNativeType(JSTypeNative.VOID_TYPE);
                    for (String name : templateNames) {
                        if (!this.currentScope.canDeclare(name)) {
                            TypedScopeCreator.this.validator.expectUndeclaredVariable(NodeUtil.getSourceName(functionNode), input, functionNode, functionNode.getParent(), (TypedVar)this.currentScope.getVar(name), name, voidType);
                        }
                        this.currentScope.declare(name, functionNode, voidType, input, false);
                    }
                }
            }
        }
    }

    private final class NormalScopeBuilder
    extends AbstractScopeBuilder {
        NormalScopeBuilder(TypedScope scope) {
            super(scope);
        }

        @Override
        void visitPreorder(NodeTraversal t, Node n, Node parent) {
            if (NodeUtil.isStatementParent(n)) {
                for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
                    if (!NodeUtil.isHoistedFunctionDeclaration(child)) continue;
                    this.defineFunctionLiteral(child);
                }
            }
            if (parent != null && NodeUtil.createsBlockScope(n) && !n.isClass()) {
                TypedScopeCreator.this.createScope(n, (AbstractScope)this.currentScope);
            }
            if (n.isFunction() && !NodeUtil.isHoistedFunctionDeclaration(n)) {
                this.defineFunctionLiteral(n);
            }
        }

        @Override
        void visitPostorder(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case CALL: {
                    this.checkForClassDefiningCalls(n);
                    break;
                }
                case ASSIGN: {
                    Node firstChild = n.getFirstChild();
                    if (!firstChild.isGetProp() || !firstChild.isQualifiedName()) break;
                    this.maybeDeclareQualifiedName(t, n.getJSDocInfo(), firstChild, n, firstChild.getNext());
                    break;
                }
                case CATCH: {
                    this.defineCatch(n);
                    break;
                }
                case LET: 
                case CONST: 
                case VAR: {
                    this.defineVars(n);
                    if (!n.hasOneChild()) break;
                    this.checkForTypedef(n.getFirstChild(), n.getJSDocInfo());
                    break;
                }
                case GETPROP: {
                    TypedScopeCreator.this.codingConvention.checkForCallingConventionDefinitions(n, TypedScopeCreator.this.delegateCallingConventions);
                    if (!parent.isExprResult() || !n.isQualifiedName()) break;
                    this.maybeDeclareQualifiedName(t, n.getJSDocInfo(), n, parent, null);
                    break;
                }
            }
        }
    }

    private abstract class AbstractScopeBuilder
    implements NodeTraversal.Callback {
        final TypedScope currentScope;
        final TypedScope currentHoistScope;
        private String sourceName = null;
        private InputId inputId;
        final Multimap<Node, Runnable> deferredActions = HashMultimap.create();

        AbstractScopeBuilder(TypedScope scope) {
            this.currentScope = scope;
            this.currentHoistScope = (TypedScope)scope.getClosestHoistScope();
        }

        CompilerInput getCompilerInput() {
            return TypedScopeCreator.this.compiler.getInput(this.inputId);
        }

        void build() {
            new NodeTraversal(TypedScopeCreator.this.compiler, this, ScopeCreator.ASSERT_NO_SCOPES_CREATED).traverseAtScope(this.currentScope);
        }

        @Override
        public final boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            this.inputId = t.getInputId();
            if (n.isFunction() || n.isScript() || parent == null && this.inputId != null) {
                Preconditions.checkNotNull(this.inputId);
                this.sourceName = NodeUtil.getSourceName(n);
            }
            if (parent == null || this.inCurrentScope(t)) {
                this.visitPreorder(t, n, parent);
                return true;
            }
            return false;
        }

        private boolean inCurrentScope(NodeTraversal t) {
            Node traversalScopeRoot = t.getScopeRoot();
            if (traversalScopeRoot.isScript()) {
                return this.currentScope.isGlobal();
            }
            return traversalScopeRoot == this.currentScope.getRootNode();
        }

        @Override
        public final void visit(NodeTraversal t, Node n, Node parent) {
            this.inputId = t.getInputId();
            if (parent != null) {
                this.attachLiteralTypes(n);
                this.visitPostorder(t, n, parent);
                if (this.deferredActions.containsKey(n)) {
                    this.deferredActions.removeAll(n).stream().forEach(Runnable::run);
                }
            } else if (!this.deferredActions.isEmpty()) {
                this.deferredActions.values().stream().forEach(Runnable::run);
            }
        }

        void visitPreorder(NodeTraversal t, Node n, Node parent) {
        }

        void visitPostorder(NodeTraversal t, Node n, Node parent) {
        }

        void attachLiteralTypes(Node n) {
            switch (n.getToken()) {
                case NULL: {
                    n.setJSType(TypedScopeCreator.this.getNativeType(JSTypeNative.NULL_TYPE));
                    break;
                }
                case VOID: {
                    n.setJSType(TypedScopeCreator.this.getNativeType(JSTypeNative.VOID_TYPE));
                    break;
                }
                case STRING: {
                    n.setJSType(TypedScopeCreator.this.getNativeType(JSTypeNative.STRING_TYPE));
                    break;
                }
                case NUMBER: {
                    n.setJSType(TypedScopeCreator.this.getNativeType(JSTypeNative.NUMBER_TYPE));
                    break;
                }
                case TRUE: 
                case FALSE: {
                    n.setJSType(TypedScopeCreator.this.getNativeType(JSTypeNative.BOOLEAN_TYPE));
                    break;
                }
                case REGEXP: {
                    n.setJSType(TypedScopeCreator.this.getNativeType(JSTypeNative.REGEXP_TYPE));
                    break;
                }
                case OBJECTLIT: {
                    JSDocInfo info = n.getJSDocInfo();
                    if (info != null && info.getLendsName() != null) {
                        this.deferredActions.put(NodeUtil.getEnclosingStatement(n), () -> this.defineObjectLiteral(n));
                        break;
                    }
                    this.defineObjectLiteral(n);
                    break;
                }
                case CLASS: {
                    this.defineClassLiteral(n);
                    break;
                }
                case ARRAYLIT: {
                    n.setJSType(TypedScopeCreator.this.getNativeType(JSTypeNative.ARRAY_TYPE));
                    break;
                }
            }
        }

        private void defineObjectLiteral(Node objectLit) {
            boolean createEnumType;
            JSType type = null;
            JSDocInfo info = objectLit.getJSDocInfo();
            if (info != null && info.getLendsName() != null) {
                String lendsName = info.getLendsName();
                TypedVar lendsVar = (TypedVar)this.currentScope.getVar(lendsName);
                if (lendsVar == null) {
                    TypedScopeCreator.this.report(JSError.make(objectLit, UNKNOWN_LENDS, lendsName));
                } else {
                    type = lendsVar.getType();
                    if (type == null) {
                        type = TypedScopeCreator.this.unknownType;
                    }
                    if (!type.isSubtypeOf(TypedScopeCreator.this.typeRegistry.getNativeType(JSTypeNative.OBJECT_TYPE))) {
                        TypedScopeCreator.this.report(JSError.make(objectLit, LENDS_ON_NON_OBJECT, lendsName, type.toString()));
                        type = null;
                    } else {
                        objectLit.setJSType(type);
                    }
                }
            }
            boolean bl = createEnumType = (info = NodeUtil.getBestJSDocInfo(objectLit)) != null && info.hasEnumParameterType();
            if (createEnumType) {
                Node lValue = NodeUtil.getBestLValue(objectLit);
                String lValueName = NodeUtil.getBestLValueName(lValue);
                type = this.createEnumTypeFromNodes(objectLit, lValueName, info);
            }
            if (type == null) {
                type = TypedScopeCreator.this.typeRegistry.createAnonymousObjectType(info);
            }
            TypedScopeCreator.this.setDeferredType(objectLit, type);
            this.processObjectLitProperties(objectLit, ObjectType.cast(objectLit.getJSType()), !createEnumType);
        }

        void processObjectLitProperties(Node objLit, ObjectType objLitType, boolean declareOnOwner) {
            for (Node keyNode = objLit.getFirstChild(); keyNode != null; keyNode = keyNode.getNext()) {
                if (keyNode.isComputedProp()) continue;
                Node value = keyNode.getFirstChild();
                String memberName = NodeUtil.getObjectLitKeyName(keyNode);
                JSDocInfo info = keyNode.getJSDocInfo();
                JSType valueType = this.getDeclaredType(info, keyNode, value);
                JSType keyType = objLitType.isEnumType() ? objLitType.toMaybeEnumType().getElementsType() : TypeCheck.getObjectLitKeyTypeFromValueType(keyNode, valueType);
                String qualifiedName = NodeUtil.getBestLValueName(keyNode);
                if (qualifiedName != null) {
                    new SlotDefiner().forDeclarationNode(keyNode).forVariableName(qualifiedName).inScope(this.getLValueRootScope(keyNode)).withType(keyType).allowLaterTypeInference(keyType == null).defineSlot();
                } else if (keyType != null) {
                    TypedScopeCreator.this.setDeferredType(keyNode, keyType);
                }
                if (keyType == null || objLitType == null || !declareOnOwner) continue;
                objLitType.defineDeclaredProperty(memberName, keyType, keyNode);
            }
        }

        private JSType getDeclaredTypeInAnnotation(Node node, JSDocInfo info) {
            TypedVar ownerVar;
            Preconditions.checkArgument(info.hasType());
            ImmutableList<TemplateType> ownerTypeKeys = ImmutableList.of();
            Node ownerNode = NodeUtil.getBestLValueOwner(node);
            String ownerName = NodeUtil.getBestLValueName(ownerNode);
            ObjectType ownerType = null;
            if (ownerName != null && (ownerVar = (TypedVar)this.currentScope.getVar(ownerName)) != null && (ownerType = this.getPrototypeOwnerType(ObjectType.cast(ownerVar.getType()))) != null) {
                ownerTypeKeys = ownerType.getTemplateTypeMap().getTemplateKeys();
            }
            TypedScope templateScope = !ownerTypeKeys.isEmpty() ? TypedScopeCreator.this.typeRegistry.createScopeWithTemplates(this.currentScope, ownerTypeKeys) : this.currentScope;
            return info.getType().evaluate(templateScope, TypedScopeCreator.this.typeRegistry);
        }

        void assertDefinitionNode(Node n, Token type) {
            Preconditions.checkState(this.sourceName != null);
            Preconditions.checkState(n.getToken() == type, n);
        }

        void defineCatch(Node n) {
            this.assertDefinitionNode(n, Token.CATCH);
            for (Node catchName : NodeUtil.findLhsNodesInNode(n)) {
                JSType type = this.getDeclaredType(catchName.getJSDocInfo(), catchName, null);
                new SlotDefiner().forDeclarationNode(catchName).forVariableName(catchName.getString()).inScope(this.currentScope).withType(type).allowLaterTypeInference(type == null).defineSlot();
            }
        }

        void defineVars(Node n) {
            Preconditions.checkState(this.sourceName != null);
            Preconditions.checkState(NodeUtil.isNameDeclaration(n));
            JSDocInfo info = n.getJSDocInfo();
            TypedScope scope = n.isVar() ? this.currentHoistScope : this.currentScope;
            List<Node> varNames = NodeUtil.findLhsNodesInNode(n);
            if (varNames.size() == 1) {
                Node singleVarName = varNames.get(0);
                if (info == null) {
                    info = singleVarName.getJSDocInfo();
                }
                this.defineName(singleVarName, scope, info);
            } else {
                if (info != null) {
                    TypedScopeCreator.this.report(JSError.make(n, TypeCheck.MULTIPLE_VAR_DEF, new String[0]));
                }
                for (Node nameNode : varNames) {
                    this.defineName(nameNode, scope, nameNode.getJSDocInfo());
                }
            }
        }

        void defineClassLiteral(Node n) {
            this.assertDefinitionNode(n, Token.CLASS);
            Node lValue = NodeUtil.getBestLValue(n);
            JSDocInfo info = NodeUtil.getBestJSDocInfo(n);
            String className = NodeUtil.getBestLValueName(lValue);
            FunctionType classType = this.createClassTypeFromNodes(n, className, info, lValue);
            TypedScopeCreator.this.setDeferredType(n, classType);
            if (NodeUtil.isClassDeclaration(n)) {
                Preconditions.checkNotNull(className);
                new SlotDefiner().forDeclarationNode(n.getFirstChild()).forVariableName(className).inScope(this.currentScope).withType(classType).allowLaterTypeInference(classType == null).defineSlot();
            }
        }

        void defineFunctionLiteral(Node n) {
            this.assertDefinitionNode(n, Token.FUNCTION);
            Node lValue = NodeUtil.getBestLValue(n);
            JSDocInfo info = NodeUtil.getBestJSDocInfo(n);
            String functionName = NodeUtil.getBestLValueName(lValue);
            FunctionType functionType = this.createFunctionTypeFromNodes(n, functionName, info, lValue);
            TypedScopeCreator.this.setDeferredType(n, functionType);
            if (NodeUtil.isFunctionDeclaration(n)) {
                new SlotDefiner().forDeclarationNode(n.getFirstChild()).forVariableName(functionName).inScope(this.currentScope).withType(functionType).allowLaterTypeInference(functionType == null).defineSlot();
            }
        }

        private void defineName(Node name, TypedScope scope, JSDocInfo info) {
            Node value = name.getFirstChild();
            JSType type = this.getDeclaredType(info, name, value);
            if (type == null) {
                type = name.isFromExterns() ? TypedScopeCreator.this.unknownType : null;
            }
            new SlotDefiner().forDeclarationNode(name).forVariableName(name.getString()).inScope(scope).withType(type).allowLaterTypeInference(type == null).defineSlot();
        }

        private boolean shouldUseFunctionLiteralType(FunctionType type, JSDocInfo info, Node lValue) {
            if (info != null) {
                return true;
            }
            if (lValue != null && NodeUtil.isObjectLitKey(lValue)) {
                return false;
            }
            return this.isLValueRootedInGlobalScope(lValue) || !type.isReturnTypeInferred();
        }

        private FunctionType createClassTypeFromNodes(Node n, @Nullable String name, @Nullable JSDocInfo info, @Nullable Node lvalueNode) {
            FunctionTypeBuilder builder = new FunctionTypeBuilder(name, TypedScopeCreator.this.compiler, n, this.currentScope).usingClassSyntax().setContents(new FunctionTypeBuilder.AstFunctionContents(n)).setDeclarationScope(lvalueNode != null ? this.getLValueRootScope(lvalueNode) : null).inferKind(info).inferTemplateTypeName(info, null);
            Node extendsClause = n.getSecondChild();
            Node classMembers = n.getLastChild();
            ObjectType baseType = this.findSuperClassFromNodes(extendsClause, info);
            builder.inferInheritance(info, baseType);
            Node constructor = NodeUtil.getFirstPropMatchingKey(classMembers, "constructor");
            if (constructor != null) {
                JSDocInfo ctorInfo = NodeUtil.getBestJSDocInfo(constructor);
                builder.inferConstructorParameters(constructor.getSecondChild(), ctorInfo);
            } else if (extendsClause.isEmpty()) {
                builder.inferImplicitConstructorParameters(new Node(Token.PARAM_LIST));
            } else {
                FunctionType extendsCtor;
                FunctionType functionType = extendsCtor = baseType != null ? baseType.getConstructor() : null;
                if (extendsCtor != null) {
                    builder.inferImplicitConstructorParameters(extendsCtor.getParametersNode().cloneTree());
                } else {
                    builder.inferImplicitConstructorParameters(TypedScopeCreator.this.typeRegistry.createParametersWithVarArgs(TypedScopeCreator.this.typeRegistry.getNativeType(JSTypeNative.UNKNOWN_TYPE)));
                }
            }
            return builder.buildAndRegister();
        }

        @Nullable
        private ObjectType findSuperClassFromNodes(Node extendsNode, @Nullable JSDocInfo info) {
            if (extendsNode.isEmpty()) {
                return null;
            }
            JSType ctorType = extendsNode.getJSType();
            if (ctorType == null) {
                if (extendsNode.isQualifiedName()) {
                    TypedVar var = (TypedVar)this.currentScope.getVar(extendsNode.getQualifiedName());
                    if (var != null) {
                        ctorType = var.getType();
                    }
                } else if (info == null || !info.hasBaseType()) {
                    TypedScopeCreator.this.report(JSError.make(extendsNode, DYNAMIC_EXTENDS_WITHOUT_JSDOC, new String[0]));
                }
            }
            if (ctorType != null && (ctorType.isConstructor() || ctorType.isInterface())) {
                return ctorType.toMaybeFunctionType().getInstanceType();
            }
            return null;
        }

        private FunctionType createFunctionTypeFromNodes(@Nullable Node rValue, @Nullable String name, @Nullable JSDocInfo info, @Nullable Node lvalueNode) {
            FunctionTypeBuilder.AstFunctionContents contents;
            TypedVar ownerVar;
            FunctionType aliasedType;
            TypedVar var;
            if (rValue != null && rValue.isQualifiedName() && lvalueNode != null && (var = (TypedVar)this.currentScope.getVar(rValue.getQualifiedName())) != null && var.getType() != null && var.getType().isFunctionType() && ((aliasedType = var.getType().toMaybeFunctionType()).isConstructor() || aliasedType.isInterface())) {
                if (name != null) {
                    TypedScopeCreator.this.typeRegistry.declareType(this.currentScope, name, aliasedType.getInstanceType());
                }
                this.checkFunctionAliasAnnotations(lvalueNode, aliasedType, info);
                return aliasedType;
            }
            if (info != null && info.hasType()) {
                JSType type = info.getType().evaluate(this.currentScope, TypedScopeCreator.this.typeRegistry);
                if ((type = type.restrictByNotNullOrUndefined()).isFunctionType()) {
                    FunctionType functionType = type.toMaybeFunctionType();
                    functionType.setJSDocInfo(info);
                    return functionType;
                }
            }
            Node errorRoot = rValue == null ? lvalueNode : rValue;
            boolean isFnLiteral = rValue != null && rValue.isFunction();
            Node fnRoot = isFnLiteral ? rValue : null;
            Node parametersNode = isFnLiteral ? rValue.getSecondChild() : null;
            Node classRoot = lvalueNode != null && lvalueNode.getParent().isClassMembers() ? lvalueNode.getGrandparent() : null;
            Node ownerNode = NodeUtil.getBestLValueOwner(lvalueNode);
            String ownerName = NodeUtil.getBestLValueName(ownerNode);
            ObjectType ownerType = null;
            if (ownerNode != null && classRoot != null) {
                ownerType = JSType.toMaybeFunctionType(classRoot.getJSType());
                if (!lvalueNode.isStaticMember() && ownerType != null) {
                    ownerType = ((FunctionType)ownerType).getPrototype();
                    ownerName = ownerName + ".prototype";
                }
            } else if (ownerName != null && (ownerVar = (TypedVar)this.currentScope.getVar(ownerName)) != null) {
                ownerType = ObjectType.cast(ownerVar.getType());
            }
            String propName = null;
            if (ownerName != null && name != null) {
                propName = name.substring(ownerName.length() + 1);
            }
            ObjectType prototypeOwner = this.getPrototypeOwnerType(ownerType);
            TemplateTypeMap prototypeOwnerTypeMap = null;
            if (prototypeOwner != null && prototypeOwner.getTypeOfThis() != null) {
                prototypeOwnerTypeMap = prototypeOwner.getTypeOfThis().getTemplateTypeMap();
            }
            FunctionType overriddenType = null;
            if (ownerType != null && propName != null) {
                overriddenType = this.findOverriddenFunction(ownerType, propName, prototypeOwnerTypeMap);
            }
            FunctionTypeBuilder.AstFunctionContents astFunctionContents = contents = fnRoot != null ? new FunctionTypeBuilder.AstFunctionContents(fnRoot) : null;
            if (TypedScopeCreator.this.functionsWithNonEmptyReturns.contains(fnRoot)) {
                contents.recordNonEmptyReturn();
            }
            FunctionTypeBuilder builder = new FunctionTypeBuilder(name, TypedScopeCreator.this.compiler, errorRoot, this.currentScope).setContents(contents).setDeclarationScope(lvalueNode != null ? this.getLValueRootScope(lvalueNode) : null).inferFromOverriddenFunction(overriddenType, parametersNode).inferKind(info).inferTemplateTypeName(info, prototypeOwner).inferInheritance(info, null);
            if (info == null || !info.hasReturnType()) {
                if (rValue != null && rValue.isFunction() && rValue.getFirstChild() != null) {
                    JSDocInfo nameDocInfo = rValue.getFirstChild().getJSDocInfo();
                    builder.inferReturnType(nameDocInfo, true);
                }
            } else {
                builder.inferReturnType(info, false);
            }
            if (ownerType != null && ownerType.isFunctionPrototypeType() && ownerType.getOwnerFunction().hasInstanceType()) {
                builder.inferThisType(info, ownerType.getOwnerFunction().getInstanceType());
            } else if (ownerNode != null && ownerNode.isThis()) {
                builder.inferThisType(info, this.currentScope.getTypeOfThis());
            } else {
                builder.inferThisType(info);
            }
            return builder.inferParameterTypes(parametersNode, info).buildAndRegister();
        }

        private void checkFunctionAliasAnnotations(Node n, FunctionType type, JSDocInfo info) {
            if (info == null) {
                return;
            }
            String annotation = null;
            if (info.usesImplicitMatch()) {
                if (!type.isStructuralInterface()) {
                    annotation = "@record";
                }
            } else if (info.isInterface()) {
                if (!type.isInterface()) {
                    annotation = "@interface";
                }
            } else if (info.isConstructor() && !type.isConstructor()) {
                annotation = "@constructor";
            }
            if (annotation != null && (!n.isFromExterns() || annotation.equals("@record"))) {
                TypedScopeCreator.this.report(JSError.make(n, INCOMPATIBLE_ALIAS_ANNOTATION, annotation, n.getQualifiedName()));
            }
        }

        private ObjectType getPrototypeOwnerType(ObjectType ownerType) {
            if (ownerType != null && ownerType.isFunctionPrototypeType()) {
                return ownerType.getOwnerFunction();
            }
            return null;
        }

        private FunctionType findOverriddenFunction(ObjectType ownerType, String propName, TemplateTypeMap typeMap) {
            FunctionType result = null;
            JSType propType = ownerType.getPropertyType(propName);
            if (propType != null && propType.isFunctionType()) {
                result = propType.toMaybeFunctionType();
            } else {
                for (ObjectType iface : ownerType.getCtorImplementedInterfaces()) {
                    propType = iface.getPropertyType(propName);
                    if (propType == null || !propType.isFunctionType()) continue;
                    result = propType.toMaybeFunctionType();
                    break;
                }
            }
            if (result != null && typeMap != null && !typeMap.isEmpty()) {
                result = result.visit(new TemplateTypeMapReplacer(TypedScopeCreator.this.typeRegistry, typeMap)).toMaybeFunctionType();
            }
            return result;
        }

        private EnumType createEnumTypeFromNodes(Node rValue, String name, JSDocInfo info) {
            TypedVar var;
            Preconditions.checkNotNull(info);
            Preconditions.checkState(info.hasEnumParameterType());
            EnumType enumType = null;
            if (rValue != null && rValue.isQualifiedName() && (var = (TypedVar)this.currentScope.getVar(rValue.getQualifiedName())) != null && var.getType() instanceof EnumType) {
                enumType = (EnumType)var.getType();
            }
            if (enumType == null) {
                JSType elementsType = info.getEnumParameterType().evaluate(this.currentScope, TypedScopeCreator.this.typeRegistry);
                enumType = TypedScopeCreator.this.typeRegistry.createEnumType(name, rValue, elementsType);
                if (rValue != null && rValue.isObjectLit()) {
                    Node key = rValue.getFirstChild();
                    while (key != null) {
                        if (key.isComputedProp()) {
                            TypedScopeCreator.this.report(JSError.make(key, INVALID_ENUM_KEY, new String[0]));
                            key = key.getNext();
                            continue;
                        }
                        String keyName = key.getString();
                        Preconditions.checkNotNull(keyName, "Invalid enum key: %s", (Object)key);
                        enumType.defineElement(keyName, key);
                        key = key.getNext();
                    }
                }
            }
            if (name != null) {
                TypedScopeCreator.this.typeRegistry.declareType(this.currentScope, name, enumType.getElementsType());
            }
            return enumType;
        }

        private TypedVar declare(TypedScope scope, String name, Node n, JSType type, CompilerInput input, boolean inferred) {
            TypedVar var = scope.declare(name, n, type, input, inferred);
            ScopedName scopedName = ScopedName.of(name, scope.getRootNode());
            if (TypedScopeCreator.this.escapedVarNames.contains(scopedName)) {
                var.markEscaped();
            }
            if (TypedScopeCreator.this.assignedVarNames.count(scopedName) == 1) {
                var.markAssignedExactlyOnce();
            }
            return var;
        }

        private void finishConstructorDefinition(Node n, String variableName, FunctionType fnType, TypedScope scopeToDeclareIn, CompilerInput input, TypedVar newVar) {
            FunctionType superClassCtor = fnType.getSuperClassConstructor();
            Property prototypeSlot = fnType.getSlot("prototype");
            prototypeSlot.setNode(n);
            String prototypeName = variableName + ".prototype";
            TypedVar prototypeVar = (TypedVar)scopeToDeclareIn.getVar(prototypeName);
            if (prototypeVar != null && prototypeVar.scope == scopeToDeclareIn) {
                scopeToDeclareIn.undeclare(prototypeVar);
            }
            scopeToDeclareIn.declare(prototypeName, n, prototypeSlot.getType(), input, superClassCtor == null || superClassCtor.getInstanceType().isEquivalentTo(TypedScopeCreator.this.getNativeType(JSTypeNative.OBJECT_TYPE)));
            if (newVar.getInitialValue() == null && !n.isFromExterns()) {
                TypedScopeCreator.this.report(JSError.make(n, fnType.isConstructor() ? CTOR_INITIALIZER : IFACE_INITIALIZER, variableName));
            }
        }

        private boolean isLValueRootedInGlobalScope(Node n) {
            return this.getLValueRootScope(n).isGlobal();
        }

        private TypedScope getLValueRootScope(Node n) {
            Node root = NodeUtil.getBestLValueRoot(n);
            if (root != null) {
                if (root.isName()) {
                    Node nameParent = root.getParent();
                    switch (nameParent.getToken()) {
                        case VAR: {
                            return this.currentHoistScope;
                        }
                        case LET: 
                        case CONST: 
                        case CLASS: 
                        case FUNCTION: 
                        case PARAM_LIST: 
                        case CATCH: {
                            return this.currentScope;
                        }
                        case REST: {
                            Preconditions.checkState(nameParent.getParent().isParamList(), nameParent);
                            return this.currentScope;
                        }
                    }
                    TypedVar var = (TypedVar)this.currentScope.getVar(root.getString());
                    if (var != null) {
                        return (TypedScope)var.getScope();
                    }
                } else if (root.isThis() || root.isSuper()) {
                    return this.currentHoistScope;
                }
            }
            return (TypedScope)this.currentHoistScope.getGlobalScope();
        }

        JSType getDeclaredType(JSDocInfo info, Node lValue, @Nullable Node rValue) {
            if (info != null && info.hasType()) {
                return this.getDeclaredTypeInAnnotation(lValue, info);
            }
            if (rValue != null && rValue.isFunction() && this.shouldUseFunctionLiteralType(JSType.toMaybeFunctionType(rValue.getJSType()), info, lValue)) {
                return rValue.getJSType();
            }
            if (rValue != null && rValue.isClass()) {
                return rValue.getJSType();
            }
            if (info != null) {
                if (info.hasEnumParameterType()) {
                    if (rValue != null && rValue.isObjectLit()) {
                        return rValue.getJSType();
                    }
                    return this.createEnumTypeFromNodes(rValue, lValue.getQualifiedName(), info);
                }
                if (info.isConstructorOrInterface()) {
                    return this.createFunctionTypeFromNodes(rValue, lValue.getQualifiedName(), info, lValue);
                }
            }
            if (NodeUtil.isConstantDeclaration(TypedScopeCreator.this.compiler.getCodingConvention(), info, lValue) && rValue != null) {
                JSType rValueType = this.getDeclaredRValueType(lValue, rValue);
                this.maybeDeclareAliasType(lValue, rValue, rValueType);
                if (rValueType != null) {
                    return rValueType;
                }
            }
            if (info != null && FunctionTypeBuilder.isFunctionTypeDeclaration(info)) {
                String fnName = lValue.getQualifiedName();
                return this.createFunctionTypeFromNodes(null, fnName, info, lValue);
            }
            return null;
        }

        private void maybeDeclareAliasType(Node lValue, Node rValue, JSType rValueType) {
            if (!lValue.isQualifiedName() || !rValue.isQualifiedName()) {
                return;
            }
            if (rValueType != null && rValueType.isFunctionType() && rValueType.toMaybeFunctionType().hasInstanceType()) {
                FunctionType functionType = rValueType.toMaybeFunctionType();
                TypedScopeCreator.this.typeRegistry.declareType(this.currentScope, lValue.getQualifiedName(), functionType.getInstanceType());
            } else {
                JSType rhsNamedType = TypedScopeCreator.this.typeRegistry.getType(this.currentScope, rValue.getQualifiedName());
                if (rhsNamedType != null) {
                    TypedScopeCreator.this.typeRegistry.declareType(this.currentScope, lValue.getQualifiedName(), rhsNamedType);
                }
            }
        }

        private JSType getDeclaredRValueType(Node lValue, Node rValue) {
            FunctionType fnType;
            JSType targetType;
            JSDocInfo rValueInfo = rValue.getJSDocInfo();
            if (rValue.isCast() && rValueInfo != null && rValueInfo.hasType()) {
                return rValueInfo.getType().evaluate(this.currentScope, TypedScopeCreator.this.typeRegistry);
            }
            JSType type = rValue.getJSType();
            if (type != null && !type.isUnknownType()) {
                return type;
            }
            if (rValue.isQualifiedName()) {
                return this.lookupQualifiedName(rValue);
            }
            if (NodeUtil.isBooleanResult(rValue)) {
                return TypedScopeCreator.this.getNativeType(JSTypeNative.BOOLEAN_TYPE);
            }
            if (NodeUtil.isNumericResult(rValue)) {
                return TypedScopeCreator.this.getNativeType(JSTypeNative.NUMBER_TYPE);
            }
            if (NodeUtil.isStringResult(rValue)) {
                return TypedScopeCreator.this.getNativeType(JSTypeNative.STRING_TYPE);
            }
            if (rValue.isNew() && rValue.getFirstChild().isQualifiedName() && (targetType = this.lookupQualifiedName(rValue.getFirstChild())) != null && (fnType = targetType.restrictByNotNullOrUndefined().toMaybeFunctionType()) != null && fnType.hasInstanceType()) {
                return fnType.getInstanceType();
            }
            if (rValue.isOr()) {
                boolean namesMatch;
                Node firstClause = rValue.getFirstChild();
                Node secondClause = firstClause.getNext();
                boolean bl = namesMatch = firstClause.isName() && lValue.isName() && firstClause.getString().equals(lValue.getString());
                if (namesMatch && (type = secondClause.getJSType()) != null && !type.isUnknownType()) {
                    return type;
                }
            }
            return null;
        }

        private JSType lookupQualifiedName(Node n) {
            JSType type;
            String name = n.getQualifiedName();
            TypedVar slot = (TypedVar)this.currentScope.getVar(name);
            if (slot != null && !slot.isTypeInferred()) {
                JSType type2 = slot.getType();
                if (type2 != null && !type2.isUnknownType()) {
                    return type2;
                }
            } else if (n.isGetProp() && (type = this.lookupQualifiedName(n.getFirstChild())) != null && type.isRecordType()) {
                JSType propType = type.findPropertyType(n.getLastChild().getString());
                return propType;
            }
            return null;
        }

        void checkForClassDefiningCalls(Node n) {
            CodingConvention.ObjectLiteralCast objectLiteralCast;
            CodingConvention.DelegateRelationship delegateRelationship;
            FunctionType functionType;
            ObjectType objectType;
            String singletonGetterClassName;
            CodingConvention.SubclassRelationship relationship = TypedScopeCreator.this.codingConvention.getClassesDefinedByCall(n);
            if (relationship != null) {
                ObjectType superClass = TypeValidator.getInstanceOfCtor((TypedVar)this.currentScope.getVar(relationship.superclassName));
                ObjectType subClass = TypeValidator.getInstanceOfCtor((TypedVar)this.currentScope.getVar(relationship.subclassName));
                if (superClass != null && subClass != null) {
                    FunctionType superCtor = superClass.getConstructor();
                    FunctionType subCtor = subClass.getConstructor();
                    if (superCtor != null && subCtor != null) {
                        TypedScopeCreator.this.codingConvention.applySubclassRelationship(new NominalTypeBuilderOti(superCtor, superClass), new NominalTypeBuilderOti(subCtor, subClass), relationship.type);
                    }
                }
            }
            if ((singletonGetterClassName = TypedScopeCreator.this.codingConvention.getSingletonGetterClassName(n)) != null && (objectType = ObjectType.cast(TypedScopeCreator.this.typeRegistry.getType(this.currentScope, singletonGetterClassName))) != null && (functionType = objectType.getConstructor()) != null) {
                FunctionType getterType = TypedScopeCreator.this.typeRegistry.createFunctionType((JSType)objectType, new JSType[0]);
                TypedScopeCreator.this.codingConvention.applySingletonGetter(new NominalTypeBuilderOti(functionType, objectType), getterType);
            }
            if ((delegateRelationship = TypedScopeCreator.this.codingConvention.getDelegateRelationship(n)) != null) {
                this.applyDelegateRelationship(delegateRelationship);
            }
            if ((objectLiteralCast = TypedScopeCreator.this.codingConvention.getObjectLiteralCast(n)) != null) {
                if (objectLiteralCast.diagnosticType == null) {
                    ObjectType type = ObjectType.cast(TypedScopeCreator.this.typeRegistry.getType(this.currentScope, objectLiteralCast.typeName));
                    if (type != null && type.getConstructor() != null) {
                        TypedScopeCreator.this.setDeferredType(objectLiteralCast.objectNode, type);
                        objectLiteralCast.objectNode.putBooleanProp((byte)57, true);
                    } else {
                        TypedScopeCreator.this.report(JSError.make(n, CONSTRUCTOR_EXPECTED, new String[0]));
                    }
                } else {
                    TypedScopeCreator.this.report(JSError.make(n, objectLiteralCast.diagnosticType, new String[0]));
                }
            }
        }

        private void applyDelegateRelationship(CodingConvention.DelegateRelationship delegateRelationship) {
            ObjectType delegatorObject = ObjectType.cast(TypedScopeCreator.this.typeRegistry.getType(this.currentScope, delegateRelationship.delegator));
            ObjectType delegateBaseObject = ObjectType.cast(TypedScopeCreator.this.typeRegistry.getType(this.currentScope, delegateRelationship.delegateBase));
            ObjectType delegateSuperObject = ObjectType.cast(TypedScopeCreator.this.typeRegistry.getType(this.currentScope, TypedScopeCreator.this.codingConvention.getDelegateSuperclassName()));
            if (delegatorObject != null && delegateBaseObject != null && delegateSuperObject != null) {
                FunctionType delegatorCtor = delegatorObject.getConstructor();
                FunctionType delegateBaseCtor = delegateBaseObject.getConstructor();
                FunctionType delegateSuperCtor = delegateSuperObject.getConstructor();
                if (delegatorCtor != null && delegateBaseCtor != null && delegateSuperCtor != null) {
                    FunctionParamBuilder functionParamBuilder = new FunctionParamBuilder(TypedScopeCreator.this.typeRegistry);
                    functionParamBuilder.addRequiredParams(TypedScopeCreator.this.getNativeType(JSTypeNative.U2U_CONSTRUCTOR_TYPE));
                    FunctionType findDelegate = TypedScopeCreator.this.typeRegistry.createFunctionType(TypedScopeCreator.this.typeRegistry.createDefaultObjectUnion(delegateBaseObject), functionParamBuilder.build());
                    FunctionType delegateProxy = TypedScopeCreator.this.typeRegistry.createConstructorType(delegateBaseObject.getReferenceName() + DELEGATE_PROXY_SUFFIX, null, null, null, null, false);
                    delegateProxy.setPrototypeBasedOn(delegateBaseObject);
                    TypedScopeCreator.this.codingConvention.applyDelegateRelationship(new NominalTypeBuilderOti(delegateSuperCtor, delegateSuperObject), new NominalTypeBuilderOti(delegateBaseCtor, delegateBaseObject), new NominalTypeBuilderOti(delegatorCtor, delegatorObject), (ObjectType)delegateProxy.getTypeOfThis(), findDelegate);
                    TypedScopeCreator.this.delegateProxyCtors.add(delegateProxy);
                }
            }
        }

        void maybeDeclareQualifiedName(NodeTraversal t, JSDocInfo info, Node n, Node parent, Node rhsValue) {
            TypedVar qVar;
            this.checkForTypedef(n, info);
            Node ownerNode = n.getFirstChild();
            String ownerName = ownerNode.getQualifiedName();
            String qName = n.getQualifiedName();
            String propName = n.getLastChild().getString();
            Preconditions.checkArgument(qName != null && ownerName != null);
            JSType valueType = this.getDeclaredType(info, n, rhsValue);
            if (valueType == null && rhsValue != null) {
                valueType = rhsValue.getJSType();
            }
            if ("prototype".equals(propName) && (qVar = (TypedVar)this.currentScope.getVar(qName)) != null) {
                ObjectType qVarType = ObjectType.cast(qVar.getType());
                if (qVarType != null && rhsValue != null && rhsValue.isObjectLit()) {
                    TypedScopeCreator.this.typeRegistry.resetImplicitPrototype(rhsValue.getJSType(), qVarType.getImplicitPrototype());
                } else if (!qVar.isTypeInferred()) {
                    return;
                }
                ((TypedScope)qVar.getScope()).undeclare(qVar);
            }
            if (valueType == null) {
                if (parent.isExprResult()) {
                    boolean isExtern = t.getInput() != null && t.getInput().isExtern();
                    this.deferredActions.put(this.currentScope.getRootNode(), () -> this.resolveStubDeclaration(n, isExtern, ownerName));
                }
                return;
            }
            boolean inferred = this.isQualifiedNameInferred(qName, n, info, rhsValue, valueType);
            if (!inferred) {
                ObjectType ownerType = this.getObjectSlot(ownerName);
                if (ownerType != null && (!ownerType.hasOwnProperty(propName) || ownerType.isPropertyTypeInferred(propName))) {
                    boolean isNonNativeExtern;
                    boolean bl = isNonNativeExtern = t.getInput() != null && t.getInput().isExtern() && !ownerType.isNativeObjectType();
                    if (isNonNativeExtern || !ownerType.isInstanceType() || ownerNode.isThis()) {
                        ownerType.defineDeclaredProperty(propName, valueType, n);
                    }
                }
                new SlotDefiner().forDeclarationNode(n).readVariableNameFromDeclarationNode().inScope(this.getLValueRootScope(n)).withType(valueType).allowLaterTypeInference(inferred).defineSlot();
            }
        }

        private boolean isQualifiedNameInferred(@Nullable String qName, Node n, @Nullable JSDocInfo info, @Nullable Node rhsValue, JSType valueType) {
            if (qName != null && qName.endsWith(".prototype")) {
                JSType classType;
                String className = qName.substring(0, qName.lastIndexOf(".prototype"));
                TypedVar slot = (TypedVar)this.currentScope.getVar(className);
                JSType jSType = classType = slot == null ? null : slot.getType();
                if (classType != null && (classType.isConstructor() || classType.isInterface())) {
                    return false;
                }
            }
            if (info != null && (info.hasType() || info.hasEnumParameterType() || this.isConstantDeclarationWithKnownType(info, n, valueType) || FunctionTypeBuilder.isFunctionTypeDeclaration(info) || rhsValue != null && rhsValue.isFunction())) {
                return false;
            }
            if (rhsValue == null || !rhsValue.isFunction()) {
                return true;
            }
            if (!n.isUnscopedQualifiedName()) {
                return true;
            }
            TypedScope ownerScope = this.getLValueRootScope(n);
            if (ownerScope != null && ownerScope.hasOwnSlot(qName)) {
                return true;
            }
            if (this.hasControlStructureAncestor(n.getParent())) {
                return true;
            }
            return ownerScope != null && TypedScopeCreator.this.escapedVarNames.contains(ScopedName.of(qName, ownerScope.getRootNode()));
        }

        private boolean isConstantDeclarationWithKnownType(JSDocInfo info, Node n, JSType valueType) {
            return NodeUtil.isConstantDeclaration(TypedScopeCreator.this.compiler.getCodingConvention(), info, n) && valueType != null && !valueType.isUnknownType();
        }

        private boolean hasControlStructureAncestor(Node n) {
            while (!n.isScript() && !n.isFunction()) {
                if (NodeUtil.isControlStructure(n)) {
                    return true;
                }
                n = n.getParent();
            }
            return false;
        }

        private ObjectType getObjectSlot(String slotName) {
            TypedVar ownerVar = (TypedVar)this.currentScope.getVar(slotName);
            if (ownerVar != null) {
                JSType ownerVarType = ownerVar.getType();
                return ObjectType.cast(ownerVarType == null ? null : ownerVarType.restrictByNotNullOrUndefined());
            }
            return null;
        }

        private JSType getInheritedInterfacePropertyType(ObjectType obj, String propName) {
            if (obj != null && obj.isFunctionPrototypeType()) {
                FunctionType f = obj.getOwnerFunction();
                for (ObjectType i : f.getImplementedInterfaces()) {
                    if (!i.hasProperty(propName)) continue;
                    return i.getPropertyType(propName);
                }
            }
            return null;
        }

        void resolveStubDeclaration(Node n, boolean isExtern, String ownerName) {
            String qName = n.getQualifiedName();
            String propName = n.getLastChild().getString();
            if (this.currentScope.hasOwnSlot(qName)) {
                return;
            }
            ObjectType ownerType = this.getObjectSlot(ownerName);
            JSType inheritedType = this.getInheritedInterfacePropertyType(ownerType, propName);
            JSType stubType = inheritedType == null ? TypedScopeCreator.this.unknownType : inheritedType;
            new SlotDefiner().forDeclarationNode(n).readVariableNameFromDeclarationNode().inScope(this.getLValueRootScope(n)).withType(stubType).allowLaterTypeInference(true).defineSlot();
            if (ownerType != null && (isExtern || ownerType.isFunctionPrototypeType())) {
                ownerType.defineInferredProperty(propName, stubType, n);
            } else {
                TypedScopeCreator.this.typeRegistry.registerPropertyOnType(propName, ownerType == null ? stubType : ownerType);
            }
        }

        void checkForTypedef(Node candidate, JSDocInfo info) {
            if (info == null || !info.hasTypedefType()) {
                return;
            }
            String typedef = candidate.getQualifiedName();
            if (typedef == null) {
                return;
            }
            if (this.currentScope.isGlobal() && typedef.equals("symbol")) {
                return;
            }
            TypedScopeCreator.this.typeRegistry.declareType(this.currentScope, typedef, TypedScopeCreator.this.unknownType);
            JSType realType = info.getTypedefType().evaluate(this.currentScope, TypedScopeCreator.this.typeRegistry);
            if (realType == null) {
                TypedScopeCreator.this.report(JSError.make(candidate, MALFORMED_TYPEDEF, typedef));
            }
            TypedScopeCreator.this.typeRegistry.overwriteDeclaredType(this.currentScope, typedef, realType);
            if (candidate.isGetProp()) {
                new SlotDefiner().forDeclarationNode(candidate).readVariableNameFromDeclarationNode().forVariableName(typedef).inScope(this.getLValueRootScope(candidate)).withType(TypedScopeCreator.this.getNativeType(JSTypeNative.NO_TYPE)).allowLaterTypeInference(false).defineSlot();
            }
        }

        class SlotDefiner {
            Node declarationNode;
            String variableName;
            TypedScope scope;
            JSType type = null;
            boolean allowLaterTypeInference = true;

            SlotDefiner() {
            }

            SlotDefiner forDeclarationNode(Node declarationNode) {
                this.declarationNode = declarationNode;
                return this;
            }

            SlotDefiner readVariableNameFromDeclarationNode() {
                Node parent = this.declarationNode.getParent();
                if (this.declarationNode.isName()) {
                    Preconditions.checkArgument(parent.isFunction() || parent.isClass() || NodeUtil.isNameDeclaration(parent) || parent.isParamList() || parent.isRest() && parent.getParent().isParamList() || parent.isCatch());
                } else {
                    Preconditions.checkArgument(this.declarationNode.isGetProp() && (parent.isAssign() || parent.isExprResult()));
                }
                this.variableName = this.declarationNode.getQualifiedName();
                return this;
            }

            SlotDefiner forVariableName(String variableName) {
                this.variableName = variableName;
                return this;
            }

            SlotDefiner inScope(TypedScope scope) {
                this.scope = Preconditions.checkNotNull(scope);
                return this;
            }

            SlotDefiner withType(@Nullable JSType type) {
                this.type = type;
                return this;
            }

            SlotDefiner allowLaterTypeInference(boolean allowLaterTypeInference) {
                this.allowLaterTypeInference = allowLaterTypeInference;
                return this;
            }

            void defineSlot() {
                TypedVar rootVar;
                Preconditions.checkNotNull(this.declarationNode, "declarationNode not set");
                Preconditions.checkNotNull(this.variableName, "variableName not set");
                Preconditions.checkState(this.allowLaterTypeInference || this.type != null, "null type but inference not allowed");
                Preconditions.checkState(!this.variableName.isEmpty());
                Preconditions.checkNotNull(this.scope);
                Node parent = this.declarationNode.getParent();
                TypedScope scopeToDeclareIn = this.scope;
                boolean isGlobalVar = this.declarationNode.isName() && scopeToDeclareIn.isGlobal();
                boolean shouldDeclareOnGlobalThis = isGlobalVar && (parent.isVar() || parent.isFunction());
                TypedScope ownerScope = null;
                if (this.declarationNode.isGetProp()) {
                    ownerScope = scopeToDeclareIn;
                } else if (this.variableName.contains(".") && (rootVar = (TypedVar)AbstractScopeBuilder.this.currentScope.getVar(this.variableName.substring(0, this.variableName.indexOf(46)))) != null) {
                    ownerScope = (TypedScope)rootVar.getScope();
                }
                if (ownerScope != null && scopeToDeclareIn != ownerScope && (!ownerScope.hasOwnSlot(this.variableName) || ownerScope.hasSameContainerScope(scopeToDeclareIn))) {
                    scopeToDeclareIn = ownerScope;
                }
                if (scopeToDeclareIn != AbstractScopeBuilder.this.currentHoistScope && scopeToDeclareIn.isGlobal() && scopeToDeclareIn.hasOwnSlot(this.variableName)) {
                    scopeToDeclareIn = AbstractScopeBuilder.this.currentHoistScope;
                }
                TypedVar newVar = null;
                CompilerInput input = TypedScopeCreator.this.compiler.getInput(AbstractScopeBuilder.this.inputId);
                if (!scopeToDeclareIn.canDeclare(this.variableName)) {
                    TypedVar oldVar = (TypedVar)scopeToDeclareIn.getVar(this.variableName);
                    newVar = TypedScopeCreator.this.validator.expectUndeclaredVariable(AbstractScopeBuilder.this.sourceName, input, this.declarationNode, parent, oldVar, this.variableName, this.type);
                } else {
                    if (this.type != null) {
                        TypedScopeCreator.this.setDeferredType(this.declarationNode, this.type);
                    }
                    newVar = AbstractScopeBuilder.this.declare(scopeToDeclareIn, this.variableName, this.declarationNode, this.type, input, this.allowLaterTypeInference);
                    if (this.type instanceof EnumType) {
                        boolean isValidValue;
                        Node initialValue = newVar.getInitialValue();
                        boolean bl = isValidValue = initialValue != null && (initialValue.isObjectLit() || initialValue.isQualifiedName());
                        if (!isValidValue) {
                            TypedScopeCreator.this.report(JSError.make(this.declarationNode, ENUM_INITIALIZER, new String[0]));
                        }
                    }
                }
                FunctionType fnType = JSType.toMaybeFunctionType(this.type);
                if (fnType != null && !this.type.isEmptyType() && (fnType.isConstructor() || fnType.isInterface()) && this.variableName.equals(fnType.getReferenceName())) {
                    AbstractScopeBuilder.this.finishConstructorDefinition(this.declarationNode, this.variableName, fnType, scopeToDeclareIn, input, newVar);
                }
                if (shouldDeclareOnGlobalThis) {
                    ObjectType globalThis = TypedScopeCreator.this.typeRegistry.getNativeObjectType(JSTypeNative.GLOBAL_THIS);
                    if (this.allowLaterTypeInference) {
                        globalThis.defineInferredProperty(this.variableName, this.type == null ? TypedScopeCreator.this.getNativeType(JSTypeNative.NO_TYPE) : this.type, this.declarationNode);
                    } else {
                        globalThis.defineDeclaredProperty(this.variableName, this.type, this.declarationNode);
                    }
                }
                if (isGlobalVar && "Window".equals(this.variableName) && this.type != null && this.type.isFunctionType() && this.type.isConstructor()) {
                    FunctionType globalThisCtor = TypedScopeCreator.this.typeRegistry.getNativeObjectType(JSTypeNative.GLOBAL_THIS).getConstructor();
                    globalThisCtor.getInstanceType().clearCachedValues();
                    globalThisCtor.getPrototype().clearCachedValues();
                    globalThisCtor.setPrototypeBasedOn(this.type.toMaybeFunctionType().getInstanceType());
                }
            }
        }
    }

    private static class IdentifyGlobalEnumsAndTypedefsAsNonNullable
    extends NodeTraversal.AbstractShallowStatementCallback {
        private final JSTypeRegistry registry;

        IdentifyGlobalEnumsAndTypedefsAsNonNullable(JSTypeRegistry registry) {
            this.registry = registry;
        }

        @Override
        public void visit(NodeTraversal t, Node node, Node parent) {
            switch (node.getToken()) {
                case LET: 
                case CONST: 
                case VAR: {
                    Scope scope = t.getScope();
                    Preconditions.checkState(scope.isGlobal() || ((Scope)scope.getClosestHoistScope()).isGlobal());
                    if (!node.isVar() && !scope.isGlobal()) break;
                    for (Node child = node.getFirstChild(); child != null; child = child.getNext()) {
                        this.identifyNameNode(child, NodeUtil.getBestJSDocInfo(child));
                    }
                    break;
                }
                case EXPR_RESULT: {
                    Node firstChild = node.getFirstChild();
                    if (firstChild.isAssign()) {
                        this.identifyNameNode(firstChild.getFirstChild(), firstChild.getJSDocInfo());
                        break;
                    }
                    this.identifyNameNode(firstChild, firstChild.getJSDocInfo());
                    break;
                }
            }
        }

        private void identifyNameNode(Node nameNode, JSDocInfo info) {
            if (info != null && nameNode.isQualifiedName()) {
                if (info.hasEnumParameterType()) {
                    this.registry.identifyNonNullableName(nameNode.getQualifiedName());
                } else if (info.hasTypedefType()) {
                    this.registry.identifyNonNullableName(nameNode.getQualifiedName());
                }
            }
        }
    }

    private class DeferredSetType {
        final Node node;
        final JSType type;

        DeferredSetType(Node node, JSType type) {
            Preconditions.checkNotNull(node);
            Preconditions.checkNotNull(type);
            this.node = node;
            this.type = type;
        }

        void resolve() {
            this.node.setJSType(this.type.resolve(TypedScopeCreator.this.typeParsingErrorReporter));
        }
    }
}

