/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.collect.Table;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AccessControlUtils;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CollectFileOverviewVisibility;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.parsing.parser.util.format.SimpleFormat;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticRef;
import com.google.javascript.rhino.StaticScope;
import com.google.javascript.rhino.StaticSlot;
import com.google.javascript.rhino.StaticSourceFile;
import com.google.javascript.rhino.StaticSymbolTable;
import com.google.javascript.rhino.jstype.EnumType;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.Property;
import com.google.javascript.rhino.jstype.SimpleReference;
import com.google.javascript.rhino.jstype.SimpleSlot;
import com.google.javascript.rhino.jstype.StaticTypedScope;
import com.google.javascript.rhino.jstype.StaticTypedSlot;
import com.google.javascript.rhino.jstype.UnionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class SymbolTable {
    private static final Logger logger = Logger.getLogger(SymbolTable.class.getName());
    public static final String GLOBAL_THIS = "*global*";
    private final Table<Node, String, Symbol> symbols = HashBasedTable.create();
    private final Map<Node, SymbolScope> scopes = new LinkedHashMap<Node, SymbolScope>();
    private final List<Node> docInfos = new ArrayList<Node>();
    private SymbolScope globalScope = null;
    private final AbstractCompiler compiler;
    private final JSTypeRegistry registry;
    private final Ordering<String> sourceNameOrdering = Ordering.natural().nullsFirst();
    private final Ordering<Node> nodeOrdering = new Ordering<Node>(){

        @Override
        public int compare(Node a, Node b) {
            int result = SymbolTable.this.sourceNameOrdering.compare(a.getSourceFileName(), b.getSourceFileName());
            if (result != 0) {
                return result;
            }
            return a.getSourcePosition() - b.getSourcePosition();
        }
    };
    private final Ordering<SymbolScope> lexicalScopeOrdering = new Ordering<SymbolScope>(){

        @Override
        public int compare(SymbolScope a, SymbolScope b) {
            Preconditions.checkState(a.isLexicalScope() && b.isLexicalScope(), "We can only sort lexical scopes");
            int result = SymbolTable.this.nodeOrdering.compare(a.getRootNode(), b.getRootNode());
            if (result != 0) {
                return result;
            }
            return a.getScopeDepth() - b.getScopeDepth();
        }
    };
    private final Ordering<Symbol> symbolOrdering = new Ordering<Symbol>(){

        @Override
        public int compare(Symbol a, Symbol b) {
            SymbolScope scopeA = SymbolTable.this.getScope(a);
            SymbolScope scopeB = SymbolTable.this.getScope(b);
            int result = SymbolTable.this.getLexicalScopeDepth(scopeA) - SymbolTable.this.getLexicalScopeDepth(scopeB);
            if (result != 0) {
                return result;
            }
            return a.getName().compareTo(b.getName());
        }
    };

    SymbolTable(AbstractCompiler compiler, JSTypeRegistry registry) {
        this.compiler = compiler;
        this.registry = registry;
    }

    public Iterable<Reference> getReferences(Symbol symbol) {
        return Collections.unmodifiableCollection(symbol.references.values());
    }

    public ImmutableList<Reference> getReferenceList(Symbol symbol) {
        return ImmutableList.copyOf(symbol.references.values());
    }

    public ImmutableList<Symbol> getAllSymbols() {
        return ImmutableList.copyOf(this.symbols.values());
    }

    public List<Symbol> getAllSymbolsSorted() {
        List<Symbol> sortedSymbols = this.getNaturalSymbolOrdering().sortedCopy(this.symbols.values());
        return sortedSymbols;
    }

    public Ordering<Symbol> getNaturalSymbolOrdering() {
        return this.symbolOrdering;
    }

    public SymbolScope getScope(Symbol slot) {
        return slot.scope;
    }

    public Collection<Node> getAllJSDocInfoNodes() {
        return Collections.unmodifiableList(this.docInfos);
    }

    public SymbolScope getEnclosingScope(Node n) {
        Node current = n.getParent();
        if (n.isName() && n.getParent().isFunction()) {
            current = current.getParent();
        }
        while (current != null) {
            if (this.scopes.containsKey(current)) {
                return this.scopes.get(current);
            }
            current = current.getParent();
        }
        return null;
    }

    public SymbolScope getEnclosingFunctionScope(Node n) {
        Node current = n.getParent();
        if (n.isName() && current != null && current.isFunction()) {
            current = current.getParent();
        }
        while (current != null) {
            SymbolScope scope = this.scopes.get(current);
            if (scope != null && !scope.isBlockScope()) {
                return scope;
            }
            current = current.getParent();
        }
        return this.globalScope;
    }

    public Symbol getParameterInFunction(Symbol sym, String paramName) {
        Symbol param;
        SymbolScope scope = this.getScopeInFunction(sym);
        if (scope != null && (param = scope.getSlot(paramName)) != null && param.scope == scope) {
            return param;
        }
        return null;
    }

    private SymbolScope getScopeInFunction(Symbol sym) {
        FunctionType type = sym.getFunctionType();
        if (type == null) {
            return null;
        }
        Node functionNode = type.getSource();
        if (functionNode == null) {
            return null;
        }
        return this.scopes.get(functionNode);
    }

    public Symbol getSymbolForScope(SymbolScope scope) {
        if (scope.getSymbolForScope() == null) {
            scope.setSymbolForScope(this.findSymbolForScope(scope));
        }
        return scope.getSymbolForScope();
    }

    private Symbol findSymbolForScope(SymbolScope scope) {
        Node rootNode = scope.getRootNode();
        if (rootNode.getParent() == null) {
            return this.globalScope.getSlot(GLOBAL_THIS);
        }
        if (!rootNode.isFunction()) {
            return null;
        }
        String name = NodeUtil.getBestLValueName(NodeUtil.getBestLValue(rootNode));
        return name == null ? null : scope.getParentScope().getQualifiedSlot(name);
    }

    public Iterable<Symbol> getAllSymbolsForTypeOf(Symbol sym) {
        return this.getAllSymbolsForType(this.getType(sym));
    }

    public SymbolScope getGlobalScope() {
        return this.globalScope;
    }

    public Symbol getSymbolDeclaredBy(FunctionType fn) {
        Preconditions.checkState(fn.isConstructor() || fn.isInterface());
        ObjectType instanceType = fn.getInstanceType();
        return this.getSymbolForName(fn.getSource(), instanceType.getReferenceName());
    }

    public Symbol getSymbolDeclaredBy(EnumType enumType) {
        return this.getSymbolForName(null, enumType.getElementsType().getReferenceName());
    }

    public Symbol getSymbolForInstancesOf(Symbol sym) {
        FunctionType fn = sym.getFunctionType();
        if (fn != null && fn.isNominalConstructor()) {
            return this.getSymbolForInstancesOf(fn);
        }
        return null;
    }

    public Symbol getSymbolForInstancesOf(FunctionType fn) {
        Preconditions.checkState(fn.isConstructor() || fn.isInterface());
        ObjectType pType = fn.getPrototype();
        return this.getSymbolForName(fn.getSource(), pType.getReferenceName());
    }

    private Symbol getSymbolForName(Node source, String name) {
        if (name == null || this.globalScope == null) {
            return null;
        }
        SymbolScope scope = source == null ? this.globalScope : this.getEnclosingScope(source);
        return scope == null ? null : scope.getQualifiedSlot(name);
    }

    public List<Symbol> getAllSymbolsForType(JSType type) {
        if (type == null) {
            return ImmutableList.of();
        }
        UnionType unionType = type.toMaybeUnionType();
        if (unionType != null) {
            ArrayList<Symbol> result = new ArrayList<Symbol>(2);
            for (JSType alt : unionType.getAlternates()) {
                Symbol altSym = this.getSymbolForTypeHelper(alt, true);
                if (altSym == null) continue;
                result.add(altSym);
            }
            return result;
        }
        Symbol result = this.getSymbolForTypeHelper(type, true);
        return result == null ? ImmutableList.of() : ImmutableList.of(result);
    }

    private Symbol getSymbolForTypeHelper(JSType type, boolean linkToCtor) {
        if (type == null) {
            return null;
        }
        if (type.isGlobalThisType()) {
            return this.globalScope.getSlot(GLOBAL_THIS);
        }
        if (type.isNominalConstructor()) {
            return linkToCtor ? this.globalScope.getSlot("Function") : this.getSymbolDeclaredBy(type.toMaybeFunctionType());
        }
        if (type.isFunctionPrototypeType()) {
            FunctionType ownerFn = ((ObjectType)type).getOwnerFunction();
            if (!ownerFn.isConstructor() && !ownerFn.isInterface()) {
                return null;
            }
            return linkToCtor ? this.getSymbolDeclaredBy(ownerFn) : this.getSymbolForInstancesOf(ownerFn);
        }
        if (type.isInstanceType()) {
            FunctionType ownerFn = ((ObjectType)type).getConstructor();
            return linkToCtor ? this.getSymbolDeclaredBy(ownerFn) : this.getSymbolForInstancesOf(ownerFn);
        }
        if (type.isFunctionType()) {
            return linkToCtor ? this.globalScope.getSlot("Function") : this.globalScope.getQualifiedSlot("Function.prototype");
        }
        if (type.autoboxesTo() != null) {
            return this.getSymbolForTypeHelper(type.autoboxesTo(), linkToCtor);
        }
        return null;
    }

    public String toDebugString() {
        StringBuilder builder = new StringBuilder();
        for (Symbol symbol : this.getAllSymbols()) {
            this.toDebugString(builder, symbol);
        }
        return builder.toString();
    }

    private void toDebugString(StringBuilder builder, Symbol symbol) {
        SymbolScope scope = symbol.scope;
        if (scope.isGlobalScope()) {
            builder.append(SimpleFormat.format("'%s' : in global scope:\n", symbol.getName()));
        } else if (scope.getRootNode() != null) {
            builder.append(SimpleFormat.format("'%s' : in scope %s:%d\n", symbol.getName(), scope.getRootNode().getSourceFileName(), scope.getRootNode().getLineno()));
        } else if (scope.getSymbolForScope() != null) {
            builder.append(SimpleFormat.format("'%s' : in scope %s\n", symbol.getName(), scope.getSymbolForScope().getName()));
        } else {
            builder.append(SimpleFormat.format("'%s' : in unknown scope\n", symbol.getName()));
        }
        int refCount = 0;
        for (Reference ref : this.getReferences(symbol)) {
            builder.append(SimpleFormat.format("  Ref %d: %s:%d\n", refCount, ref.getNode().getSourceFileName(), ref.getNode().getLineno()));
            ++refCount;
        }
    }

    <S extends StaticScope> void addScopes(Collection<S> scopes) {
        for (StaticScope scope : scopes) {
            this.createScopeFrom(scope);
        }
    }

    void findScopes(Node externs, Node root) {
        NodeTraversal.traverseRoots(this.compiler, new NodeTraversal.AbstractScopedCallback(){

            @Override
            public void enterScope(NodeTraversal t) {
                SymbolTable.this.createScopeFrom(t.getScope());
            }

            @Override
            public void visit(NodeTraversal t, Node n, Node p) {
            }
        }, externs, root);
    }

    public Collection<SymbolScope> getAllScopes() {
        return Collections.unmodifiableCollection(this.scopes.values());
    }

    public void addAnonymousFunctions() {
        TreeSet<SymbolScope> scopes = new TreeSet<SymbolScope>(this.lexicalScopeOrdering);
        for (SymbolScope scope : this.getAllScopes()) {
            if (!scope.isLexicalScope()) continue;
            scopes.add(scope);
        }
        for (SymbolScope scope : scopes) {
            this.addAnonymousFunctionsInScope(scope);
        }
    }

    private void addAnonymousFunctionsInScope(SymbolScope scope) {
        Symbol sym = this.getSymbolForScope(scope);
        if (sym == null && scope.isLexicalScope() && !scope.isGlobalScope() && scope.getRootNode() != null && !scope.getRootNode().isFromExterns() && scope.getParentScope() != null && scope.getRootNode().isFunction()) {
            SymbolScope parent = scope.getParentScope();
            String innerName = "function%" + scope.getIndexInParent();
            Symbol anonymousFunctionSymbol = this.declareSymbol(innerName, scope.getRootNode().getJSType(), true, parent, scope.getRootNode(), null);
            scope.setSymbolForScope(anonymousFunctionSymbol);
        }
    }

    <S extends StaticSlot, R extends StaticRef> void addSymbolsFrom(StaticSymbolTable<S, R> otherSymbolTable) {
        for (StaticSlot otherSymbol : otherSymbolTable.getAllSymbols()) {
            String name = otherSymbol.getName();
            SymbolScope myScope = this.createScopeFrom(otherSymbolTable.getScope(otherSymbol));
            StaticRef decl = this.findBestDeclToAdd(otherSymbolTable, otherSymbol);
            Symbol mySymbol = null;
            if (decl != null) {
                Node declNode = decl.getNode();
                mySymbol = this.isAnySymbolDeclared(name, declNode, myScope);
                if (mySymbol == null) {
                    mySymbol = this.copySymbolTo(otherSymbol, declNode, myScope);
                }
            } else {
                mySymbol = myScope.getOwnSlot(name);
            }
            if (mySymbol == null) continue;
            for (StaticRef otherRef : otherSymbolTable.getReferences(otherSymbol)) {
                if (!this.isGoodRefToAdd(otherRef)) continue;
                mySymbol.defineReferenceAt(otherRef.getNode());
            }
        }
    }

    private Symbol isAnySymbolDeclared(String name, Node declNode, SymbolScope scope) {
        Symbol sym = this.symbols.get(declNode, name);
        if (sym == null) {
            return (Symbol)scope.ownSymbols.get(name);
        }
        return sym;
    }

    private <S extends StaticSlot, R extends StaticRef> StaticRef findBestDeclToAdd(StaticSymbolTable<S, R> otherSymbolTable, S slot) {
        StaticRef decl = slot.getDeclaration();
        if (this.isGoodRefToAdd(decl)) {
            return decl;
        }
        for (StaticRef ref : otherSymbolTable.getReferences(slot)) {
            if (!this.isGoodRefToAdd(ref)) continue;
            return ref;
        }
        return null;
    }

    private boolean isGoodRefToAdd(@Nullable StaticRef ref) {
        return ref != null && ref.getNode() != null && ref.getNode().getStaticSourceFile() != null && !"{SyntheticVarsDeclar}".equals(ref.getNode().getStaticSourceFile().getName());
    }

    private Symbol copySymbolTo(StaticSlot sym, SymbolScope scope) {
        return this.copySymbolTo(sym, sym.getDeclaration().getNode(), scope);
    }

    private Symbol copySymbolTo(StaticSlot sym, Node declNode, SymbolScope scope) {
        Preconditions.checkNotNull(declNode);
        return this.declareSymbol(sym.getName(), this.getType(sym), this.isTypeInferred(sym), scope, declNode, sym.getJSDocInfo());
    }

    private static String sanitizeSpecialChars(String s) {
        return s.replace("\\", "\\\\").replace("\u0000", "\\0").replace("\n", "\\n");
    }

    private Symbol addSymbol(String name, JSType type, boolean inferred, SymbolScope scope, Node declNode) {
        Symbol symbol;
        Symbol replacedSymbol = this.symbols.put(declNode, name = SymbolTable.sanitizeSpecialChars(name), symbol = new Symbol(name, type, inferred, scope));
        Preconditions.checkState(replacedSymbol == null, "Found duplicate symbol %s in global index. Type %s", (Object)name, (Object)type);
        replacedSymbol = scope.ownSymbols.put(name, symbol);
        Preconditions.checkState(replacedSymbol == null, "Found duplicate symbol %s in its scope. Type %s", (Object)name, (Object)type);
        return symbol;
    }

    private Symbol declareSymbol(String name, JSType type, boolean inferred, SymbolScope scope, Node declNode, JSDocInfo info) {
        Symbol symbol = this.addSymbol(name, type, inferred, scope, declNode);
        symbol.setJSDocInfo(info);
        symbol.setDeclaration(symbol.defineReferenceAt(declNode));
        return symbol;
    }

    private void removeSymbol(Symbol s) {
        SymbolScope scope = this.getScope(s);
        if (!s.equals(scope.ownSymbols.remove(s.getName()))) {
            throw new IllegalStateException("Symbol not found in scope " + s);
        }
        if (!s.equals(this.symbols.remove(s.getDeclaration().getNode(), s.getName()))) {
            throw new IllegalStateException("Symbol not found in table " + s);
        }
        if (s.propertyScope != null && s.propertyScope.getSymbolForScope().equals(s)) {
            for (Symbol childSymbol : ImmutableList.copyOf(s.propertyScope.ownSymbols.values())) {
                this.removeSymbol(childSymbol);
            }
            this.scopes.remove(s.getDeclarationNode());
        }
    }

    void fillNamespaceReferences() {
        for (Symbol symbol : this.getAllSymbols()) {
            Symbol root;
            String qName = symbol.getName();
            int rootIndex = qName.indexOf(46);
            if (rootIndex == -1 || (root = symbol.scope.getQualifiedSlot(qName.substring(0, rootIndex))) == null) continue;
            for (Reference ref : this.getReferences(symbol)) {
                Node currentNode = ref.getNode();
                if (!currentNode.isQualifiedName()) continue;
                while (currentNode.isGetProp()) {
                    String name = (currentNode = currentNode.getFirstChild()).getQualifiedName();
                    if (name == null) continue;
                    Symbol namespace = this.isAnySymbolDeclared(name, currentNode, root.scope);
                    if (namespace == null) {
                        namespace = root.scope.getQualifiedSlot(name);
                    }
                    if (namespace == null && root.scope.isGlobalScope()) {
                        namespace = this.declareSymbol(name, this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE), true, root.scope, currentNode, null);
                    }
                    if (namespace == null) continue;
                    namespace.defineReferenceAt(currentNode);
                }
            }
        }
    }

    void fillPropertyScopes() {
        ArrayList<Symbol> types = new ArrayList<Symbol>();
        ArrayList<Symbol> googModuleExportTypes = new ArrayList<Symbol>();
        for (Symbol sym : this.getAllSymbols()) {
            if (!this.needsPropertyScope(sym)) continue;
            if (sym.getName().startsWith("module$exports")) {
                googModuleExportTypes.add(sym);
                continue;
            }
            types.add(sym);
        }
        Collections.sort(types, this.getNaturalSymbolOrdering().reverse());
        Collections.sort(googModuleExportTypes, this.getNaturalSymbolOrdering().reverse());
        Iterable<Symbol> allTypes = Iterables.concat(googModuleExportTypes, types);
        IdentityHashMap<JSType, Symbol> symbolThatDeclaresType = new IdentityHashMap<JSType, Symbol>();
        for (Symbol s : allTypes) {
            symbolThatDeclaresType.put(s.getType(), s);
        }
        for (Symbol s : allTypes) {
            if (s.getType() != null && !((Symbol)symbolThatDeclaresType.get(s.getType())).equals(s)) continue;
            this.createPropertyScopeFor(s);
        }
        for (Symbol s : allTypes) {
            if (s.getType() == null) continue;
            s.propertyScope = ((Symbol)symbolThatDeclaresType.get(s.getType())).getPropertyScope();
        }
        this.pruneOrphanedNames();
    }

    private boolean needsPropertyScope(Symbol sym) {
        ObjectType type = ObjectType.cast(this.getType(sym));
        if (type == null) {
            return false;
        }
        if (type.getReferenceName() == null) {
            return true;
        }
        if (sym.getName().equals(type.getReferenceName())) {
            return true;
        }
        return type.isEnumType() && sym.getName().equals(type.toMaybeEnumType().getElementsType().getReferenceName());
    }

    void pruneOrphanedNames() {
        block0: for (Symbol s : this.getAllSymbols()) {
            if (s.isProperty()) continue;
            String currentName = s.getName();
            int dot = -1;
            while (-1 != (dot = currentName.lastIndexOf(46))) {
                currentName = currentName.substring(0, dot);
                Symbol owner = s.scope.getQualifiedSlot(currentName);
                if (owner == null || this.getType(owner) == null || !this.getType(owner).isNominalConstructor() && !this.getType(owner).isFunctionPrototypeType() && !this.getType(owner).isEnumType()) continue;
                this.removeSymbol(s);
                continue block0;
            }
        }
    }

    void fillPropertySymbols(Node externs, Node root) {
        new PropertyRefCollector().process(externs, root);
    }

    void fillJSDocInfo(Node externs, Node root) {
        NodeTraversal.traverseRoots(this.compiler, new JSDocInfoCollector(this.compiler.getTypeRegistry()), externs, root);
        for (Symbol sym : this.getAllSymbols()) {
            JSDocInfo info = sym.getJSDocInfo();
            if (info == null) continue;
            for (JSDocInfo.Marker marker : info.getMarkers()) {
                JSDocInfo.NamePosition pos = marker.getNameNode();
                if (pos == null) continue;
                Node paramNode = (Node)pos.getItem();
                String name = paramNode.getString();
                Symbol param = this.getParameterInFunction(sym, name);
                if (param == null) {
                    Symbol existingSymbol;
                    JSDocInfo.TypePosition typePos = marker.getType();
                    JSType type = null;
                    if (typePos != null) {
                        type = ((Node)typePos.getItem()).getJSType();
                    }
                    if (sym.docScope == null) {
                        sym.docScope = new SymbolScope(null, null, null, sym);
                    }
                    if ((existingSymbol = this.isAnySymbolDeclared(name, paramNode, sym.docScope)) != null) continue;
                    this.declareSymbol(name, type, type == null, sym.docScope, paramNode, null);
                    continue;
                }
                param.defineReferenceAt(paramNode);
            }
        }
    }

    void fillSymbolVisibility(Node externs, Node root) {
        CollectFileOverviewVisibility collectPass = new CollectFileOverviewVisibility(this.compiler);
        collectPass.process(externs, root);
        ImmutableMap<StaticSourceFile, JSDocInfo.Visibility> visibilityMap = collectPass.getFileOverviewVisibilityMap();
        NodeTraversal.traverseRoots(this.compiler, new VisibilityCollector(visibilityMap, this.compiler.getCodingConvention()), externs, root);
    }

    private void createPropertyScopeFor(Symbol s) {
        Symbol parentSymbol;
        ObjectType type;
        if (s.propertyScope != null) {
            return;
        }
        SymbolScope parentPropertyScope = null;
        ObjectType objectType = type = this.getType(s) == null ? null : this.getType(s).toObjectType();
        if (type == null) {
            return;
        }
        ObjectType proto = type.getParentScope();
        if (proto != null && proto != type && proto.getConstructor() != null && (parentSymbol = this.getSymbolForInstancesOf(proto.getConstructor())) != null) {
            this.createPropertyScopeFor(parentSymbol);
            parentPropertyScope = parentSymbol.getPropertyScope();
        }
        ObjectType instanceType = type;
        Iterable<String> propNames = type.getOwnPropertyNames();
        if (instanceType.isFunctionPrototypeType() && instanceType.getOwnerFunction().hasInstanceType()) {
            instanceType = instanceType.getOwnerFunction().getInstanceType();
            propNames = Iterables.concat(propNames, instanceType.getOwnPropertyNames());
        }
        s.setPropertyScope(new SymbolScope(null, parentPropertyScope, type, s));
        for (String propName : propNames) {
            Property newProp = instanceType.getSlot(propName);
            if (newProp.getDeclaration() == null) continue;
            Symbol oldProp = this.symbols.get(newProp.getDeclaration().getNode(), s.getName() + "." + propName);
            if (this.symbols.get(newProp.getDeclaration().getNode(), newProp.getName()) != null) {
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.fine("Found duplicate symbol " + newProp);
                continue;
            }
            Symbol newSym = this.copySymbolTo(newProp, s.propertyScope);
            if (oldProp == null) continue;
            if (newSym.getJSDocInfo() == null) {
                newSym.setJSDocInfo(oldProp.getJSDocInfo());
            }
            newSym.setPropertyScope(oldProp.propertyScope);
            for (Reference ref : oldProp.references.values()) {
                newSym.defineReferenceAt(ref.getNode());
            }
            this.removeSymbol(oldProp);
        }
    }

    void fillThisReferences(Node externs, Node root) {
        new ThisRefCollector().process(externs, root);
    }

    private boolean isSymbolGeneratedAndShouldNotBeIndexed(Symbol symbol) {
        return symbol.getName().contains("$jscomp$destructuring$var");
    }

    private boolean isSymbolAQuotedObjectKey(Symbol symbol) {
        Node node = symbol.getDeclarationNode();
        return node != null && node.isStringKey() && node.isQuotedString();
    }

    void removeGeneratedSymbols() {
        IdentityHashMap<Node, Symbol> nodeToSymbol = null;
        for (Symbol symbol : ImmutableList.copyOf(this.symbols.values())) {
            boolean symbolAlreadyRemoved;
            if (this.isSymbolGeneratedAndShouldNotBeIndexed(symbol)) {
                this.removeSymbol(symbol);
                continue;
            }
            if (symbol.getDeclaration() != null && symbol.getDeclaration().getNode().getBooleanProp((byte)97)) {
                if (nodeToSymbol == null) {
                    nodeToSymbol = new IdentityHashMap<Node, Symbol>();
                    for (Symbol s : this.symbols.values()) {
                        for (Node node : s.references.keySet()) {
                            nodeToSymbol.put(node, s);
                        }
                    }
                }
                this.inlineEs6ExportProperty(symbol, nodeToSymbol);
                continue;
            }
            if (!this.isSymbolAQuotedObjectKey(symbol) || (symbolAlreadyRemoved = !this.getScope(symbol).ownSymbols.containsKey(symbol.getName()))) continue;
            this.removeSymbol(symbol);
        }
    }

    private void inlineEs6ExportProperty(Symbol exportPropertySymbol, IdentityHashMap<Node, Symbol> nodeToSymbol) {
        Node decl = exportPropertySymbol.getDeclaration().getNode();
        Symbol originalSymbol = null;
        if (decl.isGetProp() && decl.getParent().isAssign()) {
            originalSymbol = nodeToSymbol.get(decl.getNext());
        } else if (decl.isGetProp() && decl.getParent().isExprResult()) {
            Node originalTypedefNode = decl.getJSDocInfo().getTypedefType().getRoot();
            originalSymbol = nodeToSymbol.get(originalTypedefNode);
        }
        if (originalSymbol == null) {
            return;
        }
        for (Node nodeToMove : exportPropertySymbol.references.keySet()) {
            originalSymbol.defineReferenceAt(nodeToMove);
        }
        this.removeSymbol(exportPropertySymbol);
    }

    private SymbolScope createScopeFrom(StaticScope otherScope) {
        Node otherScopeRoot = otherScope.getRootNode();
        SymbolScope myScope = this.scopes.get(otherScopeRoot);
        if (myScope == null) {
            StaticScope otherScopeParent = otherScope.getParentScope();
            if (otherScopeParent == null) {
                Preconditions.checkState(this.globalScope == null, "Global scopes found at different roots");
            }
            myScope = new SymbolScope(otherScopeRoot, otherScopeParent == null ? null : this.createScopeFrom(otherScopeParent), this.getTypeOfThis(otherScope), null);
            this.scopes.put(otherScopeRoot, myScope);
            if (myScope.isGlobalScope()) {
                this.globalScope = myScope;
            }
        }
        return myScope;
    }

    private int getLexicalScopeDepth(SymbolScope scope) {
        if (scope.isLexicalScope() || scope.isDocScope()) {
            return scope.getScopeDepth();
        }
        Preconditions.checkState(scope.isPropertyScope());
        Symbol sym = scope.getSymbolForScope();
        Preconditions.checkNotNull(sym);
        return this.getLexicalScopeDepth(this.getScope(sym)) + 1;
    }

    private JSType getType(StaticSlot sym) {
        if (sym instanceof StaticTypedSlot) {
            return ((StaticTypedSlot)sym).getType();
        }
        return null;
    }

    private JSType getTypeOfThis(StaticScope s) {
        if (s instanceof StaticTypedScope) {
            return ((StaticTypedScope)s).getTypeOfThis();
        }
        return null;
    }

    private boolean isTypeInferred(StaticSlot sym) {
        if (sym instanceof StaticTypedSlot) {
            return ((StaticTypedSlot)sym).isTypeInferred();
        }
        return true;
    }

    private class VisibilityCollector
    extends NodeTraversal.AbstractPostOrderCallback {
        private final ImmutableMap<StaticSourceFile, JSDocInfo.Visibility> fileVisibilityMap;
        private final CodingConvention codingConvention;

        private VisibilityCollector(ImmutableMap<StaticSourceFile, JSDocInfo.Visibility> fileVisibilityMap, CodingConvention codingConvention) {
            this.fileVisibilityMap = fileVisibilityMap;
            this.codingConvention = codingConvention;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isName()) {
                this.visitName(t, n);
            } else if (n.isGetProp()) {
                this.visitProperty(n, parent);
            }
        }

        private void visitName(NodeTraversal t, Node n) {
            Symbol symbol = (Symbol)SymbolTable.this.symbols.get(n, n.getString());
            if (symbol == null) {
                return;
            }
            if (symbol.getVisibility() != null) {
                return;
            }
            Var var = (Var)t.getScope().getVar(n.getString());
            if (var == null) {
                return;
            }
            JSDocInfo.Visibility v = AccessControlUtils.getEffectiveNameVisibility(n, var, this.fileVisibilityMap);
            if (v == null) {
                return;
            }
            symbol.setVisibility(v);
        }

        private void visitProperty(Node getprop, Node parent) {
            boolean isOverride;
            String propertyName = getprop.getLastChild().getString();
            Symbol symbol = (Symbol)SymbolTable.this.symbols.get(getprop, propertyName);
            if (symbol == null) {
                return;
            }
            if (symbol.getVisibility() != null) {
                return;
            }
            JSType jsType = getprop.getFirstChild().getJSType();
            if (jsType == null) {
                return;
            }
            boolean bl = isOverride = parent.getJSDocInfo() != null && parent.isAssign() && parent.getFirstChild() == getprop;
            if (isOverride) {
                symbol.setVisibility(JSDocInfo.Visibility.INHERITED);
            } else {
                ObjectType referenceType = ObjectType.cast(jsType.dereference());
                JSDocInfo.Visibility v = AccessControlUtils.getEffectivePropertyVisibility(getprop, referenceType, this.fileVisibilityMap, this.codingConvention);
                if (v == null) {
                    return;
                }
                symbol.setVisibility(v);
            }
        }
    }

    private class JSDocInfoCollector
    extends NodeTraversal.AbstractPostOrderCallback {
        private final JSTypeRegistry typeRegistry;

        private JSDocInfoCollector(JSTypeRegistry registry) {
            this.typeRegistry = registry;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.getJSDocInfo() != null) {
                JSDocInfo info = n.getJSDocInfo();
                SymbolTable.this.docInfos.add(n);
                for (Node typeAst : info.getTypeNodes()) {
                    SymbolScope scope = (SymbolScope)SymbolTable.this.scopes.get(t.getScopeRoot());
                    this.visitTypeNode(info.getTemplateTypeNames(), scope == null ? SymbolTable.this.globalScope : scope, typeAst);
                }
            }
        }

        private boolean isNativeSourcelessType(String name) {
            switch (name) {
                case "null": 
                case "undefined": 
                case "void": {
                    return true;
                }
            }
            return false;
        }

        public void visitTypeNode(ImmutableList<String> templateTypeNames, SymbolScope scope, Node n) {
            Symbol symbol;
            if (n.isString() && !this.isNativeSourcelessType(n.getString()) && !templateTypeNames.contains(n.getString()) && (symbol = this.lookupPossiblyDottedName(scope, n.getString())) != null) {
                String typeString;
                Node ref = n;
                String string = typeString = n.getOriginalName() != null ? n.getOriginalName() : n.getString();
                if (typeString.contains(".")) {
                    String lastPart = typeString.substring(typeString.lastIndexOf(46) + 1);
                    Node copy = n.cloneNode();
                    copy.setCharno(copy.getCharno() + copy.getLength() - lastPart.length());
                    copy.setLength(lastPart.length());
                    ref = copy;
                }
                symbol.defineReferenceAt(ref);
            }
            for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
                this.visitTypeNode(templateTypeNames, scope, child);
            }
        }

        private Symbol lookupPossiblyDottedName(SymbolScope scope, String dottedName) {
            String name;
            String[] names = dottedName.split("\\.");
            Symbol result = null;
            SymbolScope currentScope = scope;
            for (int i = 0; i < names.length && (result = currentScope.getSlot(name = names[i])) != null; ++i) {
                if (i >= names.length - 1 || (currentScope = result.getPropertyScope()) != null) continue;
                result = null;
                break;
            }
            if (result == null) {
                JSType type = this.typeRegistry.getGlobalType(dottedName);
                JSType autobox = type == null ? null : type.autoboxesTo();
                Symbol symbol = result = autobox == null ? SymbolTable.this.getSymbolForTypeHelper(type, true) : SymbolTable.this.getSymbolForTypeHelper(autobox, true);
            }
            if (result == null && (result = SymbolTable.this.globalScope.getSlot(dottedName)) != null && !result.getDeclarationNode().getStaticSourceFile().isExtern()) {
                result = null;
            }
            return result;
        }
    }

    private class ThisRefCollector
    extends NodeTraversal.AbstractScopedCallback
    implements CompilerPass {
        private final List<Symbol> thisStack = new ArrayList<Symbol>();

        private ThisRefCollector() {
        }

        @Override
        public void process(Node externs, Node root) {
            NodeTraversal.traverseRoots(SymbolTable.this.compiler, this, externs, root);
        }

        @Override
        public void enterScope(NodeTraversal t) {
            Symbol symbol = null;
            if (t.inGlobalScope()) {
                Node firstInputRoot = t.getScopeRoot().getLastChild().getFirstChild();
                if (firstInputRoot != null) {
                    symbol = SymbolTable.this.addSymbol(SymbolTable.GLOBAL_THIS, SymbolTable.this.registry.getNativeType(JSTypeNative.GLOBAL_THIS), false, SymbolTable.this.globalScope, firstInputRoot);
                    symbol.setDeclaration(new Reference(symbol, firstInputRoot));
                }
                this.thisStack.add(symbol);
            } else if (t.getScopeRoot().isFunction()) {
                Node scopeRoot = t.getScopeRoot();
                SymbolScope scope = (SymbolScope)SymbolTable.this.scopes.get(scopeRoot);
                if (NodeUtil.getFunctionBody(scopeRoot).hasChildren()) {
                    SymbolScope propScope;
                    Symbol scopeSymbol = SymbolTable.this.getSymbolForScope(scope);
                    if (scopeSymbol != null && (propScope = scopeSymbol.getPropertyScope()) != null && (symbol = propScope.getOwnSlot("this")) == null) {
                        JSType rootType = t.getScopeRoot().getJSType();
                        FunctionType fnType = rootType == null ? null : rootType.toMaybeFunctionType();
                        JSType type = fnType == null ? null : fnType.getTypeOfThis();
                        symbol = SymbolTable.this.addSymbol("this", type, false, scope, scopeRoot);
                    }
                } else {
                    logger.fine("Skipping empty function: " + scopeRoot);
                }
                this.thisStack.add(symbol);
            }
        }

        @Override
        public void exitScope(NodeTraversal t) {
            if (t.inGlobalScope() || t.getScopeRoot().isFunction()) {
                this.thisStack.remove(this.thisStack.size() - 1);
            }
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (!n.isThis()) {
                return;
            }
            Symbol symbol = Iterables.getLast(this.thisStack);
            if (symbol != null) {
                Reference ref = symbol.defineReferenceAt(n);
                if (symbol.getDeclaration() == null) {
                    symbol.setDeclaration(ref);
                }
            }
        }
    }

    private class PropertyRefCollector
    extends NodeTraversal.AbstractPostOrderCallback
    implements CompilerPass {
        private PropertyRefCollector() {
        }

        @Override
        public void process(Node externs, Node root) {
            NodeTraversal.traverseRoots(SymbolTable.this.compiler, this, externs, root);
        }

        private boolean maybeDefineReference(Node n, String propName, Symbol ownerSymbol) {
            Symbol prop;
            if (ownerSymbol != null && ownerSymbol.getPropertyScope() != null && (prop = ownerSymbol.getPropertyScope().getSlot(propName)) != null) {
                prop.defineReferenceAt(n);
                return true;
            }
            return false;
        }

        private boolean tryDefineLexicalQualifiedNameRef(String name, Node n) {
            Symbol lexicalSym;
            if (name != null && (lexicalSym = SymbolTable.this.getEnclosingScope(n).getQualifiedSlot(name)) != null) {
                lexicalSym.defineReferenceAt(n);
                return true;
            }
            return false;
        }

        private void tryRemoveLexicalQualifiedNameRef(String name, Node n) {
            Symbol lexicalSym;
            if (name != null && (lexicalSym = SymbolTable.this.getEnclosingScope(n).getQualifiedSlot(name)) != null && lexicalSym.isLexicalVariable() && lexicalSym.getDeclaration().getNode() == n) {
                SymbolTable.this.removeSymbol(lexicalSym);
            }
        }

        private boolean maybeDefineTypedReference(Node n, String propName, JSType owner) {
            if (owner.isGlobalThisType()) {
                Symbol sym = SymbolTable.this.globalScope.getSlot(propName);
                if (sym != null) {
                    sym.defineReferenceAt(n);
                    return true;
                }
            } else {
                if (owner.isNominalConstructor()) {
                    return this.maybeDefineReference(n, propName, SymbolTable.this.getSymbolDeclaredBy(owner.toMaybeFunctionType()));
                }
                if (owner.isEnumType()) {
                    return this.maybeDefineReference(n, propName, SymbolTable.this.getSymbolDeclaredBy(owner.toMaybeEnumType()));
                }
                boolean defined = false;
                for (Symbol ctor : SymbolTable.this.getAllSymbolsForType(owner)) {
                    if (!this.maybeDefineReference(n, propName, SymbolTable.this.getSymbolForInstancesOf(ctor))) continue;
                    defined = true;
                }
                return defined;
            }
            return false;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isGetProp()) {
                boolean defined;
                JSType owner = n.getFirstChild().getJSType();
                if (owner != null && (defined = this.maybeDefineTypedReference(n, n.getLastChild().getString(), owner))) {
                    this.tryRemoveLexicalQualifiedNameRef(n.getQualifiedName(), n);
                    return;
                }
                this.tryDefineLexicalQualifiedNameRef(n.getQualifiedName(), n);
            } else if (n.isStringKey()) {
                boolean defined;
                JSType owner = parent.getJSType();
                if (owner != null && (defined = this.maybeDefineTypedReference(n, n.getString(), owner))) {
                    this.tryRemoveLexicalQualifiedNameRef(NodeUtil.getBestLValueName(n), n);
                    return;
                }
                this.tryDefineLexicalQualifiedNameRef(NodeUtil.getBestLValueName(n), n);
            }
        }
    }

    public static final class SymbolScope {
        private final Node rootNode;
        private final SymbolScope parent;
        private final JSType typeOfThis;
        private final Map<String, Symbol> ownSymbols = new LinkedHashMap<String, Symbol>();
        private final int scopeDepth;
        private final int indexInParent;
        private int numberOfChildScopes = 0;
        private Symbol mySymbol;

        SymbolScope(Node rootNode, @Nullable SymbolScope parent, JSType typeOfThis, Symbol mySymbol) {
            this.rootNode = rootNode;
            this.parent = parent;
            this.typeOfThis = typeOfThis;
            this.scopeDepth = parent == null ? 0 : parent.getScopeDepth() + 1;
            this.mySymbol = mySymbol;
            this.indexInParent = parent == null ? 0 : parent.numberOfChildScopes++;
        }

        Symbol getSymbolForScope() {
            return this.mySymbol;
        }

        void setSymbolForScope(Symbol sym) {
            this.mySymbol = sym;
        }

        public int getIndexOfSymbol(Symbol sym) {
            return Iterables.indexOf(this.ownSymbols.values(), Predicates.equalTo(sym));
        }

        Node getRootNode() {
            return this.rootNode;
        }

        public SymbolScope getParentScope() {
            return this.parent;
        }

        public Symbol getQualifiedSlot(String name) {
            Symbol owner;
            Symbol fullyNamedSym = this.getSlot(name);
            if (fullyNamedSym != null) {
                return fullyNamedSym;
            }
            int dot = name.lastIndexOf(46);
            if (dot != -1 && (owner = this.getQualifiedSlot(name.substring(0, dot))) != null && owner.getPropertyScope() != null) {
                return owner.getPropertyScope().getSlot(name.substring(dot + 1));
            }
            return null;
        }

        public Symbol getSlot(String name) {
            Symbol ancestor;
            Symbol own = this.getOwnSlot(name);
            if (own != null) {
                return own;
            }
            Symbol symbol = ancestor = this.parent == null ? null : this.parent.getSlot(name);
            if (ancestor != null) {
                return ancestor;
            }
            return null;
        }

        Symbol getOwnSlot(String name) {
            return this.ownSymbols.get(name);
        }

        public JSType getTypeOfThis() {
            return this.typeOfThis;
        }

        public boolean isGlobalScope() {
            return this.getParentScope() == null && this.getRootNode() != null;
        }

        public boolean isDocScope() {
            return this.getRootNode() == null && this.mySymbol != null && this.mySymbol.docScope == this;
        }

        public boolean isPropertyScope() {
            return this.getRootNode() == null && !this.isDocScope();
        }

        public boolean isLexicalScope() {
            return this.getRootNode() != null;
        }

        public boolean isBlockScope() {
            return this.getRootNode() != null && NodeUtil.createsBlockScope(this.getRootNode());
        }

        public int getScopeDepth() {
            return this.scopeDepth;
        }

        public int getIndexInParent() {
            return this.indexInParent;
        }

        public String toString() {
            Node n = this.getRootNode();
            if (n != null) {
                return "Scope@" + n.getSourceFileName() + ":" + n.getLineno();
            }
            return "PropertyScope@" + this.getSymbolForScope();
        }
    }

    public static final class Reference
    extends SimpleReference<Symbol> {
        Reference(Symbol symbol, Node node) {
            super(symbol, node);
        }
    }

    public static final class Symbol
    extends SimpleSlot {
        private final Map<Node, Reference> references = new LinkedHashMap<Node, Reference>();
        private final SymbolScope scope;
        private SymbolScope propertyScope = null;
        private Reference declaration = null;
        private JSDocInfo docInfo = null;
        @Nullable
        private JSDocInfo.Visibility visibility = null;
        private SymbolScope docScope = null;

        Symbol(String name, JSType type, boolean inferred, SymbolScope scope) {
            super(name, type, inferred);
            this.scope = scope;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Symbol)) {
                return false;
            }
            Symbol other = (Symbol)o;
            return this.isTypeInferred() == other.isTypeInferred() && Objects.equals(this.getName(), other.getName()) && Objects.equals(this.getType(), other.getType()) && Objects.equals(this.scope, other.scope);
        }

        public int hashCode() {
            return Objects.hash(this.isTypeInferred(), this.getName(), this.getType(), this.scope);
        }

        @Override
        public Reference getDeclaration() {
            return this.declaration;
        }

        public FunctionType getFunctionType() {
            return JSType.toMaybeFunctionType(this.getType());
        }

        public Reference defineReferenceAt(Node n) {
            Reference result = this.references.get(n);
            if (result == null) {
                result = new Reference(this, n);
                this.references.put(n, result);
            }
            return result;
        }

        void setDeclaration(Reference ref) {
            Preconditions.checkState(this.declaration == null);
            this.declaration = ref;
        }

        public Node getDeclarationNode() {
            return this.declaration == null ? null : this.declaration.getNode();
        }

        public String getSourceFileName() {
            Node n = this.getDeclarationNode();
            return n == null ? null : n.getSourceFileName();
        }

        public SymbolScope getPropertyScope() {
            return this.propertyScope;
        }

        void setPropertyScope(SymbolScope scope) {
            this.propertyScope = scope;
            if (scope != null) {
                this.propertyScope.setSymbolForScope(this);
            }
        }

        @Override
        public JSDocInfo getJSDocInfo() {
            return this.docInfo;
        }

        void setJSDocInfo(JSDocInfo info) {
            this.docInfo = info;
        }

        @Nullable
        public JSDocInfo.Visibility getVisibility() {
            return this.visibility;
        }

        void setVisibility(JSDocInfo.Visibility v) {
            this.visibility = v;
        }

        public boolean isProperty() {
            return this.scope.isPropertyScope();
        }

        public boolean isLexicalVariable() {
            return this.scope.isLexicalScope();
        }

        public boolean isDocOnlyParameter() {
            return this.scope.isDocScope();
        }

        public String toString() {
            Node n = this.getDeclarationNode();
            int lineNo = n == null ? -1 : n.getLineno();
            return this.getName() + "@" + this.getSourceFileName() + ":" + lineNo;
        }
    }
}

