/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.Node;

public final class RewriteAsyncIteration
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    static final DiagnosticType CANNOT_CONVERT_ASYNC_ITERATION_YET = DiagnosticType.error("JSC_CANNOT_CONVERT_ASYNC_ITERATION_YET", "Cannot convert async iteration/generators yet.");
    private static final FeatureSet transpiledFeatures = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.ASYNC_GENERATORS, FeatureSet.Feature.FOR_AWAIT_OF);
    private final AbstractCompiler compiler;

    public RewriteAsyncIteration(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        TranspilationPasses.processTranspile(this.compiler, scriptRoot, transpiledFeatures, this);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, transpiledFeatures);
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, root, transpiledFeatures, this);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, transpiledFeatures);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isForAwaitOf() || n.isAsyncFunction() && n.isGeneratorFunction()) {
            this.compiler.report(JSError.make(n, CANNOT_CONVERT_ASYNC_ITERATION_YET, new String[0]));
        }
    }
}

