/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.errorprone.annotations.Immutable;
import com.google.javascript.jscomp.deps.ModuleNames;
import java.io.Serializable;

@Immutable
public class ModuleIdentifier
implements Serializable {
    private final String name;
    private final String closureNamespace;
    private final String moduleName;

    ModuleIdentifier(String name, String closureNamespace, String moduleName) {
        this.name = name;
        this.closureNamespace = closureNamespace;
        this.moduleName = moduleName;
    }

    public String getName() {
        return this.name;
    }

    public String getClosureNamespace() {
        return this.closureNamespace;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String toString() {
        if (this.closureNamespace.equals(this.moduleName)) {
            return this.closureNamespace;
        }
        return this.moduleName + ":" + this.closureNamespace;
    }

    public static ModuleIdentifier forClosure(String name) {
        String normalizedName = name;
        if (normalizedName.startsWith("goog:")) {
            normalizedName = normalizedName.substring("goog:".length());
        }
        String namespace = normalizedName;
        String moduleName = normalizedName;
        int splitPoint = normalizedName.indexOf(58);
        if (splitPoint != -1) {
            moduleName = normalizedName.substring(0, splitPoint);
            namespace = normalizedName.substring(Math.min(splitPoint + 1, normalizedName.length() - 1));
        }
        return new ModuleIdentifier(normalizedName, namespace, moduleName);
    }

    public static ModuleIdentifier forFile(String filepath) {
        String normalizedName = ModuleNames.fileToModuleName(filepath);
        return new ModuleIdentifier(filepath, normalizedName, normalizedName);
    }
}

