/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.EnumElementType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.ObjectType;
import javax.annotation.Nullable;

class InferJSDocInfo
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    private final AbstractCompiler compiler;

    InferJSDocInfo(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        if (externs != null) {
            NodeTraversal.traverse(this.compiler, externs, this);
        }
        if (root != null) {
            NodeTraversal.traverse(this.compiler, root, this);
        }
    }

    @Override
    public void hotSwapScript(Node root, Node originalRoot) {
        Preconditions.checkNotNull(root);
        Preconditions.checkState(root.isScript());
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case NAME: {
                JSType inferredType;
                JSDocInfo typeDoc;
                if (parent == null) {
                    return;
                }
                if (NodeUtil.isNameDeclaration(parent)) {
                    JSDocInfo nameInfo = n.getJSDocInfo();
                    typeDoc = nameInfo != null ? nameInfo : parent.getJSDocInfo();
                    inferredType = n.getJSType();
                } else if (NodeUtil.isFunctionDeclaration(parent)) {
                    typeDoc = parent.getJSDocInfo();
                    inferredType = parent.getJSType();
                } else if (parent.isAssign() && n.isFirstChildOf(parent)) {
                    typeDoc = parent.getJSDocInfo();
                    inferredType = n.getJSType();
                } else {
                    return;
                }
                if (typeDoc == null) {
                    return;
                }
                ObjectType objType = InferJSDocInfo.dereferenceToObject(inferredType);
                if (objType == null || objType.getJSDocInfo() != null) {
                    return;
                }
                InferJSDocInfo.attachJSDocInfoToNominalTypeOrShape(objType, typeDoc, n.getString());
                return;
            }
            case STRING_KEY: 
            case GETTER_DEF: 
            case SETTER_DEF: 
            case MEMBER_FUNCTION_DEF: {
                JSDocInfo typeDoc = n.getJSDocInfo();
                if (typeDoc == null) {
                    return;
                }
                ObjectType owningType = InferJSDocInfo.dereferenceToObject(parent.getJSType());
                if (owningType == null) {
                    return;
                }
                String propName = n.getString();
                if (owningType.hasOwnProperty(propName)) {
                    owningType.setPropertyJSDocInfo(propName, typeDoc);
                }
                return;
            }
            case GETPROP: {
                ObjectType propType;
                JSDocInfo typeDoc;
                if (parent.isAssign() && n.isFirstChildOf(parent)) {
                    typeDoc = parent.getJSDocInfo();
                } else if (parent.isExprResult()) {
                    typeDoc = n.getJSDocInfo();
                } else {
                    return;
                }
                if (typeDoc == null) {
                    return;
                }
                ObjectType lhsType = InferJSDocInfo.dereferenceToObject(n.getFirstChild().getJSType());
                if (lhsType == null) {
                    return;
                }
                String propName = n.getLastChild().getString();
                if (lhsType.hasOwnProperty(propName)) {
                    lhsType.setPropertyJSDocInfo(propName, typeDoc);
                }
                if ((propType = InferJSDocInfo.dereferenceToObject(lhsType.getPropertyType(propName))) != null) {
                    InferJSDocInfo.attachJSDocInfoToNominalTypeOrShape(propType, typeDoc, n.getQualifiedName());
                }
                return;
            }
        }
    }

    private static ObjectType dereferenceToObject(JSType type) {
        return ObjectType.cast(type == null ? null : type.dereference());
    }

    private static void attachJSDocInfoToNominalTypeOrShape(ObjectType objType, JSDocInfo docInfo, @Nullable String qName) {
        if (objType.isConstructor() || objType.isInterface()) {
            if (!InferJSDocInfo.isReferenceNameOf(objType, qName)) {
                return;
            }
            objType.setJSDocInfo(docInfo);
            JSType.toMaybeFunctionType(objType).getInstanceType().setJSDocInfo(docInfo);
        } else if (objType.isEnumType()) {
            EnumElementType elementType = objType.toMaybeEnumType().getElementsType();
            if (!InferJSDocInfo.isReferenceNameOf(elementType, qName)) {
                return;
            }
            objType.setJSDocInfo(docInfo);
            elementType.setJSDocInfo(docInfo);
        } else if (!objType.isNativeObjectType() && objType.isFunctionType()) {
            objType.setJSDocInfo(docInfo);
        }
    }

    private static boolean isReferenceNameOf(ObjectType type, String name) {
        return type.hasReferenceName() && type.getReferenceName().equals(name);
    }
}

