/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Ascii;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckConformance;
import com.google.javascript.jscomp.ClosureRewriteModule;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JsAst;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Requirement;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.TemplateAstMatcher;
import com.google.javascript.jscomp.TypeMatchingStrategy;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.parsing.JsDocInfoParser;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.protobuf.ProtocolStringList;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nullable;

@GwtIncompatible(value="java.lang.reflect, java.util.regex")
public final class ConformanceRules {
    private ConformanceRules() {
    }

    public static final class BanCreateDom
    extends AbstractRule {
        private final List<String[]> bannedTagAttrs = new ArrayList<String[]>();
        private final JSType domHelperType;
        private final JSType classNameTypes;
        private static final ImmutableMultimap<String, String> ELEMENT_TAG_NAMES = ImmutableMultimap.builder().put("HTMLAnchorElement", "a").put("HTMLAppletElement", "applet").put("HTMLAreaElement", "area").put("HTMLAudioElement", "audio").put("HTMLBRElement", "br").put("HTMLBaseElement", "base").put("HTMLBaseFontElement", "basefont").put("HTMLBodyElement", "body").put("HTMLButtonElement", "button").put("HTMLCanvasElement", "canvas").put("HTMLDListElement", "dl").put("HTMLDataListElement", "datalist").put("HTMLDetailsElement", "details").put("HTMLDialogElement", "dialog").put("HTMLDirectoryElement", "dir").put("HTMLDivElement", "div").put("HTMLEmbedElement", "embed").put("HTMLFieldSetElement", "fieldset").put("HTMLFontElement", "font").put("HTMLFormElement", "form").put("HTMLFrameElement", "frame").put("HTMLFrameSetElement", "frameset").put("HTMLHRElement", "hr").put("HTMLHeadElement", "head").put("HTMLHeadingElement", "h1").put("HTMLHeadingElement", "h2").put("HTMLHeadingElement", "h3").put("HTMLHeadingElement", "h4").put("HTMLHeadingElement", "h5").put("HTMLHeadingElement", "h6").put("HTMLHtmlElement", "html").put("HTMLIFrameElement", "iframe").put("HTMLImageElement", "img").put("HTMLInputElement", "input").put("HTMLIsIndexElement", "isindex").put("HTMLLIElement", "li").put("HTMLLabelElement", "label").put("HTMLLegendElement", "legend").put("HTMLLinkElement", "link").put("HTMLMapElement", "map").put("HTMLMenuElement", "menu").put("HTMLMetaElement", "meta").put("HTMLMeterElement", "meter").put("HTMLModElement", "del").put("HTMLModElement", "ins").put("HTMLOListElement", "ol").put("HTMLObjectElement", "object").put("HTMLOptGroupElement", "optgroup").put("HTMLOptionElement", "option").put("HTMLOutputElement", "output").put("HTMLParagraphElement", "p").put("HTMLParamElement", "param").put("HTMLPreElement", "pre").put("HTMLProgressElement", "progress").put("HTMLQuoteElement", "blockquote").put("HTMLQuoteElement", "q").put("HTMLScriptElement", "script").put("HTMLSelectElement", "select").put("HTMLSourceElement", "source").put("HTMLSpanElement", "span").put("HTMLStyleElement", "style").put("HTMLTableCaptionElement", "caption").put("HTMLTableCellElement", "td").put("HTMLTableCellElement", "th").put("HTMLTableColElement", "col").put("HTMLTableColElement", "colgroup").put("HTMLTableElement", "table").put("HTMLTableRowElement", "tr").put("HTMLTableSectionElement", "tbody").put("HTMLTableSectionElement", "tfoot").put("HTMLTableSectionElement", "thead").put("HTMLTemplateElement", "template").put("HTMLTextAreaElement", "textarea").put("HTMLTitleElement", "title").put("HTMLTrackElement", "track").put("HTMLUListElement", "ul").put("HTMLVideoElement", "video").build();

        public BanCreateDom(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
            for (String value : requirement.getValueList()) {
                String[] tagAttr = value.split("\\.");
                if (tagAttr.length != 2 || tagAttr[0].isEmpty() || tagAttr[1].isEmpty()) {
                    throw new CheckConformance.InvalidRequirementSpec("Values must be in the format tagname.attribute.");
                }
                tagAttr[0] = tagAttr[0].toLowerCase();
                this.bannedTagAttrs.add(tagAttr);
            }
            if (this.bannedTagAttrs.isEmpty()) {
                throw new CheckConformance.InvalidRequirementSpec("Specify one or more values.");
            }
            this.domHelperType = compiler.getTypeRegistry().getGlobalType("goog.dom.DomHelper");
            this.classNameTypes = compiler.getTypeRegistry().createUnionType(ImmutableList.of(compiler.getTypeRegistry().getNativeType(JSTypeNative.STRING_TYPE), compiler.getTypeRegistry().getNativeType(JSTypeNative.ARRAY_TYPE), compiler.getTypeRegistry().getNativeType(JSTypeNative.NULL_TYPE), compiler.getTypeRegistry().getNativeType(JSTypeNative.VOID_TYPE)));
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            boolean isClassName;
            if (!this.isCreateDomCall(n)) {
                return ConformanceResult.CONFORMANCE;
            }
            if (n.getChildCount() < 3) {
                return ConformanceResult.CONFORMANCE;
            }
            ImmutableCollection<String> tagNames = this.getTagNames(n.getSecondChild());
            Node attrs = n.getChildAtIndex(2);
            JSType attrsType = attrs.getJSType();
            if (attrsType == null) {
                return ConformanceResult.CONFORMANCE;
            }
            boolean bl = isClassName = !attrsType.isUnknownType() && attrsType.isSubtypeOf(this.classNameTypes);
            if (attrs.isNull() || attrsType != null && attrsType.isVoidType()) {
                return ConformanceResult.CONFORMANCE;
            }
            for (String[] tagAttr : this.bannedTagAttrs) {
                if (tagNames != null && !tagNames.contains(tagAttr[0]) && !tagAttr[0].equals("*")) continue;
                ConformanceResult violation = tagNames != null || tagAttr[0].equals("*") ? ConformanceResult.VIOLATION : (this.reportLooseTypeViolations ? ConformanceResult.POSSIBLE_VIOLATION : ConformanceResult.CONFORMANCE);
                if (isClassName) {
                    if (!tagAttr[1].equals("class")) continue;
                    return violation;
                }
                if (tagAttr[1].equals("textContent") && n.getChildCount() > 3 && violation != ConformanceResult.CONFORMANCE) {
                    return violation;
                }
                if (!attrs.isObjectLit()) {
                    return this.reportLooseTypeViolations ? ConformanceResult.POSSIBLE_VIOLATION : ConformanceResult.CONFORMANCE;
                }
                Node prop = NodeUtil.getFirstPropMatchingKey(attrs, tagAttr[1]);
                if (prop != null) {
                    if (NodeUtil.isSomeCompileTimeConstStringValue(prop)) continue;
                    return violation;
                }
                if (!Iterables.any(attrs.children(), child -> child.isComputedProp())) continue;
                return this.reportLooseTypeViolations ? ConformanceResult.POSSIBLE_VIOLATION : ConformanceResult.CONFORMANCE;
            }
            return ConformanceResult.CONFORMANCE;
        }

        private ImmutableCollection<String> getTagNames(Node tag) {
            if (tag.isString()) {
                return ImmutableSet.of(tag.getString().toLowerCase());
            }
            if (tag.isGetProp() && tag.getFirstChild().matchesQualifiedName("goog.dom.TagName")) {
                return ImmutableSet.of(tag.getLastChild().getString().toLowerCase());
            }
            JSType type = tag.getJSType();
            if (type == null || !type.isGenericObjectType()) {
                return null;
            }
            ObjectType typeAsObj = type.toMaybeObjectType();
            if (typeAsObj.getRawType().getDisplayName().equals("goog.dom.TagName")) {
                JSType tagType = Iterables.getOnlyElement(typeAsObj.getTemplateTypes());
                return ELEMENT_TAG_NAMES.get((Object)tagType.getDisplayName());
            }
            return null;
        }

        private boolean isCreateDomCall(Node n) {
            if (!n.isCall()) {
                return false;
            }
            Node target = n.getFirstChild();
            if (!target.isGetProp()) {
                return false;
            }
            if (!"createDom".equals(target.getLastChild().getString())) {
                return false;
            }
            Node srcObj = target.getFirstChild();
            if (srcObj.matchesQualifiedName("goog.dom")) {
                return true;
            }
            JSType type = srcObj.getJSType();
            if (type == null) {
                return false;
            }
            return type.isEquivalentTo(this.domHelperType);
        }
    }

    public static final class BanCreateElement
    extends AbstractRule {
        private final Set<String> bannedTags = new HashSet<String>();
        private final JSType domHelperType;
        private final JSType documentType;

        public BanCreateElement(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
            for (String value : requirement.getValueList()) {
                this.bannedTags.add(Ascii.toLowerCase(value));
            }
            if (this.bannedTags.isEmpty()) {
                throw new CheckConformance.InvalidRequirementSpec("Specify one or more values.");
            }
            this.domHelperType = compiler.getTypeRegistry().getGlobalType("goog.dom.DomHelper");
            this.documentType = compiler.getTypeRegistry().getGlobalType("Document");
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            Node tag;
            if (n.isCall() && (tag = n.getSecondChild()) != null && tag.isString() && this.bannedTags.contains(Ascii.toLowerCase(tag.getString()))) {
                return this.checkCreateElement(n);
            }
            return ConformanceResult.CONFORMANCE;
        }

        private ConformanceResult checkCreateElement(Node n) {
            Node target = n.getFirstChild();
            if (!target.isGetProp()) {
                return ConformanceResult.CONFORMANCE;
            }
            String functionName = target.getLastChild().getString();
            if (!"createElement".equals(functionName) && !"createDom".equals(functionName)) {
                return ConformanceResult.CONFORMANCE;
            }
            Node srcObj = target.getFirstChild();
            if (srcObj.matchesQualifiedName("goog.dom")) {
                return ConformanceResult.VIOLATION;
            }
            JSType type = srcObj.getJSType();
            if (type == null || type.isUnknownType() || type.isUnresolved() || type.isAllType()) {
                return this.reportLooseTypeViolations ? ConformanceResult.POSSIBLE_VIOLATION_DUE_TO_LOOSE_TYPES : ConformanceResult.CONFORMANCE;
            }
            if (this.domHelperType != null && this.domHelperType.isSubtypeOf(type) || this.documentType != null && this.documentType.isSubtypeOf(type)) {
                return ConformanceResult.VIOLATION;
            }
            return ConformanceResult.CONFORMANCE;
        }
    }

    public static final class RequireFileoverviewVisibility
    extends AbstractRule {
        public RequireFileoverviewVisibility(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            if (!n.isScript()) {
                return ConformanceResult.CONFORMANCE;
            }
            JSDocInfo docInfo = n.getJSDocInfo();
            if (docInfo == null || !docInfo.hasFileOverview()) {
                return ConformanceResult.VIOLATION;
            }
            JSDocInfo.Visibility v = docInfo.getVisibility();
            if (v == null || v == JSDocInfo.Visibility.INHERITED) {
                return ConformanceResult.VIOLATION;
            }
            return ConformanceResult.CONFORMANCE;
        }
    }

    public static final class BanGlobalVars
    extends AbstractRule {
        public BanGlobalVars(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            if (t.inGlobalScope() && NodeUtil.isDeclaration(n) && !n.getBooleanProp((byte)46) && !this.isWhitelisted(n)) {
                Node enclosingScript = NodeUtil.getEnclosingScript(n);
                if (enclosingScript != null && (enclosingScript.getBooleanProp((byte)87) || enclosingScript.getBooleanProp((byte)99))) {
                    return ConformanceResult.CONFORMANCE;
                }
                return ConformanceResult.VIOLATION;
            }
            return ConformanceResult.CONFORMANCE;
        }

        private boolean isWhitelisted(Node n) {
            return (NodeUtil.isNameDeclaration(n) || n.isFunction()) && this.isWhitelistedName(n.getFirstChild().getString());
        }

        private boolean isWhitelistedName(String name) {
            return name.equals("$jscomp") || name.startsWith("$jscomp$compprop") || ClosureRewriteModule.isModuleContent(name) || ClosureRewriteModule.isModuleExport(name);
        }
    }

    public static final class StrictBanUnresolvedType
    extends AbstractTypeRestrictionRule {
        public StrictBanUnresolvedType(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            JSType nonConformingPart = BanUnresolvedType.getNonConformingPart(n.getJSType());
            if (nonConformingPart != null && !this.isTypeImmediatelyTightened(n)) {
                return new ConformanceResult(ConformanceLevel.VIOLATION, "Reference to type '" + nonConformingPart + "' never resolved.");
            }
            return ConformanceResult.CONFORMANCE;
        }
    }

    public static final class BanUnresolvedType
    extends AbstractTypeRestrictionRule {
        public BanUnresolvedType(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            Node target;
            JSType type;
            JSType nonConformingPart;
            if (n.isGetProp() && (nonConformingPart = BanUnresolvedType.getNonConformingPart(type = (target = n.getFirstChild()).getJSType())) != null && !this.isTypeImmediatelyTightened(n)) {
                return new ConformanceResult(ConformanceLevel.VIOLATION, "Reference to type '" + nonConformingPart + "' never resolved.");
            }
            return ConformanceResult.CONFORMANCE;
        }

        @Nullable
        private static JSType getNonConformingPart(JSType type) {
            if (type == null) {
                return null;
            }
            if (type.isUnionType()) {
                for (JSType part : type.getUnionMembers()) {
                    JSType nonConformingPart = BanUnresolvedType.getNonConformingPart(part);
                    if (nonConformingPart == null) continue;
                    return nonConformingPart;
                }
            } else if (type.isUnresolved()) {
                return type;
            }
            return null;
        }
    }

    public static final class BanUnknownTypedClassPropsReferences
    extends AbstractTypeRestrictionRule {
        public BanUnknownTypedClassPropsReferences(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            if (n.isGetProp() && this.isSomeUnknownType(n) && this.isUsed(n) && !this.isTypeImmediatelyTightened(n) && this.isCheckablePropertySource(n.getFirstChild()) && !this.isTypeVariable(n) && !this.isDeclaredUnknown(n)) {
                String propName = n.getLastChild().getString();
                String typeName = n.getFirstChild().getJSType().toString();
                return new ConformanceResult(ConformanceLevel.VIOLATION, "The property \"" + propName + "\" on type \"" + typeName + "\"");
            }
            return ConformanceResult.CONFORMANCE;
        }

        private boolean isCheckablePropertySource(Node n) {
            return this.isKnown(n) && !this.isTop(n) && this.isClassType(n) && !this.isNativeObjectType(n) && !this.isWhitelistedType(n);
        }

        private boolean isClassType(Node n) {
            JSDocInfo info;
            FunctionType ctor;
            ObjectType type = n.getJSType().restrictByNotNullOrUndefined().toMaybeObjectType();
            return type != null && type.isInstanceType() && (ctor = type.getConstructor()) != null && (info = ctor.getJSDocInfo()) != null && info.isConstructorOrInterface();
        }

        private boolean isDeclaredUnknown(Node n) {
            JSTypeExpression expr;
            Node typeExprNode;
            JSDocInfo info;
            Node target = n.getFirstChild();
            ObjectType targetType = target.getJSType().toMaybeObjectType();
            return targetType != null && (info = targetType.getPropertyJSDocInfo(n.getLastChild().getString())) != null && info.hasType() && (typeExprNode = (expr = info.getType()).getRoot()).getToken() == Token.QMARK && !typeExprNode.hasChildren();
        }
    }

    public static final class BanUnknownDirectThisPropsReferences
    extends AbstractTypeRestrictionRule {
        public BanUnknownDirectThisPropsReferences(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            if (n.isGetProp() && this.isKnownThis(n.getFirstChild()) && this.isUnknown(n) && !this.isTypeVariable(n) && this.isUsed(n) && !this.isTypeImmediatelyTightened(n)) {
                return ConformanceResult.VIOLATION;
            }
            return ConformanceResult.CONFORMANCE;
        }

        private boolean isKnownThis(Node n) {
            return n.isThis() && !this.isUnknown(n);
        }
    }

    public static final class BanUnknownThis
    extends AbstractTypeRestrictionRule {
        private final Set<Node> reports = Sets.newIdentityHashSet();

        public BanUnknownThis(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            Node root;
            JSType type;
            if (n.isThis() && (type = n.getJSType()) != null && type.isUnknownType() && !this.isTypeImmediatelyTightened(n) && !this.reports.contains(root = t.getScopeRoot())) {
                this.reports.add(root);
                return ConformanceResult.VIOLATION;
            }
            return ConformanceResult.CONFORMANCE;
        }
    }

    public static final class BanNullDeref
    extends AbstractTypeRestrictionRule {
        public BanNullDeref(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            boolean violation;
            switch (n.getToken()) {
                case GETPROP: 
                case GETELEM: 
                case NEW: 
                case CALL: {
                    violation = this.report(n.getFirstChild());
                    break;
                }
                case IN: {
                    violation = this.report(n.getLastChild());
                    break;
                }
                default: {
                    violation = false;
                }
            }
            return violation ? ConformanceResult.VIOLATION : ConformanceResult.CONFORMANCE;
        }

        boolean report(Node n) {
            return n.getJSType() != null && this.isKnown(n) && this.invalidDeref(n) && !this.isWhitelistedType(n);
        }

        private boolean invalidDeref(Node n) {
            JSType type = n.getJSType();
            return !type.isAllType() && (type.isNullable() || type.isVoidable());
        }
    }

    public static final class BanThrowOfNonErrorTypes
    extends AbstractRule {
        final JSType errorObjType;

        public BanThrowOfNonErrorTypes(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
            this.errorObjType = compiler.getTypeRegistry().getGlobalType("Error");
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            JSType thrown;
            if (!(this.errorObjType == null || !n.isThrow() || (thrown = n.getFirstChild().getJSType()) == null || thrown.isUnknownType() || thrown.isAllType() || thrown.isEmptyType() || thrown.isSubtypeOf(this.errorObjType))) {
                return ConformanceResult.VIOLATION;
            }
            return ConformanceResult.CONFORMANCE;
        }
    }

    public static class RequireUseStrict
    extends AbstractRule {
        public RequireUseStrict(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
            if (!requirement.getValueList().isEmpty()) {
                throw new CheckConformance.InvalidRequirementSpec("invalid value");
            }
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            Set<String> directives;
            if (n.isScript() && ((directives = n.getDirectives()) == null || !directives.contains("use strict"))) {
                return ConformanceResult.VIOLATION;
            }
            return ConformanceResult.CONFORMANCE;
        }
    }

    public static final class BanExpose
    extends AbstractRule {
        public BanExpose(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            JSDocInfo info = n.getJSDocInfo();
            if (info != null && info.isExpose()) {
                return ConformanceResult.VIOLATION;
            }
            return ConformanceResult.CONFORMANCE;
        }
    }

    static class CustomRuleProxy
    implements CheckConformance.Rule {
        final CheckConformance.Rule customRule;
        private static final TypeToken<CheckConformance.Rule> RULE_TYPE = new TypeToken<CheckConformance.Rule>(){};
        private static final TypeToken<AbstractCompiler> COMPILER_TYPE = new TypeToken<AbstractCompiler>(){};
        private static final TypeToken<Requirement> REQUIREMENT_TYPE = new TypeToken<Requirement>(){};

        CustomRuleProxy(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            if (!requirement.hasJavaClass()) {
                throw new CheckConformance.InvalidRequirementSpec("missing java_class");
            }
            this.customRule = this.createRule(compiler, requirement);
        }

        @Override
        public void check(NodeTraversal t, Node n) {
            this.customRule.check(t, n);
        }

        private CheckConformance.Rule createRule(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            try {
                CheckConformance.Rule rule;
                Class<CheckConformance.Rule> custom = this.getRuleClass(requirement.getJavaClass());
                Constructor<?> ctor = this.getRuleConstructor(custom);
                try {
                    rule = (CheckConformance.Rule)ctor.newInstance(compiler, requirement);
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof CheckConformance.InvalidRequirementSpec) {
                        throw (CheckConformance.InvalidRequirementSpec)cause;
                    }
                    throw new RuntimeException(cause);
                }
                return rule;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }

        private Constructor<?> getRuleConstructor(Class<CheckConformance.Rule> cls) throws CheckConformance.InvalidRequirementSpec {
            for (Constructor<?> ctor : cls.getConstructors()) {
                Class<?>[] paramClasses = ctor.getParameterTypes();
                if (paramClasses.length != 2) continue;
                TypeToken<AbstractCompiler> param1 = TypeToken.of(paramClasses[0]);
                TypeToken<Requirement> param2 = TypeToken.of(paramClasses[1]);
                if (!param1.isSupertypeOf(COMPILER_TYPE) || !param2.isSupertypeOf(REQUIREMENT_TYPE)) continue;
                return ctor;
            }
            throw new CheckConformance.InvalidRequirementSpec("No valid class constructors found.");
        }

        private Class<CheckConformance.Rule> getRuleClass(String className) throws CheckConformance.InvalidRequirementSpec {
            Class<CheckConformance.Rule> customClass;
            try {
                customClass = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new CheckConformance.InvalidRequirementSpec("JavaClass not found.");
            }
            if (RULE_TYPE.isSupertypeOf(TypeToken.of(customClass))) {
                Class<CheckConformance.Rule> ruleClass = customClass;
                return ruleClass;
            }
            throw new CheckConformance.InvalidRequirementSpec("JavaClass is not a rule.");
        }
    }

    static class BannedCodePattern
    extends AbstractRule {
        private final ImmutableList<TemplateAstMatcher> restrictions;

        BannedCodePattern(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
            if (requirement.getValueCount() == 0) {
                throw new CheckConformance.InvalidRequirementSpec("missing value");
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (String value : requirement.getValueList()) {
                Node parseRoot = new JsAst(SourceFile.fromCode("template", value)).getAstRoot(compiler);
                if (!parseRoot.hasOneChild() || !parseRoot.getFirstChild().isFunction()) {
                    throw new CheckConformance.InvalidRequirementSpec("invalid conformance template: " + value);
                }
                Node templateRoot = parseRoot.getFirstChild();
                TemplateAstMatcher astMatcher = new TemplateAstMatcher(compiler.getTypeRegistry(), templateRoot, this.typeMatchingStrategy);
                builder.add(astMatcher);
            }
            this.restrictions = builder.build();
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            boolean possibleViolation = false;
            for (int i = 0; i < this.restrictions.size(); ++i) {
                TemplateAstMatcher matcher = (TemplateAstMatcher)this.restrictions.get(i);
                if (!matcher.matches(n)) continue;
                if (matcher.isLooseMatch()) {
                    possibleViolation = true;
                    continue;
                }
                return ConformanceResult.VIOLATION;
            }
            return possibleViolation && this.reportLooseTypeViolations ? ConformanceResult.POSSIBLE_VIOLATION_DUE_TO_LOOSE_TYPES : ConformanceResult.CONFORMANCE;
        }
    }

    static class RestrictedMethodCall
    extends AbstractRule {
        private final ImmutableList<Restriction> restrictions;

        RestrictedMethodCall(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
            if (requirement.getValueCount() == 0) {
                throw new CheckConformance.InvalidRequirementSpec("missing value");
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (String value : requirement.getValueList()) {
                String type = RestrictedMethodCall.getClassFromDeclarationName(value);
                String property = RestrictedMethodCall.getPropertyFromDeclarationName(value);
                String restrictedDecl = RestrictedMethodCall.getTypeFromValue(value);
                if (type == null || property == null || restrictedDecl == null) {
                    throw new CheckConformance.InvalidRequirementSpec("bad prop value");
                }
                FunctionType restrictedCallType = ConformanceUtil.evaluateTypeString(compiler, restrictedDecl).toMaybeFunctionType();
                if (restrictedCallType == null) {
                    throw new CheckConformance.InvalidRequirementSpec("invalid conformance type");
                }
                builder.add(new Restriction(type, property, restrictedCallType));
            }
            this.restrictions = builder.build();
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            if (NodeUtil.isGet(n) && ConformanceUtil.isCallTarget(n) && n.getLastChild().isString()) {
                for (int i = 0; i < this.restrictions.size(); ++i) {
                    Restriction r = (Restriction)this.restrictions.get(i);
                    ConformanceResult result = ConformanceResult.CONFORMANCE;
                    if (this.matchesProp(n, r)) {
                        result = this.checkConformance(t, n, r, false);
                    } else if (n.getLastChild().getString().equals("call") && this.matchesProp(n.getFirstChild(), r)) {
                        result = this.checkConformance(t, n, r, true);
                    }
                    if (result.level == ConformanceLevel.CONFORMANCE) continue;
                    return result;
                }
            }
            return ConformanceResult.CONFORMANCE;
        }

        private ConformanceResult checkConformance(NodeTraversal t, Node n, Restriction r, boolean isCallInvocation) {
            Node lhs;
            JSTypeRegistry registry = t.getCompiler().getTypeRegistry();
            JSType methodClassType = registry.getGlobalType(r.type);
            Node node = lhs = isCallInvocation ? n.getFirstFirstChild() : n.getFirstChild();
            if (methodClassType != null && lhs.getJSType() != null) {
                JSType targetType = lhs.getJSType().restrictByNotNullOrUndefined();
                if (targetType.isUnknownType() || targetType.isUnresolved() || targetType.isAllType() || targetType.isEquivalentTo(registry.getNativeType(JSTypeNative.OBJECT_TYPE))) {
                    if (this.reportLooseTypeViolations && !ConformanceUtil.validateCall(this.compiler, n.getParent(), r.restrictedCallType, isCallInvocation)) {
                        return ConformanceResult.POSSIBLE_VIOLATION_DUE_TO_LOOSE_TYPES;
                    }
                } else if (targetType.isSubtypeOf(methodClassType) && !ConformanceUtil.validateCall(this.compiler, n.getParent(), r.restrictedCallType, isCallInvocation)) {
                    return ConformanceResult.VIOLATION;
                }
            }
            return ConformanceResult.CONFORMANCE;
        }

        private boolean matchesProp(Node n, Restriction r) {
            return n.isGetProp() && n.getLastChild().getString().equals(r.property);
        }

        private static String getPropertyFromDeclarationName(String specName) throws CheckConformance.InvalidRequirementSpec {
            String[] parts = RestrictedMethodCall.removeTypeDecl(specName).split("\\.prototype\\.");
            Preconditions.checkState(parts.length == 1 || parts.length == 2);
            if (parts.length == 2) {
                return parts[1];
            }
            return null;
        }

        private static String getClassFromDeclarationName(String specName) throws CheckConformance.InvalidRequirementSpec {
            String tmp = RestrictedMethodCall.removeTypeDecl(specName);
            String[] parts = tmp.split("\\.prototype\\.");
            Preconditions.checkState(parts.length == 1 || parts.length == 2);
            if (parts.length == 2) {
                return parts[0];
            }
            return null;
        }

        private static String removeTypeDecl(String specName) throws CheckConformance.InvalidRequirementSpec {
            int index = specName.indexOf(58);
            if (index < 1) {
                throw new CheckConformance.InvalidRequirementSpec("value should be in the form NAME:TYPE");
            }
            return specName.substring(0, index);
        }

        private static String getTypeFromValue(String specName) {
            int index = specName.indexOf(58);
            if (index < 1) {
                return null;
            }
            return specName.substring(index + 1);
        }

        private static class Restriction {
            final String type;
            final String property;
            final FunctionType restrictedCallType;

            Restriction(String type, String property, FunctionType restrictedCallType) {
                this.type = type;
                this.property = property;
                this.restrictedCallType = restrictedCallType;
            }
        }
    }

    static class RestrictedNameCall
    extends AbstractRule {
        private final ImmutableList<Restriction> restrictions;

        RestrictedNameCall(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
            if (requirement.getValueCount() == 0) {
                throw new CheckConformance.InvalidRequirementSpec("missing value");
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (String value : requirement.getValueList()) {
                Node name = NodeUtil.newQName(compiler, RestrictedNameCall.getNameFromValue(value));
                String restrictedDecl = RestrictedNameCall.getTypeFromValue(value);
                if (name == null || restrictedDecl == null) {
                    throw new CheckConformance.InvalidRequirementSpec("bad prop value");
                }
                FunctionType restrictedCallType = ConformanceUtil.evaluateTypeString(compiler, restrictedDecl).toMaybeFunctionType();
                if (restrictedCallType == null) {
                    throw new CheckConformance.InvalidRequirementSpec("invalid conformance type");
                }
                builder.add(new Restriction(name, restrictedCallType));
            }
            this.restrictions = builder.build();
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            if (ConformanceUtil.isCallTarget(n) && n.isQualifiedName()) {
                for (int i = 0; i < this.restrictions.size(); ++i) {
                    Restriction r = (Restriction)this.restrictions.get(i);
                    if (!(n.matchesQualifiedName(r.name) ? !ConformanceUtil.validateCall(this.compiler, n.getParent(), r.restrictedCallType, false) : n.isGetProp() && n.getLastChild().getString().equals("call") && n.getFirstChild().matchesQualifiedName(r.name) && !ConformanceUtil.validateCall(this.compiler, n.getParent(), r.restrictedCallType, true))) continue;
                    return ConformanceResult.VIOLATION;
                }
            }
            return ConformanceResult.CONFORMANCE;
        }

        private static String getNameFromValue(String specName) {
            int index = specName.indexOf(58);
            if (index < 1) {
                return null;
            }
            return specName.substring(0, index);
        }

        private static String getTypeFromValue(String specName) {
            int index = specName.indexOf(58);
            if (index < 1) {
                return null;
            }
            return specName.substring(index + 1);
        }

        private static class Restriction {
            final Node name;
            final FunctionType restrictedCallType;

            Restriction(Node name, FunctionType restrictedCallType) {
                this.name = name;
                this.restrictedCallType = restrictedCallType;
            }
        }
    }

    private static class ConformanceUtil {
        private ConformanceUtil() {
        }

        static boolean isCallTarget(Node n) {
            Node parent = n.getParent();
            return (parent.isCall() || parent.isNew()) && parent.getFirstChild() == n;
        }

        static JSType evaluateTypeString(AbstractCompiler compiler, String expression) throws CheckConformance.InvalidRequirementSpec {
            Node typeNodes = JsDocInfoParser.parseTypeString(expression);
            if (typeNodes == null) {
                throw new CheckConformance.InvalidRequirementSpec("bad type expression");
            }
            JSTypeExpression typeExpr = new JSTypeExpression(typeNodes, "conformance");
            return compiler.getTypeRegistry().evaluateTypeExpressionInGlobalScope(typeExpr);
        }

        static boolean validateCall(AbstractCompiler compiler, Node callOrNew, FunctionType functionType, boolean isCallInvocation) {
            Preconditions.checkState(callOrNew.isCall() || callOrNew.isNew());
            return ConformanceUtil.validateParameterList(compiler, callOrNew, functionType, isCallInvocation) && ConformanceUtil.validateThis(callOrNew, functionType, isCallInvocation);
        }

        private static boolean validateThis(Node callOrNew, FunctionType functionType, boolean isCallInvocation) {
            if (callOrNew.isNew()) {
                return true;
            }
            JSType thisType = functionType.getTypeOfThis();
            if (thisType == null || thisType.isUnknownType()) {
                return true;
            }
            Node thisNode = isCallInvocation ? callOrNew.getSecondChild() : callOrNew.getFirstFirstChild();
            JSType thisNodeType = thisNode.getJSType().restrictByNotNullOrUndefined();
            return thisNodeType.isSubtypeOf(thisType);
        }

        private static boolean validateParameterList(AbstractCompiler compiler, Node callOrNew, FunctionType functionType, boolean isCallInvocation) {
            Iterator<Node> arguments = callOrNew.children().iterator();
            arguments.next();
            if (isCallInvocation && arguments.hasNext()) {
                arguments.next();
            }
            ImmutableList.Builder argumentTypes = ImmutableList.builder();
            while (arguments.hasNext()) {
                JSType argType = arguments.next().getJSType();
                if (argType == null) {
                    argType = compiler.getTypeRegistry().getNativeType(JSTypeNative.UNKNOWN_TYPE);
                }
                argumentTypes.add(argType);
            }
            return functionType.acceptsArguments((List<? extends JSType>)((Object)argumentTypes.build()));
        }
    }

    static class BannedProperty
    extends AbstractRule {
        private final ImmutableList<Property> props;
        private final Requirement.Type requirementType;

        BannedProperty(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
            if (requirement.getValueCount() == 0) {
                throw new CheckConformance.InvalidRequirementSpec("missing value");
            }
            Preconditions.checkArgument(requirement.getType() == Requirement.Type.BANNED_PROPERTY || requirement.getType() == Requirement.Type.BANNED_PROPERTY_READ || requirement.getType() == Requirement.Type.BANNED_PROPERTY_WRITE || requirement.getType() == Requirement.Type.BANNED_PROPERTY_NON_CONSTANT_WRITE || requirement.getType() == Requirement.Type.BANNED_PROPERTY_CALL);
            this.requirementType = requirement.getType();
            ImmutableList.Builder builder = ImmutableList.builder();
            ProtocolStringList values = requirement.getValueList();
            for (String value : values) {
                String type = BannedProperty.getClassFromDeclarationName(value);
                String property = BannedProperty.getPropertyFromDeclarationName(value);
                if (type == null || property == null) {
                    throw new CheckConformance.InvalidRequirementSpec("bad prop value");
                }
                builder.add(new Property(type, property));
            }
            this.props = builder.build();
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            if (NodeUtil.isGet(n) && n.getLastChild().isString()) {
                for (int i = 0; i < this.props.size(); ++i) {
                    Property prop = (Property)this.props.get(i);
                    ConformanceResult result = this.checkConformance(t, n, prop);
                    if (result.level == ConformanceLevel.CONFORMANCE) continue;
                    return result;
                }
            }
            return ConformanceResult.CONFORMANCE;
        }

        private ConformanceResult checkConformance(NodeTraversal t, Node propAccess, Property prop) {
            if (this.isCandidatePropUse(propAccess, prop)) {
                JSTypeRegistry registry = t.getCompiler().getTypeRegistry();
                JSType typeWithBannedProp = registry.getGlobalType(prop.type);
                Node receiver = propAccess.getFirstChild();
                if (typeWithBannedProp != null && receiver.getJSType() != null) {
                    JSType foundType = receiver.getJSType().restrictByNotNullOrUndefined();
                    ObjectType foundObj = foundType.toMaybeObjectType();
                    if (foundObj != null) {
                        if (foundObj.isFunctionPrototypeType()) {
                            FunctionType ownerFun = foundObj.getOwnerFunction();
                            if (ownerFun.isConstructor()) {
                                foundType = ownerFun.getInstanceType();
                            }
                        } else if (foundObj.isGenericObjectType()) {
                            foundType = foundObj.getRawType();
                        }
                    }
                    if (foundType.isSomeUnknownType() || foundType.isTypeVariable() || foundType.isEmptyType() || foundType.isAllType() || foundType.isEquivalentTo(registry.getNativeType(JSTypeNative.OBJECT_TYPE))) {
                        if (this.reportLooseTypeViolations) {
                            return ConformanceResult.POSSIBLE_VIOLATION_DUE_TO_LOOSE_TYPES;
                        }
                    } else {
                        if (foundType.isSubtypeOf(typeWithBannedProp)) {
                            return ConformanceResult.VIOLATION;
                        }
                        if (typeWithBannedProp.isSubtypeWithoutStructuralTyping(foundType)) {
                            if (this.matchesPrototype(typeWithBannedProp, foundType)) {
                                return ConformanceResult.VIOLATION;
                            }
                            if (this.reportLooseTypeViolations) {
                                return ConformanceResult.POSSIBLE_VIOLATION_DUE_TO_LOOSE_TYPES;
                            }
                        }
                    }
                }
            }
            return ConformanceResult.CONFORMANCE;
        }

        private boolean matchesPrototype(JSType type, JSType maybePrototype) {
            ObjectType methodClassObjectType = type.toMaybeObjectType();
            return methodClassObjectType != null && methodClassObjectType.getPrototypeObject().isEquivalentTo(maybePrototype);
        }

        private boolean isCandidatePropUse(Node propAccess, Property prop) {
            Preconditions.checkState(propAccess.isGetProp() || propAccess.isGetElem(), "Expected property-access node but found %s", (Object)propAccess);
            if (propAccess.getLastChild().getString().equals(prop.property)) {
                if (this.requirementType == Requirement.Type.BANNED_PROPERTY_WRITE) {
                    return NodeUtil.isLValue(propAccess);
                }
                if (this.requirementType == Requirement.Type.BANNED_PROPERTY_NON_CONSTANT_WRITE) {
                    if (!NodeUtil.isLValue(propAccess)) {
                        return false;
                    }
                    return !NodeUtil.isLhsOfAssign(propAccess) || !NodeUtil.isLiteralValue(propAccess.getNext(), false) && !NodeUtil.isSomeCompileTimeConstStringValue(propAccess.getNext());
                }
                if (this.requirementType == Requirement.Type.BANNED_PROPERTY_READ) {
                    return !NodeUtil.isLValue(propAccess) && NodeUtil.isExpressionResultUsed(propAccess);
                }
                if (this.requirementType == Requirement.Type.BANNED_PROPERTY_CALL) {
                    return ConformanceUtil.isCallTarget(propAccess);
                }
                return true;
            }
            return false;
        }

        private static String getPropertyFromDeclarationName(String specName) {
            String[] parts = specName.split("\\.prototype\\.");
            Preconditions.checkState(parts.length == 1 || parts.length == 2);
            if (parts.length == 2) {
                return parts[1];
            }
            return null;
        }

        private static String getClassFromDeclarationName(String specName) {
            String[] parts = specName.split("\\.prototype\\.");
            Preconditions.checkState(parts.length == 1 || parts.length == 2);
            if (parts.length == 2) {
                return parts[0];
            }
            return null;
        }

        private static class Property {
            final String type;
            final String property;

            Property(String type, String property) {
                this.type = type;
                this.property = property;
            }
        }
    }

    static class BannedName
    extends AbstractRule {
        private final Requirement.Type requirementType;
        private final ImmutableList<Node> names;

        BannedName(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
            if (requirement.getValueCount() == 0) {
                throw new CheckConformance.InvalidRequirementSpec("missing value");
            }
            this.requirementType = requirement.getType();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (String name : requirement.getValueList()) {
                builder.add(NodeUtil.newQName(compiler, name));
            }
            this.names = builder.build();
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            if (this.isCandidateNode(n)) {
                if (this.requirementType == Requirement.Type.BANNED_NAME_CALL && !ConformanceUtil.isCallTarget(n)) {
                    return ConformanceResult.CONFORMANCE;
                }
                for (int i = 0; i < this.names.size(); ++i) {
                    Node nameNode = (Node)this.names.get(i);
                    if (!n.matchesQualifiedName(nameNode) || !BannedName.isRootOfQualifiedNameGlobal(t, n)) continue;
                    if (NodeUtil.isInSyntheticScript(n)) {
                        return ConformanceResult.CONFORMANCE;
                    }
                    return ConformanceResult.VIOLATION;
                }
            }
            return ConformanceResult.CONFORMANCE;
        }

        private boolean isCandidateNode(Node n) {
            switch (n.getToken()) {
                case GETPROP: {
                    return n.getFirstChild().isQualifiedName();
                }
                case NAME: {
                    return !n.getString().isEmpty();
                }
            }
            return false;
        }

        private static boolean isRootOfQualifiedNameGlobal(NodeTraversal t, Node n) {
            String rootName = NodeUtil.getRootOfQualifiedName(n).getQualifiedName();
            Var v = (Var)t.getScope().getVar(rootName);
            return v != null && v.isGlobal();
        }
    }

    static class BannedDependency
    extends AbstractRule {
        private final List<String> paths;

        BannedDependency(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
            this.paths = requirement.getValueList();
            if (this.paths.isEmpty()) {
                throw new CheckConformance.InvalidRequirementSpec("missing value");
            }
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            if (n.isScript()) {
                String srcFile = n.getSourceFileName();
                for (int i = 0; i < this.paths.size(); ++i) {
                    String path = this.paths.get(i);
                    if (!srcFile.startsWith(path)) continue;
                    return ConformanceResult.VIOLATION;
                }
            }
            return ConformanceResult.CONFORMANCE;
        }
    }

    static class InferredConstCheck
    extends AbstractRule {
        public InferredConstCheck(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
        }

        @Override
        protected ConformanceResult checkConformance(NodeTraversal t, Node n) {
            JSDocInfo jsDoc = n.getJSDocInfo();
            if (jsDoc != null && jsDoc.hasConstAnnotation() && jsDoc.getType() == null) {
                JSType type;
                if (n.isAssign()) {
                    n = n.getFirstChild();
                }
                if ((type = n.getJSType()) != null && type.isUnknownType() && !NodeUtil.isNamespaceDecl(n)) {
                    return ConformanceResult.VIOLATION;
                }
            }
            return ConformanceResult.CONFORMANCE;
        }
    }

    static abstract class AbstractTypeRestrictionRule
    extends AbstractRule {
        private final JSType nativeObjectType;
        private final JSType whitelistedTypes;
        private final ImmutableList<Node> assertionsFunctionNames;

        public AbstractTypeRestrictionRule(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            super(compiler, requirement);
            this.nativeObjectType = compiler.getTypeRegistry().getNativeType(JSTypeNative.OBJECT_TYPE);
            ProtocolStringList whitelistedTypeNames = requirement.getValueList();
            this.whitelistedTypes = this.union(whitelistedTypeNames);
            ImmutableList.Builder builder = ImmutableList.builder();
            for (CodingConvention.AssertionFunctionSpec fn : compiler.getCodingConvention().getAssertionFunctions()) {
                builder.add(NodeUtil.newQName(compiler, fn.getFunctionName()));
            }
            this.assertionsFunctionNames = builder.build();
        }

        protected boolean isWhitelistedType(Node n) {
            JSType targetType;
            return this.whitelistedTypes != null && n.getJSType() != null && (targetType = n.getJSType().restrictByNotNullOrUndefined()).isSubtypeOf(this.whitelistedTypes);
        }

        protected boolean isKnown(Node n) {
            return !this.isUnknown(n) && !this.isBottom(n) && !this.isTypeVariable(n);
        }

        protected boolean isNativeObjectType(Node n) {
            JSType type = n.getJSType().restrictByNotNullOrUndefined();
            return type.isEquivalentTo(this.nativeObjectType);
        }

        protected boolean isTop(Node n) {
            JSType type = n.getJSType();
            return type != null && type.isAllType();
        }

        protected boolean isUnknown(Node n) {
            JSType type = n.getJSType();
            return type == null || type.isUnknownType();
        }

        protected boolean isSomeUnknownType(Node n) {
            JSType type = n.getJSType();
            return type == null || type.isSomeUnknownType();
        }

        protected boolean isTypeVariable(Node n) {
            JSType type = n.getJSType().restrictByNotNullOrUndefined();
            return type.isTypeVariable();
        }

        private boolean isBottom(Node n) {
            JSType type = n.getJSType().restrictByNotNullOrUndefined();
            return type.isEmptyType();
        }

        protected JSType union(List<String> typeNames) {
            JSTypeRegistry registry = this.compiler.getTypeRegistry();
            ArrayList<JSType> types = new ArrayList<JSType>();
            for (String typeName : typeNames) {
                JSType type = registry.getGlobalType(typeName);
                if (type == null) continue;
                types.add(type);
            }
            if (types.isEmpty()) {
                return null;
            }
            return registry.createUnionType(types);
        }

        protected boolean isAssertionCall(Node n) {
            if (n.isCall() && n.getFirstChild().isQualifiedName()) {
                Node target = n.getFirstChild();
                for (int i = 0; i < this.assertionsFunctionNames.size(); ++i) {
                    if (!target.matchesQualifiedName((Node)this.assertionsFunctionNames.get(i))) continue;
                    return true;
                }
            }
            return false;
        }

        protected boolean isTypeImmediatelyTightened(Node n) {
            return this.isAssertionCall(n.getParent()) || n.getParent().isTypeOf() || n.getJSTypeBeforeCast() != null;
        }

        protected boolean isUsed(Node n) {
            return !n.getParent().isName() && (NodeUtil.isAssignmentOp(n.getParent()) ? NodeUtil.isExpressionResultUsed(n.getParent()) : NodeUtil.isExpressionResultUsed(n));
        }
    }

    public static abstract class AbstractRule
    implements CheckConformance.Rule {
        final AbstractCompiler compiler;
        final String message;
        final Requirement.Severity severity;
        final ImmutableList<String> whitelist;
        final ImmutableList<String> onlyApplyTo;
        @Nullable
        final Pattern whitelistRegexp;
        @Nullable
        final Pattern onlyApplyToRegexp;
        final boolean reportLooseTypeViolations;
        final TypeMatchingStrategy typeMatchingStrategy;

        public AbstractRule(AbstractCompiler compiler, Requirement requirement) throws CheckConformance.InvalidRequirementSpec {
            if (!requirement.hasErrorMessage()) {
                throw new CheckConformance.InvalidRequirementSpec("missing message");
            }
            this.compiler = compiler;
            this.message = requirement.getErrorMessage();
            this.severity = requirement.getSeverity() == Requirement.Severity.UNSPECIFIED ? Requirement.Severity.WARNING : requirement.getSeverity();
            this.whitelist = ImmutableList.copyOf(requirement.getWhitelistList());
            this.whitelistRegexp = AbstractRule.buildPattern(requirement.getWhitelistRegexpList());
            this.onlyApplyTo = ImmutableList.copyOf(requirement.getOnlyApplyToList());
            this.onlyApplyToRegexp = AbstractRule.buildPattern(requirement.getOnlyApplyToRegexpList());
            this.reportLooseTypeViolations = requirement.getReportLooseTypeViolations();
            this.typeMatchingStrategy = AbstractRule.getTypeMatchingStrategy(requirement);
        }

        private static TypeMatchingStrategy getTypeMatchingStrategy(Requirement requirement) {
            switch (requirement.getTypeMatchingStrategy()) {
                case LOOSE: {
                    return TypeMatchingStrategy.LOOSE;
                }
                case STRICT_NULLABILITY: {
                    return TypeMatchingStrategy.STRICT_NULLABILITY;
                }
                case SUBTYPES: {
                    return TypeMatchingStrategy.SUBTYPES;
                }
                case EXACT: {
                    return TypeMatchingStrategy.EXACT;
                }
            }
            throw new IllegalStateException("Unknown TypeMatchingStrategy");
        }

        @Nullable
        private static Pattern buildPattern(List<String> reqPatterns) throws CheckConformance.InvalidRequirementSpec {
            if (reqPatterns == null || reqPatterns.isEmpty()) {
                return null;
            }
            for (String reqPattern : reqPatterns) {
                try {
                    Pattern.compile(reqPattern);
                }
                catch (PatternSyntaxException e) {
                    throw new CheckConformance.InvalidRequirementSpec("invalid regex pattern");
                }
            }
            Pattern pattern = null;
            try {
                String jointRegExp = "(" + Joiner.on("|").join(reqPatterns) + ")";
                pattern = Pattern.compile(jointRegExp);
            }
            catch (PatternSyntaxException e) {
                throw new RuntimeException("bad joined regexp", e);
            }
            return pattern;
        }

        protected abstract ConformanceResult checkConformance(NodeTraversal var1, Node var2);

        protected final boolean shouldCheckConformance(Node n) {
            String srcfile = NodeUtil.getSourceName(n);
            if (srcfile == null) {
                return true;
            }
            if (!this.onlyApplyTo.isEmpty() || this.onlyApplyToRegexp != null) {
                return AbstractRule.pathIsInListOrRegexp(srcfile, this.onlyApplyTo, this.onlyApplyToRegexp) && !AbstractRule.pathIsInListOrRegexp(srcfile, this.whitelist, this.whitelistRegexp);
            }
            return !AbstractRule.pathIsInListOrRegexp(srcfile, this.whitelist, this.whitelistRegexp);
        }

        private static boolean pathIsInListOrRegexp(String srcfile, ImmutableList<String> list, @Nullable Pattern regexp) {
            for (int i = 0; i < list.size(); ++i) {
                String entry = (String)list.get(i);
                if (entry.isEmpty() || !srcfile.startsWith(entry)) continue;
                return true;
            }
            return regexp != null && regexp.matcher(srcfile).find();
        }

        @Override
        public final void check(NodeTraversal t, Node n) {
            ConformanceResult result = this.checkConformance(t, n);
            if (result.level != ConformanceLevel.CONFORMANCE && this.shouldCheckConformance(n)) {
                this.report(t, n, result);
            }
        }

        protected void report(NodeTraversal t, Node n, ConformanceResult result) {
            DiagnosticType msg = this.severity == Requirement.Severity.ERROR ? CheckConformance.CONFORMANCE_ERROR : (result.level == ConformanceLevel.VIOLATION ? CheckConformance.CONFORMANCE_VIOLATION : CheckConformance.CONFORMANCE_POSSIBLE_VIOLATION);
            String separator = result.note.isEmpty() ? "" : "\n";
            t.report(n, msg, this.message, separator, result.note);
        }
    }

    public static enum ConformanceLevel {
        CONFORMANCE,
        POSSIBLE_VIOLATION,
        VIOLATION;

    }

    public static class ConformanceResult {
        public final ConformanceLevel level;
        public final String note;
        public static final ConformanceResult CONFORMANCE = new ConformanceResult(ConformanceLevel.CONFORMANCE);
        public static final ConformanceResult POSSIBLE_VIOLATION = new ConformanceResult(ConformanceLevel.POSSIBLE_VIOLATION);
        private static final ConformanceResult POSSIBLE_VIOLATION_DUE_TO_LOOSE_TYPES = new ConformanceResult(ConformanceLevel.POSSIBLE_VIOLATION, "The type information available for this expression is too loose to ensure conformance.");
        public static final ConformanceResult VIOLATION = new ConformanceResult(ConformanceLevel.VIOLATION);

        ConformanceResult(ConformanceLevel level) {
            this(level, "");
        }

        ConformanceResult(ConformanceLevel level, String note) {
            this.level = level;
            this.note = note;
        }
    }
}

