/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.deps;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.deps.DependencyInfo;
import com.google.javascript.jscomp.deps.SortedDependencies;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Es6SortedDependencies<INPUT extends DependencyInfo>
implements SortedDependencies<INPUT> {
    private final List<INPUT> userOrderedInputs = new ArrayList<INPUT>();
    private final List<INPUT> importOrderedInputs = new ArrayList<INPUT>();
    private final Set<INPUT> completedInputs = new HashSet<INPUT>();
    private final List<INPUT> nonExportingInputs = new ArrayList<INPUT>();
    private final Map<String, INPUT> exportingInputBySymbolName = new HashMap<String, INPUT>();
    private final Multimap<INPUT, INPUT> importedInputByImportingInput = LinkedHashMultimap.create();

    public Es6SortedDependencies(List<INPUT> userOrderedInputs) {
        this.userOrderedInputs.addAll(userOrderedInputs);
        this.processInputs();
    }

    @Override
    public List<INPUT> getDependenciesOf(List<INPUT> rootInputs, boolean sorted) {
        Preconditions.checkArgument((boolean)this.userOrderedInputs.containsAll(rootInputs));
        HashSet<DependencyInfo> includedInputs = new HashSet<DependencyInfo>();
        ArrayDeque<INPUT> worklist = new ArrayDeque<INPUT>(rootInputs);
        while (!worklist.isEmpty()) {
            DependencyInfo input = (DependencyInfo)worklist.pop();
            if (!includedInputs.add(input)) continue;
            for (String symbolName : input.getRequires()) {
                DependencyInfo importedSymbolName = (DependencyInfo)this.exportingInputBySymbolName.get(symbolName);
                if (importedSymbolName == null) continue;
                worklist.add(importedSymbolName);
            }
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (DependencyInfo input : sorted ? this.importOrderedInputs : this.userOrderedInputs) {
            if (!includedInputs.contains(input)) continue;
            builder.add((Object)input);
        }
        return builder.build();
    }

    @Override
    public INPUT getInputProviding(String symbolName) throws SortedDependencies.MissingProvideException {
        if (this.exportingInputBySymbolName.containsKey(symbolName)) {
            return (INPUT)((DependencyInfo)this.exportingInputBySymbolName.get(symbolName));
        }
        throw new SortedDependencies.MissingProvideException(symbolName);
    }

    @Override
    public List<INPUT> getInputsWithoutProvides() {
        return Collections.unmodifiableList(this.nonExportingInputs);
    }

    @Override
    public List<INPUT> getSortedDependenciesOf(List<INPUT> roots) {
        return this.getDependenciesOf(roots, true);
    }

    @Override
    public List<INPUT> getSortedList() {
        return Collections.unmodifiableList(this.importOrderedInputs);
    }

    @Override
    public INPUT maybeGetInputProviding(String symbol) {
        return (INPUT)((DependencyInfo)this.exportingInputBySymbolName.get(symbol));
    }

    private void orderInput(INPUT input) {
        if (this.completedInputs.contains(input)) {
            return;
        }
        this.completedInputs.add(input);
        for (DependencyInfo importedInput : this.importedInputByImportingInput.get(input)) {
            this.orderInput(importedInput);
        }
        this.importOrderedInputs.add(input);
    }

    private void processInputs() {
        for (DependencyInfo userOrderedInput : this.userOrderedInputs) {
            if (userOrderedInput.getProvides().isEmpty()) {
                this.nonExportingInputs.add(userOrderedInput);
            }
            for (String providedSymbolName : userOrderedInput.getProvides()) {
                this.exportingInputBySymbolName.put(providedSymbolName, userOrderedInput);
            }
        }
        for (DependencyInfo userOrderedInput : this.userOrderedInputs) {
            for (String symbolName : userOrderedInput.getRequires()) {
                DependencyInfo importedInput = (DependencyInfo)this.exportingInputBySymbolName.get(symbolName);
                if (importedInput == null) continue;
                this.importedInputByImportingInput.put((Object)userOrderedInput, (Object)importedInput);
            }
        }
        for (DependencyInfo userOrderedInput : this.userOrderedInputs) {
            this.orderInput(userOrderedInput);
        }
        this.completedInputs.clear();
        this.importedInputByImportingInput.clear();
    }
}

