/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.ReferenceCollectingCallback;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.VarCheck;
import com.google.javascript.rhino.Node;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

class VariableReferenceCheck
implements HotSwapCompilerPass {
    static final DiagnosticType EARLY_REFERENCE = DiagnosticType.warning("JSC_REFERENCE_BEFORE_DECLARE", "Variable referenced before declaration: {0}");
    static final DiagnosticType REDECLARED_VARIABLE = DiagnosticType.warning("JSC_REDECLARED_VARIABLE", "Redeclared variable: {0}");
    static final DiagnosticType AMBIGUOUS_FUNCTION_DECL = DiagnosticType.error("AMBIGUOUS_FUNCTION_DECL", "Ambiguous use of a named function: {0}.");
    static final DiagnosticType EARLY_REFERENCE_ERROR = DiagnosticType.error("JSC_REFERENCE_BEFORE_DECLARE_ERROR", "Illegal variable reference before declaration: {0}");
    static final DiagnosticType REASSIGNED_CONSTANT = DiagnosticType.error("JSC_REASSIGNED_CONSTANT", "Constant reassigned: {0}");
    static final DiagnosticType REDECLARED_VARIABLE_ERROR = DiagnosticType.error("JSC_REDECLARED_VARIABLE_ERROR", "Illegal redeclared variable: {0}");
    static final DiagnosticType DECLARATION_NOT_DIRECTLY_IN_BLOCK = DiagnosticType.error("JSC_DECLARATION_NOT_DIRECTLY_IN_BLOCK", "Block-scoped declaration not directly within block: {0}");
    static final DiagnosticType UNUSED_LOCAL_ASSIGNMENT = DiagnosticType.disabled("JSC_UNUSED_LOCAL_ASSIGNMENT", "Value assigned to local variable {0} is never read");
    private final AbstractCompiler compiler;
    private final Set<ReferenceCollectingCallback.BasicBlock> blocksWithDeclarations = new HashSet<ReferenceCollectingCallback.BasicBlock>();

    public VariableReferenceCheck(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        ReferenceCollectingCallback callback = new ReferenceCollectingCallback(this.compiler, new ReferenceCheckingBehavior());
        callback.process(externs, root);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        ReferenceCollectingCallback callback = new ReferenceCollectingCallback(this.compiler, new ReferenceCheckingBehavior());
        callback.hotSwapScript(scriptRoot, originalRoot);
    }

    private class ReferenceCheckingBehavior
    implements ReferenceCollectingCallback.Behavior {
        private ReferenceCheckingBehavior() {
        }

        @Override
        public void afterExitScope(NodeTraversal t, ReferenceCollectingCallback.ReferenceMap referenceMap) {
            Scope scope = t.getScope();
            Iterator it = scope.getVars();
            while (it.hasNext()) {
                Var v = (Var)it.next();
                ReferenceCollectingCallback.ReferenceCollection referenceCollection = referenceMap.getReferences(v);
                if (referenceCollection == null) continue;
                if (scope.getRootNode().isFunction() && v.isDefaultParam()) {
                    this.checkDefaultParam(v, scope);
                }
                if (scope.getRootNode().isFunction()) {
                    this.checkShadowParam(v, scope, referenceCollection.references);
                }
                this.checkVar(v, referenceCollection.references);
            }
        }

        private void checkDefaultParam(Var v, Scope scope) {
            ShallowReferenceCollector check = new ShallowReferenceCollector();
            NodeTraversal.traverseEs6(VariableReferenceCheck.this.compiler, v.getParentNode().getChildAtIndex(1), check);
            for (Node ref : check.currParamReferences) {
                String refName = ref.getString();
                if (scope.isDeclared(refName, true)) continue;
                VariableReferenceCheck.this.compiler.report(JSError.make(ref, EARLY_REFERENCE_ERROR, v.name));
            }
        }

        private void checkShadowParam(Var v, Scope functionScope, List<ReferenceCollectingCallback.Reference> references) {
            Var maybeParam = functionScope.getVar(v.getName());
            if (maybeParam != null && maybeParam.isParam() && maybeParam.getScope() == functionScope) {
                for (ReferenceCollectingCallback.Reference r : references) {
                    if (!r.isVarDeclaration() && !r.isHoistedFunction() || r.getNode().equals(v.getNameNode())) continue;
                    VariableReferenceCheck.this.compiler.report(JSError.make(r.getNode(), REDECLARED_VARIABLE, v.name));
                }
            }
        }

        private void checkVar(Var v, List<ReferenceCollectingCallback.Reference> references) {
            VariableReferenceCheck.this.blocksWithDeclarations.clear();
            boolean isDeclaredInScope = false;
            boolean isUnhoistedNamedFunction = false;
            boolean hasErrors = false;
            boolean isRead = false;
            ReferenceCollectingCallback.Reference hoistedFn = null;
            ReferenceCollectingCallback.Reference unusedAssignment = null;
            for (ReferenceCollectingCallback.Reference reference : references) {
                if (reference.isHoistedFunction()) {
                    VariableReferenceCheck.this.blocksWithDeclarations.add(reference.getBasicBlock());
                    isDeclaredInScope = true;
                    hoistedFn = reference;
                    break;
                }
                if (!NodeUtil.isFunctionDeclaration(reference.getNode().getParent())) continue;
                isUnhoistedNamedFunction = true;
            }
            for (ReferenceCollectingCallback.Reference reference : references) {
                if (reference == hoistedFn) continue;
                ReferenceCollectingCallback.BasicBlock basicBlock = reference.getBasicBlock();
                boolean isDeclaration = reference.isDeclaration();
                Node referenceNode = reference.getNode();
                boolean isAssignment = isDeclaration || reference.isLvalue();
                boolean allowDupe = VarCheck.hasDuplicateDeclarationSuppression(referenceNode, v);
                boolean letConstShadowsVar = v.getParentNode().isVar() && (reference.isLetDeclaration() || reference.isConstDeclaration());
                boolean shadowCatchVar = isDeclaration && VariableReferenceCheck.this.compiler.getLanguageMode().isEs6OrHigher() && v.getParentNode().isCatch() && reference.getNode() != v.getNode();
                boolean shadowParam = isDeclaration && NodeUtil.isBlockScopedDeclaration(referenceNode) && v.isParam() && v.getScope() == reference.getScope().getParentScope();
                boolean shadowDetected = false;
                if (isDeclaration && !allowDupe) {
                    for (ReferenceCollectingCallback.BasicBlock declaredBlock : VariableReferenceCheck.this.blocksWithDeclarations) {
                        DiagnosticType diagnosticType;
                        if (!declaredBlock.provablyExecutesBefore(basicBlock)) continue;
                        shadowDetected = true;
                        if (v.isLet() || v.isConst() || v.isClass() || letConstShadowsVar || shadowCatchVar || shadowParam) {
                            diagnosticType = REDECLARED_VARIABLE_ERROR;
                        } else {
                            if (reference.getNode().getParent().isCatch() || allowDupe) {
                                return;
                            }
                            diagnosticType = REDECLARED_VARIABLE;
                        }
                        VariableReferenceCheck.this.compiler.report(JSError.make(referenceNode, diagnosticType, v.name));
                        hasErrors = true;
                        break;
                    }
                }
                if (!shadowDetected && isDeclaration && (letConstShadowsVar || shadowCatchVar) && v.getScope() == reference.getScope()) {
                    VariableReferenceCheck.this.compiler.report(JSError.make(referenceNode, REDECLARED_VARIABLE_ERROR, v.name));
                }
                if (isAssignment) {
                    boolean lhsOfForInLoop;
                    ReferenceCollectingCallback.Reference decl = references.get(0);
                    Node declNode = decl.getNode();
                    boolean bl = lhsOfForInLoop = NodeUtil.isForIn(declNode.getParent()) && declNode == declNode.getParent().getFirstChild() || NodeUtil.isForIn(declNode.getParent().getParent()) && declNode.getParent().getParent().getFirstChild().getFirstChild() == declNode;
                    if (decl.getScope().isLocal() && (decl.isVarDeclaration() || decl.isLetDeclaration() || decl.isConstDeclaration()) && !decl.getNode().isFromExterns() && !lhsOfForInLoop) {
                        unusedAssignment = reference;
                    }
                } else {
                    isRead = true;
                }
                if (isUnhoistedNamedFunction && !isDeclaration && isDeclaredInScope) {
                    for (ReferenceCollectingCallback.BasicBlock declaredBlock : VariableReferenceCheck.this.blocksWithDeclarations) {
                        if (declaredBlock.provablyExecutesBefore(basicBlock)) continue;
                        VariableReferenceCheck.this.compiler.report(JSError.make(referenceNode, AMBIGUOUS_FUNCTION_DECL, v.name));
                        hasErrors = true;
                        break;
                    }
                }
                boolean isUndeclaredReference = false;
                if (!(isDeclaration || isDeclaredInScope || referenceNode.isFromExterns())) {
                    Node grandparent = reference.getGrandparent();
                    if (v.isVar() && grandparent.isName() && grandparent.getString().equals(v.name)) continue;
                    if (reference.getScope() == v.scope && !v.getName().equals("goog")) {
                        isUndeclaredReference = true;
                        VariableReferenceCheck.this.compiler.report(JSError.make(reference.getNode(), v.isLet() || v.isConst() || v.isClass() || v.isParam() ? EARLY_REFERENCE_ERROR : EARLY_REFERENCE, v.name));
                        hasErrors = true;
                    }
                }
                if (!isDeclaration && !isUndeclaredReference && v.isConst() && reference.isLvalue()) {
                    VariableReferenceCheck.this.compiler.report(JSError.make(referenceNode, REASSIGNED_CONSTANT, v.name));
                }
                if (isDeclaration && !reference.isVarDeclaration() && reference.getGrandparent().isAddedBlock()) {
                    VariableReferenceCheck.this.compiler.report(JSError.make(referenceNode, DECLARATION_NOT_DIRECTLY_IN_BLOCK, v.name));
                }
                if (!isDeclaration) continue;
                VariableReferenceCheck.this.blocksWithDeclarations.add(basicBlock);
                isDeclaredInScope = true;
            }
            if (unusedAssignment != null && !isRead && !hasErrors) {
                VariableReferenceCheck.this.compiler.report(JSError.make(unusedAssignment.getNode(), UNUSED_LOCAL_ASSIGNMENT, v.name));
            }
        }

        private class ShallowReferenceCollector
        extends NodeTraversal.AbstractShallowCallback {
            private final Set<Node> currParamReferences = new LinkedHashSet<Node>();

            private ShallowReferenceCollector() {
            }

            @Override
            public void visit(NodeTraversal t, Node n, Node parent) {
                if (!NodeUtil.isReferenceName(n)) {
                    return;
                }
                this.currParamReferences.add(n);
            }
        }
    }
}

