/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ES6ModuleLoader;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.SyntacticScopeCreator;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public final class ProcessCommonJSModules
implements CompilerPass {
    private static final String EXPORTS = "exports";
    private static final String MODULE = "module";
    private final Compiler compiler;
    private final ES6ModuleLoader loader;
    private final boolean reportDependencies;

    public ProcessCommonJSModules(Compiler compiler, ES6ModuleLoader loader) {
        this(compiler, loader, true);
    }

    public ProcessCommonJSModules(Compiler compiler, ES6ModuleLoader loader, boolean reportDependencies) {
        this.compiler = compiler;
        this.loader = loader;
        this.reportDependencies = reportDependencies;
    }

    @Override
    public void process(Node externs, Node root) {
        FindGoogProvideOrGoogModule finder = new FindGoogProvideOrGoogModule();
        NodeTraversal.traverseEs6(this.compiler, root, finder);
        if (finder.found) {
            return;
        }
        NodeTraversal.traverseEs6(this.compiler, root, new ProcessCommonJsModulesCallback());
    }

    String inputToModuleName(CompilerInput input) {
        return ES6ModuleLoader.toModuleName(this.loader.normalizeInputAddress(input));
    }

    private class SuffixVarsCallback
    extends NodeTraversal.AbstractPostOrderCallback {
        private final String suffix;

        SuffixVarsCallback(String suffix) {
            this.suffix = suffix;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            JSDocInfo info = n.getJSDocInfo();
            if (info != null) {
                for (Node typeNode : info.getTypeNodes()) {
                    this.fixTypeNode(t, typeNode);
                }
            }
            if (n.isName()) {
                String name = n.getString();
                if (this.suffix.equals(name)) {
                    return;
                }
                if (ProcessCommonJSModules.EXPORTS.equals(name)) {
                    return;
                }
                if (((ProcessCommonJSModules)ProcessCommonJSModules.this).compiler.getOptions().exportTestFunctions && name.startsWith("test")) {
                    return;
                }
                Var var = t.getScope().getVar(name);
                if (var != null && var.isGlobal()) {
                    n.setString(name + "$$" + this.suffix);
                    n.putProp(40, name);
                }
            }
        }

        private void fixTypeNode(NodeTraversal t, Node typeNode) {
            if (typeNode.isString()) {
                String name = typeNode.getString();
                if (ES6ModuleLoader.isRelativeIdentifier(name)) {
                    int lastSlash = name.lastIndexOf(47);
                    int endIndex = name.indexOf(46, lastSlash);
                    String localTypeName = null;
                    if (endIndex == -1) {
                        endIndex = name.length();
                    } else {
                        localTypeName = name.substring(endIndex);
                    }
                    String moduleName = name.substring(0, endIndex);
                    URI loadAddress = ProcessCommonJSModules.this.loader.locateCommonJsModule(moduleName, t.getInput());
                    if (loadAddress == null) {
                        t.makeError(typeNode, ES6ModuleLoader.LOAD_ERROR, moduleName);
                        return;
                    }
                    String globalModuleName = ES6ModuleLoader.toModuleName(loadAddress);
                    typeNode.setString(localTypeName == null ? globalModuleName : globalModuleName + localTypeName);
                } else {
                    int endIndex = name.indexOf(46);
                    if (endIndex == -1) {
                        endIndex = name.length();
                    }
                    String baseName = name.substring(0, endIndex);
                    Var var = t.getScope().getVar(baseName);
                    if (var != null && var.isGlobal()) {
                        typeNode.setString(baseName + "$$" + this.suffix + name.substring(endIndex));
                        typeNode.putProp(40, name);
                    }
                }
            }
            for (Node child = typeNode.getFirstChild(); child != null; child = child.getNext()) {
                this.fixTypeNode(t, child);
            }
        }
    }

    private class ProcessCommonJsModulesCallback
    extends NodeTraversal.AbstractPostOrderCallback {
        private int scriptNodeCount = 0;
        private List<Node> moduleExportRefs = new ArrayList<Node>();
        private List<Node> exportRefs = new ArrayList<Node>();

        private ProcessCommonJsModulesCallback() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            Var v;
            if (n.isCall() && n.getChildCount() == 2 && n.getFirstChild().matchesQualifiedName("require") && n.getChildAtIndex(1).isString()) {
                this.visitRequireCall(t, n, parent);
            }
            if (n.isIf()) {
                FindModuleExportStatements commonjsFinder = new FindModuleExportStatements();
                Node condition = n.getFirstChild();
                NodeTraversal.traverseEs6(ProcessCommonJSModules.this.compiler, condition, commonjsFinder);
                if (commonjsFinder.isFound()) {
                    this.visitCommonJSIfStatement(n);
                } else {
                    FindDefineAmdStatements amdFinder = new FindDefineAmdStatements();
                    NodeTraversal.traverseEs6(ProcessCommonJSModules.this.compiler, condition, amdFinder);
                    if (amdFinder.isFound()) {
                        this.visitAMDIfStatement(n);
                    }
                }
            }
            if (n.isScript()) {
                ++this.scriptNodeCount;
                this.visitScript(t, n);
            }
            if (n.isGetProp() && "module.exports".equals(n.getQualifiedName()) && (v = t.getScope().getVar(ProcessCommonJSModules.MODULE)) == null) {
                this.moduleExportRefs.add(n);
            }
            if (n.isName() && ProcessCommonJSModules.EXPORTS.equals(n.getString()) && ((v = t.getScope().getVar(n.getString())) == null || v.isGlobal())) {
                this.exportRefs.add(n);
            }
        }

        private void visitRequireCall(NodeTraversal t, Node require, Node parent) {
            String requireName = require.getChildAtIndex(1).getString();
            URI loadAddress = ProcessCommonJSModules.this.loader.locateCommonJsModule(requireName, t.getInput());
            if (loadAddress == null) {
                ProcessCommonJSModules.this.compiler.report(t.makeError(require, ES6ModuleLoader.LOAD_ERROR, requireName));
                return;
            }
            String moduleName = ES6ModuleLoader.toModuleName(loadAddress);
            Node moduleRef = IR.name(moduleName).srcref(require);
            parent.replaceChild(require, moduleRef);
            Node script = this.getCurrentScriptNode(parent);
            if (ProcessCommonJSModules.this.reportDependencies) {
                t.getInput().addRequire(moduleName);
            }
            script.addChildToFront(IR.exprResult(IR.call(IR.getprop(IR.name("goog"), IR.string("require")), IR.string(moduleName))).useSourceInfoIfMissingFromForTree(require));
            ProcessCommonJSModules.this.compiler.reportCodeChange();
        }

        private void visitScript(NodeTraversal t, Node script) {
            Preconditions.checkArgument((this.scriptNodeCount == 1 ? 1 : 0) != 0, (Object)"ProcessCommonJSModules supports only one invocation per CompilerInput / script node");
            String moduleName = ProcessCommonJSModules.this.inputToModuleName(t.getInput());
            NodeTraversal.traverseEs6(ProcessCommonJSModules.this.compiler, script, new SuffixVarsCallback(moduleName));
            this.processExports(script, moduleName);
            this.moduleExportRefs.clear();
            this.exportRefs.clear();
            if (ProcessCommonJSModules.this.reportDependencies) {
                CompilerInput ci = t.getInput();
                ci.addProvide(moduleName);
            }
            script.addChildToFront(IR.exprResult(IR.call(IR.getprop(IR.name("goog"), IR.string("provide")), IR.string(moduleName))).useSourceInfoIfMissingFromForTree(script));
            ProcessCommonJSModules.this.compiler.reportCodeChange();
        }

        private void visitCommonJSIfStatement(Node n) {
            Node p = n.getParent();
            if (p != null) {
                this.replaceIfStatementWithBranch(n, n.getChildAtIndex(1));
            }
        }

        private void visitAMDIfStatement(Node n) {
            Node p = n.getParent();
            if (p != null) {
                if (n.getChildCount() == 3) {
                    this.replaceIfStatementWithBranch(n, n.getChildAtIndex(2));
                } else {
                    p.removeChild(n);
                }
            }
        }

        private void replaceIfStatementWithBranch(Node ifStatement, Node branch) {
            Node p = ifStatement.getParent();
            Node newNode = branch;
            if (branch.isBlock() && branch.getChildCount() == 1) {
                newNode = branch.getFirstChild();
                branch.detachChildren();
            } else {
                ifStatement.detachChildren();
            }
            p.replaceChild(ifStatement, newNode);
        }

        private void processExports(Node script, String moduleName) {
            if (this.hasOneTopLevelModuleExportAssign()) {
                Node ref = this.moduleExportRefs.get(0);
                Node newName = IR.name(moduleName);
                newName.putProp(40, ref.getQualifiedName());
                Node rhsValue = ref.getNext().detachFromParent();
                Node newExprResult = IR.exprResult(IR.assign(newName, rhsValue).useSourceInfoIfMissingFromForTree(ref.getParent()));
                if (rhsValue.isObjectLit()) {
                    Scope globalScope = SyntacticScopeCreator.makeUntyped(ProcessCommonJSModules.this.compiler).createScope(script, null);
                    for (Node key = rhsValue.getFirstChild(); key != null; key = key.getNext()) {
                        JSDocInfo info;
                        if (key.getJSDocInfo() != null || !key.getFirstChild().isName()) continue;
                        Var aliasedVar = globalScope.getVar(key.getFirstChild().getString());
                        JSDocInfo jSDocInfo = info = aliasedVar == null ? null : aliasedVar.getJSDocInfo();
                        if (info == null || info.getVisibility() == JSDocInfo.Visibility.PRIVATE) continue;
                        key.setJSDocInfo(info);
                    }
                }
                Node assign = ref.getParent();
                Node exprResult = assign.getParent();
                script.replaceChild(exprResult, newExprResult);
                return;
            }
            if (!this.hasExportLValues()) {
                for (Node ref : Iterables.concat(this.moduleExportRefs, this.exportRefs)) {
                    Node newRef = IR.name(moduleName).useSourceInfoIfMissingFrom(ref);
                    newRef.putProp(40, ref.getQualifiedName());
                    ref.getParent().replaceChild(ref, newRef);
                }
                return;
            }
            for (Node ref : this.moduleExportRefs) {
                Node newRef = IR.name(moduleName).useSourceInfoIfMissingFrom(ref);
                ref.getParent().replaceChild(ref, newRef);
            }
            if (!this.exportRefs.isEmpty()) {
                String aliasName = "exports$$" + moduleName;
                Node aliasNode = IR.var(IR.name(aliasName), IR.name(moduleName)).useSourceInfoIfMissingFromForTree(script);
                script.addChildToFront(aliasNode);
                for (Node ref : this.exportRefs) {
                    ref.putProp(40, ref.getString());
                    ref.setString(aliasName);
                }
            }
        }

        private boolean hasOneTopLevelModuleExportAssign() {
            return this.moduleExportRefs.size() == 1 && this.exportRefs.isEmpty() && this.isTopLevelAssignLhs(this.moduleExportRefs.get(0));
        }

        private boolean isTopLevelAssignLhs(Node n) {
            Node parent = n.getParent();
            return parent.isAssign() && n == parent.getFirstChild() && parent.getParent().isExprResult() && parent.getParent().getParent().isScript();
        }

        private boolean hasExportLValues() {
            for (Node ref : Iterables.concat(this.moduleExportRefs, this.exportRefs)) {
                if (!NodeUtil.isLValue(ref)) continue;
                return true;
            }
            return false;
        }

        private Node getCurrentScriptNode(Node n) {
            while (!n.isScript()) {
                n = n.getParent();
            }
            return n;
        }
    }

    static class FindDefineAmdStatements
    extends NodeTraversal.AbstractPreOrderCallback {
        private boolean found;

        FindDefineAmdStatements() {
        }

        boolean isFound() {
            return this.found;
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
            if (n.isGetProp() && "define.amd".equals(n.getQualifiedName())) {
                this.found = true;
            }
            return true;
        }
    }

    static class FindModuleExportStatements
    extends NodeTraversal.AbstractPreOrderCallback {
        private boolean found;

        FindModuleExportStatements() {
        }

        boolean isFound() {
            return this.found;
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
            if (n.isGetProp() && "module.exports".equals(n.getQualifiedName()) || n.isName() && ProcessCommonJSModules.EXPORTS.equals(n.getString())) {
                this.found = true;
            }
            return true;
        }
    }

    static class FindGoogProvideOrGoogModule
    extends NodeTraversal.AbstractPreOrderCallback {
        private boolean found;

        FindGoogProvideOrGoogModule() {
        }

        boolean isFound() {
            return this.found;
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
            if (parent == null || !parent.isFunction() || n == parent.getFirstChild()) {
                Node maybeGetProp;
                if (n.isExprResult() && (maybeGetProp = n.getFirstChild().getFirstChild()) != null && (maybeGetProp.matchesQualifiedName("goog.provide") || maybeGetProp.matchesQualifiedName("goog.module"))) {
                    this.found = true;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

