/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CssRenamingMap;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JSModuleGraph;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PreprocessorSymbolTable;
import com.google.javascript.jscomp.parsing.parser.util.format.SimpleFormat;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nullable;

class ProcessClosurePrimitives
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    static final DiagnosticType NULL_ARGUMENT_ERROR = DiagnosticType.error("JSC_NULL_ARGUMENT_ERROR", "method \"{0}\" called without an argument");
    static final DiagnosticType EXPECTED_OBJECTLIT_ERROR = DiagnosticType.error("JSC_EXPECTED_OBJECTLIT_ERROR", "method \"{0}\" expected an object literal argument");
    static final DiagnosticType EXPECTED_STRING_ERROR = DiagnosticType.error("JSC_EXPECTED_STRING_ERROR", "method \"{0}\" expected an object string argument");
    static final DiagnosticType INVALID_ARGUMENT_ERROR = DiagnosticType.error("JSC_INVALID_ARGUMENT_ERROR", "method \"{0}\" called with invalid argument");
    static final DiagnosticType INVALID_STYLE_ERROR = DiagnosticType.error("JSC_INVALID_CSS_NAME_MAP_STYLE_ERROR", "Invalid CSS name map style {0}");
    static final DiagnosticType TOO_MANY_ARGUMENTS_ERROR = DiagnosticType.error("JSC_TOO_MANY_ARGUMENTS_ERROR", "method \"{0}\" called with more than one argument");
    static final DiagnosticType DUPLICATE_NAMESPACE_ERROR = DiagnosticType.error("JSC_DUPLICATE_NAMESPACE_ERROR", "namespace \"{0}\" cannot be provided twice");
    static final DiagnosticType WEAK_NAMESPACE_TYPE = DiagnosticType.warning("JSC_WEAK_NAMESPACE_TYPE", "Provided symbol declared with type Object. This is rarely useful. For more information see https://github.com/google/closure-compiler/wiki/A-word-about-the-type-Object");
    static final DiagnosticType CLASS_NAMESPACE_ERROR = DiagnosticType.error("JSC_CLASS_NAMESPACE_ERROR", "\"{0}\" cannot be both provided and declared as a class. Try var {0} = class '{'...'}'");
    static final DiagnosticType FUNCTION_NAMESPACE_ERROR = DiagnosticType.error("JSC_FUNCTION_NAMESPACE_ERROR", "\"{0}\" cannot be both provided and declared as a function");
    static final DiagnosticType MISSING_PROVIDE_ERROR = DiagnosticType.error("JSC_MISSING_PROVIDE_ERROR", "required \"{0}\" namespace never provided");
    static final DiagnosticType LATE_PROVIDE_ERROR = DiagnosticType.error("JSC_LATE_PROVIDE_ERROR", "required \"{0}\" namespace not provided yet");
    static final DiagnosticType INVALID_PROVIDE_ERROR = DiagnosticType.error("JSC_INVALID_PROVIDE_ERROR", "\"{0}\" is not a valid {1} qualified name");
    static final DiagnosticType INVALID_DEFINE_NAME_ERROR = DiagnosticType.error("JSC_INVALID_DEFINE_NAME_ERROR", "\"{0}\" is not a valid JS identifier name");
    static final DiagnosticType MISSING_DEFINE_ANNOTATION = DiagnosticType.error("JSC_INVALID_MISSING_DEFINE_ANNOTATION", "Missing @define annotation");
    static final DiagnosticType XMODULE_REQUIRE_ERROR = DiagnosticType.warning("JSC_XMODULE_REQUIRE_ERROR", "namespace \"{0}\" is required in module {2} but provided in module {1}. Is module {2} missing a dependency on module {1}?");
    static final DiagnosticType INVALID_CLOSURE_CALL_ERROR = DiagnosticType.error("JSC_INVALID_CLOSURE_CALL_ERROR", "Closure dependency methods(goog.provide, goog.require, etc) must be called at file scope.");
    static final DiagnosticType NON_STRING_PASSED_TO_SET_CSS_NAME_MAPPING_ERROR = DiagnosticType.error("JSC_NON_STRING_PASSED_TO_SET_CSS_NAME_MAPPING_ERROR", "goog.setCssNameMapping only takes an object literal with string values");
    static final DiagnosticType INVALID_CSS_RENAMING_MAP = DiagnosticType.warning("INVALID_CSS_RENAMING_MAP", "Invalid entries in css renaming map: {0}");
    static final DiagnosticType GOOG_BASE_CLASS_ERROR = DiagnosticType.error("JSC_BASE_CLASS_ERROR", "incorrect use of goog.base: {0}");
    static final DiagnosticType BASE_CLASS_ERROR = DiagnosticType.error("JSC_BASE_CLASS_ERROR", "incorrect use of {0}.base: {1}");
    static final DiagnosticType CLOSURE_DEFINES_ERROR = DiagnosticType.error("JSC_CLOSURE_DEFINES_ERROR", "Invalid CLOSURE_DEFINES definition");
    static final DiagnosticType INVALID_FORWARD_DECLARE = DiagnosticType.error("JSC_INVALID_FORWARD_DECLARE", "Malformed goog.forwardDeclaration");
    static final DiagnosticType USE_OF_GOOG_BASE = DiagnosticType.disabled("JSC_USE_OF_GOOG_BASE", "goog.base is not compatible with ES5 strict mode.");
    static final String GOOG = "goog";
    private final AbstractCompiler compiler;
    private final JSModuleGraph moduleGraph;
    private final Map<String, ProvidedName> providedNames = new LinkedHashMap<String, ProvidedName>();
    private final Set<String> knownClosureSubclasses = new HashSet<String>();
    private final List<UnrecognizedRequire> unrecognizedRequires = new ArrayList<UnrecognizedRequire>();
    private final Set<String> exportedVariables = new HashSet<String>();
    private final CheckLevel requiresLevel;
    private final PreprocessorSymbolTable preprocessorSymbolTable;
    private final List<Node> defineCalls = new ArrayList<Node>();
    private final boolean preserveGoogRequires;

    ProcessClosurePrimitives(AbstractCompiler compiler, @Nullable PreprocessorSymbolTable preprocessorSymbolTable, CheckLevel requiresLevel, boolean preserveGoogRequires) {
        this.compiler = compiler;
        this.preprocessorSymbolTable = preprocessorSymbolTable;
        this.moduleGraph = compiler.getModuleGraph();
        this.requiresLevel = requiresLevel;
        this.preserveGoogRequires = preserveGoogRequires;
        this.providedNames.put(GOOG, new ProvidedName(GOOG, null, null, false));
    }

    Set<String> getExportedVariableNames() {
        return this.exportedVariables;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseEs6(this.compiler, root, this);
        for (Node n : this.defineCalls) {
            this.replaceGoogDefines(n);
        }
        for (ProvidedName pn : this.providedNames.values()) {
            pn.replace();
        }
        if (this.requiresLevel.isOn()) {
            for (UnrecognizedRequire r : this.unrecognizedRequires) {
                ProvidedName expectedName = this.providedNames.get(r.namespace);
                DiagnosticType error = expectedName != null && expectedName.firstNode != null ? LATE_PROVIDE_ERROR : MISSING_PROVIDE_ERROR;
                this.compiler.report(JSError.make(r.requireNode, this.requiresLevel, error, r.namespace));
            }
        }
    }

    private void replaceGoogDefines(Node n) {
        Node parent = n.getParent();
        Preconditions.checkState((boolean)parent.isExprResult());
        String name = n.getChildAtIndex(1).getString();
        Node value = n.getChildAtIndex(2).detachFromParent();
        Node replacement = NodeUtil.newQNameDeclaration(this.compiler, name, value, n.getJSDocInfo());
        replacement.useSourceInfoIfMissingFromForTree(parent);
        parent.getParent().replaceChild(parent, replacement);
        this.compiler.reportCodeChange();
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        this.compiler.process(this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getType()) {
            case 37: {
                Node left = n.getFirstChild();
                if (!left.isGetProp()) break;
                Node name = left.getFirstChild();
                if (name.isName() && GOOG.equals(name.getString())) {
                    String methodName = name.getNext().getString();
                    if ("base".equals(methodName)) {
                        this.processBaseClassCall(t, n);
                        break;
                    }
                    if ("define".equals(methodName)) {
                        if (!this.validPrimitiveCall(t, n)) break;
                        this.processDefineCall(t, n, parent);
                        break;
                    }
                    if ("require".equals(methodName)) {
                        if (!this.validPrimitiveCall(t, n)) break;
                        this.processRequireCall(t, n, parent);
                        break;
                    }
                    if ("provide".equals(methodName)) {
                        if (!this.validPrimitiveCall(t, n)) break;
                        this.processProvideCall(t, n, parent);
                        break;
                    }
                    if ("inherits".equals(methodName)) {
                        this.processInheritsCall(t, n);
                        break;
                    }
                    if ("exportSymbol".equals(methodName)) {
                        Node arg = left.getNext();
                        if (!arg.isString()) break;
                        int dot = arg.getString().indexOf(46);
                        if (dot == -1) {
                            this.exportedVariables.add(arg.getString());
                            break;
                        }
                        this.exportedVariables.add(arg.getString().substring(0, dot));
                        break;
                    }
                    if ("forwardDeclare".equals(methodName)) {
                        if (!this.validPrimitiveCall(t, n)) break;
                        this.processForwardDeclare(t, n, parent);
                        break;
                    }
                    if ("addDependency".equals(methodName)) {
                        if (!this.validPrimitiveCall(t, n)) break;
                        this.processAddDependency(n, parent);
                        break;
                    }
                    if (!"setCssNameMapping".equals(methodName)) break;
                    this.processSetCssNameMapping(t, n, parent);
                    break;
                }
                if (!left.getLastChild().getString().equals("base")) break;
                this.maybeProcessClassBaseCall(t, n);
                break;
            }
            case 38: 
            case 86: {
                if (n.isName() && n.getString().equals("CLOSURE_DEFINES")) {
                    this.handleClosureDefinesValues(t, n);
                    break;
                }
                this.handleCandidateProvideDefinition(t, n, parent);
                break;
            }
            case 130: {
                this.handleTypedefDefinition(t, n);
                break;
            }
            case 158: {
                String name;
                ProvidedName pn;
                if (!t.inGlobalHoistScope() || NodeUtil.isClassExpression(n) || (pn = this.providedNames.get(name = n.getFirstChild().getString())) == null) break;
                this.compiler.report(t.makeError(n, CLASS_NAMESPACE_ERROR, name));
                break;
            }
            case 105: {
                String name;
                ProvidedName pn;
                if (!t.inGlobalHoistScope() || NodeUtil.isFunctionExpression(n) || (pn = this.providedNames.get(name = n.getFirstChild().getString())) == null) break;
                this.compiler.report(t.makeError(n, FUNCTION_NAMESPACE_ERROR, name));
                break;
            }
            case 33: {
                if (!n.getFirstChild().isName() || parent.isCall() || parent.isAssign() || !n.matchesQualifiedName("goog.base")) break;
                this.reportBadGoogBaseUse(t, n, "May only be called directly.");
            }
        }
    }

    private boolean validPrimitiveCall(NodeTraversal t, Node n) {
        if (!n.getParent().isExprResult() || !t.inGlobalHoistScope()) {
            this.compiler.report(t.makeError(n, INVALID_CLOSURE_CALL_ERROR, new String[0]));
            return false;
        }
        return true;
    }

    private void handleClosureDefinesValues(NodeTraversal t, Node n) {
        if (n.getParent().isVar() && n.hasOneChild() && n.getFirstChild().isObjectLit()) {
            HashMap<String, Node> builder = new HashMap<String, Node>();
            builder.putAll((Map<String, Node>)this.compiler.getDefaultDefineValues());
            for (Node c : n.getFirstChild().children()) {
                if (c.isStringKey() && c.getFirstChild() != null && ProcessClosurePrimitives.isValidDefineValue(c.getFirstChild())) {
                    builder.put(c.getString(), c.getFirstChild().cloneTree());
                    continue;
                }
                this.reportBadClosureCommonDefinesDefinition(t, c);
            }
            this.compiler.setDefaultDefineValues((ImmutableMap<String, Node>)ImmutableMap.copyOf(builder));
        }
    }

    static boolean isValidDefineValue(Node val) {
        switch (val.getType()) {
            case 39: 
            case 40: 
            case 43: 
            case 44: {
                return true;
            }
            case 29: {
                return val.getFirstChild().isNumber();
            }
        }
        return false;
    }

    private void processRequireCall(NodeTraversal t, Node n, Node parent) {
        Node arg;
        Node left = n.getFirstChild();
        if (this.verifyLastArgumentIsString(t, left, arg = left.getNext())) {
            String ns = arg.getString();
            ProvidedName provided = this.providedNames.get(ns);
            if (provided == null || !provided.isExplicitlyProvided()) {
                this.unrecognizedRequires.add(new UnrecognizedRequire(n, ns));
            } else {
                JSModule providedModule = provided.explicitModule;
                Preconditions.checkNotNull((Object)providedModule);
                JSModule module = t.getModule();
                if (this.moduleGraph != null && module != providedModule && !this.moduleGraph.dependsOn(module, providedModule)) {
                    this.compiler.report(t.makeError(n, XMODULE_REQUIRE_ERROR, ns, providedModule.getName(), module.getName()));
                }
            }
            this.maybeAddToSymbolTable(left);
            this.maybeAddStringNodeToSymbolTable(arg);
            if (!this.preserveGoogRequires && (provided != null || this.requiresLevel.isOn())) {
                parent.detachFromParent();
                this.compiler.reportCodeChange();
            }
        }
    }

    private void processProvideCall(NodeTraversal t, Node n, Node parent) {
        Node arg;
        Node left = n.getFirstChild();
        if (this.verifyProvide(t, left, arg = left.getNext())) {
            String ns = arg.getString();
            this.maybeAddToSymbolTable(left);
            this.maybeAddStringNodeToSymbolTable(arg);
            if (this.providedNames.containsKey(ns)) {
                ProvidedName previouslyProvided = this.providedNames.get(ns);
                if (!previouslyProvided.isExplicitlyProvided()) {
                    previouslyProvided.addProvide(parent, t.getModule(), true);
                } else {
                    this.compiler.report(t.makeError(n, DUPLICATE_NAMESPACE_ERROR, ns));
                }
            } else {
                this.registerAnyProvidedPrefixes(ns, parent, t.getModule());
                this.providedNames.put(ns, new ProvidedName(ns, parent, t.getModule(), true));
            }
        }
    }

    private void processDefineCall(NodeTraversal t, Node n, Node parent) {
        Node args;
        Node left = n.getFirstChild();
        if (this.verifyDefine(t, parent, left, args = left.getNext())) {
            Node nameNode = args;
            this.maybeAddToSymbolTable(left);
            this.maybeAddStringNodeToSymbolTable(nameNode);
            this.defineCalls.add(n);
        }
    }

    private void handleTypedefDefinition(NodeTraversal t, Node n) {
        ProvidedName pn;
        String name;
        JSDocInfo info = n.getFirstChild().getJSDocInfo();
        if (t.inGlobalHoistScope() && info != null && info.hasTypedefType() && (name = n.getFirstChild().getQualifiedName()) != null && (pn = this.providedNames.get(name)) != null) {
            pn.addDefinition(n, t.getModule());
        }
    }

    private void handleCandidateProvideDefinition(NodeTraversal t, Node n, Node parent) {
        if (t.inGlobalHoistScope()) {
            String name = null;
            if (n.isName() && NodeUtil.isNameDeclaration(parent)) {
                name = n.getString();
            } else if (n.isAssign() && parent.isExprResult()) {
                name = n.getFirstChild().getQualifiedName();
            }
            if (name != null) {
                if (parent.getBooleanProp(46)) {
                    this.processProvideFromPreviousPass(t, name, parent);
                } else {
                    ProvidedName pn = this.providedNames.get(name);
                    if (pn != null) {
                        pn.addDefinition(parent, t.getModule());
                    }
                }
            }
        }
    }

    private void processBaseClassCall(NodeTraversal t, Node n) {
        t.report(n, USE_OF_GOOG_BASE, new String[0]);
        if (this.baseUsedInClass(n)) {
            this.reportBadGoogBaseUse(t, n, "goog.base in ES6 class is not allowed. Use super instead.");
            return;
        }
        Node callee = n.getFirstChild();
        Node thisArg = callee.getNext();
        if (thisArg == null || !thisArg.isThis()) {
            this.reportBadGoogBaseUse(t, n, "First argument must be 'this'.");
            return;
        }
        Node enclosingFnNameNode = ProcessClosurePrimitives.getEnclosingDeclNameNode(n);
        if (enclosingFnNameNode == null) {
            this.reportBadGoogBaseUse(t, n, "Could not find enclosing method.");
            return;
        }
        String enclosingQname = enclosingFnNameNode.getQualifiedName();
        if (!enclosingQname.contains(".prototype.")) {
            Node callNode;
            Node enclosingParent = enclosingFnNameNode.getParent();
            Node maybeInheritsExpr = (enclosingParent.isAssign() ? enclosingParent.getParent() : enclosingParent).getNext();
            Node baseClassNode = null;
            if (maybeInheritsExpr != null && maybeInheritsExpr.isExprResult() && maybeInheritsExpr.getFirstChild().isCall() && (callNode = maybeInheritsExpr.getFirstChild()).getFirstChild().matchesQualifiedName("goog.inherits") && callNode.getLastChild().isQualifiedName()) {
                baseClassNode = callNode.getLastChild();
            }
            if (baseClassNode == null) {
                this.reportBadGoogBaseUse(t, n, "Could not find goog.inherits for base class");
                return;
            }
            n.replaceChild(callee, NodeUtil.newQName(this.compiler, SimpleFormat.format("%s.call", baseClassNode.getQualifiedName()), callee, "goog.base"));
            this.compiler.reportCodeChange();
        } else {
            Node methodNameNode = thisArg.getNext();
            if (methodNameNode == null || !methodNameNode.isString()) {
                this.reportBadGoogBaseUse(t, n, "Second argument must name a method.");
                return;
            }
            String methodName = methodNameNode.getString();
            String ending = ".prototype." + methodName;
            if (enclosingQname == null || !enclosingQname.endsWith(ending)) {
                this.reportBadGoogBaseUse(t, n, "Enclosing method does not match " + methodName);
                return;
            }
            Node className = enclosingFnNameNode.getFirstChild().getFirstChild();
            n.replaceChild(callee, NodeUtil.newQName(this.compiler, SimpleFormat.format("%s.superClass_.%s.call", className.getQualifiedName(), methodName), callee, "goog.base"));
            n.removeChild(methodNameNode);
            this.compiler.reportCodeChange();
        }
    }

    private void maybeProcessClassBaseCall(NodeTraversal t, Node n) {
        if (this.baseUsedInClass(n)) {
            this.reportBadGoogBaseUse(t, n, "goog.base in ES6 class is not allowed. Use super instead.");
            return;
        }
        Node callTarget = n.getFirstChild();
        Node baseContainerNode = callTarget.getFirstChild();
        if (!baseContainerNode.isUnscopedQualifiedName()) {
            return;
        }
        String baseContainer = callTarget.getFirstChild().getQualifiedName();
        Node enclosingFnNameNode = ProcessClosurePrimitives.getEnclosingDeclNameNode(n);
        if (enclosingFnNameNode == null || !enclosingFnNameNode.isUnscopedQualifiedName()) {
            if (this.knownClosureSubclasses.contains(baseContainer)) {
                this.reportBadBaseMethodUse(t, n, baseContainer, "Could not find enclosing method.");
            }
            return;
        }
        String enclosingQname = enclosingFnNameNode.getQualifiedName();
        if (!enclosingQname.contains(".prototype.")) {
            Node callNode;
            Node maybeInheritsExpr;
            if (!enclosingQname.equals(baseContainer)) {
                if (this.knownClosureSubclasses.contains(baseContainer)) {
                    this.reportBadBaseMethodUse(t, n, baseContainer, "Must be used within " + baseContainer + " methods");
                }
                return;
            }
            for (maybeInheritsExpr = ((enclosingParent = enclosingFnNameNode.getParent()).isAssign() ? enclosingParent.getParent() : enclosingParent).getNext(); maybeInheritsExpr != null && maybeInheritsExpr.isEmpty(); maybeInheritsExpr = maybeInheritsExpr.getNext()) {
            }
            Node baseClassNode = null;
            if (maybeInheritsExpr != null && maybeInheritsExpr.isExprResult() && maybeInheritsExpr.getFirstChild().isCall() && (callNode = maybeInheritsExpr.getFirstChild()).getFirstChild().matchesQualifiedName("goog.inherits") && callNode.getLastChild().isQualifiedName()) {
                baseClassNode = callNode.getLastChild();
            }
            if (baseClassNode == null) {
                return;
            }
            Node callee = n.getFirstChild();
            Node thisArg = callee.getNext();
            if (thisArg == null || !thisArg.isThis()) {
                this.reportBadBaseMethodUse(t, n, baseContainer, "First argument must be 'this'.");
                return;
            }
            Node methodNameNode = thisArg.getNext();
            if (methodNameNode == null || !methodNameNode.isString() || !methodNameNode.getString().equals("constructor")) {
                this.reportBadBaseMethodUse(t, n, baseContainer, "Second argument must be 'constructor'.");
                return;
            }
            n.replaceChild(callee, NodeUtil.newQName(this.compiler, SimpleFormat.format("%s.call", baseClassNode.getQualifiedName()), callee, enclosingQname + ".base"));
            n.removeChild(methodNameNode);
            this.compiler.reportCodeChange();
        } else {
            boolean misuseOfBase;
            if (!this.knownClosureSubclasses.contains(baseContainer)) {
                return;
            }
            boolean bl = misuseOfBase = !enclosingFnNameNode.getFirstChild().getFirstChild().matchesQualifiedName(baseContainer);
            if (misuseOfBase) {
                this.reportBadBaseMethodUse(t, n, baseContainer, "Must be used within " + baseContainer + " methods");
                return;
            }
            Node callee = n.getFirstChild();
            Node thisArg = callee.getNext();
            if (thisArg == null || !thisArg.isThis()) {
                this.reportBadBaseMethodUse(t, n, baseContainer, "First argument must be 'this'.");
                return;
            }
            Node methodNameNode = thisArg.getNext();
            if (methodNameNode == null || !methodNameNode.isString()) {
                this.reportBadBaseMethodUse(t, n, baseContainer, "Second argument must name a method.");
                return;
            }
            String methodName = methodNameNode.getString();
            String ending = ".prototype." + methodName;
            if (enclosingQname == null || !enclosingQname.endsWith(ending)) {
                this.reportBadBaseMethodUse(t, n, baseContainer, "Enclosing method does not match " + methodName);
                return;
            }
            Node className = enclosingFnNameNode.getFirstChild().getFirstChild();
            n.replaceChild(callee, NodeUtil.newQName(this.compiler, SimpleFormat.format("%s.superClass_.%s.call", className.getQualifiedName(), methodName), callee, enclosingQname + ".base"));
            n.removeChild(methodNameNode);
            this.compiler.reportCodeChange();
        }
    }

    private void processInheritsCall(NodeTraversal t, Node n) {
        if (n.getChildCount() == 3) {
            Node subClass = n.getChildAtIndex(1);
            Node superClass = subClass.getNext();
            if (subClass.isUnscopedQualifiedName() && superClass.isUnscopedQualifiedName()) {
                this.knownClosureSubclasses.add(subClass.getQualifiedName());
            }
        }
    }

    private static Node getEnclosingDeclNameNode(Node n) {
        Node fn = NodeUtil.getEnclosingFunction(n);
        return fn == null ? null : NodeUtil.getFunctionNameNode(fn);
    }

    private boolean baseUsedInClass(Node n) {
        for (Node curr = n; curr != null; curr = curr.getParent()) {
            if (!curr.isClassMembers()) continue;
            return true;
        }
        return false;
    }

    private void reportBadGoogBaseUse(NodeTraversal t, Node n, String extraMessage) {
        this.compiler.report(t.makeError(n, GOOG_BASE_CLASS_ERROR, extraMessage));
    }

    private void reportBadBaseMethodUse(NodeTraversal t, Node n, String className, String extraMessage) {
        this.compiler.report(t.makeError(n, BASE_CLASS_ERROR, className, extraMessage));
    }

    private void reportBadClosureCommonDefinesDefinition(NodeTraversal t, Node n) {
        this.compiler.report(t.makeError(n, CLOSURE_DEFINES_ERROR, new String[0]));
    }

    private void processProvideFromPreviousPass(NodeTraversal t, String name, Node parent) {
        if (!this.providedNames.containsKey(name)) {
            Node expr = new Node(130);
            expr.copyInformationFromForTree(parent);
            parent.getParent().addChildBefore(expr, parent);
            this.compiler.reportCodeChange();
            JSModule module = t.getModule();
            this.registerAnyProvidedPrefixes(name, expr, module);
            ProvidedName provided = new ProvidedName(name, expr, module, true);
            this.providedNames.put(name, provided);
            provided.addDefinition(parent, module);
        } else if (ProcessClosurePrimitives.isNamespacePlaceholder(parent)) {
            parent.getParent().removeChild(parent);
            this.compiler.reportCodeChange();
        }
    }

    private void processSetCssNameMapping(NodeTraversal t, Node n, Node parent) {
        Node arg;
        Node left = n.getFirstChild();
        if (this.verifySetCssNameMapping(t, left, arg = left.getNext())) {
            ArrayList<String> errors;
            CssRenamingMap.Style style;
            final HashMap<String, String> cssNames = new HashMap<String, String>();
            for (Node key = arg.getFirstChild(); key != null; key = key.getNext()) {
                Node value = key.getFirstChild();
                if (!key.isStringKey() || value == null || !value.isString()) {
                    this.compiler.report(t.makeError(n, NON_STRING_PASSED_TO_SET_CSS_NAME_MAPPING_ERROR, new String[0]));
                    return;
                }
                cssNames.put(key.getString(), value.getString());
            }
            String styleStr = "BY_PART";
            if (arg.getNext() != null) {
                styleStr = arg.getNext().getString();
            }
            try {
                style = CssRenamingMap.Style.valueOf(styleStr);
            }
            catch (IllegalArgumentException e) {
                this.compiler.report(t.makeError(n, INVALID_STYLE_ERROR, styleStr));
                return;
            }
            if (style == CssRenamingMap.Style.BY_PART) {
                errors = new ArrayList<String>();
                for (String key : cssNames.keySet()) {
                    if (!key.contains("-")) continue;
                    errors.add(key);
                }
                if (!errors.isEmpty()) {
                    this.compiler.report(t.makeError(n, INVALID_CSS_RENAMING_MAP, ((Object)errors).toString()));
                }
            } else if (style == CssRenamingMap.Style.BY_WHOLE) {
                errors = new ArrayList();
                for (Map.Entry b : cssNames.entrySet()) {
                    if (((String)b.getKey()).length() > 10) continue;
                    for (Map.Entry a : cssNames.entrySet()) {
                        String combined = (String)cssNames.get((String)a.getKey() + "-" + (String)b.getKey());
                        if (combined == null || combined.equals((String)a.getValue() + "-" + (String)b.getValue())) continue;
                        errors.add("map(" + (String)a.getKey() + "-" + (String)b.getKey() + ") != map(" + (String)a.getKey() + ")-map(" + (String)b.getKey() + ")");
                    }
                }
                if (!errors.isEmpty()) {
                    this.compiler.report(t.makeError(n, INVALID_CSS_RENAMING_MAP, ((Object)errors).toString()));
                }
            }
            CssRenamingMap cssRenamingMap = new CssRenamingMap(){

                @Override
                public String get(String value) {
                    if (cssNames.containsKey(value)) {
                        return (String)cssNames.get(value);
                    }
                    return value;
                }

                @Override
                public CssRenamingMap.Style getStyle() {
                    return style;
                }
            };
            this.compiler.setCssRenamingMap(cssRenamingMap);
            parent.getParent().removeChild(parent);
            this.compiler.reportCodeChange();
        }
    }

    private boolean verifyProvide(NodeTraversal t, Node methodName, Node arg) {
        if (!this.verifyLastArgumentIsString(t, methodName, arg)) {
            return false;
        }
        if (!NodeUtil.isValidQualifiedName(this.compiler.getLanguageMode(), arg.getString())) {
            this.compiler.report(t.makeError(arg, INVALID_PROVIDE_ERROR, arg.getString(), this.compiler.getLanguageMode().toString()));
            return false;
        }
        return true;
    }

    private boolean verifyDefine(NodeTraversal t, Node expr, Node methodName, Node args) {
        Node arg = args;
        if (!this.verifyNotNull(t, methodName, arg) || !this.verifyOfType(t, methodName, arg, 40)) {
            return false;
        }
        if (!this.verifyNotNull(t, methodName, arg = arg.getNext()) || !this.verifyIsLast(t, methodName, arg)) {
            return false;
        }
        String name = args.getString();
        if (!NodeUtil.isValidQualifiedName(this.compiler.getLanguageMode(), name)) {
            this.compiler.report(t.makeError(args, INVALID_DEFINE_NAME_ERROR, name));
            return false;
        }
        JSDocInfo info = expr.getFirstChild().getJSDocInfo();
        if (info == null || !info.isDefine()) {
            this.compiler.report(t.makeError(expr, MISSING_DEFINE_ANNOTATION, new String[0]));
            return false;
        }
        return true;
    }

    private void processAddDependency(Node n, Node parent) {
        CodingConvention convention = this.compiler.getCodingConvention();
        List<String> typeDecls = convention.identifyTypeDeclarationCall(n);
        if (typeDecls != null) {
            for (String typeDecl : typeDecls) {
                this.compiler.getTypeRegistry().forwardDeclareType(typeDecl);
            }
        }
        parent.replaceChild(n, IR.number(0.0));
        this.compiler.reportCodeChange();
    }

    private void processForwardDeclare(NodeTraversal t, Node n, Node parent) {
        CodingConvention convention = this.compiler.getCodingConvention();
        String typeDeclaration = null;
        try {
            typeDeclaration = (String)Iterables.getOnlyElement(convention.identifyTypeDeclarationCall(n));
        }
        catch (IllegalArgumentException | NullPointerException | NoSuchElementException e) {
            this.compiler.report(t.makeError(n, INVALID_FORWARD_DECLARE, "A single type could not identified for the goog.forwardDeclare statement"));
        }
        if (typeDeclaration != null) {
            this.compiler.getTypeRegistry().forwardDeclareType(typeDeclaration);
            parent.detachFromParent();
            this.compiler.reportCodeChange();
        }
    }

    private boolean verifyLastArgumentIsString(NodeTraversal t, Node methodName, Node arg) {
        return this.verifyNotNull(t, methodName, arg) && this.verifyOfType(t, methodName, arg, 40) && this.verifyIsLast(t, methodName, arg);
    }

    private boolean verifyNotNull(NodeTraversal t, Node methodName, Node arg) {
        if (arg == null) {
            this.compiler.report(t.makeError(methodName, NULL_ARGUMENT_ERROR, methodName.getQualifiedName()));
            return false;
        }
        return true;
    }

    private boolean verifyOfType(NodeTraversal t, Node methodName, Node arg, int desiredType) {
        if (arg.getType() != desiredType) {
            this.compiler.report(t.makeError(methodName, INVALID_ARGUMENT_ERROR, methodName.getQualifiedName()));
            return false;
        }
        return true;
    }

    private boolean verifyIsLast(NodeTraversal t, Node methodName, Node arg) {
        if (arg.getNext() != null) {
            this.compiler.report(t.makeError(methodName, TOO_MANY_ARGUMENTS_ERROR, methodName.getQualifiedName()));
            return false;
        }
        return true;
    }

    private boolean verifySetCssNameMapping(NodeTraversal t, Node methodName, Node firstArg) {
        DiagnosticType diagnostic = null;
        if (firstArg == null) {
            diagnostic = NULL_ARGUMENT_ERROR;
        } else if (!firstArg.isObjectLit()) {
            diagnostic = EXPECTED_OBJECTLIT_ERROR;
        } else if (firstArg.getNext() != null) {
            Node secondArg = firstArg.getNext();
            if (!secondArg.isString()) {
                diagnostic = EXPECTED_STRING_ERROR;
            } else if (secondArg.getNext() != null) {
                diagnostic = TOO_MANY_ARGUMENTS_ERROR;
            }
        }
        if (diagnostic != null) {
            this.compiler.report(t.makeError(methodName, diagnostic, methodName.getQualifiedName()));
            return false;
        }
        return true;
    }

    private void registerAnyProvidedPrefixes(String ns, Node node, JSModule module) {
        int pos = ns.indexOf(46);
        while (pos != -1) {
            String prefixNs = ns.substring(0, pos);
            pos = ns.indexOf(46, pos + 1);
            if (this.providedNames.containsKey(prefixNs)) {
                this.providedNames.get(prefixNs).addProvide(node, module, false);
                continue;
            }
            this.providedNames.put(prefixNs, new ProvidedName(prefixNs, node, module, false));
        }
    }

    private static boolean isNamespacePlaceholder(Node n) {
        if (!n.getBooleanProp(46)) {
            return false;
        }
        Node value = null;
        if (n.isExprResult()) {
            Node assign = n.getFirstChild();
            value = assign.getLastChild();
        } else if (n.isVar()) {
            Node name = n.getFirstChild();
            value = name.getFirstChild();
        }
        return value != null && value.isObjectLit() && !value.hasChildren();
    }

    private void maybeAddStringNodeToSymbolTable(Node n) {
        if (this.preprocessorSymbolTable == null) {
            return;
        }
        String name = n.getString();
        Node syntheticRef = NodeUtil.newQName(this.compiler, name, n, name);
        boolean forQuote = true;
        boolean forDot = true;
        Node current = null;
        current = syntheticRef;
        while (current.isGetProp()) {
            int fullLen = current.getQualifiedName().length();
            int namespaceLen = current.getFirstChild().getQualifiedName().length();
            current.setSourceEncodedPosition(n.getSourcePosition() + 1);
            current.setLength(fullLen);
            current.getLastChild().setSourceEncodedPosition(n.getSourcePosition() + namespaceLen + 1 + 1);
            current.getLastChild().setLength(current.getLastChild().getString().length());
            current = current.getFirstChild();
        }
        current.setSourceEncodedPosition(n.getSourcePosition() + 1);
        current.setLength(current.getString().length());
        this.maybeAddToSymbolTable(syntheticRef);
    }

    private void maybeAddToSymbolTable(Node n) {
        if (this.preprocessorSymbolTable != null) {
            this.preprocessorSymbolTable.addReference(n);
        }
    }

    private static class UnrecognizedRequire {
        final Node requireNode;
        final String namespace;

        UnrecognizedRequire(Node requireNode, String namespace) {
            this.requireNode = requireNode;
            this.namespace = namespace;
        }
    }

    private class ProvidedName {
        private final String namespace;
        private final Node firstNode;
        private final JSModule firstModule;
        private Node explicitNode = null;
        private JSModule explicitModule = null;
        private Node candidateDefinition = null;
        private JSModule minimumModule = null;
        private Node replacementNode = null;

        ProvidedName(String namespace, Node node, JSModule module, boolean explicit) {
            Preconditions.checkArgument((node == null || node.isExprResult() ? 1 : 0) != 0);
            this.namespace = namespace;
            this.firstNode = node;
            this.firstModule = module;
            this.addProvide(node, module, explicit);
        }

        void addProvide(Node node, JSModule module, boolean explicit) {
            if (explicit) {
                Preconditions.checkState((this.explicitNode == null ? 1 : 0) != 0);
                Preconditions.checkArgument((boolean)node.isExprResult());
                this.explicitNode = node;
                this.explicitModule = module;
            }
            this.updateMinimumModule(module);
        }

        boolean isExplicitlyProvided() {
            return this.explicitNode != null;
        }

        void addDefinition(Node node, JSModule module) {
            Preconditions.checkArgument((node.isExprResult() || node.isFunction() || NodeUtil.isNameDeclaration(node) ? 1 : 0) != 0);
            Preconditions.checkArgument((this.explicitNode != node ? 1 : 0) != 0);
            if (this.candidateDefinition == null || !node.isExprResult()) {
                this.candidateDefinition = node;
                this.updateMinimumModule(module);
            }
        }

        private void updateMinimumModule(JSModule newModule) {
            if (this.minimumModule == null) {
                this.minimumModule = newModule;
            } else if (ProcessClosurePrimitives.this.moduleGraph != null) {
                this.minimumModule = ProcessClosurePrimitives.this.moduleGraph.getDeepestCommonDependencyInclusive(this.minimumModule, newModule);
            } else {
                Preconditions.checkState((newModule == this.minimumModule ? 1 : 0) != 0, (Object)"Missing module graph");
            }
        }

        void replace() {
            if (this.firstNode == null) {
                this.replacementNode = this.candidateDefinition;
                return;
            }
            if (this.candidateDefinition != null && this.explicitNode != null) {
                JSTypeExpression expr;
                this.explicitNode.detachFromParent();
                ProcessClosurePrimitives.this.compiler.reportCodeChange();
                JSDocInfo info = this.candidateDefinition.isExprResult() ? this.candidateDefinition.getFirstChild().getJSDocInfo() : this.candidateDefinition.getJSDocInfo();
                if (info != null && (expr = info.getType()) != null) {
                    Node n = expr.getRoot();
                    if (n.getType() == 306) {
                        n = n.getFirstChild();
                    }
                    if (n.getType() == 40 && !n.hasChildren() && n.getString().equals("Object")) {
                        ProcessClosurePrimitives.this.compiler.report(JSError.make(this.candidateDefinition, WEAK_NAMESPACE_TYPE, new String[0]));
                    }
                }
                this.replacementNode = this.candidateDefinition;
                if (this.candidateDefinition.isExprResult() && !this.candidateDefinition.getFirstChild().isQualifiedName()) {
                    this.candidateDefinition.putBooleanProp(46, true);
                    Node assignNode = this.candidateDefinition.getFirstChild();
                    Node nameNode = assignNode.getFirstChild();
                    if (nameNode.isName()) {
                        Node valueNode = nameNode.getNext();
                        assignNode.removeChild(nameNode);
                        assignNode.removeChild(valueNode);
                        nameNode.addChildToFront(valueNode);
                        Node varNode = IR.var(nameNode);
                        varNode.copyInformationFrom(this.candidateDefinition);
                        this.candidateDefinition.getParent().replaceChild(this.candidateDefinition, varNode);
                        nameNode.setJSDocInfo(assignNode.getJSDocInfo());
                        ProcessClosurePrimitives.this.compiler.reportCodeChange();
                        this.replacementNode = varNode;
                    }
                }
            } else {
                this.replacementNode = this.createDeclarationNode();
                if (this.firstModule == this.minimumModule) {
                    this.firstNode.getParent().addChildBefore(this.replacementNode, this.firstNode);
                } else {
                    int indexOfDot = this.namespace.lastIndexOf(46);
                    if (indexOfDot == -1) {
                        ProcessClosurePrimitives.this.compiler.getNodeForCodeInsertion(this.minimumModule).addChildToBack(this.replacementNode);
                    } else {
                        ProvidedName parentName = (ProvidedName)ProcessClosurePrimitives.this.providedNames.get(this.namespace.substring(0, indexOfDot));
                        Preconditions.checkNotNull((Object)parentName);
                        Preconditions.checkNotNull((Object)parentName.replacementNode);
                        parentName.replacementNode.getParent().addChildAfter(this.replacementNode, parentName.replacementNode);
                    }
                }
                if (this.explicitNode != null) {
                    this.explicitNode.detachFromParent();
                }
                ProcessClosurePrimitives.this.compiler.reportCodeChange();
            }
        }

        private Node createDeclarationNode() {
            if (this.namespace.indexOf(46) == -1) {
                return this.makeVarDeclNode();
            }
            return this.makeAssignmentExprNode();
        }

        private Node makeVarDeclNode() {
            Node name = IR.name(this.namespace);
            name.addChildToFront(this.createNamespaceLiteral());
            Node decl = IR.var(name);
            decl.putBooleanProp(46, true);
            if (ProcessClosurePrimitives.this.compiler.getCodingConvention().isConstant(this.namespace)) {
                name.putBooleanProp(43, true);
            }
            if (this.candidateDefinition == null) {
                name.setJSDocInfo(NodeUtil.createConstantJsDoc());
            }
            Preconditions.checkState((boolean)ProcessClosurePrimitives.isNamespacePlaceholder(decl));
            this.setSourceInfo(decl);
            return decl;
        }

        private Node createNamespaceLiteral() {
            Node objlit = IR.objectlit(new Node[0]);
            objlit.setJSType(ProcessClosurePrimitives.this.compiler.getTypeRegistry().createAnonymousObjectType(null));
            return objlit;
        }

        private Node makeAssignmentExprNode() {
            Node decl = IR.exprResult(IR.assign(NodeUtil.newQName(ProcessClosurePrimitives.this.compiler, this.namespace, this.firstNode, this.namespace), this.createNamespaceLiteral()));
            decl.putBooleanProp(46, true);
            if (this.candidateDefinition == null) {
                decl.getFirstChild().setJSDocInfo(NodeUtil.createConstantJsDoc());
            }
            Preconditions.checkState((boolean)ProcessClosurePrimitives.isNamespacePlaceholder(decl));
            this.setSourceInfo(decl);
            return decl;
        }

        private void setSourceInfo(Node newNode) {
            Node provideStringNode = this.getProvideStringNode();
            int offset = this.getSourceInfoOffset(provideStringNode);
            Node sourceInfoNode = provideStringNode == null ? this.firstNode : provideStringNode;
            newNode.copyInformationFromForTree(sourceInfoNode);
            if (offset != 0) {
                newNode.setSourceEncodedPositionForTree(sourceInfoNode.getSourcePosition() + offset);
            }
        }

        private int getSourceInfoOffset(Node provideStringNode) {
            if (provideStringNode == null) {
                return 0;
            }
            int indexOfLastDot = this.namespace.lastIndexOf(46);
            return 2 + indexOfLastDot;
        }

        private Node getProvideStringNode() {
            return this.firstNode.getFirstChild() != null && NodeUtil.isExprCall(this.firstNode) ? this.firstNode.getFirstChild().getLastChild() : null;
        }
    }
}

