/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.GlobalNamespace;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TagNameToType;
import com.google.javascript.jscomp.parsing.parser.util.format.SimpleFormat;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class PolymerPass
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    static final DiagnosticType POLYMER_DESCRIPTOR_NOT_VALID = DiagnosticType.warning("JSC_POLYMER_DESCRIPTOR_NOT_VALID", "The argument to Polymer() is not an obj lit (perhaps because this is a pre-Polymer-1.0 call). Ignoring this call.");
    static final DiagnosticType POLYMER_INVALID_DECLARATION = DiagnosticType.error("JSC_POLYMER_INVALID_DECLARAION", "A Polymer() declaration cannot use 'let' or 'const'.");
    static final DiagnosticType POLYMER_MISSING_IS = DiagnosticType.error("JSC_POLYMER_MISSING_IS", "The class descriptor must include an 'is' property.");
    static final DiagnosticType POLYMER_UNEXPECTED_PARAMS = DiagnosticType.error("JSC_POLYMER_UNEXPECTED_PARAMS", "The class definition has too many arguments.");
    static final DiagnosticType POLYMER_MISSING_EXTERNS = DiagnosticType.error("JSC_POLYMER_MISSING_EXTERNS", "Missing Polymer externs.");
    static final DiagnosticType POLYMER_INVALID_PROPERTY = DiagnosticType.error("JSC_POLYMER_INVALID_PROPERTY", "Polymer property has an invalid or missing type.");
    static final DiagnosticType POLYMER_INVALID_BEHAVIOR_ARRAY = DiagnosticType.error("JSC_POLYMER_INVALID_BEHAVIOR_ARRAY", "The behaviors property must be an array literal.");
    static final DiagnosticType POLYMER_UNQUALIFIED_BEHAVIOR = DiagnosticType.error("JSC_POLYMER_UNQUALIFIED_BEHAVIOR", "Behaviors must be global, fully qualified names which are declared as object literals or array literals of other valid Behaviors.");
    static final DiagnosticType POLYMER_UNANNOTATED_BEHAVIOR = DiagnosticType.error("JSC_POLYMER_UNANNOTATED_BEHAVIOR", "Behavior declarations must be annotated with @polymerBehavior.");
    static final DiagnosticType POLYMER_SHORTHAND_NOT_SUPPORTED = DiagnosticType.error("JSC_POLYMER_SHORTHAND_NOT_SUPPORTED", "Shorthand assignment in object literal is not allowed in Polymer call arguments");
    static final String VIRTUAL_FILE = "<PolymerPass.java>";
    private final AbstractCompiler compiler;
    private Node polymerElementExterns;
    private Set<String> nativeExternsAdded;
    private final Map<String, String> tagNameMap;
    private List<Node> polymerElementProps;
    private final ImmutableSet<String> behaviorNamesNotToCopy;
    private GlobalNamespace globalNames;

    public PolymerPass(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.tagNameMap = TagNameToType.getMap();
        this.polymerElementProps = new ArrayList<Node>();
        this.nativeExternsAdded = new HashSet<String>();
        this.behaviorNamesNotToCopy = ImmutableSet.of((Object)"created", (Object)"attached", (Object)"detached", (Object)"attributeChanged", (Object)"configure", (Object)"ready", (Object[])new String[]{"properties", "listeners", "observers", "hostAttributes"});
    }

    @Override
    public void process(Node externs, Node root) {
        FindPolymerExterns externsCallback = new FindPolymerExterns();
        NodeTraversal.traverseEs6(this.compiler, externs, externsCallback);
        this.polymerElementExterns = externsCallback.polymerElementExterns;
        this.polymerElementProps = externsCallback.getpolymerElementProps();
        if (this.polymerElementExterns == null) {
            this.compiler.report(JSError.make(externs, POLYMER_MISSING_EXTERNS, new String[0]));
            return;
        }
        this.globalNames = new GlobalNamespace(this.compiler, externs, root);
        this.hotSwapScript(root, null);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverseEs6(this.compiler, scriptRoot, this);
        SuppressBehaviors suppressBehaviorsCallback = new SuppressBehaviors(this.compiler);
        NodeTraversal.traverseEs6(this.compiler, scriptRoot, suppressBehaviorsCallback);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (PolymerPass.isPolymerCall(n)) {
            this.rewriteClassDefinition(n, parent, t);
        }
    }

    private void rewriteClassDefinition(Node n, Node parent, NodeTraversal t) {
        if (parent.getParent().isConst() || parent.getParent().isLet()) {
            this.compiler.report(JSError.make(n, POLYMER_INVALID_DECLARATION, new String[0]));
            return;
        }
        ClassDefinition def = this.extractClassDefinition(n);
        if (def != null) {
            if (NodeUtil.isNameDeclaration(parent.getParent()) || parent.isAssign()) {
                this.rewritePolymerClass(parent.getParent(), def, t);
            } else {
                this.rewritePolymerClass(parent, def, t);
            }
        }
    }

    private ClassDefinition extractClassDefinition(Node callNode) {
        Node descriptor = NodeUtil.getArgumentForCallOrNew(callNode, 0);
        if (descriptor == null || !descriptor.isObjectLit()) {
            this.compiler.report(JSError.make(callNode, POLYMER_DESCRIPTOR_NOT_VALID, new String[0]));
            return null;
        }
        int paramCount = callNode.getChildCount() - 1;
        if (paramCount != 1) {
            this.compiler.report(JSError.make(callNode, POLYMER_UNEXPECTED_PARAMS, new String[0]));
            return null;
        }
        Node elName = NodeUtil.getFirstPropMatchingKey(descriptor, "is");
        if (elName == null) {
            this.compiler.report(JSError.make(callNode, POLYMER_MISSING_IS, new String[0]));
            return null;
        }
        String elNameString = CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_CAMEL, elName.getString());
        elNameString = elNameString + "Element";
        Node target = NodeUtil.isNameDeclaration(callNode.getParent().getParent()) ? IR.name(callNode.getParent().getString()) : (callNode.getParent().isAssign() ? callNode.getParent().getFirstChild().cloneTree() : IR.name(elNameString));
        target.useSourceInfoIfMissingFrom(callNode);
        JSDocInfo classInfo = NodeUtil.getBestJSDocInfo(target);
        JSDocInfo ctorInfo = null;
        Node constructor = NodeUtil.getFirstPropMatchingKey(descriptor, "factoryImpl");
        if (constructor == null) {
            constructor = IR.function(IR.name(""), IR.paramList(), IR.block());
            constructor.useSourceInfoFromForTree(callNode);
        } else {
            ctorInfo = NodeUtil.getBestJSDocInfo(constructor);
        }
        Node baseClass = NodeUtil.getFirstPropMatchingKey(descriptor, "extends");
        String nativeBaseElement = baseClass == null ? null : baseClass.getString();
        Node behaviorArray = NodeUtil.getFirstPropMatchingKey(descriptor, "behaviors");
        List<BehaviorDefinition> behaviors = this.extractBehaviors(behaviorArray);
        LinkedList<MemberDefinition> allProperties = new LinkedList<MemberDefinition>();
        for (BehaviorDefinition behavior : behaviors) {
            PolymerPass.overwriteMembersIfPresent(allProperties, behavior.props);
        }
        PolymerPass.overwriteMembersIfPresent(allProperties, PolymerPass.extractProperties(descriptor));
        ClassDefinition def = new ClassDefinition(target, descriptor, classInfo, new MemberDefinition(ctorInfo, null, constructor), nativeBaseElement, allProperties, behaviors);
        return def;
    }

    private static void overwriteMembersIfPresent(List<MemberDefinition> list, List<MemberDefinition> newMembers) {
        for (MemberDefinition newMember : newMembers) {
            for (MemberDefinition member : list) {
                if (!member.name.getString().equals(newMember.name.getString())) continue;
                list.remove(member);
                break;
            }
            list.add(newMember);
        }
    }

    private List<BehaviorDefinition> extractBehaviors(Node behaviorArray) {
        if (behaviorArray == null) {
            return ImmutableList.of();
        }
        if (!behaviorArray.isArrayLit()) {
            this.compiler.report(JSError.make(behaviorArray, POLYMER_INVALID_BEHAVIOR_ARRAY, new String[0]));
            return ImmutableList.of();
        }
        ImmutableList.Builder behaviors = ImmutableList.builder();
        for (Node behaviorName : behaviorArray.children()) {
            Node behaviorValue;
            if (behaviorName.isObjectLit()) {
                this.switchDollarSignPropsToBrackets(behaviorName);
                this.quoteListenerAndHostAttributeKeys(behaviorName);
                behaviors.add((Object)new BehaviorDefinition(PolymerPass.extractProperties(behaviorName), this.getBehaviorFunctionsToCopy(behaviorName), this.getNonPropertyMembersToCopy(behaviorName), !NodeUtil.isInFunction(behaviorName)));
                continue;
            }
            GlobalNamespace.Name behaviorGlobalName = this.globalNames.getSlot(behaviorName.getQualifiedName());
            boolean isGlobalDeclaration = true;
            if (behaviorGlobalName == null) {
                this.compiler.report(JSError.make(behaviorName, POLYMER_UNQUALIFIED_BEHAVIOR, new String[0]));
                continue;
            }
            GlobalNamespace.Ref behaviorDeclaration = behaviorGlobalName.getDeclaration();
            if (behaviorDeclaration == null) {
                List<GlobalNamespace.Ref> behaviorRefs = behaviorGlobalName.getRefs();
                for (GlobalNamespace.Ref ref : behaviorRefs) {
                    if (!ref.isSet()) continue;
                    isGlobalDeclaration = false;
                    behaviorDeclaration = ref;
                    break;
                }
            }
            if (behaviorDeclaration == null) {
                this.compiler.report(JSError.make(behaviorName, POLYMER_UNQUALIFIED_BEHAVIOR, new String[0]));
                continue;
            }
            Node behaviorDeclarationNode = behaviorDeclaration.getNode();
            JSDocInfo behaviorInfo = NodeUtil.getBestJSDocInfo(behaviorDeclarationNode);
            if (behaviorInfo == null || !behaviorInfo.isPolymerBehavior()) {
                this.compiler.report(JSError.make(behaviorDeclarationNode, POLYMER_UNANNOTATED_BEHAVIOR, new String[0]));
            }
            if ((behaviorValue = NodeUtil.getRValueOfLValue(behaviorDeclarationNode)) == null) {
                this.compiler.report(JSError.make(behaviorName, POLYMER_UNQUALIFIED_BEHAVIOR, new String[0]));
                continue;
            }
            if (behaviorValue.isArrayLit()) {
                behaviors.addAll(this.extractBehaviors(behaviorValue));
                continue;
            }
            if (behaviorValue.isObjectLit()) {
                this.switchDollarSignPropsToBrackets(behaviorValue);
                this.quoteListenerAndHostAttributeKeys(behaviorValue);
                behaviors.add((Object)new BehaviorDefinition(PolymerPass.extractProperties(behaviorValue), this.getBehaviorFunctionsToCopy(behaviorValue), this.getNonPropertyMembersToCopy(behaviorValue), isGlobalDeclaration));
                continue;
            }
            this.compiler.report(JSError.make(behaviorName, POLYMER_UNQUALIFIED_BEHAVIOR, new String[0]));
        }
        return behaviors.build();
    }

    private List<MemberDefinition> getBehaviorFunctionsToCopy(Node behaviorObjLit) {
        Preconditions.checkState((boolean)behaviorObjLit.isObjectLit());
        ImmutableList.Builder functionsToCopy = ImmutableList.builder();
        for (Node keyNode : behaviorObjLit.children()) {
            if ((!keyNode.isStringKey() || !keyNode.getFirstChild().isFunction()) && !keyNode.isMemberFunctionDef() || this.behaviorNamesNotToCopy.contains((Object)keyNode.getString())) continue;
            functionsToCopy.add((Object)new MemberDefinition(NodeUtil.getBestJSDocInfo(keyNode), keyNode, keyNode.getFirstChild()));
        }
        return functionsToCopy.build();
    }

    private List<MemberDefinition> getNonPropertyMembersToCopy(Node behaviorObjLit) {
        Preconditions.checkState((boolean)behaviorObjLit.isObjectLit());
        ImmutableList.Builder membersToCopy = ImmutableList.builder();
        for (Node keyNode : behaviorObjLit.children()) {
            if (!keyNode.isGetterDef() && (!keyNode.isStringKey() || keyNode.getFirstChild().isFunction() || this.behaviorNamesNotToCopy.contains((Object)keyNode.getString()))) continue;
            membersToCopy.add((Object)new MemberDefinition(NodeUtil.getBestJSDocInfo(keyNode), keyNode, keyNode.getFirstChild()));
        }
        return membersToCopy.build();
    }

    private static List<MemberDefinition> extractProperties(Node descriptor) {
        Node properties = NodeUtil.getFirstPropMatchingKey(descriptor, "properties");
        if (properties == null) {
            return ImmutableList.of();
        }
        ImmutableList.Builder members = ImmutableList.builder();
        for (Node keyNode : properties.children()) {
            members.add((Object)new MemberDefinition(NodeUtil.getBestJSDocInfo(keyNode), keyNode, keyNode.getFirstChild()));
        }
        return members.build();
    }

    private void rewritePolymerClass(Node exprRoot, ClassDefinition cls, NodeTraversal t) {
        Node call = exprRoot.getFirstChild();
        if (call.isAssign()) {
            call = call.getChildAtIndex(1);
        } else if (call.isName()) {
            call = call.getFirstChild();
        }
        Node objLit = cls.descriptor;
        if (this.hasShorthandAssignment(objLit)) {
            this.compiler.report(JSError.make(objLit, POLYMER_SHORTHAND_NOT_SUPPORTED, new String[0]));
            return;
        }
        JSDocInfoBuilder objLitDoc = new JSDocInfoBuilder(true);
        objLitDoc.recordLends(cls.target.getQualifiedName() + ".prototype");
        objLit.setJSDocInfo(objLitDoc.build());
        this.addTypesToFunctions(objLit, cls.target.getQualifiedName());
        this.switchDollarSignPropsToBrackets(objLit);
        this.quoteListenerAndHostAttributeKeys(objLit);
        Node block = IR.block();
        if (cls.nativeBaseElement != null) {
            this.appendPolymerElementExterns(cls);
        }
        JSDocInfoBuilder constructorDoc = this.getConstructorDoc(cls);
        Node ctorKey = cls.constructor.value.getParent();
        if (ctorKey != null) {
            ctorKey.removeProp(29);
        }
        if (cls.target.isGetProp()) {
            Node assign = IR.assign(cls.target.cloneTree(), cls.constructor.value.cloneTree());
            assign.setJSDocInfo(constructorDoc.build());
            Node exprResult = IR.exprResult(assign);
            block.addChildToBack(exprResult);
        } else {
            Node var = IR.var(cls.target.cloneTree(), cls.constructor.value.cloneTree());
            var.setJSDocInfo(constructorDoc.build());
            block.addChildToBack(var);
        }
        this.appendPropertiesToBlock(cls, block, cls.target.getQualifiedName() + ".prototype.");
        this.appendBehaviorMembersToBlock(cls, block);
        List<MemberDefinition> readOnlyProps = this.parseReadOnlyProperties(cls, block);
        this.addInterfaceExterns(cls, readOnlyProps);
        this.removePropertyDocs(objLit);
        block.useSourceInfoIfMissingFromForTree(exprRoot);
        Node stmts = block.removeChildren();
        Node parent = exprRoot.getParent();
        if (!t.getScope().isGlobal() && !cls.target.isGetProp()) {
            Node scriptNode = NodeUtil.getEnclosingScript(exprRoot);
            scriptNode.addChildrenToFront(stmts);
        } else {
            Node beforeRoot = parent.getChildBefore(exprRoot);
            if (beforeRoot == null) {
                parent.addChildrenToFront(stmts);
            } else {
                parent.addChildrenAfter(stmts, beforeRoot);
            }
        }
        if (exprRoot.isVar()) {
            Node assignExpr = PolymerPass.varToAssign(exprRoot);
            parent.replaceChild(exprRoot, assignExpr);
        }
        this.compiler.reportCodeChange();
    }

    private void addTypesToFunctions(Node objLit, String thisType) {
        Preconditions.checkState((boolean)objLit.isObjectLit());
        for (Node keyNode : objLit.children()) {
            Node value = keyNode.getLastChild();
            if (value == null || !value.isFunction()) continue;
            JSDocInfoBuilder fnDoc = JSDocInfoBuilder.maybeCopyFrom(keyNode.getJSDocInfo());
            fnDoc.recordThisType(new JSTypeExpression(new Node(306, IR.string(thisType)), VIRTUAL_FILE));
            keyNode.setJSDocInfo(fnDoc.build());
        }
        for (MemberDefinition property : PolymerPass.extractProperties(objLit)) {
            if (!property.value.isObjectLit()) continue;
            if (this.hasShorthandAssignment(property.value)) {
                this.compiler.report(JSError.make(property.value, POLYMER_SHORTHAND_NOT_SUPPORTED, new String[0]));
                return;
            }
            Node defaultValue = NodeUtil.getFirstPropMatchingKey(property.value, "value");
            if (defaultValue == null || !defaultValue.isFunction()) continue;
            Node defaultValueKey = defaultValue.getParent();
            JSDocInfoBuilder fnDoc = JSDocInfoBuilder.maybeCopyFrom(defaultValueKey.getJSDocInfo());
            fnDoc.recordThisType(new JSTypeExpression(new Node(306, IR.string(thisType)), VIRTUAL_FILE));
            fnDoc.recordReturnType(this.getTypeFromProperty(property));
            defaultValueKey.setJSDocInfo(fnDoc.build());
        }
    }

    private void switchDollarSignPropsToBrackets(Node objLit) {
        Preconditions.checkState((boolean)objLit.isObjectLit());
        for (Node keyNode : objLit.children()) {
            Node value = keyNode.getFirstChild();
            if (value == null || !value.isFunction()) continue;
            NodeUtil.visitPostOrder(value.getLastChild(), new NodeUtil.Visitor(){

                @Override
                public void visit(Node n) {
                    if (n.isString() && n.getString().equals("$") && n.getParent().isGetProp() && n.getParent().getParent().isGetProp()) {
                        Node dollarChildProp = n.getParent().getParent();
                        dollarChildProp.setType(35);
                        PolymerPass.this.compiler.reportCodeChange();
                    }
                }
            }, (Predicate<Node>)Predicates.alwaysTrue());
        }
    }

    private void quoteListenerAndHostAttributeKeys(Node objLit) {
        Preconditions.checkState((boolean)objLit.isObjectLit());
        for (Node keyNode : objLit.children()) {
            if (keyNode.isComputedProp() || !keyNode.getString().equals("listeners") && !keyNode.getString().equals("hostAttributes")) continue;
            for (Node keyToQuote : keyNode.getFirstChild().children()) {
                keyToQuote.setQuotedString();
            }
        }
    }

    private void appendPropertiesToBlock(ClassDefinition cls, Node block, String basePath) {
        for (MemberDefinition prop : cls.props) {
            Node propertyNode = IR.exprResult(NodeUtil.newQName(this.compiler, basePath + prop.name.getString()));
            JSDocInfoBuilder info = JSDocInfoBuilder.maybeCopyFrom(prop.info);
            JSTypeExpression propType = this.getTypeFromProperty(prop);
            if (propType == null) {
                return;
            }
            info.recordType(propType);
            propertyNode.getFirstChild().setJSDocInfo(info.build());
            block.addChildToBack(propertyNode);
        }
    }

    private void removePropertyDocs(Node objLit) {
        for (MemberDefinition prop : PolymerPass.extractProperties(objLit)) {
            prop.name.removeProp(29);
        }
    }

    private void appendBehaviorMembersToBlock(ClassDefinition cls, Node block) {
        String qualifiedPath = cls.target.getQualifiedName() + ".prototype.";
        HashMap<String, Node> nameToExprResult = new HashMap<String, Node>();
        for (BehaviorDefinition behavior : cls.behaviors) {
            for (MemberDefinition behaviorFunction : behavior.functionsToCopy) {
                String fnName = behaviorFunction.name.getString();
                if (NodeUtil.getFirstPropMatchingKey(cls.descriptor, fnName) != null) continue;
                if (nameToExprResult.containsKey(fnName)) {
                    block.removeChild((Node)nameToExprResult.get(fnName));
                }
                Node fnValue = behaviorFunction.value.cloneTree();
                Node exprResult = IR.exprResult(IR.assign(NodeUtil.newQName(this.compiler, qualifiedPath + fnName), fnValue));
                JSDocInfoBuilder info = JSDocInfoBuilder.maybeCopyFrom(behaviorFunction.info);
                if (!behavior.isGlobalDeclaration) {
                    NodeUtil.getFunctionBody(fnValue).removeChildren();
                }
                exprResult.getFirstChild().setJSDocInfo(info.build());
                block.addChildToBack(exprResult);
                nameToExprResult.put(fnName, exprResult);
            }
            for (MemberDefinition behaviorProp : behavior.nonPropertyMembersToCopy) {
                String propName = behaviorProp.name.getString();
                if (nameToExprResult.containsKey(propName)) {
                    block.removeChild((Node)nameToExprResult.get(propName));
                }
                Node exprResult = IR.exprResult(NodeUtil.newQName(this.compiler, qualifiedPath + propName));
                JSDocInfoBuilder info = JSDocInfoBuilder.maybeCopyFrom(behaviorProp.info);
                if (behaviorProp.name.isGetterDef()) {
                    info = new JSDocInfoBuilder(true);
                    if (behaviorProp.info != null && behaviorProp.info.getReturnType() != null) {
                        info.recordType(behaviorProp.info.getReturnType());
                    }
                }
                exprResult.getFirstChild().setJSDocInfo(info.build());
                block.addChildToBack(exprResult);
                nameToExprResult.put(propName, exprResult);
            }
        }
    }

    private List<MemberDefinition> parseReadOnlyProperties(ClassDefinition cls, Node block) {
        String qualifiedPath = cls.target.getQualifiedName() + ".prototype.";
        ImmutableList.Builder readOnlyProps = ImmutableList.builder();
        for (MemberDefinition prop : cls.props) {
            Node readOnlyValue;
            if (!prop.value.isObjectLit() || (readOnlyValue = NodeUtil.getFirstPropMatchingKey(prop.value, "readOnly")) == null || !readOnlyValue.isTrue()) continue;
            block.addChildToBack(this.makeReadOnlySetter(prop.name.getString(), qualifiedPath));
            readOnlyProps.add((Object)prop);
        }
        return readOnlyProps.build();
    }

    private JSTypeExpression getTypeFromProperty(MemberDefinition property) {
        if (property.info != null && property.info.hasType()) {
            return property.info.getType();
        }
        String typeString = "";
        if (property.value.isObjectLit()) {
            Node typeValue = NodeUtil.getFirstPropMatchingKey(property.value, "type");
            if (typeValue == null || !typeValue.isName()) {
                this.compiler.report(JSError.make(property.name, POLYMER_INVALID_PROPERTY, new String[0]));
                return null;
            }
            typeString = typeValue.getString();
        } else if (property.value.isName()) {
            typeString = property.value.getString();
        }
        Node typeNode = null;
        switch (typeString) {
            case "Boolean": 
            case "String": 
            case "Number": {
                typeNode = IR.string(typeString.toLowerCase());
                break;
            }
            case "Array": 
            case "Function": 
            case "Object": 
            case "Date": {
                typeNode = new Node(306, IR.string(typeString));
                break;
            }
            default: {
                this.compiler.report(JSError.make(property.name, POLYMER_INVALID_PROPERTY, new String[0]));
                return null;
            }
        }
        return new JSTypeExpression(typeNode, VIRTUAL_FILE);
    }

    private Node makeReadOnlySetter(String propName, String qualifiedPath) {
        String setterName = "_set" + propName.substring(0, 1).toUpperCase() + propName.substring(1);
        Node fnNode = IR.function(IR.name(""), IR.paramList(IR.name(propName)), IR.block());
        Node exprResNode = IR.exprResult(IR.assign(NodeUtil.newQName(this.compiler, qualifiedPath + setterName), fnNode));
        JSDocInfoBuilder info = new JSDocInfoBuilder(true);
        info.recordOverride();
        exprResNode.getFirstChild().setJSDocInfo(info.build());
        return exprResNode;
    }

    private void appendPolymerElementExterns(ClassDefinition cls) {
        if (!this.nativeExternsAdded.add(cls.nativeBaseElement)) {
            return;
        }
        Node block = IR.block();
        Node baseExterns = this.polymerElementExterns.cloneTree();
        String polymerElementType = PolymerPass.getPolymerElementType(cls);
        baseExterns.getFirstChild().setString(polymerElementType);
        String elementType = this.tagNameMap.get(cls.nativeBaseElement);
        JSTypeExpression elementBaseType = new JSTypeExpression(new Node(306, IR.string(elementType)), VIRTUAL_FILE);
        JSDocInfoBuilder baseDocs = JSDocInfoBuilder.copyFrom(baseExterns.getJSDocInfo());
        baseDocs.changeBaseType(elementBaseType);
        baseExterns.setJSDocInfo(baseDocs.build());
        block.addChildToBack(baseExterns);
        for (Node baseProp : this.polymerElementProps) {
            Node newProp = baseProp.cloneTree();
            Node newPropRootName = NodeUtil.getRootOfQualifiedName(newProp.getFirstChild().getFirstChild());
            newPropRootName.setString(polymerElementType);
            block.addChildToBack(newProp);
        }
        block.useSourceInfoIfMissingFromForTree(this.polymerElementExterns);
        Node parent = this.polymerElementExterns.getParent();
        Node stmts = block.removeChildren();
        parent.addChildrenAfter(stmts, this.polymerElementExterns);
        this.compiler.reportCodeChange();
    }

    private void addInterfaceExterns(ClassDefinition cls, List<MemberDefinition> readOnlyProps) {
        Node block = IR.block();
        String interfaceName = this.getInterfaceName(cls);
        Node fnNode = IR.function(IR.name(""), IR.paramList(), IR.block());
        Node varNode = IR.var(NodeUtil.newQName(this.compiler, interfaceName), fnNode);
        JSDocInfoBuilder info = new JSDocInfoBuilder(true);
        info.recordInterface();
        varNode.setJSDocInfo(info.build());
        block.addChildToBack(varNode);
        this.appendPropertiesToBlock(cls, block, interfaceName + ".prototype.");
        for (MemberDefinition prop : readOnlyProps) {
            String propName = prop.name.getString();
            String setterName = "_set" + propName.substring(0, 1).toUpperCase() + propName.substring(1);
            Node setterExprNode = IR.exprResult(NodeUtil.newQName(this.compiler, interfaceName + ".prototype." + setterName));
            JSDocInfoBuilder setterInfo = new JSDocInfoBuilder(true);
            JSTypeExpression propType = this.getTypeFromProperty(prop);
            setterInfo.recordParameter(propName, propType);
            setterExprNode.getFirstChild().setJSDocInfo(setterInfo.build());
            block.addChildToBack(setterExprNode);
        }
        block.useSourceInfoIfMissingFromForTree(this.polymerElementExterns);
        Node parent = this.polymerElementExterns.getParent();
        Node stmts = block.removeChildren();
        parent.addChildrenToBack(stmts);
        this.compiler.reportCodeChange();
    }

    private String getInterfaceName(ClassDefinition cls) {
        return "Polymer" + cls.target.getQualifiedName().replaceAll("\\.", "_") + "Interface";
    }

    private JSDocInfoBuilder getConstructorDoc(ClassDefinition cls) {
        JSDocInfoBuilder constructorDoc = JSDocInfoBuilder.maybeCopyFrom(cls.constructor.info);
        constructorDoc.recordConstructor();
        JSTypeExpression baseType = new JSTypeExpression(new Node(306, IR.string(PolymerPass.getPolymerElementType(cls))), VIRTUAL_FILE);
        constructorDoc.recordBaseType(baseType);
        String interfaceName = this.getInterfaceName(cls);
        JSTypeExpression interfaceType = new JSTypeExpression(new Node(306, IR.string(interfaceName)), VIRTUAL_FILE);
        constructorDoc.recordImplementedInterface(interfaceType);
        return constructorDoc;
    }

    private static Node varToAssign(Node var) {
        Node assign = IR.assign(IR.name(var.getFirstChild().getString()), var.getFirstChild().removeFirstChild());
        return IR.exprResult(assign).useSourceInfoFromForTree(var);
    }

    private static String getPolymerElementType(ClassDefinition cls) {
        return SimpleFormat.format("Polymer%sElement", cls.nativeBaseElement == null ? "" : CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_CAMEL, cls.nativeBaseElement));
    }

    private static boolean isPolymerCall(Node value) {
        return value != null && value.isCall() && value.getFirstChild().matchesQualifiedName("Polymer");
    }

    private boolean hasShorthandAssignment(Node objLit) {
        Preconditions.checkState((boolean)objLit.isObjectLit());
        for (Node property : objLit.children()) {
            if (!property.isStringKey() || property.hasChildren()) continue;
            return true;
        }
        return false;
    }

    private static final class ClassDefinition {
        final Node target;
        final Node descriptor;
        final MemberDefinition constructor;
        final String nativeBaseElement;
        final List<MemberDefinition> props;
        final List<BehaviorDefinition> behaviors;

        ClassDefinition(Node target, Node descriptor, JSDocInfo classInfo, MemberDefinition constructor, String nativeBaseElement, List<MemberDefinition> props, List<BehaviorDefinition> behaviors) {
            this.target = target;
            Preconditions.checkState((boolean)descriptor.isObjectLit());
            this.descriptor = descriptor;
            this.constructor = constructor;
            this.nativeBaseElement = nativeBaseElement;
            this.props = props;
            this.behaviors = behaviors;
        }
    }

    private static final class BehaviorDefinition {
        final List<MemberDefinition> props;
        final List<MemberDefinition> functionsToCopy;
        final List<MemberDefinition> nonPropertyMembersToCopy;
        final boolean isGlobalDeclaration;

        BehaviorDefinition(List<MemberDefinition> props, List<MemberDefinition> functionsToCopy, List<MemberDefinition> nonPropertyMembersToCopy, boolean isGlobalDeclaration) {
            this.props = props;
            this.functionsToCopy = functionsToCopy;
            this.nonPropertyMembersToCopy = nonPropertyMembersToCopy;
            this.isGlobalDeclaration = isGlobalDeclaration;
        }
    }

    private static class MemberDefinition {
        final JSDocInfo info;
        final Node name;
        final Node value;

        MemberDefinition(JSDocInfo info, Node name, Node value) {
            this.info = info;
            this.name = name;
            this.value = value;
        }
    }

    private static class SuppressBehaviors
    extends NodeTraversal.AbstractPostOrderCallback {
        private final AbstractCompiler compiler;

        public SuppressBehaviors(AbstractCompiler compiler) {
            this.compiler = compiler;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (this.isBehavior(n)) {
                if (!n.isVar() && !n.isAssign()) {
                    this.compiler.report(JSError.make(n, POLYMER_UNQUALIFIED_BEHAVIOR, new String[0]));
                    return;
                }
                JSDocInfoBuilder newDocs = JSDocInfoBuilder.maybeCopyFrom(n.getJSDocInfo());
                newDocs.recordNoCollapse();
                n.setJSDocInfo(newDocs.build());
                Node behaviorValue = n.getChildAtIndex(1);
                if (n.isVar()) {
                    behaviorValue = n.getFirstChild().getFirstChild();
                }
                this.suppressBehavior(behaviorValue);
            }
        }

        private boolean isBehavior(Node value) {
            return value.getJSDocInfo() != null && value.getJSDocInfo().isPolymerBehavior();
        }

        private void suppressBehavior(Node behaviorValue) {
            if (behaviorValue == null) {
                this.compiler.report(JSError.make(behaviorValue, POLYMER_UNQUALIFIED_BEHAVIOR, new String[0]));
                return;
            }
            if (behaviorValue.isArrayLit()) {
                for (Node child : behaviorValue.children()) {
                    this.suppressBehavior(child);
                }
            } else if (behaviorValue.isObjectLit()) {
                this.stripPropertyTypes(behaviorValue);
                this.addBehaviorSuppressions(behaviorValue);
            }
        }

        private void stripPropertyTypes(Node behaviorValue) {
            List properties = PolymerPass.extractProperties(behaviorValue);
            for (MemberDefinition property : properties) {
                property.name.removeProp(29);
            }
        }

        private void suppressDefaultValues(Node behaviorValue) {
            for (MemberDefinition property : PolymerPass.extractProperties(behaviorValue)) {
                Node defaultValue;
                if (!property.value.isObjectLit() || (defaultValue = NodeUtil.getFirstPropMatchingKey(property.value, "value")) == null || !defaultValue.isFunction()) continue;
                Node defaultValueKey = defaultValue.getParent();
                JSDocInfoBuilder suppressDoc = JSDocInfoBuilder.maybeCopyFrom(defaultValueKey.getJSDocInfo());
                suppressDoc.addSuppression("checkTypes");
                suppressDoc.addSuppression("globalThis");
                defaultValueKey.setJSDocInfo(suppressDoc.build());
            }
        }

        private void addBehaviorSuppressions(Node behaviorValue) {
            for (Node keyNode : behaviorValue.children()) {
                if (!keyNode.getFirstChild().isFunction()) continue;
                keyNode.removeProp(29);
                JSDocInfoBuilder suppressDoc = new JSDocInfoBuilder(true);
                suppressDoc.addSuppression("checkTypes");
                suppressDoc.addSuppression("globalThis");
                keyNode.setJSDocInfo(suppressDoc.build());
            }
            this.suppressDefaultValues(behaviorValue);
        }
    }

    private static class FindPolymerExterns
    extends NodeTraversal.AbstractPostOrderCallback {
        private Node polymerElementExterns;
        private ImmutableList.Builder<Node> polymerElementProps = ImmutableList.builder();
        private static final String POLYMER_ELEMENT_NAME = "PolymerElement";

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (this.isPolymerElementExterns(n)) {
                this.polymerElementExterns = n;
            } else if (this.isPolymerElementPropExpr(n)) {
                this.polymerElementProps.add((Object)n);
            }
        }

        private boolean isPolymerElementExterns(Node value) {
            return value != null && value.isVar() && value.getFirstChild().matchesQualifiedName(POLYMER_ELEMENT_NAME);
        }

        private boolean isPolymerElementPropExpr(Node value) {
            return value != null && value.isExprResult() && value.getFirstChild().getFirstChild() != null && value.getFirstChild().getFirstChild().isGetProp() && NodeUtil.getRootOfQualifiedName(value.getFirstChild().getFirstChild()).matchesQualifiedName(POLYMER_ELEMENT_NAME);
        }

        public List<Node> getpolymerElementProps() {
            return this.polymerElementProps.build();
        }
    }
}

