/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AnonymousFunctionNamingCallback;
import com.google.javascript.jscomp.CodePrinter;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NameGenerator;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.VariableMap;
import com.google.javascript.rhino.Node;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

class NameAnonymousFunctionsMapped
implements CompilerPass {
    private static Logger logger = Logger.getLogger(NameAnonymousFunctionsMapped.class.getName());
    static final char PREFIX = '$';
    static final String PREFIX_STRING = "$";
    private final AbstractCompiler compiler;
    private final NameGenerator nameGenerator;
    private final VariableMap previousMap;
    private final Map<String, String> renameMap;
    private int namedCount = 0;
    private int bytesUsed = 0;

    NameAnonymousFunctionsMapped(AbstractCompiler compiler, VariableMap previousMap) {
        this.compiler = compiler;
        Set<String> reserved = previousMap != null ? previousMap.getNewNameToOriginalNameMap().keySet() : Collections.emptySet();
        this.nameGenerator = new NameGenerator(reserved, PREFIX_STRING, null);
        this.previousMap = previousMap;
        this.renameMap = new HashMap<String, String>();
    }

    @Override
    public void process(Node externs, Node root) {
        AnonymousFunctionNamingCallback namingCallback = new AnonymousFunctionNamingCallback(new MappedFunctionNamer());
        NodeTraversal.traverseEs6(this.compiler, root, namingCallback);
        logger.fine("Named " + this.namedCount + " anon functions using " + this.bytesUsed + " bytes");
        if (this.namedCount > 0) {
            this.compiler.reportCodeChange();
        }
    }

    VariableMap getFunctionMap() {
        return new VariableMap((Map<String, String>)ImmutableMap.copyOf(this.renameMap));
    }

    private class MappedFunctionNamer
    implements AnonymousFunctionNamingCallback.FunctionNamer {
        static final char DELIMITER = '.';

        private MappedFunctionNamer() {
        }

        @Override
        public final String getName(Node node) {
            switch (node.getType()) {
                case 38: 
                case 40: 
                case 154: {
                    return node.getString();
                }
            }
            return new CodePrinter.Builder(node).build();
        }

        @Override
        public final void setFunctionName(String name, Node fnNode) {
            Node fnNameNode = fnNode.getFirstChild();
            String newName = this.getAlternateName(name);
            fnNameNode.setString(newName);
            NameAnonymousFunctionsMapped.this.namedCount++;
            NameAnonymousFunctionsMapped.this.bytesUsed = NameAnonymousFunctionsMapped.this.bytesUsed + newName.length();
        }

        String getAlternateName(String name) {
            String newName = (String)NameAnonymousFunctionsMapped.this.renameMap.get(name);
            if (newName == null) {
                if (NameAnonymousFunctionsMapped.this.previousMap != null) {
                    newName = NameAnonymousFunctionsMapped.this.previousMap.lookupNewName(name);
                }
                if (newName == null) {
                    newName = NameAnonymousFunctionsMapped.this.nameGenerator.generateNextName();
                }
                NameAnonymousFunctionsMapped.this.renameMap.put(name, newName);
            }
            return newName;
        }

        @Override
        public final String getCombinedName(String lhs, String rhs) {
            return lhs + '.' + rhs;
        }
    }
}

