/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import java.util.Iterator;

public final class JSDocInfoPrinter {
    public static String print(JSDocInfo info) {
        Node typeNode;
        Node typeNode2;
        ImmutableList<String> names;
        Iterator<String> suppressions;
        StringBuilder sb = new StringBuilder("/**");
        if (info.isConstructor()) {
            sb.append("@constructor ");
        }
        if (info.isInterface() && !info.usesImplicitMatch()) {
            sb.append("@interface ");
        }
        if (info.isInterface() && info.usesImplicitMatch()) {
            sb.append("@record ");
        }
        if (info.makesDicts()) {
            sb.append("@dict ");
        }
        if (info.makesStructs()) {
            sb.append("@struct ");
        }
        if (info.makesUnrestricted()) {
            sb.append("@unrestricted ");
        }
        if (info.isDefine()) {
            sb.append("@define {");
            JSDocInfoPrinter.appendTypeNode(sb, info.getType().getRoot());
            sb.append("} ");
        }
        if (info.isOverride()) {
            sb.append("@override ");
        }
        if (info.isConstant()) {
            sb.append("@const ");
        }
        if (info.isExport()) {
            sb.append("@export ");
        }
        if (info.isDeprecated()) {
            sb.append("@deprecated ");
            sb.append(info.getDeprecationReason() + " ");
        }
        if (info.getVisibility() != null && info.getVisibility() != JSDocInfo.Visibility.INHERITED) {
            sb.append("@" + info.getVisibility().toString().toLowerCase() + " ");
        }
        if ((suppressions = info.getSuppressions().iterator()).hasNext()) {
            sb.append("@suppress {");
            while (suppressions.hasNext()) {
                sb.append(suppressions.next());
                if (!suppressions.hasNext()) continue;
                sb.append(",");
            }
            sb.append("} ");
        }
        if (!(names = info.getTemplateTypeNames()).isEmpty()) {
            sb.append("@template ");
            Joiner.on((char)',').appendTo(sb, names);
            sb.append("\n");
        }
        if (info.getParameterCount() > 0) {
            for (String name : info.getParameterNames()) {
                sb.append("@param ");
                if (info.getParameterType(name) != null) {
                    sb.append("{");
                    JSDocInfoPrinter.appendTypeNode(sb, info.getParameterType(name).getRoot());
                    sb.append("} ");
                }
                sb.append(name);
                sb.append(' ');
            }
        }
        if (info.hasReturnType()) {
            sb.append("@return {");
            JSDocInfoPrinter.appendTypeNode(sb, info.getReturnType().getRoot());
            sb.append("} ");
        }
        if (info.hasThisType()) {
            sb.append("@this {");
            typeNode2 = info.getThisType().getRoot();
            if (typeNode2.getType() == 306) {
                JSDocInfoPrinter.appendTypeNode(sb, typeNode2.getFirstChild());
            } else {
                JSDocInfoPrinter.appendTypeNode(sb, typeNode2);
            }
            sb.append("} ");
        }
        if (info.hasBaseType()) {
            sb.append("@extends {");
            typeNode2 = info.getBaseType().getRoot();
            if (typeNode2.getType() == 306) {
                JSDocInfoPrinter.appendTypeNode(sb, typeNode2.getFirstChild());
            } else {
                JSDocInfoPrinter.appendTypeNode(sb, typeNode2);
            }
            sb.append("} ");
        }
        for (JSTypeExpression type : info.getExtendedInterfaces()) {
            sb.append("@extends {");
            typeNode = type.getRoot();
            if (typeNode.getType() == 306) {
                JSDocInfoPrinter.appendTypeNode(sb, typeNode.getFirstChild());
            } else {
                JSDocInfoPrinter.appendTypeNode(sb, typeNode);
            }
            sb.append("} ");
        }
        for (JSTypeExpression type : info.getImplementedInterfaces()) {
            sb.append("@implements {");
            typeNode = type.getRoot();
            if (typeNode.getType() == 306) {
                JSDocInfoPrinter.appendTypeNode(sb, typeNode.getFirstChild());
            } else {
                JSDocInfoPrinter.appendTypeNode(sb, typeNode);
            }
            sb.append("} ");
        }
        if (info.hasTypedefType()) {
            sb.append("@typedef {");
            JSDocInfoPrinter.appendTypeNode(sb, info.getTypedefType().getRoot());
            sb.append("} ");
        }
        if (info.hasType()) {
            if (info.isInlineType()) {
                sb.append(" ");
                JSDocInfoPrinter.appendTypeNode(sb, info.getType().getRoot());
                sb.append(" ");
            } else {
                sb.append("@type {");
                JSDocInfoPrinter.appendTypeNode(sb, info.getType().getRoot());
                sb.append("} ");
            }
        }
        if (!info.getThrownTypes().isEmpty()) {
            sb.append("@throws {");
            JSDocInfoPrinter.appendTypeNode(sb, info.getThrownTypes().get(0).getRoot());
            sb.append("} ");
        }
        if (info.hasEnumParameterType()) {
            sb.append("@enum {");
            JSDocInfoPrinter.appendTypeNode(sb, info.getEnumParameterType().getRoot());
            sb.append("} ");
        }
        sb.append("*/");
        return sb.toString();
    }

    private static void appendTypeNode(StringBuilder sb, Node typeNode) {
        if (typeNode.getType() == 306) {
            sb.append("!");
            JSDocInfoPrinter.appendTypeNode(sb, typeNode.getFirstChild());
        } else if (typeNode.getType() == 307) {
            JSDocInfoPrinter.appendTypeNode(sb, typeNode.getFirstChild());
            sb.append("=");
        } else if (typeNode.getType() == 301) {
            sb.append("(");
            for (int i = 0; i < typeNode.getChildCount() - 1; ++i) {
                JSDocInfoPrinter.appendTypeNode(sb, typeNode.getChildAtIndex(i));
                sb.append("|");
            }
            JSDocInfoPrinter.appendTypeNode(sb, typeNode.getLastChild());
            sb.append(")");
        } else if (typeNode.getType() == 305) {
            sb.append("...");
            if (typeNode.hasChildren()) {
                JSDocInfoPrinter.appendTypeNode(sb, typeNode.getFirstChild());
            }
        } else if (typeNode.getType() == 302) {
            sb.append("*");
        } else if (typeNode.getType() == 304) {
            sb.append("?");
            if (typeNode.hasChildren()) {
                JSDocInfoPrinter.appendTypeNode(sb, typeNode.getFirstChild());
            }
        } else if (typeNode.isFunction()) {
            JSDocInfoPrinter.appendFunctionNode(sb, typeNode);
        } else if (typeNode.getType() == 309) {
            sb.append("{");
            Node lb = typeNode.getFirstChild();
            for (int i = 0; i < lb.getChildCount() - 1; ++i) {
                Node colon = lb.getChildAtIndex(i);
                if (colon.hasChildren()) {
                    sb.append(colon.getFirstChild().getString() + ":");
                    JSDocInfoPrinter.appendTypeNode(sb, colon.getLastChild());
                } else {
                    sb.append(colon.getString());
                }
                sb.append(",");
            }
            Node lastColon = lb.getLastChild();
            if (lastColon.hasChildren()) {
                sb.append(lastColon.getFirstChild().getString() + ":");
                JSDocInfoPrinter.appendTypeNode(sb, lastColon.getLastChild());
            } else {
                sb.append(lastColon.getString());
            }
            sb.append("}");
        } else if (typeNode.getType() == 122) {
            sb.append("void");
        } else if (typeNode.hasChildren()) {
            sb.append(typeNode.getString()).append("<");
            Node child = typeNode.getFirstChild();
            JSDocInfoPrinter.appendTypeNode(sb, child.getFirstChild());
            for (int i = 1; i < child.getChildCount(); ++i) {
                sb.append(",");
                JSDocInfoPrinter.appendTypeNode(sb, child.getChildAtIndex(i));
            }
            sb.append(">");
        } else {
            sb.append(typeNode.getString());
        }
    }

    private static void appendFunctionNode(StringBuilder sb, Node function) {
        boolean hasNewOrThis = false;
        sb.append("function(");
        Node first = function.getFirstChild();
        if (first.isNew()) {
            sb.append("new:");
            JSDocInfoPrinter.appendTypeNode(sb, first.getFirstChild());
            hasNewOrThis = true;
        } else if (first.isThis()) {
            sb.append("this:");
            JSDocInfoPrinter.appendTypeNode(sb, first.getFirstChild());
            hasNewOrThis = true;
        } else {
            if (first.isEmpty()) {
                sb.append(")");
                return;
            }
            if (!first.isParamList()) {
                sb.append("):");
                JSDocInfoPrinter.appendTypeNode(sb, first);
                return;
            }
        }
        Node paramList = null;
        if (first.isParamList()) {
            paramList = first;
        } else if (first.getNext().isParamList()) {
            paramList = first.getNext();
        }
        if (paramList != null) {
            boolean firstParam = true;
            for (Node param : paramList.children()) {
                if (!firstParam || hasNewOrThis) {
                    sb.append(",");
                }
                JSDocInfoPrinter.appendTypeNode(sb, param);
                firstParam = false;
            }
        }
        sb.append(")");
        Node returnType = function.getLastChild();
        if (!returnType.isEmpty()) {
            sb.append(":");
            JSDocInfoPrinter.appendTypeNode(sb, returnType);
        }
    }
}

