/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NTIScope;
import com.google.javascript.jscomp.NewTypeInference;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TypeCheck;
import com.google.javascript.jscomp.TypeValidator;
import com.google.javascript.jscomp.newtypes.Declaration;
import com.google.javascript.jscomp.newtypes.DeclaredFunctionType;
import com.google.javascript.jscomp.newtypes.DeclaredTypeRegistry;
import com.google.javascript.jscomp.newtypes.EnumType;
import com.google.javascript.jscomp.newtypes.FunctionType;
import com.google.javascript.jscomp.newtypes.FunctionTypeBuilder;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.JSTypeCreatorFromJSDoc;
import com.google.javascript.jscomp.newtypes.JSTypes;
import com.google.javascript.jscomp.newtypes.Namespace;
import com.google.javascript.jscomp.newtypes.NominalType;
import com.google.javascript.jscomp.newtypes.QualifiedName;
import com.google.javascript.jscomp.newtypes.RawNominalType;
import com.google.javascript.jscomp.newtypes.Typedef;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class GlobalTypeInfo
implements CompilerPass {
    static final DiagnosticType DUPLICATE_JSDOC = DiagnosticType.warning("JSC_DUPLICATE_JSDOC", "Found two JsDoc comments for variable: {0}.\n");
    static final DiagnosticType REDECLARED_PROPERTY = DiagnosticType.warning("JSC_REDECLARED_PROPERTY", "Found two declarations for property {0} on type {1}.\n");
    static final DiagnosticType INVALID_PROP_OVERRIDE = DiagnosticType.warning("JSC_INVALID_PROP_OVERRIDE", "Invalid redeclaration of property {0}.\ninherited type  : {1}\noverriding type : {2}\n");
    static final DiagnosticType CTOR_IN_DIFFERENT_SCOPE = DiagnosticType.warning("JSC_CTOR_IN_DIFFERENT_SCOPE", "Modifying the prototype is only allowed if the constructor is in the same scope\n");
    static final DiagnosticType UNRECOGNIZED_TYPE_NAME = DiagnosticType.warning("JSC_UNRECOGNIZED_TYPE_NAME", "Type annotation references non-existent type {0}.");
    static final DiagnosticType STRUCTDICT_WITHOUT_CTOR = DiagnosticType.warning("JSC_STRUCTDICT_WITHOUT_CTOR", "{0} used without @constructor.");
    static final DiagnosticType EXPECTED_CONSTRUCTOR = DiagnosticType.warning("JSC_EXPECTED_CONSTRUCTOR", "Expected constructor name but found {0}.");
    static final DiagnosticType EXPECTED_INTERFACE = DiagnosticType.warning("JSC_EXPECTED_INTERFACE", "Expected interface name but found {0}.");
    static final DiagnosticType INEXISTENT_PARAM = DiagnosticType.warning("JSC_INEXISTENT_PARAM", "parameter {0} does not appear in {1}''s parameter list");
    static final DiagnosticType CONST_WITHOUT_INITIALIZER = DiagnosticType.warning("JSC_CONST_WITHOUT_INITIALIZER", "Constants must be initialized when they are defined.");
    static final DiagnosticType COULD_NOT_INFER_CONST_TYPE = DiagnosticType.warning("JSC_COULD_NOT_INFER_CONST_TYPE", "All constants must be typed. The compiler could not infer the type of this constant. Please use an explicit type annotation.");
    static final DiagnosticType MISPLACED_CONST_ANNOTATION = DiagnosticType.warning("JSC_MISPLACED_CONST_ANNOTATION", "This property cannot be @const. The @const annotation is only allowed for properties of namespaces, prototype properties, static properties of constructors, and properties of the form this.prop declared inside constructors.");
    static final DiagnosticType CANNOT_OVERRIDE_FINAL_METHOD = DiagnosticType.warning("JSC_CANNOT_OVERRIDE_FINAL_METHOD", "Final method {0} cannot be overriden.");
    static final DiagnosticType CANNOT_INIT_TYPEDEF = DiagnosticType.warning("JSC_CANNOT_INIT_TYPEDEF", "A typedef variable represents a type name; it cannot be assigned a value.");
    static final DiagnosticType ANONYMOUS_NOMINAL_TYPE = DiagnosticType.warning("JSC_ANONYMOUS_NOMINAL_TYPE", "Must specify a name when defining a class or interface.");
    static final DiagnosticType MALFORMED_ENUM = DiagnosticType.warning("JSC_MALFORMED_ENUM", "An enum must be initialized to a non-empty object literal.");
    static final DiagnosticType DUPLICATE_PROP_IN_ENUM = DiagnosticType.warning("JSC_DUPLICATE_PROP_IN_ENUM", "Property {0} appears twice in the enum declaration.");
    static final DiagnosticType UNDECLARED_NAMESPACE = DiagnosticType.warning("JSC_UNDECLARED_NAMESPACE", "Undeclared reference to {0}.");
    static final DiagnosticType LENDS_ON_BAD_TYPE = DiagnosticType.warning("JSC_LENDS_ON_BAD_TYPE", "May only lend properties to namespaces, constructors and their prototypes. Found {0}.");
    static final DiagnosticType FUNCTION_CONSTRUCTOR_NOT_DEFINED = DiagnosticType.error("JSC_FUNCTION_CONSTRUCTOR_NOT_DEFINED", "You must provide externs that define the built-in Function constructor.");
    static final DiagnosticType INVALID_INTERFACE_PROP_INITIALIZER = DiagnosticType.warning("JSC_INVALID_INTERFACE_PROP_INITIALIZER", "Invalid initialization of interface property.");
    static final DiagnosticType SETTER_WITH_RETURN = DiagnosticType.warning("JSC_SETTER_WITH_RETURN", "Cannot declare a return type on a setter.");
    static final DiagnosticType WRONG_PARAMETER_COUNT = DiagnosticType.warning("JSC_WRONG_PARAMETER_COUNT", "Function definition does not have the declared number of parameters.\nExpected: {0}\nFound: {1}");
    static final DiagnosticType CANNOT_ADD_PROPERTIES_TO_TYPEDEF = DiagnosticType.warning("JSC_CANNOT_ADD_PROPERTIES_TO_TYPEDEF", "A typedef should only be used in type annotations, not as a value. Adding properties to typedefs is not allowed.");
    static final DiagnosticGroup ALL_DIAGNOSTICS = new DiagnosticGroup(ANONYMOUS_NOMINAL_TYPE, CANNOT_ADD_PROPERTIES_TO_TYPEDEF, CANNOT_INIT_TYPEDEF, CANNOT_OVERRIDE_FINAL_METHOD, CONST_WITHOUT_INITIALIZER, COULD_NOT_INFER_CONST_TYPE, CTOR_IN_DIFFERENT_SCOPE, DUPLICATE_JSDOC, DUPLICATE_PROP_IN_ENUM, EXPECTED_CONSTRUCTOR, EXPECTED_INTERFACE, FUNCTION_CONSTRUCTOR_NOT_DEFINED, INEXISTENT_PARAM, INVALID_INTERFACE_PROP_INITIALIZER, INVALID_PROP_OVERRIDE, LENDS_ON_BAD_TYPE, MALFORMED_ENUM, MISPLACED_CONST_ANNOTATION, REDECLARED_PROPERTY, SETTER_WITH_RETURN, STRUCTDICT_WITHOUT_CTOR, UNDECLARED_NAMESPACE, UNRECOGNIZED_TYPE_NAME, WRONG_PARAMETER_COUNT, TypeCheck.CONFLICTING_EXTENDED_TYPE, TypeCheck.ENUM_NOT_CONSTANT, TypeCheck.INCOMPATIBLE_EXTENDED_PROPERTY_TYPE, TypeCheck.MULTIPLE_VAR_DEF, TypeCheck.UNKNOWN_OVERRIDE, TypeValidator.INTERFACE_METHOD_NOT_IMPLEMENTED);
    private final List<NTIScope> scopes = new ArrayList<NTIScope>();
    private NTIScope globalScope;
    private NewTypeInference.WarningReporter warnings;
    private JSTypeCreatorFromJSDoc typeParser;
    private final AbstractCompiler compiler;
    private final CodingConvention convention;
    private final Map<Node, String> anonFunNames = new LinkedHashMap<Node, String>();
    private static final String ANON_FUN_PREFIX = "%anon_fun";
    private int freshId = 1;
    private Map<Node, RawNominalType> nominaltypesByNode = new LinkedHashMap<Node, RawNominalType>();
    private HashBasedTable<RawNominalType, String, PropertyDef> propertyDefs = HashBasedTable.create();
    private Map<Node, JSType> castTypes = new LinkedHashMap<Node, JSType>();
    private Map<Node, JSType> declaredObjLitProps = new LinkedHashMap<Node, JSType>();
    private JSTypes commonTypes;

    GlobalTypeInfo(AbstractCompiler compiler) {
        this.warnings = new NewTypeInference.WarningReporter(compiler);
        this.compiler = compiler;
        this.convention = compiler.getCodingConvention();
        this.typeParser = new JSTypeCreatorFromJSDoc(this.convention);
        this.commonTypes = JSTypes.make();
    }

    Collection<NTIScope> getScopes() {
        return this.scopes;
    }

    NTIScope getGlobalScope() {
        return this.globalScope;
    }

    JSTypes getTypesUtilObject() {
        return this.commonTypes;
    }

    JSType getCastType(Node n) {
        JSType t = this.castTypes.get(n);
        Preconditions.checkNotNull((Object)t);
        return t;
    }

    JSType getPropDeclaredType(Node n) {
        return this.declaredObjLitProps.get(n);
    }

    String getFunInternalName(Node n) {
        Preconditions.checkArgument((boolean)n.isFunction());
        if (this.anonFunNames.containsKey(n)) {
            return this.anonFunNames.get(n);
        }
        Node fnNameNode = NodeUtil.getFunctionNameNode(n);
        Preconditions.checkState((fnNameNode != null ? 1 : 0) != 0);
        Preconditions.checkState((boolean)fnNameNode.isName());
        return fnNameNode.getString();
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkNotNull((Object)this.warnings, (Object)"Cannot rerun GlobalTypeInfo.process");
        Preconditions.checkArgument((externs == null || externs.isSyntheticBlock() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)root.isSyntheticBlock());
        this.globalScope = new NTIScope(root, null, (List<String>)ImmutableList.of(), this.commonTypes);
        this.scopes.add(this.globalScope);
        CollectNamedTypes rootCnt = new CollectNamedTypes(this.globalScope);
        if (externs != null) {
            NodeTraversal.traverseEs6(this.compiler, externs, rootCnt);
        }
        NodeTraversal.traverseEs6(this.compiler, root, rootCnt);
        this.globalScope.resolveTypedefs(this.typeParser);
        this.globalScope.resolveEnums(this.typeParser);
        for (int i = 1; i < this.scopes.size(); ++i) {
            NTIScope s = this.scopes.get(i);
            CollectNamedTypes cnt = new CollectNamedTypes(s);
            NodeTraversal.traverseEs6(this.compiler, s.getBody(), cnt);
            s.resolveTypedefs(this.typeParser);
            s.resolveEnums(this.typeParser);
            if (!NewTypeInference.measureMem) continue;
            NewTypeInference.updatePeakMem();
        }
        if (this.commonTypes.getFunctionType() == null) {
            this.warnings.add(JSError.make(root, FUNCTION_CONSTRUCTOR_NOT_DEFINED, new String[0]));
            return;
        }
        ProcessScope rootPs = new ProcessScope(this.globalScope);
        if (externs != null) {
            NodeTraversal.traverseEs6(this.compiler, externs, rootPs);
        }
        NodeTraversal.traverseEs6(this.compiler, root, rootPs);
        rootPs.finishProcessingScope();
        for (String name : this.globalScope.getUnknownTypeNames()) {
            this.globalScope.mayDeclareUnknownType(QualifiedName.fromQualifiedString(name));
        }
        for (int i = 1; i < this.scopes.size(); ++i) {
            NTIScope s = this.scopes.get(i);
            ProcessScope ps = new ProcessScope(s);
            NodeTraversal.traverseEs6(this.compiler, s.getBody(), ps);
            ps.finishProcessingScope();
            if (!NewTypeInference.measureMem) continue;
            NewTypeInference.updatePeakMem();
        }
        for (RawNominalType rawType : this.nominaltypesByNode.values()) {
            this.checkAndFinalizeNominalType(rawType);
        }
        this.nominaltypesByNode = null;
        this.propertyDefs = null;
        for (NTIScope s : this.scopes) {
            s.removeTmpData();
        }
        Map<Node, String> unknownTypes = this.typeParser.getUnknownTypesMap();
        for (Map.Entry<Node, String> unknownTypeEntry : unknownTypes.entrySet()) {
            this.warnings.add(JSError.make(unknownTypeEntry.getKey(), UNRECOGNIZED_TYPE_NAME, unknownTypeEntry.getValue()));
        }
        for (JSError warning : this.typeParser.getWarnings()) {
            this.warnings.add(warning);
        }
        this.typeParser = null;
        this.compiler.setSymbolTable(this);
        this.warnings = null;
        Collections.reverse(this.scopes);
    }

    private Collection<PropertyDef> getPropDefsFromInterface(NominalType nominalType, String pname) {
        Preconditions.checkArgument((boolean)nominalType.isFinalized());
        Preconditions.checkArgument((boolean)nominalType.isInterface());
        if (nominalType.getPropDeclaredType(pname) == null) {
            return ImmutableSet.of();
        }
        if (this.propertyDefs.get((Object)nominalType.getId(), (Object)pname) != null) {
            return ImmutableSet.of((Object)this.propertyDefs.get((Object)nominalType.getId(), (Object)pname));
        }
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (NominalType interf : nominalType.getInstantiatedInterfaces()) {
            result.addAll(this.getPropDefsFromInterface(interf, pname));
        }
        return result.build();
    }

    private PropertyDef getPropDefFromClass(NominalType nominalType, String pname) {
        while (nominalType.getPropDeclaredType(pname) != null) {
            Preconditions.checkArgument((boolean)nominalType.isFinalized());
            Preconditions.checkArgument((boolean)nominalType.isClass());
            if (this.propertyDefs.get((Object)nominalType.getId(), (Object)pname) != null) {
                return (PropertyDef)this.propertyDefs.get((Object)nominalType.getId(), (Object)pname);
            }
            nominalType = nominalType.getInstantiatedSuperclass();
        }
        return null;
    }

    private void checkAndFinalizeNominalType(RawNominalType rawType) {
        if (rawType.isFinalized()) {
            return;
        }
        NominalType superClass = rawType.getSuperClass();
        Set<String> nonInheritedPropNames = rawType.getAllOwnProps();
        if (superClass != null && !superClass.isFinalized()) {
            this.checkAndFinalizeNominalType(superClass.getRawNominalType());
        }
        for (NominalType superInterf : rawType.getInterfaces()) {
            if (superInterf.isFinalized()) continue;
            this.checkAndFinalizeNominalType(superInterf.getRawNominalType());
        }
        LinkedHashMultimap propMethodTypesToProcess = LinkedHashMultimap.create();
        LinkedHashMultimap propTypesToProcess = LinkedHashMultimap.create();
        if (superClass != null) {
            Preconditions.checkState((boolean)superClass.isFinalized());
            for (String pname : superClass.getAllPropsOfClass()) {
                nonInheritedPropNames.remove(pname);
                this.checkSuperProperty(rawType, superClass, pname, (Multimap<String, DeclaredFunctionType>)propMethodTypesToProcess, (Multimap<String, JSType>)propTypesToProcess);
            }
        }
        for (NominalType superInterf : rawType.getInterfaces()) {
            Preconditions.checkState((boolean)superInterf.isFinalized());
            for (String pname : superInterf.getAllPropsOfInterface()) {
                nonInheritedPropNames.remove(pname);
                this.checkSuperProperty(rawType, superInterf, pname, (Multimap<String, DeclaredFunctionType>)propMethodTypesToProcess, (Multimap<String, JSType>)propTypesToProcess);
            }
        }
        for (String pname : propMethodTypesToProcess.keySet()) {
            Collection methodTypes = propMethodTypesToProcess.get((Object)pname);
            Preconditions.checkState((!methodTypes.isEmpty() ? 1 : 0) != 0);
            PropertyDef localPropDef = (PropertyDef)this.propertyDefs.get((Object)rawType, (Object)pname);
            DeclaredFunctionType superMethodType = DeclaredFunctionType.meet(methodTypes);
            DeclaredFunctionType updatedMethodType = localPropDef.methodType.withTypeInfoFromSuper(superMethodType, GlobalTypeInfo.getsTypeInfoFromParentMethod(localPropDef));
            localPropDef.updateMethodType(updatedMethodType);
            propTypesToProcess.put((Object)pname, (Object)this.commonTypes.fromFunctionType(updatedMethodType.toFunctionType()));
        }
        block5: for (String pname : propTypesToProcess.keySet()) {
            Collection defs = propTypesToProcess.get((Object)pname);
            Preconditions.checkState((!defs.isEmpty() ? 1 : 0) != 0);
            JSType resultType = JSType.TOP;
            for (JSType inheritedType : defs) {
                if (!(resultType = JSType.meet(resultType, inheritedType)).isBottom()) {
                    resultType = inheritedType;
                    continue;
                }
                Node defSite = rawType.getDefSite();
                this.warnings.add(JSError.make(defSite, TypeCheck.INCOMPATIBLE_EXTENDED_PROPERTY_TYPE, NodeUtil.getNearestFunctionName(defSite), pname, "", ""));
                continue block5;
            }
            rawType.addProtoProperty(pname, null, resultType, false);
        }
        for (String pname : nonInheritedPropNames) {
            Node propDefsite = ((PropertyDef)this.propertyDefs.get((Object)rawType, (Object)pname)).defSite;
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(propDefsite);
            if (jsdoc == null || !jsdoc.isOverride()) continue;
            this.warnings.add(JSError.make(propDefsite, TypeCheck.UNKNOWN_OVERRIDE, pname, rawType.getName()));
        }
        rawType.finalize();
    }

    private void checkSuperProperty(RawNominalType current, NominalType superType, String pname, Multimap<String, DeclaredFunctionType> propMethodTypesToProcess, Multimap<String, JSType> propTypesToProcess) {
        JSType localPropType;
        JSType inheritedPropType = superType.getPropDeclaredType(pname);
        if (inheritedPropType == null) {
            return;
        }
        ImmutableSet inheritedPropDefs = superType.isInterface() ? this.getPropDefsFromInterface(superType, pname) : ImmutableSet.of((Object)this.getPropDefFromClass(superType, pname));
        if (superType.isInterface() && current.isClass() && !current.mayHaveProp(pname)) {
            this.warnings.add(JSError.make(((PropertyDef)inheritedPropDefs.iterator().next()).defSite, TypeValidator.INTERFACE_METHOD_NOT_IMPLEMENTED, pname, superType.toString(), current.toString()));
            return;
        }
        PropertyDef localPropDef = (PropertyDef)this.propertyDefs.get((Object)current, (Object)pname);
        JSType jSType = localPropType = localPropDef == null ? null : current.getInstancePropDeclaredType(pname);
        if (localPropDef != null && superType.isClass() && localPropType.getFunType() != null && superType.hasConstantProp(pname)) {
            this.warnings.add(JSError.make(localPropDef.defSite, CANNOT_OVERRIDE_FINAL_METHOD, pname));
            return;
        }
        if (localPropType == null) {
            propTypesToProcess.put((Object)pname, (Object)inheritedPropType);
        } else if (!GlobalTypeInfo.getsTypeInfoFromParentMethod(localPropDef) && !localPropType.isSubtypeOf(inheritedPropType)) {
            this.warnings.add(JSError.make(localPropDef.defSite, INVALID_PROP_OVERRIDE, pname, inheritedPropType.toString(), localPropType.toString()));
        } else if (localPropDef.methodType != null) {
            for (PropertyDef inheritedPropDef : inheritedPropDefs) {
                if (inheritedPropDef.methodType == null) continue;
                propMethodTypesToProcess.put((Object)pname, (Object)inheritedPropDef.methodType.substituteNominalGenerics(superType));
            }
        }
    }

    private static boolean getsTypeInfoFromParentMethod(PropertyDef pd) {
        if (pd == null || pd.methodType == null) {
            return false;
        }
        JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(pd.defSite);
        return jsdoc == null || jsdoc.isOverride() && !jsdoc.containsFunctionDeclaration();
    }

    private JSType getDeclaredTypeOfNode(JSDocInfo jsdoc, NTIScope s) {
        return this.typeParser.getDeclaredTypeOfNode(jsdoc, null, s);
    }

    private DeclaredFunctionType getDeclaredFunctionTypeOfCalleeIfAny(Node fn, NTIScope currentScope) {
        FunctionType funType;
        Preconditions.checkArgument((boolean)fn.getParent().isCall());
        if (fn.isThis() || !fn.isFunction() && !fn.isQualifiedName()) {
            return null;
        }
        if (fn.isFunction()) {
            return currentScope.getScope(this.getFunInternalName(fn)).getDeclaredFunctionType();
        }
        Preconditions.checkState((boolean)fn.isQualifiedName());
        Declaration decl = currentScope.getDeclaration(QualifiedName.fromNode(fn), false);
        if (decl == null) {
            return null;
        }
        if (decl.getFunctionScope() != null) {
            return decl.getFunctionScope().getDeclaredFunctionType();
        }
        if (decl.getTypeOfSimpleDecl() != null && (funType = decl.getTypeOfSimpleDecl().getFunType()) != null) {
            return funType.toDeclaredFunctionType();
        }
        return null;
    }

    private static boolean isClassPropAccess(Node n, NTIScope s) {
        return n.isGetProp() && n.getFirstChild().isThis() && (s.isConstructor() || s.isPrototypeMethod());
    }

    private static boolean isPrototypeProperty(Node getProp) {
        if (!getProp.isGetProp()) {
            return false;
        }
        Node recv = getProp.getFirstChild();
        return recv.isGetProp() && recv.getLastChild().getString().equals("prototype");
    }

    private static boolean isPrototypePropertyDeclaration(Node n) {
        return NodeUtil.isExprAssign(n) && GlobalTypeInfo.isPrototypeProperty(n.getFirstChild().getFirstChild());
    }

    private static boolean isAnnotatedAsConst(Node defSite) {
        JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(defSite);
        return jsdoc != null && jsdoc.hasConstAnnotation() && !jsdoc.isConstructor();
    }

    private static Node fromDefsiteToName(Node defSite) {
        if (defSite.isGetProp()) {
            return defSite.getLastChild();
        }
        if (defSite.isName() || defSite.isStringKey() || defSite.isGetterDef() || defSite.isSetterDef()) {
            return defSite;
        }
        throw new RuntimeException("Unknown defsite: " + Token.name(defSite.getType()));
    }

    private boolean isConst(Node defSite) {
        return GlobalTypeInfo.isAnnotatedAsConst(defSite) || !defSite.isFromExterns() && NodeUtil.isConstantByConvention(this.convention, GlobalTypeInfo.fromDefsiteToName(defSite));
    }

    private static class PropertyDef {
        final Node defSite;
        DeclaredFunctionType methodType;
        final NTIScope methodScope;

        PropertyDef(Node defSite, DeclaredFunctionType methodType, NTIScope methodScope) {
            Preconditions.checkNotNull((Object)defSite);
            Preconditions.checkArgument((defSite.isGetProp() || NodeUtil.isObjectLitKey(defSite) ? 1 : 0) != 0);
            this.defSite = defSite;
            this.methodType = methodType;
            this.methodScope = methodScope;
        }

        void updateMethodType(DeclaredFunctionType updatedType) {
            this.methodType = updatedType;
            if (this.methodScope != null) {
                this.methodScope.setDeclaredType(updatedType);
            }
        }
    }

    private class ProcessScope
    extends NodeTraversal.AbstractShallowCallback {
        private final NTIScope currentScope;
        private Set<Node> lendsObjlits = new LinkedHashSet<Node>();

        ProcessScope(NTIScope currentScope) {
            this.currentScope = currentScope;
        }

        void finishProcessingScope() {
            for (Node objlit : this.lendsObjlits) {
                this.processLendsNode(objlit);
            }
            this.lendsObjlits = null;
        }

        void processLendsNode(Node objlit) {
            JSDocInfo jsdoc = objlit.getJSDocInfo();
            String lendsName = jsdoc.getLendsName();
            Preconditions.checkNotNull((Object)lendsName);
            QualifiedName lendsQname = QualifiedName.fromQualifiedString(lendsName);
            if (this.currentScope.isNamespace(lendsQname)) {
                this.processLendsToNamespace(lendsQname, lendsName, objlit);
            } else {
                RawNominalType rawType = this.checkValidLendsToPrototypeAndGetClass(lendsQname, lendsName, objlit);
                if (rawType == null) {
                    return;
                }
                for (Node prop : objlit.children()) {
                    String pname = NodeUtil.getObjectLitKeyName(prop);
                    this.mayAddPropToPrototype(rawType, pname, prop, prop.getFirstChild());
                }
            }
        }

        void processLendsToNamespace(QualifiedName lendsQname, String lendsName, Node objlit) {
            RawNominalType rawType = this.currentScope.getNominalType(lendsQname);
            if (rawType != null && rawType.isInterface()) {
                GlobalTypeInfo.this.warnings.add(JSError.make(objlit, LENDS_ON_BAD_TYPE, lendsName));
                return;
            }
            Namespace borrowerNamespace = this.currentScope.getNamespace(lendsQname);
            for (Node prop : objlit.children()) {
                String pname = NodeUtil.getObjectLitKeyName(prop);
                JSType propDeclType = (JSType)GlobalTypeInfo.this.declaredObjLitProps.get(prop);
                if (propDeclType != null) {
                    borrowerNamespace.addProperty(pname, prop, propDeclType, false);
                    continue;
                }
                JSType t = this.simpleInferExprType(prop.getFirstChild());
                if (t == null) {
                    t = JSType.UNKNOWN;
                }
                borrowerNamespace.addProperty(pname, prop, t, false);
            }
        }

        RawNominalType checkValidLendsToPrototypeAndGetClass(QualifiedName lendsQname, String lendsName, Node objlit) {
            if (!lendsQname.getRightmostName().equals("prototype")) {
                GlobalTypeInfo.this.warnings.add(JSError.make(objlit, LENDS_ON_BAD_TYPE, lendsName));
                return null;
            }
            QualifiedName recv = lendsQname.getAllButRightmost();
            RawNominalType rawType = this.currentScope.getNominalType(recv);
            if (rawType == null || rawType.isInterface()) {
                GlobalTypeInfo.this.warnings.add(JSError.make(objlit, LENDS_ON_BAD_TYPE, lendsName));
            }
            return rawType;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getType()) {
                case 105: {
                    Node grandparent = parent.getParent();
                    if (grandparent != null && GlobalTypeInfo.isPrototypePropertyDeclaration(grandparent)) break;
                    RawNominalType ownerType = this.maybeGetOwnerType(n, parent);
                    this.visitFunctionLate(n, ownerType);
                    break;
                }
                case 38: {
                    String name = n.getString();
                    if (name == null || "undefined".equals(name) || parent.isFunction()) {
                        return;
                    }
                    if (parent.isVar() || parent.isCatch()) {
                        this.visitVar(n, parent);
                        break;
                    }
                    if (this.currentScope.isOuterVarEarly(name)) {
                        this.currentScope.addOuterVar(name);
                        break;
                    }
                    if (this.currentScope.getTypedef(name) != null || name.equals(this.currentScope.getName()) || this.currentScope.isDefinedLocally(name, false)) break;
                    break;
                }
                case 33: {
                    if (!parent.isExprResult() || !n.isQualifiedName()) break;
                    this.visitPropertyDeclaration(n);
                    break;
                }
                case 86: {
                    Node lvalue = n.getFirstChild();
                    if (!lvalue.isGetProp() || !lvalue.isQualifiedName() || !parent.isExprResult()) break;
                    this.visitPropertyDeclaration(lvalue);
                    break;
                }
                case 155: {
                    GlobalTypeInfo.this.castTypes.put(n, GlobalTypeInfo.this.getDeclaredTypeOfNode(n.getJSDocInfo(), this.currentScope));
                    break;
                }
                case 64: {
                    this.visitObjectLit(n, parent);
                    break;
                }
                case 37: {
                    this.visitCall(n);
                }
            }
        }

        private void visitVar(Node nameNode, Node parent) {
            String name = nameNode.getString();
            if (this.currentScope.isNamespace(name) || NodeUtil.isTypedefDecl(nameNode) || NodeUtil.isEnumDecl(nameNode)) {
                if (!this.currentScope.isDefinedLocally(name, false)) {
                    this.currentScope.addLocal(name, JSType.UNKNOWN, false, nameNode.isFromExterns());
                }
                return;
            }
            Node initializer = nameNode.getFirstChild();
            if (initializer != null && initializer.isFunction()) {
                return;
            }
            if (this.currentScope.isDefinedLocally(name, false)) {
                return;
            }
            if (parent.isCatch()) {
                this.currentScope.addLocal(name, JSType.UNKNOWN, false, false);
            } else {
                boolean isConst = GlobalTypeInfo.this.isConst(nameNode);
                JSType declType = this.getVarTypeFromAnnotation(nameNode);
                if (declType == null) {
                    declType = this.mayInferFromRhsIfConst(nameNode);
                }
                this.currentScope.addLocal(name, declType, isConst, nameNode.isFromExterns());
            }
        }

        private void visitObjectLit(Node objLitNode, Node parent) {
            block5: {
                Node maybeLvalue;
                block4: {
                    JSDocInfo jsdoc = objLitNode.getJSDocInfo();
                    if (jsdoc != null && jsdoc.getLendsName() != null) {
                        this.lendsObjlits.add(objLitNode);
                    }
                    Node node = maybeLvalue = parent.isAssign() ? parent.getFirstChild() : parent;
                    if (!NodeUtil.isNamespaceDecl(maybeLvalue) || !this.currentScope.isNamespace(maybeLvalue)) break block4;
                    for (Node prop : objLitNode.children()) {
                        this.visitNamespacePropertyDeclaration(prop, maybeLvalue, prop.getString());
                    }
                    break block5;
                }
                if (NodeUtil.isEnumDecl(maybeLvalue) || NodeUtil.isPrototypeAssignment(maybeLvalue)) break block5;
                for (Node prop : objLitNode.children()) {
                    if (prop.getJSDocInfo() != null) {
                        GlobalTypeInfo.this.declaredObjLitProps.put(prop, GlobalTypeInfo.this.getDeclaredTypeOfNode(prop.getJSDocInfo(), this.currentScope));
                    }
                    if (!GlobalTypeInfo.isAnnotatedAsConst(prop)) continue;
                    GlobalTypeInfo.this.warnings.add(JSError.make(prop, MISPLACED_CONST_ANNOTATION, new String[0]));
                }
            }
        }

        private void visitCall(Node call) {
            String className = GlobalTypeInfo.this.convention.getSingletonGetterClassName(call);
            if (className == null) {
                return;
            }
            QualifiedName qname = QualifiedName.fromQualifiedString(className);
            RawNominalType rawType = this.currentScope.getNominalType(qname);
            if (rawType != null) {
                JSType instanceType = rawType.getInstanceAsJSType();
                FunctionType getInstanceFunType = new FunctionTypeBuilder().addRetType(instanceType).buildFunction();
                JSType getInstanceType = GlobalTypeInfo.this.commonTypes.fromFunctionType(getInstanceFunType);
                GlobalTypeInfo.this.convention.applySingletonGetterNew(rawType, getInstanceType, instanceType);
            }
        }

        private void visitPropertyDeclaration(Node getProp) {
            if (GlobalTypeInfo.isClassPropAccess(getProp, this.currentScope)) {
                if (GlobalTypeInfo.isAnnotatedAsConst(getProp) && this.currentScope.isPrototypeMethod()) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(getProp, MISPLACED_CONST_ANNOTATION, new String[0]));
                }
                this.visitClassPropertyDeclaration(getProp);
            } else if (GlobalTypeInfo.isPrototypeProperty(getProp)) {
                this.visitPrototypePropertyDeclaration(getProp);
            } else if (NodeUtil.isPrototypeAssignment(getProp)) {
                this.visitPrototypeAssignment(getProp);
            } else if (this.isStaticCtorProp(getProp, this.currentScope)) {
                this.visitConstructorPropertyDeclaration(getProp);
            } else if (this.currentScope.isNamespace(getProp.getFirstChild())) {
                this.visitNamespacePropertyDeclaration(getProp);
            } else {
                this.visitOtherPropertyDeclaration(getProp);
            }
        }

        private boolean isStaticCtorProp(Node getProp, NTIScope s) {
            Preconditions.checkArgument((boolean)getProp.isGetProp());
            if (!getProp.isQualifiedName()) {
                return false;
            }
            Node receiverObj = getProp.getFirstChild();
            if (!s.isLocalFunDef(receiverObj.getQualifiedName())) {
                return false;
            }
            return null != this.currentScope.getNominalType(QualifiedName.fromNode(receiverObj));
        }

        private NTIScope visitFunctionLate(Node fn, RawNominalType ownerType) {
            Preconditions.checkArgument((boolean)fn.isFunction());
            String internalName = GlobalTypeInfo.this.getFunInternalName(fn);
            NTIScope fnScope = this.currentScope.getScope(internalName);
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(fn);
            DeclaredFunctionType declFunType = this.computeFnDeclaredType(jsdoc, internalName, fn, ownerType, this.currentScope);
            fnScope.setDeclaredType(declFunType);
            return fnScope;
        }

        private void visitPrototypePropertyDeclaration(Node getProp) {
            Preconditions.checkArgument((boolean)getProp.isGetProp());
            Node parent = getProp.getParent();
            Node initializer = parent.isAssign() ? parent.getLastChild() : null;
            Node ctorNameNode = NodeUtil.getPrototypeClassName(getProp);
            QualifiedName ctorQname = QualifiedName.fromNode(ctorNameNode);
            RawNominalType rawType = this.currentScope.getNominalType(ctorQname);
            if (rawType == null) {
                if (initializer != null && initializer.isFunction()) {
                    this.visitFunctionLate(initializer, null);
                }
                return;
            }
            if (initializer != null && initializer.isFunction()) {
                parent.putBooleanProp(76, true);
            }
            if (!this.currentScope.isDefined(ctorNameNode)) {
                GlobalTypeInfo.this.warnings.add(JSError.make(getProp, CTOR_IN_DIFFERENT_SCOPE, new String[0]));
                if (initializer != null && initializer.isFunction()) {
                    this.visitFunctionLate(initializer, rawType);
                }
                return;
            }
            this.mayWarnAboutInterfacePropInit(rawType, initializer);
            this.mayAddPropToPrototype(rawType, getProp.getLastChild().getString(), getProp, initializer);
        }

        private void mayWarnAboutInterfacePropInit(RawNominalType rawType, Node initializer) {
            if (rawType.isInterface() && initializer != null) {
                String abstractMethodName = GlobalTypeInfo.this.convention.getAbstractMethodName();
                if (initializer.isFunction() && !NodeUtil.isEmptyFunctionExpression(initializer)) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(initializer, TypeCheck.INTERFACE_METHOD_NOT_EMPTY, new String[0]));
                } else if (!initializer.isFunction() && !initializer.matchesQualifiedName(abstractMethodName)) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(initializer, INVALID_INTERFACE_PROP_INITIALIZER, new String[0]));
                }
            }
        }

        private void visitPrototypeAssignment(Node getProp) {
            Preconditions.checkArgument((boolean)getProp.isGetProp());
            Node ctorNameNode = NodeUtil.getPrototypeClassName(getProp);
            QualifiedName ctorQname = QualifiedName.fromNode(ctorNameNode);
            RawNominalType rawType = this.currentScope.getNominalType(ctorQname);
            if (rawType == null) {
                return;
            }
            getProp.putBooleanProp(76, true);
            for (Node objLitChild : getProp.getParent().getLastChild().children()) {
                this.mayAddPropToPrototype(rawType, objLitChild.getString(), objLitChild, objLitChild.getLastChild());
            }
        }

        private void visitConstructorPropertyDeclaration(Node getProp) {
            Preconditions.checkArgument((boolean)getProp.isGetProp());
            if (this.isNamedType(getProp)) {
                return;
            }
            String ctorName = getProp.getFirstChild().getQualifiedName();
            QualifiedName ctorQname = QualifiedName.fromNode(getProp.getFirstChild());
            Preconditions.checkState((boolean)this.currentScope.isLocalFunDef(ctorName));
            RawNominalType classType = this.currentScope.getNominalType(ctorQname);
            String pname = getProp.getLastChild().getString();
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(getProp);
            JSType propDeclType = GlobalTypeInfo.this.getDeclaredTypeOfNode(jsdoc, this.currentScope);
            boolean isConst = GlobalTypeInfo.this.isConst(getProp);
            if (propDeclType != null || isConst) {
                JSType previousPropType = classType.getCtorPropDeclaredType(pname);
                if (classType.hasCtorProp(pname) && previousPropType != null && !this.suppressDupPropWarning(jsdoc, propDeclType, previousPropType)) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(getProp, REDECLARED_PROPERTY, pname, classType.toString()));
                    return;
                }
                if (propDeclType == null) {
                    propDeclType = this.mayInferFromRhsIfConst(getProp);
                }
                classType.addCtorProperty(pname, getProp, propDeclType, isConst);
                getProp.putBooleanProp(76, true);
                if (isConst) {
                    getProp.putBooleanProp(77, true);
                }
            } else {
                classType.addUndeclaredCtorProperty(pname, getProp);
            }
        }

        private void visitNamespacePropertyDeclaration(Node getProp) {
            Preconditions.checkArgument((boolean)getProp.isGetProp());
            if (this.isNamedType(getProp)) {
                return;
            }
            Node recv = getProp.getFirstChild();
            String pname = getProp.getLastChild().getString();
            this.visitNamespacePropertyDeclaration(getProp, recv, pname);
        }

        private void visitNamespacePropertyDeclaration(Node declNode, Node recv, String pname) {
            Preconditions.checkArgument((declNode.isGetProp() || declNode.isStringKey() ? 1 : 0) != 0);
            Preconditions.checkArgument((boolean)this.currentScope.isNamespace(recv));
            EnumType et = this.currentScope.getEnum(QualifiedName.fromNode(recv));
            if (et != null && et.enumLiteralHasKey(pname)) {
                return;
            }
            Namespace ns = this.currentScope.getNamespace(QualifiedName.fromNode(recv));
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(declNode);
            JSType propDeclType = GlobalTypeInfo.this.getDeclaredTypeOfNode(jsdoc, this.currentScope);
            boolean isConst = GlobalTypeInfo.this.isConst(declNode);
            if (propDeclType != null || isConst) {
                JSType previousPropType = ns.getPropDeclaredType(pname);
                if (ns.hasProp(pname) && previousPropType != null && !this.suppressDupPropWarning(jsdoc, propDeclType, previousPropType)) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(declNode, REDECLARED_PROPERTY, pname, ns.toString()));
                    return;
                }
                if (propDeclType == null) {
                    propDeclType = this.mayInferFromRhsIfConst(declNode);
                }
                ns.addProperty(pname, declNode, propDeclType, isConst);
                declNode.putBooleanProp(76, true);
                if (declNode.isGetProp() && isConst) {
                    declNode.putBooleanProp(77, true);
                }
            } else {
                JSType t;
                Node initializer = NodeUtil.getRValueOfLValue(declNode);
                JSType jSType = t = initializer == null ? null : this.simpleInferExprType(initializer);
                if (t == null) {
                    t = JSType.UNKNOWN;
                }
                ns.addUndeclaredProperty(pname, declNode, t, false);
            }
        }

        private void visitClassPropertyDeclaration(Node getProp) {
            Preconditions.checkArgument((boolean)getProp.isGetProp());
            NominalType thisType = this.currentScope.getDeclaredFunctionType().getThisType();
            if (thisType == null) {
                return;
            }
            RawNominalType rawNominalType = thisType.getRawNominalType();
            String pname = getProp.getLastChild().getString();
            JSType declType = GlobalTypeInfo.this.getDeclaredTypeOfNode(NodeUtil.getBestJSDocInfo(getProp), this.currentScope);
            boolean isConst = GlobalTypeInfo.this.isConst(getProp);
            if (declType != null || isConst) {
                this.mayWarnAboutExistingProp(rawNominalType, pname, getProp, declType);
                if (declType == null) {
                    declType = this.mayInferFromRhsIfConst(getProp);
                }
                if (this.mayAddPropToType(getProp, rawNominalType)) {
                    rawNominalType.addClassProperty(pname, getProp, declType, isConst);
                }
                if (isConst) {
                    getProp.putBooleanProp(77, true);
                }
            } else if (this.mayAddPropToType(getProp, rawNominalType)) {
                rawNominalType.addUndeclaredClassProperty(pname, getProp);
            }
            GlobalTypeInfo.this.propertyDefs.put((Object)rawNominalType, (Object)pname, (Object)new PropertyDef(getProp, null, null));
        }

        private void visitOtherPropertyDeclaration(Node getProp) {
            QualifiedName recvQname;
            Declaration d;
            Preconditions.checkArgument((boolean)getProp.isGetProp());
            Preconditions.checkArgument((boolean)getProp.isQualifiedName());
            if (GlobalTypeInfo.isAnnotatedAsConst(getProp)) {
                GlobalTypeInfo.this.warnings.add(JSError.make(getProp, MISPLACED_CONST_ANNOTATION, new String[0]));
            }
            if ((d = this.currentScope.getDeclaration(recvQname = QualifiedName.fromNode(getProp.getFirstChild()), false)) == null) {
                return;
            }
            if (d.getTypedef() != null) {
                GlobalTypeInfo.this.warnings.add(JSError.make(getProp, CANNOT_ADD_PROPERTIES_TO_TYPEDEF, new String[0]));
                getProp.getParent().putBooleanProp(76, true);
                return;
            }
            JSType recvType = d.getTypeOfSimpleDecl();
            if (recvType == null) {
                return;
            }
            NominalType nt = recvType.getNominalTypeIfSingletonObj();
            if (nt == null || nt.equals(GlobalTypeInfo.this.commonTypes.getObjectType())) {
                return;
            }
            RawNominalType rawType = nt.getRawNominalType();
            String pname = getProp.getLastChild().getString();
            JSType declType = GlobalTypeInfo.this.getDeclaredTypeOfNode(NodeUtil.getBestJSDocInfo(getProp), this.currentScope);
            if (declType != null) {
                if (this.mayWarnAboutExistingProp(rawType, pname, getProp, declType = declType.substituteGenericsWithUnknown())) {
                    return;
                }
                rawType.addPropertyWhichMayNotBeOnAllInstances(pname, declType);
            } else if (!rawType.mayHaveProp(pname)) {
                rawType.addPropertyWhichMayNotBeOnAllInstances(pname, null);
            }
        }

        boolean mayWarnAboutNoInit(Node constExpr) {
            if (constExpr.isFromExterns()) {
                return false;
            }
            Node initializer = NodeUtil.getRValueOfLValue(constExpr);
            if (initializer == null) {
                GlobalTypeInfo.this.warnings.add(JSError.make(constExpr, CONST_WITHOUT_INITIALIZER, new String[0]));
                return true;
            }
            return false;
        }

        private JSType mayInferFromRhsIfConst(Node lvalueNode) {
            JSDocInfo info = NodeUtil.getBestJSDocInfo(lvalueNode);
            if (info != null && info.containsFunctionDeclaration()) {
                return null;
            }
            if (GlobalTypeInfo.this.isConst(lvalueNode) && !this.mayWarnAboutNoInit(lvalueNode)) {
                return this.inferConstTypeFromRhs(lvalueNode);
            }
            return null;
        }

        private JSType inferConstTypeFromRhs(Node constExpr) {
            if (constExpr.isFromExterns()) {
                GlobalTypeInfo.this.warnings.add(JSError.make(constExpr, COULD_NOT_INFER_CONST_TYPE, new String[0]));
                return null;
            }
            Node rhs = NodeUtil.getRValueOfLValue(constExpr);
            JSType rhsType = this.simpleInferExprType(rhs);
            if (rhsType == null || rhsType.isUnknown()) {
                GlobalTypeInfo.this.warnings.add(JSError.make(constExpr, COULD_NOT_INFER_CONST_TYPE, new String[0]));
                return null;
            }
            return rhsType;
        }

        private FunctionType simpleInferFunctionType(Node n) {
            DeclaredFunctionType funType;
            Declaration decl;
            if (n.isQualifiedName() && (decl = this.currentScope.getDeclaration(QualifiedName.fromNode(n), false)) != null && decl.getFunctionScope() != null && (funType = decl.getFunctionScope().getDeclaredFunctionType()) != null) {
                return funType.toFunctionType();
            }
            return null;
        }

        private JSType simpleInferExprType(Node n) {
            switch (n.getType()) {
                case 47: {
                    return GlobalTypeInfo.this.commonTypes.getRegexpType();
                }
                case 63: {
                    if (!n.hasChildren()) {
                        return null;
                    }
                    Node child = n.getFirstChild();
                    JSType arrayType = this.simpleInferExprType(child);
                    if (arrayType == null) {
                        return null;
                    }
                    while (null != (child = child.getNext())) {
                        if (arrayType.equals(this.simpleInferExprType(child))) continue;
                        return null;
                    }
                    return GlobalTypeInfo.this.commonTypes.getArrayInstance(arrayType);
                }
                case 44: {
                    return JSType.TRUE_TYPE;
                }
                case 43: {
                    return JSType.FALSE_TYPE;
                }
                case 42: {
                    return this.currentScope.getDeclaredTypeOf("this");
                }
                case 38: {
                    return this.simpleInferDeclaration(this.currentScope.getDeclaration(n.getString(), false));
                }
                case 64: {
                    JSType objLitType = JSType.TOP_OBJECT;
                    for (Node prop : n.children()) {
                        JSType propType = this.simpleInferExprType(prop.getFirstChild());
                        if (propType == null) {
                            return null;
                        }
                        objLitType = objLitType.withProperty(new QualifiedName(NodeUtil.getObjectLitKeyName(prop)), propType);
                    }
                    return objLitType;
                }
                case 33: {
                    return this.simpleInferGetpropType(n);
                }
                case 85: 
                case 86: {
                    return this.simpleInferExprType(n.getLastChild());
                }
                case 30: 
                case 37: {
                    Node callee = n.getFirstChild();
                    if (callee.matchesQualifiedName("goog.getMsg")) {
                        return JSType.STRING;
                    }
                    FunctionType funType = this.simpleInferFunctionType(callee);
                    if (funType == null) {
                        return null;
                    }
                    if (funType.isGeneric()) {
                        ImmutableList.Builder argTypes = ImmutableList.builder();
                        for (Node argNode = n.getFirstChild().getNext(); argNode != null; argNode = argNode.getNext()) {
                            JSType t = this.simpleInferExprType(argNode);
                            if (t == null) {
                                return null;
                            }
                            argTypes.add((Object)t);
                        }
                        if ((funType = funType.instantiateGenericsFromArgumentTypes((List<JSType>)argTypes.build())) == null) {
                            return null;
                        }
                    }
                    JSType retType = n.isNew() ? funType.getThisType() : funType.getReturnType();
                    return retType;
                }
            }
            switch (NodeUtil.getKnownValueType(n)) {
                case NULL: {
                    return JSType.NULL;
                }
                case VOID: {
                    return JSType.UNDEFINED;
                }
                case NUMBER: {
                    return JSType.NUMBER;
                }
                case STRING: {
                    return JSType.STRING;
                }
                case BOOLEAN: {
                    return JSType.BOOLEAN;
                }
            }
            return null;
        }

        private JSType simpleInferGetpropType(Node n) {
            Preconditions.checkArgument((boolean)n.isGetProp());
            Node recv = n.getFirstChild();
            if (!recv.isQualifiedName()) {
                return null;
            }
            QualifiedName recvQname = QualifiedName.fromNode(recv);
            String pname = n.getLastChild().getString();
            Declaration decl = this.currentScope.getDeclaration(recvQname, false);
            if (decl == null) {
                return null;
            }
            EnumType et = decl.getEnum();
            if (et != null && et.enumLiteralHasKey(pname)) {
                return et.getEnumeratedType();
            }
            QualifiedName propQname = new QualifiedName(pname);
            Namespace ns = decl.getNamespace();
            if (ns != null) {
                return this.simpleInferDeclaration(ns.getDeclaration(propQname));
            }
            JSType recvType = this.simpleInferExprType(recv);
            if (recvType != null && recvType.mayHaveProp(propQname)) {
                return recvType.getProp(propQname);
            }
            return null;
        }

        private JSType simpleInferDeclaration(Declaration decl) {
            if (decl == null) {
                return null;
            }
            if (decl.getNamespace() != null) {
                return null;
            }
            if (decl.getTypeOfSimpleDecl() != null) {
                return decl.getTypeOfSimpleDecl();
            }
            NTIScope funScope = (NTIScope)decl.getFunctionScope();
            if (funScope != null) {
                return GlobalTypeInfo.this.commonTypes.fromFunctionType(funScope.getDeclaredFunctionType().toFunctionType());
            }
            return null;
        }

        private boolean mayAddPropToType(Node getProp, RawNominalType rawType) {
            if (!rawType.isStruct()) {
                return true;
            }
            Node parent = getProp.getParent();
            return (parent.isAssign() && getProp == parent.getFirstChild() || parent.isExprResult()) && this.currentScope.isConstructor();
        }

        private boolean mayWarnAboutExistingProp(RawNominalType classType, String pname, Node propCreationNode, JSType typeInJsdoc) {
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(propCreationNode);
            JSType previousPropType = classType.getInstancePropDeclaredType(pname);
            if (classType.mayHaveOwnProp(pname) && previousPropType != null && !this.suppressDupPropWarning(jsdoc, typeInJsdoc, previousPropType)) {
                GlobalTypeInfo.this.warnings.add(JSError.make(propCreationNode, REDECLARED_PROPERTY, pname, classType.toString()));
                return true;
            }
            return false;
        }

        private boolean suppressDupPropWarning(JSDocInfo propCreationJsdoc, JSType typeInJsdoc, JSType previousType) {
            if (propCreationJsdoc == null || !propCreationJsdoc.getSuppressions().contains("duplicate")) {
                return false;
            }
            return typeInJsdoc != null && previousType != null && typeInJsdoc.equals(previousType);
        }

        private DeclaredFunctionType computeFnDeclaredType(JSDocInfo fnDoc, String functionName, Node declNode, RawNominalType ownerType, NTIScope parentScope) {
            Node qnameNode;
            DeclaredFunctionType t;
            Preconditions.checkArgument((declNode.isFunction() || declNode.isGetProp() ? 1 : 0) != 0);
            if (fnDoc == null && !NodeUtil.functionHasInlineJsdocs(declNode) && (t = this.getDeclaredFunctionTypeFromContext(functionName, declNode, parentScope)) != null) {
                return t;
            }
            RawNominalType ctorType = declNode.isFunction() ? (RawNominalType)GlobalTypeInfo.this.nominaltypesByNode.get(declNode) : null;
            JSTypeCreatorFromJSDoc.FunctionAndSlotType result = GlobalTypeInfo.this.typeParser.getFunctionType(fnDoc, functionName, declNode, ctorType, ownerType, parentScope);
            Node node = qnameNode = declNode.isGetProp() ? declNode : NodeUtil.getFunctionNameNode(declNode);
            if (result.slotType != null && qnameNode != null && qnameNode.isName()) {
                parentScope.addSimpleType(qnameNode, result.slotType);
            }
            if (ctorType != null) {
                ctorType.setCtorFunction(result.functionType.toFunctionType(), GlobalTypeInfo.this.commonTypes);
            }
            if (declNode.isFunction()) {
                this.maybeWarnFunctionDeclaration(declNode, result.functionType);
            }
            return result.functionType;
        }

        private void maybeWarnFunctionDeclaration(Node funNode, DeclaredFunctionType funType) {
            JSType returnType;
            if (funNode.getParent().isSetterDef() && (returnType = funType.getReturnType()) != null && !returnType.isUnknown() && !returnType.isUndefined()) {
                GlobalTypeInfo.this.warnings.add(JSError.make(funNode, SETTER_WITH_RETURN, new String[0]));
            }
            int declaredArity = funType.getOptionalArity();
            int parameterCount = funNode.getFirstChild().getNext().getChildCount();
            if (!funType.hasRestFormals() && parameterCount != declaredArity) {
                GlobalTypeInfo.this.warnings.add(JSError.make(funNode, WRONG_PARAMETER_COUNT, String.valueOf(declaredArity), String.valueOf(parameterCount)));
            }
        }

        private DeclaredFunctionType computeFnDeclaredTypeFromCallee(Node declNode, JSType declaredTypeAsJSType) {
            Preconditions.checkArgument((boolean)declNode.isFunction());
            Preconditions.checkArgument((boolean)declNode.getParent().isCall());
            Preconditions.checkNotNull((Object)declaredTypeAsJSType);
            FunctionType funType = declaredTypeAsJSType.getFunType();
            if (funType == null || funType.isConstructor() || funType.isInterfaceDefinition()) {
                return null;
            }
            DeclaredFunctionType declType = funType.toDeclaredFunctionType();
            if (declType == null) {
                return null;
            }
            int numFormals = declNode.getChildAtIndex(1).getChildCount();
            int reqArity = declType.getRequiredArity();
            int optArity = declType.getOptionalArity();
            boolean hasRestFormals = declType.hasRestFormals();
            if (reqArity == optArity && !hasRestFormals) {
                return numFormals == reqArity ? declType : null;
            }
            if (numFormals == optArity && !hasRestFormals || numFormals == optArity + 1 && hasRestFormals) {
                return declType;
            }
            return null;
        }

        private DeclaredFunctionType getDeclaredFunctionTypeFromContext(String functionName, Node declNode, NTIScope parentScope) {
            DeclaredFunctionType t;
            int index;
            JSType declTypeFromCallee;
            DeclaredFunctionType calleeDeclType;
            Node maybeBind;
            Node parent = declNode.getParent();
            Node node = maybeBind = parent.isCall() ? parent.getFirstChild() : parent;
            if (NodeUtil.isFunctionBind(maybeBind) && !NodeUtil.isGoogPartial(maybeBind)) {
                Node call = maybeBind.getParent();
                CodingConvention.Bind bindComponents = GlobalTypeInfo.this.convention.describeFunctionBind(call, true, false);
                JSType recvType = this.simpleInferExprType(bindComponents.thisValue);
                if (recvType == null) {
                    return null;
                }
                DeclaredFunctionType allButRecvType = ((GlobalTypeInfo)GlobalTypeInfo.this).typeParser.getFunctionType(null, (String)functionName, (Node)declNode, null, null, (DeclaredTypeRegistry)parentScope).functionType;
                return allButRecvType.withReceiverType(recvType.getNominalTypeIfSingletonObj());
            }
            if (parent.isCall() && declNode != parent.getFirstChild() && (calleeDeclType = GlobalTypeInfo.this.getDeclaredFunctionTypeOfCalleeIfAny(parent.getFirstChild(), parentScope)) != null && !calleeDeclType.isGeneric() && (declTypeFromCallee = calleeDeclType.getFormalType(index = parent.getIndexOfChild(declNode) - 1)) != null && (t = this.computeFnDeclaredTypeFromCallee(declNode, declTypeFromCallee)) != null) {
                return t;
            }
            return null;
        }

        private JSType getVarTypeFromAnnotation(Node nameNode) {
            Preconditions.checkArgument((boolean)nameNode.getParent().isVar());
            Node varNode = nameNode.getParent();
            JSType varType = GlobalTypeInfo.this.getDeclaredTypeOfNode(varNode.getJSDocInfo(), this.currentScope);
            if (varNode.getChildCount() > 1 && varType != null) {
                GlobalTypeInfo.this.warnings.add(JSError.make(varNode, TypeCheck.MULTIPLE_VAR_DEF, new String[0]));
            }
            String varName = nameNode.getString();
            JSType nameNodeType = GlobalTypeInfo.this.getDeclaredTypeOfNode(nameNode.getJSDocInfo(), this.currentScope);
            if (nameNodeType != null) {
                if (varType != null) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(nameNode, DUPLICATE_JSDOC, varName));
                }
                return nameNodeType;
            }
            return varType;
        }

        private void mayAddPropToPrototype(RawNominalType rawType, String pname, Node defSite, Node initializer) {
            NTIScope methodScope = null;
            DeclaredFunctionType methodType = null;
            JSType propDeclType = null;
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(defSite);
            if (initializer != null && initializer.isFunction()) {
                methodScope = this.visitFunctionLate(initializer, rawType);
                methodType = methodScope.getDeclaredFunctionType();
            } else if (jsdoc != null && jsdoc.containsFunctionDeclaration()) {
                methodType = this.computeFnDeclaredType(jsdoc, pname, defSite, rawType, this.currentScope);
            }
            if (jsdoc != null && jsdoc.hasType()) {
                propDeclType = GlobalTypeInfo.this.typeParser.getDeclaredTypeOfNode(jsdoc, rawType, this.currentScope);
            } else if (methodType != null) {
                propDeclType = GlobalTypeInfo.this.commonTypes.fromFunctionType(methodType.toFunctionType());
            }
            GlobalTypeInfo.this.propertyDefs.put((Object)rawType, (Object)pname, (Object)new PropertyDef(defSite, methodType, methodScope));
            boolean isConst = GlobalTypeInfo.this.isConst(defSite);
            if (propDeclType != null || isConst) {
                if (this.mayWarnAboutExistingProp(rawType, pname, defSite, propDeclType)) {
                    return;
                }
                if (propDeclType == null) {
                    propDeclType = this.mayInferFromRhsIfConst(defSite);
                }
                rawType.addProtoProperty(pname, defSite, propDeclType, isConst);
                if (defSite.isGetProp()) {
                    defSite.putBooleanProp(76, true);
                    if (isConst) {
                        defSite.putBooleanProp(77, true);
                    }
                }
            } else {
                rawType.addUndeclaredProtoProperty(pname, defSite);
            }
        }

        private RawNominalType maybeGetOwnerType(Node funNode, Node parent) {
            QualifiedName qname;
            Node recv;
            Preconditions.checkArgument((boolean)funNode.isFunction());
            if (parent.isAssign() && parent.getFirstChild().isGetElem() && (recv = parent.getFirstChild().getFirstChild()).isGetProp() && recv.getLastChild().getString().equals("prototype") && (qname = QualifiedName.fromNode(recv.getFirstChild())) != null) {
                return this.currentScope.getNominalType(qname);
            }
            return null;
        }

        private boolean isNamedType(Node getProp) {
            return this.currentScope.isNamespace(getProp) || NodeUtil.isTypedefDecl(getProp);
        }
    }

    private class CollectNamedTypes
    extends NodeTraversal.AbstractShallowCallback {
        private final NTIScope currentScope;

        CollectNamedTypes(NTIScope s) {
            this.currentScope = s;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            block0 : switch (n.getType()) {
                case 105: {
                    this.visitFunctionEarly(n);
                    break;
                }
                case 118: {
                    Node nameNode = n.getFirstChild();
                    if (NodeUtil.isNamespaceDecl(nameNode)) {
                        this.visitObjlitNamespace(nameNode);
                        break;
                    }
                    if (NodeUtil.isTypedefDecl(nameNode)) {
                        this.visitTypedef(nameNode);
                        break;
                    }
                    if (NodeUtil.isEnumDecl(nameNode)) {
                        this.visitEnum(nameNode);
                        break;
                    }
                    if (!this.isAliasedNamespaceDefinition(nameNode)) break;
                    this.visitAliasedNamespace(nameNode);
                    break;
                }
                case 130: {
                    Node expr = n.getFirstChild();
                    switch (expr.getType()) {
                        case 86: {
                            if (!expr.getFirstChild().isGetProp()) {
                                return;
                            }
                            expr = expr.getFirstChild();
                        }
                        case 33: {
                            if (GlobalTypeInfo.isPrototypeProperty(expr) || NodeUtil.referencesThis(expr) || !expr.isQualifiedName()) {
                                return;
                            }
                            this.processQualifiedDefinition(expr);
                            break block0;
                        }
                        case 37: {
                            List<String> decls = GlobalTypeInfo.this.convention.identifyTypeDeclarationCall(expr);
                            if (decls == null || decls.isEmpty()) {
                                return;
                            }
                            this.currentScope.addUnknownTypeNames(decls);
                            break block0;
                        }
                    }
                    break;
                }
            }
        }

        private void processQualifiedDefinition(Node qnameNode) {
            Preconditions.checkArgument((boolean)qnameNode.isGetProp());
            Preconditions.checkArgument((boolean)qnameNode.isQualifiedName());
            Node recv = qnameNode.getFirstChild();
            if (!this.currentScope.isNamespace(recv) && !this.mayCreateFunctionNamespace(recv)) {
                return;
            }
            if (NodeUtil.isNamespaceDecl(qnameNode)) {
                this.visitObjlitNamespace(qnameNode);
            } else if (NodeUtil.isTypedefDecl(qnameNode)) {
                this.visitTypedef(qnameNode);
            } else if (NodeUtil.isEnumDecl(qnameNode)) {
                this.visitEnum(qnameNode);
            } else if (this.isAliasedNamespaceDefinition(qnameNode)) {
                this.visitAliasedNamespace(qnameNode);
            } else if (this.isQualifiedFunctionDefinition(qnameNode)) {
                this.maybeAddFunctionScopeToNamespace(qnameNode);
            }
        }

        private boolean isAliasedNamespaceDefinition(Node qnameNode) {
            Node rhs = NodeUtil.getRValueOfLValue(qnameNode);
            if (rhs == null || !rhs.isQualifiedName()) {
                return false;
            }
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(qnameNode);
            return jsdoc != null && (jsdoc.isConstructorOrInterface() || jsdoc.hasConstAnnotation());
        }

        private boolean isQualifiedFunctionDefinition(Node qnameNode) {
            Preconditions.checkArgument((boolean)qnameNode.isGetProp());
            Preconditions.checkArgument((boolean)qnameNode.isQualifiedName());
            Node parent = qnameNode.getParent();
            return parent.isAssign() && parent.getParent().isExprResult() && parent.getLastChild().isFunction();
        }

        private boolean mayCreateFunctionNamespace(Node qnameNode) {
            if (!qnameNode.isQualifiedName()) {
                return false;
            }
            QualifiedName qname = QualifiedName.fromNode(qnameNode);
            Preconditions.checkState((!this.currentScope.isNamespace(qname) ? 1 : 0) != 0);
            if (!this.currentScope.isKnownFunction(qname)) {
                return false;
            }
            if (qnameNode.isGetProp()) {
                this.markAssignNodeAsAnalyzed(qnameNode.getParent().getParent());
            }
            NTIScope s = qnameNode.isName() ? this.currentScope.getScope(qnameNode.getString()).getParent() : this.currentScope;
            s.addNamespaceLit(qnameNode);
            return true;
        }

        private void visitObjlitNamespace(Node qnameNode) {
            if (this.currentScope.isDefined(qnameNode)) {
                return;
            }
            if (qnameNode.isGetProp()) {
                this.markAssignNodeAsAnalyzed(qnameNode.getParent());
            }
            this.currentScope.addNamespaceLit(qnameNode);
        }

        private void markAssignNodeAsAnalyzed(Node maybeAssign) {
            if (maybeAssign.isAssign()) {
                maybeAssign.putBooleanProp(76, true);
            } else {
                Preconditions.checkState((boolean)maybeAssign.isExprResult());
            }
        }

        private void visitTypedef(Node qnameNode) {
            Preconditions.checkState((boolean)qnameNode.isQualifiedName());
            qnameNode.putBooleanProp(76, true);
            if (NodeUtil.getRValueOfLValue(qnameNode) != null) {
                GlobalTypeInfo.this.warnings.add(JSError.make(qnameNode, CANNOT_INIT_TYPEDEF, new String[0]));
            }
            if (this.currentScope.isDefined(qnameNode)) {
                return;
            }
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(qnameNode);
            Typedef td = Typedef.make(jsdoc.getTypedefType());
            this.currentScope.addTypedef(qnameNode, td);
        }

        private void visitEnum(Node qnameNode) {
            EnumType et;
            Preconditions.checkState((boolean)qnameNode.isQualifiedName());
            qnameNode.putBooleanProp(76, true);
            if (this.currentScope.isDefined(qnameNode)) {
                return;
            }
            Node init = NodeUtil.getRValueOfLValue(qnameNode);
            if (init != null && init.isQualifiedName() && (et = this.currentScope.getEnum(QualifiedName.fromNode(init))) != null) {
                this.currentScope.addEnum(qnameNode, et);
                return;
            }
            if (init == null || !init.isObjectLit() || init.getFirstChild() == null) {
                GlobalTypeInfo.this.warnings.add(JSError.make(qnameNode, MALFORMED_ENUM, new String[0]));
                return;
            }
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(qnameNode);
            LinkedHashSet<String> propNames = new LinkedHashSet<String>();
            for (Node prop : init.children()) {
                String pname = NodeUtil.getObjectLitKeyName(prop);
                if (propNames.contains(pname)) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(qnameNode, DUPLICATE_PROP_IN_ENUM, pname));
                }
                if (!GlobalTypeInfo.this.convention.isValidEnumKey(pname)) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(prop, TypeCheck.ENUM_NOT_CONSTANT, pname));
                }
                propNames.add(pname);
            }
            this.currentScope.addEnum(qnameNode, EnumType.make(qnameNode.getQualifiedName(), jsdoc.getEnumParameterType(), (Collection<String>)ImmutableSet.copyOf(propNames)));
        }

        private void visitFunctionEarly(Node fn) {
            JSDocInfo fnDoc = NodeUtil.getBestJSDocInfo(fn);
            Node nameNode = NodeUtil.getFunctionNameNode(fn);
            String internalName = this.createFunctionInternalName(fn, nameNode);
            boolean isRedeclaration = nameNode == null || !nameNode.isQualifiedName() ? false : (nameNode.isName() ? this.currentScope.isDefinedLocally(nameNode.getString(), false) : this.currentScope.isDefined(nameNode));
            NTIScope fnScope = new NTIScope(fn, this.currentScope, this.collectFormals(fn, fnDoc), null);
            if (!fn.isFromExterns()) {
                GlobalTypeInfo.this.scopes.add(fnScope);
            }
            this.currentScope.addLocalFunDef(internalName, fnScope);
            this.maybeRecordNominalType(fn, nameNode, fnDoc, isRedeclaration);
        }

        private String createFunctionInternalName(Node fn, Node nameNode) {
            String internalName = null;
            if (nameNode == null || !nameNode.isName() || nameNode.getParent().isAssign()) {
                internalName = GlobalTypeInfo.ANON_FUN_PREFIX + GlobalTypeInfo.this.freshId;
                GlobalTypeInfo.this.anonFunNames.put(fn, internalName);
                GlobalTypeInfo.this.freshId++;
            } else if (this.currentScope.isDefinedLocally(nameNode.getString(), false)) {
                String fnName = nameNode.getString();
                Preconditions.checkState((!fnName.contains(".") ? 1 : 0) != 0);
                internalName = GlobalTypeInfo.ANON_FUN_PREFIX + GlobalTypeInfo.this.freshId;
                GlobalTypeInfo.this.anonFunNames.put(fn, internalName);
                GlobalTypeInfo.this.freshId++;
            } else {
                internalName = nameNode.getString();
            }
            return internalName;
        }

        private ArrayList<String> collectFormals(Node fn, JSDocInfo fnDoc) {
            Preconditions.checkArgument((boolean)fn.isFunction());
            ArrayList<String> formals = new ArrayList<String>();
            ArrayList<String> tmpRestFormals = new ArrayList<String>();
            for (Node param = NodeUtil.getFunctionParameters(fn).getFirstChild(); param != null; param = param.getNext()) {
                if (JSTypeCreatorFromJSDoc.isRestArg(fnDoc, param.getString()) && param.getNext() == null) {
                    tmpRestFormals.add(param.getString());
                    continue;
                }
                formals.add(param.getString());
            }
            if (fnDoc != null) {
                for (String formalInJsdoc : fnDoc.getParameterNames()) {
                    if (formals.contains(formalInJsdoc) || tmpRestFormals.contains(formalInJsdoc)) continue;
                    String functionName = NodeUtil.getNearestFunctionName(fn);
                    GlobalTypeInfo.this.warnings.add(JSError.make(fn, INEXISTENT_PARAM, formalInJsdoc, functionName));
                }
            }
            return formals;
        }

        private void maybeRecordNominalType(Node fn, Node nameNode, JSDocInfo fnDoc, boolean isRedeclaration) {
            if (fnDoc != null && fnDoc.isConstructorOrInterface()) {
                QualifiedName qname = QualifiedName.fromNode(nameNode);
                if (qname == null) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(fn, ANONYMOUS_NOMINAL_TYPE, new String[0]));
                    return;
                }
                ImmutableList<String> typeParameters = fnDoc.getTemplateTypeNames();
                RawNominalType rawNominalType = fnDoc.isInterface() ? RawNominalType.makeInterface(fn, qname, typeParameters) : (fnDoc.makesStructs() ? RawNominalType.makeStructClass(fn, qname, typeParameters) : (fnDoc.makesDicts() ? RawNominalType.makeDictClass(fn, qname, typeParameters) : RawNominalType.makeUnrestrictedClass(fn, qname, typeParameters)));
                GlobalTypeInfo.this.nominaltypesByNode.put(fn, rawNominalType);
                if (isRedeclaration) {
                    return;
                }
                if (nameNode.isName() || this.currentScope.isNamespace(nameNode.getFirstChild()) || this.mayCreateFunctionNamespace(nameNode.getFirstChild())) {
                    if (nameNode.isGetProp()) {
                        fn.getParent().getFirstChild().putBooleanProp(76, true);
                    } else if (this.currentScope.isTopLevel()) {
                        this.maybeRecordBuiltinType(nameNode.getString(), rawNominalType);
                    }
                    this.currentScope.addNominalType(nameNode, rawNominalType);
                }
            } else if (fnDoc != null) {
                if (fnDoc.makesStructs()) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(fn, STRUCTDICT_WITHOUT_CTOR, "@struct"));
                } else if (fnDoc.makesDicts()) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(fn, STRUCTDICT_WITHOUT_CTOR, "@dict"));
                }
            }
        }

        private void maybeRecordBuiltinType(String name, RawNominalType rawNominalType) {
            switch (name) {
                case "Arguments": {
                    GlobalTypeInfo.this.commonTypes.setArgumentsType(rawNominalType);
                    break;
                }
                case "Function": {
                    GlobalTypeInfo.this.commonTypes.setFunctionType(rawNominalType);
                    break;
                }
                case "Object": {
                    GlobalTypeInfo.this.commonTypes.setObjectType(rawNominalType);
                    break;
                }
                case "Number": {
                    GlobalTypeInfo.this.commonTypes.setNumberInstance(rawNominalType.getInstanceAsJSType());
                    break;
                }
                case "String": {
                    GlobalTypeInfo.this.commonTypes.setStringInstance(rawNominalType.getInstanceAsJSType());
                    break;
                }
                case "Boolean": {
                    GlobalTypeInfo.this.commonTypes.setBooleanInstance(rawNominalType.getInstanceAsJSType());
                    break;
                }
                case "RegExp": {
                    GlobalTypeInfo.this.commonTypes.setRegexpInstance(rawNominalType.getInstanceAsJSType());
                    break;
                }
                case "Array": {
                    GlobalTypeInfo.this.commonTypes.setArrayType(rawNominalType);
                }
            }
        }

        private void visitAliasedNamespace(Node lhs) {
            Namespace ns;
            Node rhs = NodeUtil.getRValueOfLValue(lhs);
            QualifiedName rhsQname = QualifiedName.fromNode(rhs);
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(lhs);
            if (jsdoc != null && jsdoc.isConstructorOrInterface()) {
                RawNominalType rawType = this.currentScope.getNominalType(rhsQname);
                if (jsdoc.isConstructor() && (rawType == null || rawType.isInterface())) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(rhs, EXPECTED_CONSTRUCTOR, rhsQname.toString()));
                    return;
                }
                if (jsdoc.isInterface() && (rawType == null || rawType.isClass())) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(rhs, EXPECTED_INTERFACE, rhsQname.toString()));
                    return;
                }
            }
            if ((ns = this.currentScope.getNamespace(rhsQname)) != null) {
                this.currentScope.addNamespace(lhs, ns);
            }
        }

        private void maybeAddFunctionScopeToNamespace(Node funQname) {
            Namespace ns = this.currentScope.getNamespace(QualifiedName.fromNode(funQname.getFirstChild()));
            String internalName = GlobalTypeInfo.this.getFunInternalName(funQname.getParent().getLastChild());
            NTIScope s = this.currentScope.getScope(internalName);
            QualifiedName pname = new QualifiedName(funQname.getLastChild().getString());
            if (!ns.isDefined(pname)) {
                ns.addScope(pname, s);
            }
        }
    }
}

