/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.EnumElementType;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.NamedType;
import com.google.javascript.rhino.jstype.NoType;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.ProxyObjectType;
import com.google.javascript.rhino.jstype.TemplateType;
import com.google.javascript.rhino.jstype.TemplatizedType;
import com.google.javascript.rhino.jstype.UnionType;
import com.google.javascript.rhino.jstype.Visitor;
import java.util.HashSet;
import java.util.Set;

class GatherExternProperties
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private final Set<String> externProperties = new HashSet<String>();
    private final AbstractCompiler compiler;
    private final ExtractRecordTypePropertyNames typeVisitor = new ExtractRecordTypePropertyNames();

    public GatherExternProperties(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseEs6(this.compiler, externs, this);
        this.compiler.setExternProperties((Set<String>)ImmutableSet.copyOf(this.externProperties));
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        JSType typedefType;
        JSDocInfo jsDoc;
        switch (n.getType()) {
            case 33: {
                Node dest = n.getFirstChild().getNext();
                if (!dest.isString()) break;
                this.externProperties.add(dest.getString());
                break;
            }
            case 64: {
                for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
                    this.externProperties.add(child.getString());
                }
                break;
            }
        }
        JSType type = n.getJSType();
        if (type != null) {
            this.typeVisitor.visitOnce(type);
        }
        if (n.isQualifiedName() && (jsDoc = NodeUtil.getBestJSDocInfo(n)) != null && jsDoc.hasTypedefType() && (typedefType = (JSType)this.compiler.getTypeIRegistry().getType(n.getQualifiedName())) != null) {
            this.typeVisitor.visitOnce(typedefType);
        }
    }

    private class ExtractRecordTypePropertyNames
    implements Visitor<Set<String>> {
        private final Set<JSType> seenTypes = Sets.newIdentityHashSet();

        private ExtractRecordTypePropertyNames() {
        }

        public void visitOnce(JSType type) {
            if (this.seenTypes.add(type)) {
                type.visit(this);
            }
        }

        @Override
        public Set<String> caseEnumElementType(EnumElementType type) {
            this.visitOnce(type.getPrimitiveType());
            return GatherExternProperties.this.externProperties;
        }

        @Override
        public Set<String> caseFunctionType(FunctionType type) {
            for (Node node : type.getParameters()) {
                this.visitOnce(node.getJSType());
            }
            this.visitOnce(type.getReturnType());
            if (type.isInterface()) {
                for (JSType jSType : type.getExtendedInterfaces()) {
                    this.visitOnce(jSType);
                }
            }
            if (type.isConstructor()) {
                for (JSType jSType : type.getOwnImplementedInterfaces()) {
                    this.visitOnce(jSType);
                }
                ObjectType superClass = type.getPrototype().getImplicitPrototype();
                if (superClass != null) {
                    this.visitOnce(superClass);
                }
            }
            return GatherExternProperties.this.externProperties;
        }

        @Override
        public Set<String> caseObjectType(ObjectType type) {
            if (type.isRecordType()) {
                for (String propertyName : type.getOwnPropertyNames()) {
                    if (!type.getPropertyNode(propertyName).isFromExterns()) continue;
                    GatherExternProperties.this.externProperties.add(propertyName);
                    this.visitOnce(type.getPropertyType(propertyName));
                }
            }
            return GatherExternProperties.this.externProperties;
        }

        @Override
        public Set<String> caseNamedType(NamedType type) {
            return this.caseProxyObjectType(type);
        }

        @Override
        public Set<String> caseProxyObjectType(ProxyObjectType type) {
            type.visitReferenceType(this);
            return GatherExternProperties.this.externProperties;
        }

        @Override
        public Set<String> caseUnionType(UnionType type) {
            for (JSType alternateType : type.getAlternates()) {
                this.visitOnce(alternateType);
            }
            return GatherExternProperties.this.externProperties;
        }

        @Override
        public Set<String> caseTemplatizedType(TemplatizedType type) {
            for (JSType templateType : type.getTemplateTypes()) {
                this.visitOnce(templateType);
            }
            return GatherExternProperties.this.externProperties;
        }

        @Override
        public Set<String> caseNoType(NoType type) {
            return GatherExternProperties.this.externProperties;
        }

        @Override
        public Set<String> caseAllType() {
            return GatherExternProperties.this.externProperties;
        }

        @Override
        public Set<String> caseBooleanType() {
            return GatherExternProperties.this.externProperties;
        }

        @Override
        public Set<String> caseNoObjectType() {
            return GatherExternProperties.this.externProperties;
        }

        @Override
        public Set<String> caseUnknownType() {
            return GatherExternProperties.this.externProperties;
        }

        @Override
        public Set<String> caseNullType() {
            return GatherExternProperties.this.externProperties;
        }

        @Override
        public Set<String> caseNumberType() {
            return GatherExternProperties.this.externProperties;
        }

        @Override
        public Set<String> caseStringType() {
            return GatherExternProperties.this.externProperties;
        }

        @Override
        public Set<String> caseVoidType() {
            return GatherExternProperties.this.externProperties;
        }

        @Override
        public Set<String> caseTemplateType(TemplateType templateType) {
            return GatherExternProperties.this.externProperties;
        }
    }
}

