/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class Es6ToEs3ClassSideInheritance
implements HotSwapCompilerPass {
    final AbstractCompiler compiler;
    private final Multimap<String, Node> staticMethods = ArrayListMultimap.create();
    private final Multimap<String, Node> staticProperties = ArrayListMultimap.create();
    static final DiagnosticType DUPLICATE_CLASS = DiagnosticType.error("DUPLICATE_CLASS", "Multiple classes cannot share the same name.");
    private final Set<String> multiplyDefinedClasses = new HashSet<String>();

    public Es6ToEs3ClassSideInheritance(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        FindStaticMembers findStaticMembers = new FindStaticMembers();
        NodeTraversal.traverseEs6(this.compiler, externs, findStaticMembers);
        NodeTraversal.traverseEs6(this.compiler, root, findStaticMembers);
        this.processInherits(findStaticMembers.inheritsCalls);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        FindStaticMembers findStaticMembers = new FindStaticMembers();
        NodeTraversal.traverseEs6(this.compiler, scriptRoot, findStaticMembers);
        this.processInherits(findStaticMembers.inheritsCalls);
    }

    private void processInherits(List<Node> inheritsCalls) {
        for (Node n : inheritsCalls) {
            Node parent = n.getParent();
            Node superclassNameNode = n.getLastChild();
            Node subclassNameNode = n.getChildBefore(superclassNameNode);
            if (this.multiplyDefinedClasses.contains(superclassNameNode.getQualifiedName())) {
                this.compiler.report(JSError.make(n, DUPLICATE_CLASS, new String[0]));
                return;
            }
            for (Node staticMethod : this.staticMethods.get((Object)superclassNameNode.getQualifiedName())) {
                this.copyStaticMethod(staticMethod, superclassNameNode, subclassNameNode, parent);
            }
            for (Node staticProperty : this.staticProperties.get((Object)superclassNameNode.getQualifiedName())) {
                Preconditions.checkState((boolean)staticProperty.isGetProp(), (Object)staticProperty);
                String memberName = staticProperty.getLastChild().getString();
                Node getprop = IR.getprop(subclassNameNode.cloneTree(), IR.string(memberName));
                JSDocInfoBuilder info = JSDocInfoBuilder.maybeCopyFrom(staticProperty.getJSDocInfo());
                JSTypeExpression unknown = new JSTypeExpression(new Node(304), "<synthetic>");
                info.recordType(unknown);
                info.addSuppression("visibility");
                getprop.setJSDocInfo(info.build());
                Node declaration = IR.exprResult(getprop);
                declaration.useSourceInfoIfMissingFromForTree(n);
                parent.getParent().addChildAfter(declaration, parent);
                this.staticProperties.put((Object)subclassNameNode.getQualifiedName(), (Object)staticProperty);
                this.compiler.reportCodeChange();
            }
        }
    }

    private void copyStaticMethod(Node staticMember, Node superclassNameNode, Node subclassNameNode, Node insertionPoint) {
        Preconditions.checkState((boolean)staticMember.isAssign(), (Object)staticMember);
        String memberName = staticMember.getFirstChild().getLastChild().getString();
        for (Node subclassMember : this.staticMethods.get((Object)subclassNameNode.getQualifiedName())) {
            Preconditions.checkState((boolean)subclassMember.isAssign(), (Object)subclassMember);
            if (!subclassMember.getFirstChild().getLastChild().getString().equals(memberName)) continue;
            return;
        }
        JSDocInfoBuilder info = JSDocInfoBuilder.maybeCopyFrom(staticMember.getJSDocInfo());
        Node assign = IR.assign(IR.getprop(subclassNameNode.cloneTree(), IR.string(memberName)), IR.getprop(superclassNameNode.cloneTree(), IR.string(memberName)));
        info.addSuppression("visibility");
        assign.setJSDocInfo(info.build());
        Node exprResult = IR.exprResult(assign);
        exprResult.useSourceInfoIfMissingFromForTree(superclassNameNode);
        insertionPoint.getParent().addChildAfter(exprResult, insertionPoint);
        this.staticMethods.put((Object)subclassNameNode.getQualifiedName(), (Object)assign);
        this.compiler.reportCodeChange();
    }

    private class FindStaticMembers
    extends NodeTraversal.AbstractPostOrderCallback {
        private final Set<String> classNames = new HashSet<String>();
        private final List<Node> inheritsCalls = new LinkedList<Node>();

        private FindStaticMembers() {
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node n, Node parent) {
            switch (n.getType()) {
                case 37: {
                    if (!n.getFirstChild().matchesQualifiedName("$jscomp.inherits")) break;
                    this.inheritsCalls.add(n);
                    break;
                }
                case 118: {
                    this.visitVar(n);
                    break;
                }
                case 86: {
                    this.visitAssign(n);
                    break;
                }
                case 33: {
                    if (!parent.isExprResult()) break;
                    this.visitGetProp(n);
                    break;
                }
                case 105: {
                    this.visitFunctionClassDef(n);
                }
            }
        }

        private void visitFunctionClassDef(Node n) {
            JSDocInfo classInfo = NodeUtil.getBestJSDocInfo(n);
            if (classInfo != null && classInfo.isConstructor()) {
                String name = NodeUtil.getFunctionName(n);
                if (this.classNames.contains(name)) {
                    Es6ToEs3ClassSideInheritance.this.multiplyDefinedClasses.add(name);
                } else if (name != null) {
                    this.classNames.add(name);
                }
            }
        }

        private void visitGetProp(Node n) {
            String className = n.getFirstChild().getQualifiedName();
            if (this.classNames.contains(className)) {
                Es6ToEs3ClassSideInheritance.this.staticProperties.put((Object)className, (Object)n);
            }
        }

        private void visitAssign(Node n) {
            Node getProp;
            String maybeClassName;
            if (this.classNames.contains(n.getLastChild().getQualifiedName())) {
                String maybeAlias = n.getFirstChild().getQualifiedName();
                if (maybeAlias != null) {
                    this.classNames.add(maybeAlias);
                    Es6ToEs3ClassSideInheritance.this.staticMethods.putAll((Object)maybeAlias, (Iterable)Es6ToEs3ClassSideInheritance.this.staticMethods.get((Object)n.getLastChild().getQualifiedName()));
                }
            } else if (n.getFirstChild().isGetProp() && this.classNames.contains(maybeClassName = (getProp = n.getFirstChild()).getFirstChild().getQualifiedName())) {
                Es6ToEs3ClassSideInheritance.this.staticMethods.put((Object)maybeClassName, (Object)n);
            }
        }

        private void visitVar(Node n) {
            String maybeAlias;
            Node child = n.getFirstChild();
            if (!child.hasChildren()) {
                return;
            }
            String maybeOriginalName = child.getFirstChild().getQualifiedName();
            if (this.classNames.contains(maybeOriginalName) && (maybeAlias = child.getQualifiedName()) != null) {
                this.classNames.add(maybeAlias);
                Es6ToEs3ClassSideInheritance.this.staticMethods.putAll((Object)maybeAlias, (Iterable)Es6ToEs3ClassSideInheritance.this.staticMethods.get((Object)maybeOriginalName));
            }
        }
    }
}

