/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.DiagnosticType;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public final class ES6ModuleLoader {
    static final String MODULE_SLASH = "/";
    public static final String DEFAULT_FILENAME_PREFIX = "./";
    static final DiagnosticType LOAD_ERROR = DiagnosticType.error("JSC_ES6_MODULE_LOAD_ERROR", "Failed to load module \"{0}\"");
    private final List<URI> moduleRootUris;
    private final Set<URI> moduleUris;

    public ES6ModuleLoader(List<String> moduleRoots, Iterable<CompilerInput> inputs) {
        this.moduleRootUris = Lists.transform(moduleRoots, (Function)new Function<String, URI>(){

            public URI apply(String path) {
                return ES6ModuleLoader.createUri(path);
            }
        });
        this.moduleUris = new HashSet<URI>();
        for (CompilerInput input : inputs) {
            if (this.moduleUris.add(this.normalizeInputAddress(input))) continue;
            throw new IllegalArgumentException("Duplicate module URI after resolving: " + input.getName());
        }
    }

    URI locateCommonJsModule(String requireName, CompilerInput context) {
        URI loadAddress = this.locate(requireName, context);
        if (loadAddress == null) {
            loadAddress = this.locate(requireName + MODULE_SLASH + "index.js", context);
        }
        if (loadAddress == null) {
            loadAddress = this.locate(requireName + ".js", context);
        }
        return loadAddress;
    }

    URI locateEs6Module(String moduleName, CompilerInput context) {
        return this.locate(moduleName + ".js", context);
    }

    private URI locate(String name, CompilerInput referrer) {
        URI normalized;
        URI uri = ES6ModuleLoader.createUri(name);
        if (ES6ModuleLoader.isRelativeIdentifier(name)) {
            URI referrerUri = this.normalizeInputAddress(referrer);
            uri = referrerUri.resolve(uri);
        }
        if (this.moduleUris.contains(normalized = this.normalizeAddress(uri))) {
            return normalized;
        }
        return null;
    }

    URI normalizeInputAddress(CompilerInput input) {
        String name = input.getName();
        return this.normalizeAddress(ES6ModuleLoader.createUri(name));
    }

    private URI normalizeAddress(URI uri) {
        for (URI moduleRoot : this.moduleRootUris) {
            if (!uri.toString().startsWith(moduleRoot.toString())) continue;
            return moduleRoot.relativize(uri);
        }
        return uri;
    }

    private static URI createUri(String input) {
        String forwardSlashes = input.replace(':', '-').replace("\\", MODULE_SLASH);
        return URI.create(forwardSlashes).normalize();
    }

    private static String stripJsExtension(String fileName) {
        if (fileName.endsWith(".js")) {
            return fileName.substring(0, fileName.length() - ".js".length());
        }
        return fileName;
    }

    static boolean isRelativeIdentifier(String name) {
        return name.startsWith(DEFAULT_FILENAME_PREFIX) || name.startsWith("../");
    }

    public static String toModuleName(URI filename) {
        String moduleName = ES6ModuleLoader.stripJsExtension(filename.toString()).replaceAll("^\\." + Pattern.quote(MODULE_SLASH), "").replace(MODULE_SLASH, "$").replace('\\', '$').replace('-', '_').replace(':', '_').replace('.', '_');
        return "module$" + moduleName;
    }
}

