/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public final class DependencyOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean sortDependencies = false;
    private boolean pruneDependencies = false;
    private boolean dropMoochers = false;
    private boolean es6ModuleOrder = false;
    private final Set<String> entryPoints = new HashSet<String>();

    public DependencyOptions setDependencySorting(boolean enabled) {
        this.sortDependencies = enabled;
        return this;
    }

    public DependencyOptions setDependencyPruning(boolean enabled) {
        this.pruneDependencies = enabled;
        return this;
    }

    public DependencyOptions setEs6ModuleOrder(boolean es6ModuleOrder) {
        this.es6ModuleOrder = es6ModuleOrder;
        return this;
    }

    public DependencyOptions setMoocherDropping(boolean enabled) {
        this.dropMoochers = enabled;
        return this;
    }

    public DependencyOptions setEntryPoints(Collection<String> symbols) {
        this.entryPoints.clear();
        this.entryPoints.addAll(symbols);
        return this;
    }

    public boolean isEs6ModuleOrder() {
        return this.es6ModuleOrder;
    }

    boolean needsManagement() {
        return this.sortDependencies || this.pruneDependencies || this.es6ModuleOrder;
    }

    boolean shouldSortDependencies() {
        return this.sortDependencies;
    }

    boolean shouldPruneDependencies() {
        return this.pruneDependencies;
    }

    boolean shouldDropMoochers() {
        return this.pruneDependencies && this.dropMoochers;
    }

    Collection<String> getEntryPoints() {
        return this.entryPoints;
    }
}

