/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AccessControlUtils;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CollectFileOverviewVisibility;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TypedVar;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticSourceFile;
import com.google.javascript.rhino.TypeIRegistry;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.Property;
import java.util.ArrayDeque;
import javax.annotation.Nullable;

class CheckAccessControls
implements NodeTraversal.ScopedCallback,
HotSwapCompilerPass {
    static final DiagnosticType DEPRECATED_NAME = DiagnosticType.disabled("JSC_DEPRECATED_VAR", "Variable {0} has been deprecated.");
    static final DiagnosticType DEPRECATED_NAME_REASON = DiagnosticType.disabled("JSC_DEPRECATED_VAR_REASON", "Variable {0} has been deprecated: {1}");
    static final DiagnosticType DEPRECATED_PROP = DiagnosticType.disabled("JSC_DEPRECATED_PROP", "Property {0} of type {1} has been deprecated.");
    static final DiagnosticType DEPRECATED_PROP_REASON = DiagnosticType.disabled("JSC_DEPRECATED_PROP_REASON", "Property {0} of type {1} has been deprecated: {2}");
    static final DiagnosticType DEPRECATED_CLASS = DiagnosticType.disabled("JSC_DEPRECATED_CLASS", "Class {0} has been deprecated.");
    static final DiagnosticType DEPRECATED_CLASS_REASON = DiagnosticType.disabled("JSC_DEPRECATED_CLASS_REASON", "Class {0} has been deprecated: {1}");
    static final DiagnosticType BAD_PACKAGE_PROPERTY_ACCESS = DiagnosticType.error("JSC_BAD_PACKAGE_PROPERTY_ACCESS", "Access to package-private property {0} of {1} not allowed here.");
    static final DiagnosticType BAD_PRIVATE_GLOBAL_ACCESS = DiagnosticType.error("JSC_BAD_PRIVATE_GLOBAL_ACCESS", "Access to private variable {0} not allowed outside file {1}.");
    static final DiagnosticType BAD_PRIVATE_PROPERTY_ACCESS = DiagnosticType.warning("JSC_BAD_PRIVATE_PROPERTY_ACCESS", "Access to private property {0} of {1} not allowed here.");
    static final DiagnosticType BAD_PROTECTED_PROPERTY_ACCESS = DiagnosticType.warning("JSC_BAD_PROTECTED_PROPERTY_ACCESS", "Access to protected property {0} of {1} not allowed here.");
    static final DiagnosticType BAD_PROPERTY_OVERRIDE_IN_FILE_WITH_FILEOVERVIEW_VISIBILITY = DiagnosticType.error("JSC_BAD_PROPERTY_OVERRIDE_IN_FILE_WITH_FILEOVERVIEW_VISIBILITY", "Overridden property {0} in file with fileoverview visibility {1} must explicitly redeclare superclass visibility");
    static final DiagnosticType PRIVATE_OVERRIDE = DiagnosticType.warning("JSC_PRIVATE_OVERRIDE", "Overriding private property of {0}.");
    static final DiagnosticType EXTEND_FINAL_CLASS = DiagnosticType.error("JSC_EXTEND_FINAL_CLASS", "{0} is not allowed to extend final class {1}.");
    static final DiagnosticType VISIBILITY_MISMATCH = DiagnosticType.warning("JSC_VISIBILITY_MISMATCH", "Overriding {0} property of {1} with {2} property.");
    static final DiagnosticType CONST_PROPERTY_REASSIGNED_VALUE = DiagnosticType.warning("JSC_CONSTANT_PROPERTY_REASSIGNED_VALUE", "constant property {0} assigned a value more than once");
    static final DiagnosticType CONST_PROPERTY_DELETED = DiagnosticType.warning("JSC_CONSTANT_PROPERTY_DELETED", "constant property {0} cannot be deleted");
    static final DiagnosticType CONVENTION_MISMATCH = DiagnosticType.warning("JSC_CONVENTION_MISMATCH", "Declared access conflicts with access convention.");
    private final AbstractCompiler compiler;
    private final TypeIRegistry typeRegistry;
    private final boolean enforceCodingConventions;
    private int deprecatedDepth = 0;
    private final ArrayDeque<JSType> currentClassStack = new ArrayDeque();
    private final JSType noTypeSentinel;
    private ImmutableMap<StaticSourceFile, JSDocInfo.Visibility> defaultVisibilityForFiles;
    private final Multimap<JSType, String> initializedConstantProperties;

    CheckAccessControls(AbstractCompiler compiler, boolean enforceCodingConventions) {
        this.compiler = compiler;
        this.typeRegistry = compiler.getTypeIRegistry();
        this.initializedConstantProperties = HashMultimap.create();
        this.enforceCodingConventions = enforceCodingConventions;
        this.noTypeSentinel = (JSType)this.typeRegistry.getNativeType(JSTypeNative.NO_TYPE);
    }

    @Override
    public void process(Node externs, Node root) {
        CollectFileOverviewVisibility collectPass = new CollectFileOverviewVisibility(this.compiler);
        collectPass.process(externs, root);
        this.defaultVisibilityForFiles = collectPass.getFileOverviewVisibilityMap();
        NodeTraversal.traverseTyped(this.compiler, externs, this);
        NodeTraversal.traverseTyped(this.compiler, root, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        CollectFileOverviewVisibility collectPass = new CollectFileOverviewVisibility(this.compiler);
        collectPass.hotSwapScript(scriptRoot, originalRoot);
        this.defaultVisibilityForFiles = collectPass.getFileOverviewVisibilityMap();
        NodeTraversal.traverseTyped(this.compiler, scriptRoot, this);
    }

    @Override
    public void enterScope(NodeTraversal t) {
        if (!t.inGlobalScope()) {
            JSType prevClass;
            Node n = t.getScopeRoot();
            Node parent = n.getParent();
            if (CheckAccessControls.isDeprecatedFunction(n)) {
                ++this.deprecatedDepth;
            }
            JSType currentClass = (prevClass = this.getCurrentClass()) == null ? this.getClassOfMethod(n, parent) : prevClass;
            this.currentClassStack.addFirst(currentClass == null ? this.noTypeSentinel : currentClass);
        }
    }

    @Override
    public void exitScope(NodeTraversal t) {
        if (!t.inGlobalScope()) {
            Node n = t.getScopeRoot();
            if (CheckAccessControls.isDeprecatedFunction(n)) {
                --this.deprecatedDepth;
            }
            this.currentClassStack.pop();
        }
    }

    private JSType getClassOfMethod(Node n, Node parent) {
        if (parent.isAssign()) {
            Node lValue = parent.getFirstChild();
            if (NodeUtil.isGet(lValue)) {
                JSType lValueType = lValue.getJSType();
                if (lValueType != null && lValueType.isNominalConstructor()) {
                    return lValueType.toMaybeFunctionType().getInstanceType();
                }
                return CheckAccessControls.normalizeClassType(lValue.getFirstChild().getJSType());
            }
            return CheckAccessControls.normalizeClassType(lValue.getJSType());
        }
        if (NodeUtil.isFunctionDeclaration(n) || parent.isName()) {
            return CheckAccessControls.normalizeClassType(n.getJSType());
        }
        if (parent.isStringKey() || parent.isGetterDef() || parent.isSetterDef()) {
            Node objectLitParent = parent.getParent().getParent();
            if (!objectLitParent.isAssign()) {
                return null;
            }
            Node className = NodeUtil.getPrototypeClassName(objectLitParent.getFirstChild());
            if (className != null) {
                return CheckAccessControls.normalizeClassType(className.getJSType());
            }
        }
        return null;
    }

    private static JSType normalizeClassType(JSType type) {
        FunctionType owner;
        if (type == null || type.isUnknownType()) {
            return type;
        }
        if (type.isNominalConstructor()) {
            return type.toMaybeFunctionType().getInstanceType();
        }
        if (type.isFunctionPrototypeType() && (owner = ((ObjectType)type).getOwnerFunction()).isConstructor()) {
            return owner.getInstanceType();
        }
        return type;
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getType()) {
            case 38: {
                this.checkNameDeprecation(t, n, parent);
                this.checkNameVisibility(t, n, parent);
                break;
            }
            case 33: {
                this.checkPropertyDeprecation(t, n, parent);
                this.checkPropertyVisibility(t, n, parent);
                this.checkConstantProperty(t, n);
                break;
            }
            case 147: 
            case 148: 
            case 154: {
                this.checkKeyVisibilityConvention(t, n, parent);
                break;
            }
            case 30: {
                this.checkConstructorDeprecation(t, n, parent);
                break;
            }
            case 105: {
                this.checkFinalClassOverrides(t, n, parent);
            }
        }
    }

    private void checkConstructorDeprecation(NodeTraversal t, Node n, Node parent) {
        String deprecationInfo;
        JSType type = n.getJSType();
        if (type != null && (deprecationInfo = CheckAccessControls.getTypeDeprecationInfo(type)) != null && this.shouldEmitDeprecationWarning(t, n, parent)) {
            if (!deprecationInfo.isEmpty()) {
                this.compiler.report(t.makeError(n, DEPRECATED_CLASS_REASON, type.toString(), deprecationInfo));
            } else {
                this.compiler.report(t.makeError(n, DEPRECATED_CLASS, type.toString()));
            }
        }
    }

    private void checkNameDeprecation(NodeTraversal t, Node n, Node parent) {
        JSDocInfo docInfo;
        if (parent.isFunction() || parent.isVar() || parent.isNew()) {
            return;
        }
        TypedVar var = t.getTypedScope().getVar(n.getString());
        JSDocInfo jSDocInfo = docInfo = var == null ? null : var.getJSDocInfo();
        if (docInfo != null && docInfo.isDeprecated() && this.shouldEmitDeprecationWarning(t, n, parent)) {
            if (docInfo.getDeprecationReason() != null) {
                this.compiler.report(t.makeError(n, DEPRECATED_NAME_REASON, n.getString(), docInfo.getDeprecationReason()));
            } else {
                this.compiler.report(t.makeError(n, DEPRECATED_NAME, n.getString()));
            }
        }
    }

    private void checkPropertyDeprecation(NodeTraversal t, Node n, Node parent) {
        String deprecationInfo;
        if (parent.isNew()) {
            return;
        }
        ObjectType objectType = ObjectType.cast(CheckAccessControls.dereference(n.getFirstChild().getJSType()));
        String propertyName = n.getLastChild().getString();
        if (objectType != null && (deprecationInfo = CheckAccessControls.getPropertyDeprecationInfo(objectType, propertyName)) != null && this.shouldEmitDeprecationWarning(t, n, parent)) {
            if (!deprecationInfo.isEmpty()) {
                this.compiler.report(t.makeError(n, DEPRECATED_PROP_REASON, propertyName, this.typeRegistry.getReadableTypeName(n.getFirstChild()), deprecationInfo));
            } else {
                this.compiler.report(t.makeError(n, DEPRECATED_PROP, propertyName, this.typeRegistry.getReadableTypeName(n.getFirstChild())));
            }
        }
    }

    private boolean isPrivateByConvention(String name) {
        return this.enforceCodingConventions && this.compiler.getCodingConvention().isPrivate(name);
    }

    private void checkKeyVisibilityConvention(NodeTraversal t, Node key, Node parent) {
        JSDocInfo info = key.getJSDocInfo();
        if (info == null) {
            return;
        }
        if (!this.isPrivateByConvention(key.getString())) {
            return;
        }
        Node assign = parent.getParent();
        if (assign == null || !assign.isAssign()) {
            return;
        }
        Node left = assign.getFirstChild();
        if (!left.isGetProp() || !left.getLastChild().getString().equals("prototype")) {
            return;
        }
        JSDocInfo.Visibility declaredVisibility = info.getVisibility();
        if (declaredVisibility != JSDocInfo.Visibility.INHERITED && declaredVisibility != JSDocInfo.Visibility.PRIVATE) {
            this.compiler.report(t.makeError(key, CONVENTION_MISMATCH, new String[0]));
        }
    }

    private void checkNameVisibility(NodeTraversal t, Node name, Node parent) {
        TypedVar var = t.getTypedScope().getVar(name.getString());
        if (var == null) {
            return;
        }
        JSDocInfo.Visibility v = this.checkPrivateNameConvention(AccessControlUtils.getEffectiveNameVisibility(name, var, this.defaultVisibilityForFiles), name);
        switch (v) {
            case PACKAGE: {
                if (this.isPackageAccessAllowed(var, name)) break;
                this.compiler.report(t.makeError(name, BAD_PACKAGE_PROPERTY_ACCESS, name.getString(), var.getSourceFile().getName()));
                break;
            }
            case PRIVATE: {
                if (CheckAccessControls.isPrivateAccessAllowed(var, name, parent)) break;
                this.compiler.report(t.makeError(name, BAD_PRIVATE_GLOBAL_ACCESS, name.getString(), var.getSourceFile().getName()));
                break;
            }
        }
    }

    private JSDocInfo.Visibility checkPrivateNameConvention(JSDocInfo.Visibility v, Node name) {
        if (this.isPrivateByConvention(name.getString())) {
            if (v != JSDocInfo.Visibility.PRIVATE && v != JSDocInfo.Visibility.INHERITED) {
                this.compiler.report(JSError.make(name, CONVENTION_MISMATCH, new String[0]));
            }
            return JSDocInfo.Visibility.PRIVATE;
        }
        return v;
    }

    private static boolean isPrivateAccessAllowed(TypedVar var, Node name, Node parent) {
        StaticSourceFile varSrc = var.getSourceFile();
        StaticSourceFile refSrc = name.getStaticSourceFile();
        JSDocInfo docInfo = var.getJSDocInfo();
        if (varSrc != null && refSrc != null && !varSrc.getName().equals(refSrc.getName())) {
            return docInfo != null && docInfo.isConstructor() && CheckAccessControls.isValidPrivateConstructorAccess(parent);
        }
        return true;
    }

    private boolean isPackageAccessAllowed(TypedVar var, Node name) {
        StaticSourceFile varSrc = var.getSourceFile();
        StaticSourceFile refSrc = name.getStaticSourceFile();
        CodingConvention codingConvention = this.compiler.getCodingConvention();
        if (varSrc != null && refSrc != null) {
            String srcPackage = codingConvention.getPackageName(varSrc);
            String refPackage = codingConvention.getPackageName(refSrc);
            return srcPackage != null && refPackage != null && srcPackage.equals(refPackage);
        }
        return false;
    }

    private void checkOverriddenPropertyVisibilityMismatch(JSDocInfo.Visibility overriding, JSDocInfo.Visibility overridden, @Nullable JSDocInfo.Visibility fileOverview, NodeTraversal t, Node getprop) {
        if (overriding == JSDocInfo.Visibility.INHERITED && overriding != overridden && fileOverview != null && fileOverview != JSDocInfo.Visibility.INHERITED) {
            String propertyName = getprop.getLastChild().getString();
            this.compiler.report(t.makeError(getprop, BAD_PROPERTY_OVERRIDE_IN_FILE_WITH_FILEOVERVIEW_VISIBILITY, propertyName, fileOverview.name()));
        }
    }

    @Nullable
    private static JSDocInfo.Visibility getOverridingPropertyVisibility(Node parent) {
        JSDocInfo overridingInfo = parent.getJSDocInfo();
        return overridingInfo == null || !overridingInfo.isOverride() ? null : overridingInfo.getVisibility();
    }

    private void checkFinalClassOverrides(NodeTraversal t, Node fn, Node parent) {
        JSType finalParentClass;
        FunctionType type = fn.getJSType().toMaybeFunctionType();
        if (type != null && ((JSType)type).isConstructor() && (finalParentClass = CheckAccessControls.getFinalParentClass(this.getClassOfMethod(fn, parent))) != null) {
            this.compiler.report(t.makeError(fn, EXTEND_FINAL_CLASS, ((JSType)type).getDisplayName(), finalParentClass.getDisplayName()));
        }
    }

    private void checkConstantProperty(NodeTraversal t, Node getprop) {
        String propertyName;
        Node parent = getprop.getParent();
        boolean isDelete = parent.isDelProp();
        if (!(NodeUtil.isAssignmentOp(parent) && parent.getFirstChild() == getprop || parent.isInc() || parent.isDec() || isDelete)) {
            return;
        }
        ObjectType objectType = ObjectType.cast(CheckAccessControls.dereference(getprop.getFirstChild().getJSType()));
        boolean isConstant = this.isPropertyDeclaredConstant(objectType, propertyName = getprop.getLastChild().getString());
        if (isConstant) {
            ObjectType prototype;
            JSDocInfo info = parent.getJSDocInfo();
            if (info != null && info.getSuppressions().contains("const")) {
                return;
            }
            if (isDelete) {
                this.compiler.report(t.makeError(getprop, CONST_PROPERTY_DELETED, propertyName));
                return;
            }
            if (objectType == null || objectType.isFunctionType() && !objectType.toMaybeFunctionType().isConstructor()) {
                return;
            }
            for (ObjectType oType = objectType; oType != null; oType = oType.getImplicitPrototype()) {
                if (!this.initializedConstantProperties.containsEntry((Object)oType, (Object)propertyName)) continue;
                this.compiler.report(t.makeError(getprop, CONST_PROPERTY_REASSIGNED_VALUE, propertyName));
                break;
            }
            this.initializedConstantProperties.put((Object)objectType, (Object)propertyName);
            if (objectType.isInstanceType() && (prototype = objectType.getImplicitPrototype()) != null && prototype.hasProperty(propertyName)) {
                this.initializedConstantProperties.put((Object)prototype, (Object)propertyName);
            }
        }
    }

    private void checkPropertyVisibility(NodeTraversal t, Node getprop, Node parent) {
        JSDocInfo.Visibility overriding;
        JSDocInfo jsdoc = parent.getJSDocInfo();
        if (jsdoc != null && jsdoc.getSuppressions().contains("visibility")) {
            return;
        }
        ObjectType referenceType = ObjectType.cast(CheckAccessControls.dereference(getprop.getFirstChild().getJSType()));
        String propertyName = getprop.getLastChild().getString();
        boolean isPrivateByConvention = this.isPrivateByConvention(propertyName);
        if (isPrivateByConvention && CheckAccessControls.propertyIsDeclaredButNotPrivate(getprop, parent)) {
            this.compiler.report(t.makeError(getprop, CONVENTION_MISMATCH, new String[0]));
            return;
        }
        StaticSourceFile definingSource = CheckAccessControls.getDefiningSource(getprop, referenceType, propertyName);
        boolean isClassType = false;
        boolean isOverride = jsdoc != null && parent.isAssign() && parent.getFirstChild() == getprop;
        ObjectType objectType = CheckAccessControls.getObjectType(referenceType, isOverride, propertyName);
        JSDocInfo.Visibility fileOverviewVisibility = (JSDocInfo.Visibility)((Object)this.defaultVisibilityForFiles.get((Object)definingSource));
        JSDocInfo.Visibility visibility = AccessControlUtils.getEffectivePropertyVisibility(getprop, referenceType, this.defaultVisibilityForFiles, this.enforceCodingConventions ? this.compiler.getCodingConvention() : null);
        if (isOverride && (overriding = CheckAccessControls.getOverridingPropertyVisibility(parent)) != null) {
            this.checkOverriddenPropertyVisibilityMismatch(overriding, visibility, fileOverviewVisibility, t, getprop);
        }
        if (objectType != null) {
            Property p = objectType.getOwnSlot(propertyName);
            Node node = p.getNode();
            if (node == null) {
                return;
            }
            definingSource = node.getStaticSourceFile();
            isClassType = p.getJSDocInfo().isConstructor();
        } else if (isPrivateByConvention) {
            objectType = referenceType;
        } else if (fileOverviewVisibility == null) {
            return;
        }
        StaticSourceFile referenceSource = getprop.getStaticSourceFile();
        if (isOverride) {
            boolean sameInput = referenceSource != null && referenceSource.getName().equals(definingSource.getName());
            this.checkOverriddenPropertyVisibility(t, getprop, parent, visibility, fileOverviewVisibility, objectType, sameInput);
        } else {
            this.checkNonOverriddenPropertyVisibility(t, getprop, parent, visibility, isClassType, objectType, referenceSource, definingSource);
        }
    }

    private static boolean propertyIsDeclaredButNotPrivate(Node getprop, Node parent) {
        JSDocInfo.Visibility declaredVisibility;
        JSDocInfo info = NodeUtil.getBestJSDocInfo(getprop);
        return (parent.isAssign() || parent.isExprResult()) && parent.getFirstChild() == getprop && info != null && (declaredVisibility = info.getVisibility()) != JSDocInfo.Visibility.PRIVATE && declaredVisibility != JSDocInfo.Visibility.INHERITED;
    }

    @Nullable
    private static StaticSourceFile getDefiningSource(Node getprop, @Nullable ObjectType referenceType, String propertyName) {
        Node propDefNode;
        if (referenceType != null && (propDefNode = referenceType.getPropertyNode(propertyName)) != null) {
            return propDefNode.getStaticSourceFile();
        }
        return getprop.getStaticSourceFile();
    }

    @Nullable
    private static ObjectType getObjectType(@Nullable ObjectType referenceType, boolean isOverride, String propertyName) {
        ObjectType objectType;
        if (referenceType == null) {
            return null;
        }
        ObjectType objectType2 = objectType = isOverride ? referenceType.getImplicitPrototype() : referenceType;
        while (objectType != null) {
            JSDocInfo docInfo = objectType.getOwnPropertyJSDocInfo(propertyName);
            if (docInfo != null && docInfo.getVisibility() != JSDocInfo.Visibility.INHERITED) {
                return objectType;
            }
            objectType = objectType.getImplicitPrototype();
        }
        return null;
    }

    private void checkOverriddenPropertyVisibility(NodeTraversal t, Node getprop, Node parent, JSDocInfo.Visibility visibility, JSDocInfo.Visibility fileOverviewVisibility, ObjectType objectType, boolean sameInput) {
        JSDocInfo.Visibility overridingVisibility;
        JSDocInfo overridingInfo = parent.getJSDocInfo();
        JSDocInfo.Visibility visibility2 = overridingVisibility = overridingInfo == null ? JSDocInfo.Visibility.INHERITED : overridingInfo.getVisibility();
        if (visibility == JSDocInfo.Visibility.PRIVATE && !sameInput) {
            this.compiler.report(t.makeError(getprop, PRIVATE_OVERRIDE, objectType.toString()));
        } else if (overridingVisibility != JSDocInfo.Visibility.INHERITED && overridingVisibility != visibility && fileOverviewVisibility == null) {
            this.compiler.report(t.makeError(getprop, VISIBILITY_MISMATCH, visibility.name(), objectType.toString(), overridingVisibility.name()));
        }
    }

    private void checkNonOverriddenPropertyVisibility(NodeTraversal t, Node getprop, Node parent, JSDocInfo.Visibility visibility, boolean isClassType, JSType objectType, StaticSourceFile referenceSource, StaticSourceFile definingSource) {
        if (referenceSource != null && definingSource != null && referenceSource.getName().equals(definingSource.getName())) {
            return;
        }
        String propertyName = getprop.getLastChild().getString();
        JSType ownerType = CheckAccessControls.normalizeClassType(objectType);
        switch (visibility) {
            case PACKAGE: {
                this.checkPackagePropertyVisibility(t, getprop, referenceSource, definingSource);
                break;
            }
            case PRIVATE: {
                this.checkPrivatePropertyVisibility(t, getprop, parent, isClassType, ownerType);
                break;
            }
            case PROTECTED: {
                this.checkProtectedPropertyVisibility(t, getprop, ownerType);
                break;
            }
        }
    }

    private void checkPackagePropertyVisibility(NodeTraversal t, Node getprop, StaticSourceFile referenceSource, StaticSourceFile definingSource) {
        CodingConvention codingConvention = this.compiler.getCodingConvention();
        String refPackage = codingConvention.getPackageName(referenceSource);
        String defPackage = codingConvention.getPackageName(definingSource);
        if (refPackage == null || defPackage == null || !refPackage.equals(defPackage)) {
            String propertyName = getprop.getLastChild().getString();
            this.compiler.report(t.makeError(getprop, BAD_PACKAGE_PROPERTY_ACCESS, propertyName, this.typeRegistry.getReadableTypeName(getprop.getFirstChild())));
        }
    }

    @Nullable
    private JSType getCurrentClass() {
        JSType cur = this.currentClassStack.peekFirst();
        return cur == this.noTypeSentinel ? null : cur;
    }

    private void checkPrivatePropertyVisibility(NodeTraversal t, Node getprop, Node parent, boolean isClassType, JSType ownerType) {
        JSType currentClass = this.getCurrentClass();
        if (currentClass != null && ownerType.isEquivalentTo(currentClass)) {
            return;
        }
        if (isClassType && CheckAccessControls.isValidPrivateConstructorAccess(parent)) {
            return;
        }
        JSType accessedType = getprop.getFirstChild().getJSType();
        String propertyName = getprop.getLastChild().getString();
        String readableTypeName = ownerType.equals(accessedType) ? this.typeRegistry.getReadableTypeName(getprop.getFirstChild()) : ownerType.toString();
        this.compiler.report(t.makeError(getprop, BAD_PRIVATE_PROPERTY_ACCESS, propertyName, readableTypeName));
    }

    private void checkProtectedPropertyVisibility(NodeTraversal t, Node getprop, JSType ownerType) {
        JSType currentClass = this.getCurrentClass();
        if (currentClass == null || !currentClass.isSubtype(ownerType)) {
            String propertyName = getprop.getLastChild().getString();
            this.compiler.report(t.makeError(getprop, BAD_PROTECTED_PROPERTY_ACCESS, propertyName, this.typeRegistry.getReadableTypeName(getprop.getFirstChild())));
        }
    }

    private static boolean isValidPrivateConstructorAccess(Node parent) {
        return !parent.isNew();
    }

    private boolean shouldEmitDeprecationWarning(NodeTraversal t, Node n, Node parent) {
        if (!(!t.inGlobalScope() || parent.isCall() && parent.getFirstChild() == n || n.isNew())) {
            return false;
        }
        if (n.isGetProp() && n == parent.getFirstChild() && NodeUtil.isAssignmentOp(parent)) {
            return false;
        }
        if (n.isGetProp() && parent.isExprResult() && n.getJSDocInfo().isDeprecated()) {
            return false;
        }
        return !this.canAccessDeprecatedTypes(t);
    }

    private boolean canAccessDeprecatedTypes(NodeTraversal t) {
        Node scopeRoot = t.getScopeRoot();
        Node scopeRootParent = scopeRoot.getParent();
        return this.deprecatedDepth > 0 || CheckAccessControls.getTypeDeprecationInfo(t.getTypedScope().getTypeOfThis()) != null || scopeRootParent != null && scopeRootParent.isAssign() && CheckAccessControls.getTypeDeprecationInfo(this.getClassOfMethod(scopeRoot, scopeRootParent)) != null;
    }

    private static boolean isDeprecatedFunction(Node n) {
        JSType type;
        if (n.isFunction() && (type = n.getJSType()) != null) {
            return CheckAccessControls.getTypeDeprecationInfo(type) != null;
        }
        return false;
    }

    private static String getTypeDeprecationInfo(JSType type) {
        ObjectType implicitProto;
        if (type == null) {
            return null;
        }
        JSDocInfo info = type.getJSDocInfo();
        if (info != null && info.isDeprecated()) {
            if (info.getDeprecationReason() != null) {
                return info.getDeprecationReason();
            }
            return "";
        }
        ObjectType objType = ObjectType.cast(type);
        if (objType != null && (implicitProto = objType.getImplicitPrototype()) != null) {
            return CheckAccessControls.getTypeDeprecationInfo(implicitProto);
        }
        return null;
    }

    private boolean isPropertyDeclaredConstant(ObjectType objectType, String prop) {
        if (this.enforceCodingConventions && this.compiler.getCodingConvention().isConstant(prop)) {
            return true;
        }
        while (objectType != null) {
            JSDocInfo docInfo = objectType.getOwnPropertyJSDocInfo(prop);
            if (docInfo != null && docInfo.isConstant()) {
                return true;
            }
            objectType = objectType.getImplicitPrototype();
        }
        return false;
    }

    private static String getPropertyDeprecationInfo(ObjectType type, String prop) {
        JSDocInfo info = type.getOwnPropertyJSDocInfo(prop);
        if (info != null && info.isDeprecated()) {
            if (info.getDeprecationReason() != null) {
                return info.getDeprecationReason();
            }
            return "";
        }
        ObjectType implicitProto = type.getImplicitPrototype();
        if (implicitProto != null) {
            return CheckAccessControls.getPropertyDeprecationInfo(implicitProto, prop);
        }
        return null;
    }

    private static JSType dereference(JSType type) {
        return type == null ? null : type.dereference();
    }

    private static JSType getFinalParentClass(JSType type) {
        if (type != null) {
            ObjectType iproto;
            for (iproto = ObjectType.cast(type).getImplicitPrototype(); iproto != null && iproto.getConstructor() == null; iproto = iproto.getImplicitPrototype()) {
            }
            if (iproto != null) {
                JSDocInfo jsDoc;
                Node source = iproto.getConstructor().getSource();
                JSDocInfo jSDocInfo = jsDoc = source != null ? NodeUtil.getBestJSDocInfo(source) : null;
                if (jsDoc != null && jsDoc.isConstant()) {
                    return iproto;
                }
            }
        }
        return null;
    }
}

