/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.GlobalNamespace;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TagNameToType;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class PolymerPass
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    static final DiagnosticType POLYMER_DESCRIPTOR_NOT_VALID = DiagnosticType.error("JSC_POLYMER_DESCRIPTOR_NOT_VALID", "The class descriptor must be an object literal.");
    static final DiagnosticType POLYMER_MISSING_IS = DiagnosticType.error("JSC_POLYMER_MISSING_IS", "The class descriptor must include an 'is' property.");
    static final DiagnosticType POLYMER_UNEXPECTED_PARAMS = DiagnosticType.error("JSC_POLYMER_UNEXPECTED_PARAMS", "The class definition has too many arguments.");
    static final DiagnosticType POLYMER_MISSING_EXTERNS = DiagnosticType.error("JSC_POLYMER_MISSING_EXTERNS", "Missing Polymer externs.");
    static final DiagnosticType POLYMER_INVALID_PROPERTY = DiagnosticType.error("JSC_POLYMER_INVALID_PROPERTY", "Polymer property has an invalid or missing type.");
    static final DiagnosticType POLYMER_INVALID_BEHAVIOR_ARRAY = DiagnosticType.error("JSC_POLYMER_INVALID_BEHAVIOR_ARRAY", "The behaviors property must be an array literal.");
    static final DiagnosticType POLYMER_UNQUALIFIED_BEHAVIOR = DiagnosticType.error("JSC_POLYMER_UNQUALIFIED_BEHAVIOR", "Behaviors must be global, fully qualified names which are declared as object literals or array literals of other valid Behaviors.");
    static final DiagnosticType POLYMER_UNANNOTATED_BEHAVIOR = DiagnosticType.error("JSC_POLYMER_UNANNOTATED_BEHAVIOR", "Behavior declarations must be annotated with @polymerBehavior.");
    static final String VIRTUAL_FILE = "<PolymerPass.java>";
    private final AbstractCompiler compiler;
    private Node polymerElementExterns;
    private Set<String> nativeExternsAdded;
    private final Map<String, String> tagNameMap;
    private List<Node> polymerElementProps;
    private Set<String> lifecycleCallbacks;
    private GlobalNamespace globalNames;

    public PolymerPass(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.tagNameMap = TagNameToType.getMap();
        this.polymerElementProps = new ArrayList<Node>();
        this.nativeExternsAdded = new HashSet<String>();
        this.lifecycleCallbacks = ImmutableSet.of((Object)"created", (Object)"attached", (Object)"detached", (Object)"attributeChanged", (Object)"configure", (Object)"ready", (Object[])new String[0]);
    }

    @Override
    public void process(Node externs, Node root) {
        FindPolymerExterns externsCallback = new FindPolymerExterns();
        NodeTraversal.traverse(this.compiler, externs, externsCallback);
        this.polymerElementExterns = externsCallback.polymerElementExterns;
        this.polymerElementProps = externsCallback.getpolymerElementProps();
        if (this.polymerElementExterns == null) {
            this.compiler.report(JSError.make(externs, POLYMER_MISSING_EXTERNS, new String[0]));
            return;
        }
        this.globalNames = new GlobalNamespace(this.compiler, externs, root);
        this.hotSwapScript(root, null);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverse(this.compiler, scriptRoot, this);
        SuppressBehaviors suppressBehaviorsCallback = new SuppressBehaviors(this.compiler);
        NodeTraversal.traverse(this.compiler, scriptRoot, suppressBehaviorsCallback);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (PolymerPass.isPolymerCall(n)) {
            this.rewriteClassDefinition(n, parent, t);
        }
    }

    private void rewriteClassDefinition(Node n, Node parent, NodeTraversal t) {
        ClassDefinition def = this.extractClassDefinition(n);
        if (def != null) {
            if (NodeUtil.isNameDeclaration(parent.getParent()) || parent.isAssign()) {
                this.rewritePolymerClass(parent.getParent(), def, t);
            } else {
                this.rewritePolymerClass(parent, def, t);
            }
        }
    }

    private ClassDefinition extractClassDefinition(Node callNode) {
        Node descriptor = NodeUtil.getArgumentForCallOrNew(callNode, 0);
        if (descriptor == null || !descriptor.isObjectLit()) {
            this.compiler.report(JSError.make(callNode, POLYMER_DESCRIPTOR_NOT_VALID, new String[0]));
            return null;
        }
        int paramCount = callNode.getChildCount() - 1;
        if (paramCount != 1) {
            this.compiler.report(JSError.make(callNode, POLYMER_UNEXPECTED_PARAMS, new String[0]));
            return null;
        }
        Node elName = NodeUtil.getFirstPropMatchingKey(descriptor, "is");
        if (elName == null) {
            this.compiler.report(JSError.make(callNode, POLYMER_MISSING_IS, new String[0]));
            return null;
        }
        String elNameString = CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_CAMEL, elName.getString());
        elNameString = elNameString + "Element";
        Node target = NodeUtil.isNameDeclaration(callNode.getParent().getParent()) ? IR.name(callNode.getParent().getString()) : (callNode.getParent().isAssign() ? callNode.getParent().getFirstChild().cloneTree() : IR.name(elNameString));
        target.useSourceInfoIfMissingFrom(callNode);
        JSDocInfo classInfo = NodeUtil.getBestJSDocInfo(target);
        JSDocInfo ctorInfo = null;
        Node constructor = NodeUtil.getFirstPropMatchingKey(descriptor, "factoryImpl");
        if (constructor == null) {
            constructor = IR.function(IR.name(""), IR.paramList(), IR.block());
            constructor.useSourceInfoFromForTree(callNode);
        } else {
            ctorInfo = NodeUtil.getBestJSDocInfo(constructor);
        }
        Node baseClass = NodeUtil.getFirstPropMatchingKey(descriptor, "extends");
        String nativeBaseElement = baseClass == null ? null : baseClass.getString();
        Node behaviorArray = NodeUtil.getFirstPropMatchingKey(descriptor, "behaviors");
        List<BehaviorDefinition> behaviors = this.extractBehaviors(behaviorArray);
        ImmutableList.Builder allProperties = ImmutableList.builder();
        allProperties.addAll(PolymerPass.extractProperties(descriptor));
        for (BehaviorDefinition behavior : behaviors) {
            allProperties.addAll(behavior.props);
        }
        ClassDefinition def = new ClassDefinition(target, classInfo, new MemberDefinition(ctorInfo, null, constructor), nativeBaseElement, (List<MemberDefinition>)allProperties.build(), behaviors);
        return def;
    }

    private List<BehaviorDefinition> extractBehaviors(Node behaviorArray) {
        if (behaviorArray == null) {
            return ImmutableList.of();
        }
        if (!behaviorArray.isArrayLit()) {
            this.compiler.report(JSError.make(behaviorArray, POLYMER_INVALID_BEHAVIOR_ARRAY, new String[0]));
            return ImmutableList.of();
        }
        ImmutableList.Builder behaviors = ImmutableList.builder();
        for (Node behaviorName : behaviorArray.children()) {
            Node behaviorValue;
            if (behaviorName.isObjectLit()) {
                behaviors.add((Object)new BehaviorDefinition(PolymerPass.extractProperties(behaviorName), this.getBehaviorFunctionsToCopy(behaviorName)));
                continue;
            }
            GlobalNamespace.Name behaviorGlobalName = this.globalNames.getSlot(behaviorName.getQualifiedName());
            if (behaviorGlobalName == null || behaviorGlobalName.getDeclaration() == null) {
                this.compiler.report(JSError.make(behaviorName, POLYMER_UNQUALIFIED_BEHAVIOR, new String[0]));
                continue;
            }
            Node behaviorDeclaration = behaviorGlobalName.getDeclaration().getNode();
            JSDocInfo behaviorInfo = NodeUtil.getBestJSDocInfo(behaviorDeclaration);
            if (behaviorInfo == null || !behaviorInfo.isPolymerBehavior()) {
                this.compiler.report(JSError.make(behaviorDeclaration, POLYMER_UNANNOTATED_BEHAVIOR, new String[0]));
            }
            if ((behaviorValue = NodeUtil.getRValueOfLValue(behaviorDeclaration)).isArrayLit()) {
                behaviors.addAll(this.extractBehaviors(behaviorValue));
                continue;
            }
            if (behaviorValue == null || !behaviorValue.isObjectLit()) {
                this.compiler.report(JSError.make(behaviorName, POLYMER_UNQUALIFIED_BEHAVIOR, new String[0]));
                continue;
            }
            behaviors.add((Object)new BehaviorDefinition(PolymerPass.extractProperties(behaviorValue), this.getBehaviorFunctionsToCopy(behaviorValue)));
        }
        return behaviors.build();
    }

    private List<MemberDefinition> getBehaviorFunctionsToCopy(Node behaviorObjLit) {
        Preconditions.checkState((boolean)behaviorObjLit.isObjectLit());
        ImmutableList.Builder functionsToCopy = ImmutableList.builder();
        for (Node keyNode : behaviorObjLit.children()) {
            if (!keyNode.isStringKey() || !keyNode.getFirstChild().isFunction() || this.lifecycleCallbacks.contains(keyNode.getString())) continue;
            functionsToCopy.add((Object)new MemberDefinition(NodeUtil.getBestJSDocInfo(keyNode), keyNode, keyNode.getFirstChild()));
        }
        return functionsToCopy.build();
    }

    private static List<MemberDefinition> extractProperties(Node descriptor) {
        Node properties = NodeUtil.getFirstPropMatchingKey(descriptor, "properties");
        if (properties == null) {
            return ImmutableList.of();
        }
        ImmutableList.Builder members = ImmutableList.builder();
        for (Node keyNode : properties.children()) {
            members.add((Object)new MemberDefinition(NodeUtil.getBestJSDocInfo(keyNode), keyNode, keyNode.getFirstChild()));
        }
        return members.build();
    }

    private void rewritePolymerClass(Node exprRoot, ClassDefinition cls, NodeTraversal t) {
        Node call = exprRoot.getFirstChild();
        if (call.isAssign()) {
            call = call.getChildAtIndex(1);
        } else if (call.isName()) {
            call = call.getFirstChild();
        }
        Node objLit = NodeUtil.getArgumentForCallOrNew(call, 0);
        JSDocInfoBuilder objLitDoc = new JSDocInfoBuilder(true);
        objLitDoc.recordLends(cls.target.getQualifiedName() + ".prototype");
        objLit.setJSDocInfo(objLitDoc.build());
        this.addThisTypeToFunctions(objLit, cls.target.getQualifiedName());
        this.switchDollarSignPropsToBrackets(objLit);
        Node block = IR.block();
        if (cls.nativeBaseElement != null) {
            this.appendPolymerElementExterns(cls);
        }
        JSDocInfoBuilder constructorDoc = this.getConstructorDoc(cls);
        Node ctorKey = cls.constructor.value.getParent();
        if (ctorKey != null) {
            ctorKey.removeProp(29);
        }
        if (cls.target.isGetProp()) {
            Node assign = IR.assign(cls.target.cloneTree(), cls.constructor.value.cloneTree());
            assign.setJSDocInfo(constructorDoc.build());
            Node exprResult = IR.exprResult(assign);
            block.addChildToBack(exprResult);
        } else {
            Node var = IR.var(cls.target.cloneTree(), cls.constructor.value.cloneTree());
            var.setJSDocInfo(constructorDoc.build());
            block.addChildToBack(var);
        }
        this.appendPropertiesToBlock(cls, block, cls.target.getQualifiedName() + ".prototype.");
        this.appendBehaviorFunctionsToBlock(cls, block);
        List<MemberDefinition> readOnlyProps = this.parseReadOnlyProperties(cls, block);
        this.addInterfaceExterns(cls, readOnlyProps);
        this.removePropertyDocs(cls);
        block.useSourceInfoFromForTree(exprRoot);
        Node stmts = block.removeChildren();
        Node parent = exprRoot.getParent();
        if (!t.getScope().isGlobal() && !cls.target.isGetProp()) {
            Node scriptNode = NodeUtil.getEnclosingScript(exprRoot);
            scriptNode.addChildrenToFront(stmts);
        } else {
            Node beforeRoot = parent.getChildBefore(exprRoot);
            if (beforeRoot == null) {
                parent.addChildrenToFront(stmts);
            } else {
                parent.addChildrenAfter(stmts, beforeRoot);
            }
        }
        if (exprRoot.isVar()) {
            Node assignExpr = PolymerPass.varToAssign(exprRoot);
            parent.replaceChild(exprRoot, assignExpr);
        }
        this.compiler.reportCodeChange();
    }

    private void addThisTypeToFunctions(Node objLit, String thisType) {
        Preconditions.checkState((boolean)objLit.isObjectLit());
        for (Node keyNode : objLit.children()) {
            Node value = keyNode.getFirstChild();
            if (value == null || !value.isFunction()) continue;
            JSDocInfoBuilder fnDoc = JSDocInfoBuilder.maybeCopyFrom(keyNode.getJSDocInfo());
            fnDoc.recordThisType(new JSTypeExpression(new Node(306, IR.string(thisType)), VIRTUAL_FILE));
            keyNode.setJSDocInfo(fnDoc.build());
        }
    }

    private void switchDollarSignPropsToBrackets(Node objLit) {
        Preconditions.checkState((boolean)objLit.isObjectLit());
        for (Node keyNode : objLit.children()) {
            Node value = keyNode.getFirstChild();
            if (value == null || !value.isFunction()) continue;
            NodeUtil.visitPostOrder(value.getLastChild(), new NodeUtil.Visitor(){

                @Override
                public void visit(Node n) {
                    if (n.isString() && n.getString().equals("$") && n.getParent().isGetProp() && n.getParent().getParent().isGetProp()) {
                        Node dollarChildProp = n.getParent().getParent();
                        dollarChildProp.setType(35);
                        PolymerPass.this.compiler.reportCodeChange();
                    }
                }
            }, (Predicate<Node>)Predicates.alwaysTrue());
        }
    }

    private void appendPropertiesToBlock(ClassDefinition cls, Node block, String basePath) {
        for (MemberDefinition prop : cls.props) {
            Node propertyNode = IR.exprResult(NodeUtil.newQName(this.compiler, basePath + prop.name.getString()));
            JSDocInfoBuilder info = JSDocInfoBuilder.maybeCopyFrom(prop.info);
            JSTypeExpression propType = this.getTypeFromProperty(prop);
            if (propType == null) {
                return;
            }
            info.recordType(propType);
            propertyNode.getFirstChild().setJSDocInfo(info.build());
            block.addChildToBack(propertyNode);
        }
    }

    private void removePropertyDocs(ClassDefinition cls) {
        for (MemberDefinition prop : cls.props) {
            prop.name.removeProp(29);
        }
    }

    private void appendBehaviorFunctionsToBlock(ClassDefinition cls, Node block) {
        String qualifiedPath = cls.target.getQualifiedName() + ".prototype.";
        HashMap<String, Node> nameToExprResult = new HashMap<String, Node>();
        for (BehaviorDefinition behavior : cls.behaviors) {
            for (MemberDefinition behaviorFunction : behavior.functionsToCopy) {
                String fnName = behaviorFunction.name.getString();
                if (nameToExprResult.containsKey(fnName)) {
                    block.removeChild((Node)nameToExprResult.get(fnName));
                }
                Node exprResult = IR.exprResult(IR.assign(NodeUtil.newQName(this.compiler, qualifiedPath + fnName), behaviorFunction.value.cloneTree()));
                JSDocInfoBuilder info = JSDocInfoBuilder.maybeCopyFrom(behaviorFunction.info);
                exprResult.getFirstChild().setJSDocInfo(info.build());
                block.addChildToBack(exprResult);
                nameToExprResult.put(fnName, exprResult);
            }
        }
    }

    private List<MemberDefinition> parseReadOnlyProperties(ClassDefinition cls, Node block) {
        String qualifiedPath = cls.target.getQualifiedName() + ".prototype.";
        ImmutableList.Builder readOnlyProps = ImmutableList.builder();
        for (MemberDefinition prop : cls.props) {
            Node readOnlyValue;
            if (!prop.value.isObjectLit() || (readOnlyValue = NodeUtil.getFirstPropMatchingKey(prop.value, "readOnly")) == null || !readOnlyValue.isTrue()) continue;
            block.addChildToBack(this.makeReadOnlySetter(prop.name.getString(), qualifiedPath));
            readOnlyProps.add((Object)prop);
        }
        return readOnlyProps.build();
    }

    private JSTypeExpression getTypeFromProperty(MemberDefinition property) {
        String typeString = "";
        if (property.value.isObjectLit()) {
            Node typeValue = NodeUtil.getFirstPropMatchingKey(property.value, "type");
            if (typeValue == null) {
                this.compiler.report(JSError.make(property.name, POLYMER_INVALID_PROPERTY, new String[0]));
                return null;
            }
            typeString = typeValue.getString();
        } else if (property.value.isName()) {
            typeString = property.value.getString();
        }
        Node typeNode = null;
        switch (typeString) {
            case "Boolean": 
            case "String": 
            case "Number": {
                typeNode = IR.string(typeString.toLowerCase());
                break;
            }
            case "Array": 
            case "Function": 
            case "Object": 
            case "Date": {
                typeNode = new Node(306, IR.string(typeString));
                break;
            }
            default: {
                this.compiler.report(JSError.make(property.name, POLYMER_INVALID_PROPERTY, new String[0]));
                return null;
            }
        }
        return new JSTypeExpression(typeNode, VIRTUAL_FILE);
    }

    private Node makeReadOnlySetter(String propName, String qualifiedPath) {
        String setterName = "_set" + propName.substring(0, 1).toUpperCase() + propName.substring(1);
        Node fnNode = IR.function(IR.name(""), IR.paramList(IR.name(propName)), IR.block());
        Node exprResNode = IR.exprResult(IR.assign(NodeUtil.newQName(this.compiler, qualifiedPath + setterName), fnNode));
        JSDocInfoBuilder info = new JSDocInfoBuilder(true);
        info.recordOverride();
        exprResNode.getFirstChild().setJSDocInfo(info.build());
        return exprResNode;
    }

    private void appendPolymerElementExterns(ClassDefinition cls) {
        if (!this.nativeExternsAdded.add(cls.nativeBaseElement)) {
            return;
        }
        Node block = IR.block();
        Node baseExterns = this.polymerElementExterns.cloneTree();
        String polymerElementType = PolymerPass.getPolymerElementType(cls);
        baseExterns.getFirstChild().setString(polymerElementType);
        String elementType = this.tagNameMap.get(cls.nativeBaseElement);
        JSTypeExpression elementBaseType = new JSTypeExpression(new Node(306, IR.string(elementType)), VIRTUAL_FILE);
        JSDocInfoBuilder baseDocs = JSDocInfoBuilder.copyFrom(baseExterns.getJSDocInfo());
        baseDocs.changeBaseType(elementBaseType);
        baseExterns.setJSDocInfo(baseDocs.build());
        block.addChildToBack(baseExterns);
        for (Node baseProp : this.polymerElementProps) {
            Node newProp = baseProp.cloneTree();
            Node newPropRootName = NodeUtil.getRootOfQualifiedName(newProp.getFirstChild().getFirstChild());
            newPropRootName.setString(polymerElementType);
            block.addChildToBack(newProp);
        }
        Node parent = this.polymerElementExterns.getParent();
        Node stmts = block.removeChildren();
        parent.addChildrenAfter(stmts, this.polymerElementExterns);
        this.compiler.reportCodeChange();
    }

    private void addInterfaceExterns(ClassDefinition cls, List<MemberDefinition> readOnlyProps) {
        Node block = IR.block();
        String interfaceName = this.getInterfaceName(cls);
        Node fnNode = IR.function(IR.name(""), IR.paramList(), IR.block());
        Node varNode = IR.var(NodeUtil.newQName(this.compiler, interfaceName), fnNode);
        JSDocInfoBuilder info = new JSDocInfoBuilder(true);
        info.recordInterface();
        varNode.setJSDocInfo(info.build());
        block.addChildToBack(varNode);
        this.appendPropertiesToBlock(cls, block, interfaceName + ".prototype.");
        for (MemberDefinition prop : readOnlyProps) {
            String propName = prop.name.getString();
            String setterName = "_set" + propName.substring(0, 1).toUpperCase() + propName.substring(1);
            Node setterExprNode = IR.exprResult(NodeUtil.newQName(this.compiler, interfaceName + ".prototype." + setterName));
            JSDocInfoBuilder setterInfo = new JSDocInfoBuilder(true);
            JSTypeExpression propType = this.getTypeFromProperty(prop);
            setterInfo.recordParameter(propName, propType);
            setterExprNode.getFirstChild().setJSDocInfo(setterInfo.build());
            block.addChildToBack(setterExprNode);
        }
        Node parent = this.polymerElementExterns.getParent();
        Node stmts = block.removeChildren();
        parent.addChildrenToBack(stmts);
        this.compiler.reportCodeChange();
    }

    private String getInterfaceName(ClassDefinition cls) {
        return "Polymer" + cls.target.getQualifiedName().replaceAll("\\.", "_") + "Interface";
    }

    private JSDocInfoBuilder getConstructorDoc(ClassDefinition cls) {
        JSDocInfoBuilder constructorDoc = JSDocInfoBuilder.maybeCopyFrom(cls.constructor.info);
        constructorDoc.recordConstructor();
        JSTypeExpression baseType = new JSTypeExpression(new Node(306, IR.string(PolymerPass.getPolymerElementType(cls))), VIRTUAL_FILE);
        constructorDoc.recordBaseType(baseType);
        String interfaceName = this.getInterfaceName(cls);
        JSTypeExpression interfaceType = new JSTypeExpression(new Node(306, IR.string(interfaceName)), VIRTUAL_FILE);
        constructorDoc.recordImplementedInterface(interfaceType);
        return constructorDoc;
    }

    private static Node varToAssign(Node var) {
        Node assign = IR.assign(IR.name(var.getFirstChild().getString()), var.getFirstChild().removeFirstChild());
        return IR.exprResult(assign).useSourceInfoFromForTree(var);
    }

    private static String getPolymerElementType(ClassDefinition cls) {
        return String.format("Polymer%sElement", cls.nativeBaseElement == null ? "" : CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_CAMEL, cls.nativeBaseElement));
    }

    private static boolean isPolymerCall(Node value) {
        return value != null && value.isCall() && value.getFirstChild().matchesQualifiedName("Polymer");
    }

    private static final class ClassDefinition {
        final Node target;
        final MemberDefinition constructor;
        final String nativeBaseElement;
        final List<MemberDefinition> props;
        final List<BehaviorDefinition> behaviors;

        ClassDefinition(Node target, JSDocInfo classInfo, MemberDefinition constructor, String nativeBaseElement, List<MemberDefinition> props, List<BehaviorDefinition> behaviors) {
            this.target = target;
            this.constructor = constructor;
            this.nativeBaseElement = nativeBaseElement;
            this.props = props;
            this.behaviors = behaviors;
        }
    }

    private static final class BehaviorDefinition {
        final List<MemberDefinition> props;
        final List<MemberDefinition> functionsToCopy;

        BehaviorDefinition(List<MemberDefinition> props, List<MemberDefinition> functionsToCopy) {
            this.props = props;
            this.functionsToCopy = functionsToCopy;
        }
    }

    private static class MemberDefinition {
        final JSDocInfo info;
        final Node name;
        final Node value;

        MemberDefinition(JSDocInfo info, Node name, Node value) {
            this.info = info;
            this.name = name;
            this.value = value;
        }
    }

    private static class SuppressBehaviors
    extends NodeTraversal.AbstractPostOrderCallback {
        private final AbstractCompiler compiler;

        public SuppressBehaviors(AbstractCompiler compiler) {
            this.compiler = compiler;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (this.isBehavior(n)) {
                if (!n.isVar() && !n.isAssign()) {
                    this.compiler.report(JSError.make(n, POLYMER_UNQUALIFIED_BEHAVIOR, new String[0]));
                    return;
                }
                JSDocInfoBuilder newDocs = JSDocInfoBuilder.maybeCopyFrom(n.getJSDocInfo());
                newDocs.recordNoCollapse();
                n.setJSDocInfo(newDocs.build());
                Node behaviorValue = n.getChildAtIndex(1);
                if (n.isVar()) {
                    behaviorValue = n.getFirstChild().getFirstChild();
                }
                this.suppressBehavior(behaviorValue);
            }
        }

        private boolean isBehavior(Node value) {
            return value.getJSDocInfo() != null && value.getJSDocInfo().isPolymerBehavior();
        }

        private void suppressBehavior(Node behaviorValue) {
            if (behaviorValue == null) {
                this.compiler.report(JSError.make(behaviorValue, POLYMER_UNQUALIFIED_BEHAVIOR, new String[0]));
                return;
            }
            if (behaviorValue.isArrayLit()) {
                for (Node child : behaviorValue.children()) {
                    this.suppressBehavior(child);
                }
            } else if (behaviorValue.isObjectLit()) {
                this.stripPropertyTypes(behaviorValue);
                this.addBehaviorSuppressions(behaviorValue);
            }
        }

        private void stripPropertyTypes(Node behaviorValue) {
            List properties = PolymerPass.extractProperties(behaviorValue);
            for (MemberDefinition property : properties) {
                property.name.removeProp(29);
            }
        }

        private void addBehaviorSuppressions(Node behaviorValue) {
            for (Node keyNode : behaviorValue.children()) {
                if (!keyNode.getFirstChild().isFunction()) continue;
                keyNode.removeProp(29);
                JSDocInfoBuilder suppressDoc = new JSDocInfoBuilder(true);
                suppressDoc.addSuppression("checkTypes");
                suppressDoc.addSuppression("globalThis");
                keyNode.setJSDocInfo(suppressDoc.build());
            }
        }
    }

    private static class FindPolymerExterns
    extends NodeTraversal.AbstractPostOrderCallback {
        private Node polymerElementExterns;
        private ImmutableList.Builder<Node> polymerElementProps = ImmutableList.builder();
        private static final String POLYMER_ELEMENT_NAME = "PolymerElement";

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (this.isPolymerElementExterns(n)) {
                this.polymerElementExterns = n;
            } else if (this.isPolymerElementPropExpr(n)) {
                this.polymerElementProps.add((Object)n);
            }
        }

        private boolean isPolymerElementExterns(Node value) {
            return value != null && value.isVar() && value.getFirstChild().matchesQualifiedName(POLYMER_ELEMENT_NAME);
        }

        private boolean isPolymerElementPropExpr(Node value) {
            return value != null && value.isExprResult() && value.getFirstChild().isAssign() && value.getFirstChild().getFirstChild().isGetProp() && NodeUtil.getRootOfQualifiedName(value.getFirstChild().getFirstChild()).matchesQualifiedName(POLYMER_ELEMENT_NAME);
        }

        public List<Node> getpolymerElementProps() {
            return this.polymerElementProps.build();
        }
    }
}

