/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.TypeValidator;
import com.google.javascript.jscomp.graph.StandardUnionFind;
import com.google.javascript.jscomp.graph.UnionFind;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.StaticTypedScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Logger;
import java.util.regex.Pattern;

class DisambiguateProperties<T>
implements CompilerPass {
    private static final int MAX_INVALDIATION_WARNINGS_PER_PROPERTY = 10;
    private static final Logger logger = Logger.getLogger(DisambiguateProperties.class.getName());
    private static final Pattern NONWORD_PATTERN = Pattern.compile("[^\\w$]");
    private final AbstractCompiler compiler;
    private final TypeSystem<T> typeSystem;
    private Multimap<Object, JSError> invalidationMap;
    private final Map<String, CheckLevel> propertiesToErrorFor;
    private Map<String, Property> properties = new HashMap<String, Property>();

    static DisambiguateProperties<JSType> forJSTypeSystem(AbstractCompiler compiler, Map<String, CheckLevel> propertiesToErrorFor) {
        return new DisambiguateProperties<JSType>(compiler, new JSTypeSystem(compiler), propertiesToErrorFor);
    }

    private DisambiguateProperties(AbstractCompiler compiler, TypeSystem<T> typeSystem, Map<String, CheckLevel> propertiesToErrorFor) {
        this.compiler = compiler;
        this.typeSystem = typeSystem;
        this.propertiesToErrorFor = propertiesToErrorFor;
        this.invalidationMap = !this.propertiesToErrorFor.isEmpty() ? LinkedHashMultimap.create() : null;
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkState((this.compiler.getLifeCycleStage() == AbstractCompiler.LifeCycleStage.NORMALIZED ? 1 : 0) != 0);
        for (TypeValidator.TypeMismatch mis : this.compiler.getTypeMismatches()) {
            this.addInvalidatingType(mis.typeA, mis.src);
            this.addInvalidatingType(mis.typeB, mis.src);
        }
        NodeTraversal.traverse(this.compiler, externs, new FindExternProperties());
        NodeTraversal.traverse(this.compiler, root, new FindRenameableProperties());
        this.renameProperties();
    }

    private void recordInvalidationError(JSType t, JSError error) {
        if (!t.isObject()) {
            return;
        }
        if (this.invalidationMap != null) {
            this.invalidationMap.put((Object)t, (Object)error);
        }
    }

    private void addInvalidatingType(JSType type, JSError error) {
        if ((type = type.restrictByNotNullOrUndefined()).isUnionType()) {
            for (JSType alt : type.toMaybeUnionType().getAlternates()) {
                this.addInvalidatingType(alt, error);
            }
        } else if (type.isEnumElementType()) {
            this.addInvalidatingType(type.toMaybeEnumElementType().getPrimitiveType(), error);
        } else {
            this.typeSystem.addInvalidatingType(type);
            this.recordInvalidationError(type, error);
            ObjectType objType = ObjectType.cast(type);
            if (objType != null && objType.getImplicitPrototype() != null) {
                this.typeSystem.addInvalidatingType(objType.getImplicitPrototype());
                this.recordInvalidationError(objType.getImplicitPrototype(), error);
            }
        }
    }

    protected Property getProperty(String name) {
        if (!this.properties.containsKey(name)) {
            this.properties.put(name, new Property(name));
        }
        return this.properties.get(name);
    }

    T getTypeWithProperty(String field, T type) {
        return this.typeSystem.getTypeWithProperty(field, type);
    }

    void renameProperties() {
        int propsRenamed = 0;
        int propsSkipped = 0;
        int instancesRenamed = 0;
        int instancesSkipped = 0;
        int singleTypeProps = 0;
        HashSet<String> reported = new HashSet<String>();
        for (Property prop : this.properties.values()) {
            if (prop.shouldRename()) {
                Map propNames = this.buildPropNames(prop.getTypes(), prop.name);
                ++propsRenamed;
                prop.expandTypesToSkip();
                for (Node node : prop.renameNodes) {
                    Object rootType = prop.rootTypes.get(node);
                    if (prop.shouldRename(rootType)) {
                        String newName = propNames.get(rootType);
                        node.setString(newName);
                        this.compiler.reportCodeChange();
                        ++instancesRenamed;
                        continue;
                    }
                    ++instancesSkipped;
                    CheckLevel checkLevelForProp = this.propertiesToErrorFor.get(prop.name);
                    if (checkLevelForProp == null || checkLevelForProp == CheckLevel.OFF || reported.contains(prop.name)) continue;
                    reported.add(prop.name);
                    this.compiler.report(JSError.make(node, checkLevelForProp, Warnings.INVALIDATION_ON_TYPE, prop.name, rootType.toString(), ""));
                }
                continue;
            }
            if (prop.skipRenaming) {
                ++propsSkipped;
                continue;
            }
            ++singleTypeProps;
        }
        logger.fine("Renamed " + instancesRenamed + " instances of " + propsRenamed + " properties.");
        logger.fine("Skipped renaming " + instancesSkipped + " invalidated " + "properties, " + propsSkipped + " instances of properties " + "that were skipped for specific types and " + singleTypeProps + " properties that were referenced from only one type.");
    }

    private Map<T, String> buildPropNames(UnionFind<T> types, String name) {
        HashMap<T, String> names = new HashMap<T, String>();
        for (Set<T> set : types.allEquivalenceClasses()) {
            Preconditions.checkState((!set.isEmpty() ? 1 : 0) != 0);
            String typeName = null;
            for (T type : set) {
                if (typeName != null && type.toString().compareTo(typeName) >= 0) continue;
                typeName = type.toString();
            }
            String newName = "{...}".equals(typeName) ? name : NONWORD_PATTERN.matcher(typeName).replaceAll("_") + '$' + name;
            for (T type : set) {
                names.put(type, newName);
            }
        }
        return names;
    }

    Multimap<String, Collection<T>> getRenamedTypesForTesting() {
        HashMultimap ret = HashMultimap.create();
        for (Map.Entry<String, Property> entry : this.properties.entrySet()) {
            Property prop = entry.getValue();
            if (prop.skipRenaming) continue;
            for (Collection collection : prop.getTypes().allEquivalenceClasses()) {
                if (collection.isEmpty() || prop.typesToSkip.contains(collection.iterator().next())) continue;
                ret.put((Object)entry.getKey(), (Object)collection);
            }
        }
        return ret;
    }

    private static class JSTypeSystem
    implements TypeSystem<JSType> {
        private final Set<JSType> invalidatingTypes;
        private final Map<FunctionType, Iterable<ObjectType>> implementedInterfaces;
        private JSTypeRegistry registry;

        public JSTypeSystem(AbstractCompiler compiler) {
            this.registry = compiler.getTypeRegistry();
            this.implementedInterfaces = new HashMap<FunctionType, Iterable<ObjectType>>();
            this.invalidatingTypes = new HashSet<JSType>((Collection<JSType>)ImmutableSet.of((Object)this.registry.getNativeType(JSTypeNative.ALL_TYPE), (Object)this.registry.getNativeType(JSTypeNative.NO_OBJECT_TYPE), (Object)this.registry.getNativeType(JSTypeNative.NO_TYPE), (Object)this.registry.getNativeType(JSTypeNative.FUNCTION_PROTOTYPE), (Object)this.registry.getNativeType(JSTypeNative.FUNCTION_INSTANCE_TYPE), (Object)this.registry.getNativeType(JSTypeNative.OBJECT_PROTOTYPE), (Object[])new JSType[]{this.registry.getNativeType(JSTypeNative.TOP_LEVEL_PROTOTYPE), this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE)}));
        }

        @Override
        public void addInvalidatingType(JSType type) {
            Preconditions.checkState((!type.isUnionType() ? 1 : 0) != 0);
            this.invalidatingTypes.add(type);
        }

        @Override
        public StaticTypedScope<JSType> getRootScope() {
            return null;
        }

        @Override
        public StaticTypedScope<JSType> getFunctionScope(Node node) {
            return null;
        }

        @Override
        public JSType getType(StaticTypedScope<JSType> scope, Node node, String prop) {
            if (node.getJSType() == null) {
                return this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            }
            return node.getJSType();
        }

        @Override
        public boolean isInvalidatingType(JSType type) {
            if (type == null || this.invalidatingTypes.contains(type) || type.isUnknownType()) {
                return true;
            }
            ObjectType objType = ObjectType.cast(type);
            return objType != null && !objType.hasReferenceName();
        }

        @Override
        public ImmutableSet<JSType> getTypesToSkipForType(JSType type) {
            if ((type = type.restrictByNotNullOrUndefined()).isUnionType()) {
                ImmutableSet.Builder types = ImmutableSet.builder();
                types.add((Object)type);
                for (JSType alt : type.toMaybeUnionType().getAlternates()) {
                    types.addAll(JSTypeSystem.getTypesToSkipForTypeNonUnion(alt));
                }
                return types.build();
            }
            if (type.isEnumElementType()) {
                return this.getTypesToSkipForType(type.toMaybeEnumElementType().getPrimitiveType());
            }
            return ImmutableSet.copyOf(JSTypeSystem.getTypesToSkipForTypeNonUnion(type));
        }

        private static Set<JSType> getTypesToSkipForTypeNonUnion(JSType type) {
            HashSet<JSType> types = new HashSet<JSType>();
            JSType skipType = type;
            while (skipType != null) {
                types.add(skipType);
                ObjectType objSkipType = skipType.toObjectType();
                if (objSkipType == null) break;
                skipType = objSkipType.getImplicitPrototype();
            }
            return types;
        }

        @Override
        public boolean isTypeToSkip(JSType type) {
            return type.isEnumType() || type.autoboxesTo() != null;
        }

        @Override
        public JSType restrictByNotNullOrUndefined(JSType type) {
            return type.restrictByNotNullOrUndefined();
        }

        @Override
        public Iterable<JSType> getTypeAlternatives(JSType type) {
            if (type.isUnionType()) {
                return type.toMaybeUnionType().getAlternates();
            }
            ObjectType objType = type.toObjectType();
            if (objType != null && objType.getConstructor() != null && objType.getConstructor().isInterface()) {
                ArrayList<JSType> list = new ArrayList<JSType>();
                for (FunctionType impl : this.registry.getDirectImplementors(objType)) {
                    list.add(impl.getInstanceType());
                }
                return list;
            }
            return null;
        }

        @Override
        public ObjectType getTypeWithProperty(String field, JSType type) {
            ObjectType maybeType;
            if (type == null) {
                return null;
            }
            if (type.isEnumElementType()) {
                return this.getTypeWithProperty(field, type.toMaybeEnumElementType().getPrimitiveType());
            }
            if (!(type instanceof ObjectType)) {
                if (type.autoboxesTo() != null) {
                    type = type.autoboxesTo();
                } else {
                    return null;
                }
            }
            if ("prototype".equals(field)) {
                return null;
            }
            JSType foundType = null;
            ObjectType objType = ObjectType.cast(type);
            if (objType != null && objType.getConstructor() != null && objType.getConstructor().isInterface()) {
                ObjectType topInterface = FunctionType.getTopDefiningInterface(objType, field);
                if (topInterface != null && topInterface.getConstructor() != null) {
                    foundType = topInterface.getConstructor().getPrototype();
                }
            } else {
                while (objType != null && objType.getImplicitPrototype() != objType) {
                    if (objType.hasOwnProperty(field)) {
                        foundType = objType;
                    }
                    objType = objType.getImplicitPrototype();
                }
            }
            if (foundType == null && (maybeType = ObjectType.cast(this.registry.getGreatestSubtypeWithProperty(type, field))) != null && maybeType.hasOwnProperty(field)) {
                foundType = maybeType;
            }
            if (foundType != null && foundType.isTemplatizedType()) {
                foundType = foundType.toMaybeTemplatizedType().getReferencedType();
            }
            return foundType;
        }

        @Override
        public JSType getInstanceFromPrototype(JSType type) {
            ObjectType prototype;
            FunctionType owner;
            if (type.isFunctionPrototypeType() && ((owner = (prototype = (ObjectType)type).getOwnerFunction()).isConstructor() || owner.isInterface())) {
                return prototype.getOwnerFunction().getInstanceType();
            }
            return null;
        }

        @Override
        public void recordInterfaces(JSType type, JSType relatedType, Property p) {
            ObjectType objType = ObjectType.cast(type);
            if (objType == null) {
                return;
            }
            FunctionType constructor = objType.isFunctionType() ? objType.toMaybeFunctionType() : (objType.isFunctionPrototypeType() ? objType.getOwnerFunction() : objType.getConstructor());
            if (constructor == null) {
                return;
            }
            Iterable<ObjectType> interfaces = this.implementedInterfaces.get(constructor);
            if (interfaces == null) {
                interfaces = constructor.getImplementedInterfaces();
                this.implementedInterfaces.put(constructor, interfaces);
            }
            for (ObjectType itype : interfaces) {
                ObjectType top = this.getTypeWithProperty(p.name, itype);
                if (top != null) {
                    p.addType(itype, top, relatedType);
                } else {
                    this.recordInterfaces(itype, relatedType, p);
                }
                if (!p.skipRenaming) continue;
                return;
            }
        }
    }

    private static interface TypeSystem<T> {
        public StaticTypedScope<T> getRootScope();

        public StaticTypedScope<T> getFunctionScope(Node var1);

        public T getType(StaticTypedScope<T> var1, Node var2, String var3);

        public boolean isInvalidatingType(T var1);

        public void addInvalidatingType(JSType var1);

        public ImmutableSet<T> getTypesToSkipForType(T var1);

        public boolean isTypeToSkip(T var1);

        public T restrictByNotNullOrUndefined(T var1);

        public Iterable<T> getTypeAlternatives(T var1);

        public T getTypeWithProperty(String var1, T var2);

        public T getInstanceFromPrototype(T var1);

        public void recordInterfaces(T var1, T var2, Property var3);
    }

    private class FindRenameableProperties
    extends AbstractScopingCallback {
        private FindRenameableProperties() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isGetProp()) {
                this.handleGetProp(t, n);
            } else if (n.isObjectLit()) {
                this.handleObjectLit(t, n);
            }
        }

        private void handleGetProp(NodeTraversal t, Node n) {
            String name = n.getLastChild().getString();
            Object type = DisambiguateProperties.this.typeSystem.getType(this.getScope(), n.getFirstChild(), name);
            Property prop = DisambiguateProperties.this.getProperty(name);
            if (!prop.scheduleRenaming(n.getLastChild(), this.processProperty(t, prop, type, null)) && DisambiguateProperties.this.propertiesToErrorFor.containsKey(name)) {
                String suggestion = "";
                if (type instanceof JSType) {
                    JSType jsType = (JSType)type;
                    if (jsType.isAllType() || jsType.isUnknownType()) {
                        if (n.getFirstChild().isThis()) {
                            suggestion = "The \"this\" object is unknown in the function,consider using @this";
                        } else {
                            String qName = n.getFirstChild().getQualifiedName();
                            suggestion = "Consider casting " + qName + " if you know it's type.";
                        }
                    } else {
                        ArrayList<String> errors = new ArrayList<String>();
                        this.printErrorLocations(errors, jsType);
                        if (!errors.isEmpty()) {
                            suggestion = "Consider fixing errors for the following types:\n";
                            suggestion = suggestion + Joiner.on((String)"\n").join(errors);
                        }
                    }
                }
                DisambiguateProperties.this.compiler.report(JSError.make(n, (CheckLevel)((Object)DisambiguateProperties.this.propertiesToErrorFor.get(name)), Warnings.INVALIDATION, name, String.valueOf(type), n.toString(), suggestion));
            }
        }

        private void handleObjectLit(NodeTraversal t, Node n) {
            for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
                if (child.isQuotedString()) continue;
                String name = child.getString();
                Object type = DisambiguateProperties.this.typeSystem.getType(this.getScope(), n, name);
                Property prop = DisambiguateProperties.this.getProperty(name);
                if (prop.scheduleRenaming(child, this.processProperty(t, prop, type, null)) || !DisambiguateProperties.this.propertiesToErrorFor.containsKey(name)) continue;
                DisambiguateProperties.this.compiler.report(JSError.make(child, (CheckLevel)((Object)DisambiguateProperties.this.propertiesToErrorFor.get(name)), Warnings.INVALIDATION, name, String.valueOf(type), n.toString(), ""));
            }
        }

        private void printErrorLocations(List<String> errors, JSType t) {
            if (!t.isObject() || t.isAllType()) {
                return;
            }
            if (t.isUnionType()) {
                for (JSType alt : t.toMaybeUnionType().getAlternates()) {
                    this.printErrorLocations(errors, alt);
                }
                return;
            }
            for (JSError error : DisambiguateProperties.this.invalidationMap.get((Object)t)) {
                if (errors.size() > 10) {
                    return;
                }
                errors.add(t + " at " + error.sourceName + ":" + error.lineNumber);
            }
        }

        private T processProperty(NodeTraversal t, Property prop, T type, T relatedType) {
            type = DisambiguateProperties.this.typeSystem.restrictByNotNullOrUndefined(type);
            if (prop.skipRenaming || DisambiguateProperties.this.typeSystem.isInvalidatingType(type)) {
                return null;
            }
            Iterable alternatives = DisambiguateProperties.this.typeSystem.getTypeAlternatives(type);
            if (alternatives != null) {
                Object firstType = relatedType;
                for (Object subType : alternatives) {
                    Object lastType = this.processProperty(t, prop, subType, firstType);
                    if (lastType == null) continue;
                    firstType = firstType == null ? lastType : firstType;
                }
                return firstType;
            }
            Object topType = DisambiguateProperties.this.typeSystem.getTypeWithProperty(prop.name, type);
            if (DisambiguateProperties.this.typeSystem.isInvalidatingType(topType)) {
                return null;
            }
            prop.addType(type, topType, relatedType);
            return topType;
        }
    }

    private class FindExternProperties
    extends AbstractScopingCallback {
        private FindExternProperties() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isGetProp()) {
                String field = n.getLastChild().getString();
                Object type = DisambiguateProperties.this.typeSystem.getType(this.getScope(), n.getFirstChild(), field);
                Property prop = DisambiguateProperties.this.getProperty(field);
                if (DisambiguateProperties.this.typeSystem.isInvalidatingType(type)) {
                    prop.invalidate();
                } else {
                    prop.addTypeToSkip(type);
                    type = DisambiguateProperties.this.typeSystem.getInstanceFromPrototype(type);
                    if (type != null) {
                        prop.getTypes().add(type);
                        prop.typesToSkip.add(type);
                    }
                }
            }
        }
    }

    private abstract class AbstractScopingCallback
    implements NodeTraversal.ScopedCallback {
        protected final Stack<StaticTypedScope<T>> scopes = new Stack();

        private AbstractScopingCallback() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            return true;
        }

        @Override
        public void enterScope(NodeTraversal t) {
            if (t.inGlobalScope()) {
                this.scopes.push(DisambiguateProperties.this.typeSystem.getRootScope());
            } else {
                this.scopes.push(DisambiguateProperties.this.typeSystem.getFunctionScope(t.getScopeRoot()));
            }
        }

        @Override
        public void exitScope(NodeTraversal t) {
            this.scopes.pop();
        }

        protected StaticTypedScope<T> getScope() {
            return this.scopes.peek();
        }
    }

    private class Property {
        final String name;
        private UnionFind<T> types;
        Set<T> typesToSkip = new HashSet();
        boolean skipRenaming;
        Set<Node> renameNodes = new HashSet<Node>();
        final Map<Node, T> rootTypes = new HashMap();

        Property(String name) {
            this.name = name;
        }

        UnionFind<T> getTypes() {
            if (this.types == null) {
                this.types = new StandardUnionFind();
            }
            return this.types;
        }

        boolean addType(T type, T top, T relatedType) {
            Preconditions.checkState((!this.skipRenaming ? 1 : 0) != 0, (String)"Attempt to record skipped property: %s", (Object[])new Object[]{this.name});
            if (DisambiguateProperties.this.typeSystem.isInvalidatingType(top)) {
                this.invalidate();
                return false;
            }
            if (DisambiguateProperties.this.typeSystem.isTypeToSkip(top)) {
                this.addTypeToSkip(top);
            }
            if (relatedType == null) {
                this.getTypes().add(top);
            } else {
                this.getTypes().union(top, relatedType);
            }
            DisambiguateProperties.this.typeSystem.recordInterfaces(type, top, this);
            return true;
        }

        void addTypeToSkip(T type) {
            for (Object skipType : DisambiguateProperties.this.typeSystem.getTypesToSkipForType(type)) {
                this.typesToSkip.add(skipType);
                this.getTypes().union(skipType, type);
            }
        }

        void expandTypesToSkip() {
            block4: {
                int originalTypesSize;
                if (!this.shouldRename()) break block4;
                int count = 0;
                do {
                    Preconditions.checkState((++count < 10 ? 1 : 0) != 0, (Object)"Stuck in loop expanding types to skip.");
                    HashSet rootTypesToSkip = new HashSet();
                    for (Object subType : this.typesToSkip) {
                        rootTypesToSkip.add(this.types.find(subType));
                    }
                    this.typesToSkip.addAll(rootTypesToSkip);
                    HashSet newTypesToSkip = new HashSet();
                    Set allTypes = this.types.elements();
                    originalTypesSize = allTypes.size();
                    for (Object subType : allTypes) {
                        if (this.typesToSkip.contains(subType) || !this.typesToSkip.contains(this.types.find(subType))) continue;
                        newTypesToSkip.add(subType);
                    }
                    for (Object newType : newTypesToSkip) {
                        this.addTypeToSkip(newType);
                    }
                } while (this.types.elements().size() != originalTypesSize);
            }
        }

        boolean shouldRename() {
            return !this.skipRenaming && this.types != null && this.types.allEquivalenceClasses().size() > 1;
        }

        boolean shouldRename(T type) {
            return !this.skipRenaming && !this.typesToSkip.contains(type);
        }

        boolean invalidate() {
            boolean changed = !this.skipRenaming;
            this.skipRenaming = true;
            this.types = null;
            return changed;
        }

        boolean scheduleRenaming(Node node, T type) {
            if (!this.skipRenaming) {
                if (DisambiguateProperties.this.typeSystem.isInvalidatingType(type)) {
                    this.invalidate();
                    return false;
                }
                this.renameNodes.add(node);
                this.rootTypes.put(node, type);
            }
            return true;
        }
    }

    static class Warnings {
        static final DiagnosticType INVALIDATION = DiagnosticType.disabled("JSC_INVALIDATION", "Property disambiguator skipping all instances of property {0} because of type {1} node {2}. {3}");
        static final DiagnosticType INVALIDATION_ON_TYPE = DiagnosticType.disabled("JSC_INVALIDATION_TYPE", "Property disambiguator skipping instances of property {0} on type {1}. {2}");

        Warnings() {
        }
    }
}

