/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.parsing.parser;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.parsing.parser.IdentifierToken;
import com.google.javascript.jscomp.parsing.parser.Keywords;
import com.google.javascript.jscomp.parsing.parser.LiteralToken;
import com.google.javascript.jscomp.parsing.parser.Scanner;
import com.google.javascript.jscomp.parsing.parser.SourceFile;
import com.google.javascript.jscomp.parsing.parser.Token;
import com.google.javascript.jscomp.parsing.parser.TokenType;
import com.google.javascript.jscomp.parsing.parser.trees.ArgumentListTree;
import com.google.javascript.jscomp.parsing.parser.trees.ArrayLiteralExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ArrayPatternTree;
import com.google.javascript.jscomp.parsing.parser.trees.AssignmentRestElementTree;
import com.google.javascript.jscomp.parsing.parser.trees.BinaryOperatorTree;
import com.google.javascript.jscomp.parsing.parser.trees.BlockTree;
import com.google.javascript.jscomp.parsing.parser.trees.BreakStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.CallExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.CaseClauseTree;
import com.google.javascript.jscomp.parsing.parser.trees.CatchTree;
import com.google.javascript.jscomp.parsing.parser.trees.ClassDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.CommaExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.Comment;
import com.google.javascript.jscomp.parsing.parser.trees.ComprehensionForTree;
import com.google.javascript.jscomp.parsing.parser.trees.ComprehensionIfTree;
import com.google.javascript.jscomp.parsing.parser.trees.ComprehensionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ComputedPropertyDefinitionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ComputedPropertyGetterTree;
import com.google.javascript.jscomp.parsing.parser.trees.ComputedPropertyMethodTree;
import com.google.javascript.jscomp.parsing.parser.trees.ComputedPropertySetterTree;
import com.google.javascript.jscomp.parsing.parser.trees.ConditionalExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ContinueStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.DebuggerStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.DefaultClauseTree;
import com.google.javascript.jscomp.parsing.parser.trees.DefaultParameterTree;
import com.google.javascript.jscomp.parsing.parser.trees.DoWhileStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.EmptyStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.ExportDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.ExportSpecifierTree;
import com.google.javascript.jscomp.parsing.parser.trees.ExpressionStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.FinallyTree;
import com.google.javascript.jscomp.parsing.parser.trees.ForInStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.ForOfStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.ForStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.FormalParameterListTree;
import com.google.javascript.jscomp.parsing.parser.trees.FunctionDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.GetAccessorTree;
import com.google.javascript.jscomp.parsing.parser.trees.IdentifierExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.IfStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.ImportDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.ImportSpecifierTree;
import com.google.javascript.jscomp.parsing.parser.trees.LabelledStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.LiteralExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.MemberExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.MemberLookupExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.MissingPrimaryExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.NewExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.NullTree;
import com.google.javascript.jscomp.parsing.parser.trees.ObjectLiteralExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ObjectPatternTree;
import com.google.javascript.jscomp.parsing.parser.trees.ParenExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ParseTree;
import com.google.javascript.jscomp.parsing.parser.trees.ParseTreeType;
import com.google.javascript.jscomp.parsing.parser.trees.PostfixExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ProgramTree;
import com.google.javascript.jscomp.parsing.parser.trees.PropertyNameAssignmentTree;
import com.google.javascript.jscomp.parsing.parser.trees.RestParameterTree;
import com.google.javascript.jscomp.parsing.parser.trees.ReturnStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.SetAccessorTree;
import com.google.javascript.jscomp.parsing.parser.trees.SpreadExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.SuperExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.SwitchStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.TemplateLiteralExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.TemplateLiteralPortionTree;
import com.google.javascript.jscomp.parsing.parser.trees.TemplateSubstitutionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ThisExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.ThrowStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.TryStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.UnaryExpressionTree;
import com.google.javascript.jscomp.parsing.parser.trees.VariableDeclarationListTree;
import com.google.javascript.jscomp.parsing.parser.trees.VariableDeclarationTree;
import com.google.javascript.jscomp.parsing.parser.trees.VariableStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.WhileStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.WithStatementTree;
import com.google.javascript.jscomp.parsing.parser.trees.YieldExpressionTree;
import com.google.javascript.jscomp.parsing.parser.util.ErrorReporter;
import com.google.javascript.jscomp.parsing.parser.util.LookaheadErrorReporter;
import com.google.javascript.jscomp.parsing.parser.util.SourcePosition;
import com.google.javascript.jscomp.parsing.parser.util.SourceRange;
import com.google.javascript.jscomp.parsing.parser.util.Timer;
import java.util.ArrayDeque;
import java.util.EnumSet;
import java.util.List;

public class Parser {
    private final Scanner scanner;
    private final ErrorReporter errorReporter;
    private Token lastToken;
    private final Config config;
    private final CommentRecorder commentRecorder = new CommentRecorder();
    private final ArrayDeque<Boolean> inGeneratorContext = new ArrayDeque();
    private static final EnumSet<TokenType> arraySubPatternFollowSet = EnumSet.of(TokenType.COMMA, TokenType.CLOSE_SQUARE, TokenType.EQUAL);

    public Parser(Config config, ErrorReporter errorReporter, SourceFile source, int offset, boolean initialGeneratorContext) {
        this.config = config;
        this.errorReporter = errorReporter;
        this.scanner = new Scanner(errorReporter, this.commentRecorder, source, offset);
        this.inGeneratorContext.add(initialGeneratorContext);
    }

    public Parser(Config config, ErrorReporter errorReporter, SourceFile source, int offset) {
        this(config, errorReporter, source, offset, false);
    }

    public Parser(Config config, ErrorReporter errorReporter, SourceFile source) {
        this(config, errorReporter, source, 0);
    }

    public List<Comment> getComments() {
        return this.commentRecorder.getComments();
    }

    public ProgramTree parseProgram() {
        Timer t = new Timer("Parse Program");
        try {
            SourcePosition start = this.getTreeStartLocation();
            ImmutableList<ParseTree> sourceElements = this.parseGlobalSourceElements();
            this.eat(TokenType.END_OF_FILE);
            t.end();
            return new ProgramTree(this.getTreeLocation(start), sourceElements, (ImmutableList<Comment>)this.commentRecorder.getComments());
        }
        catch (StackOverflowError e) {
            this.reportError("Too deep recursion while parsing", new Object[0]);
            return null;
        }
    }

    private ImmutableList<ParseTree> parseGlobalSourceElements() {
        ImmutableList.Builder result = ImmutableList.builder();
        while (!this.peek(TokenType.END_OF_FILE)) {
            result.add((Object)this.parseScriptElement());
        }
        return result.build();
    }

    private ParseTree parseScriptElement() {
        if (this.peekImportDeclaration()) {
            return this.parseImportDeclaration();
        }
        if (this.peekExportDeclaration()) {
            return this.parseExportDeclaration();
        }
        return this.parseSourceElement();
    }

    private boolean peekImportDeclaration() {
        return this.peek(TokenType.IMPORT);
    }

    private ParseTree parseImportDeclaration() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.IMPORT);
        if (this.peek(TokenType.STRING)) {
            LiteralToken moduleSpecifier = this.eat(TokenType.STRING).asLiteral();
            this.eatPossibleImplicitSemiColon();
            return new ImportDeclarationTree(this.getTreeLocation(start), null, null, null, moduleSpecifier);
        }
        IdentifierToken defaultBindingIdentifier = null;
        IdentifierToken nameSpaceImportIdentifier = null;
        ImmutableList<ParseTree> identifierSet = null;
        boolean parseExplicitNames = true;
        if (this.peekId()) {
            defaultBindingIdentifier = this.eatId();
            if (this.peek(TokenType.COMMA)) {
                this.eat(TokenType.COMMA);
            } else {
                parseExplicitNames = false;
            }
        }
        if (parseExplicitNames) {
            if (this.peek(TokenType.STAR)) {
                this.eat(TokenType.STAR);
                this.eatPredefinedString("as");
                nameSpaceImportIdentifier = this.eatId();
            } else {
                identifierSet = this.parseImportSpecifierSet();
            }
        }
        this.eatPredefinedString("from");
        Token moduleStr = this.eat(TokenType.STRING);
        LiteralToken moduleSpecifier = moduleStr == null ? null : moduleStr.asLiteral();
        this.eatPossibleImplicitSemiColon();
        return new ImportDeclarationTree(this.getTreeLocation(start), defaultBindingIdentifier, identifierSet, nameSpaceImportIdentifier, moduleSpecifier);
    }

    private ImmutableList<ParseTree> parseImportSpecifierSet() {
        ImmutableList.Builder elements = ImmutableList.builder();
        this.eat(TokenType.OPEN_CURLY);
        while (this.peekId()) {
            elements.add((Object)this.parseImportSpecifier());
            if (this.peek(TokenType.CLOSE_CURLY)) continue;
            this.eat(TokenType.COMMA);
        }
        this.eat(TokenType.CLOSE_CURLY);
        return elements.build();
    }

    private ParseTree parseImportSpecifier() {
        SourcePosition start = this.getTreeStartLocation();
        IdentifierToken importedName = this.eatId();
        IdentifierToken destinationName = null;
        if (this.peekPredefinedString("as")) {
            this.eatPredefinedString("as");
            destinationName = this.eatId();
        }
        return new ImportSpecifierTree(this.getTreeLocation(start), importedName, destinationName);
    }

    private boolean peekExportDeclaration() {
        return this.peek(TokenType.EXPORT);
    }

    private ParseTree parseExportDeclaration() {
        SourcePosition start = this.getTreeStartLocation();
        boolean isDefault = false;
        boolean isExportAll = false;
        boolean isExportSpecifier = false;
        this.eat(TokenType.EXPORT);
        ParseTree export = null;
        ImmutableList<ParseTree> exportSpecifierList = null;
        switch (this.peekType()) {
            case STAR: {
                isExportAll = true;
                this.nextToken();
                break;
            }
            case FUNCTION: {
                export = this.parseFunctionDeclaration();
                break;
            }
            case CLASS: {
                export = this.parseClassDeclaration();
                break;
            }
            case DEFAULT: {
                isDefault = true;
                this.nextToken();
                export = this.parseExpression();
                break;
            }
            case OPEN_CURLY: {
                isExportSpecifier = true;
                exportSpecifierList = this.parseExportSpecifierSet();
                break;
            }
            default: {
                export = this.parseVariableDeclarationList();
            }
        }
        LiteralToken moduleSpecifier = null;
        if (isExportAll || isExportSpecifier && this.peekPredefinedString("from")) {
            this.eatPredefinedString("from");
            moduleSpecifier = this.eat(TokenType.STRING).asLiteral();
        }
        this.eatPossibleImplicitSemiColon();
        return new ExportDeclarationTree(this.getTreeLocation(start), isDefault, isExportAll, export, exportSpecifierList, moduleSpecifier);
    }

    private ImmutableList<ParseTree> parseExportSpecifierSet() {
        ImmutableList.Builder elements = ImmutableList.builder();
        this.eat(TokenType.OPEN_CURLY);
        while (this.peekId()) {
            elements.add((Object)this.parseExportSpecifier());
            if (this.peek(TokenType.CLOSE_CURLY)) continue;
            this.eat(TokenType.COMMA);
        }
        this.eat(TokenType.CLOSE_CURLY);
        return elements.build();
    }

    private ParseTree parseExportSpecifier() {
        SourcePosition start = this.getTreeStartLocation();
        IdentifierToken importedName = this.eatId();
        IdentifierToken destinationName = null;
        if (this.peekPredefinedString("as")) {
            this.eatPredefinedString("as");
            destinationName = this.eatId();
        }
        return new ExportSpecifierTree(this.getTreeLocation(start), importedName, destinationName);
    }

    private boolean peekClassDeclaration() {
        return this.peek(TokenType.CLASS);
    }

    private ParseTree parseClassDeclaration() {
        return this.parseClass(false);
    }

    private ParseTree parseClassExpression() {
        return this.parseClass(true);
    }

    private ParseTree parseClass(boolean isExpression) {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.CLASS);
        IdentifierToken name = null;
        if (!isExpression || this.peekId()) {
            name = this.eatId();
        }
        ParseTree superClass = null;
        if (this.peek(TokenType.EXTENDS)) {
            this.eat(TokenType.EXTENDS);
            superClass = this.parseExpression();
        }
        this.eat(TokenType.OPEN_CURLY);
        ImmutableList<ParseTree> elements = this.parseClassElements();
        this.eat(TokenType.CLOSE_CURLY);
        return new ClassDeclarationTree(this.getTreeLocation(start), name, isExpression, superClass, elements);
    }

    private ImmutableList<ParseTree> parseClassElements() {
        ImmutableList.Builder result = ImmutableList.builder();
        while (this.peekClassElement()) {
            result.add((Object)this.parseClassElement());
        }
        return result.build();
    }

    private boolean peekClassElement() {
        Token token = this.peekToken();
        switch (token.type) {
            case STAR: 
            case IDENTIFIER: 
            case STATIC: 
            case OPEN_SQUARE: 
            case SEMI_COLON: {
                return true;
            }
        }
        return Keywords.isKeyword(token.type);
    }

    private ParseTree parseClassElement() {
        if (this.peek(TokenType.SEMI_COLON)) {
            return this.parseEmptyStatement();
        }
        if (this.peekGetAccessor(true)) {
            return this.parseGetAccessor();
        }
        if (this.peekSetAccessor(true)) {
            return this.parseSetAccessor();
        }
        return this.parseMethodDeclaration(true);
    }

    private ParseTree parseMethodDeclaration(boolean allowStatic) {
        SourcePosition start = this.getTreeStartLocation();
        boolean isStatic = false;
        if (allowStatic && this.peek(TokenType.STATIC) && this.peekType(1) != TokenType.OPEN_PAREN) {
            this.eat(TokenType.STATIC);
            isStatic = true;
        }
        boolean isGenerator = this.eatOpt(TokenType.STAR) != null;
        TokenType type = this.peekType();
        if (type == TokenType.IDENTIFIER || Keywords.isKeyword(type)) {
            IdentifierToken name = this.eatIdOrKeywordAsId();
            return this.parseFunctionTail(start, name, isStatic, isGenerator, FunctionDeclarationTree.Kind.MEMBER);
        }
        ParseTree name = this.parseComputedPropertyName();
        ParseTree function = this.parseFunctionTail(start, null, isStatic, isGenerator, FunctionDeclarationTree.Kind.EXPRESSION);
        return new ComputedPropertyMethodTree(this.getTreeLocation(start), name, function);
    }

    private ParseTree parseFunctionTail(SourcePosition start, IdentifierToken name, boolean isStatic, boolean isGenerator, FunctionDeclarationTree.Kind kind) {
        this.inGeneratorContext.addLast(isGenerator);
        FormalParameterListTree formalParameterList = this.parseFormalParameterList();
        BlockTree functionBody = this.parseFunctionBody();
        FunctionDeclarationTree declaration = new FunctionDeclarationTree(this.getTreeLocation(start), name, isStatic, isGenerator, kind, formalParameterList, functionBody);
        this.inGeneratorContext.removeLast();
        return declaration;
    }

    private ParseTree parseSourceElement() {
        if (this.peekFunction()) {
            return this.parseFunctionDeclaration();
        }
        if (this.peekClassDeclaration()) {
            return this.parseClassDeclaration();
        }
        if (this.peek(TokenType.LET)) {
            return this.parseVariableStatement();
        }
        return this.parseStatementStandard();
    }

    private boolean peekSourceElement() {
        return this.peekFunction() || this.peekStatementStandard() || this.peekDeclaration();
    }

    private boolean peekFunction() {
        return this.peekFunction(0);
    }

    private boolean peekDeclaration() {
        return this.peek(TokenType.LET) || this.peekClassDeclaration();
    }

    private boolean peekFunction(int index) {
        return this.peek(index, TokenType.FUNCTION);
    }

    private ParseTree parseArrowFunction(Expression expressionIn) {
        FormalParameterListTree formalParameterList;
        SourcePosition start = this.getTreeStartLocation();
        this.inGeneratorContext.addLast(false);
        if (this.peekId()) {
            IdentifierExpressionTree param = this.parseIdentifierExpression();
            formalParameterList = new FormalParameterListTree(this.getTreeLocation(start), (ImmutableList<ParseTree>)ImmutableList.of((Object)param));
        } else {
            formalParameterList = this.parseFormalParameterList();
        }
        this.eat(TokenType.ARROW);
        ParseTree functionBody = this.peek(TokenType.OPEN_CURLY) ? this.parseFunctionBody() : this.parseAssignment(expressionIn);
        FunctionDeclarationTree declaration = new FunctionDeclarationTree(this.getTreeLocation(start), null, false, false, FunctionDeclarationTree.Kind.ARROW, formalParameterList, functionBody);
        this.inGeneratorContext.removeLast();
        return declaration;
    }

    private boolean peekArrowFunction() {
        if (this.peekId() && this.peekType(1) == TokenType.ARROW) {
            return true;
        }
        if (this.peekType() == TokenType.OPEN_PAREN) {
            Parser p = this.createLookaheadParser();
            try {
                p.parseFormalParameterList();
                return p.peek(TokenType.ARROW);
            }
            catch (LookaheadErrorReporter.ParseException e) {
                return false;
            }
        }
        return false;
    }

    private ParseTree parseFunctionDeclaration() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(Keywords.FUNCTION.type);
        boolean isGenerator = this.eatOpt(TokenType.STAR) != null;
        IdentifierToken name = this.eatId();
        return this.parseFunctionTail(start, name, false, isGenerator, FunctionDeclarationTree.Kind.DECLARATION);
    }

    private ParseTree parseFunctionExpression() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(Keywords.FUNCTION.type);
        boolean isGenerator = this.eatOpt(TokenType.STAR) != null;
        IdentifierToken name = this.eatIdOpt();
        return this.parseFunctionTail(start, name, false, isGenerator, FunctionDeclarationTree.Kind.EXPRESSION);
    }

    private FormalParameterListTree parseFormalParameterList() {
        SourcePosition listStart = this.getTreeStartLocation();
        this.eat(TokenType.OPEN_PAREN);
        ImmutableList.Builder result = ImmutableList.builder();
        while (this.peek(TokenType.SPREAD) || this.peekId() || this.peek(TokenType.OPEN_SQUARE) || this.peek(TokenType.OPEN_CURLY)) {
            SourcePosition start = this.getTreeStartLocation();
            if (this.peek(TokenType.SPREAD)) {
                this.eat(TokenType.SPREAD);
                result.add((Object)new RestParameterTree(this.getTreeLocation(start), this.eatId()));
                break;
            }
            ParseTree parameter = this.peekId() ? this.parseIdentifierExpression() : (this.peek(TokenType.OPEN_SQUARE) ? this.parseArrayPattern(PatternKind.INITIALIZER) : this.parseObjectPattern(PatternKind.INITIALIZER));
            if (this.peek(TokenType.EQUAL)) {
                this.eat(TokenType.EQUAL);
                ParseTree defaultValue = this.parseAssignmentExpression();
                parameter = new DefaultParameterTree(this.getTreeLocation(start), parameter, defaultValue);
            }
            result.add((Object)parameter);
            if (this.peek(TokenType.CLOSE_PAREN)) continue;
            Token comma = this.eat(TokenType.COMMA);
            if (!this.peek(TokenType.CLOSE_PAREN)) continue;
            this.reportError(comma, "Invalid trailing comma in formal parameter list", new Object[0]);
        }
        this.eat(TokenType.CLOSE_PAREN);
        return new FormalParameterListTree(this.getTreeLocation(listStart), (ImmutableList<ParseTree>)result.build());
    }

    private BlockTree parseFunctionBody() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.OPEN_CURLY);
        ImmutableList<ParseTree> result = this.parseSourceElementList();
        this.eat(TokenType.CLOSE_CURLY);
        return new BlockTree(this.getTreeLocation(start), result);
    }

    private ImmutableList<ParseTree> parseSourceElementList() {
        ImmutableList.Builder result = ImmutableList.builder();
        while (this.peekSourceElement()) {
            result.add((Object)this.parseSourceElement());
        }
        return result.build();
    }

    private SpreadExpressionTree parseSpreadExpression() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.SPREAD);
        ParseTree operand = this.parseAssignmentExpression();
        return new SpreadExpressionTree(this.getTreeLocation(start), operand);
    }

    private ParseTree parseStatement() {
        return this.parseSourceElement();
    }

    private ParseTree parseStatementStandard() {
        switch (this.peekType()) {
            case OPEN_CURLY: {
                return this.parseBlock();
            }
            case VAR: 
            case CONST: {
                return this.parseVariableStatement();
            }
            case SEMI_COLON: {
                return this.parseEmptyStatement();
            }
            case IF: {
                return this.parseIfStatement();
            }
            case DO: {
                return this.parseDoWhileStatement();
            }
            case WHILE: {
                return this.parseWhileStatement();
            }
            case FOR: {
                return this.parseForStatement();
            }
            case CONTINUE: {
                return this.parseContinueStatement();
            }
            case BREAK: {
                return this.parseBreakStatement();
            }
            case RETURN: {
                return this.parseReturnStatement();
            }
            case WITH: {
                return this.parseWithStatement();
            }
            case SWITCH: {
                return this.parseSwitchStatement();
            }
            case THROW: {
                return this.parseThrowStatement();
            }
            case TRY: {
                return this.parseTryStatement();
            }
            case DEBUGGER: {
                return this.parseDebuggerStatement();
            }
        }
        if (this.peekLabelledStatement()) {
            return this.parseLabelledStatement();
        }
        return this.parseExpressionStatement();
    }

    private boolean peekStatement() {
        return this.peekSourceElement();
    }

    private boolean peekStatementStandard() {
        switch (this.peekType()) {
            case CLASS: 
            case OPEN_CURLY: 
            case VAR: 
            case CONST: 
            case IDENTIFIER: 
            case OPEN_SQUARE: 
            case SEMI_COLON: 
            case IF: 
            case DO: 
            case WHILE: 
            case FOR: 
            case CONTINUE: 
            case BREAK: 
            case RETURN: 
            case WITH: 
            case SWITCH: 
            case THROW: 
            case TRY: 
            case DEBUGGER: 
            case YIELD: 
            case THIS: 
            case SUPER: 
            case NUMBER: 
            case STRING: 
            case NO_SUBSTITUTION_TEMPLATE: 
            case TEMPLATE_HEAD: 
            case NULL: 
            case TRUE: 
            case SLASH: 
            case SLASH_EQUAL: 
            case FALSE: 
            case OPEN_PAREN: 
            case NEW: 
            case DELETE: 
            case VOID: 
            case TYPEOF: 
            case PLUS_PLUS: 
            case MINUS_MINUS: 
            case PLUS: 
            case MINUS: 
            case TILDE: 
            case BANG: {
                return true;
            }
        }
        return false;
    }

    private BlockTree parseBlock() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.OPEN_CURLY);
        ImmutableList<ParseTree> result = this.parseSourceElementList();
        this.eat(TokenType.CLOSE_CURLY);
        return new BlockTree(this.getTreeLocation(start), result);
    }

    private ImmutableList<ParseTree> parseStatementList() {
        ImmutableList.Builder result = ImmutableList.builder();
        while (this.peekStatement()) {
            result.add((Object)this.parseStatement());
        }
        return result.build();
    }

    private VariableStatementTree parseVariableStatement() {
        SourcePosition start = this.getTreeStartLocation();
        VariableDeclarationListTree declarations = this.parseVariableDeclarationList();
        this.eatPossibleImplicitSemiColon();
        return new VariableStatementTree(this.getTreeLocation(start), declarations);
    }

    private VariableDeclarationListTree parseVariableDeclarationList() {
        return this.parseVariableDeclarationList(Expression.NORMAL);
    }

    private VariableDeclarationListTree parseVariableDeclarationListNoIn() {
        return this.parseVariableDeclarationList(Expression.NO_IN);
    }

    private VariableDeclarationListTree parseVariableDeclarationList(Expression expressionIn) {
        TokenType token = this.peekType();
        switch (token) {
            case VAR: 
            case LET: 
            case CONST: {
                this.eat(token);
                break;
            }
            default: {
                this.reportError(this.peekToken(), "expected declaration", new Object[0]);
                return null;
            }
        }
        SourcePosition start = this.getTreeStartLocation();
        ImmutableList.Builder declarations = ImmutableList.builder();
        declarations.add((Object)this.parseVariableDeclaration(token, expressionIn));
        while (this.peek(TokenType.COMMA)) {
            this.eat(TokenType.COMMA);
            declarations.add((Object)this.parseVariableDeclaration(token, expressionIn));
        }
        return new VariableDeclarationListTree(this.getTreeLocation(start), token, (ImmutableList<VariableDeclarationTree>)declarations.build());
    }

    private VariableDeclarationTree parseVariableDeclaration(TokenType binding, Expression expressionIn) {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree lvalue = this.peekPattern(PatternKind.INITIALIZER) ? this.parsePattern(PatternKind.INITIALIZER) : this.parseIdentifierExpression();
        ParseTree initializer = null;
        if (this.peek(TokenType.EQUAL)) {
            initializer = this.parseInitializer(expressionIn);
        } else if (expressionIn != Expression.NO_IN) {
            if (binding == TokenType.CONST) {
                this.reportError("const variables must have an initializer", new Object[0]);
            } else if (lvalue.isPattern()) {
                this.reportError("destructuring must have an initializer", new Object[0]);
            }
        }
        return new VariableDeclarationTree(this.getTreeLocation(start), lvalue, initializer);
    }

    private ParseTree parseInitializer(Expression expressionIn) {
        this.eat(TokenType.EQUAL);
        return this.parseAssignment(expressionIn);
    }

    private EmptyStatementTree parseEmptyStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.SEMI_COLON);
        return new EmptyStatementTree(this.getTreeLocation(start));
    }

    private ExpressionStatementTree parseExpressionStatement() {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree expression = this.parseExpression();
        this.eatPossibleImplicitSemiColon();
        return new ExpressionStatementTree(this.getTreeLocation(start), expression);
    }

    private IfStatementTree parseIfStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.IF);
        this.eat(TokenType.OPEN_PAREN);
        ParseTree condition = this.parseExpression();
        this.eat(TokenType.CLOSE_PAREN);
        ParseTree ifClause = this.parseStatement();
        ParseTree elseClause = null;
        if (this.peek(TokenType.ELSE)) {
            this.eat(TokenType.ELSE);
            elseClause = this.parseStatement();
        }
        return new IfStatementTree(this.getTreeLocation(start), condition, ifClause, elseClause);
    }

    private ParseTree parseDoWhileStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.DO);
        ParseTree body = this.parseStatement();
        this.eat(TokenType.WHILE);
        this.eat(TokenType.OPEN_PAREN);
        ParseTree condition = this.parseExpression();
        this.eat(TokenType.CLOSE_PAREN);
        if (this.peek(TokenType.SEMI_COLON)) {
            this.eat(TokenType.SEMI_COLON);
        }
        return new DoWhileStatementTree(this.getTreeLocation(start), body, condition);
    }

    private ParseTree parseWhileStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.WHILE);
        this.eat(TokenType.OPEN_PAREN);
        ParseTree condition = this.parseExpression();
        this.eat(TokenType.CLOSE_PAREN);
        ParseTree body = this.parseStatement();
        return new WhileStatementTree(this.getTreeLocation(start), condition, body);
    }

    private ParseTree parseForStatement() {
        ParseTree initializer;
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.FOR);
        this.eat(TokenType.OPEN_PAREN);
        if (this.peekVariableDeclarationList()) {
            VariableDeclarationListTree variables = this.parseVariableDeclarationListNoIn();
            if (this.peek(TokenType.IN)) {
                if (variables.declarations.size() > 1) {
                    this.reportError("for-in statement may not have more than one variable declaration", new Object[0]);
                }
                VariableDeclarationTree declaration = (VariableDeclarationTree)variables.declarations.get(0);
                if (declaration.initializer != null) {
                    if (this.config.atLeast6) {
                        this.reportError("for-in statement may not have initializer", new Object[0]);
                    } else {
                        this.errorReporter.reportWarning(declaration.location.start, "for-in statement should not have initializer", new Object[0]);
                    }
                }
                return this.parseForInStatement(start, variables);
            }
            if (this.peekPredefinedString("of")) {
                if (variables.declarations.size() > 1) {
                    this.reportError("for-of statement may not have more than one variable declaration", new Object[0]);
                }
                VariableDeclarationTree declaration = (VariableDeclarationTree)variables.declarations.get(0);
                if (declaration.initializer != null) {
                    this.reportError("for-of statement may not have initializer", new Object[0]);
                }
                return this.parseForOfStatement(start, variables);
            }
            this.checkInitializers(variables);
            return this.parseForStatement(start, variables);
        }
        if (this.peek(TokenType.SEMI_COLON)) {
            return this.parseForStatement(start, null);
        }
        Predicate<Token> followPred = new Predicate<Token>(){

            public boolean apply(Token t) {
                return EnumSet.of(TokenType.IN, TokenType.EQUAL).contains((Object)t.type) || t.type == TokenType.IDENTIFIER && t.asIdentifier().value.equals("of");
            }
        };
        ParseTree parseTree = initializer = this.peekPattern(PatternKind.ANY, followPred) ? this.parsePattern(PatternKind.ANY) : this.parseExpressionNoIn();
        if ((this.peek(TokenType.IN) || this.peekPredefinedString("of")) && initializer.type != ParseTreeType.BINARY_OPERATOR) {
            if (this.peek(TokenType.IN)) {
                return this.parseForInStatement(start, initializer);
            }
            return this.parseForOfStatement(start, initializer);
        }
        return this.parseForStatement(start, initializer);
    }

    private ParseTree parseForOfStatement(SourcePosition start, ParseTree initializer) {
        this.eatPredefinedString("of");
        ParseTree collection = this.parseExpression();
        this.eat(TokenType.CLOSE_PAREN);
        ParseTree body = this.parseStatement();
        return new ForOfStatementTree(this.getTreeLocation(start), initializer, collection, body);
    }

    private void checkInitializers(VariableDeclarationListTree variables) {
        if (variables.declarationType == TokenType.LET || variables.declarationType == TokenType.CONST) {
            for (VariableDeclarationTree declaration : variables.declarations) {
                if (declaration.initializer != null) continue;
                this.reportError("let/const in for statement must have an initializer", new Object[0]);
                break;
            }
        }
    }

    private boolean peekVariableDeclarationList() {
        switch (this.peekType()) {
            case VAR: 
            case LET: 
            case CONST: {
                return true;
            }
        }
        return false;
    }

    private ParseTree parseForStatement(SourcePosition start, ParseTree initializer) {
        if (initializer == null) {
            initializer = new NullTree(this.getTreeLocation(this.getTreeStartLocation()));
        }
        this.eat(TokenType.SEMI_COLON);
        ParseTree condition = null;
        condition = !this.peek(TokenType.SEMI_COLON) ? this.parseExpression() : new NullTree(this.getTreeLocation(this.getTreeStartLocation()));
        this.eat(TokenType.SEMI_COLON);
        ParseTree increment = null;
        increment = !this.peek(TokenType.CLOSE_PAREN) ? this.parseExpression() : new NullTree(this.getTreeLocation(this.getTreeStartLocation()));
        this.eat(TokenType.CLOSE_PAREN);
        ParseTree body = this.parseStatement();
        return new ForStatementTree(this.getTreeLocation(start), initializer, condition, increment, body);
    }

    private ParseTree parseForInStatement(SourcePosition start, ParseTree initializer) {
        this.eat(TokenType.IN);
        ParseTree collection = this.parseExpression();
        this.eat(TokenType.CLOSE_PAREN);
        ParseTree body = this.parseStatement();
        return new ForInStatementTree(this.getTreeLocation(start), initializer, collection, body);
    }

    private ParseTree parseContinueStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.CONTINUE);
        IdentifierToken name = null;
        if (!this.peekImplicitSemiColon()) {
            name = this.eatIdOpt();
        }
        this.eatPossibleImplicitSemiColon();
        return new ContinueStatementTree(this.getTreeLocation(start), name);
    }

    private ParseTree parseBreakStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.BREAK);
        IdentifierToken name = null;
        if (!this.peekImplicitSemiColon()) {
            name = this.eatIdOpt();
        }
        this.eatPossibleImplicitSemiColon();
        return new BreakStatementTree(this.getTreeLocation(start), name);
    }

    private ParseTree parseReturnStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.RETURN);
        ParseTree expression = null;
        if (!this.peekImplicitSemiColon()) {
            expression = this.parseExpression();
        }
        this.eatPossibleImplicitSemiColon();
        return new ReturnStatementTree(this.getTreeLocation(start), expression);
    }

    private ParseTree parseWithStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.WITH);
        this.eat(TokenType.OPEN_PAREN);
        ParseTree expression = this.parseExpression();
        this.eat(TokenType.CLOSE_PAREN);
        ParseTree body = this.parseStatement();
        return new WithStatementTree(this.getTreeLocation(start), expression, body);
    }

    private ParseTree parseSwitchStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.SWITCH);
        this.eat(TokenType.OPEN_PAREN);
        ParseTree expression = this.parseExpression();
        this.eat(TokenType.CLOSE_PAREN);
        this.eat(TokenType.OPEN_CURLY);
        ImmutableList<ParseTree> caseClauses = this.parseCaseClauses();
        this.eat(TokenType.CLOSE_CURLY);
        return new SwitchStatementTree(this.getTreeLocation(start), expression, caseClauses);
    }

    private ImmutableList<ParseTree> parseCaseClauses() {
        boolean foundDefaultClause = false;
        ImmutableList.Builder result = ImmutableList.builder();
        block4: while (true) {
            SourcePosition start = this.getTreeStartLocation();
            switch (this.peekType()) {
                case CASE: {
                    this.eat(TokenType.CASE);
                    ParseTree expression = this.parseExpression();
                    this.eat(TokenType.COLON);
                    ImmutableList<ParseTree> statements = this.parseCaseStatementsOpt();
                    result.add((Object)new CaseClauseTree(this.getTreeLocation(start), expression, statements));
                    continue block4;
                }
                case DEFAULT: {
                    if (foundDefaultClause) {
                        this.reportError("Switch statements may have at most one default clause", new Object[0]);
                    } else {
                        foundDefaultClause = true;
                    }
                    this.eat(TokenType.DEFAULT);
                    this.eat(TokenType.COLON);
                    result.add((Object)new DefaultClauseTree(this.getTreeLocation(start), this.parseCaseStatementsOpt()));
                    continue block4;
                }
            }
            break;
        }
        return result.build();
    }

    private ImmutableList<ParseTree> parseCaseStatementsOpt() {
        return this.parseStatementList();
    }

    private ParseTree parseLabelledStatement() {
        SourcePosition start = this.getTreeStartLocation();
        IdentifierToken name = this.eatId();
        this.eat(TokenType.COLON);
        return new LabelledStatementTree(this.getTreeLocation(start), name, this.parseStatement());
    }

    private boolean peekLabelledStatement() {
        return this.peekId() && this.peek(1, TokenType.COLON);
    }

    private ParseTree parseThrowStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.THROW);
        ParseTree value = null;
        if (this.peekImplicitSemiColon()) {
            this.reportError("semicolon/newline not allowed after 'throw'", new Object[0]);
        } else {
            value = this.parseExpression();
        }
        this.eatPossibleImplicitSemiColon();
        return new ThrowStatementTree(this.getTreeLocation(start), value);
    }

    private ParseTree parseTryStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.TRY);
        BlockTree body = this.parseBlock();
        CatchTree catchBlock = null;
        if (this.peek(TokenType.CATCH)) {
            catchBlock = this.parseCatch();
        }
        FinallyTree finallyBlock = null;
        if (this.peek(TokenType.FINALLY)) {
            finallyBlock = this.parseFinallyBlock();
        }
        if (catchBlock == null && finallyBlock == null) {
            this.reportError("'catch' or 'finally' expected.", new Object[0]);
        }
        return new TryStatementTree(this.getTreeLocation(start), body, catchBlock, finallyBlock);
    }

    private CatchTree parseCatch() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.CATCH);
        this.eat(TokenType.OPEN_PAREN);
        ParseTree exception = this.peekPattern(PatternKind.INITIALIZER) ? this.parsePattern(PatternKind.INITIALIZER) : this.parseIdentifierExpression();
        this.eat(TokenType.CLOSE_PAREN);
        BlockTree catchBody = this.parseBlock();
        CatchTree catchBlock = new CatchTree(this.getTreeLocation(start), exception, catchBody);
        return catchBlock;
    }

    private FinallyTree parseFinallyBlock() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.FINALLY);
        BlockTree finallyBlock = this.parseBlock();
        return new FinallyTree(this.getTreeLocation(start), finallyBlock);
    }

    private ParseTree parseDebuggerStatement() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.DEBUGGER);
        this.eatPossibleImplicitSemiColon();
        return new DebuggerStatementTree(this.getTreeLocation(start));
    }

    private ParseTree parsePrimaryExpression() {
        switch (this.peekType()) {
            case CLASS: {
                return this.parseClassExpression();
            }
            case SUPER: {
                return this.parseSuperExpression();
            }
            case THIS: {
                return this.parseThisExpression();
            }
            case IDENTIFIER: {
                return this.parseIdentifierExpression();
            }
            case NUMBER: 
            case STRING: 
            case NULL: 
            case TRUE: 
            case FALSE: {
                return this.parseLiteralExpression();
            }
            case NO_SUBSTITUTION_TEMPLATE: 
            case TEMPLATE_HEAD: {
                return this.parseTemplateLiteral(null);
            }
            case OPEN_SQUARE: {
                return this.parseArrayInitializer();
            }
            case OPEN_CURLY: {
                return this.parseObjectLiteral();
            }
            case OPEN_PAREN: {
                return this.parseParenExpression();
            }
            case SLASH: 
            case SLASH_EQUAL: {
                return this.parseRegularExpressionLiteral();
            }
        }
        return this.parseMissingPrimaryExpression();
    }

    private SuperExpressionTree parseSuperExpression() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.SUPER);
        return new SuperExpressionTree(this.getTreeLocation(start));
    }

    private ThisExpressionTree parseThisExpression() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.THIS);
        return new ThisExpressionTree(this.getTreeLocation(start));
    }

    private IdentifierExpressionTree parseIdentifierExpression() {
        SourcePosition start = this.getTreeStartLocation();
        IdentifierToken identifier = this.eatId();
        return new IdentifierExpressionTree(this.getTreeLocation(start), identifier);
    }

    private LiteralExpressionTree parseLiteralExpression() {
        SourcePosition start = this.getTreeStartLocation();
        Token literal = this.nextLiteralToken();
        return new LiteralExpressionTree(this.getTreeLocation(start), literal);
    }

    private TemplateLiteralExpressionTree parseTemplateLiteral(ParseTree operand) {
        SourcePosition start = operand == null ? this.getTreeStartLocation() : operand.location.start;
        Token token = this.nextToken();
        ImmutableList.Builder elements = ImmutableList.builder();
        elements.add((Object)new TemplateLiteralPortionTree(token.location, token));
        if (token.type == TokenType.NO_SUBSTITUTION_TEMPLATE) {
            return new TemplateLiteralExpressionTree(this.getTreeLocation(start), operand, (ImmutableList<ParseTree>)elements.build());
        }
        ParseTree expression = this.parseExpression();
        elements.add((Object)new TemplateSubstitutionTree(expression.location, expression));
        while (!this.errorReporter.hadError()) {
            token = this.nextTemplateLiteralToken();
            if (token.type == TokenType.ERROR || token.type == TokenType.END_OF_FILE) break;
            elements.add((Object)new TemplateLiteralPortionTree(token.location, token));
            if (token.type == TokenType.TEMPLATE_TAIL) break;
            expression = this.parseExpression();
            elements.add((Object)new TemplateSubstitutionTree(expression.location, expression));
        }
        return new TemplateLiteralExpressionTree(this.getTreeLocation(start), operand, (ImmutableList<ParseTree>)elements.build());
    }

    private Token nextLiteralToken() {
        return this.nextToken();
    }

    private ParseTree parseRegularExpressionLiteral() {
        SourcePosition start = this.getTreeStartLocation();
        LiteralToken literal = this.nextRegularExpressionLiteralToken();
        return new LiteralExpressionTree(this.getTreeLocation(start), literal);
    }

    private ParseTree parseArrayInitializer() {
        if (this.peekType(1) == TokenType.FOR) {
            return this.parseArrayComprehension();
        }
        return this.parseArrayLiteral();
    }

    private ParseTree parseGeneratorComprehension() {
        return this.parseComprehension(ComprehensionTree.ComprehensionType.GENERATOR, TokenType.OPEN_PAREN, TokenType.CLOSE_PAREN);
    }

    private ParseTree parseArrayComprehension() {
        return this.parseComprehension(ComprehensionTree.ComprehensionType.ARRAY, TokenType.OPEN_SQUARE, TokenType.CLOSE_SQUARE);
    }

    private ParseTree parseComprehension(ComprehensionTree.ComprehensionType type, TokenType startToken, TokenType endToken) {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(startToken);
        ImmutableList.Builder children = ImmutableList.builder();
        while (this.peek(TokenType.FOR) || this.peek(TokenType.IF)) {
            if (this.peek(TokenType.FOR)) {
                children.add((Object)this.parseComprehensionFor());
                continue;
            }
            children.add((Object)this.parseComprehensionIf());
        }
        ParseTree tailExpression = this.parseAssignmentExpression();
        this.eat(endToken);
        return new ComprehensionTree(this.getTreeLocation(start), type, (ImmutableList<ParseTree>)children.build(), tailExpression);
    }

    private ParseTree parseComprehensionFor() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.FOR);
        this.eat(TokenType.OPEN_PAREN);
        ParseTree initializer = this.peekId() ? this.parseIdentifierExpression() : this.parsePattern(PatternKind.ANY);
        this.eatPredefinedString("of");
        ParseTree collection = this.parseAssignmentExpression();
        this.eat(TokenType.CLOSE_PAREN);
        return new ComprehensionForTree(this.getTreeLocation(start), initializer, collection);
    }

    private ParseTree parseComprehensionIf() {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.IF);
        this.eat(TokenType.OPEN_PAREN);
        ParseTree initializer = this.parseAssignmentExpression();
        this.eat(TokenType.CLOSE_PAREN);
        return new ComprehensionIfTree(this.getTreeLocation(start), initializer);
    }

    private ParseTree parseArrayLiteral() {
        SourcePosition start = this.getTreeStartLocation();
        ImmutableList.Builder elements = ImmutableList.builder();
        this.eat(TokenType.OPEN_SQUARE);
        Token trailingCommaToken = null;
        while (this.peek(TokenType.COMMA) || this.peek(TokenType.SPREAD) || this.peekAssignmentExpression()) {
            trailingCommaToken = null;
            if (this.peek(TokenType.COMMA)) {
                elements.add((Object)new NullTree(this.getTreeLocation(this.getTreeStartLocation())));
            } else if (this.peek(TokenType.SPREAD)) {
                elements.add((Object)this.parseSpreadExpression());
            } else {
                elements.add((Object)this.parseAssignmentExpression());
            }
            if (this.peek(TokenType.CLOSE_SQUARE)) continue;
            trailingCommaToken = this.eat(TokenType.COMMA);
        }
        this.eat(TokenType.CLOSE_SQUARE);
        this.maybeReportTrailingComma(trailingCommaToken);
        return new ArrayLiteralExpressionTree(this.getTreeLocation(start), (ImmutableList<ParseTree>)elements.build());
    }

    private ParseTree parseObjectLiteral() {
        SourcePosition start = this.getTreeStartLocation();
        ImmutableList.Builder result = ImmutableList.builder();
        this.eat(TokenType.OPEN_CURLY);
        Token commaToken = null;
        while (this.peekPropertyNameOrComputedProp(0) || this.peek(TokenType.STAR)) {
            commaToken = null;
            result.add((Object)this.parsePropertyAssignment());
            commaToken = this.eatOpt(TokenType.COMMA);
            if (commaToken != null) continue;
        }
        this.eat(TokenType.CLOSE_CURLY);
        this.maybeReportTrailingComma(commaToken);
        return new ObjectLiteralExpressionTree(this.getTreeLocation(start), (ImmutableList<ParseTree>)result.build());
    }

    void maybeReportTrailingComma(Token commaToken) {
        if (commaToken != null && this.config.warnTrailingCommas) {
            this.errorReporter.reportWarning(commaToken.location.start, "Trailing comma is not legal in an ECMA-262 object initializer", new Object[0]);
        }
    }

    private boolean peekPropertyNameOrComputedProp(int tokenIndex) {
        return this.peekPropertyName(tokenIndex) || this.peekType(tokenIndex) == TokenType.OPEN_SQUARE;
    }

    private boolean peekPropertyName(int tokenIndex) {
        TokenType type = this.peekType(tokenIndex);
        switch (type) {
            case IDENTIFIER: 
            case NUMBER: 
            case STRING: {
                return true;
            }
        }
        return Keywords.isKeyword(type);
    }

    private ParseTree parsePropertyAssignment() {
        TokenType type = this.peekType();
        if (type == TokenType.STAR) {
            return this.parsePropertyAssignmentGenerator();
        }
        if (type == TokenType.STRING || type == TokenType.NUMBER || type == TokenType.IDENTIFIER || Keywords.isKeyword(type)) {
            if (this.peekGetAccessor(false)) {
                return this.parseGetAccessor();
            }
            if (this.peekSetAccessor(false)) {
                return this.parseSetAccessor();
            }
            if (this.peekType(1) == TokenType.OPEN_PAREN) {
                return this.parseMethodDeclaration(false);
            }
            return this.parsePropertyNameAssignment();
        }
        if (type == TokenType.OPEN_SQUARE) {
            SourcePosition start = this.getTreeStartLocation();
            ParseTree name = this.parseComputedPropertyName();
            if (this.peek(TokenType.COLON)) {
                this.eat(TokenType.COLON);
                ParseTree value = this.parseAssignmentExpression();
                return new ComputedPropertyDefinitionTree(this.getTreeLocation(start), name, value);
            }
            ParseTree value = this.parseFunctionTail(start, null, false, false, FunctionDeclarationTree.Kind.EXPRESSION);
            return new ComputedPropertyMethodTree(this.getTreeLocation(start), name, value);
        }
        throw new RuntimeException("unreachable");
    }

    private ParseTree parsePropertyAssignmentGenerator() {
        TokenType type = this.peekType(1);
        if (type == TokenType.STRING || type == TokenType.NUMBER || type == TokenType.IDENTIFIER || Keywords.isKeyword(type)) {
            return this.parseMethodDeclaration(false);
        }
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.STAR);
        ParseTree name = this.parseComputedPropertyName();
        ParseTree value = this.parseFunctionTail(start, null, false, true, FunctionDeclarationTree.Kind.EXPRESSION);
        return new ComputedPropertyMethodTree(this.getTreeLocation(start), name, value);
    }

    private ParseTree parseComputedPropertyName() {
        this.eat(TokenType.OPEN_SQUARE);
        ParseTree assign = this.parseAssignmentExpression();
        this.eat(TokenType.CLOSE_SQUARE);
        return assign;
    }

    private boolean peekGetAccessor(boolean allowStatic) {
        int index = allowStatic && this.peek(TokenType.STATIC) ? 1 : 0;
        return this.peekPredefinedString(index, "get") && this.peekPropertyNameOrComputedProp(index + 1);
    }

    private boolean peekPredefinedString(String string) {
        return this.peekPredefinedString(0, string);
    }

    private Token eatPredefinedString(String string) {
        IdentifierToken token = this.eatId();
        if (token == null || !token.asIdentifier().value.equals(string)) {
            this.reportExpectedError(token, string);
            return null;
        }
        return token;
    }

    private boolean peekPredefinedString(int index, String string) {
        return this.peek(index, TokenType.IDENTIFIER) && ((IdentifierToken)this.peekToken((int)index)).value.equals(string);
    }

    private ParseTree parseGetAccessor() {
        SourcePosition start = this.getTreeStartLocation();
        boolean isStatic = this.eatOpt(TokenType.STATIC) != null;
        this.eatPredefinedString("get");
        if (this.peekPropertyName(0)) {
            Token propertyName = this.eatObjectLiteralPropertyName();
            this.eat(TokenType.OPEN_PAREN);
            this.eat(TokenType.CLOSE_PAREN);
            BlockTree body = this.parseFunctionBody();
            return new GetAccessorTree(this.getTreeLocation(start), propertyName, isStatic, body);
        }
        ParseTree property = this.parseComputedPropertyName();
        this.eat(TokenType.OPEN_PAREN);
        this.eat(TokenType.CLOSE_PAREN);
        BlockTree body = this.parseFunctionBody();
        return new ComputedPropertyGetterTree(this.getTreeLocation(start), property, isStatic, body);
    }

    private boolean peekSetAccessor(boolean allowStatic) {
        int index = allowStatic && this.peek(TokenType.STATIC) ? 1 : 0;
        return this.peekPredefinedString(index, "set") && this.peekPropertyNameOrComputedProp(index + 1);
    }

    private ParseTree parseSetAccessor() {
        SourcePosition start = this.getTreeStartLocation();
        boolean isStatic = this.eatOpt(TokenType.STATIC) != null;
        this.eatPredefinedString("set");
        if (this.peekPropertyName(0)) {
            Token propertyName = this.eatObjectLiteralPropertyName();
            this.eat(TokenType.OPEN_PAREN);
            IdentifierToken parameter = this.eatId();
            this.eat(TokenType.CLOSE_PAREN);
            BlockTree body = this.parseFunctionBody();
            return new SetAccessorTree(this.getTreeLocation(start), propertyName, isStatic, parameter, body);
        }
        ParseTree property = this.parseComputedPropertyName();
        this.eat(TokenType.OPEN_PAREN);
        IdentifierToken parameter = this.eatId();
        this.eat(TokenType.CLOSE_PAREN);
        BlockTree body = this.parseFunctionBody();
        return new ComputedPropertySetterTree(this.getTreeLocation(start), property, isStatic, parameter, body);
    }

    private ParseTree parsePropertyNameAssignment() {
        SourcePosition start = this.getTreeStartLocation();
        Token name = this.eatObjectLiteralPropertyName();
        Token colon = this.eatOpt(TokenType.COLON);
        if (colon == null) {
            if (name.type != TokenType.IDENTIFIER) {
                this.reportExpectedError(this.peekToken(), (Object)TokenType.COLON);
            } else if (Keywords.isKeyword(name.asIdentifier().value)) {
                this.reportError(name, "Cannot use keyword in short object literal", new Object[0]);
            }
        }
        ParseTree value = colon == null ? null : this.parseAssignmentExpression();
        return new PropertyNameAssignmentTree(this.getTreeLocation(start), name, value);
    }

    private ParseTree parseParenExpression() {
        if (this.peekType(1) == TokenType.FOR) {
            return this.parseGeneratorComprehension();
        }
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.OPEN_PAREN);
        ParseTree result = this.parseExpression();
        this.eat(TokenType.CLOSE_PAREN);
        return new ParenExpressionTree(this.getTreeLocation(start), result);
    }

    private ParseTree parseMissingPrimaryExpression() {
        SourcePosition start = this.getTreeStartLocation();
        Token token = this.nextToken();
        this.reportError("primary expression expected", new Object[0]);
        return new MissingPrimaryExpressionTree(this.getTreeLocation(start), token);
    }

    private ParseTree parseExpressionNoIn() {
        return this.parse(Expression.NO_IN);
    }

    private ParseTree parseExpression() {
        return this.parse(Expression.NORMAL);
    }

    private boolean peekExpression() {
        switch (this.peekType()) {
            case FUNCTION: 
            case CLASS: 
            case OPEN_CURLY: 
            case IDENTIFIER: 
            case OPEN_SQUARE: 
            case YIELD: 
            case THIS: 
            case SUPER: 
            case NUMBER: 
            case STRING: 
            case NO_SUBSTITUTION_TEMPLATE: 
            case TEMPLATE_HEAD: 
            case NULL: 
            case TRUE: 
            case SLASH: 
            case SLASH_EQUAL: 
            case FALSE: 
            case OPEN_PAREN: 
            case NEW: 
            case DELETE: 
            case VOID: 
            case TYPEOF: 
            case PLUS_PLUS: 
            case MINUS_MINUS: 
            case PLUS: 
            case MINUS: 
            case TILDE: 
            case BANG: {
                return true;
            }
        }
        return false;
    }

    private ParseTree parse(Expression expressionIn) {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree result = this.parseAssignment(expressionIn);
        if (this.peek(TokenType.COMMA)) {
            ImmutableList.Builder exprs = ImmutableList.builder();
            exprs.add((Object)result);
            while (this.peek(TokenType.COMMA)) {
                this.eat(TokenType.COMMA);
                exprs.add((Object)this.parseAssignment(expressionIn));
            }
            return new CommaExpressionTree(this.getTreeLocation(start), (ImmutableList<ParseTree>)exprs.build());
        }
        return result;
    }

    private ParseTree parseAssignmentExpression() {
        return this.parseAssignment(Expression.NORMAL);
    }

    private boolean peekAssignmentExpression() {
        return this.peekExpression();
    }

    private ParseTree parseAssignment(Expression expressionIn) {
        ParseTree left;
        if (this.peek(TokenType.YIELD) && this.inGeneratorContext()) {
            return this.parseYield(expressionIn);
        }
        if (this.peekArrowFunction()) {
            return this.parseArrowFunction(expressionIn);
        }
        SourcePosition start = this.getTreeStartLocation();
        ParseTree parseTree = left = this.peekParenPatternAssignment() ? this.parseParenPattern() : this.parseConditional(expressionIn);
        if (this.peekAssignmentOperator()) {
            if (!left.isValidAssignmentTarget()) {
                this.reportError("invalid assignment target", new Object[0]);
            }
            Token operator = this.nextToken();
            ParseTree right = this.parseAssignment(expressionIn);
            return new BinaryOperatorTree(this.getTreeLocation(start), left, operator, right);
        }
        return left;
    }

    private boolean peekAssignmentOperator() {
        switch (this.peekType()) {
            case SLASH_EQUAL: 
            case EQUAL: 
            case STAR_EQUAL: 
            case PERCENT_EQUAL: 
            case PLUS_EQUAL: 
            case MINUS_EQUAL: 
            case LEFT_SHIFT_EQUAL: 
            case RIGHT_SHIFT_EQUAL: 
            case UNSIGNED_RIGHT_SHIFT_EQUAL: 
            case AMPERSAND_EQUAL: 
            case CARET_EQUAL: 
            case BAR_EQUAL: {
                return true;
            }
        }
        return false;
    }

    private boolean inGeneratorContext() {
        return this.inGeneratorContext.peekLast();
    }

    private ParseTree parseYield(Expression expressionIn) {
        SourcePosition start = this.getTreeStartLocation();
        this.eat(TokenType.YIELD);
        boolean isYieldFor = false;
        ParseTree expression = null;
        if (!this.peekImplicitSemiColon()) {
            boolean bl = isYieldFor = this.eatOpt(TokenType.STAR) != null;
            if (this.peekAssignmentExpression()) {
                expression = this.parseAssignment(expressionIn);
            }
        }
        return new YieldExpressionTree(this.getTreeLocation(start), isYieldFor, expression);
    }

    private ParseTree parseConditional(Expression expressionIn) {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree condition = this.parseLogicalOR(expressionIn);
        if (this.peek(TokenType.QUESTION)) {
            this.eat(TokenType.QUESTION);
            ParseTree left = this.parseAssignment(expressionIn);
            this.eat(TokenType.COLON);
            ParseTree right = this.parseAssignment(expressionIn);
            return new ConditionalExpressionTree(this.getTreeLocation(start), condition, left, right);
        }
        return condition;
    }

    private ParseTree parseLogicalOR(Expression expressionIn) {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree left = this.parseLogicalAND(expressionIn);
        while (this.peek(TokenType.OR)) {
            Token operator = this.eat(TokenType.OR);
            ParseTree right = this.parseLogicalAND(expressionIn);
            left = new BinaryOperatorTree(this.getTreeLocation(start), left, operator, right);
        }
        return left;
    }

    private ParseTree parseLogicalAND(Expression expressionIn) {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree left = this.parseBitwiseOR(expressionIn);
        while (this.peek(TokenType.AND)) {
            Token operator = this.eat(TokenType.AND);
            ParseTree right = this.parseBitwiseOR(expressionIn);
            left = new BinaryOperatorTree(this.getTreeLocation(start), left, operator, right);
        }
        return left;
    }

    private ParseTree parseBitwiseOR(Expression expressionIn) {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree left = this.parseBitwiseXOR(expressionIn);
        while (this.peek(TokenType.BAR)) {
            Token operator = this.eat(TokenType.BAR);
            ParseTree right = this.parseBitwiseXOR(expressionIn);
            left = new BinaryOperatorTree(this.getTreeLocation(start), left, operator, right);
        }
        return left;
    }

    private ParseTree parseBitwiseXOR(Expression expressionIn) {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree left = this.parseBitwiseAND(expressionIn);
        while (this.peek(TokenType.CARET)) {
            Token operator = this.eat(TokenType.CARET);
            ParseTree right = this.parseBitwiseAND(expressionIn);
            left = new BinaryOperatorTree(this.getTreeLocation(start), left, operator, right);
        }
        return left;
    }

    private ParseTree parseBitwiseAND(Expression expressionIn) {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree left = this.parseEquality(expressionIn);
        while (this.peek(TokenType.AMPERSAND)) {
            Token operator = this.eat(TokenType.AMPERSAND);
            ParseTree right = this.parseEquality(expressionIn);
            left = new BinaryOperatorTree(this.getTreeLocation(start), left, operator, right);
        }
        return left;
    }

    private ParseTree parseEquality(Expression expressionIn) {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree left = this.parseRelational(expressionIn);
        while (this.peekEqualityOperator()) {
            Token operator = this.nextToken();
            ParseTree right = this.parseRelational(expressionIn);
            left = new BinaryOperatorTree(this.getTreeLocation(start), left, operator, right);
        }
        return left;
    }

    private boolean peekEqualityOperator() {
        switch (this.peekType()) {
            case EQUAL_EQUAL: 
            case NOT_EQUAL: 
            case EQUAL_EQUAL_EQUAL: 
            case NOT_EQUAL_EQUAL: {
                return true;
            }
        }
        return false;
    }

    private ParseTree parseRelational(Expression expressionIn) {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree left = this.parseShiftExpression();
        while (this.peekRelationalOperator(expressionIn)) {
            Token operator = this.nextToken();
            ParseTree right = this.parseShiftExpression();
            left = new BinaryOperatorTree(this.getTreeLocation(start), left, operator, right);
        }
        return left;
    }

    private boolean peekRelationalOperator(Expression expressionIn) {
        switch (this.peekType()) {
            case OPEN_ANGLE: 
            case CLOSE_ANGLE: 
            case GREATER_EQUAL: 
            case LESS_EQUAL: 
            case INSTANCEOF: {
                return true;
            }
            case IN: {
                return expressionIn == Expression.NORMAL;
            }
        }
        return false;
    }

    private ParseTree parseShiftExpression() {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree left = this.parseAdditiveExpression();
        while (this.peekShiftOperator()) {
            Token operator = this.nextToken();
            ParseTree right = this.parseAdditiveExpression();
            left = new BinaryOperatorTree(this.getTreeLocation(start), left, operator, right);
        }
        return left;
    }

    private boolean peekShiftOperator() {
        switch (this.peekType()) {
            case LEFT_SHIFT: 
            case RIGHT_SHIFT: 
            case UNSIGNED_RIGHT_SHIFT: {
                return true;
            }
        }
        return false;
    }

    private ParseTree parseAdditiveExpression() {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree left = this.parseMultiplicativeExpression();
        while (this.peekAdditiveOperator()) {
            Token operator = this.nextToken();
            ParseTree right = this.parseMultiplicativeExpression();
            left = new BinaryOperatorTree(this.getTreeLocation(start), left, operator, right);
        }
        return left;
    }

    private boolean peekAdditiveOperator() {
        switch (this.peekType()) {
            case PLUS: 
            case MINUS: {
                return true;
            }
        }
        return false;
    }

    private ParseTree parseMultiplicativeExpression() {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree left = this.parseUnaryExpression();
        while (this.peekMultiplicativeOperator()) {
            Token operator = this.nextToken();
            ParseTree right = this.parseUnaryExpression();
            left = new BinaryOperatorTree(this.getTreeLocation(start), left, operator, right);
        }
        return left;
    }

    private boolean peekMultiplicativeOperator() {
        switch (this.peekType()) {
            case STAR: 
            case SLASH: 
            case PERCENT: {
                return true;
            }
        }
        return false;
    }

    private ParseTree parseUnaryExpression() {
        SourcePosition start = this.getTreeStartLocation();
        if (this.peekUnaryOperator()) {
            Token operator = this.nextToken();
            ParseTree operand = this.parseUnaryExpression();
            return new UnaryExpressionTree(this.getTreeLocation(start), operator, operand);
        }
        return this.parsePostfixExpression();
    }

    private boolean peekUnaryOperator() {
        switch (this.peekType()) {
            case DELETE: 
            case VOID: 
            case TYPEOF: 
            case PLUS_PLUS: 
            case MINUS_MINUS: 
            case PLUS: 
            case MINUS: 
            case TILDE: 
            case BANG: {
                return true;
            }
        }
        return false;
    }

    private ParseTree parsePostfixExpression() {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree operand = this.parseLeftHandSideExpression();
        while (this.peekPostfixOperator()) {
            Token operator = this.nextToken();
            operand = new PostfixExpressionTree(this.getTreeLocation(start), operand, operator);
        }
        return operand;
    }

    private boolean peekPostfixOperator() {
        if (this.peekImplicitSemiColon()) {
            return false;
        }
        switch (this.peekType()) {
            case PLUS_PLUS: 
            case MINUS_MINUS: {
                return true;
            }
        }
        return false;
    }

    private ParseTree parseLeftHandSideExpression() {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree operand = this.parseNewExpression();
        if (!(operand instanceof NewExpressionTree) || ((NewExpressionTree)operand).arguments != null) {
            while (this.peekCallSuffix()) {
                switch (this.peekType()) {
                    case OPEN_PAREN: {
                        ArgumentListTree arguments = this.parseArguments();
                        operand = new CallExpressionTree(this.getTreeLocation(start), operand, arguments);
                        break;
                    }
                    case OPEN_SQUARE: {
                        this.eat(TokenType.OPEN_SQUARE);
                        ParseTree member = this.parseExpression();
                        this.eat(TokenType.CLOSE_SQUARE);
                        operand = new MemberLookupExpressionTree(this.getTreeLocation(start), operand, member);
                        break;
                    }
                    case PERIOD: {
                        this.eat(TokenType.PERIOD);
                        IdentifierToken id = this.eatIdOrKeywordAsId();
                        operand = new MemberExpressionTree(this.getTreeLocation(start), operand, id);
                        break;
                    }
                    case NO_SUBSTITUTION_TEMPLATE: 
                    case TEMPLATE_HEAD: {
                        operand = this.parseTemplateLiteral(operand);
                    }
                }
            }
        }
        return operand;
    }

    private boolean peekCallSuffix() {
        return this.peek(TokenType.OPEN_PAREN) || this.peek(TokenType.OPEN_SQUARE) || this.peek(TokenType.PERIOD) || this.peek(TokenType.NO_SUBSTITUTION_TEMPLATE) || this.peek(TokenType.TEMPLATE_HEAD);
    }

    private ParseTree parseMemberExpressionNoNew() {
        SourcePosition start = this.getTreeStartLocation();
        ParseTree operand = this.peekFunction() ? this.parseFunctionExpression() : this.parsePrimaryExpression();
        block5: while (this.peekMemberExpressionSuffix()) {
            switch (this.peekType()) {
                case OPEN_SQUARE: {
                    this.eat(TokenType.OPEN_SQUARE);
                    ParseTree member = this.parseExpression();
                    this.eat(TokenType.CLOSE_SQUARE);
                    operand = new MemberLookupExpressionTree(this.getTreeLocation(start), operand, member);
                    continue block5;
                }
                case PERIOD: {
                    this.eat(TokenType.PERIOD);
                    IdentifierToken id = this.eatIdOrKeywordAsId();
                    operand = new MemberExpressionTree(this.getTreeLocation(start), operand, id);
                    continue block5;
                }
                case NO_SUBSTITUTION_TEMPLATE: 
                case TEMPLATE_HEAD: {
                    operand = this.parseTemplateLiteral(operand);
                    continue block5;
                }
            }
            throw new RuntimeException("unreachable");
        }
        return operand;
    }

    private boolean peekMemberExpressionSuffix() {
        return this.peek(TokenType.OPEN_SQUARE) || this.peek(TokenType.PERIOD) || this.peek(TokenType.NO_SUBSTITUTION_TEMPLATE) || this.peek(TokenType.TEMPLATE_HEAD);
    }

    private ParseTree parseNewExpression() {
        if (this.peek(TokenType.NEW)) {
            SourcePosition start = this.getTreeStartLocation();
            this.eat(TokenType.NEW);
            ParseTree operand = this.parseNewExpression();
            ArgumentListTree arguments = null;
            if (this.peek(TokenType.OPEN_PAREN)) {
                arguments = this.parseArguments();
            }
            return new NewExpressionTree(this.getTreeLocation(start), operand, arguments);
        }
        return this.parseMemberExpressionNoNew();
    }

    private ArgumentListTree parseArguments() {
        SourcePosition start = this.getTreeStartLocation();
        ImmutableList.Builder arguments = ImmutableList.builder();
        this.eat(TokenType.OPEN_PAREN);
        while (this.peekAssignmentOrSpread()) {
            arguments.add((Object)this.parseAssignmentOrSpread());
            if (this.peek(TokenType.CLOSE_PAREN)) continue;
            this.eat(TokenType.COMMA);
            if (!this.peek(TokenType.CLOSE_PAREN)) continue;
            this.reportError("Invalid trailing comma in arguments list", new Object[0]);
        }
        this.eat(TokenType.CLOSE_PAREN);
        return new ArgumentListTree(this.getTreeLocation(start), (ImmutableList<ParseTree>)arguments.build());
    }

    private boolean peekAssignmentOrSpread() {
        return this.peek(TokenType.SPREAD) || this.peekAssignmentExpression();
    }

    private ParseTree parseAssignmentOrSpread() {
        if (this.peek(TokenType.SPREAD)) {
            return this.parseSpreadExpression();
        }
        return this.parseAssignmentExpression();
    }

    private boolean peekParenPatternAssignment() {
        return this.peekParenPattern(PatternKind.ANY, EnumSet.of(TokenType.EQUAL));
    }

    private boolean peekParenPatternStart() {
        int index = 0;
        while (this.peek(index, TokenType.OPEN_PAREN)) {
            ++index;
        }
        return this.peekPatternStart(index);
    }

    private boolean peekPatternStart() {
        return this.peekPatternStart(0);
    }

    private boolean peekPatternStart(int index) {
        return this.peek(index, TokenType.OPEN_SQUARE) || this.peek(index, TokenType.OPEN_CURLY);
    }

    private ParseTree parseParenPattern() {
        return this.parseParenPattern(PatternKind.ANY);
    }

    private ParseTree parseParenPattern(PatternKind kind) {
        if (this.peek(TokenType.OPEN_PAREN)) {
            SourcePosition start = this.getTreeStartLocation();
            this.eat(TokenType.OPEN_PAREN);
            ParseTree result = this.parseParenPattern(kind);
            this.eat(TokenType.CLOSE_PAREN);
            return new ParenExpressionTree(this.getTreeLocation(start), result);
        }
        return this.parsePattern(kind);
    }

    private boolean peekPattern(PatternKind kind) {
        return this.peekPattern(kind, (Predicate<Token>)Predicates.alwaysTrue());
    }

    private boolean peekPattern(PatternKind kind, Predicate<Token> follow) {
        if (!this.peekPatternStart()) {
            return false;
        }
        Parser p = this.createLookaheadParser();
        try {
            p.parsePattern(kind);
            return follow.apply((Object)p.peekToken());
        }
        catch (LookaheadErrorReporter.ParseException e) {
            return false;
        }
    }

    private boolean peekParenPattern(PatternKind kind, EnumSet<TokenType> follow) {
        if (!this.peekParenPatternStart()) {
            return false;
        }
        Parser p = this.createLookaheadParser();
        try {
            p.parseParenPattern(kind);
            return follow.contains((Object)p.peekType());
        }
        catch (LookaheadErrorReporter.ParseException e) {
            return false;
        }
    }

    private ParseTree parsePattern(PatternKind kind) {
        switch (this.peekType()) {
            case OPEN_SQUARE: {
                return this.parseArrayPattern(kind);
            }
        }
        return this.parseObjectPattern(kind);
    }

    private boolean peekPatternElement() {
        return this.peekExpression() || this.peek(TokenType.SPREAD);
    }

    private ParseTree parseArrayPatternElement(PatternKind kind) {
        ParseTree lvalue;
        SourcePosition start = this.getTreeStartLocation();
        boolean rest = false;
        if (this.peekParenPattern(kind, arraySubPatternFollowSet)) {
            lvalue = this.parseParenPattern(kind);
        } else {
            if (this.peek(TokenType.SPREAD)) {
                this.eat(TokenType.SPREAD);
                rest = true;
            }
            lvalue = this.parseLeftHandSideExpression();
        }
        if (rest && lvalue.type != ParseTreeType.IDENTIFIER_EXPRESSION) {
            this.reportError("lvalues in rest elements must be identifiers", new Object[0]);
            return lvalue;
        }
        if (rest) {
            return new AssignmentRestElementTree(this.getTreeLocation(start), lvalue.asIdentifierExpression().identifierToken);
        }
        Token eq = this.eatOpt(TokenType.EQUAL);
        if (eq != null) {
            ParseTree defaultValue = this.parseAssignmentExpression();
            return new DefaultParameterTree(this.getTreeLocation(start), lvalue, defaultValue);
        }
        return lvalue;
    }

    private ParseTree parseArrayPattern(PatternKind kind) {
        SourcePosition start = this.getTreeStartLocation();
        ImmutableList.Builder elements = ImmutableList.builder();
        this.eat(TokenType.OPEN_SQUARE);
        while (this.peek(TokenType.COMMA) || this.peekPatternElement()) {
            if (this.peek(TokenType.COMMA)) {
                this.eat(TokenType.COMMA);
                elements.add((Object)new NullTree(this.getTreeLocation(this.getTreeStartLocation())));
                continue;
            }
            ParseTree element = this.parseArrayPatternElement(kind);
            elements.add((Object)element);
            if (element.isAssignmentRestElement() || !this.peek(TokenType.COMMA)) break;
            this.eat(TokenType.COMMA);
            if (!this.peek(TokenType.CLOSE_SQUARE)) continue;
            this.reportError("Array pattern may not end with a comma", new Object[0]);
            break;
        }
        this.eat(TokenType.CLOSE_SQUARE);
        return new ArrayPatternTree(this.getTreeLocation(start), (ImmutableList<ParseTree>)elements.build());
    }

    private ParseTree parseObjectPattern(PatternKind kind) {
        SourcePosition start = this.getTreeStartLocation();
        ImmutableList.Builder fields = ImmutableList.builder();
        this.eat(TokenType.OPEN_CURLY);
        while (this.peekObjectPatternField()) {
            fields.add((Object)this.parseObjectPatternField(kind));
            if (!this.peek(TokenType.COMMA)) break;
            this.eat(TokenType.COMMA);
        }
        this.eat(TokenType.CLOSE_CURLY);
        return new ObjectPatternTree(this.getTreeLocation(start), (ImmutableList<ParseTree>)fields.build());
    }

    private boolean peekObjectPatternField() {
        return this.peekPropertyNameOrComputedProp(0);
    }

    private ParseTree parseObjectPatternField(PatternKind kind) {
        Token name;
        SourcePosition start = this.getTreeStartLocation();
        if (this.peekType() == TokenType.OPEN_SQUARE) {
            ParseTree key = this.parseComputedPropertyName();
            this.eat(TokenType.COLON);
            ParseTree value = this.parseObjectPatternFieldTail(kind);
            return new ComputedPropertyDefinitionTree(this.getTreeLocation(start), key, value);
        }
        if (this.peekId() || Keywords.isKeyword(this.peekType())) {
            name = this.eatIdOrKeywordAsId();
            if (!this.peek(TokenType.COLON)) {
                Token idToken = name;
                if (Keywords.isKeyword(idToken.value)) {
                    this.reportError("cannot use keyword '" + name + "' here.", new Object[0]);
                }
                if (this.peek(TokenType.EQUAL)) {
                    IdentifierExpressionTree idTree = new IdentifierExpressionTree(this.getTreeLocation(start), (IdentifierToken)idToken);
                    this.eat(TokenType.EQUAL);
                    ParseTree defaultValue = this.parseAssignmentExpression();
                    return new DefaultParameterTree(this.getTreeLocation(start), idTree, defaultValue);
                }
                return new PropertyNameAssignmentTree(this.getTreeLocation(start), name, null);
            }
        } else {
            name = this.parseLiteralExpression().literalToken;
        }
        this.eat(TokenType.COLON);
        ParseTree value = this.parseObjectPatternFieldTail(kind);
        return new PropertyNameAssignmentTree(this.getTreeLocation(start), name, value);
    }

    private ParseTree parseObjectPatternFieldTail(PatternKind kind) {
        ParseTree value;
        SourcePosition start = this.getTreeStartLocation();
        if (this.peekPattern(kind)) {
            value = this.parsePattern(kind);
        } else {
            ParseTree parseTree = value = kind == PatternKind.ANY ? this.parseLeftHandSideExpression() : this.parseIdentifierExpression();
            if (!value.isValidAssignmentTarget()) {
                this.reportError("invalid assignment target", new Object[0]);
            }
        }
        if (this.peek(TokenType.EQUAL)) {
            this.eat(TokenType.EQUAL);
            ParseTree defaultValue = this.parseAssignmentExpression();
            return new DefaultParameterTree(this.getTreeLocation(start), value, defaultValue);
        }
        return value;
    }

    private void eatPossibleImplicitSemiColon() {
        if (this.peek(TokenType.SEMI_COLON) && this.peekToken().location.start.line == this.getLastLine()) {
            this.eat(TokenType.SEMI_COLON);
            return;
        }
        if (this.peekImplicitSemiColon()) {
            return;
        }
        this.reportError("Semi-colon expected", new Object[0]);
    }

    private boolean peekImplicitSemiColon() {
        return this.getNextLine() > this.getLastLine() || this.peek(TokenType.SEMI_COLON) || this.peek(TokenType.CLOSE_CURLY) || this.peek(TokenType.END_OF_FILE);
    }

    private int getLastLine() {
        return this.lastToken.location.end.line;
    }

    private int getNextLine() {
        return this.peekToken().location.start.line;
    }

    private Token eatOpt(TokenType expectedTokenType) {
        if (this.peek(expectedTokenType)) {
            return this.eat(expectedTokenType);
        }
        return null;
    }

    private boolean inStrictContext() {
        return this.config.isStrictMode;
    }

    private boolean peekId() {
        return this.peekId(0);
    }

    private boolean peekId(int index) {
        TokenType type = this.peekType(index);
        return type == TokenType.IDENTIFIER || !this.inStrictContext() && Keywords.isStrictKeyword(type);
    }

    private IdentifierToken eatIdOpt() {
        return this.peekId() ? this.eatIdOrKeywordAsId() : null;
    }

    private IdentifierToken eatId() {
        if (this.peekId()) {
            return this.eatIdOrKeywordAsId();
        }
        this.reportExpectedError(this.peekToken(), (Object)TokenType.IDENTIFIER);
        return null;
    }

    private Token eatObjectLiteralPropertyName() {
        Token token = this.peekToken();
        switch (token.type) {
            case NUMBER: 
            case STRING: {
                return this.nextToken();
            }
        }
        return this.eatIdOrKeywordAsId();
    }

    private IdentifierToken eatIdOrKeywordAsId() {
        Token token = this.nextToken();
        if (token.type == TokenType.IDENTIFIER) {
            return (IdentifierToken)token;
        }
        if (Keywords.isKeyword(token.type)) {
            return new IdentifierToken(token.location, Keywords.get(token.type).toString());
        }
        this.reportExpectedError(token, (Object)TokenType.IDENTIFIER);
        return null;
    }

    private Token eat(TokenType expectedTokenType) {
        Token token = this.nextToken();
        if (token.type != expectedTokenType) {
            this.reportExpectedError(token, (Object)expectedTokenType);
            return null;
        }
        return token;
    }

    private void reportExpectedError(Token token, Object expected) {
        this.reportError(token, "'%s' expected", expected);
    }

    private SourcePosition getTreeStartLocation() {
        return this.peekToken().location.start;
    }

    private SourcePosition getTreeEndLocation() {
        return this.lastToken.location.end;
    }

    private SourceRange getTreeLocation(SourcePosition start) {
        return new SourceRange(start, this.getTreeEndLocation());
    }

    private Token nextToken() {
        this.lastToken = this.scanner.nextToken();
        return this.lastToken;
    }

    private LiteralToken nextRegularExpressionLiteralToken() {
        LiteralToken lastToken = this.scanner.nextRegularExpressionLiteralToken();
        this.lastToken = lastToken;
        return lastToken;
    }

    private LiteralToken nextTemplateLiteralToken() {
        LiteralToken lastToken = this.scanner.nextTemplateLiteralToken();
        this.lastToken = lastToken;
        return lastToken;
    }

    private boolean peek(TokenType expectedType) {
        return this.peek(0, expectedType);
    }

    private boolean peek(int index, TokenType expectedType) {
        return this.peekType(index) == expectedType;
    }

    private TokenType peekType() {
        return this.peekType(0);
    }

    private TokenType peekType(int index) {
        return this.peekToken((int)index).type;
    }

    private Token peekToken() {
        return this.peekToken(0);
    }

    private Token peekToken(int index) {
        return this.scanner.peekToken(index);
    }

    private Parser createLookaheadParser() {
        return new Parser(this.config, new LookaheadErrorReporter(), this.scanner.getFile(), this.scanner.getOffset(), this.inGeneratorContext());
    }

    private void reportError(Token token, String message, Object ... arguments) {
        if (token == null) {
            this.reportError(message, arguments);
        } else {
            this.errorReporter.reportError(token.getStart(), message, arguments);
        }
    }

    private void reportError(String message, Object ... arguments) {
        this.errorReporter.reportError(this.scanner.getPosition(), message, arguments);
    }

    private static enum PatternKind {
        INITIALIZER,
        ANY;

    }

    private static enum Expression {
        NO_IN,
        NORMAL;

    }

    private static class CommentRecorder
    implements Scanner.CommentRecorder {
        private ImmutableList.Builder<Comment> comments = ImmutableList.builder();

        private CommentRecorder() {
        }

        @Override
        public void recordComment(Comment.Type type, SourceRange range, String value) {
            this.comments.add((Object)new Comment(value, range, type));
        }

        private ImmutableList<Comment> getComments() {
            return this.comments.build();
        }
    }

    public static class Config {
        public final boolean atLeast6;
        public final boolean atLeast5;
        public final boolean isStrictMode;
        public final boolean warnTrailingCommas;
        public final boolean warnLineContinuations;
        public final boolean warnES6NumberLiteral;

        public Config(Mode mode) {
            this.atLeast6 = mode == Mode.ES6 || mode == Mode.ES6_STRICT;
            this.atLeast5 = this.atLeast6 || mode == Mode.ES5 || mode == Mode.ES5_STRICT;
            this.isStrictMode = mode == Mode.ES5_STRICT || mode == Mode.ES6_STRICT;
            this.warnTrailingCommas = !this.atLeast5;
            this.warnLineContinuations = !this.atLeast6;
            this.warnES6NumberLiteral = !this.atLeast6;
        }

        public static enum Mode {
            ES3,
            ES5,
            ES5_STRICT,
            ES6,
            ES6_STRICT;

        }
    }
}

