/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.fuzzing;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.javascript.jscomp.fuzzing.AbstractFuzzer;
import com.google.javascript.jscomp.fuzzing.DiscreteDistribution;
import com.google.javascript.jscomp.fuzzing.FuzzingContext;
import com.google.javascript.jscomp.fuzzing.Type;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Set;

abstract class Dispatcher
extends AbstractFuzzer {
    private Set<Type> supportedTypes;
    protected AbstractFuzzer[] candidates;

    Dispatcher(FuzzingContext context) {
        super(context);
    }

    @Override
    protected boolean isEnough(int budget) {
        if (budget < 1) {
            return false;
        }
        Preconditions.checkNotNull((Object)this.getCandidates(), (Object)"Candidate fuzzers need to be initialized before being used.");
        for (AbstractFuzzer fuzzer : this.getCandidates()) {
            if (!fuzzer.isEnough(budget)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Node generate(int budget, Set<Type> types) {
        AbstractFuzzer fuzzer = this.selectFuzzer(budget, types);
        return fuzzer.generate(budget, types);
    }

    @Override
    protected Set<Type> supportedTypes() {
        if (this.supportedTypes == null) {
            this.supportedTypes = EnumSet.noneOf(Type.class);
            for (AbstractFuzzer fuzzer : this.getCandidates()) {
                this.supportedTypes.addAll(fuzzer.supportedTypes());
            }
        }
        return Sets.immutableEnumSet(this.supportedTypes);
    }

    protected AbstractFuzzer selectFuzzer(int budget, Set<Type> types) {
        Preconditions.checkNotNull((Object)this.getCandidates(), (Object)"Candidate fuzzers need to be initialized before being used.");
        ArrayList typeCorrectCandidates = Lists.newArrayList();
        for (AbstractFuzzer fuzzer : this.getCandidates()) {
            if (Sets.intersection(fuzzer.supportedTypes(), types).isEmpty()) continue;
            typeCorrectCandidates.add(fuzzer);
        }
        JsonObject weightConfig = this.getOwnConfig().get("weights").getAsJsonObject();
        ArrayList validFuzzers = Lists.newArrayList();
        ArrayList weights = Lists.newArrayList();
        int stepSize = 2;
        budget -= stepSize;
        do {
            budget += stepSize;
            for (AbstractFuzzer fuzzer : typeCorrectCandidates) {
                if (!fuzzer.isEnough(budget)) continue;
                validFuzzers.add(fuzzer);
                try {
                    weights.add(weightConfig.get(fuzzer.getConfigName()).getAsDouble());
                }
                catch (JsonParseException e) {
                    e.printStackTrace();
                }
            }
        } while (validFuzzers.isEmpty());
        DiscreteDistribution dd = new DiscreteDistribution(this.context.random, validFuzzers, weights);
        return (AbstractFuzzer)dd.nextItem();
    }

    protected abstract void initCandidates();

    private AbstractFuzzer[] getCandidates() {
        if (this.candidates == null) {
            this.initCandidates();
        }
        return this.candidates;
    }
}

