/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.deps;

import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.ErrorManager;
import com.google.javascript.jscomp.deps.DependencyInfo;
import com.google.javascript.jscomp.deps.JsFileLineParser;
import com.google.javascript.jscomp.deps.SimpleDependencyInfo;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DepsFileParser
extends JsFileLineParser {
    private static Logger logger = Logger.getLogger(DepsFileParser.class.getName());
    private final Matcher depMatcher = Pattern.compile("\\s*goog.addDependency\\((.*)\\);?\\s*").matcher("");
    private final Matcher depArgsMatch = Pattern.compile("\\s*([^,]*), (\\[[^\\]]*\\]), (\\[[^\\]]*\\])(?:, (true|false))?\\s*").matcher("");
    private List<DependencyInfo> depInfos;
    private final Function<String, String> pathTranslator;

    public DepsFileParser(ErrorManager errorManager) {
        this((Function<String, String>)Functions.identity(), errorManager);
    }

    public DepsFileParser(Function<String, String> pathTranslator, ErrorManager errorManager) {
        super(errorManager);
        this.pathTranslator = pathTranslator;
    }

    public List<DependencyInfo> parseFile(String filePath) throws IOException {
        return this.parseFileReader(filePath, new FileReader(filePath));
    }

    public List<DependencyInfo> parseFile(String filePath, String fileContents) {
        return this.parseFileReader(filePath, new StringReader(fileContents));
    }

    public List<DependencyInfo> parseFileReader(String filePath, Reader reader) {
        this.depInfos = Lists.newArrayList();
        logger.fine("Parsing Dep: " + filePath);
        this.doParse(filePath, reader);
        return this.depInfos;
    }

    @Override
    protected boolean parseLine(String line) throws JsFileLineParser.ParseException {
        boolean hasDependencies = false;
        if (line.contains("addDependency")) {
            this.depMatcher.reset(line);
            if (this.depMatcher.matches()) {
                hasDependencies = true;
                String addDependencyParams = this.depMatcher.group(1);
                this.depArgsMatch.reset(addDependencyParams);
                if (!this.depArgsMatch.matches()) {
                    throw new JsFileLineParser.ParseException("Invalid arguments to goog.addDependency(). Found: " + addDependencyParams, true);
                }
                String path = (String)this.pathTranslator.apply((Object)this.parseJsString(this.depArgsMatch.group(1)));
                String moduleMatch = this.depArgsMatch.group(4);
                boolean isModule = moduleMatch == null ? false : this.parseJsBoolean(moduleMatch);
                SimpleDependencyInfo depInfo = new SimpleDependencyInfo(path, this.filePath, this.parseJsStringArray(this.depArgsMatch.group(2)), this.parseJsStringArray(this.depArgsMatch.group(3)), isModule);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Found dep: " + depInfo);
                }
                this.depInfos.add(depInfo);
            }
        }
        return !this.shortcutMode || hasDependencies || CharMatcher.WHITESPACE.matchesAllOf((CharSequence)line);
    }
}

