/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.ScopeCreator;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.Node;

class Es6SyntacticScopeCreator
implements ScopeCreator {
    private final AbstractCompiler compiler;
    private Scope scope;
    private InputId inputId;
    private final RedeclarationHandler redeclarationHandler;
    private static final String ARGUMENTS = "arguments";

    Es6SyntacticScopeCreator(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.redeclarationHandler = new DefaultRedeclarationHandler();
    }

    Es6SyntacticScopeCreator(AbstractCompiler compiler, RedeclarationHandler redeclarationHandler) {
        this.compiler = compiler;
        this.redeclarationHandler = redeclarationHandler;
    }

    @Override
    public Scope createScope(Node n, Scope parent) {
        this.inputId = null;
        this.scope = parent == null ? Scope.createGlobalScope(n) : new Scope(parent, n);
        this.scanRoot(n);
        this.inputId = null;
        Scope returnedScope = this.scope;
        this.scope = null;
        return returnedScope;
    }

    private void scanRoot(Node n) {
        if (n.isFunction()) {
            if (this.inputId == null) {
                this.inputId = NodeUtil.getInputId(n);
            }
            Node fnNameNode = n.getFirstChild();
            Node args = fnNameNode.getNext();
            String fnName = fnNameNode.getString();
            if (!fnName.isEmpty() && NodeUtil.isFunctionExpression(n)) {
                this.declareVar(fnNameNode);
            }
            Preconditions.checkState((boolean)args.isParamList());
            for (Node a = args.getFirstChild(); a != null; a = a.getNext()) {
                if (a.isDefaultValue()) {
                    this.declareLHS(this.scope, a.getFirstChild());
                    continue;
                }
                this.declareLHS(this.scope, a);
            }
        } else if (n.isBlock() || n.isFor() || n.isForOf()) {
            this.scanVars(n);
        } else {
            Preconditions.checkState((this.scope.getParent() == null ? 1 : 0) != 0);
            this.scanVars(n);
        }
    }

    private void declareLHS(Scope declarationScope, Node lhs) {
        if (lhs.isName() || lhs.isStringKey() || lhs.isRest()) {
            this.declareVar(declarationScope, lhs);
        } else if (lhs.isArrayPattern() || lhs.isObjectPattern()) {
            for (Node child = lhs.getFirstChild(); child != null; child = child.getNext()) {
                if (NodeUtil.isNameDeclaration(lhs.getParent()) && child.getNext() == null) {
                    return;
                }
                this.declareLHS(declarationScope, child);
            }
        } else {
            Preconditions.checkState((boolean)lhs.isEmpty());
        }
    }

    private void scanVars(Node n) {
        switch (n.getType()) {
            case 118: {
                for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
                    this.declareLHS(this.scope.getClosestHoistScope(), child);
                }
                return;
            }
            case 149: 
            case 162: {
                if (!this.isNodeAtCurrentLexicalScope(n)) {
                    return;
                }
                for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
                    this.declareLHS(this.scope, child);
                }
                return;
            }
            case 105: {
                if (NodeUtil.isFunctionExpression(n) || !this.isNodeAtCurrentLexicalScope(n)) {
                    return;
                }
                String fnName = n.getFirstChild().getString();
                if (fnName.isEmpty()) {
                    return;
                }
                this.declareVar(n.getFirstChild());
                return;
            }
            case 158: {
                if (NodeUtil.isClassExpression(n) || !this.isNodeAtCurrentLexicalScope(n)) {
                    return;
                }
                String className = n.getFirstChild().getString();
                if (className.isEmpty()) {
                    return;
                }
                this.declareVar(n.getFirstChild());
                return;
            }
            case 120: {
                Preconditions.checkState((n.getChildCount() == 2 ? 1 : 0) != 0);
                Preconditions.checkState((boolean)n.getFirstChild().isName());
                Node var = n.getFirstChild();
                Node block = var.getNext();
                if (this.isNodeAtCurrentLexicalScope(n)) {
                    this.declareVar(var);
                }
                this.scanVars(block);
                return;
            }
            case 132: {
                this.inputId = n.getInputId();
                Preconditions.checkNotNull((Object)this.inputId);
            }
        }
        if (NodeUtil.isControlStructure(n) || NodeUtil.isStatementBlock(n)) {
            Node child = n.getFirstChild();
            while (child != null) {
                Node next = child.getNext();
                this.scanVars(child);
                child = next;
            }
        }
    }

    private void declareVar(Node n) {
        this.declareVar(this.scope, n);
    }

    private void declareVar(Scope s, Node n) {
        Preconditions.checkState((n.isName() || n.isRest() || n.isStringKey() ? 1 : 0) != 0);
        String name = n.getString();
        if (s.getVar(name) != null && s.getVar(name).getNode() == n) {
            return;
        }
        CompilerInput input = this.compiler.getInput(this.inputId);
        if (s.isDeclared(name, false) || s.isLocal() && name.equals(ARGUMENTS)) {
            this.redeclarationHandler.onRedeclaration(s, name, n, input);
        } else {
            s.declare(name, n, null, input);
        }
    }

    static Scope generateUntypedTopScope(AbstractCompiler compiler) {
        return new Es6SyntacticScopeCreator(compiler).createScope(compiler.getRoot(), null);
    }

    private boolean isNodeAtCurrentLexicalScope(Node n) {
        Node parent = n.getParent();
        Preconditions.checkState((parent.isBlock() || parent.isFor() || parent.isForOf() || parent.isScript() || parent.isLabel() ? 1 : 0) != 0);
        if (parent == this.scope.getRootNode() || parent.isScript() || parent.getParent().isCatch() && parent.getParent().getParent() == this.scope.getRootNode()) {
            return true;
        }
        while (parent.isLabel()) {
            if (parent.getParent() == this.scope.getRootNode()) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    @Override
    public boolean hasBlockScope() {
        return true;
    }

    private static class DefaultRedeclarationHandler
    implements RedeclarationHandler {
        private DefaultRedeclarationHandler() {
        }

        @Override
        public void onRedeclaration(Scope s, String name, Node n, CompilerInput input) {
        }
    }

    static interface RedeclarationHandler {
        public void onRedeclaration(Scope var1, String var2, Node var3, CompilerInput var4);
    }
}

