/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.TypeValidator;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.StaticSourceFile;

class CheckAccessControls
implements NodeTraversal.ScopedCallback,
HotSwapCompilerPass {
    static final DiagnosticType DEPRECATED_NAME = DiagnosticType.disabled("JSC_DEPRECATED_VAR", "Variable {0} has been deprecated.");
    static final DiagnosticType DEPRECATED_NAME_REASON = DiagnosticType.disabled("JSC_DEPRECATED_VAR_REASON", "Variable {0} has been deprecated: {1}");
    static final DiagnosticType DEPRECATED_PROP = DiagnosticType.disabled("JSC_DEPRECATED_PROP", "Property {0} of type {1} has been deprecated.");
    static final DiagnosticType DEPRECATED_PROP_REASON = DiagnosticType.disabled("JSC_DEPRECATED_PROP_REASON", "Property {0} of type {1} has been deprecated: {2}");
    static final DiagnosticType DEPRECATED_CLASS = DiagnosticType.disabled("JSC_DEPRECATED_CLASS", "Class {0} has been deprecated.");
    static final DiagnosticType DEPRECATED_CLASS_REASON = DiagnosticType.disabled("JSC_DEPRECATED_CLASS_REASON", "Class {0} has been deprecated: {1}");
    static final DiagnosticType BAD_PACKAGE_PROPERTY_ACCESS = DiagnosticType.error("JSC_BAD_PACKAGE_PROPERTY_ACCESS", "Access to package-private property {0} of {1} not allowed here.");
    static final DiagnosticType BAD_PRIVATE_GLOBAL_ACCESS = DiagnosticType.warning("JSC_BAD_PRIVATE_GLOBAL_ACCESS", "Access to private variable {0} not allowed outside file {1}.");
    static final DiagnosticType BAD_PRIVATE_PROPERTY_ACCESS = DiagnosticType.warning("JSC_BAD_PRIVATE_PROPERTY_ACCESS", "Access to private property {0} of {1} not allowed here.");
    static final DiagnosticType BAD_PROTECTED_PROPERTY_ACCESS = DiagnosticType.warning("JSC_BAD_PROTECTED_PROPERTY_ACCESS", "Access to protected property {0} of {1} not allowed here.");
    static final DiagnosticType PRIVATE_OVERRIDE = DiagnosticType.warning("JSC_PRIVATE_OVERRIDE", "Overriding private property of {0}.");
    static final DiagnosticType EXTEND_FINAL_CLASS = DiagnosticType.error("JSC_EXTEND_FINAL_CLASS", "{0} is not allowed to extend final class {1}.");
    static final DiagnosticType VISIBILITY_MISMATCH = DiagnosticType.warning("JSC_VISIBILITY_MISMATCH", "Overriding {0} property of {1} with {2} property.");
    static final DiagnosticType CONST_PROPERTY_REASSIGNED_VALUE = DiagnosticType.warning("JSC_CONSTANT_PROPERTY_REASSIGNED_VALUE", "constant property {0} assigned a value more than once");
    static final DiagnosticType CONST_PROPERTY_DELETED = DiagnosticType.warning("JSC_CONSTANT_PROPERTY_DELETED", "constant property {0} cannot be deleted");
    static final DiagnosticType CONVENTION_MISMATCH = DiagnosticType.warning("JSC_CONVENTION_MISMATCH", "Declared access conflicts with access convention.");
    private final AbstractCompiler compiler;
    private final TypeValidator validator;
    private final boolean enforceCodingConventions;
    private int deprecatedDepth = 0;
    private int methodDepth = 0;
    private JSType currentClass = null;
    private final Multimap<JSType, String> initializedConstantProperties;

    CheckAccessControls(AbstractCompiler compiler, boolean enforceCodingConventions) {
        this.compiler = compiler;
        this.validator = compiler.getTypeValidator();
        this.initializedConstantProperties = HashMultimap.create();
        this.enforceCodingConventions = enforceCodingConventions;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, externs, this);
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverse(this.compiler, scriptRoot, this);
    }

    @Override
    public void enterScope(NodeTraversal t) {
        if (!t.inGlobalScope()) {
            Node n = t.getScopeRoot();
            Node parent = n.getParent();
            if (CheckAccessControls.isDeprecatedFunction(n)) {
                ++this.deprecatedDepth;
            }
            if (this.methodDepth == 0) {
                this.currentClass = this.getClassOfMethod(n, parent);
            }
            ++this.methodDepth;
        }
    }

    @Override
    public void exitScope(NodeTraversal t) {
        if (!t.inGlobalScope()) {
            Node n = t.getScopeRoot();
            if (CheckAccessControls.isDeprecatedFunction(n)) {
                --this.deprecatedDepth;
            }
            --this.methodDepth;
            if (this.methodDepth == 0) {
                this.currentClass = null;
            }
        }
    }

    private JSType getClassOfMethod(Node n, Node parent) {
        if (parent.isAssign()) {
            Node lValue = parent.getFirstChild();
            if (NodeUtil.isGet(lValue)) {
                JSType lValueType = lValue.getJSType();
                if (lValueType != null && lValueType.isNominalConstructor()) {
                    return lValueType.toMaybeFunctionType().getInstanceType();
                }
                return CheckAccessControls.normalizeClassType(lValue.getFirstChild().getJSType());
            }
            return CheckAccessControls.normalizeClassType(lValue.getJSType());
        }
        if (NodeUtil.isFunctionDeclaration(n) || parent.isName()) {
            return CheckAccessControls.normalizeClassType(n.getJSType());
        }
        if (parent.isStringKey() || parent.isGetterDef() || parent.isSetterDef()) {
            Node objectLitParent = parent.getParent().getParent();
            if (!objectLitParent.isAssign()) {
                return null;
            }
            Node className = NodeUtil.getPrototypeClassName(objectLitParent.getFirstChild());
            if (className != null) {
                return CheckAccessControls.normalizeClassType(className.getJSType());
            }
        }
        return null;
    }

    private static JSType normalizeClassType(JSType type) {
        FunctionType owner;
        if (type == null || type.isUnknownType()) {
            return type;
        }
        if (type.isNominalConstructor()) {
            return type.toMaybeFunctionType().getInstanceType();
        }
        if (type.isFunctionPrototypeType() && (owner = ((ObjectType)type).getOwnerFunction()).isConstructor()) {
            return owner.getInstanceType();
        }
        return type;
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getType()) {
            case 38: {
                this.checkNameDeprecation(t, n, parent);
                this.checkNameVisibility(t, n, parent);
                break;
            }
            case 33: {
                this.checkPropertyDeprecation(t, n, parent);
                this.checkPropertyVisibility(t, n, parent);
                this.checkConstantProperty(t, n);
                break;
            }
            case 147: 
            case 148: 
            case 154: {
                this.checkKeyVisibilityConvention(t, n, parent);
                break;
            }
            case 30: {
                this.checkConstructorDeprecation(t, n, parent);
                break;
            }
            case 105: {
                this.checkFinalClassOverrides(t, n, parent);
            }
        }
    }

    private void checkConstructorDeprecation(NodeTraversal t, Node n, Node parent) {
        String deprecationInfo;
        JSType type = n.getJSType();
        if (type != null && (deprecationInfo = CheckAccessControls.getTypeDeprecationInfo(type)) != null && this.shouldEmitDeprecationWarning(t, n, parent)) {
            if (!deprecationInfo.isEmpty()) {
                this.compiler.report(t.makeError(n, DEPRECATED_CLASS_REASON, type.toString(), deprecationInfo));
            } else {
                this.compiler.report(t.makeError(n, DEPRECATED_CLASS, type.toString()));
            }
        }
    }

    private void checkNameDeprecation(NodeTraversal t, Node n, Node parent) {
        JSDocInfo docInfo;
        if (parent.isFunction() || parent.isVar() || parent.isNew()) {
            return;
        }
        Scope.Var var = t.getScope().getVar(n.getString());
        JSDocInfo jSDocInfo = docInfo = var == null ? null : var.getJSDocInfo();
        if (docInfo != null && docInfo.isDeprecated() && this.shouldEmitDeprecationWarning(t, n, parent)) {
            if (docInfo.getDeprecationReason() != null) {
                this.compiler.report(t.makeError(n, DEPRECATED_NAME_REASON, n.getString(), docInfo.getDeprecationReason()));
            } else {
                this.compiler.report(t.makeError(n, DEPRECATED_NAME, n.getString()));
            }
        }
    }

    private void checkPropertyDeprecation(NodeTraversal t, Node n, Node parent) {
        String deprecationInfo;
        if (parent.isNew()) {
            return;
        }
        ObjectType objectType = ObjectType.cast(CheckAccessControls.dereference(n.getFirstChild().getJSType()));
        String propertyName = n.getLastChild().getString();
        if (objectType != null && (deprecationInfo = CheckAccessControls.getPropertyDeprecationInfo(objectType, propertyName)) != null && this.shouldEmitDeprecationWarning(t, n, parent)) {
            if (!deprecationInfo.isEmpty()) {
                this.compiler.report(t.makeError(n, DEPRECATED_PROP_REASON, propertyName, this.validator.getReadableJSTypeName(n.getFirstChild(), true), deprecationInfo));
            } else {
                this.compiler.report(t.makeError(n, DEPRECATED_PROP, propertyName, this.validator.getReadableJSTypeName(n.getFirstChild(), true)));
            }
        }
    }

    private boolean isPrivateByConvention(String name) {
        return this.enforceCodingConventions && this.compiler.getCodingConvention().isPrivate(name);
    }

    private void checkKeyVisibilityConvention(NodeTraversal t, Node key, Node parent) {
        JSDocInfo info = key.getJSDocInfo();
        if (info == null) {
            return;
        }
        if (!this.isPrivateByConvention(key.getString())) {
            return;
        }
        Node assign = parent.getParent();
        if (assign == null || !assign.isAssign()) {
            return;
        }
        Node left = assign.getFirstChild();
        if (!left.isGetProp() || !left.getLastChild().getString().equals("prototype")) {
            return;
        }
        JSDocInfo.Visibility declaredVisibility = info.getVisibility();
        if (declaredVisibility != JSDocInfo.Visibility.INHERITED && declaredVisibility != JSDocInfo.Visibility.PRIVATE) {
            this.compiler.report(t.makeError(key, CONVENTION_MISMATCH, new String[0]));
        }
    }

    private void checkNameVisibility(NodeTraversal t, Node name, Node parent) {
        Scope.Var var = t.getScope().getVar(name.getString());
        if (var != null) {
            JSDocInfo.Visibility visibility;
            boolean isPrivateByConvention;
            StaticSourceFile varSrc = var.getSourceFile();
            boolean isPrivate = isPrivateByConvention = this.isPrivateByConvention(name.getString());
            JSDocInfo docInfo = var.getJSDocInfo();
            if (docInfo != null && (visibility = docInfo.getVisibility()) != JSDocInfo.Visibility.INHERITED) {
                boolean bl = isPrivate = visibility == JSDocInfo.Visibility.PRIVATE;
                if (isPrivateByConvention && !isPrivate) {
                    this.compiler.report(t.makeError(name, CONVENTION_MISMATCH, new String[0]));
                    return;
                }
                if (visibility == JSDocInfo.Visibility.PACKAGE && !this.isPackageAccessAllowed(var, name)) {
                    this.compiler.report(t.makeError(name, BAD_PACKAGE_PROPERTY_ACCESS, name.getString(), varSrc.getName()));
                }
            }
            if (isPrivate && !this.isPrivateAccessAllowed(var, name, parent)) {
                this.compiler.report(t.makeError(name, BAD_PRIVATE_GLOBAL_ACCESS, name.getString(), varSrc.getName()));
            }
        }
    }

    private boolean isPrivateAccessAllowed(Scope.Var var, Node name, Node parent) {
        StaticSourceFile varSrc = var.getSourceFile();
        StaticSourceFile refSrc = name.getStaticSourceFile();
        JSDocInfo docInfo = var.getJSDocInfo();
        if (varSrc != null && refSrc != null && !varSrc.getName().equals(refSrc.getName())) {
            return docInfo != null && docInfo.isConstructor() && CheckAccessControls.isValidPrivateConstructorAccess(parent);
        }
        return true;
    }

    private boolean isPackageAccessAllowed(Scope.Var var, Node name) {
        StaticSourceFile varSrc = var.getSourceFile();
        StaticSourceFile refSrc = name.getStaticSourceFile();
        CodingConvention codingConvention = this.compiler.getCodingConvention();
        if (varSrc != null && refSrc != null) {
            String srcPackage = codingConvention.getPackageName(varSrc);
            String refPackage = codingConvention.getPackageName(refSrc);
            return srcPackage != null && refPackage != null && srcPackage.equals(refPackage);
        }
        return false;
    }

    private void checkFinalClassOverrides(NodeTraversal t, Node fn, Node parent) {
        JSType finalParentClass;
        FunctionType type = fn.getJSType().toMaybeFunctionType();
        if (type != null && ((JSType)type).isConstructor() && (finalParentClass = CheckAccessControls.getFinalParentClass(this.getClassOfMethod(fn, parent))) != null) {
            this.compiler.report(t.makeError(fn, EXTEND_FINAL_CLASS, ((JSType)type).getDisplayName(), finalParentClass.getDisplayName()));
        }
    }

    private void checkConstantProperty(NodeTraversal t, Node getprop) {
        String propertyName;
        Node parent = getprop.getParent();
        boolean isDelete = parent.isDelProp();
        if (!(NodeUtil.isAssignmentOp(parent) && parent.getFirstChild() == getprop || parent.isInc() || parent.isDec() || isDelete)) {
            return;
        }
        ObjectType objectType = ObjectType.cast(CheckAccessControls.dereference(getprop.getFirstChild().getJSType()));
        boolean isConstant = this.isPropertyDeclaredConstant(objectType, propertyName = getprop.getLastChild().getString());
        if (isConstant) {
            ObjectType prototype;
            if (isDelete) {
                this.compiler.report(t.makeError(getprop, CONST_PROPERTY_DELETED, propertyName));
                return;
            }
            if (objectType == null || objectType.isFunctionType() && !objectType.toMaybeFunctionType().isConstructor()) {
                return;
            }
            for (ObjectType oType = objectType; oType != null; oType = oType.getImplicitPrototype()) {
                if (!this.initializedConstantProperties.containsEntry((Object)oType, (Object)propertyName)) continue;
                this.compiler.report(t.makeError(getprop, CONST_PROPERTY_REASSIGNED_VALUE, propertyName));
                break;
            }
            this.initializedConstantProperties.put((Object)objectType, (Object)propertyName);
            if (objectType.isInstanceType() && (prototype = objectType.getImplicitPrototype()) != null && prototype.hasProperty(propertyName)) {
                this.initializedConstantProperties.put((Object)prototype, (Object)propertyName);
            }
        }
    }

    private void checkPropertyVisibility(NodeTraversal t, Node getprop, Node parent) {
        ObjectType referenceType;
        ObjectType objectType = referenceType = ObjectType.cast(CheckAccessControls.dereference(getprop.getFirstChild().getJSType()));
        String propertyName = getprop.getLastChild().getString();
        boolean isPrivateByConvention = this.isPrivateByConvention(propertyName);
        if (isPrivateByConvention) {
            JSDocInfo.Visibility declaredVisibility;
            JSDocInfo info = NodeUtil.getBestJSDocInfo(getprop);
            if ((parent.isAssign() || parent.isExprResult()) && parent.getFirstChild() == getprop && info != null && (declaredVisibility = info.getVisibility()) != JSDocInfo.Visibility.INHERITED && declaredVisibility != JSDocInfo.Visibility.PRIVATE) {
                this.compiler.report(t.makeError(getprop, CONVENTION_MISMATCH, new String[0]));
                return;
            }
        }
        StaticSourceFile definingSource = null;
        JSDocInfo.Visibility visibility = JSDocInfo.Visibility.INHERITED;
        boolean isClassType = false;
        if (isPrivateByConvention && objectType != null) {
            Node propDefNode = objectType.getPropertyNode(propertyName);
            if (propDefNode != null) {
                definingSource = propDefNode.getStaticSourceFile();
            } else {
                isPrivateByConvention = false;
            }
        }
        if (objectType != null) {
            StaticSourceFile referenceSource;
            boolean isOverride;
            boolean bl = isOverride = parent.getJSDocInfo() != null && parent.isAssign() && parent.getFirstChild() == getprop;
            if (isOverride) {
                objectType = objectType.getImplicitPrototype();
            }
            while (objectType != null) {
                JSDocInfo docInfo = objectType.getOwnPropertyJSDocInfo(propertyName);
                if (docInfo != null && docInfo.getVisibility() != JSDocInfo.Visibility.INHERITED) {
                    definingSource = docInfo.getStaticSourceFile();
                    visibility = docInfo.getVisibility();
                    isClassType = docInfo.isConstructor();
                    break;
                }
                objectType = objectType.getImplicitPrototype();
            }
            if (objectType == null) {
                if (isPrivateByConvention && visibility == JSDocInfo.Visibility.INHERITED && referenceType != null) {
                    objectType = referenceType;
                    visibility = JSDocInfo.Visibility.PRIVATE;
                } else {
                    return;
                }
            }
            boolean sameInput = (referenceSource = getprop.getStaticSourceFile()) != null && referenceSource.getName().equals(definingSource.getName());
            JSType ownerType = CheckAccessControls.normalizeClassType(objectType);
            if (isOverride) {
                JSDocInfo.Visibility overridingVisibility;
                JSDocInfo overridingInfo = parent.getJSDocInfo();
                JSDocInfo.Visibility visibility2 = overridingVisibility = overridingInfo == null ? JSDocInfo.Visibility.INHERITED : overridingInfo.getVisibility();
                if (visibility == JSDocInfo.Visibility.PRIVATE && !sameInput) {
                    this.compiler.report(t.makeError(getprop, PRIVATE_OVERRIDE, objectType.toString()));
                } else if (overridingVisibility != JSDocInfo.Visibility.INHERITED && overridingVisibility != visibility) {
                    this.compiler.report(t.makeError(getprop, VISIBILITY_MISMATCH, visibility.name(), objectType.toString(), overridingVisibility.name()));
                }
            } else {
                if (sameInput) {
                    return;
                }
                if (!(visibility != JSDocInfo.Visibility.PRIVATE || this.currentClass != null && ownerType.isEquivalentTo(this.currentClass))) {
                    if (isClassType && CheckAccessControls.isValidPrivateConstructorAccess(parent)) {
                        return;
                    }
                    JSType accessedType = getprop.getFirstChild().getJSType();
                    String readableTypeName = ownerType.equals(accessedType) ? this.validator.getReadableJSTypeName(getprop.getFirstChild(), true) : ownerType.toString();
                    this.compiler.report(t.makeError(getprop, BAD_PRIVATE_PROPERTY_ACCESS, propertyName, readableTypeName));
                } else if (visibility == JSDocInfo.Visibility.PROTECTED) {
                    if (this.currentClass == null || !this.currentClass.isSubtype(ownerType)) {
                        this.compiler.report(t.makeError(getprop, BAD_PROTECTED_PROPERTY_ACCESS, propertyName, this.validator.getReadableJSTypeName(getprop.getFirstChild(), true)));
                    }
                } else if (visibility == JSDocInfo.Visibility.PACKAGE) {
                    CodingConvention codingConvention = this.compiler.getCodingConvention();
                    String refPackage = codingConvention.getPackageName(referenceSource);
                    String defPackage = codingConvention.getPackageName(definingSource);
                    if (refPackage == null || defPackage == null || !refPackage.equals(defPackage)) {
                        this.compiler.report(t.makeError(getprop, BAD_PACKAGE_PROPERTY_ACCESS, propertyName, this.validator.getReadableJSTypeName(getprop.getFirstChild(), true)));
                    }
                }
            }
        }
    }

    private static boolean isValidPrivateConstructorAccess(Node parent) {
        return !parent.isNew();
    }

    private boolean shouldEmitDeprecationWarning(NodeTraversal t, Node n, Node parent) {
        if (!(!t.inGlobalScope() || parent.isCall() && parent.getFirstChild() == n || n.isNew())) {
            return false;
        }
        if (n.isGetProp() && n == parent.getFirstChild() && NodeUtil.isAssignmentOp(parent)) {
            return false;
        }
        if (n.isGetProp() && parent.isExprResult() && n.getJSDocInfo().isDeprecated()) {
            return false;
        }
        return !this.canAccessDeprecatedTypes(t);
    }

    private boolean canAccessDeprecatedTypes(NodeTraversal t) {
        Node scopeRoot = t.getScopeRoot();
        Node scopeRootParent = scopeRoot.getParent();
        return this.deprecatedDepth > 0 || CheckAccessControls.getTypeDeprecationInfo(t.getScope().getTypeOfThis()) != null || scopeRootParent != null && scopeRootParent.isAssign() && CheckAccessControls.getTypeDeprecationInfo(this.getClassOfMethod(scopeRoot, scopeRootParent)) != null;
    }

    private static boolean isDeprecatedFunction(Node n) {
        JSType type;
        if (n.isFunction() && (type = n.getJSType()) != null) {
            return CheckAccessControls.getTypeDeprecationInfo(type) != null;
        }
        return false;
    }

    private static String getTypeDeprecationInfo(JSType type) {
        ObjectType implicitProto;
        if (type == null) {
            return null;
        }
        JSDocInfo info = type.getJSDocInfo();
        if (info != null && info.isDeprecated()) {
            if (info.getDeprecationReason() != null) {
                return info.getDeprecationReason();
            }
            return "";
        }
        ObjectType objType = ObjectType.cast(type);
        if (objType != null && (implicitProto = objType.getImplicitPrototype()) != null) {
            return CheckAccessControls.getTypeDeprecationInfo(implicitProto);
        }
        return null;
    }

    private boolean isPropertyDeclaredConstant(ObjectType objectType, String prop) {
        if (this.enforceCodingConventions && this.compiler.getCodingConvention().isConstant(prop)) {
            return true;
        }
        while (objectType != null) {
            JSDocInfo docInfo = objectType.getOwnPropertyJSDocInfo(prop);
            if (docInfo != null && docInfo.isConstant()) {
                return true;
            }
            objectType = objectType.getImplicitPrototype();
        }
        return false;
    }

    private static String getPropertyDeprecationInfo(ObjectType type, String prop) {
        JSDocInfo info = type.getOwnPropertyJSDocInfo(prop);
        if (info != null && info.isDeprecated()) {
            if (info.getDeprecationReason() != null) {
                return info.getDeprecationReason();
            }
            return "";
        }
        ObjectType implicitProto = type.getImplicitPrototype();
        if (implicitProto != null) {
            return CheckAccessControls.getPropertyDeprecationInfo(implicitProto, prop);
        }
        return null;
    }

    private static JSType dereference(JSType type) {
        return type == null ? null : type.dereference();
    }

    private static JSType getFinalParentClass(JSType type) {
        if (type != null) {
            ObjectType iproto;
            for (iproto = ObjectType.cast(type).getImplicitPrototype(); iproto != null && iproto.getConstructor() == null; iproto = iproto.getImplicitPrototype()) {
            }
            if (iproto != null) {
                JSDocInfo jsDoc;
                Node source = iproto.getConstructor().getSource();
                JSDocInfo jSDocInfo = jsDoc = source != null ? NodeUtil.getBestJSDocInfo(source) : null;
                if (jsDoc != null && jsDoc.isConstant()) {
                    return iproto;
                }
            }
        }
        return null;
    }
}

